/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-timing.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/*********************************************************************
*
* Name        : timing.c
*
* Version     : 1.1
*
* Description : Common Standard Portable Timing Routine.
*
* Modified by : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357

* Rev History : Originally developed by Bradford Nichols,
*               late modified to make it in function call form, 
                Sep 1990.
*                 
************************************************************************/


#include <sys/types.h>
#include <sys/stat.h>
#include "timing.h"

extern unsigned long time_diff;

begin_timing()

{


/*********************  START TIMING ***********************/
#ifdef GETTIMEOFDAY
  gettimeofday (&gtime_start, &gtzp);
#endif
#ifdef GETRUSAGE
  getrusage(RUSAGE_SELF, &rusage_start);
#endif
#ifdef FTIME
  ftime(&ftime_start);
#endif 
#ifdef TIME
  time(&time_start);
#endif
#ifdef TIMES
  times(&times_start);
#endif
#ifdef CLOCK
  clock_start = clock();
#endif
/***************************************************************/



}

end_timing()
{

/******** STOP TIMING, COMPUTE AND PRINT RESULT(S) ****************/
#ifdef GETTIMEOFDAY
  gettimeofday (&gtime_end, &gtzp);
  gtime_elapsed = 1000*(gtime_end.tv_sec - gtime_start.tv_sec)
            + (gtime_end.tv_usec - gtime_start.tv_usec)/1000;
  gtime_diff = gtime_elapsed;
  time_diff = gtime_diff;
  printf("gettimeofday results:\n");
  printf("  Elaped time = %d msec\n",gtime_diff);
#endif

#ifdef GETRUSAGE
  getrusage(RUSAGE_SELF, &rusage_end);
  rusage_utime = 1000*(rusage_end.ru_utime.tv_sec 
		 - rusage_start.ru_utime.tv_sec)
            + (rusage_end.ru_utime.tv_usec 
	       - rusage_start.ru_utime.tv_usec)/1000;
  rusage_udiff = rusage_utime;
  rusage_stime = 1000*(rusage_end.ru_stime.tv_sec 
		 - rusage_start.ru_stime.tv_sec)
            + (rusage_end.ru_stime.tv_usec 
	       - rusage_start.ru_stime.tv_usec)/1000;
  rusage_sdiff = rusage_stime;
  printf("getrusage results:\n");
  printf("  User time   = %d msec\n",rusage_udiff);
  printf("  System time = %d msec\n",rusage_sdiff);
  time_diff = rusage_udiff + rusage_sdiff;
#endif

#ifdef FTIME
  ftime(&ftime_end);
  ftime_sec1 = ftime_start.time;
  ftime_millisec1 = ftime_start.millitm;
  ftime_millisec1 += ftime_sec1*1000;
  ftime_sec2 = ftime_end.time;
  ftime_millisec2 = ftime_end.millitm;
  ftime_millisec2 += ftime_sec2*1000;
  ftime_diff += ftime_millisec2 - ftime_millisec1;
  time_diff = ftime_diff;
  printf("ftime results:\n");
  printf("  Elaped time = %d msec\n",ftime_diff);
#endif

#ifdef TIME
  time(&time_end);
  time_tdiff = time_end - time_start;
  printf("time results:\n");
  printf("  Elaped time = %d sec\n",time_diff);
#endif

#ifdef TIMES
  times(&times_end);
  times_utime = 1000*(times_end.tms_utime 
		 - times_start.tms_utime)/HZ;
  times_udiff = times_utime;
  times_stime = 1000*(times_end.tms_stime 
		 - times_start.tms_stime)/HZ;
  times_sdiff = times_stime;
  printf("times results:\n");
  printf("  User time   = %d msec\n",times_udiff);
  printf("  System time = %d msec\n",times_sdiff);
#endif

#ifdef CLOCK
  clock_end = clock();
  clock_diff = (clock_end - clock_start)/1000;
  printf("clock results:\n");
  printf("  CPU time    = %d msec\n",clock_diff);
#endif
/********************************************************/




}
