
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-server.c=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/

/*********************************************************************
*
* Name        : server.c   / * of sdbase * /
*
* Version     : $Revision: 1.0 $
*
* Description : Server process for the synthetic database - Sdbase
*
* Written by  : Aju John
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute (WPI)
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
************************************************************************/



/******************************************************************************
 *  This benchmark was originally  written using Mach ipc features, but
 *  later modified to have only SVID calls to make it highly portable. 
 *  Certain principles are taken with permission from 
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: dbmserv.c   SID: 2.4 1/17/90 15:52:05
 *          
 ******************************************************************************
 * Sdbase
 * ======
 * 
 * Multi-user database simulation benchmark
 * Uses the CLIENT - SERVER PARADIGM.
 * Services multiple clients concurrently
 */
/***************************   REVISION HISTORY ****************************
 *  $Log:	server.c,v $
 * Revision 1.1  91/02/17  18:04:42  aju
 * Beta version.
 ****************************************************************************/

/*
Inputs :  (command line arguments to this program)
========
First argument: the name of the database. This is generated by the program
                buildbms (see buildbms)

Example:  % server db.dat
 where db.dat is a flat database file of the format:
         
  IIIIINNNNNNNNNNNNNNNNNNNNAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAPPPPPPPPPP
  Where IIIII is the 5-digit id number (0-padded)
        NN... is the 20-character name
        AA... is the 40-character address
        PP... is the 10-character phone number
  Records are accessed by ID number (1 is the 0th record, 2 is 1st..etc.)



Outputs:
========

  Output is a table of statistics of service time for each type
  of request. Use the program serv_anl (server analyzer) to
  re-structure the output generated.

*/

static char rcsid[] = "$Id: server.c,v 1.1 91/02/17 18:04:42 aju Exp Locker: aju $";

#include <stdio.h>
#include <setjmp.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include "defines.h"


#ifdef SYSV_FOUR 
#include "sysv4.h"
#endif

#ifdef VERBOSE
#define DEBUG  /* remove after debugging */
#endif

#define ERROR (-1)
#define QERR 1

#define SEEK_SET 0
#define SEEK_END 2

#define RMODE 0644
#define WMODE 0666

#define TRUE 1
#define FALSE 0

#define MYPORT		3278
#define BUFSIZE		512
#define MAXNAME         30

#define START 0
#define STOP 1
/*
** Record definitions.
*/

#define IDLEN 5
#define NAMELEN 20
#define ADDRLEN 40
#define PHONLEN 10
#define RECLEN  75	/* Sum of the above. */


/*
** Message types.
*/

#define READREQ	1		/* Read a record */
#define WRITEREQ 2		/* Write a record */
#define ADDREQ 3		/* Add a new record */
#define GETLREQ 4		/* Get largest record number */
#define DIEREQ 99		/* Orders server to terminate. */

/*
** Return codes.
*/

#define AOK 1			/* Request met ok */
#define DERR_RNF 2		/* Record not found */
#define DERR_RAE 3		/* Record already exists */
#define DERR_WRD 4		/* Unexplainable error */
#define DERR_UNK 9		/* Unknown request type */
/*
** Structures.
*/

#define	MAXDATA	20

/*  simple message structure */


char time_stamp[10];

typedef struct {
	int request;		/* Request type and response code */
	char recdat[RECLEN+11];	/* DBMS record data */
} msgdata;

typedef struct {
	long type;		/* Holds caller's pid */
	msgdata data;		/* Pointer to request and data */
} amess;


/*
** Structure instances.
*/
amess hisreq;
amess myresp;

FILE *dbfp;			/* Pointer for database file */
jmp_buf myjump;			/* Jump buffer for signals */


static unsigned long 
  rd_cnt, 		/* read request counter */
  wr_cnt,		/* write request counter */
  ad_cnt,		/* add request counter */
  gt_cnt,		/* get request counter */
  rs_cnt;		/* result request counter */

unsigned long errcnt;		/* Total error count */

unsigned long time_diff;
unsigned long total_tasks;	/* Total number of tasks logged in */
unsigned long server_time;
unsigned long init_time;
unsigned long getlen_time;
unsigned long read_time;
unsigned long write_time;
unsigned long append_time;

unsigned long    rd_blkd, wr_blkd, ap_blkd, gt_blkd;

extern int errno;
static  int capt_sig();
int     process;

char homedir[100];

/************************ main.c ********************************************/

main(argc,argv)
int argc;
char *argv[];


{


  int	  my_port;
  int	  tmpsock, sock, len, childpid;
  struct  sockaddr_in	host_addr;
  char    bu[20], *getwd();
  FILE    *fopen(), *fd;
  int     blocksize = BUFSIZE;
  int     no_of_clients;
  char    task_buf[3], test_file[6];
  int     i,status;
  long    real_time;

  /* initializing data */

  server_time = 0;
  init_time = 0;
  getlen_time = 0;
  read_time = 0;
  write_time = 0;
  append_time = 0;
  rd_blkd = wr_blkd = ap_blkd = gt_blkd = 0;


  /* checks to see if the command line parameters are okay */

  
  if(argc<2)
    {
      fprintf(stderr,"usage: %s dbasefile \n",argv[0]);
      exit(1);
    }
  printf("Server started..\n");
  

  /* opening the database file ( initializing timer started)*/
  
  begin_timing();
  
  if((dbfp=fopen(argv[1],"r+"))==(FILE *)NULL)
    {
      fprintf(stderr,"**Open error on: %s\n",argv[1]);
      exit(1);
    }
  
  fscanf ( dbfp, "%5s", test_file);
  if( (strncmp (test_file,"00001",5) !=0) &&
     (strncmp  (test_file,"    1",5) !=0))
    {
      fprintf(stderr,"** Wrong database file: %s\n",argv[1]);
      exit(1);
    }
  else
    rewind (dbfp);

  /* ** Initialize  counters ** */

  errcnt=0L;
  total_tasks=0L;
  rd_cnt=0L;
  wr_cnt=0L;
  ad_cnt=0L;
  gt_cnt=0L;
  rs_cnt=0L;
  system("rm -f dbs_* *_#s *_#r *_#w _ap_lck.dbs");
#ifdef VERBOSE
	printf("Server calling servicer()\n");
#endif VERBOSE

  /* initializing the socket for communications */

  sock = initialize_server(&host_addr); /* create bind & listen */
  
  /* set all the signals to capture.*/
  setsignals();
  
  /* Build a longjump. */
  if(setjmp(myjump)!=0)
    return(0);
  

  /* All set to start receiving requests from clients */
  process = 0;
  tmpsock = accept_data(sock);
  /* receiving info on # of sub-clients from the master client */
  receive_data(tmpsock, task_buf);
  no_of_clients = task_buf[0];
  printf("NUMBER OF CLIENTS EXPECTED: %d\n", no_of_clients);
  end_timing();
  init_time = time_diff;
  
  /* start waiting for each of the expected clients */

  begin_timing();
  
  for  (i=0; i< no_of_clients; i++ )
    {
      
      tmpsock = accept_data(sock);
      if ( ( childpid = vfork()) < 0)
	{
	  bailout("Server:fork error");
	  exit(-1); 
	}
      /* fork  a new process for each sub-client */
      else if (childpid == 0)
	{
	  close(sock);  
	  process_client_request( tmpsock, i );
	  _exit(0);
	}
#ifdef FORK
      printf("[%d]   %d\n", i+1, childpid);
#endif
    }
  
  printf("NOTE: Server subprocesses executing in background\n");


  /* wait for every sub-client to terminate */
	for (i = 1; i <= no_of_clients; i += 1) 
	  {
	    wait(&status);
	  }
  end_timing();
  real_time = time_diff;
  printf("Total Server (REAL) Time: %d msec\n", real_time );
  serv_anl(no_of_clients);
  return;


}


/**************************** doread *********************
 ** Perform a read request.
 *********************************************************/


#include <sys/file.h>

doread(idnum,buff)
char idnum[IDLEN+1];
char buff[RECLEN];
{

 	long offset;
	char lockname[IDLEN+5], sema_lock[IDLEN+5];
	int ret, sema_ret, failed, one, value;
	FILE *rd_lock;
	unsigned long bg_time, end_time;
	unsigned long local_timing();
	/*
	** Calculate offset.
	*/
	bg_time = end_time = 0L;
	idnum[IDLEN]='\0';
	offset=(atol(idnum)-1)*(long)RECLEN;
	if(offset<0L) return(DERR_RNF);		/* Illegal offset */
#ifdef DEBUG
	printf("Random record number is:%s, offset %d\n", idnum, offset);
#endif
	bg_time = local_timing();
	strcpy(lockname,idnum);
	strcpy(sema_lock,idnum);
	strcat(lockname, "_#w");
	strcat(sema_lock, "_#s");

	ret = ERROR;


	while ( ret < 0)
	  {
	    ret = open(lockname, O_CREAT | O_EXCL);
#ifdef VERBOSE
	if( ret < 0)
	    printf("Blocked by spinlocks..[read:_w]\n");
#endif
	  }

/* Thanks to Paul Dale  of OSF for this simple locking idea */	     

	rd_lock = NULL;
	close(ret);
	unlink(lockname);
        strcpy(lockname,idnum);
        strcat(lockname, "_#r");
	rd_lock = fopen(lockname, "r");
	if (rd_lock == NULL) /* no one else is reading */
	  {
	     rd_lock = fopen(lockname, "w+");
	     one = 1;
	     fprintf( rd_lock, "%d" ,one );
	     fclose (rd_lock);
	   }
	else /* some one is reading already */
	  {

	    fclose (rd_lock);
	    sema_ret = -1;
	    while(sema_ret == -1)
	      {
		sema_ret = open(sema_lock, O_CREAT | O_EXCL);
/* #ifdef VERBOSE */
		if( ret < 0)
		  printf("Blocked by spinlocks..[read:_w]\n");
/* #endif */
	      }			

	    close(sema_ret);

            rd_lock =  fopen(lockname, "r+");
	    if (rd_lock == NULL )
		printf ("******** ERROR IN READ LOCK ********\n");
	    fscanf( rd_lock, "%d", &value);
	    value ++;
	    rewind( rd_lock);
	    fprintf ( rd_lock, "%d", value);
	    fclose(rd_lock);
	    unlink (sema_lock);
	  }
	end_time = local_timing();
	rd_blkd += (end_time - bg_time);

	failed = FALSE;

	if( (fseek(dbfp,offset,SEEK_SET)!=0) ||
	    (fread(buff,RECLEN,1,dbfp)!=1) )
	  {
	    failed = TRUE;
	  }

	sema_ret = -1;
	bg_time = local_timing();
	while(sema_ret == -1)
	  {
	    sema_ret = open(sema_lock, O_CREAT | O_EXCL);
/* #ifdef VERBOSE */
	    if( ret < 0)
	      printf("Blocked by spinlocks..[read:_w]\n");
/* #endif */
	  }
	close(sema_ret);

	rd_lock =  fopen(lockname, "r+");
	fscanf (rd_lock, "%d", &value);
	if (value == 1)
	  {
	    fclose(rd_lock);
	    unlink(lockname);
	  }
	else
	  {
	    value--;
	    rewind(rd_lock);
	    fprintf ( rd_lock, "%d", value);
	    fclose(rd_lock);
	  }
	unlink (sema_lock);
	end_time = local_timing();
        rd_blkd += (end_time - bg_time);


	if ( failed)
	  return(DERR_RNF);			/* Seek or read failed */
	else
	  return(AOK);				/* No problems */
}

/**************************** dowrite *********************
** Perform a write request.
*************************************************************/
dowrite(buff)
char buff[RECLEN];
{
	char idnum[IDLEN+1];
	long offset;
        char lockname_r[IDLEN+5];
        char lockname_w[IDLEN+5];
	int ret_r , ret_w;
	unsigned long end_time , bg_time;
        unsigned long local_time();



	strncpy(idnum,buff,5);			/* Get id number */

	/*
	** Calculate offset.
	*/
	bg_time = end_time = 0L;
	idnum[IDLEN]='\0';
	offset=(atol(idnum)-1)*(long)RECLEN;
	if(offset<0L) return(DERR_RNF);		/* Illegal offset */
#ifdef DEBUG	
	printf("Writing %s\n", buff);
#endif

	bg_time = local_timing();

        strcpy(lockname_w,idnum);
        strcpy(lockname_r,idnum);
	strcat(lockname_w, "_#w");

        ret_w = -1;
        while ( ret_w < 0)
          {
	    /* first capture the write lock */
            ret_w = open(lockname_w, O_CREAT | O_EXCL);
#ifdef VERBOSE
	    if (ret_w < 0)
	      printf("Blocked by spinlocks..write:1\n");
#endif
	  }

	    close(ret_w);
	    strcat(lockname_r, "_#r");
	    ret_r = -1;
	    while( ret_r < 0)
	      {
		ret_r = open(lockname_r, O_CREAT | O_EXCL);
#ifdef VERBOSE
		if (ret_r < 0)
		  printf("Blocked by spinlocks..write:2\n");
#endif VERBOSE
	      }
	    close(ret_r);
	    unlink(lockname_r);

	if((fseek(dbfp,offset,SEEK_SET)!=0) ||
		(fwrite(buff,RECLEN,1,dbfp)!=1))
	  {
	    unlink(lockname_w);
	    return(DERR_RNF);
	  }
	unlink(lockname_w);
	end_time = local_timing();
	wr_blkd += (end_time - bg_time);
	return(AOK);
      }

/**************************** doadd *********************
** Perform an add request.
*************************************************************/
doadd(buff)
char buff[RECLEN];
{
        char lockname[12];
	long offset;
	unsigned long end_time , bg_time;
        unsigned long local_time();
        int ret, rt_error;


	bg_time = end_time = 0L;

        ret = -1;
	bg_time = local_timing();

        strcpy(lockname,"_ap_lck.dbs");

        while ( ret < 0)
          {
            ret = open(lockname, O_CREAT | O_EXCL);
#ifdef VERBOSE
	    if ( ret < 0)
	      printf("Blocked by spinlocks..\n");
#endif VERBOSE
          }
	close(ret);
	rt_error = 0;
	end_time = local_timing();
	ap_blkd += (end_time - bg_time);
	/* Seek to the end of the file. */
	if(fseek(dbfp,0L,SEEK_END)!=0)
	  {
	    rt_error = 1;
	    /* 	 Huh? */
	  }


	/* Get offset -- we presume caller has proper id set */
	offset=ftell(dbfp);
	if (fwrite(buff,RECLEN,1,dbfp)!=1)
	  {
	    rt_error = 2;
	    /*	 Failed write */
	  }
	bg_time = local_timing();
	unlink(lockname);
	end_time = local_timing();
	ap_blkd += (end_time - bg_time);
	switch (rt_error)
	  {
	  case 1:
	    {
	      return(DERR_WRD);
	      break;
	    }
	  case 2:
	    {
	      return(DERR_RNF);
	      break;
	    }
	  case 0:
	    {
	      return(AOK);
	      break;
	    }
	  }
}

/**************************** dotell *********************
** Perform a "tell" request.
** Returns highest current id number in file.
*************************************************************/
dotell(buff)
char buff[RECLEN];
{

  char lockname[12];
  long offset;
  int ret;
  unsigned long end_time , bg_time;
  unsigned long local_time();
  int rt_error;
  
  rt_error = 0;
  bg_time = end_time = 0L;
  strcpy(lockname,"_ap_lck.dbs");
  ret = -1;
  bg_time = local_timing();
  while ( ret < 0)
    {
      ret = open(lockname, O_CREAT | O_EXCL);
#ifdef VERBOSE
      if ( ret < 0)
	printf("Blocked by spinlocks..\n");
#endif VERBOSE
    }
  close(ret);
  end_time = local_timing();
  gt_blkd += (end_time - bg_time);
  /* Seek to the end of the file. */
  if(fseek(dbfp,0L,SEEK_END)!=0)
    {
        rt_error = 1;
    /*  DERR_WRD Huh? */
    }

  
  /* Get offset and calculate new id number */
  offset=ftell(dbfp);
  sprintf(buff,"%#05ld",(offset/(long)RECLEN));
  bg_time = local_timing();
  unlink(lockname);
  end_time = local_timing();
  gt_blkd += (end_time - bg_time);
  if (rt_error)
    return(DERR_WRD);
  else
    return(AOK); /* okay */
}

/**************************** setsignals *********************
** Set up all the signals we want to capture or ignore.
*************************************************************/
setsignals()
{
static int diehard();

	/*
	** Ignore hangup and interrupt.
	*/
	signal(SIGHUP, diehard);
	signal(SIGINT, diehard);

	/*
	** Capture the rest.
	***
	*/
	signal(SIGQUIT, capt_sig);
	signal(SIGILL, capt_sig);
	signal(SIGTRAP, capt_sig);
	signal(SIGIOT, capt_sig);
	signal(SIGEMT, capt_sig);
	signal(SIGFPE, capt_sig);
	signal(SIGBUS, capt_sig);
	signal(SIGSEGV, capt_sig);
	signal(SIGSYS, capt_sig);
	signal(SIGPIPE, capt_sig);
	signal(SIGALRM, capt_sig);
	signal(SIGTERM, capt_sig);
	signal(SIGUSR1, capt_sig);
	signal(SIGUSR2, capt_sig);

	return(0);
}

/********************** capt_sig ****************************
** Capture signals.
** This just performs the long jump and blasts us out.
*************************************************************/
static int capt_sig(sign)
int sign;
{
	longjmp(myjump,sign);
}

/*************************** diehard ************************
 for kills and other such interrupts: cleanup and exit
*************************************************************/
static int diehard()
{
cleanup();
exit(1);
}

/*************************** cleanup *************************/

cleanup()
{
	fclose(dbfp);			/* Close the database file. */
	printf ("Server shutdown complete.\n");
}

/**************************************************************/
/*********************** process client request****************/
/**************************************************************/

process_client_request( my_port, clientID)
     int my_port;
     int clientID;
{
  extern int process;
  char buf[RECLEN+10];
  int ret, cl_request;
  char server_response[RECLEN+10];
  char received_data[RECLEN+10];
  int  received_request;
  char return_data[RECLEN+10];
/* int service_router( int, char*, char*, int); */
  int ret_value;
/* receive request (read) */

  while(1)
    {
      receive_data(my_port, buf);
  
      received_request = buf[0];
      strcpy ( received_data, buf+1);
      ret_value = service_router( received_request, received_data,
				      server_response, clientID);
      if (ret_value == 2 ) break;
      /* send reply (write) */
      send_data(my_port, server_response, sizeof(server_response));


    }
  return;
}

/**************************************************************/
/********************service router****************************/
/**************************************************************/


service_router(client_request , client_data, server_reply, clientID)
int client_request;
char *client_data;
char *server_reply;
int clientID;
{
  int	ret;
  int		i;
  int             reply_size;
  int             filler;
  FILE            *fp;
  char idnum[IDLEN+1];
  char buff[RECLEN+1];
  char return_buff[RECLEN+10];
  int rcod;
  char            c[5];
  char            disk[30];
  long            ret_time;

  buff[RECLEN]=buff[RECLEN+1]=0;

#ifdef VERBOSE
  printf("Client_data is %s\n",client_data);
#endif VERBOSE



  switch(client_request)
		{

		/*
		** Read operation.
		*/
		case READREQ:
		  timing(START);
#ifdef VERBOSE		  
		  printf("SERVER: It is a READ request\n");
#endif
		  ++rd_cnt;
#ifdef VERBOSE		  
		  printf("Read count is %d \n" , rd_cnt);
#endif
		  strncpy(idnum,client_data,5);
#ifdef DEBUG
		  printf("Rec to be read:%s\n",idnum);
#endif DEBUG

		  rcod=doread(idnum,buff);

		  buff[RECLEN]=0;
		  ret_time = timing(STOP);
		  if(rcod==AOK)
		    strcpy(myresp.data.recdat,buff);

#ifdef VERBOSE
		  printf("RECORD:%s\n",myresp.data.recdat);
#endif
		  myresp.data.request=rcod;
		  ret_time = timing(STOP);
		  sprintf (time_stamp, "%ld:" , ret_time);
		  strcpy(return_buff, time_stamp);
		  strcat(return_buff, myresp.data.recdat);
#ifdef DEBUG
		  printf("returning response\n");
#endif

		  read_time += ret_time;
		  strcpy(server_reply, return_buff);
		  return(1);



		/*
		** Write operation.
		*/

		case WRITEREQ:
		  timing(START);
#ifdef VERBOSE
		  printf( "SERVER:It is a WRITE request\n");
#endif
		  ++wr_cnt;
#ifdef VERBOSE
		  printf("Write count is %d \n", wr_cnt);
#endif
		  strcpy(hisreq.data.recdat,client_data);
#ifdef VERBOSE
		  printf("To write:%s\n",hisreq.data.recdat);
		  printf("To write:%s\n",client_data);
#endif
		  myresp.data.request=(long)dowrite(hisreq.data.recdat);
		  myresp.type=hisreq.type;
		  strcpy(myresp.data.recdat, hisreq.data.recdat);
		  ret_time = timing(STOP);
		  sprintf (time_stamp, "%ld:" , ret_time);
		  strcpy(return_buff, time_stamp);
		  strcat(return_buff, myresp.data.recdat);
#ifdef DEBUG
		  printf("returning response\n");
#endif

		  
		  write_time += ret_time;
		  strcpy(server_reply, return_buff);
		  return(1);



		/*
		** Add operation.
		*/
		case ADDREQ:
#ifdef VERBOSE
		  printf("SERVER: it is a ADD request \n");
#endif
		  timing(START);
		  ++ad_cnt;
#ifdef VERBOSE
		  printf("Add count is %d \n", ad_cnt);
#endif
		  myresp.data.request=(long)doadd(client_data);
		  ret_time = timing(STOP);
		  
#ifdef VERBOSE
		  printf("To write:%s\n",client_data);
#endif
		  time_stamp[0] = 0;
		  sprintf (time_stamp, "%ld:" , ret_time);
		  strcpy(return_buff, time_stamp);
		  strcat(return_buff, client_data);
#ifdef DEBUG
		  printf("returning response\n");
#endif
		  append_time += ret_time;
		  strcpy(server_reply, return_buff);
		  return(1);



		/*
		** Get-last-record-in-file operation.
		*/
		case GETLREQ:
		  timing(START);
#ifdef VERBOSE
		  printf("SERVER: The request is : GETLREQ\n");
#endif
		  ++gt_cnt;
#ifdef VERBOSE
		  printf("Get count is %d \n", gt_cnt);
#endif
		  myresp.data.request=(long)dotell(myresp.data.recdat);
		  ret_time = timing(STOP);
		  sprintf (time_stamp, "%ld:" , ret_time);
		  strcpy(return_buff, time_stamp);
		  strcat(return_buff, myresp.data.recdat);
#ifdef DEBUG
		  printf("returning response\n");
#endif

#ifdef VERBOSE
		  printf("GETLREQ = %s\n", return_buff);
#endif
		  getlen_time += ret_time;
		  strcpy(server_reply, return_buff);
#ifdef VERBOSE
		  printf("GETLREQ = %s\n", server_reply);
#endif
		  return(1);


		/*
		** Server shutdown process initiated.
		*/

		case DIEREQ:
#ifdef VERBOSE
		  printf("SERVER: The request is DIEREQ\n");
#endif
		
		  strcpy(return_buff, "PTL:Shutdown ");

	/*
	 ** Output results.
	 */
		  strcpy(disk,"dbs_");
		  sprintf( c, "%d", clientID);
		  strcat(disk, c);

	fp = fopen ( disk, "a");
		  if (fp == NULL)
		    {
		      printf("Can't open %s\n", disk);
		    }
		  
	server_time = init_time + getlen_time +	read_time + write_time 
	  + append_time;

	fprintf(fp, " %d", server_time);
	fprintf( fp, " %d %d %d %d",
		rd_cnt, wr_cnt, ad_cnt, gt_cnt);
	fprintf( fp," %d %d %d %d %d %d %d %d",
		read_time, write_time, append_time, getlen_time,
		rd_blkd, wr_blkd, ap_blkd, gt_blkd);
#ifdef OUTPUT
	printf( "Total server time = %d milliseconds\n",server_time);
	wpi_banner("Synthetic Database: database server", "v1.0" );
	printf( "------------------------------------------------\n");
	printf( "\t read \t write \t append\t get_last_record \n");
	printf( "------------------------------------------------\n");
	printf( "Number of operations\n");
	printf( "\t %d \t %d \t %d \t %d \n",
		rd_cnt, wr_cnt, ad_cnt, gt_cnt);
	printf( "Total time for each  operation (Time in msecs)\n");
	printf( "\t %d \t %d \t %d \t %d \n",
		read_time, write_time, append_time, getlen_time);

	printf( "Average time for each  operation (Time in msecs)\n");
	printf( "\t %.2f \t %.2f \t %.2f \t %.2f \n",
               (float)read_time/(float)rd_cnt,
                (float)write_time/(float)wr_cnt,
                (float)append_time/(float)ad_cnt,
                (float)getlen_time/(float)gt_cnt);

	printf( "------------------------------------------------\n");
	printf( " %d errors\n", errcnt);
	printf( "Total server time = %d milliseconds\n",server_time);
#endif

#ifdef FORK

 	printf( "Service for client %d completed.\n", clientID+1);
	printf( "[%d]    Done\n", clientID+1);
#endif



		  
		  fclose(fp);
		  fflush(stdout);
		  return(2);	

		  
		/*
		**  What? Unknown service request. ALERT: Alien CLient
		*/
		default: /** This should never happen **/
		  printf("SERVER::Error:Request has fallen to DEFAULT\n");
		  myresp.data.request=DERR_UNK;
		  myresp.type=hisreq.type;
		  strcpy(myresp.data.recdat, "Error:Defaulted");
		  return(DERR_UNK);
		  
		}
	
}

/*****************************************************************
**********************accept data*********************************
******************************************************************/

accept_data(sock)
int sock;
{
  struct sockaddr_in from;
  int g, len = sizeof(from);

  g = accept(sock, &from, &len);
  if (g < 0) bailout("accept ");
  return(g);
}


/*****************************************************************
*********************initialize server****************************
******************************************************************/

initialize_server(host_addr)
struct sockaddr_in *host_addr;
{
  char host[BUFSIZE];
  int sock, t;

  gethostname(host, MAXNAME);
  mk_sock_addrin(host_addr, host);
  sock = create_socket();
  t = bind_sock(sock, host_addr);
  listen(sock, 5);
  getwd(homedir);
  return(sock);
}


/*********************************************************************
* Name        : serv_anl()   / * of sdbase * /
* Description : Analyzes the server's output files - Sdbase
************************************************************************/


serv_anl(no_clients)
  int   no_clients;


{
  unsigned long rd_cnt, 		/* read request counter */
              wr_cnt,		/* write request counter */
	      ad_cnt,		/* add request counter */
	      gt_cnt,		/* get request counter */
	      rs_cnt;		/* result request counter */

  unsigned long errcnt;		/* Total error count */

  unsigned long ret_time;
  unsigned long total_tasks;	/* Total number of tasks logged in */
  unsigned long client_time;
  unsigned long init_time;
  unsigned long getlen_time;
  unsigned long read_time;
  unsigned long write_time;
  unsigned long append_time;

  long randnum(), randwc();


  int       i,j,k,iters, no_of_clients;
  int       l_rid;
  char            c[5];
  char            disk[30], tmp[10];
  long      tot_server_time,
            tot_rd_cnt,tot_wr_cnt,tot_ad_cnt,tot_gt_cnt;
  long      tot_read_time, tot_write_time, tot_append_time,
            tot_getlen_time;
  long      tot_rd_bl, tot_wr_bl, tot_ap_bl, tot_gt_bl;
  long      rd_ovhd, wr_ovhd, ap_ovhd, gt_ovhd, tot_ovhd;
  long      maximum_sz[100], l_rtn;
  FILE      *fp;

  
  printf("*** Server data Analyzer ***\n");

  tot_server_time=tot_rd_cnt=tot_wr_cnt=tot_ad_cnt=tot_gt_cnt=0L;
  tot_read_time= tot_write_time= tot_append_time= tot_getlen_time=0L; 
  tot_rd_bl =  tot_wr_bl = tot_ap_bl =  tot_gt_bl = 0L;


  printf("Analyzing Data for %d clients\n", no_clients);
  
  for(i=0; i<no_clients; i++)
    {
      strcpy(disk,"dbs_");
      sprintf( c, "%d", i);
      strcat(disk, c);
      fp = fopen ( disk, "r");
      if (fp == NULL)
	{
	  printf("Error: Can't open %s\n\n", disk);
	  printf("*** Only %d files analyzed\n", i);
	  break;
	}
      fscanf(fp, " %d", &server_time);
      fscanf( fp, " %d %d %d %d",
	      &rd_cnt, &wr_cnt, &ad_cnt, &gt_cnt);
      fscanf( fp," %d %d %d %d %d %d %d %d",
	      &read_time, &write_time, &append_time, &getlen_time,
	      &rd_blkd, &wr_blkd, &ap_blkd, &gt_blkd);
      fclose(fp);
      tot_server_time += server_time;
      tot_rd_cnt += rd_cnt;
      tot_wr_cnt += wr_cnt;
      tot_ad_cnt += ad_cnt;
      tot_gt_cnt += gt_cnt;
      tot_read_time += read_time;
      tot_write_time += write_time;
      tot_append_time += append_time;
      tot_getlen_time += getlen_time;
      tot_rd_bl += rd_blkd;
      tot_wr_bl += wr_blkd;
      tot_ap_bl += ap_blkd;
      tot_gt_bl += gt_blkd;

    }
        wpi_banner("Synthetic Database: database server", "version" );
        printf( "------------------TOTAL-TIME--------------------\n");
        printf( "\t read \t write \t append\t get_last_record \n");
        printf( "------------------------------------------------\n");
        printf( "Number of operations\n");
        printf( "\t %d \t %d \t %d \t %d \n",
                tot_rd_cnt, tot_wr_cnt, tot_ad_cnt, tot_gt_cnt);
        printf( "Total time  (Time in msecs)\n");
        printf( "%14d%8d%8d%8d \n",
                tot_read_time, tot_write_time,tot_append_time,tot_getlen_time);
        printf( "Average time  (Time in msecs)\n");
        printf( "\t%.2f %.2f  %.2f %.2f \n",
               (float)tot_read_time/(float)tot_rd_cnt,
                (float)tot_write_time/(float)tot_wr_cnt,
                (float)tot_append_time/(float)tot_ad_cnt,
                (float)tot_getlen_time/(float)tot_gt_cnt);
        printf( "(Average time)/%d  (Time in msecs)\n",i);
        printf( " \t%.2f   %.2f   %.2f   %.2f \n",
               (float)tot_read_time/(float)tot_rd_cnt/(float)i,
                (float)tot_write_time/(float)tot_wr_cnt/(float)i,
                (float)tot_append_time/(float)tot_ad_cnt/(float)i,
                (float)tot_getlen_time/(float)tot_gt_cnt/(float)i);
        printf( "------------------------------------------------\n");
        printf( "Total server time = %d milliseconds\n",tot_server_time);
        printf( "(Total server time)/%d = %d ms\n",i,tot_server_time/i);
#ifdef LOCK_DELAY
        printf( "*** Time spent in locks *** (msec)\n", i);
        printf( "Read:  :  %8d\n", tot_rd_bl);
        printf( "Write  :  %8d\n", tot_wr_bl);
        printf( "Append :  %8d\n", tot_ap_bl);
        printf( "Getlast:  %8d\n", tot_gt_bl);
        printf( "-------------------\n");
        printf("Total  :  %8d\n\nCalculating lock overheads\n ",
	       tot_rd_bl+tot_wr_bl+tot_ap_bl+tot_gt_bl);
#endif

  /* normalizing the lock overheads */


#ifndef NOLOCKS
  iters = wr_cnt;
  no_of_clients = no_clients;
  system("rm -f *_#s *_#r *_#w _ap_lck.dbs");

  printf(stderr,"Calculating lock over-heads...");
  for(i=1; i<=no_of_clients; i++)
    {
      gt_ovhd += dum_dotell();
      l_rtn = randnum((unsigned long)i);
      for (j=0; j<iters; j++)
        {
          for(k=0;k<4;k++)
            {
              l_rid=(int)randwc((int)maximum_sz[i])+1;
              sprintf(tmp,"%5d\0",l_rid);
              rd_ovhd += dum_doread(tmp);

            }
          l_rid=(int)randwc(maximum_sz[i])+1;
          sprintf(tmp,"%5d\0",l_rid);
          wr_ovhd += dum_dowrite(tmp);
          if((j%10)==0)
            {
              gt_ovhd += dum_dotell();
              ap_ovhd += dum_doadd();
            }
        }
    }

  tot_ovhd = rd_ovhd + wr_ovhd + ap_ovhd + gt_ovhd;

  fp = fopen ( "tmp#ovhd", "w+");
  if (fp == NULL)
    {
      printf("Error: Can't open temp files\n\n");
      return(1);
    }
  fprintf(fp, " %d %d %d %d %d", rd_ovhd, wr_ovhd, ap_ovhd, gt_ovhd, tot_ovhd);
  fclose(fp);
  printf ("Lock overheads(msec):\nread:\t%8d\nwrite:\t%8d\nappend:\t%8d\n\n",rd_ovhd, wr_ovhd, ap_ovhd);
  unlink ("tmp#ovhd");
  fsync(stderr);
  return(0);

#endif NOLOCKS


}

/**************************** server program ends ****************************/
