
/*********************************************************************
*
* Name        : jigsaw.c
*
* Version     : 1.0
*
* Description : Program makes a jigsaw puzzle of the specified size by
*               using the data generated by generate.c and then jumbles
*               the puzzle. The solve routine is then called to solve
*               the jumbled puzzle.
*
* Written by  : Aju John & Dhruve Shah.
*
* e-mail      : mach@cs.wpi.edu
*
* Address     : Mach Research Group
*               Worcester Polytechnic Institute
*               Computer Science Department
*               100 Institute Road,
*               Worcester MA 01609.
*               U.S.A
*               (508) 831-5357
*
* Rev History : 
*
************************************************************************/

/* include files */
#include <stdio.h>
#include <math.h>
#include "glob.h"       /* file containing global declarations */
#include "defines.h"    /* file containing global definitions  */

main(argc, argv)
int argc;
char *argv[];
{
int size_of_jigsaw ;
char input_file[20];

if (argc > 1)
  strcpy(input_file,argv[1]);
else
  strcpy(input_file,"random.out");
if ((argc < 3) || ( ( size_of_jigsaw = atoi (argv[2])) < 1) )
    {
      printf ("Enter the size of the puzzle:");
      scanf ("%d", &size_of_jigsaw);
    }
printf ("\nThe size of the puzzle is %dx%d\n", size_of_jigsaw, size_of_jigsaw);
printf ("Each tile is of size: %d bytes\n\n",sizeof(TILE));
check_file(size_of_jigsaw, input_file);
make_puzzle(size_of_jigsaw, input_file);
jumble(size_of_jigsaw);
solve(size_of_jigsaw);

}


/*****************************************************************************
 make_puzzle(): Makes all the tiles of the puzzle

 Input(s): void
 Returns : the required size of the puzzle.
 Output  : none
 routines called: none    
                    
 ****************************************************************************/

make_puzzle(size_of_jigsaw, random_file)
int size_of_jigsaw;
char * random_file;
{
     


  SET_PTR   pair;
  TILE_PTR  *jigsaw_matrix, start, ptr, prev, make_random_list(); 
  int total_pairs;
  int i,j,k;
  FILE *file1, *file2;


  total_pairs = 2 * pow((float)size_of_jigsaw,2.);

  if (!(pair = (SET *) calloc (total_pairs, sizeof(SET))))
    {
      printf ("Error in calloc at X01 \n");
      exit(-1);
    }



  if (!(jigsaw_matrix = (TILE_PTR*) calloc (size_of_jigsaw, sizeof(TILE_PTR))))
    {
      printf ("Error in calloc at X01 \n");
      exit(-1);
    }
  for(i=0;i<size_of_jigsaw;i++)
    {
      jigsaw_matrix[i] = (TILE*) calloc (size_of_jigsaw, sizeof(TILE));
    }


  
  file1 = fopen(random_file,"r");
  if (file1 == NULL)
    {
      printf("Error: - Cannot open data file: %s.\n", random_file);
      printf("Usage: jigsaw <datafile> puzzle-size \n");
      exit(-1);
    }


  for(i = 0; i < total_pairs; i++)
    {

      if ( 2 != (fscanf(file1,"%d %d\n",&pair[i].n1,&pair[i].n2)) )
	{
	  printf("Error: File %s is not generated for puzzle size %dx%d\n",
		 random_file, size_of_jigsaw,size_of_jigsaw);
	  exit(-1);
	}

      if (pair[i].n1 % pair[i].n2 != KEY)
	{
	  printf("Error in index i = %d\n", i);
	  exit(-1);
	}
    }
  fclose(file1);

  k=0;
  printf("Making puzzle tiles...");

  for(i=0; i<size_of_jigsaw; i++)
    for(j=0; j<size_of_jigsaw; j++){
      jigsaw_matrix[i][j].identity = i*size_of_jigsaw + j;
      jigsaw_matrix[i][j].match_north     =  INITIAL_VALUE;
      jigsaw_matrix[i][j].match_south  =  INITIAL_VALUE;
      jigsaw_matrix[i][j].match_west    =  INITIAL_VALUE;
      jigsaw_matrix[i][j].match_east   =  INITIAL_VALUE;
      jigsaw_matrix[i][j].count=  0;
      jigsaw_matrix[i][j].next = NULL;

      jigsaw_matrix[i][j].east           = pair[k].n1;
      jigsaw_matrix[i][(j+1) % size_of_jigsaw].west = pair[k++].n2;
      jigsaw_matrix[i][j].south            = pair[k].n1;
      jigsaw_matrix[(i+1) % size_of_jigsaw][j].north  = pair[k++].n2;

    }

  for(i=0; i<size_of_jigsaw; i++)
    for(j=0; j<size_of_jigsaw; j++)
      {
	if (i==0  && j==0)
	  {
	    start = &jigsaw_matrix[i][j];
	    prev = start;
	  }
	
	else
	  {
	    ptr = &jigsaw_matrix[i][j];
	    prev->next = ptr;
	    prev = ptr;
	  }
      }
  prev->next = '\0';




  
  file2 = fopen("puzzle.out","w");
  if (file2 == NULL)
    {
      printf("\nError: X02 - Cannot open file:puzzle.out.\n");
      printf("Check for user write permission in current directory.\n");
      exit(-1);
    }


  
  for(i=0;i<size_of_jigsaw;i++)
    for(j=0;j<size_of_jigsaw;j++)
      fprintf(file2,"%d %d %d %d %d\n",jigsaw_matrix[i][j].identity,jigsaw_matrix[i][j].east,jigsaw_matrix[i][j].west,jigsaw_matrix[i][j].north,jigsaw_matrix[i][j].south);

  fclose(file2);

  printf("Completed.\n");

}


check_file(size_of_jigsaw, random_file)
int size_of_jigsaw;
char * random_file;
{

  int total_pairs;
  int i,c;
  long j;
  FILE *file1, *file2;

  i = j = c = 0;
  total_pairs = size_of_jigsaw * size_of_jigsaw * 2;
  
  file1 = fopen(random_file,"r");
  if (file1 == NULL)
    {
      printf("Error: X02 - Cannot open file: %s.\n", random_file);
      exit(-1);
    }

  while ( ( c = fgetc(file1)) != EOF)
    {
      if (c == '\n') 
	{
	  j++;
	  i++;
	  if (i > 1) break;
	}
      else
	if (c == ' ') i = 0;
    }

  if (j < total_pairs)
	{
	  printf("Error: File %s is not generated for puzzle size %dx%d\n",
		 random_file, size_of_jigsaw,size_of_jigsaw);
	  printf("Check file and/or try  smaller puzzle sizes\n");
	  exit(-1);
	}

           


  fclose(file1);
}

/* $Header$ */
