/* Execution of files 
   Copyright (C) 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include "ufs.h"

error_t
file_exec (struct protid *cred,
	   task_t task,

	   char *argv,
	   u_int argvlen,
	   char *envp,
	   u_int envplen,
	   int argc,
	   int envc,

	   mach_port_t *fds,
	   u_int fdslen,
	   mach_port_t cwdir,
	   mach_port_t crdir,

	   mach_port_t procserver,
	   mach_port_t authserver,
	   mach_port_t nameserver,

	   vm_address_t saveregion,
	   vm_size_t savesize,

	   mach_port_t *deallocnames,
	   u_int deallocnameslen,

	   int flags)
{
  return err;
}

void
handle_exec_map (void *ipf,
		 memory_object_t *memobj)
{
  struct inode *ip = ipf;
  *memobj = get_filemap (ip);
}

error_t
handle_exec_read (void *ipf,
		  int offset,
		  void *buffer,
		  int buflen)
{
  struct inode *ip = ipf;
  if (offset + buflen > ip->di->di_size)
    return ENOEXEC;
  else
    return fs_rdwr (ip, buffer, offset, buflen, 0, 0);
}
