#ifndef	_fsys_user_
#define	_fsys_user_

/* Module fsys */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <hurd/hurd_types.h>
#include "ufs.h"

/* Routine fsys_startup */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_fsys_startup
#if	defined(LINTLIBRARY)
    (bootstrap, control_port, realnode, dotdot_node)
	mach_port_t bootstrap;
	fsys_t control_port;
	file_t *realnode;
	file_t *dotdot_node;
{ return U_fsys_startup(bootstrap, control_port, realnode, dotdot_node); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t bootstrap,
	fsys_t control_port,
	file_t *realnode,
	file_t *dotdot_node
);
#else
    ();
#endif
#endif

/* Routine fsys_goaway */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_fsys_goaway
#if	defined(LINTLIBRARY)
    (fsys, flags)
	fsys_t fsys;
	int flags;
{ return U_fsys_goaway(fsys, flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	fsys_t fsys,
	int flags
);
#else
    ();
#endif
#endif

/* Routine fsys_getroot */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_fsys_getroot
#if	defined(LINTLIBRARY)
    (fsys, flags, auth_realnode, file)
	fsys_t fsys;
	int flags;
	mach_port_t auth_realnode;
	mach_port_t *file;
{ return U_fsys_getroot(fsys, flags, auth_realnode, file); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	fsys_t fsys,
	int flags,
	mach_port_t auth_realnode,
	mach_port_t *file
);
#else
    ();
#endif
#endif

/* Routine fsys_getfile */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_fsys_getfile
#if	defined(LINTLIBRARY)
    (fsys, uids, uidsCnt, gids, gidsCnt, filehandle, filehandleCnt, file)
	fsys_t fsys;
	idarray_t uids;
	mach_msg_type_number_t uidsCnt;
	idarray_t gids;
	mach_msg_type_number_t gidsCnt;
	data_t filehandle;
	mach_msg_type_number_t filehandleCnt;
	file_t *file;
{ return U_fsys_getfile(fsys, uids, uidsCnt, gids, gidsCnt, filehandle, filehandleCnt, file); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	fsys_t fsys,
	idarray_t uids,
	mach_msg_type_number_t uidsCnt,
	idarray_t gids,
	mach_msg_type_number_t gidsCnt,
	data_t filehandle,
	mach_msg_type_number_t filehandleCnt,
	file_t *file
);
#else
    ();
#endif
#endif

#endif	_fsys_user_
