#ifndef	_fs_user_
#define	_fs_user_

/* Module fs */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <hurd/hurd_types.h>
#include "ufs.h"

/* Routine file_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_exec
#if	defined(LINTLIBRARY)
    (exec_file, exec_task, flags, argv, argvCnt, envp, envpCnt, fdarray, fdarrayCnt, portarray, portarrayCnt, intarray, intarrayCnt)
	file_t exec_file;
	mach_port_t exec_task;
	int flags;
	data_t argv;
	mach_msg_type_number_t argvCnt;
	data_t envp;
	mach_msg_type_number_t envpCnt;
	portarray_t fdarray;
	mach_msg_type_number_t fdarrayCnt;
	portarray_t portarray;
	mach_msg_type_number_t portarrayCnt;
	intarray_t intarray;
	mach_msg_type_number_t intarrayCnt;
{ return U_file_exec(exec_file, exec_task, flags, argv, argvCnt, envp, envpCnt, fdarray, fdarrayCnt, portarray, portarrayCnt, intarray, intarrayCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t exec_file,
	mach_port_t exec_task,
	int flags,
	data_t argv,
	mach_msg_type_number_t argvCnt,
	data_t envp,
	mach_msg_type_number_t envpCnt,
	portarray_t fdarray,
	mach_msg_type_number_t fdarrayCnt,
	portarray_t portarray,
	mach_msg_type_number_t portarrayCnt,
	intarray_t intarray,
	mach_msg_type_number_t intarrayCnt
);
#else
    ();
#endif
#endif

/* Routine file_chown */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_chown
#if	defined(LINTLIBRARY)
    (chown_file, new_owner, new_group)
	file_t chown_file;
	uid_t new_owner;
	gid_t new_group;
{ return U_file_chown(chown_file, new_owner, new_group); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chown_file,
	uid_t new_owner,
	gid_t new_group
);
#else
    ();
#endif
#endif

/* Routine file_chauthor */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_chauthor
#if	defined(LINTLIBRARY)
    (chauth_file, new_author)
	file_t chauth_file;
	uid_t new_author;
{ return U_file_chauthor(chauth_file, new_author); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chauth_file,
	uid_t new_author
);
#else
    ();
#endif
#endif

/* Routine file_chmod */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_chmod
#if	defined(LINTLIBRARY)
    (chmod_file, new_mode)
	file_t chmod_file;
	mode_t new_mode;
{ return U_file_chmod(chmod_file, new_mode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chmod_file,
	mode_t new_mode
);
#else
    ();
#endif
#endif

/* Routine file_chflags */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_chflags
#if	defined(LINTLIBRARY)
    (chflags_file, new_flags)
	file_t chflags_file;
	int new_flags;
{ return U_file_chflags(chflags_file, new_flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chflags_file,
	int new_flags
);
#else
    ();
#endif
#endif

/* Routine file_utimes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_utimes
#if	defined(LINTLIBRARY)
    (utimes_file, new_atime, new_mtime)
	file_t utimes_file;
	time_value_t new_atime;
	time_value_t new_mtime;
{ return U_file_utimes(utimes_file, new_atime, new_mtime); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t utimes_file,
	time_value_t new_atime,
	time_value_t new_mtime
);
#else
    ();
#endif
#endif

/* Routine file_seek */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_seek
#if	defined(LINTLIBRARY)
    (seek_file, offset, whence, newp)
	file_t seek_file;
	int offset;
	int whence;
	int *newp;
{ return U_file_seek(seek_file, offset, whence, newp); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t seek_file,
	int offset,
	int whence,
	int *newp
);
#else
    ();
#endif
#endif

/* Routine file_truncate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_truncate
#if	defined(LINTLIBRARY)
    (trunc_file, new_size)
	file_t trunc_file;
	int new_size;
{ return U_file_truncate(trunc_file, new_size); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t trunc_file,
	int new_size
);
#else
    ();
#endif
#endif

/* Routine file_lock */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_lock
#if	defined(LINTLIBRARY)
    (lock_file, flags)
	file_t lock_file;
	int flags;
{ return U_file_lock(lock_file, flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t lock_file,
	int flags
);
#else
    ();
#endif
#endif

/* Routine file_lock_stat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_lock_stat
#if	defined(LINTLIBRARY)
    (lock_file, mystatus, otherstatus)
	file_t lock_file;
	int *mystatus;
	int *otherstatus;
{ return U_file_lock_stat(lock_file, mystatus, otherstatus); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t lock_file,
	int *mystatus,
	int *otherstatus
);
#else
    ();
#endif
#endif

/* Routine file_getcontrol */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_getcontrol
#if	defined(LINTLIBRARY)
    (file, control)
	file_t file;
	mach_port_t *control;
{ return U_file_getcontrol(file, control); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	mach_port_t *control
);
#else
    ();
#endif
#endif

/* Routine file_statfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_statfs
#if	defined(LINTLIBRARY)
    (file, info)
	file_t file;
	fsys_statfsbuf_t *info;
{ return U_file_statfs(file, info); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	fsys_statfsbuf_t *info
);
#else
    ();
#endif
#endif

/* Routine file_sync */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_sync
#if	defined(LINTLIBRARY)
    (file, wait)
	file_t file;
	int wait;
{ return U_file_sync(file, wait); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	int wait
);
#else
    ();
#endif
#endif

/* Routine file_syncfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_syncfs
#if	defined(LINTLIBRARY)
    (file, wait, do_children)
	file_t file;
	int wait;
	int do_children;
{ return U_file_syncfs(file, wait, do_children); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	int wait,
	int do_children
);
#else
    ();
#endif
#endif

/* Routine file_pathconf */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_pathconf
#if	defined(LINTLIBRARY)
    (file, pathconf)
	file_t file;
	pathconf_t *pathconf;
{ return U_file_pathconf(file, pathconf); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	pathconf_t *pathconf
);
#else
    ();
#endif
#endif

/* Routine file_getlinknode */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_getlinknode
#if	defined(LINTLIBRARY)
    (file, linknode)
	file_t file;
	file_t *linknode;
{ return U_file_getlinknode(file, linknode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	file_t *linknode
);
#else
    ();
#endif
#endif

/* Routine file_getfh */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_getfh
#if	defined(LINTLIBRARY)
    (file, filehandle, filehandleCnt)
	file_t file;
	data_t *filehandle;
	mach_msg_type_number_t *filehandleCnt;
{ return U_file_getfh(file, filehandle, filehandleCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	data_t *filehandle,
	mach_msg_type_number_t *filehandleCnt
);
#else
    ();
#endif
#endif

/* Routine dir_pathtrans */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_dir_pathtrans
#if	defined(LINTLIBRARY)
    (start_dir, pathname, flags, mode, do_retry, retry_name, result)
	file_t start_dir;
	string_t pathname;
	int flags;
	mode_t mode;
	retry_type *do_retry;
	string_t retry_name;
	file_t *result;
{ return U_dir_pathtrans(start_dir, pathname, flags, mode, do_retry, retry_name, result); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t start_dir,
	string_t pathname,
	int flags,
	mode_t mode,
	retry_type *do_retry,
	string_t retry_name,
	file_t *result
);
#else
    ();
#endif
#endif

/* Routine dir_readdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_dir_readdir
#if	defined(LINTLIBRARY)
    (dir, data, dataCnt, offset, nextoffset, amount)
	file_t dir;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
	int offset;
	int *nextoffset;
	int amount;
{ return U_dir_readdir(dir, data, dataCnt, offset, nextoffset, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t dir,
	data_t *data,
	mach_msg_type_number_t *dataCnt,
	int offset,
	int *nextoffset,
	int amount
);
#else
    ();
#endif
#endif

/* Routine dir_mkdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_dir_mkdir
#if	defined(LINTLIBRARY)
    (directory, name, mode)
	file_t directory;
	string_t name;
	mode_t mode;
{ return U_dir_mkdir(directory, name, mode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name,
	mode_t mode
);
#else
    ();
#endif
#endif

/* Routine dir_rmdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_dir_rmdir
#if	defined(LINTLIBRARY)
    (directory, name)
	file_t directory;
	string_t name;
{ return U_dir_rmdir(directory, name); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name
);
#else
    ();
#endif
#endif

/* Routine dir_unlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_dir_unlink
#if	defined(LINTLIBRARY)
    (directory, name)
	file_t directory;
	string_t name;
{ return U_dir_unlink(directory, name); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name
);
#else
    ();
#endif
#endif

/* Routine dir_link */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_dir_link
#if	defined(LINTLIBRARY)
    (oldfile, newdirectory, newname)
	file_t oldfile;
	file_t newdirectory;
	string_t newname;
{ return U_dir_link(oldfile, newdirectory, newname); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t oldfile,
	file_t newdirectory,
	string_t newname
);
#else
    ();
#endif
#endif

/* Routine dir_rename */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_dir_rename
#if	defined(LINTLIBRARY)
    (olddirectory, oldname, newdirectory, newname)
	file_t olddirectory;
	string_t oldname;
	file_t newdirectory;
	string_t newname;
{ return U_dir_rename(olddirectory, oldname, newdirectory, newname); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t olddirectory,
	string_t oldname,
	file_t newdirectory,
	string_t newname
);
#else
    ();
#endif
#endif

/* Routine file_set_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_set_translator
#if	defined(LINTLIBRARY)
    (file, flags, oldtrans_flags, translator, translatorCnt, existing)
	file_t file;
	int flags;
	int oldtrans_flags;
	data_t translator;
	mach_msg_type_number_t translatorCnt;
	mach_port_t existing;
{ return U_file_set_translator(file, flags, oldtrans_flags, translator, translatorCnt, existing); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	int flags,
	int oldtrans_flags,
	data_t translator,
	mach_msg_type_number_t translatorCnt,
	mach_port_t existing
);
#else
    ();
#endif
#endif

/* Routine file_get_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_get_translator
#if	defined(LINTLIBRARY)
    (file, translator, translatorCnt)
	file_t file;
	data_t *translator;
	mach_msg_type_number_t *translatorCnt;
{ return U_file_get_translator(file, translator, translatorCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	data_t *translator,
	mach_msg_type_number_t *translatorCnt
);
#else
    ();
#endif
#endif

/* Routine file_get_translator_cntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t U_file_get_translator_cntl
#if	defined(LINTLIBRARY)
    (file, translator_cntl)
	file_t file;
	fsys_t *translator_cntl;
{ return U_file_get_translator_cntl(file, translator_cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	fsys_t *translator_cntl
);
#else
    ();
#endif
#endif

#endif	_fs_user_
