/* Module fs */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <hurd/hurd_types.h>
#include "ufs.h"

/* Routine file_exec */
mig_internal novalue _Xfile_exec
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t exec_taskType;
		mach_port_t exec_task;
		mach_msg_type_t flagsType;
		int flags;
		mach_msg_type_long_t argvType;
		char argv[2048];
		mach_msg_type_long_t envpType;
		char envp[2048];
		mach_msg_type_long_t fdarrayType;
		mach_port_t fdarray[512];
		mach_msg_type_long_t portarrayType;
		mach_port_t portarray[512];
		mach_msg_type_long_t intarrayType;
		int intarray[512];
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Request *In1P;
	register Request *In2P;
	register Request *In3P;
	register Request *In4P;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_exec
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t exec_file, mach_port_t exec_task, int flags, data_t argv, mach_msg_type_number_t argvCnt, data_t envp, mach_msg_type_number_t envpCnt, portarray_t fdarray, mach_msg_type_number_t fdarrayCnt, portarray_t portarray, mach_msg_type_number_t portarrayCnt, intarray_t intarray, mach_msg_type_number_t intarrayCnt);
#else
		();
#endif

	unsigned int msgh_size;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t exec_taskCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t flagsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t exec_file;

#if	TypeCheck
	msgh_size = In0P->Head.msgh_size;
	if ((msgh_size < 100) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->exec_taskType != * (int *) &exec_taskCheck)
#else	UseStaticMsgType
	if ((In0P->exec_taskType.msgt_inline != TRUE) ||
	    (In0P->exec_taskType.msgt_longform != FALSE) ||
	    (In0P->exec_taskType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->exec_taskType.msgt_number != 1) ||
	    (In0P->exec_taskType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flagsType != * (int *) &flagsCheck)
#else	UseStaticMsgType
	if ((In0P->flagsType.msgt_inline != TRUE) ||
	    (In0P->flagsType.msgt_longform != FALSE) ||
	    (In0P->flagsType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->flagsType.msgt_number != 1) ||
	    (In0P->flagsType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->argvType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->argvType.msgtl_name != MACH_MSG_TYPE_CHAR) ||
	    (In0P->argvType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	msgh_size_delta = (In0P->argvType.msgtl_header.msgt_inline) ? In0P->argvType.msgtl_number + 3 & ~3 : sizeof(char *);
#if	TypeCheck
	if (msgh_size < 100 + msgh_size_delta)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	In1P = (Request *) ((char *) In0P + msgh_size_delta - 2048);

#if	TypeCheck
	if ((In1P->envpType.msgtl_header.msgt_longform != TRUE) ||
	    (In1P->envpType.msgtl_name != MACH_MSG_TYPE_CHAR) ||
	    (In1P->envpType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	msgh_size_delta = (In1P->envpType.msgtl_header.msgt_inline) ? In1P->envpType.msgtl_number + 3 & ~3 : sizeof(char *);
#if	TypeCheck
	if (msgh_size < 100 + msgh_size_delta)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	In2P = (Request *) ((char *) In1P + msgh_size_delta - 2048);

#if	TypeCheck
	if ((In2P->fdarrayType.msgtl_header.msgt_longform != TRUE) ||
	    (In2P->fdarrayType.msgtl_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In2P->fdarrayType.msgtl_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	msgh_size_delta = (In2P->fdarrayType.msgtl_header.msgt_inline) ? 4 * In2P->fdarrayType.msgtl_number : sizeof(mach_port_t *);
#if	TypeCheck
	if (msgh_size < 100 + msgh_size_delta)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	In3P = (Request *) ((char *) In2P + msgh_size_delta - 2048);

#if	TypeCheck
	if ((In3P->portarrayType.msgtl_header.msgt_longform != TRUE) ||
	    (In3P->portarrayType.msgtl_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In3P->portarrayType.msgtl_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	msgh_size_delta = (In3P->portarrayType.msgtl_header.msgt_inline) ? 4 * In3P->portarrayType.msgtl_number : sizeof(mach_port_t *);
#if	TypeCheck
	if (msgh_size < 100 + msgh_size_delta)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
	msgh_size -= msgh_size_delta;
#endif	TypeCheck

	In4P = (Request *) ((char *) In3P + msgh_size_delta - 2048);

#if	TypeCheck
	if ((In4P->intarrayType.msgtl_header.msgt_longform != TRUE) ||
	    (In4P->intarrayType.msgtl_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In4P->intarrayType.msgtl_size != 32))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if (msgh_size != 100 + ((In4P->intarrayType.msgtl_header.msgt_inline) ? 4 * In4P->intarrayType.msgtl_number : sizeof(int *)))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	exec_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_exec(exec_file, In0P->exec_task, In0P->flags, (In0P->argvType.msgtl_header.msgt_inline) ? In0P->argv : *((char **)In0P->argv), In0P->argvType.msgtl_number, (In1P->envpType.msgtl_header.msgt_inline) ? In1P->envp : *((char **)In1P->envp), In1P->envpType.msgtl_number, (In2P->fdarrayType.msgtl_header.msgt_inline) ? In2P->fdarray : *((mach_port_t **)In2P->fdarray), In2P->fdarrayType.msgtl_number, (In3P->portarrayType.msgtl_header.msgt_inline) ? In3P->portarray : *((mach_port_t **)In3P->portarray), In3P->portarrayType.msgtl_number, (In4P->intarrayType.msgtl_header.msgt_inline) ? In4P->intarray : *((int **)In4P->intarray), In4P->intarrayType.msgtl_number);
	if (!In4P->intarrayType.msgtl_header.msgt_inline)
		mig_deallocate(*(char **)In4P->intarray, 4 *  In4P->intarrayType.msgtl_number);
	if (!In3P->portarrayType.msgtl_header.msgt_inline)
		mig_deallocate(*(char **)In3P->portarray, 4 *  In3P->portarrayType.msgtl_number);
	if (!In2P->fdarrayType.msgtl_header.msgt_inline)
		mig_deallocate(*(char **)In2P->fdarray, 4 *  In2P->fdarrayType.msgtl_number);
	if (!In1P->envpType.msgtl_header.msgt_inline)
		mig_deallocate(*(char **)In1P->envp,  In1P->envpType.msgtl_number);
	if (!In0P->argvType.msgtl_header.msgt_inline)
		mig_deallocate(*(char **)In0P->argv,  In0P->argvType.msgtl_number);
	release_protidport(exec_file);
}

/* Routine file_chown */
mig_internal novalue _Xfile_chown
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_ownerType;
		uid_t new_owner;
		mach_msg_type_t new_groupType;
		gid_t new_group;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_chown
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t chown_file, uid_t new_owner, gid_t new_group);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t new_ownerCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t new_groupCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t chown_file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_ownerType != * (int *) &new_ownerCheck)
#else	UseStaticMsgType
	if ((In0P->new_ownerType.msgt_inline != TRUE) ||
	    (In0P->new_ownerType.msgt_longform != FALSE) ||
	    (In0P->new_ownerType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->new_ownerType.msgt_number != 1) ||
	    (In0P->new_ownerType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_groupType != * (int *) &new_groupCheck)
#else	UseStaticMsgType
	if ((In0P->new_groupType.msgt_inline != TRUE) ||
	    (In0P->new_groupType.msgt_longform != FALSE) ||
	    (In0P->new_groupType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->new_groupType.msgt_number != 1) ||
	    (In0P->new_groupType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	chown_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_chown(chown_file, In0P->new_owner, In0P->new_group);
	release_protidport(chown_file);
}

/* Routine file_chauthor */
mig_internal novalue _Xfile_chauthor
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_authorType;
		uid_t new_author;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_chauthor
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t chauth_file, uid_t new_author);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t new_authorCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t chauth_file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_authorType != * (int *) &new_authorCheck)
#else	UseStaticMsgType
	if ((In0P->new_authorType.msgt_inline != TRUE) ||
	    (In0P->new_authorType.msgt_longform != FALSE) ||
	    (In0P->new_authorType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->new_authorType.msgt_number != 1) ||
	    (In0P->new_authorType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	chauth_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_chauthor(chauth_file, In0P->new_author);
	release_protidport(chauth_file);
}

/* Routine file_chmod */
mig_internal novalue _Xfile_chmod
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_modeType;
		mode_t new_mode;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_chmod
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t chmod_file, mode_t new_mode);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t new_modeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t chmod_file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_modeType != * (int *) &new_modeCheck)
#else	UseStaticMsgType
	if ((In0P->new_modeType.msgt_inline != TRUE) ||
	    (In0P->new_modeType.msgt_longform != FALSE) ||
	    (In0P->new_modeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->new_modeType.msgt_number != 1) ||
	    (In0P->new_modeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	chmod_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_chmod(chmod_file, In0P->new_mode);
	release_protidport(chmod_file);
}

/* Routine file_chflags */
mig_internal novalue _Xfile_chflags
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_flagsType;
		int new_flags;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_chflags
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t chflags_file, int new_flags);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t new_flagsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t chflags_file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_flagsType != * (int *) &new_flagsCheck)
#else	UseStaticMsgType
	if ((In0P->new_flagsType.msgt_inline != TRUE) ||
	    (In0P->new_flagsType.msgt_longform != FALSE) ||
	    (In0P->new_flagsType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->new_flagsType.msgt_number != 1) ||
	    (In0P->new_flagsType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	chflags_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_chflags(chflags_file, In0P->new_flags);
	release_protidport(chflags_file);
}

/* Routine file_utimes */
mig_internal novalue _Xfile_utimes
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_atimeType;
		time_value_t new_atime;
		mach_msg_type_t new_mtimeType;
		time_value_t new_mtime;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_utimes
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t utimes_file, time_value_t new_atime, time_value_t new_mtime);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t new_atimeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		2,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t new_mtimeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		2,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t utimes_file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_atimeType != * (int *) &new_atimeCheck)
#else	UseStaticMsgType
	if ((In0P->new_atimeType.msgt_inline != TRUE) ||
	    (In0P->new_atimeType.msgt_longform != FALSE) ||
	    (In0P->new_atimeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->new_atimeType.msgt_number != 2) ||
	    (In0P->new_atimeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_mtimeType != * (int *) &new_mtimeCheck)
#else	UseStaticMsgType
	if ((In0P->new_mtimeType.msgt_inline != TRUE) ||
	    (In0P->new_mtimeType.msgt_longform != FALSE) ||
	    (In0P->new_mtimeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->new_mtimeType.msgt_number != 2) ||
	    (In0P->new_mtimeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	utimes_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_utimes(utimes_file, In0P->new_atime, In0P->new_mtime);
	release_protidport(utimes_file);
}

/* Routine file_seek */
mig_internal novalue _Xfile_seek
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		int offset;
		mach_msg_type_t whenceType;
		int whence;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t newpType;
		int newp;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_seek
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t seek_file, int offset, int whence, int *newp);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t whenceCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newpType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t seek_file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whenceType != * (int *) &whenceCheck)
#else	UseStaticMsgType
	if ((In0P->whenceType.msgt_inline != TRUE) ||
	    (In0P->whenceType.msgt_longform != FALSE) ||
	    (In0P->whenceType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->whenceType.msgt_number != 1) ||
	    (In0P->whenceType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	seek_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_seek(seek_file, In0P->offset, In0P->whence, &OutP->newp);
	release_protidport(seek_file);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->newpType = newpType;
#else	UseStaticMsgType
	OutP->newpType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->newpType.msgt_size = 32;
	OutP->newpType.msgt_number = 1;
	OutP->newpType.msgt_inline = TRUE;
	OutP->newpType.msgt_longform = FALSE;
	OutP->newpType.msgt_deallocate = FALSE;
	OutP->newpType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine file_truncate */
mig_internal novalue _Xfile_truncate
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t new_sizeType;
		int new_size;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_truncate
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t trunc_file, int new_size);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t new_sizeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t trunc_file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->new_sizeType != * (int *) &new_sizeCheck)
#else	UseStaticMsgType
	if ((In0P->new_sizeType.msgt_inline != TRUE) ||
	    (In0P->new_sizeType.msgt_longform != FALSE) ||
	    (In0P->new_sizeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->new_sizeType.msgt_number != 1) ||
	    (In0P->new_sizeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	trunc_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_truncate(trunc_file, In0P->new_size);
	release_protidport(trunc_file);
}

/* Routine file_lock */
mig_internal novalue _Xfile_lock
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flagsType;
		int flags;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_lock
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t lock_file, int flags);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t flagsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t lock_file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flagsType != * (int *) &flagsCheck)
#else	UseStaticMsgType
	if ((In0P->flagsType.msgt_inline != TRUE) ||
	    (In0P->flagsType.msgt_longform != FALSE) ||
	    (In0P->flagsType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->flagsType.msgt_number != 1) ||
	    (In0P->flagsType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	lock_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_lock(lock_file, In0P->flags);
	release_protidport(lock_file);
}

/* Routine file_lock_stat */
mig_internal novalue _Xfile_lock_stat
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t mystatusType;
		int mystatus;
		mach_msg_type_t otherstatusType;
		int otherstatus;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_lock_stat
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t lock_file, int *mystatus, int *otherstatus);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t mystatusType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t otherstatusType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t lock_file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	lock_file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_lock_stat(lock_file, &OutP->mystatus, &OutP->otherstatus);
	release_protidport(lock_file);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 48;

#if	UseStaticMsgType
	OutP->mystatusType = mystatusType;
#else	UseStaticMsgType
	OutP->mystatusType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->mystatusType.msgt_size = 32;
	OutP->mystatusType.msgt_number = 1;
	OutP->mystatusType.msgt_inline = TRUE;
	OutP->mystatusType.msgt_longform = FALSE;
	OutP->mystatusType.msgt_deallocate = FALSE;
	OutP->mystatusType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->otherstatusType = otherstatusType;
#else	UseStaticMsgType
	OutP->otherstatusType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->otherstatusType.msgt_size = 32;
	OutP->otherstatusType.msgt_number = 1;
	OutP->otherstatusType.msgt_inline = TRUE;
	OutP->otherstatusType.msgt_longform = FALSE;
	OutP->otherstatusType.msgt_deallocate = FALSE;
	OutP->otherstatusType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine file_getcontrol */
mig_internal novalue _Xfile_getcontrol
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t controlType;
		mach_port_t control;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_getcontrol
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, mach_port_t *control);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t controlType = {
		/* msgt_name = */		MACH_MSG_TYPE_MAKE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_getcontrol(file, &OutP->control);
	release_protidport(file);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->controlType = controlType;
#else	UseStaticMsgType
	OutP->controlType.msgt_name = MACH_MSG_TYPE_MAKE_SEND;
	OutP->controlType.msgt_size = 32;
	OutP->controlType.msgt_number = 1;
	OutP->controlType.msgt_inline = TRUE;
	OutP->controlType.msgt_longform = FALSE;
	OutP->controlType.msgt_deallocate = FALSE;
	OutP->controlType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine file_statfs */
mig_internal novalue _Xfile_statfs
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t infoType;
		fsys_statfsbuf_t info;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_statfs
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, fsys_statfsbuf_t *info);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t infoType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		19,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_statfs(file, &OutP->info);
	release_protidport(file);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 112;

#if	UseStaticMsgType
	OutP->infoType = infoType;
#else	UseStaticMsgType
	OutP->infoType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->infoType.msgt_size = 32;
	OutP->infoType.msgt_number = 19;
	OutP->infoType.msgt_inline = TRUE;
	OutP->infoType.msgt_longform = FALSE;
	OutP->infoType.msgt_deallocate = FALSE;
	OutP->infoType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine file_sync */
mig_internal novalue _Xfile_sync
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t waitType;
		int wait;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_sync
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, int wait);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t waitCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->waitType != * (int *) &waitCheck)
#else	UseStaticMsgType
	if ((In0P->waitType.msgt_inline != TRUE) ||
	    (In0P->waitType.msgt_longform != FALSE) ||
	    (In0P->waitType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->waitType.msgt_number != 1) ||
	    (In0P->waitType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_sync(file, In0P->wait);
	release_protidport(file);
}

/* Routine file_syncfs */
mig_internal novalue _Xfile_syncfs
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t waitType;
		int wait;
		mach_msg_type_t do_childrenType;
		int do_children;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_syncfs
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, int wait, int do_children);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t waitCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t do_childrenCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->waitType != * (int *) &waitCheck)
#else	UseStaticMsgType
	if ((In0P->waitType.msgt_inline != TRUE) ||
	    (In0P->waitType.msgt_longform != FALSE) ||
	    (In0P->waitType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->waitType.msgt_number != 1) ||
	    (In0P->waitType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->do_childrenType != * (int *) &do_childrenCheck)
#else	UseStaticMsgType
	if ((In0P->do_childrenType.msgt_inline != TRUE) ||
	    (In0P->do_childrenType.msgt_longform != FALSE) ||
	    (In0P->do_childrenType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->do_childrenType.msgt_number != 1) ||
	    (In0P->do_childrenType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_syncfs(file, In0P->wait, In0P->do_children);
	release_protidport(file);
}

/* Routine file_pathconf */
mig_internal novalue _Xfile_pathconf
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t pathconfType;
		pathconf_t pathconf;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_pathconf
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, pathconf_t *pathconf);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pathconfType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		9,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_pathconf(file, &OutP->pathconf);
	release_protidport(file);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 72;

#if	UseStaticMsgType
	OutP->pathconfType = pathconfType;
#else	UseStaticMsgType
	OutP->pathconfType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->pathconfType.msgt_size = 32;
	OutP->pathconfType.msgt_number = 9;
	OutP->pathconfType.msgt_inline = TRUE;
	OutP->pathconfType.msgt_longform = FALSE;
	OutP->pathconfType.msgt_deallocate = FALSE;
	OutP->pathconfType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine file_getlinknode */
mig_internal novalue _Xfile_getlinknode
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t linknodeType;
		file_t linknode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_getlinknode
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, protid_t *linknode);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t linknodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t file;
	protid_t linknode;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_getlinknode(file, &linknode);
	release_protidport(file);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->linknodeType = linknodeType;
#else	UseStaticMsgType
	OutP->linknodeType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	OutP->linknodeType.msgt_size = 32;
	OutP->linknodeType.msgt_number = 1;
	OutP->linknodeType.msgt_inline = TRUE;
	OutP->linknodeType.msgt_longform = FALSE;
	OutP->linknodeType.msgt_deallocate = FALSE;
	OutP->linknodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->linknode = convert_protid_to_port(linknode);
}

/* Routine file_getfh */
mig_internal novalue _Xfile_getfh
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t filehandleType;
		char filehandle[2048];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_getfh
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, data_t *filehandle, mach_msg_type_number_t *filehandleCnt);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_long_t filehandleType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2048,
	};
#endif	UseStaticMsgType

	protid_t file;
	mach_msg_type_number_t filehandleCnt;

	char *filehandleP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	filehandleP = OutP->filehandle;
	filehandleCnt = 2048;

	OutP->RetCode = file_getfh(file, &filehandleP, &filehandleCnt);
	release_protidport(file);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->filehandleType = filehandleType;
#else	UseStaticMsgType
	OutP->filehandleType.msgtl_name = MACH_MSG_TYPE_CHAR;
	OutP->filehandleType.msgtl_size = 8;
	OutP->filehandleType.msgtl_header.msgt_name = 0;
	OutP->filehandleType.msgtl_header.msgt_size = 0;
	OutP->filehandleType.msgtl_header.msgt_number = 0;
	OutP->filehandleType.msgtl_header.msgt_inline = TRUE;
	OutP->filehandleType.msgtl_header.msgt_longform = TRUE;
	OutP->filehandleType.msgtl_header.msgt_deallocate = FALSE;
	OutP->filehandleType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (filehandleP != OutP->filehandle) {
		OutP->filehandleType.msgtl_header.msgt_inline = FALSE;
		*((char **)OutP->filehandle) = filehandleP;
		msgh_simple = FALSE;
	}

	OutP->filehandleType.msgtl_number = filehandleCnt;
	OutP->Head.msgh_size = 44 + ((OutP->filehandleType.msgtl_header.msgt_inline) ? filehandleCnt + 3 & ~3 : sizeof(char *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine dir_pathtrans */
mig_internal novalue _Xdir_pathtrans
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pathnameType;
		string_t pathname;
		mach_msg_type_t flagsType;
		int flags;
		mach_msg_type_t modeType;
		mode_t mode;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t do_retryType;
		retry_type do_retry;
		mach_msg_type_t retry_nameType;
		string_t retry_name;
		mach_msg_type_t resultType;
		file_t result;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t dir_pathtrans
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t start_dir, string_t pathname, int flags, mode_t mode, retry_type *do_retry, string_t retry_name, protid_t *result);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pathnameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t flagsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t modeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t do_retryType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t retry_nameType = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t resultType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t start_dir;
	protid_t result;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 1068) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pathnameType != * (int *) &pathnameCheck)
#else	UseStaticMsgType
	if ((In0P->pathnameType.msgt_inline != TRUE) ||
	    (In0P->pathnameType.msgt_longform != FALSE) ||
	    (In0P->pathnameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (In0P->pathnameType.msgt_number != 1024) ||
	    (In0P->pathnameType.msgt_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flagsType != * (int *) &flagsCheck)
#else	UseStaticMsgType
	if ((In0P->flagsType.msgt_inline != TRUE) ||
	    (In0P->flagsType.msgt_longform != FALSE) ||
	    (In0P->flagsType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->flagsType.msgt_number != 1) ||
	    (In0P->flagsType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->modeType != * (int *) &modeCheck)
#else	UseStaticMsgType
	if ((In0P->modeType.msgt_inline != TRUE) ||
	    (In0P->modeType.msgt_longform != FALSE) ||
	    (In0P->modeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->modeType.msgt_number != 1) ||
	    (In0P->modeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	start_dir = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = dir_pathtrans(start_dir, In0P->pathname, In0P->flags, In0P->mode, &OutP->do_retry, OutP->retry_name, &result);
	release_protidport(start_dir);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 1076;

#if	UseStaticMsgType
	OutP->do_retryType = do_retryType;
#else	UseStaticMsgType
	OutP->do_retryType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->do_retryType.msgt_size = 32;
	OutP->do_retryType.msgt_number = 1;
	OutP->do_retryType.msgt_inline = TRUE;
	OutP->do_retryType.msgt_longform = FALSE;
	OutP->do_retryType.msgt_deallocate = FALSE;
	OutP->do_retryType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->retry_nameType = retry_nameType;
#else	UseStaticMsgType
	OutP->retry_nameType.msgt_name = MACH_MSG_TYPE_STRING_C;
	OutP->retry_nameType.msgt_size = 8;
	OutP->retry_nameType.msgt_number = 1024;
	OutP->retry_nameType.msgt_inline = TRUE;
	OutP->retry_nameType.msgt_longform = FALSE;
	OutP->retry_nameType.msgt_deallocate = FALSE;
	OutP->retry_nameType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->resultType = resultType;
#else	UseStaticMsgType
	OutP->resultType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	OutP->resultType.msgt_size = 32;
	OutP->resultType.msgt_number = 1;
	OutP->resultType.msgt_inline = TRUE;
	OutP->resultType.msgt_longform = FALSE;
	OutP->resultType.msgt_deallocate = FALSE;
	OutP->resultType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->result = convert_protid_to_port(result);
}

/* Routine dir_readdir */
mig_internal novalue _Xdir_readdir
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t offsetType;
		int offset;
		mach_msg_type_t amountType;
		int amount;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t dataType;
		char data[2048];
		mach_msg_type_t nextoffsetType;
		int nextoffset;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t dir_readdir
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t dir, data_t *data, mach_msg_type_number_t *dataCnt, int offset, int *nextoffset, int amount);
#else
		();
#endif

	boolean_t msgh_simple;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t offsetCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t amountCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t dataType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2048,
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t nextoffsetType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t dir;
	mach_msg_type_number_t dataCnt;
	int nextoffset;

	char *dataP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->offsetType != * (int *) &offsetCheck)
#else	UseStaticMsgType
	if ((In0P->offsetType.msgt_inline != TRUE) ||
	    (In0P->offsetType.msgt_longform != FALSE) ||
	    (In0P->offsetType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->offsetType.msgt_number != 1) ||
	    (In0P->offsetType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->amountType != * (int *) &amountCheck)
#else	UseStaticMsgType
	if ((In0P->amountType.msgt_inline != TRUE) ||
	    (In0P->amountType.msgt_longform != FALSE) ||
	    (In0P->amountType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->amountType.msgt_number != 1) ||
	    (In0P->amountType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	dir = convert_port_to_protid(In0P->Head.msgh_request_port);

	dataP = OutP->data;
	dataCnt = 2048;

	OutP->RetCode = dir_readdir(dir, &dataP, &dataCnt, In0P->offset, &nextoffset, In0P->amount);
	release_protidport(dir);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->dataType = dataType;
#else	UseStaticMsgType
	OutP->dataType.msgtl_name = MACH_MSG_TYPE_CHAR;
	OutP->dataType.msgtl_size = 8;
	OutP->dataType.msgtl_header.msgt_name = 0;
	OutP->dataType.msgtl_header.msgt_size = 0;
	OutP->dataType.msgtl_header.msgt_number = 0;
	OutP->dataType.msgtl_header.msgt_inline = TRUE;
	OutP->dataType.msgtl_header.msgt_longform = TRUE;
	OutP->dataType.msgtl_header.msgt_deallocate = FALSE;
	OutP->dataType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (dataP != OutP->data) {
		OutP->dataType.msgtl_header.msgt_inline = FALSE;
		*((char **)OutP->data) = dataP;
		msgh_simple = FALSE;
	}

	OutP->dataType.msgtl_number = dataCnt;
	msgh_size_delta = (OutP->dataType.msgtl_header.msgt_inline) ? dataCnt + 3 & ~3 : sizeof(char *);
	OutP->Head.msgh_size = 52 + msgh_size_delta;
	OutP = (Reply *) ((char *) OutP + msgh_size_delta - 2048);

#if	UseStaticMsgType
	OutP->nextoffsetType = nextoffsetType;
#else	UseStaticMsgType
	OutP->nextoffsetType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->nextoffsetType.msgt_size = 32;
	OutP->nextoffsetType.msgt_number = 1;
	OutP->nextoffsetType.msgt_inline = TRUE;
	OutP->nextoffsetType.msgt_longform = FALSE;
	OutP->nextoffsetType.msgt_deallocate = FALSE;
	OutP->nextoffsetType.msgt_unused = 0;
#endif	UseStaticMsgType

	OutP->nextoffset = nextoffset;

	OutP = (Reply *) OutHeadP;
	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine dir_mkdir */
mig_internal novalue _Xdir_mkdir
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		string_t name;
		mach_msg_type_t modeType;
		mode_t mode;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t dir_mkdir
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t directory, string_t name, mode_t mode);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t modeCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t directory;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 1060) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nameType != * (int *) &nameCheck)
#else	UseStaticMsgType
	if ((In0P->nameType.msgt_inline != TRUE) ||
	    (In0P->nameType.msgt_longform != FALSE) ||
	    (In0P->nameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (In0P->nameType.msgt_number != 1024) ||
	    (In0P->nameType.msgt_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->modeType != * (int *) &modeCheck)
#else	UseStaticMsgType
	if ((In0P->modeType.msgt_inline != TRUE) ||
	    (In0P->modeType.msgt_longform != FALSE) ||
	    (In0P->modeType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->modeType.msgt_number != 1) ||
	    (In0P->modeType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	directory = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = dir_mkdir(directory, In0P->name, In0P->mode);
	release_protidport(directory);
}

/* Routine dir_rmdir */
mig_internal novalue _Xdir_rmdir
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		string_t name;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t dir_rmdir
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t directory, string_t name);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t directory;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 1052) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nameType != * (int *) &nameCheck)
#else	UseStaticMsgType
	if ((In0P->nameType.msgt_inline != TRUE) ||
	    (In0P->nameType.msgt_longform != FALSE) ||
	    (In0P->nameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (In0P->nameType.msgt_number != 1024) ||
	    (In0P->nameType.msgt_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	directory = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = dir_rmdir(directory, In0P->name);
	release_protidport(directory);
}

/* Routine dir_unlink */
mig_internal novalue _Xdir_unlink
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t nameType;
		string_t name;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t dir_unlink
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t directory, string_t name);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t nameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t directory;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 1052) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->nameType != * (int *) &nameCheck)
#else	UseStaticMsgType
	if ((In0P->nameType.msgt_inline != TRUE) ||
	    (In0P->nameType.msgt_longform != FALSE) ||
	    (In0P->nameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (In0P->nameType.msgt_number != 1024) ||
	    (In0P->nameType.msgt_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	directory = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = dir_unlink(directory, In0P->name);
	release_protidport(directory);
}

/* Routine dir_link */
mig_internal novalue _Xdir_link
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t newdirectoryType;
		file_t newdirectory;
		mach_msg_type_t newnameType;
		string_t newname;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t dir_link
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t oldfile, protid_t newdirectory, string_t newname);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t newdirectoryCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newnameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t oldfile;
	protid_t newdirectory;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 1060) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->newdirectoryType != * (int *) &newdirectoryCheck)
#else	UseStaticMsgType
	if ((In0P->newdirectoryType.msgt_inline != TRUE) ||
	    (In0P->newdirectoryType.msgt_longform != FALSE) ||
	    (In0P->newdirectoryType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->newdirectoryType.msgt_number != 1) ||
	    (In0P->newdirectoryType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->newnameType != * (int *) &newnameCheck)
#else	UseStaticMsgType
	if ((In0P->newnameType.msgt_inline != TRUE) ||
	    (In0P->newnameType.msgt_longform != FALSE) ||
	    (In0P->newnameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (In0P->newnameType.msgt_number != 1024) ||
	    (In0P->newnameType.msgt_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	oldfile = convert_port_to_protid(In0P->Head.msgh_request_port);

	newdirectory = convert_port_to_protid(In0P->newdirectory);

	OutP->RetCode = dir_link(oldfile, newdirectory, In0P->newname);
	release_protidport(newdirectory);
	release_protidport(oldfile);
}

/* Routine dir_rename */
mig_internal novalue _Xdir_rename
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t oldnameType;
		string_t oldname;
		mach_msg_type_t newdirectoryType;
		file_t newdirectory;
		mach_msg_type_t newnameType;
		string_t newname;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t dir_rename
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t olddirectory, string_t oldname, protid_t newdirectory, string_t newname);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t oldnameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newdirectoryCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newnameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t olddirectory;
	protid_t newdirectory;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 2088) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->oldnameType != * (int *) &oldnameCheck)
#else	UseStaticMsgType
	if ((In0P->oldnameType.msgt_inline != TRUE) ||
	    (In0P->oldnameType.msgt_longform != FALSE) ||
	    (In0P->oldnameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (In0P->oldnameType.msgt_number != 1024) ||
	    (In0P->oldnameType.msgt_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->newdirectoryType != * (int *) &newdirectoryCheck)
#else	UseStaticMsgType
	if ((In0P->newdirectoryType.msgt_inline != TRUE) ||
	    (In0P->newdirectoryType.msgt_longform != FALSE) ||
	    (In0P->newdirectoryType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->newdirectoryType.msgt_number != 1) ||
	    (In0P->newdirectoryType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->newnameType != * (int *) &newnameCheck)
#else	UseStaticMsgType
	if ((In0P->newnameType.msgt_inline != TRUE) ||
	    (In0P->newnameType.msgt_longform != FALSE) ||
	    (In0P->newnameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (In0P->newnameType.msgt_number != 1024) ||
	    (In0P->newnameType.msgt_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	olddirectory = convert_port_to_protid(In0P->Head.msgh_request_port);

	newdirectory = convert_port_to_protid(In0P->newdirectory);

	OutP->RetCode = dir_rename(olddirectory, In0P->oldname, newdirectory, In0P->newname);
	release_protidport(newdirectory);
	release_protidport(olddirectory);
}

/* Routine file_set_translator */
mig_internal novalue _Xfile_set_translator
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t flagsType;
		int flags;
		mach_msg_type_t oldtrans_flagsType;
		int oldtrans_flags;
		mach_msg_type_long_t translatorType;
		char translator[2048];
		mach_msg_type_t existingType;
		mach_port_t existing;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Request *In1P;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_set_translator
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, int flags, int oldtrans_flags, data_t translator, mach_msg_type_number_t translatorCnt, mach_port_t existing);
#else
		();
#endif

	unsigned int msgh_size;
	unsigned int msgh_size_delta;

#if	UseStaticMsgType
	static mach_msg_type_t flagsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t oldtrans_flagsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t existingCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t file;

#if	TypeCheck
	msgh_size = In0P->Head.msgh_size;
	if ((msgh_size < 60) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->flagsType != * (int *) &flagsCheck)
#else	UseStaticMsgType
	if ((In0P->flagsType.msgt_inline != TRUE) ||
	    (In0P->flagsType.msgt_longform != FALSE) ||
	    (In0P->flagsType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->flagsType.msgt_number != 1) ||
	    (In0P->flagsType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->oldtrans_flagsType != * (int *) &oldtrans_flagsCheck)
#else	UseStaticMsgType
	if ((In0P->oldtrans_flagsType.msgt_inline != TRUE) ||
	    (In0P->oldtrans_flagsType.msgt_longform != FALSE) ||
	    (In0P->oldtrans_flagsType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->oldtrans_flagsType.msgt_number != 1) ||
	    (In0P->oldtrans_flagsType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
	if ((In0P->translatorType.msgtl_header.msgt_longform != TRUE) ||
	    (In0P->translatorType.msgtl_name != MACH_MSG_TYPE_CHAR) ||
	    (In0P->translatorType.msgtl_size != 8))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	msgh_size_delta = (In0P->translatorType.msgtl_header.msgt_inline) ? In0P->translatorType.msgtl_number + 3 & ~3 : sizeof(char *);
#if	TypeCheck
	if (msgh_size != 60 + msgh_size_delta)
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	In1P = (Request *) ((char *) In0P + msgh_size_delta - 2048);

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In1P->existingType != * (int *) &existingCheck)
#else	UseStaticMsgType
	if ((In1P->existingType.msgt_inline != TRUE) ||
	    (In1P->existingType.msgt_longform != FALSE) ||
	    (In1P->existingType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In1P->existingType.msgt_number != 1) ||
	    (In1P->existingType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_set_translator(file, In0P->flags, In0P->oldtrans_flags, (In0P->translatorType.msgtl_header.msgt_inline) ? In0P->translator : *((char **)In0P->translator), In0P->translatorType.msgtl_number, In1P->existing);
	if (!In0P->translatorType.msgtl_header.msgt_inline)
		mig_deallocate(*(char **)In0P->translator,  In0P->translatorType.msgtl_number);
	release_protidport(file);
}

/* Routine file_get_translator */
mig_internal novalue _Xfile_get_translator
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t translatorType;
		char translator[2048];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_get_translator
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, data_t *translator, mach_msg_type_number_t *translatorCnt);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_long_t translatorType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_CHAR,
		/* msgtl_size = */	8,
		/* msgtl_number = */	2048,
	};
#endif	UseStaticMsgType

	protid_t file;
	mach_msg_type_number_t translatorCnt;

	char *translatorP;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	translatorP = OutP->translator;
	translatorCnt = 2048;

	OutP->RetCode = file_get_translator(file, &translatorP, &translatorCnt);
	release_protidport(file);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->translatorType = translatorType;
#else	UseStaticMsgType
	OutP->translatorType.msgtl_name = MACH_MSG_TYPE_CHAR;
	OutP->translatorType.msgtl_size = 8;
	OutP->translatorType.msgtl_header.msgt_name = 0;
	OutP->translatorType.msgtl_header.msgt_size = 0;
	OutP->translatorType.msgtl_header.msgt_number = 0;
	OutP->translatorType.msgtl_header.msgt_inline = TRUE;
	OutP->translatorType.msgtl_header.msgt_longform = TRUE;
	OutP->translatorType.msgtl_header.msgt_deallocate = FALSE;
	OutP->translatorType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (translatorP != OutP->translator) {
		OutP->translatorType.msgtl_header.msgt_inline = FALSE;
		*((char **)OutP->translator) = translatorP;
		msgh_simple = FALSE;
	}

	OutP->translatorType.msgtl_number = translatorCnt;
	OutP->Head.msgh_size = 44 + ((OutP->translatorType.msgtl_header.msgt_inline) ? translatorCnt + 3 & ~3 : sizeof(char *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine file_get_translator_cntl */
mig_internal novalue _Xfile_get_translator_cntl
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t translator_cntlType;
		fsys_t translator_cntl;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t file_get_translator_cntl
#if	(defined(__STDC__) || defined(c_plusplus))
		(protid_t file, fsys_t *translator_cntl);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t translator_cntlType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	protid_t file;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	file = convert_port_to_protid(In0P->Head.msgh_request_port);

	OutP->RetCode = file_get_translator_cntl(file, &OutP->translator_cntl);
	release_protidport(file);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->translator_cntlType = translator_cntlType;
#else	UseStaticMsgType
	OutP->translator_cntlType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	OutP->translator_cntlType.msgt_size = 32;
	OutP->translator_cntlType.msgt_number = 1;
	OutP->translator_cntlType.msgt_inline = TRUE;
	OutP->translator_cntlType.msgt_longform = FALSE;
	OutP->translator_cntlType.msgt_deallocate = FALSE;
	OutP->translator_cntlType.msgt_unused = 0;
#endif	UseStaticMsgType
}

static mig_routine_t fs_server_routines[] = {
		_Xfile_exec,
		_Xfile_chown,
		_Xfile_chauthor,
		_Xfile_chmod,
		_Xfile_chflags,
		_Xfile_utimes,
		_Xfile_seek,
		_Xfile_truncate,
		_Xfile_lock,
		_Xfile_lock_stat,
		_Xfile_getcontrol,
		_Xfile_statfs,
		_Xfile_sync,
		_Xfile_syncfs,
		_Xfile_pathconf,
		_Xfile_getlinknode,
		_Xfile_getfh,
		_Xdir_pathtrans,
		_Xdir_readdir,
		_Xdir_mkdir,
		_Xdir_rmdir,
		_Xdir_unlink,
		_Xdir_link,
		_Xdir_rename,
		_Xfile_set_translator,
		_Xfile_get_translator,
		_Xfile_get_translator_cntl,
};

mig_external boolean_t fs_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	register mig_routine_t routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 20026) || (InP->msgh_id < 20000) ||
	    ((routine = fs_server_routines[InP->msgh_id - 20000]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}

mig_external mig_routine_t fs_server_routine
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP)
#else
	(InHeadP)
	mach_msg_header_t *InHeadP;
#endif
{
	register int msgh_id;

	msgh_id = InHeadP->msgh_id - 20000;

	if ((msgh_id > 26) || (msgh_id < 0))
		return 0;

	return fs_server_routines[msgh_id];
}

