#ifndef	_io
#define	_io

/* Module io */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#ifdef	mig_external
mig_external
#else
extern
#endif
void init_io
#if	(defined(__STDC__) || defined(c_plusplus))
    (mach_port_t rep_port);
#else
    ();
#endif
#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>

/* Routine io_write_inband */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_write_inband
#if	defined(LINTLIBRARY)
    (io_object, terminfo, data, dataCnt, offset, amount)
	io_t io_object;
	term_io_data_t terminfo;
	inband_data_t data;
	mach_msg_type_number_t dataCnt;
	int offset;
	int *amount;
{ return io_write_inband(io_object, terminfo, data, dataCnt, offset, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	term_io_data_t terminfo,
	inband_data_t data,
	mach_msg_type_number_t dataCnt,
	int offset,
	int *amount
);
#else
    ();
#endif
#endif

/* Routine io_write_outofband */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_write_outofband
#if	defined(LINTLIBRARY)
    (io_object, terminfo, data, dataCnt, offset, amount)
	io_t io_object;
	term_io_data_t terminfo;
	outofband_data_t data;
	mach_msg_type_number_t dataCnt;
	int offset;
	int *amount;
{ return io_write_outofband(io_object, terminfo, data, dataCnt, offset, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	term_io_data_t terminfo,
	outofband_data_t data,
	mach_msg_type_number_t dataCnt,
	int offset,
	int *amount
);
#else
    ();
#endif
#endif

/* Routine io_read_inband */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_read_inband
#if	defined(LINTLIBRARY)
    (io_object, terminfo, data, dataCnt, offset, amount)
	io_t io_object;
	term_io_data_t terminfo;
	inband_data_t data;
	mach_msg_type_number_t *dataCnt;
	int offset;
	int amount;
{ return io_read_inband(io_object, terminfo, data, dataCnt, offset, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	term_io_data_t terminfo,
	inband_data_t data,
	mach_msg_type_number_t *dataCnt,
	int offset,
	int amount
);
#else
    ();
#endif
#endif

/* Routine io_read_outofband */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_read_outofband
#if	defined(LINTLIBRARY)
    (io_object, terminfo, data, dataCnt, offset, amount)
	io_t io_object;
	term_io_data_t terminfo;
	outofband_data_t *data;
	mach_msg_type_number_t *dataCnt;
	int offset;
	int amount;
{ return io_read_outofband(io_object, terminfo, data, dataCnt, offset, amount); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	term_io_data_t terminfo,
	outofband_data_t *data,
	mach_msg_type_number_t *dataCnt,
	int offset,
	int amount
);
#else
    ();
#endif
#endif

/* Routine io_ioctl_x */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_ioctl_x
#if	defined(LINTLIBRARY)
    (io_object, terminfo, ioctl_code)
	io_t io_object;
	term_io_data_t terminfo;
	int ioctl_code;
{ return io_ioctl_x(io_object, terminfo, ioctl_code); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	term_io_data_t terminfo,
	int ioctl_code
);
#else
    ();
#endif
#endif

/* Routine io_ioctl_r */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_ioctl_r
#if	defined(LINTLIBRARY)
    (io_object, terminfo, ioctl_code, data, dataCnt)
	io_t io_object;
	term_io_data_t terminfo;
	int ioctl_code;
	ioctl_data_t data;
	mach_msg_type_number_t *dataCnt;
{ return io_ioctl_r(io_object, terminfo, ioctl_code, data, dataCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	term_io_data_t terminfo,
	int ioctl_code,
	ioctl_data_t data,
	mach_msg_type_number_t *dataCnt
);
#else
    ();
#endif
#endif

/* Routine io_ioctl_w */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_ioctl_w
#if	defined(LINTLIBRARY)
    (io_object, terminfo, ioctl_code, data, dataCnt)
	io_t io_object;
	term_io_data_t terminfo;
	int ioctl_code;
	ioctl_data_t data;
	mach_msg_type_number_t dataCnt;
{ return io_ioctl_w(io_object, terminfo, ioctl_code, data, dataCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	term_io_data_t terminfo,
	int ioctl_code,
	ioctl_data_t data,
	mach_msg_type_number_t dataCnt
);
#else
    ();
#endif
#endif

/* Routine io_ioctl_rw */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_ioctl_rw
#if	defined(LINTLIBRARY)
    (io_object, terminfo, ioctl_code, ioctl_data_in, ioctl_data_inCnt, ioctl_data_out, ioctl_data_outCnt)
	io_t io_object;
	term_io_data_t terminfo;
	int ioctl_code;
	ioctl_data_t ioctl_data_in;
	mach_msg_type_number_t ioctl_data_inCnt;
	ioctl_data_t ioctl_data_out;
	mach_msg_type_number_t *ioctl_data_outCnt;
{ return io_ioctl_rw(io_object, terminfo, ioctl_code, ioctl_data_in, ioctl_data_inCnt, ioctl_data_out, ioctl_data_outCnt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	term_io_data_t terminfo,
	int ioctl_code,
	ioctl_data_t ioctl_data_in,
	mach_msg_type_number_t ioctl_data_inCnt,
	ioctl_data_t ioctl_data_out,
	mach_msg_type_number_t *ioctl_data_outCnt
);
#else
    ();
#endif
#endif

/* Routine io_set_flags */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_set_flags
#if	defined(LINTLIBRARY)
    (own_io, io_flags)
	io_t own_io;
	int io_flags;
{ return io_set_flags(own_io, io_flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t own_io,
	int io_flags
);
#else
    ();
#endif
#endif

/* Routine io_get_flags */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_flags
#if	defined(LINTLIBRARY)
    (own_io, io_flags)
	io_t own_io;
	int *io_flags;
{ return io_get_flags(own_io, io_flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t own_io,
	int *io_flags
);
#else
    ();
#endif
#endif

/* Routine io_select */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_select
#if	defined(LINTLIBRARY)
    (io_object, select_type, return_port, id_tag, select_result)
	io_t io_object;
	int select_type;
	mach_port_t return_port;
	int id_tag;
	int *select_result;
{ return io_select(io_object, select_type, return_port, id_tag, select_result); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	int select_type,
	mach_port_t return_port,
	int id_tag,
	int *select_result
);
#else
    ();
#endif
#endif

/* Routine io_stat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_stat
#if	defined(LINTLIBRARY)
    (stat_object, stat_info)
	io_t stat_object;
	io_statbuf_t *stat_info;
{ return io_stat(stat_object, stat_info); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t stat_object,
	io_statbuf_t *stat_info
);
#else
    ();
#endif
#endif

/* SimpleRoutine io_reauthenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_reauthenticate
#if	defined(LINTLIBRARY)
    (auth_object)
	io_t auth_object;
{ return io_reauthenticate(auth_object); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t auth_object
);
#else
    ();
#endif
#endif

/* Routine io_map */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_map
#if	defined(LINTLIBRARY)
    (io_object, memobjxx, memobjrd, memobjwt)
	io_t io_object;
	mach_port_t *memobjxx;
	mach_port_t *memobjrd;
	mach_port_t *memobjwt;
{ return io_map(io_object, memobjxx, memobjrd, memobjwt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	mach_port_t *memobjxx,
	mach_port_t *memobjrd,
	mach_port_t *memobjwt
);
#else
    ();
#endif
#endif

/* Routine io_map_cntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_map_cntl
#if	defined(LINTLIBRARY)
    (io_object, memobjxx, memobjrd, memobjwt)
	io_t io_object;
	memory_object_t *memobjxx;
	memory_object_t *memobjrd;
	memory_object_t *memobjwt;
{ return io_map_cntl(io_object, memobjxx, memobjrd, memobjwt); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	memory_object_t *memobjxx,
	memory_object_t *memobjrd,
	memory_object_t *memobjwt
);
#else
    ();
#endif
#endif

/* Routine io_get_it */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_it
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	memory_object_t cntl;
{ return io_get_it(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	memory_object_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_release_it */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_release_it
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	memory_object_t cntl;
{ return io_release_it(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	memory_object_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_eofnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_eofnotify
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	memory_object_t cntl;
{ return io_eofnotify(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	memory_object_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_prenotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_prenotify
#if	defined(LINTLIBRARY)
    (io_object, cntl, write_start, write_end)
	io_t io_object;
	memory_object_t cntl;
	int write_start;
	int write_end;
{ return io_prenotify(io_object, cntl, write_start, write_end); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	memory_object_t cntl,
	int write_start,
	int write_end
);
#else
    ();
#endif
#endif

/* Routine io_postnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_postnotify
#if	defined(LINTLIBRARY)
    (io_object, cntl, write_start, write_end)
	io_t io_object;
	memory_object_t cntl;
	int write_start;
	int write_end;
{ return io_postnotify(io_object, cntl, write_start, write_end); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	memory_object_t cntl,
	int write_start,
	int write_end
);
#else
    ();
#endif
#endif

/* Routine io_readsleep */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_readsleep
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	memory_object_t cntl;
{ return io_readsleep(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	memory_object_t cntl
);
#else
    ();
#endif
#endif

/* Routine io_sigio */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_sigio
#if	defined(LINTLIBRARY)
    (io_object, cntl)
	io_t io_object;
	memory_object_t cntl;
{ return io_sigio(io_object, cntl); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	io_t io_object,
	memory_object_t cntl
);
#else
    ();
#endif
#endif

#endif	_io
