/* Definitions for hurd library
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include <mach.h>
#include <hurd/hurd_types.h>
#include <machine/lib_machdep.h>
#include <cthreads.h>
#include <lib/ldfmt.h>

void printf (char *, ...);
volatile void panic (char *);
volatile void panic_with_error (char *, int);
char *mach_error_string (error_t);
void set_console_port (mach_port_t);
void insque (void *, void *);
void remque (void *);
int bcmp (void *, void *, long);
volatile void assert_failed (char *, int);
int scanc (u_int, u_char *, u_char *, u_char);
int skpc (u_char, u_int, u_char *);
int locc (u_char, u_int, u_char *);
int ffs (int);
int setjmp (jmp_buf *);
void longjmp (jmp_buf *, int);
int atoi (char *);

/* Machine dependent routines for exec: */
error_t exec_read_header (void *, struct loader_info *);
void exec_setargs (task_t, char *, u_int, char *, u_int, int, int, int *);
void exec_setregs (thread_t, int, int, int);

/* Filesystem-provided routines for exec: */
void handle_exec_map (void *, memory_object_t *);
error_t handle_exec_read (void *, int, void *, int);

/* This is in libthreads, but not in the header */
void *malloc (long);
void free (void *);
void *realloc (void *, int);

/* These libmach_sa functions are missing from the headers. */
void bcopy (void *, void *, long);
void bzero (void *, long);
void mig_deallocate (char *, u_int);

#define assert(n) ((void)({ if (!(n)) assert_failed (__FILE__, __LINE__);}))
