/* Machine dependent header information and macros for UFS
   Copyright (C) 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include <cthreads.h>

#define catch_exception() \
  ({									    \
    struct thread_stuff *tmp;						    \
    tmp = __builtin_alloca (sizeof (struct thread_stuff));		    \
    tmp->link = (struct thread_stuff *)cthread_data (cthread_self ());	    \
    cthread_set_data (cthread_self (), (any_t)tmp);			    \
    setjmp (tmp->buf);							    \
  })

#define end_catch_exception() \
  (void) ({								    \
    struct thread_stuff *tmp;						    \
    tmp = (struct thread_stuff *)cthread_data (cthread_self ());	    \
    (void) cthread_set_data (cthread_self (), (any_t)tmp->link);	    \
  })									    \
