/*
   Copyright (C) 1992 Free Software Foundation, Inc.

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Roland McGrath.  */

#include <mach.h>
#include <string.h>

extern fsys_t tfs_translator_cntl;

tfs_file_get_translator_cntl (mach_port_t file, fsys_t *cntl)
{
  if (!tfs_authorized (file))
    return EPERM;
  *cntl = tfs_translator_cntl;
  return 0;
}
