/* Module process */

#define EXPORT_BOOLEAN
#include <mach/boolean.h>
#include <mach/kern_return.h>
#include <mach/message.h>
#include <mach/mig_errors.h>

#ifndef	mig_internal
#define	mig_internal	static
#endif

#ifndef	mig_external
#define mig_external
#endif

#ifndef	TypeCheck
#define	TypeCheck 1
#endif

#ifndef	UseExternRCSId
#ifdef	hc
#define	UseExternRCSId		1
#endif
#endif

#ifndef	UseStaticMsgType
#if	!defined(hc) || defined(__STDC__)
#define	UseStaticMsgType	1
#endif
#endif

/* Due to pcc compiler bug, cannot use void */
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(hc)
#define novalue void
#else
#define novalue int
#endif

#define msgh_request_port	msgh_local_port
#define MACH_MSGH_BITS_REQUEST(bits)	MACH_MSGH_BITS_LOCAL(bits)
#define msgh_reply_port		msgh_remote_port
#define MACH_MSGH_BITS_REPLY(bits)	MACH_MSGH_BITS_REMOTE(bits)

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>
#include <lib/libhurd.h>
#include "proc.h"

/* Routine proc_sethostid */
mig_internal novalue _Xproc_sethostid
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t hostidType;
		int hostid;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_sethostid
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, int hostid);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t hostidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->hostidType != * (int *) &hostidCheck)
#else	UseStaticMsgType
	if ((In0P->hostidType.msgt_inline != TRUE) ||
	    (In0P->hostidType.msgt_longform != FALSE) ||
	    (In0P->hostidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->hostidType.msgt_number != 1) ||
	    (In0P->hostidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_sethostid(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->hostid);
}

/* Routine proc_gethostid */
mig_internal novalue _Xproc_gethostid
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t hostidType;
		int hostid;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_gethostid
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, int *hostid);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t hostidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_gethostid(convert_port_to_pstruct(In0P->Head.msgh_request_port), &OutP->hostid);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->hostidType = hostidType;
#else	UseStaticMsgType
	OutP->hostidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->hostidType.msgt_size = 32;
	OutP->hostidType.msgt_number = 1;
	OutP->hostidType.msgt_inline = TRUE;
	OutP->hostidType.msgt_longform = FALSE;
	OutP->hostidType.msgt_deallocate = FALSE;
	OutP->hostidType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_sethostname */
mig_internal novalue _Xproc_sethostname
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t hostnameType;
		string_t hostname;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_sethostname
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, string_t hostname);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t hostnameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 1052) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->hostnameType != * (int *) &hostnameCheck)
#else	UseStaticMsgType
	if ((In0P->hostnameType.msgt_inline != TRUE) ||
	    (In0P->hostnameType.msgt_longform != FALSE) ||
	    (In0P->hostnameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (In0P->hostnameType.msgt_number != 1024) ||
	    (In0P->hostnameType.msgt_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_sethostname(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->hostname);
}

/* Routine proc_gethostname */
mig_internal novalue _Xproc_gethostname
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t hostnameType;
		string_t hostname;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_gethostname
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, string_t hostname);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t hostnameType = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_gethostname(convert_port_to_pstruct(In0P->Head.msgh_request_port), OutP->hostname);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 1060;

#if	UseStaticMsgType
	OutP->hostnameType = hostnameType;
#else	UseStaticMsgType
	OutP->hostnameType.msgt_name = MACH_MSG_TYPE_STRING_C;
	OutP->hostnameType.msgt_size = 8;
	OutP->hostnameType.msgt_number = 1024;
	OutP->hostnameType.msgt_inline = TRUE;
	OutP->hostnameType.msgt_longform = FALSE;
	OutP->hostnameType.msgt_deallocate = FALSE;
	OutP->hostnameType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_getpids */
mig_internal novalue _Xproc_getpids
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t pidType;
		pid_t pid;
		mach_msg_type_t ppidType;
		pid_t ppid;
		mach_msg_type_t orphanedType;
		int orphaned;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_getpids
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t *pid, pid_t *ppid, int *orphaned);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t ppidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t orphanedType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_getpids(convert_port_to_pstruct(In0P->Head.msgh_request_port), &OutP->pid, &OutP->ppid, &OutP->orphaned);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 56;

#if	UseStaticMsgType
	OutP->pidType = pidType;
#else	UseStaticMsgType
	OutP->pidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->pidType.msgt_size = 32;
	OutP->pidType.msgt_number = 1;
	OutP->pidType.msgt_inline = TRUE;
	OutP->pidType.msgt_longform = FALSE;
	OutP->pidType.msgt_deallocate = FALSE;
	OutP->pidType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->ppidType = ppidType;
#else	UseStaticMsgType
	OutP->ppidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->ppidType.msgt_size = 32;
	OutP->ppidType.msgt_number = 1;
	OutP->ppidType.msgt_inline = TRUE;
	OutP->ppidType.msgt_longform = FALSE;
	OutP->ppidType.msgt_deallocate = FALSE;
	OutP->ppidType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->orphanedType = orphanedType;
#else	UseStaticMsgType
	OutP->orphanedType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->orphanedType.msgt_size = 32;
	OutP->orphanedType.msgt_number = 1;
	OutP->orphanedType.msgt_inline = TRUE;
	OutP->orphanedType.msgt_longform = FALSE;
	OutP->orphanedType.msgt_deallocate = FALSE;
	OutP->orphanedType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* SimpleRoutine proc_reauthenticate */
mig_internal novalue _Xproc_reauthenticate
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_reauthenticate
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_reauthenticate(convert_port_to_pstruct(In0P->Head.msgh_request_port));
}

/* Routine proc_register */
mig_internal novalue _Xproc_register
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t proc_taskType;
		mach_port_t proc_task;
		mach_msg_type_t sigportType;
		sigthread_t sigport;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t new_processType;
		mach_port_t new_process;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_register
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t old_process, mach_port_t proc_task, sigthread_t sigport, mach_port_t *new_process);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t proc_taskCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t sigportCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t new_processType = {
		/* msgt_name = */		MACH_MSG_TYPE_MAKE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->proc_taskType != * (int *) &proc_taskCheck)
#else	UseStaticMsgType
	if ((In0P->proc_taskType.msgt_inline != TRUE) ||
	    (In0P->proc_taskType.msgt_longform != FALSE) ||
	    (In0P->proc_taskType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->proc_taskType.msgt_number != 1) ||
	    (In0P->proc_taskType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->sigportType != * (int *) &sigportCheck)
#else	UseStaticMsgType
	if ((In0P->sigportType.msgt_inline != TRUE) ||
	    (In0P->sigportType.msgt_longform != FALSE) ||
	    (In0P->sigportType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->sigportType.msgt_number != 1) ||
	    (In0P->sigportType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_register(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->proc_task, In0P->sigport, &OutP->new_process);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->new_processType = new_processType;
#else	UseStaticMsgType
	OutP->new_processType.msgt_name = MACH_MSG_TYPE_MAKE_SEND;
	OutP->new_processType.msgt_size = 32;
	OutP->new_processType.msgt_number = 1;
	OutP->new_processType.msgt_inline = TRUE;
	OutP->new_processType.msgt_longform = FALSE;
	OutP->new_processType.msgt_deallocate = FALSE;
	OutP->new_processType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_setports */
mig_internal novalue _Xproc_setports
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pidType;
		pid_t pid;
		mach_msg_type_t newsigportType;
		sigthread_t newsigport;
		mach_msg_type_t newtaskportType;
		mach_port_t newtaskport;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t oldsigportType;
		mach_port_t oldsigport;
		mach_msg_type_t oldtaskportType;
		mach_port_t oldtaskport;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_setports
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t pid, sigthread_t newsigport, mach_port_t newtaskport, mach_port_t *oldsigport, mach_port_t *oldtaskport);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newsigportCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t newtaskportCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t oldsigportType = {
		/* msgt_name = */		MACH_MSG_TYPE_MOVE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t oldtaskportType = {
		/* msgt_name = */		MACH_MSG_TYPE_MOVE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pidType != * (int *) &pidCheck)
#else	UseStaticMsgType
	if ((In0P->pidType.msgt_inline != TRUE) ||
	    (In0P->pidType.msgt_longform != FALSE) ||
	    (In0P->pidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pidType.msgt_number != 1) ||
	    (In0P->pidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->newsigportType != * (int *) &newsigportCheck)
#else	UseStaticMsgType
	if ((In0P->newsigportType.msgt_inline != TRUE) ||
	    (In0P->newsigportType.msgt_longform != FALSE) ||
	    (In0P->newsigportType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->newsigportType.msgt_number != 1) ||
	    (In0P->newsigportType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->newtaskportType != * (int *) &newtaskportCheck)
#else	UseStaticMsgType
	if ((In0P->newtaskportType.msgt_inline != TRUE) ||
	    (In0P->newtaskportType.msgt_longform != FALSE) ||
	    (In0P->newtaskportType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->newtaskportType.msgt_number != 1) ||
	    (In0P->newtaskportType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_setports(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->pid, In0P->newsigport, In0P->newtaskport, &OutP->oldsigport, &OutP->oldtaskport);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 48;

#if	UseStaticMsgType
	OutP->oldsigportType = oldsigportType;
#else	UseStaticMsgType
	OutP->oldsigportType.msgt_name = MACH_MSG_TYPE_MOVE_SEND;
	OutP->oldsigportType.msgt_size = 32;
	OutP->oldsigportType.msgt_number = 1;
	OutP->oldsigportType.msgt_inline = TRUE;
	OutP->oldsigportType.msgt_longform = FALSE;
	OutP->oldsigportType.msgt_deallocate = FALSE;
	OutP->oldsigportType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->oldtaskportType = oldtaskportType;
#else	UseStaticMsgType
	OutP->oldtaskportType.msgt_name = MACH_MSG_TYPE_MOVE_SEND;
	OutP->oldtaskportType.msgt_size = 32;
	OutP->oldtaskportType.msgt_number = 1;
	OutP->oldtaskportType.msgt_inline = TRUE;
	OutP->oldtaskportType.msgt_longform = FALSE;
	OutP->oldtaskportType.msgt_deallocate = FALSE;
	OutP->oldtaskportType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_kill */
mig_internal novalue _Xproc_kill
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pidType;
		pid_t pid;
		mach_msg_type_t signalType;
		int signal;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_kill
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t pid, int signal);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t signalCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pidType != * (int *) &pidCheck)
#else	UseStaticMsgType
	if ((In0P->pidType.msgt_inline != TRUE) ||
	    (In0P->pidType.msgt_longform != FALSE) ||
	    (In0P->pidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pidType.msgt_number != 1) ||
	    (In0P->pidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->signalType != * (int *) &signalCheck)
#else	UseStaticMsgType
	if ((In0P->signalType.msgt_inline != TRUE) ||
	    (In0P->signalType.msgt_longform != FALSE) ||
	    (In0P->signalType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->signalType.msgt_number != 1) ||
	    (In0P->signalType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_kill(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->pid, In0P->signal);
}

/* Routine proc_ctty_kill */
mig_internal novalue _Xproc_ctty_kill
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pidType;
		pid_t pid;
		mach_msg_type_t cttyType;
		mach_port_t ctty;
		mach_msg_type_t signalType;
		int signal;
		mach_msg_type_t stoppidType;
		int stoppid;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t willstopType;
		int willstop;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_ctty_kill
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t pid, mach_port_t ctty, int signal, int stoppid, int *willstop);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t cttyCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t signalCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t stoppidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t willstopType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 56) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pidType != * (int *) &pidCheck)
#else	UseStaticMsgType
	if ((In0P->pidType.msgt_inline != TRUE) ||
	    (In0P->pidType.msgt_longform != FALSE) ||
	    (In0P->pidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pidType.msgt_number != 1) ||
	    (In0P->pidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cttyType != * (int *) &cttyCheck)
#else	UseStaticMsgType
	if ((In0P->cttyType.msgt_inline != TRUE) ||
	    (In0P->cttyType.msgt_longform != FALSE) ||
	    (In0P->cttyType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->cttyType.msgt_number != 1) ||
	    (In0P->cttyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->signalType != * (int *) &signalCheck)
#else	UseStaticMsgType
	if ((In0P->signalType.msgt_inline != TRUE) ||
	    (In0P->signalType.msgt_longform != FALSE) ||
	    (In0P->signalType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->signalType.msgt_number != 1) ||
	    (In0P->signalType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->stoppidType != * (int *) &stoppidCheck)
#else	UseStaticMsgType
	if ((In0P->stoppidType.msgt_inline != TRUE) ||
	    (In0P->stoppidType.msgt_longform != FALSE) ||
	    (In0P->stoppidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->stoppidType.msgt_number != 1) ||
	    (In0P->stoppidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_ctty_kill(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->pid, In0P->ctty, In0P->signal, In0P->stoppid, &OutP->willstop);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->willstopType = willstopType;
#else	UseStaticMsgType
	OutP->willstopType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->willstopType.msgt_size = 32;
	OutP->willstopType.msgt_number = 1;
	OutP->willstopType.msgt_inline = TRUE;
	OutP->willstopType.msgt_longform = FALSE;
	OutP->willstopType.msgt_deallocate = FALSE;
	OutP->willstopType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_set_ctty */
mig_internal novalue _Xproc_set_ctty
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t cttyType;
		mach_port_t ctty;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_set_ctty
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, mach_port_t ctty);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t cttyCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->cttyType != * (int *) &cttyCheck)
#else	UseStaticMsgType
	if ((In0P->cttyType.msgt_inline != TRUE) ||
	    (In0P->cttyType.msgt_longform != FALSE) ||
	    (In0P->cttyType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->cttyType.msgt_number != 1) ||
	    (In0P->cttyType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_set_ctty(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->ctty);
}

/* Routine proc_wait */
mig_internal novalue _Xproc_wait
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pidType;
		pid_t pid;
		mach_msg_type_t optionsType;
		int options;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t statusType;
		int status;
		mach_msg_type_t rusageType;
		rusage_t rusage;
		mach_msg_type_t pid_statusType;
		pid_t pid_status;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_wait
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, mach_port_t reply_port, mach_msg_type_name_t reply_portPoly, pid_t pid, int *status, int options, rusage_t *rusage, pid_t *pid_status);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t optionsCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t statusType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t rusageType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		18,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pid_statusType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pidType != * (int *) &pidCheck)
#else	UseStaticMsgType
	if ((In0P->pidType.msgt_inline != TRUE) ||
	    (In0P->pidType.msgt_longform != FALSE) ||
	    (In0P->pidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pidType.msgt_number != 1) ||
	    (In0P->pidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->optionsType != * (int *) &optionsCheck)
#else	UseStaticMsgType
	if ((In0P->optionsType.msgt_inline != TRUE) ||
	    (In0P->optionsType.msgt_longform != FALSE) ||
	    (In0P->optionsType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->optionsType.msgt_number != 1) ||
	    (In0P->optionsType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_wait(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->Head.msgh_reply_port, MACH_MSGH_BITS_REPLY(In0P->Head.msgh_bits), In0P->pid, &OutP->status, In0P->options, &OutP->rusage, &OutP->pid_status);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 124;

#if	UseStaticMsgType
	OutP->statusType = statusType;
#else	UseStaticMsgType
	OutP->statusType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->statusType.msgt_size = 32;
	OutP->statusType.msgt_number = 1;
	OutP->statusType.msgt_inline = TRUE;
	OutP->statusType.msgt_longform = FALSE;
	OutP->statusType.msgt_deallocate = FALSE;
	OutP->statusType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->rusageType = rusageType;
#else	UseStaticMsgType
	OutP->rusageType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->rusageType.msgt_size = 32;
	OutP->rusageType.msgt_number = 18;
	OutP->rusageType.msgt_inline = TRUE;
	OutP->rusageType.msgt_longform = FALSE;
	OutP->rusageType.msgt_deallocate = FALSE;
	OutP->rusageType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->pid_statusType = pid_statusType;
#else	UseStaticMsgType
	OutP->pid_statusType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->pid_statusType.msgt_size = 32;
	OutP->pid_statusType.msgt_number = 1;
	OutP->pid_statusType.msgt_inline = TRUE;
	OutP->pid_statusType.msgt_longform = FALSE;
	OutP->pid_statusType.msgt_deallocate = FALSE;
	OutP->pid_statusType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_waitintr */
mig_internal novalue _Xproc_waitintr
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_waitintr
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_waitintr(convert_port_to_pstruct(In0P->Head.msgh_request_port));
}

/* Routine proc_dostop */
mig_internal novalue _Xproc_dostop
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t contthreadType;
		mach_port_t contthread;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_dostop
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, mach_port_t contthread);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t contthreadCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->contthreadType != * (int *) &contthreadCheck)
#else	UseStaticMsgType
	if ((In0P->contthreadType.msgt_inline != TRUE) ||
	    (In0P->contthreadType.msgt_longform != FALSE) ||
	    (In0P->contthreadType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->contthreadType.msgt_number != 1) ||
	    (In0P->contthreadType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_dostop(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->contthread);
}

/* Routine proc_markstop */
mig_internal novalue _Xproc_markstop
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t signoType;
		int signo;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_markstop
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, int signo);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t signoCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->signoType != * (int *) &signoCheck)
#else	UseStaticMsgType
	if ((In0P->signoType.msgt_inline != TRUE) ||
	    (In0P->signoType.msgt_longform != FALSE) ||
	    (In0P->signoType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->signoType.msgt_number != 1) ||
	    (In0P->signoType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_markstop(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->signo);
}

/* Routine proc_cont */
mig_internal novalue _Xproc_cont
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_cont
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_cont(convert_port_to_pstruct(In0P->Head.msgh_request_port));
}

/* Routine proc_exit */
mig_internal novalue _Xproc_exit
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t statusType;
		int status;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_exit
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, int status);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t statusCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->statusType != * (int *) &statusCheck)
#else	UseStaticMsgType
	if ((In0P->statusType.msgt_inline != TRUE) ||
	    (In0P->statusType.msgt_longform != FALSE) ||
	    (In0P->statusType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->statusType.msgt_number != 1) ||
	    (In0P->statusType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_exit(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->status);
}

/* Routine proc_mark_exec */
mig_internal novalue _Xproc_mark_exec
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_mark_exec
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_mark_exec(convert_port_to_pstruct(In0P->Head.msgh_request_port));
}

/* Routine proc_mark_traced */
mig_internal novalue _Xproc_mark_traced
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_mark_traced
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_mark_traced(convert_port_to_pstruct(In0P->Head.msgh_request_port));
}

/* Routine proc_mark_system */
mig_internal novalue _Xproc_mark_system
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_mark_system
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_mark_system(convert_port_to_pstruct(In0P->Head.msgh_request_port));
}

/* Routine proc_mark_nostopchild */
mig_internal novalue _Xproc_mark_nostopchild
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t doitType;
		int doit;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_mark_nostopchild
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, int doit);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t doitCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->doitType != * (int *) &doitCheck)
#else	UseStaticMsgType
	if ((In0P->doitType.msgt_inline != TRUE) ||
	    (In0P->doitType.msgt_longform != FALSE) ||
	    (In0P->doitType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->doitType.msgt_number != 1) ||
	    (In0P->doitType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_mark_nostopchild(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->doit);
}

/* Routine proc_setsid */
mig_internal novalue _Xproc_setsid
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_setsid
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process);
#else
		();
#endif

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_setsid(convert_port_to_pstruct(In0P->Head.msgh_request_port));
}

/* Routine proc_setpgrp */
mig_internal novalue _Xproc_setpgrp
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pidType;
		pid_t pid;
		mach_msg_type_t pgrpType;
		pid_t pgrp;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_setpgrp
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t pid, pid_t pgrp);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pidType != * (int *) &pidCheck)
#else	UseStaticMsgType
	if ((In0P->pidType.msgt_inline != TRUE) ||
	    (In0P->pidType.msgt_longform != FALSE) ||
	    (In0P->pidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pidType.msgt_number != 1) ||
	    (In0P->pidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pgrpType != * (int *) &pgrpCheck)
#else	UseStaticMsgType
	if ((In0P->pgrpType.msgt_inline != TRUE) ||
	    (In0P->pgrpType.msgt_longform != FALSE) ||
	    (In0P->pgrpType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pgrpType.msgt_number != 1) ||
	    (In0P->pgrpType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_setpgrp(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->pid, In0P->pgrp);
}

/* Routine proc_getpgrp */
mig_internal novalue _Xproc_getpgrp
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pidType;
		pid_t pid;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t pgrpType;
		pid_t pgrp;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_getpgrp
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t pid, pid_t *pgrp);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pgrpType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pidType != * (int *) &pidCheck)
#else	UseStaticMsgType
	if ((In0P->pidType.msgt_inline != TRUE) ||
	    (In0P->pidType.msgt_longform != FALSE) ||
	    (In0P->pidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pidType.msgt_number != 1) ||
	    (In0P->pidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_getpgrp(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->pid, &OutP->pgrp);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->pgrpType = pgrpType;
#else	UseStaticMsgType
	OutP->pgrpType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->pgrpType.msgt_size = 32;
	OutP->pgrpType.msgt_number = 1;
	OutP->pgrpType.msgt_inline = TRUE;
	OutP->pgrpType.msgt_longform = FALSE;
	OutP->pgrpType.msgt_deallocate = FALSE;
	OutP->pgrpType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_version */
mig_internal novalue _Xproc_version
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t whichType;
		int which;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t dataType;
		string_t data;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_version
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, int which, string_t data);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t whichCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t dataType = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whichType != * (int *) &whichCheck)
#else	UseStaticMsgType
	if ((In0P->whichType.msgt_inline != TRUE) ||
	    (In0P->whichType.msgt_longform != FALSE) ||
	    (In0P->whichType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->whichType.msgt_number != 1) ||
	    (In0P->whichType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_version(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->which, OutP->data);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 1060;

#if	UseStaticMsgType
	OutP->dataType = dataType;
#else	UseStaticMsgType
	OutP->dataType.msgt_name = MACH_MSG_TYPE_STRING_C;
	OutP->dataType.msgt_size = 8;
	OutP->dataType.msgt_number = 1024;
	OutP->dataType.msgt_inline = TRUE;
	OutP->dataType.msgt_longform = FALSE;
	OutP->dataType.msgt_deallocate = FALSE;
	OutP->dataType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_getrusage */
mig_internal novalue _Xproc_getrusage
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pidType;
		pid_t pid;
		mach_msg_type_t kindType;
		int kind;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t rusageType;
		rusage_t rusage;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_getrusage
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t pid, int kind, rusage_t *rusage);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t kindCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t rusageType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		18,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pidType != * (int *) &pidCheck)
#else	UseStaticMsgType
	if ((In0P->pidType.msgt_inline != TRUE) ||
	    (In0P->pidType.msgt_longform != FALSE) ||
	    (In0P->pidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pidType.msgt_number != 1) ||
	    (In0P->pidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->kindType != * (int *) &kindCheck)
#else	UseStaticMsgType
	if ((In0P->kindType.msgt_inline != TRUE) ||
	    (In0P->kindType.msgt_longform != FALSE) ||
	    (In0P->kindType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->kindType.msgt_number != 1) ||
	    (In0P->kindType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_getrusage(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->pid, In0P->kind, &OutP->rusage);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 108;

#if	UseStaticMsgType
	OutP->rusageType = rusageType;
#else	UseStaticMsgType
	OutP->rusageType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->rusageType.msgt_size = 32;
	OutP->rusageType.msgt_number = 18;
	OutP->rusageType.msgt_inline = TRUE;
	OutP->rusageType.msgt_longform = FALSE;
	OutP->rusageType.msgt_deallocate = FALSE;
	OutP->rusageType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_setpriority */
mig_internal novalue _Xproc_setpriority
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t whichType;
		int which;
		mach_msg_type_t whoType;
		int who;
		mach_msg_type_t prioType;
		int prio;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_setpriority
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, int which, int who, int prio);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t whichCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t whoCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t prioCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 48) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whichType != * (int *) &whichCheck)
#else	UseStaticMsgType
	if ((In0P->whichType.msgt_inline != TRUE) ||
	    (In0P->whichType.msgt_longform != FALSE) ||
	    (In0P->whichType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->whichType.msgt_number != 1) ||
	    (In0P->whichType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whoType != * (int *) &whoCheck)
#else	UseStaticMsgType
	if ((In0P->whoType.msgt_inline != TRUE) ||
	    (In0P->whoType.msgt_longform != FALSE) ||
	    (In0P->whoType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->whoType.msgt_number != 1) ||
	    (In0P->whoType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->prioType != * (int *) &prioCheck)
#else	UseStaticMsgType
	if ((In0P->prioType.msgt_inline != TRUE) ||
	    (In0P->prioType.msgt_longform != FALSE) ||
	    (In0P->prioType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->prioType.msgt_number != 1) ||
	    (In0P->prioType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_setpriority(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->which, In0P->who, In0P->prio);
}

/* Routine proc_getpriority */
mig_internal novalue _Xproc_getpriority
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t whichType;
		int which;
		mach_msg_type_t whoType;
		int who;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t prioType;
		int prio;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_getpriority
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, int which, int who, int *prio);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t whichCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t whoCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t prioType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whichType != * (int *) &whichCheck)
#else	UseStaticMsgType
	if ((In0P->whichType.msgt_inline != TRUE) ||
	    (In0P->whichType.msgt_longform != FALSE) ||
	    (In0P->whichType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->whichType.msgt_number != 1) ||
	    (In0P->whichType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whoType != * (int *) &whoCheck)
#else	UseStaticMsgType
	if ((In0P->whoType.msgt_inline != TRUE) ||
	    (In0P->whoType.msgt_longform != FALSE) ||
	    (In0P->whoType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->whoType.msgt_number != 1) ||
	    (In0P->whoType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_getpriority(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->which, In0P->who, &OutP->prio);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->prioType = prioType;
#else	UseStaticMsgType
	OutP->prioType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->prioType.msgt_size = 32;
	OutP->prioType.msgt_number = 1;
	OutP->prioType.msgt_inline = TRUE;
	OutP->prioType.msgt_longform = FALSE;
	OutP->prioType.msgt_deallocate = FALSE;
	OutP->prioType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_pid2task */
mig_internal novalue _Xproc_pid2task
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t pidType;
		pid_t pid;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t taskType;
		mach_port_t task;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_pid2task
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t pid, mach_port_t *task);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t pidCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t taskType = {
		/* msgt_name = */		MACH_MSG_TYPE_COPY_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->pidType != * (int *) &pidCheck)
#else	UseStaticMsgType
	if ((In0P->pidType.msgt_inline != TRUE) ||
	    (In0P->pidType.msgt_longform != FALSE) ||
	    (In0P->pidType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->pidType.msgt_number != 1) ||
	    (In0P->pidType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_pid2task(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->pid, &OutP->task);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->taskType = taskType;
#else	UseStaticMsgType
	OutP->taskType.msgt_name = MACH_MSG_TYPE_COPY_SEND;
	OutP->taskType.msgt_size = 32;
	OutP->taskType.msgt_number = 1;
	OutP->taskType.msgt_inline = TRUE;
	OutP->taskType.msgt_longform = FALSE;
	OutP->taskType.msgt_deallocate = FALSE;
	OutP->taskType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_task2pid */
mig_internal novalue _Xproc_task2pid
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t taskType;
		mach_port_t task;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t pidType;
		pid_t pid;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_task2pid
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, mach_port_t task, pid_t *pid);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t taskCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t pidType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->taskType != * (int *) &taskCheck)
#else	UseStaticMsgType
	if ((In0P->taskType.msgt_inline != TRUE) ||
	    (In0P->taskType.msgt_longform != FALSE) ||
	    (In0P->taskType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->taskType.msgt_number != 1) ||
	    (In0P->taskType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_task2pid(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->task, &OutP->pid);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->pidType = pidType;
#else	UseStaticMsgType
	OutP->pidType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->pidType.msgt_size = 32;
	OutP->pidType.msgt_number = 1;
	OutP->pidType.msgt_inline = TRUE;
	OutP->pidType.msgt_longform = FALSE;
	OutP->pidType.msgt_deallocate = FALSE;
	OutP->pidType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_task2proc */
mig_internal novalue _Xproc_task2proc
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t taskType;
		mach_port_t task;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t procType;
		mach_port_t proc;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_task2proc
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, mach_port_t task, mach_port_t *proc);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t taskCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_PORT_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t procType = {
		/* msgt_name = */		MACH_MSG_TYPE_MAKE_SEND,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    !(In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->taskType != * (int *) &taskCheck)
#else	UseStaticMsgType
	if ((In0P->taskType.msgt_inline != TRUE) ||
	    (In0P->taskType.msgt_longform != FALSE) ||
	    (In0P->taskType.msgt_name != MACH_MSG_TYPE_PORT_SEND) ||
	    (In0P->taskType.msgt_number != 1) ||
	    (In0P->taskType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_task2proc(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->task, &OutP->proc);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
	OutP->Head.msgh_size = 40;

#if	UseStaticMsgType
	OutP->procType = procType;
#else	UseStaticMsgType
	OutP->procType.msgt_name = MACH_MSG_TYPE_MAKE_SEND;
	OutP->procType.msgt_size = 32;
	OutP->procType.msgt_number = 1;
	OutP->procType.msgt_inline = TRUE;
	OutP->procType.msgt_longform = FALSE;
	OutP->procType.msgt_deallocate = FALSE;
	OutP->procType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_getallprocs */
mig_internal novalue _Xproc_getallprocs
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t pidarrayType;
		pid_t pidarray[512];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_getallprocs
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pidarray_t pidarray, mach_msg_type_number_t *pidarrayCnt);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_long_t pidarrayType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_INTEGER_32,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t pidarrayCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	pidarrayCnt = 512;

	OutP->RetCode = proc_getallprocs(convert_port_to_pstruct(In0P->Head.msgh_request_port), OutP->pidarray, &pidarrayCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->pidarrayType = pidarrayType;
#else	UseStaticMsgType
	OutP->pidarrayType.msgtl_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->pidarrayType.msgtl_size = 32;
	OutP->pidarrayType.msgtl_header.msgt_name = 0;
	OutP->pidarrayType.msgtl_header.msgt_size = 0;
	OutP->pidarrayType.msgtl_header.msgt_number = 0;
	OutP->pidarrayType.msgtl_header.msgt_inline = TRUE;
	OutP->pidarrayType.msgtl_header.msgt_longform = TRUE;
	OutP->pidarrayType.msgtl_header.msgt_deallocate = FALSE;
	OutP->pidarrayType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (pidarrayCnt > 512) {
		OutP->pidarrayType.msgtl_header.msgt_inline = FALSE;
		msgh_simple = FALSE;
	}

	OutP->pidarrayType.msgtl_number = pidarrayCnt;
	OutP->Head.msgh_size = 44 + ((OutP->pidarrayType.msgtl_header.msgt_inline) ? 4 * pidarrayCnt : sizeof(pid_t *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine proc_getprocinfo */
mig_internal novalue _Xproc_getprocinfo
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t whichType;
		pid_t which;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_long_t procinfoType;
		int procinfo[512];
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_getprocinfo
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t which, procinfo_t procinfo, mach_msg_type_number_t *procinfoCnt);
#else
		();
#endif

	boolean_t msgh_simple;
#if	UseStaticMsgType
	static mach_msg_type_t whichCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_long_t procinfoType = {
	{
		/* msgt_name = */		0,
		/* msgt_size = */		0,
		/* msgt_number = */		0,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		TRUE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	},
		/* msgtl_name = */	MACH_MSG_TYPE_INTEGER_32,
		/* msgtl_size = */	32,
		/* msgtl_number = */	512,
	};
#endif	UseStaticMsgType

	mach_msg_type_number_t procinfoCnt;

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whichType != * (int *) &whichCheck)
#else	UseStaticMsgType
	if ((In0P->whichType.msgt_inline != TRUE) ||
	    (In0P->whichType.msgt_longform != FALSE) ||
	    (In0P->whichType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->whichType.msgt_number != 1) ||
	    (In0P->whichType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	procinfoCnt = 512;

	OutP->RetCode = proc_getprocinfo(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->which, OutP->procinfo, &procinfoCnt);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	msgh_simple = TRUE;

#if	UseStaticMsgType
	OutP->procinfoType = procinfoType;
#else	UseStaticMsgType
	OutP->procinfoType.msgtl_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->procinfoType.msgtl_size = 32;
	OutP->procinfoType.msgtl_header.msgt_name = 0;
	OutP->procinfoType.msgtl_header.msgt_size = 0;
	OutP->procinfoType.msgtl_header.msgt_number = 0;
	OutP->procinfoType.msgtl_header.msgt_inline = TRUE;
	OutP->procinfoType.msgtl_header.msgt_longform = TRUE;
	OutP->procinfoType.msgtl_header.msgt_deallocate = FALSE;
	OutP->procinfoType.msgtl_header.msgt_unused = 0;
#endif	UseStaticMsgType
	if (procinfoCnt > 512) {
		OutP->procinfoType.msgtl_header.msgt_inline = FALSE;
		msgh_simple = FALSE;
	}

	OutP->procinfoType.msgtl_number = procinfoCnt;
	OutP->Head.msgh_size = 44 + ((OutP->procinfoType.msgtl_header.msgt_inline) ? 4 * procinfoCnt : sizeof(int *));

	if (!msgh_simple)
		OutP->Head.msgh_bits |= MACH_MSGH_BITS_COMPLEX;
}

/* Routine proc_getprocargs */
mig_internal novalue _Xproc_getprocargs
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t whichType;
		pid_t which;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t nargsType;
		int nargs;
		mach_msg_type_t procargsType;
		string_t procargs;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_getprocargs
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t which, int *nargs, string_t procargs);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t whichCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t nargsType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t procargsType = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whichType != * (int *) &whichCheck)
#else	UseStaticMsgType
	if ((In0P->whichType.msgt_inline != TRUE) ||
	    (In0P->whichType.msgt_longform != FALSE) ||
	    (In0P->whichType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->whichType.msgt_number != 1) ||
	    (In0P->whichType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_getprocargs(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->which, &OutP->nargs, OutP->procargs);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 1068;

#if	UseStaticMsgType
	OutP->nargsType = nargsType;
#else	UseStaticMsgType
	OutP->nargsType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->nargsType.msgt_size = 32;
	OutP->nargsType.msgt_number = 1;
	OutP->nargsType.msgt_inline = TRUE;
	OutP->nargsType.msgt_longform = FALSE;
	OutP->nargsType.msgt_deallocate = FALSE;
	OutP->nargsType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->procargsType = procargsType;
#else	UseStaticMsgType
	OutP->procargsType.msgt_name = MACH_MSG_TYPE_STRING_C;
	OutP->procargsType.msgt_size = 8;
	OutP->procargsType.msgt_number = 1024;
	OutP->procargsType.msgt_inline = TRUE;
	OutP->procargsType.msgt_longform = FALSE;
	OutP->procargsType.msgt_deallocate = FALSE;
	OutP->procargsType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_getprocenv */
mig_internal novalue _Xproc_getprocenv
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t whichType;
		pid_t which;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t nargsType;
		int nargs;
		mach_msg_type_t procenvType;
		string_t procenv;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_getprocenv
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, pid_t which, int *nargs, string_t procenv);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t whichCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t nargsType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t procenvType = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 32) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->whichType != * (int *) &whichCheck)
#else	UseStaticMsgType
	if ((In0P->whichType.msgt_inline != TRUE) ||
	    (In0P->whichType.msgt_longform != FALSE) ||
	    (In0P->whichType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->whichType.msgt_number != 1) ||
	    (In0P->whichType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_getprocenv(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->which, &OutP->nargs, OutP->procenv);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 1068;

#if	UseStaticMsgType
	OutP->nargsType = nargsType;
#else	UseStaticMsgType
	OutP->nargsType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->nargsType.msgt_size = 32;
	OutP->nargsType.msgt_number = 1;
	OutP->nargsType.msgt_inline = TRUE;
	OutP->nargsType.msgt_longform = FALSE;
	OutP->nargsType.msgt_deallocate = FALSE;
	OutP->nargsType.msgt_unused = 0;
#endif	UseStaticMsgType

#if	UseStaticMsgType
	OutP->procenvType = procenvType;
#else	UseStaticMsgType
	OutP->procenvType.msgt_name = MACH_MSG_TYPE_STRING_C;
	OutP->procenvType.msgt_size = 8;
	OutP->procenvType.msgt_number = 1024;
	OutP->procenvType.msgt_inline = TRUE;
	OutP->procenvType.msgt_longform = FALSE;
	OutP->procenvType.msgt_deallocate = FALSE;
	OutP->procenvType.msgt_unused = 0;
#endif	UseStaticMsgType
}

/* Routine proc_setprocargs */
mig_internal novalue _Xproc_setprocargs
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t argvType;
		int argv;
		mach_msg_type_t envpType;
		int envp;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_setprocargs
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, int argv, int envp);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t argvCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	UseStaticMsgType
	static mach_msg_type_t envpCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 40) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->argvType != * (int *) &argvCheck)
#else	UseStaticMsgType
	if ((In0P->argvType.msgt_inline != TRUE) ||
	    (In0P->argvType.msgt_longform != FALSE) ||
	    (In0P->argvType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->argvType.msgt_number != 1) ||
	    (In0P->argvType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->envpType != * (int *) &envpCheck)
#else	UseStaticMsgType
	if ((In0P->envpType.msgt_inline != TRUE) ||
	    (In0P->envpType.msgt_longform != FALSE) ||
	    (In0P->envpType.msgt_name != MACH_MSG_TYPE_INTEGER_32) ||
	    (In0P->envpType.msgt_number != 1) ||
	    (In0P->envpType.msgt_size != 32))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_setprocargs(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->argv, In0P->envp);
}

/* Routine proc_setlogin */
mig_internal novalue _Xproc_setlogin
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t lognameType;
		string_t logname;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_setlogin
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, string_t logname);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t lognameCheck = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 1052) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

#if	TypeCheck
#if	UseStaticMsgType
	if (* (int *) &In0P->lognameType != * (int *) &lognameCheck)
#else	UseStaticMsgType
	if ((In0P->lognameType.msgt_inline != TRUE) ||
	    (In0P->lognameType.msgt_longform != FALSE) ||
	    (In0P->lognameType.msgt_name != MACH_MSG_TYPE_STRING_C) ||
	    (In0P->lognameType.msgt_number != 1024) ||
	    (In0P->lognameType.msgt_size != 8))
#endif	UseStaticMsgType
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_setlogin(convert_port_to_pstruct(In0P->Head.msgh_request_port), In0P->logname);
}

/* Routine proc_getlogin */
mig_internal novalue _Xproc_getlogin
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	typedef struct {
		mach_msg_header_t Head;
	} Request;

	typedef struct {
		mach_msg_header_t Head;
		mach_msg_type_t RetCodeType;
		kern_return_t RetCode;
		mach_msg_type_t lognameType;
		string_t logname;
	} Reply;

	register Request *In0P = (Request *) InHeadP;
	register Reply *OutP = (Reply *) OutHeadP;
	mig_external kern_return_t proc_getlogin
#if	(defined(__STDC__) || defined(c_plusplus))
		(pstruct_t process, string_t logname);
#else
		();
#endif

#if	UseStaticMsgType
	static mach_msg_type_t lognameType = {
		/* msgt_name = */		MACH_MSG_TYPE_STRING_C,
		/* msgt_size = */		8,
		/* msgt_number = */		1024,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

#if	TypeCheck
	if ((In0P->Head.msgh_size != 24) ||
	    (In0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX))
		{ OutP->RetCode = MIG_BAD_ARGUMENTS; return; }
#endif	TypeCheck

	OutP->RetCode = proc_getlogin(convert_port_to_pstruct(In0P->Head.msgh_request_port), OutP->logname);
	if (OutP->RetCode != KERN_SUCCESS)
		return;

	OutP->Head.msgh_size = 1060;

#if	UseStaticMsgType
	OutP->lognameType = lognameType;
#else	UseStaticMsgType
	OutP->lognameType.msgt_name = MACH_MSG_TYPE_STRING_C;
	OutP->lognameType.msgt_size = 8;
	OutP->lognameType.msgt_number = 1024;
	OutP->lognameType.msgt_inline = TRUE;
	OutP->lognameType.msgt_longform = FALSE;
	OutP->lognameType.msgt_deallocate = FALSE;
	OutP->lognameType.msgt_unused = 0;
#endif	UseStaticMsgType
}

mig_external boolean_t process_server
#if	(defined(__STDC__) || defined(c_plusplus))
	(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)
#else
	(InHeadP, OutHeadP)
	mach_msg_header_t *InHeadP, *OutHeadP;
#endif
{
	register mach_msg_header_t *InP =  InHeadP;
	register mig_reply_header_t *OutP = (mig_reply_header_t *) OutHeadP;

#if	UseStaticMsgType
	static mach_msg_type_t RetCodeType = {
		/* msgt_name = */		MACH_MSG_TYPE_INTEGER_32,
		/* msgt_size = */		32,
		/* msgt_number = */		1,
		/* msgt_inline = */		TRUE,
		/* msgt_longform = */		FALSE,
		/* msgt_deallocate = */		FALSE,
		/* msgt_unused = */		0
	};
#endif	UseStaticMsgType

	typedef novalue (*SERVER_STUB_PROC)
#if	(defined(__STDC__) || defined(c_plusplus))
		(mach_msg_header_t *, mach_msg_header_t *);
#else
		();
#endif
	static SERVER_STUB_PROC routines[] = {
		_Xproc_sethostid,
		_Xproc_gethostid,
		_Xproc_sethostname,
		_Xproc_gethostname,
		_Xproc_getpids,
		_Xproc_reauthenticate,
		_Xproc_register,
		_Xproc_setports,
		_Xproc_kill,
		_Xproc_ctty_kill,
		_Xproc_set_ctty,
		_Xproc_wait,
		_Xproc_waitintr,
		_Xproc_dostop,
		_Xproc_markstop,
		_Xproc_cont,
		_Xproc_exit,
		_Xproc_mark_exec,
		_Xproc_mark_traced,
		_Xproc_mark_system,
		_Xproc_mark_nostopchild,
		_Xproc_setsid,
		_Xproc_setpgrp,
		_Xproc_getpgrp,
		_Xproc_version,
		_Xproc_getrusage,
		_Xproc_setpriority,
		_Xproc_getpriority,
		_Xproc_pid2task,
		_Xproc_task2pid,
		_Xproc_task2proc,
		_Xproc_getallprocs,
		_Xproc_getprocinfo,
		_Xproc_getprocargs,
		_Xproc_getprocenv,
		_Xproc_setprocargs,
		_Xproc_setlogin,
		_Xproc_getlogin,
	};

	register SERVER_STUB_PROC routine;

	OutP->Head.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REPLY(InP->msgh_bits), 0);
	OutP->Head.msgh_size = sizeof *OutP;
	OutP->Head.msgh_remote_port = InP->msgh_reply_port;
	OutP->Head.msgh_local_port = MACH_PORT_NULL;
	OutP->Head.msgh_seqno = 0;
	OutP->Head.msgh_id = InP->msgh_id + 100;

#if	UseStaticMsgType
	OutP->RetCodeType = RetCodeType;
#else	UseStaticMsgType
	OutP->RetCodeType.msgt_name = MACH_MSG_TYPE_INTEGER_32;
	OutP->RetCodeType.msgt_size = 32;
	OutP->RetCodeType.msgt_number = 1;
	OutP->RetCodeType.msgt_inline = TRUE;
	OutP->RetCodeType.msgt_longform = FALSE;
	OutP->RetCodeType.msgt_deallocate = FALSE;
	OutP->RetCodeType.msgt_unused = 0;
#endif	UseStaticMsgType

	if ((InP->msgh_id > 24037) || (InP->msgh_id < 24000) ||
	    ((routine = routines[InP->msgh_id - 24000]) == 0)) {
		OutP->RetCode = MIG_BAD_ID;
		return FALSE;
	}
	(*routine) (InP, &OutP->Head);
	return TRUE;
}
