# define sySkip 257
# define syRoutine 258
# define sySimpleRoutine 259
# define sySimpleProcedure 260
# define syProcedure 261
# define syFunction 262
# define sySubsystem 263
# define syKernelUser 264
# define syKernelServer 265
# define syMsgOption 266
# define syMsgSeqno 267
# define syWaitTime 268
# define syNoWaitTime 269
# define syErrorProc 270
# define syServerPrefix 271
# define syUserPrefix 272
# define syServerDemux 273
# define syRCSId 274
# define syImport 275
# define syUImport 276
# define sySImport 277
# define syIn 278
# define syOut 279
# define syInOut 280
# define syRequestPort 281
# define syReplyPort 282
# define sySReplyPort 283
# define syUReplyPort 284
# define syType 285
# define syArray 286
# define syStruct 287
# define syOf 288
# define syInTran 289
# define syOutTran 290
# define syDestructor 291
# define syCType 292
# define syCUserType 293
# define syCServerType 294
# define syCString 295
# define syColon 296
# define sySemi 297
# define syComma 298
# define syPlus 299
# define syMinus 300
# define syStar 301
# define syDiv 302
# define syLParen 303
# define syRParen 304
# define syEqual 305
# define syCaret 306
# define syTilde 307
# define syLAngle 308
# define syRAngle 309
# define syLBrack 310
# define syRBrack 311
# define syBar 312
# define syError 313
# define syNumber 314
# define sySymbolicType 315
# define syIdentifier 316
# define syString 317
# define syQString 318
# define syFileName 319
# define syIPCFlag 320

# line 159 "parser.y"

#include "lexxer.h"
#include "string.h"
#include "type.h"
#include "routine.h"
#include "statement.h"
#include "global.h"

static char *import_name();


# line 171 "parser.y"
typedef union 
{
    u_int number;
    identifier_t identifier;
    string_t string;
    statement_kind_t statement_kind;
    ipc_type_t *type;
    struct
    {
	u_int innumber;		/* msgt_name value, when sending */
	string_t instr;
	u_int outnumber;	/* msgt_name value, when receiving */
	string_t outstr;
	u_int size;		/* 0 means there is no default size */
    } symtype;
    routine_t *routine;
    arg_kind_t direction;
    argument_t *argument;
    ipc_flags_t flag;
} YYSTYPE;
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 685 "parser.y"


yyerror(s)
    char *s;
{
    error(s);
}

static char *
import_name(sk)
    statement_kind_t sk;
{
    switch (sk)
    {
      case skImport:
	return "Import";
      case skSImport:
	return "SImport";
      case skUImport:
	return "UImport";
      default:
	fatal("import_name(%d): not import statement", (int) sk);
	/*NOTREACHED*/
    }
}
short yyexca[] ={
-1, 1,
	0, -1,
	266, 104,
	268, 104,
	274, 106,
	275, 105,
	276, 105,
	277, 105,
	-2, 0,
	};
# define YYNPROD 107
# define YYLAST 354
short yyact[]={

 100, 101, 201,  78,  79,  73,  74,  76, 150, 102,
 153,  75, 203, 202, 197, 181, 180,  98, 149, 165,
  94, 152, 164, 209, 163, 162, 161, 160, 104, 105,
  99, 104, 105, 156, 140, 153, 139,  69,  68,  67,
  66,  65,  59,  57,  56,  55, 152,  54, 171, 172,
 173, 174, 171, 172, 173, 174,  87,  72, 153, 169,
 200, 206, 136,  77, 199, 171, 172, 173, 174, 152,
 171, 172, 173, 174, 168, 135, 208, 177, 171, 172,
 173, 174, 176, 118, 119, 117, 134, 133, 194, 207,
 170, 204, 137, 194, 198, 110, 111, 112, 113, 114,
 115, 116,  16,  12,  33,  34,  36,  35,  37,  32,
 171, 172, 173, 174, 148,  19,  20,  21,  22,  23,
 178, 106, 171, 172, 173, 174, 205, 191, 173, 174,
 138,  24, 196, 195, 182,  81, 122, 123, 124, 125,
 126, 127,  50,  15,  64,  49,  48,  47,  46,  45,
  44,  43,  42,  41,  40,  39,  38, 121, 147, 146,
 145, 144, 143, 142, 118, 119, 117, 192, 186, 184,
 167,  61,  62,  63, 151, 179, 110, 111, 112, 113,
 114, 115, 116,  52, 120,  53, 107,  97,  89, 103,
  58,  80,  31,  30,  18,  71,  86,  70,  51,  17,
  14,  13,  10,   9,   8,   7,   6,   5,   4,   3,
   2,   1, 108, 109,  29,  28,  27,  26,  25,  11,
  91,  90,  96,  88,  95,  93,  92,  60,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  82,  83,
  84,  85,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 128, 129, 130, 131,   0, 132,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 154,
 155,   0, 141,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 166, 159, 158, 157,   0, 175,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 183,   0, 185,   0, 187, 188, 189, 190,
   0,   0,   0, 193 };
short yypact[]={

-1000,-154,-1000,-141,-142,-143,-144,-145,-146,-147,
-148,-149,-150,-151,-152,-1000,-155,-1000, -83,-1000,
-269,-271,-272,-273,-274,-1000,-1000,-1000,-1000,-1000,
-104,-130,-1000,-275,-276,-277,-278,-279,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-259,-306,-310,-1000,-1000,-1000,-1000,-1000,-242,
-316,-1000,-1000,-1000,-314,-168,-168,-168,-168,-168,
-258,-1000,-1000,-1000,-1000,-1000,-1000,-286,-1000,-1000,
-1000,-183,-1000,-1000,-1000,-139,-1000,-1000,-153,-1000,
-1000,-1000,-286,-286,-286,-286,-1000,-1000,-283,-1000,
-223,-224,-235,-250,-1000,-1000,-1000,-212,-167,-280,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-282,-133,-134,-135,-136,-137,-138,-1000,-1000,
-1000,-1000,-184,-293,-245,-268,-283,-1000,-102,-139,
-242,-1000,-289,-290,-291,-292,-294,-297,-245,-118,
-237,-221,-1000,-245,-229,-234,-176,-1000,-1000,-1000,
-300,-301,-169,-1000,-1000,-1000,-189,-1000,-119,-245,
-120,-245,-245,-245,-245,-177,-121,-1000,-245,-205,
-170,-171,-302,-210,-1000,-247,-1000,-173,-173,-1000,
-1000,-1000,-1000,-251,-318,-303,-304,-213,-1000,-162,
-1000,-249,-215,-228,-1000,-1000,-288,-1000,-1000,-1000 };
short yypgo[]={

   0, 227, 226, 225, 224, 174, 190, 223, 188, 222,
 221, 220, 184, 189, 187, 219, 218, 217, 216, 215,
 214, 213, 212, 191, 186, 175, 211, 210, 209, 208,
 207, 206, 205, 204, 203, 202, 201, 200, 199, 198,
 197, 196, 195, 194, 193, 192 };
short yyr1[]={

   0,  26,  26,  27,  27,  27,  27,  27,  27,  27,
  27,  27,  27,  27,  27,  27,  27,  28,  38,  39,
  39,  42,  42,  40,  41,  30,  29,  29,  31,  32,
  33,  34,  36,   1,   1,   1,  37,  35,   6,   7,
   7,   7,   7,   7,   7,   7,   8,   8,   8,   8,
   8,   8,   8,  10,  10,  25,  25,  25,  13,  13,
  14,  14,  11,   2,   2,   2,   3,   4,   9,   9,
   5,   5,   5,   5,   5,   5,  15,  15,  15,  15,
  15,  16,  17,  18,  19,  20,  23,  23,  24,  24,
  22,  21,  21,  21,  21,  21,  21,  21,  21,  21,
  21,  21,  12,  12,  43,  44,  45 };
short yyr2[]={

   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   1,   2,   4,   1,   0,
   2,   1,   1,   1,   1,   3,   3,   1,   2,   2,
   2,   2,   3,   1,   1,   1,   3,   2,   3,   1,
   8,   8,   7,   4,   4,   4,   1,   1,   2,   2,
   2,   2,   1,   1,   6,   0,   3,   5,   1,   1,
   1,   3,   1,   4,   5,   7,   5,   5,   4,   6,
   3,   3,   3,   3,   1,   3,   1,   1,   1,   1,
   1,   3,   3,   3,   3,   4,   2,   3,   1,   3,
   4,   0,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   2,   2,   0,   0,   0 };
short yychk[]={

-1000, -26, -27, -28, -29, -30, -31, -32, -33, -34,
 -35, -15, 257, -36, -37, 297, 256, -38, -43, 269,
 270, 271, 272, 273, 285, -16, -17, -18, -19, -20,
 -44, -45, 263, 258, 259, 261, 260, 262, 297, 297,
 297, 297, 297, 297, 297, 297, 297, 297, 297, 297,
 297, -39, 266, 268, 316, 316, 316, 316,  -6, 316,
  -1, 275, 276, 277, 274, 316, 316, 316, 316, 316,
 -40, -42, 316, 264, 265, 317, 317, 305, 319, 318,
 -23, 303, -23, -23, -23, -23, -41, 314,  -7,  -8,
 -10, -11,  -2,  -3, 306,  -4,  -9, -14, 303, 316,
 286, 287, 295, -13, 314, 315, 304, -24, -22, -21,
 278, 279, 280, 281, 282, 283, 284, 268, 266, 267,
 -12, 296, 289, 290, 291, 292, 293, 294,  -8,  -8,
  -8,  -8, -14, 310, 310, 310, 312, 304, 297, 316,
 316,  -6, 296, 296, 296, 296, 296, 296, 298, 311,
 301,  -5, 314, 303,  -5,  -5, 301, -13, -24, -12,
 316, 316, 316, 316, 316, 316,  -5, 288, 311, 296,
 311, 299, 300, 301, 302,  -5, 311, 311, 296, -25,
 316, 316, 303, -25, 288,  -5, 288,  -5,  -5,  -5,
  -5, 304, 288,  -5, 298, 303, 303, 316, 304, 311,
 311, 320, 316, 316, 304, 288, 310, 304, 304, 311 };
short yydef[]={

   1,  -2,   2,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  15,   0,  19,   0,  27,
   0,   0,   0,   0,   0,  76,  77,  78,  79,  80,
   0,   0,  18,   0,   0,   0,   0,   0,   3,   4,
   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,
  16,   0,   0,   0,  28,  29,  30,  31,  37,   0,
   0,  33,  34,  35,   0,   0,   0,   0,   0,   0,
   0,  20,  23,  21,  22,  25,  26,   0,  32,  36,
  81,  91,  82,  83,  84,   0,  17,  24,  38,  39,
  46,  47,   0,   0,   0,   0,  52,  53,   0,  62,
   0,   0,   0,  60,  58,  59,  86,   0,  88,   0,
  92,  93,  94,  95,  96,  97,  98,  99, 100, 101,
  85,   0,   0,   0,   0,   0,   0,   0,  48,  49,
  50,  51,   0,   0,   0,   0,   0,  87,  91,   0,
 102, 103,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  74,   0,   0,   0,   0,  61,  89,  55,
   0,   0,   0,  43,  44,  45,  55,  63,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  68,   0,  90,
   0,   0,   0,   0,  64,   0,  66,  70,  71,  72,
  73,  75,  67,   0,   0,   0,   0,   0,  54,   0,
  69,  56,   0,   0,  42,  65,   0,  40,  41,  57 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 11:
# line 207 "parser.y"
{
    register statement_t *st = stAlloc();

    st->stKind = skRoutine;
    st->stRoutine = yypvt[-1].routine;
    rtCheckRoutine(yypvt[-1].routine);
    if (BeVerbose)
	rtPrintRoutine(yypvt[-1].routine);
} break;
case 12:
# line 217 "parser.y"
{ rtSkip(); } break;
case 16:
# line 222 "parser.y"
{ yyerrok; } break;
case 17:
# line 227 "parser.y"
{
    if (BeVerbose)
    {
	printf("Subsystem %s: base = %u%s%s\n\n",
	       SubsystemName, SubsystemBase,
	       IsKernelUser ? ", KernelUser" : "",
	       IsKernelServer ? ", KernelServer" : "");
    }
} break;
case 18:
# line 239 "parser.y"
{
    if (SubsystemName != strNULL)
    {
	warn("previous Subsystem decl (of %s) will be ignored", SubsystemName);
	IsKernelUser = FALSE;
	IsKernelServer = FALSE;
	strfree(SubsystemName);
    }
} break;
case 21:
# line 255 "parser.y"
{
    if (IsKernelUser)
	warn("duplicate KernelUser keyword");
    IsKernelUser = TRUE;
} break;
case 22:
# line 261 "parser.y"
{
    if (IsKernelServer)
	warn("duplicate KernelServer keyword");
    IsKernelServer = TRUE;
} break;
case 23:
# line 268 "parser.y"
{ SubsystemName = yypvt[-0].identifier; } break;
case 24:
# line 271 "parser.y"
{ SubsystemBase = yypvt[-0].number; } break;
case 25:
# line 275 "parser.y"
{
    if (streql(yypvt[-0].string, "MACH_MSG_OPTION_NONE"))
    {
	MsgOption = strNULL;
	if (BeVerbose)
	    printf("MsgOption: canceled\n\n");
    }
    else
    {
	MsgOption = yypvt[-0].string;
	if (BeVerbose)
	    printf("MsgOption %s\n\n",yypvt[-0].string);
    }
} break;
case 26:
# line 292 "parser.y"
{
    WaitTime = yypvt[-0].string;
    if (BeVerbose)
	printf("WaitTime %s\n\n", WaitTime);
} break;
case 27:
# line 298 "parser.y"
{
    WaitTime = strNULL;
    if (BeVerbose)
	printf("NoWaitTime\n\n");
} break;
case 28:
# line 306 "parser.y"
{
    ErrorProc = yypvt[-0].identifier;
    if (BeVerbose)
	printf("ErrorProc %s\n\n", ErrorProc);
} break;
case 29:
# line 314 "parser.y"
{
    ServerPrefix = yypvt[-0].identifier;
    if (BeVerbose)
	printf("ServerPrefix %s\n\n", ServerPrefix);
} break;
case 30:
# line 322 "parser.y"
{
    UserPrefix = yypvt[-0].identifier;
    if (BeVerbose)
	printf("UserPrefix %s\n\n", UserPrefix);
} break;
case 31:
# line 330 "parser.y"
{
    ServerDemux = yypvt[-0].identifier;
    if (BeVerbose)
	printf("ServerDemux %s\n\n", ServerDemux);
} break;
case 32:
# line 338 "parser.y"
{
    register statement_t *st = stAlloc();
    st->stKind = yypvt[-1].statement_kind;
    st->stFileName = yypvt[-0].string;

    if (BeVerbose)
	printf("%s %s\n\n", import_name(yypvt[-1].statement_kind), yypvt[-0].string);
} break;
case 33:
# line 348 "parser.y"
{ yyval.statement_kind = skImport; } break;
case 34:
# line 349 "parser.y"
{ yyval.statement_kind = skUImport; } break;
case 35:
# line 350 "parser.y"
{ yyval.statement_kind = skSImport; } break;
case 36:
# line 354 "parser.y"
{
    if (RCSId != strNULL)
	warn("previous RCS decl will be ignored");
    if (BeVerbose)
	printf("RCSId %s\n\n", yypvt[-0].string);
    RCSId = yypvt[-0].string;
} break;
case 37:
# line 364 "parser.y"
{
    register identifier_t name = yypvt[-0].type->itName;

    if (itLookUp(name) != itNULL)
	warn("overriding previous definition of %s", name);
    itInsert(name, yypvt[-0].type);
} break;
case 38:
# line 374 "parser.y"
{ itTypeDecl(yypvt[-2].identifier, yyval.type = yypvt[-0].type); } break;
case 39:
# line 378 "parser.y"
{ yyval.type = itResetType(yypvt[-0].type); } break;
case 40:
# line 381 "parser.y"
{
    yyval.type = yypvt[-7].type;

    if ((yyval.type->itTransType != strNULL) && !streql(yyval.type->itTransType, yypvt[-4].identifier))
	warn("conflicting translation types (%s, %s)",
	     yyval.type->itTransType, yypvt[-4].identifier);
    yyval.type->itTransType = yypvt[-4].identifier;

    if ((yyval.type->itInTrans != strNULL) && !streql(yyval.type->itInTrans, yypvt[-3].identifier))
	warn("conflicting in-translation functions (%s, %s)",
	     yyval.type->itInTrans, yypvt[-3].identifier);
    yyval.type->itInTrans = yypvt[-3].identifier;

    if ((yyval.type->itServerType != strNULL) && !streql(yyval.type->itServerType, yypvt[-1].identifier))
	warn("conflicting server types (%s, %s)",
	     yyval.type->itServerType, yypvt[-1].identifier);
    yyval.type->itServerType = yypvt[-1].identifier;
} break;
case 41:
# line 401 "parser.y"
{
    yyval.type = yypvt[-7].type;

    if ((yyval.type->itServerType != strNULL) && !streql(yyval.type->itServerType, yypvt[-4].identifier))
	warn("conflicting server types (%s, %s)",
	     yyval.type->itServerType, yypvt[-4].identifier);
    yyval.type->itServerType = yypvt[-4].identifier;

    if ((yyval.type->itOutTrans != strNULL) && !streql(yyval.type->itOutTrans, yypvt[-3].identifier))
	warn("conflicting out-translation functions (%s, %s)",
	     yyval.type->itOutTrans, yypvt[-3].identifier);
    yyval.type->itOutTrans = yypvt[-3].identifier;

    if ((yyval.type->itTransType != strNULL) && !streql(yyval.type->itTransType, yypvt[-1].identifier))
	warn("conflicting translation types (%s, %s)",
	     yyval.type->itTransType, yypvt[-1].identifier);
    yyval.type->itTransType = yypvt[-1].identifier;
} break;
case 42:
# line 421 "parser.y"
{
    yyval.type = yypvt[-6].type;

    if ((yyval.type->itDestructor != strNULL) && !streql(yyval.type->itDestructor, yypvt[-3].identifier))
	warn("conflicting destructor functions (%s, %s)",
	     yyval.type->itDestructor, yypvt[-3].identifier);
    yyval.type->itDestructor = yypvt[-3].identifier;

    if ((yyval.type->itTransType != strNULL) && !streql(yyval.type->itTransType, yypvt[-1].identifier))
	warn("conflicting translation types (%s, %s)",
	     yyval.type->itTransType, yypvt[-1].identifier);
    yyval.type->itTransType = yypvt[-1].identifier;
} break;
case 43:
# line 435 "parser.y"
{
    yyval.type = yypvt[-3].type;

    if ((yyval.type->itUserType != strNULL) && !streql(yyval.type->itUserType, yypvt[-0].identifier))
	warn("conflicting user types (%s, %s)",
	     yyval.type->itUserType, yypvt[-0].identifier);
    yyval.type->itUserType = yypvt[-0].identifier;

    if ((yyval.type->itServerType != strNULL) && !streql(yyval.type->itServerType, yypvt[-0].identifier))
	warn("conflicting server types (%s, %s)",
	     yyval.type->itServerType, yypvt[-0].identifier);
    yyval.type->itServerType = yypvt[-0].identifier;
} break;
case 44:
# line 449 "parser.y"
{
    yyval.type = yypvt[-3].type;

    if ((yyval.type->itUserType != strNULL) && !streql(yyval.type->itUserType, yypvt[-0].identifier))
	warn("conflicting user types (%s, %s)",
	     yyval.type->itUserType, yypvt[-0].identifier);
    yyval.type->itUserType = yypvt[-0].identifier;
} break;
case 45:
# line 459 "parser.y"
{
    yyval.type = yypvt[-3].type;

    if ((yyval.type->itServerType != strNULL) && !streql(yyval.type->itServerType, yypvt[-0].identifier))
	warn("conflicting server types (%s, %s)",
	     yyval.type->itServerType, yypvt[-0].identifier);
    yyval.type->itServerType = yypvt[-0].identifier;
} break;
case 46:
# line 470 "parser.y"
{ yyval.type = yypvt[-0].type; } break;
case 47:
# line 472 "parser.y"
{ yyval.type = yypvt[-0].type; } break;
case 48:
# line 474 "parser.y"
{ yyval.type = itVarArrayDecl(yypvt[-1].number, yypvt[-0].type); } break;
case 49:
# line 476 "parser.y"
{ yyval.type = itArrayDecl(yypvt[-1].number, yypvt[-0].type); } break;
case 50:
# line 478 "parser.y"
{ yyval.type = itPtrDecl(yypvt[-0].type); } break;
case 51:
# line 480 "parser.y"
{ yyval.type = itStructDecl(yypvt[-1].number, yypvt[-0].type); } break;
case 52:
# line 482 "parser.y"
{ yyval.type = yypvt[-0].type; } break;
case 53:
# line 486 "parser.y"
{
    yyval.type = itShortDecl(yypvt[-0].symtype.innumber, yypvt[-0].symtype.instr,
		     yypvt[-0].symtype.outnumber, yypvt[-0].symtype.outstr,
		     yypvt[-0].symtype.size);
} break;
case 54:
# line 493 "parser.y"
{
    yyval.type = itLongDecl(yypvt[-4].symtype.innumber, yypvt[-4].symtype.instr,
		    yypvt[-4].symtype.outnumber, yypvt[-4].symtype.outstr,
		    yypvt[-4].symtype.size, yypvt[-2].number, yypvt[-1].flag);
} break;
case 55:
# line 501 "parser.y"
{ yyval.flag = flNone; } break;
case 56:
# line 503 "parser.y"
{
    if (yypvt[-2].flag & yypvt[-0].flag)
	warn("redundant IPC flag ignored");
    else
	yyval.flag = yypvt[-2].flag | yypvt[-0].flag;
} break;
case 57:
# line 510 "parser.y"
{
    if (yypvt[-2].flag != flDealloc)
	warn("only Dealloc is variable");
    else
	yyval.flag = yypvt[-4].flag | flMaybeDealloc;
} break;
case 58:
# line 519 "parser.y"
{
    yyval.symtype.innumber = yyval.symtype.outnumber = yypvt[-0].number;
    yyval.symtype.instr = yyval.symtype.outstr = strNULL;
    yyval.symtype.size = 0;
} break;
case 59:
# line 525 "parser.y"
{ yyval.symtype = yypvt[-0].symtype; } break;
case 60:
# line 529 "parser.y"
{ yyval.symtype = yypvt[-0].symtype; } break;
case 61:
# line 531 "parser.y"
{
    if (yypvt[-2].symtype.size != yypvt[-0].symtype.size)
    {
	if (yypvt[-2].symtype.size == 0)
	    yyval.symtype.size = yypvt[-0].symtype.size;
	else if (yypvt[-0].symtype.size == 0)
	    yyval.symtype.size = yypvt[-2].symtype.size;
	else
	{
	    error("sizes in IPCTypes (%d, %d) aren't equal",
		  yypvt[-2].symtype.size, yypvt[-0].symtype.size);
	    yyval.symtype.size = 0;
	}
    }
    else
	yyval.symtype.size = yypvt[-2].symtype.size;
    yyval.symtype.innumber = yypvt[-2].symtype.innumber;
    yyval.symtype.instr = yypvt[-2].symtype.instr;
    yyval.symtype.outnumber = yypvt[-0].symtype.outnumber;
    yyval.symtype.outstr = yypvt[-0].symtype.outstr;
} break;
case 62:
# line 555 "parser.y"
{ yyval.type = itPrevDecl(yypvt[-0].identifier); } break;
case 63:
# line 559 "parser.y"
{ yyval.number = 0; } break;
case 64:
# line 561 "parser.y"
{ yyval.number = 0; } break;
case 65:
# line 564 "parser.y"
{ yyval.number = yypvt[-2].number; } break;
case 66:
# line 568 "parser.y"
{ yyval.number = yypvt[-2].number; } break;
case 67:
# line 572 "parser.y"
{ yyval.number = yypvt[-2].number; } break;
case 68:
# line 576 "parser.y"
{ yyval.type = itCStringDecl(yypvt[-1].number, FALSE); } break;
case 69:
# line 579 "parser.y"
{ yyval.type = itCStringDecl(yypvt[-1].number, TRUE); } break;
case 70:
# line 583 "parser.y"
{ yyval.number = yypvt[-2].number + yypvt[-0].number;	} break;
case 71:
# line 585 "parser.y"
{ yyval.number = yypvt[-2].number - yypvt[-0].number;	} break;
case 72:
# line 587 "parser.y"
{ yyval.number = yypvt[-2].number * yypvt[-0].number;	} break;
case 73:
# line 589 "parser.y"
{ yyval.number = yypvt[-2].number / yypvt[-0].number;	} break;
case 74:
# line 591 "parser.y"
{ yyval.number = yypvt[-0].number;	} break;
case 75:
# line 593 "parser.y"
{ yyval.number = yypvt[-1].number;	} break;
case 76:
# line 597 "parser.y"
{ yyval.routine = yypvt[-0].routine; } break;
case 77:
# line 598 "parser.y"
{ yyval.routine = yypvt[-0].routine; } break;
case 78:
# line 599 "parser.y"
{ yyval.routine = yypvt[-0].routine; } break;
case 79:
# line 600 "parser.y"
{ yyval.routine = yypvt[-0].routine; } break;
case 80:
# line 601 "parser.y"
{ yyval.routine = yypvt[-0].routine; } break;
case 81:
# line 605 "parser.y"
{ yyval.routine = rtMakeRoutine(yypvt[-1].identifier, yypvt[-0].argument); } break;
case 82:
# line 609 "parser.y"
{ yyval.routine = rtMakeSimpleRoutine(yypvt[-1].identifier, yypvt[-0].argument); } break;
case 83:
# line 613 "parser.y"
{ yyval.routine = rtMakeProcedure(yypvt[-1].identifier, yypvt[-0].argument); } break;
case 84:
# line 617 "parser.y"
{ yyval.routine = rtMakeSimpleProcedure(yypvt[-1].identifier, yypvt[-0].argument); } break;
case 85:
# line 621 "parser.y"
{ yyval.routine = rtMakeFunction(yypvt[-2].identifier, yypvt[-1].argument, yypvt[-0].type); } break;
case 86:
# line 625 "parser.y"
{ yyval.argument = argNULL; } break;
case 87:
# line 627 "parser.y"
{ yyval.argument = yypvt[-1].argument; } break;
case 88:
# line 632 "parser.y"
{ yyval.argument = yypvt[-0].argument; } break;
case 89:
# line 634 "parser.y"
{
    yyval.argument = yypvt[-2].argument;
    yyval.argument->argNext = yypvt[-0].argument;
} break;
case 90:
# line 641 "parser.y"
{
    yyval.argument = argAlloc();
    yyval.argument->argKind = yypvt[-3].direction;
    yyval.argument->argName = yypvt[-2].identifier;
    yyval.argument->argType = yypvt[-1].type;
    yyval.argument->argFlags = yypvt[-0].flag;
} break;
case 91:
# line 650 "parser.y"
{ yyval.direction = akNone; } break;
case 92:
# line 651 "parser.y"
{ yyval.direction = akIn; } break;
case 93:
# line 652 "parser.y"
{ yyval.direction = akOut; } break;
case 94:
# line 653 "parser.y"
{ yyval.direction = akInOut; } break;
case 95:
# line 654 "parser.y"
{ yyval.direction = akRequestPort; } break;
case 96:
# line 655 "parser.y"
{ yyval.direction = akReplyPort; } break;
case 97:
# line 656 "parser.y"
{ yyval.direction = akSReplyPort; } break;
case 98:
# line 657 "parser.y"
{ yyval.direction = akUReplyPort; } break;
case 99:
# line 658 "parser.y"
{ yyval.direction = akWaitTime; } break;
case 100:
# line 659 "parser.y"
{ yyval.direction = akMsgOption; } break;
case 101:
# line 660 "parser.y"
{ yyval.direction = akMsgSeqno; } break;
case 102:
# line 664 "parser.y"
{
    yyval.type = itLookUp(yypvt[-0].identifier);
    if (yyval.type == itNULL)
	error("type '%s' not defined", yypvt[-0].identifier);
} break;
case 103:
# line 670 "parser.y"
{ yyval.type = yypvt[-0].type; } break;
case 104:
# line 674 "parser.y"
{ LookString(); } break;
case 105:
# line 678 "parser.y"
{ LookFileName(); } break;
case 106:
# line 682 "parser.y"
{ LookQString(); } break;
		}
		goto yystack;  /* stack new state and value */

	}
