/* Miscellany used by the emulator
   Copyright (C) 1991 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include "mach.h"
#include <gnu/types.h>
#include <gnu/posix_errors.h>
#include <gnu/errno.h>
#include <hurd/hurd_types.h>
#include <mig_errors.h>
#include <mach/error.h>

/* This function is responsible for turning Mach error codes into
   Posix style error codes.  */
int
h2ae (error_t hurd_error)
{
  if (err_get_system (hurd_error) == err_posix)
    return err_get_code (hurd_error);

  /* If we get one of these errors, then we have sent a message to
     something which didn't expect it.  */
  switch (hurd_error)
    {
    case MIG_TYPE_ERROR:
    case MIG_REMOTE_ERROR:
    case MIG_BAD_ID:
    case MIG_BAD_ARGUMENTS:
      return EBADF;

    default:
      return EINVAL;
    }
}
  
int
nullsys (void *ap, int *ret1, int *ret2)
{
  return 0;
}

void
emulator_fault (int signo)
{
  task_terminate (mach_task_self ());
}
