/* This is the stat buffer used by BSD and Alix */

struct stat
{
  dev_t    st_dev;
  ino_t    st_ino;
  mode_t   st_mode;
  nlink_t  st_nlink;
  uid_t    st_uid;
  gid_t    st_gid;
  dev_t    st_rdev;
  size_t   st_size;
  time_t   st_atime;
  u_long_t st_atime_usec;
  time_t   st_mtime;
  u_long_t st_mtime_usec;
  time_t   st_ctime;
  u_long_t st_ctime_usec;
  u_long_t st_blksize;
  u_long_t st_blocks;
  long     st_spare[2];
};

/* These are the bits for a mode */
#define _S_IFMT    0170000
#define _S_IFIFO   0010000
#define _S_IFCHR   0020000
#define _S_IFDIR   0040000
#define _S_IFBLK   0060000
#define _S_IFREG   0100000
#define _S_IFLNK   0120000
#define _S_IFSOCK  0140000
#define _S_ISUID   0004000
#define _S_ISGID   0002000
#define _S_ISVTX   0001000
#define _S_IREAD   0000400
#define _S_IWRITE  0000200
#define _S_IEXEC   0000100

#define S_IRWXU 0700
#define S_IRWXG 0070
#define S_IRWXO 0007

#define S_IRUSR _S_IREAD
#define S_IWUSR _S_IWRITE
#define S_IXUSR _S_IEXEC

#define S_IRGRP (_S_IREAD >> 1)
#define S_IWGRP (_S_IWRITE >> 1)
#define S_IXGRP (_S_IEXEC >> 1)

#define S_IROTH (_S_IREAD >> 2)
#define S_IWOTH (_S_IWRITE >> 2)
#define S_IXOTH (_S_IEXEC >> 2)

#define S_ISUID  _S_ISUID
#define S_ISGID  _S_ISGID

#ifndef _POSIX_SOURCE
#define S_IFMT   _S_IFMT
#define S_IFIFO  _S_IFIFO
#define S_IFCHR  _S_IFCHR
#define S_IFDIR  _S_IFDIR
#define S_IFBLK  _S_IFBLK
#define S_IFREG  _S_IFREG
#define S_IFLNK  _S_IFLNK
#define S_IFSOCK _S_IFSOCK
#define S_ISVTX  _S_ISVTX
#define S_IREAD  _S_IREAD
#define S_IWRITE _S_IWRITE
#define S_IEXEC  _S_IEXEC
#endif

/* Test macros (ick) */
#define _TST_MODE(m, type) (((m) & _S_IFMT) == type)
#define S_ISCHR(m)  _TST_MODE (m, _S_IFCHR)
#define S_ISDIR(m)  _TST_MODE (m, _S_IFDIR)
#define S_ISBLK(m)  _TST_MODE (m, _S_IFBLK)
#define S_ISREG(m)  _TST_MODE (m, _S_IFREG)
#define S_ISFIFO(m) _TST_MODE (m, _S_IFIFO)

#ifndef _POSIX_SOURCE
#define S_ISLNK(m)  _TST_MODE (m, _S_IFLNK)
#define S_ISSOCK(m) _TST_MODE (m, _S_ISSOCK)
#endif

