--- src/mod_auth_xradius.c.orig	2005-04-28 07:58:25 UTC
+++ src/mod_auth_xradius.c
@@ -125,15 +125,15 @@ static int xrad_run_auth_check(request_r
     rctx = xrad_auth_open();
 
     /* Loop through the array of RADIUS Servers, adding them to the rctx object */
-    sr = (xrad_server_info *) dc->servers->elts;
     for (i = 0; i < dc->servers->nelts; ++i) {        
-        rc = xrad_add_server(rctx, sr[i].hostname, sr[i].port, sr[i].secret,
+        sr = &(((xrad_server_info*)dc->servers->elts)[i]);
+        rc = xrad_add_server(rctx, sr->hostname, sr->port, sr->secret,
                              dc->timeout, dc->maxtries);
         
         if (rc != 0) {
             ap_log_rerror(APLOG_MARK, APLOG_ERR, 0, r,
                           "xradius: Failed to add server '%s:%d': (%d) %s",
-                          sr[i].hostname, sr[i].port, rc, xrad_strerror(rctx));
+                          sr->hostname, sr->port, rc, xrad_strerror(rctx));
             goto run_cleanup;
         }        
     }
@@ -294,7 +294,7 @@ static const char *xrad_conf_add_server(
     /* To properly use the Pools, this array is allocated from the here, instead of
         inside the directory configuration creation function. */
     if (dc->servers == NULL) {
-        dc->servers = apr_array_make(parms->pool, 4, sizeof(xrad_server_info*));
+        dc->servers = apr_array_make(parms->pool, 4, sizeof(xrad_server_info));
     }
     
     sr = apr_array_push(dc->servers);
