
/* Generated by Interface Builder */

#import "MenuManager.h"
#import "ClassManager.h"
#import "WindowManager.h"
#import <appkit/Matrix.h>
#import <appkit/ButtonCell.h>
#import <appkit/OpenPanel.h>
#import <appkit/ScrollView.h>
#import <appkit/Text.h>
#import <appkit/NXBrowser.h>
#import <appkit/NXBrowserCell.h>
#import <objc/List.h>
#import <objc/Storage.h>
#import <strings.h>
#import <libc.h>

char thisAppsName[] = "CB" ;

const char *objCTypes[] = 
{ "m",
  "wsp",
  NULL 
} ;

struct loadClass
{ char *className ;
  char *dotOFileName ;
} ;

@implementation MenuManager

- appendFileToTranscript: (char *) fileName ;
{ // append the text of the indicated file to the transcript
  char *aStr ;
  struct stat statBuf ;
  int fd ;
  if(!(fd = open(fileName,O_RDONLY)))
  { NXRunAlertPanel("CB","Cannot open: %c",NULL,NULL,NULL,fileName) ;
    return self ;
  }
  fstat(fd,&statBuf) ;
  aStr = malloc(statBuf.st_size + 1) ;
  read(fd,aStr,statBuf.st_size) ;
  aStr[statBuf.st_size] = '\0' ;
  [self printf: aStr] ;
  close(fd) ;
  free(aStr) ;
  return self ;
}

- (int)browser:sender fillMatrix:matrix inColumn:(int)column ;
{ // delegate method for the browser object 
  return [[ClassManager loadList] count] ; 
}

- browser:sender loadCell:cell atRow:(int)row inColumn:(int)column ;
{  struct loadClass *lcPtr ;
   lcPtr = [[ClassManager loadList] elementAt: row] ;
   [cell setStringValue: lcPtr->className] ;
   [cell setLeaf:YES] ;
   return self ;
}


-cancelNewClass:sender ;
{ [self stopModal] ;
  [newClassPanel orderOut: self] ;
  return self ;
}

- clearTranscript: sender ;
{ [transcriptText setText: ""] ;
  return self ;
}

- createNewClass:sender ;
{ // create a new class browser and initialize its text
  char initText[1024] ;
  const char  *className, *superClassFileName, *superClassName ;
  BOOL anglies ;
  id manager ;
  [self stopModal] ;
  [newClassPanel orderOut: self] ;
  className = [[[newClassInfoMatrix cellList] objectAt: 0] stringValue] ;
  superClassName = [[[newClassInfoMatrix cellList] objectAt: 1] stringValue] ;
  superClassFileName = [[[newClassInfoMatrix cellList] objectAt: 2] stringValue] ;
  anglies = index(superClassFileName, '<') == NULL? NO : YES ; 
  sprintf(initText,
    "#pragma .h #import %c%s%c\n"
    "#import \"%s.h\"\n"
    "@implementation %s:%s\n"
    "{\n"
    "}\n"
    "\n"
    "@end",
    anglies? ' ':'"', superClassFileName, anglies? ' ':'"',
    className, className,superClassName) ;  
   manager = [NXApp loadNibSection:"ClassManager.nib"
     owner:self] ;
  [manager className: (char *) className] ;
  [manager classText: initText] ;
  [manager makeKeyAndOrderFront: self] ;
  return self ;  
}

- finder: sender ;
{ [[finderLineTextField window] center] ;
  [[finderLineTextField window] orderFront: self] ;
  return self ;
}

- finderAddDigit: sender ;
{ // add a digit (the finder's tag) to the finderLineTextField
  int sum ;
  sum = [finderLineTextField intValue] ;
  sum *= 10 ;
  sum += [[sender selectedCell] tag] ;
  [finderLineTextField setIntValue: sum] ;
  return self ;
}

- finderBackUp: sender ;
{ // erase previous digit in the finderLineTextField
  int sum ;
  sum = [finderLineTextField intValue] ;
  sum /= 10 ;
  [finderLineTextField setIntValue: sum] ;
  return self ;
}

- finderCurrent: sender ;
{ // put line number of beginning of selection into
  // the finderLineTextField 
  id aView ;
  if([mainWindow respondsTo: @selector(textView)])
  { NXSelPt start,end ;
    aView = [mainWindow textView] ;
    [aView getSel: &start :&end] ;
    [finderLineTextField setIntValue: [aView lineFromPosition: start.cp]] ;
  }
  return self ;
}

- finderGoTo: sender ;
{ // set selection at beginning of line indicated by
  // finderLineTextField 
  id aView ;
  if([mainWindow respondsTo: @selector(textView)])
  { int pos1, pos2, lineNum ;
    aView = [mainWindow textView] ;
    pos1 = [aView positionFromLine:lineNum = [finderLineTextField intValue]] ;
    pos2 = [aView positionFromLine: lineNum + 1] ;
    [aView setSel:pos1 :pos2] ;
    [aView scrollSelToVisible] ;
  }
  return self ;
}


- loadedClassesBrowser ;
{ return loadedClassesBrowser ;
}

- newClass:sender
{ // run the newClass panel modally
   [newClassPanel center] ;
   [self runModalFor: newClassPanel] ;
   return self;
}

- newDictionary:sender ;
{ // open a new Dictionary Manager
  [[[NXApp loadNibSection:"DictManager.nib" 
         owner: self] center] makeKeyAndOrderFront: self] ;
    return self;
}

- newWorkspace:sender
{ [[[NXApp loadNibSection:"WorkspaceManager.nib" 
         owner: self] center] makeKeyAndOrderFront: self] ;
    return self;
}

- open:sender
{ // pop up an open panel with .m or .wsp as the file extension.  get
  // the results, open a manager on the code
  id openPanel ;
  openPanel = [OpenPanel new] ;
  [openPanel allowMultipleFiles: YES] ;
  if([openPanel runModalForDirectory: NULL file:NULL types: objCTypes])
    [self openList: [openPanel filenames] path: [openPanel directory]] ;
  return self;
}

- openList:  (const char * const *) fileNames  path: (const char *) path ;
// open all files in the NULL terminated list of filenames. If
// path is non-null, then it is used as the directory in which to find
// the files.  If null, the fileNames are considered as paths themselves.
{ char fName[512], className[128] ;
  id manager ;
  int i ;
  float x = 100.0, y = 800.0 ;
  while(*fileNames != NULL)
  { char *extension ;
    extension = rindex(*fileNames,'.') ;
    if(path)
      sprintf(fName,"%s/%s",path,*fileNames) ;
    else
      strcpy(fName,*fileNames) ;
    if(!strcmp(extension,".m"))
    { manager = [NXApp loadNibSection:"ClassManager.nib" 
        owner: self] ;
      [manager moveTopLeftTo:x :y] ;
      [manager fileName: fName] ;
      x += 25.0 ; y -= 25.0 ;
      [manager makeKeyAndOrderFront: self] ;
      for(i = 0 ; (*fileNames)[i] != '.'; i++)
        className[i] = (*fileNames)[i] ;  // strip off extension 
      className[i] ='\0' ;
      [manager className: className] ;
    }
    else // open anything else in a workspace 
    { manager = [NXApp loadNibSection:"WorkspaceManager.nib" 
        owner: self] ;
      [manager fileName: fName] ;
      [manager moveTopLeftTo:x :y] ;
      [manager fileName: fName] ;
      x += 25.0 ; y -= 25.0 ;
      [manager makeKeyAndOrderFront: self] ;
     }
    [manager readFile] ;
    fileNames++ ;
  }
  return self ;
}

- printf: (char *) format, ... ;
{ // format (as in printf) and print into the transcript
  NXStream *aStream ;
  char *textBuf ;
  int textLen, maxLen ;
  va_list argList ;
  aStream = NXOpenMemory(NULL, 0, NX_READWRITE) ;
  va_start(argList, format) ;
  NXVPrintf(aStream, format, argList) ;
  NXGetMemoryBuffer(aStream, &textBuf, &textLen, &maxLen);
  textLen = [transcriptText textLength] ;
  [transcriptText setSel: textLen :textLen] ;
  [transcriptText replaceSel: textBuf] ;
  NXCloseMemory(aStream,NX_TRUNCATEBUFFER) ;
  return self ;
}


- setTranscriptText: anObject ;
{ // this set method is also used to open up an
  // initial open panel
  transcriptText = [anObject docView] ;
  return self ;
}

- showLoadedClasses: sender ;
{ [loadedClassesBrowser loadColumnZero] ;
  [[loadedClassesBrowser window] orderFront: self] ;
  return self ;
}

- showTranscript: sender ;
{ [[transcriptWindow center] orderFront: self] ;
  return self ;
}

- transcriptText ;
{ return transcriptText ;
}

- unloadAllclasses: sender ;
{ [ClassManager unloadAll] ; 
  return self ;
}


- unloadClass: sender ;
{ if([loadedClassesBrowser selectedColumn] == 0)
    [ClassManager unload: 
      [[[loadedClassesBrowser matrixInColumn: 0] selectedCell] stringValue]] ; 
  return self ;
}

@end
