
/* Generated by Interface Builder */

#import "BTFInspector.h"
#import "BlinkTextField.h"
#import <appkit/Application.h>
#import <appkit/TextFieldCell.h>
#import <appkit/TextField.h>
#import <appkit/Matrix.h>
#import <appkit/Window.h>
#import <appkit/Text.h>

@implementation BTFInspector

+ new
{
  self = [super new];
  [NXApp loadNibSection:"BTFInspector.nib" owner:self];
  return self;
}

- setIntervalSlider:anObject
{
    intervalSlider = anObject;
    return self;
}

- setAlignMatrix:anObject
{
    alignMatrix = anObject;
    return self;
}

- setTextGrayMatrix:anObject
{
    textGrayMatrix = anObject;
    return self;
}

- setBorderMatrix:anObject
{
    borderMatrix = anObject;
    return self;
}

- setBackGrayMatrix:anObject
{
    backGrayMatrix = anObject;
    return self;
}

- setIntervalField:anObject
{
    intervalField = anObject;
    return self;
}

- setBlinkOnOff:anObject
{
    blinkOnOff = anObject;
    return self;
}


// In order to be able to hit return at any time in the inspector and get an ok, each TextField
//	must have a method like this one:

- takeBlinkRateAndOK:sender
{
  double r = [sender doubleValue];

  if (r < 0.5) {
    r = 0.5;
  } else if (r > 5.0) {
    r = 5.0;
  }

  [intervalField setDoubleValue:r];
  [intervalSlider setDoubleValue:r];
  return [self performClick:self];
}

- ok:sender
{
  int t;

  [[NXApp mainWindow] makeFirstResponder:[NXApp mainWindow]];
  [window endEditingFor:self];

  if ((t = [[backGrayMatrix selectedCell] tag]) == 0) {
    [object setBackgroundGray:-1.0];
  } else {
    [object setBackgroundGray:(t - 1) / 3.0];
  }

  [object setTextGray:[[textGrayMatrix selectedCell] tag] / 3.0];

  if ((t = [[borderMatrix selectedCell] tag]) == 0) {
    [object setBezeled:NO];
    [object setBordered:NO];
  } else if (t == 1) {
    [object setBordered:NO];
    [object setBezeled:YES];
  } else {
    [object setBezeled:NO];
    [object setBordered:YES];
  }

  if ((t = [[alignMatrix selectedCell] tag]) == 0) {
    [object setAlignment:NX_LEFTALIGNED];
  } else if (t == 1) {
    [object setAlignment:NX_CENTERED];
  } else {
    [object setAlignment:NX_RIGHTALIGNED];
  }

  [object setBlinkRate:[intervalField doubleValue]];
  if ([[blinkOnOff selectedCell] tag] == 0) {
    // we want the field to blink when its read into test mode
    [object deferredSetBlink:YES];
  } else {
    [object deferredSetBlink:NO];
  }
  
  return [super ok:sender];
}

- revert:sender
{
  [window endEditingFor:self];

  if ([object backgroundGray] < 0.0) {
    [backGrayMatrix selectCellAt:0 :0];
  } else {
    [backGrayMatrix selectCellAt:0 :([object backgroundGray] * 3.0) + 1];
  }
  [textGrayMatrix selectCellAt:0 :([object textGray] * 3.0)];

  if ([object isBordered]) {
    [borderMatrix selectCellAt:0 :2];
  }
  else if ([object isBezeled]) {
    [borderMatrix selectCellAt:0 :1];
  }
  else {
    [borderMatrix selectCellAt:0 :0];
  }

  if ([object alignment] == NX_LEFTALIGNED) {
    [alignMatrix selectCellAt:0 :0];
  } else if ([object alignment] == NX_CENTERED) {
    [alignMatrix selectCellAt:0 :1];
  } else if ([object alignment] == NX_RIGHTALIGNED) {
    [alignMatrix selectCellAt:0 :2];
  }

  [intervalField setDoubleValue:[object blinkRate]];
  [intervalSlider setDoubleValue:[object blinkRate]];
  if ([object isBlinking]) {
    [blinkOnOff selectCellAt:0 :0];
  } else {
    [blinkOnOff selectCellAt:0 :1];
  }
  
  return [super revert:sender];
}

@end
