
/*by andrew stone@hydra.unm.edu */
//Thu Nov  2 20:14:50 MST 1989

#import <objc/Object.h>
#import <appkit/View.h>         /* for NXSize */

#define NUM_WINDOWS  4

@interface Preferences:Object
{
    float width[NUM_WINDOWS],height[NUM_WINDOWS],fontSize;
    BOOL useRichText,autoSave;
    char saveDirectory[1024];    
    char saveName[64];
    char fontName[64];
    id  openpanel;
    id  savepanel;
        
    id	sizeForm;		// width/height of 4 default windows
    id  sampleText;              // let user select default font for postits.
    id	prefPanel;
    id	directoryField;
    id  nameField;
    id  fileFormatMatrix;
    id  autoSaveSwitch;
}

- getPreferences:sender;
- runPrefsPanel:sender;
- registerDefaults:sender;
- showFontPanel:sender;

- (BOOL)useRichText;			/// which file format to use: 1=rtf
- (BOOL)autoSave;

- changeSaveDirectory:(const char *)dir forName:(const char *)fname;
- (const char *)saveName;
- (const char *)saveDirectory;
- (const char *)fullPath;

- openpanel;
- savepanel;
- getDefaultWinSize:(NXSize *)size tag:(int)num;

- setSizeForm:anObject;
- setPrefPanel:anObject;
- setDirectoryField:anObject;
- defaultFont;

@end
