/*---------------------------------------------------------------------------
remsubs.c -- Copyright (c) 1990 Rex Pruess
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA or send
   electronic mail to the the author.
  
  
These miscellaneous support routines contain code that would otherwise have
to be repeated often in the various methods used by the Remotes application.
  
Rex Pruess <rpruess@umaxc.weeg.uiowa.edu>
  
$Header: /rpruess/apps/Remotes-2.0/RCS/remsubs.c,v 2.0 91/01/22 15:33:09 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	remsubs.c,v $
 * Revision 2.0  91/01/22  15:33:09  rpruess
 * Remotes-2.0 was upgraded for NeXT System Release 2.0 (standard or extended).
 * Remotes-2.0 supports the NeXT supplied Terminal application and the Stuart
 * shareware product.
 * 
 * Revision 1.1  90/04/10  14:31:50  rpruess
 * Initial revision
 * 
-----------------------------------------------------------------------------*/

/* Standard C header files */
#include <stdio.h>
#include <strings.h>

/*---------------------------------------------------------------------------
This routine extracts the next field from buffer & stores it in field.  The
routine returns the pointer to the next field in buffer.  If there is not a
next field, the null pointer is returned.  Valid field separators are tab &
newline.
-----------------------------------------------------------------------------*/
char           *getfield (char *bufPtr, char *field)
{
   while (*bufPtr != '\t' && *bufPtr != '\n' && *bufPtr != '\0')
      *field++ = *bufPtr++;

   if (*bufPtr == '\0')
      return NULL;

   *field = '\0';               /* Terminate string correctly */

   return ++bufPtr;
}
