/* View3D.h */

#import <objc/Object.h>
#import "3D.h"

@interface View3D:Object
{
	id transformation;
	id subviews;
	id superview;
}

	/*
		tranformation 
			is a Transformation3D object, used on all drawing that is done by 	
			this view3D or any of it's subviews.
		subviews
			is a List object which contains all the View3D's subviews 
		superview 
			should be a View3D or a Context3D. All View3D's must have a superview
			to function properly 
	*/
	

+ new;

	/*	
		sets up a new View3D object with the instance variables initialized
		to the following:
			transformation is nil
			subviews is an empty list
			superview is nil
	*/
			
	
- moveto:(vector3D *)where;

	/* 
		moveto: sends [transformation operateOn:where] and then 
		[superview moveto:where] 
	*/

- lineto:(vector3D *)where;

	/* 
		lineto: sends [transformation operateOn:where] and then 
		[superview lineto:where] 
	*/

- polygon:(vector3D *)vertices howMany:(int)count;

	/*	
		polygon:howMany: sends [transformation OperateOn:vertices 	
		howMany:count]
		and then [superview polygon:vertices:count] 
	*/
	
- superview;

	/* Returns the View3D's superview */
	
- setSuperView:aView3D;
	
	/* 
		Should only be sent by another View3D or a Context3D to let the receiver
		know
		that its superview has been changed. Any calls to addSubView should
		automatically send this message to the subView being added. aView3D
		should be either a View3D or a Context3D.
		(see addSubView: below)
	*/
	
- addSubView:aView3D;
	
	/* 
		This is the way to add View3Ds into a View3D heirarchy. It Will
		send the setSuperView: message to aView3D with self as an argument,
		and will add aView3D into subviews automatically.
		(see setSuperView: above)
	*/

- render;

	/*
		This replaces the DrawSelf method of the View class. It should send
		itself moveto:, lineto: and polygon:howMany: messages. The vector3Ds
		sent along as arguments must be disposable, or assigned their original
		values each time the render message is sent, since they will be modified
		as they are passed up the View3D heirarchy to be displayed by the
		Context3D at the top.
		It will usually be called by it's superview when the
		Context3D at the top of the heirarchy is sent a drawSelf:: message.
		It shouldn't be called directly, only through calls to display.
	*/
	
- display;

	/* This sends itself render then sends display to each subview */
	
- transformation;
	
	/* returns the View3D's transformation instance variable */
	
- setTransformation:anObject;

	/* 
		sets transformation = anObject. The object must respond to operateOn
		and operateOn:howMany messages or else an error will be generated when
		the View3D is sent any moveto: lineto: or polygon:howMany: messages
	*/
		
- subviews;

	/* returns the subviews list */
	
@end
