/* TesterApp.m */

#import "TesterApp.h"
#import "Cube.h"
#import "Context3D.h"
#import "Linear3D.h"
#import <objc/List.h>

@implementation TesterApp

- setTheContext:anObject
{
	int ctr;
	id newCube,transform,temptransform;
	NXRect bounds;
	
	theContext = anObject;
	
   
   [theContext getBounds:&bounds];
   [theContext setDrawOrigin:-bounds.size.width/2.0:-bounds.size.height/2.0];
   
   temptransform=[Linear3D new];
   for(ctr=0;ctr<4;++ctr) {
  		newCube=[Cube new];
	   transform=[Linear3D new];
	
	   [transform scaling:5.0:5.0:5.0];
	   [temptransform translation:ctr * 3.5: ctr * 5.5
	   	: - ctr * 10.0];  
		[transform concatBefore:temptransform];
		
		[newCube setTransformation:transform];
		[[theContext contentView] addSubView:newCube];
	}
	transform=[Linear3D new];
	[transform translation:0.0: 0.0 : -40.0];
	[[theContext contentView] setTransformation:transform];
	[temptransform free];
   return self;
}


- rotateCubes:sender
{
	unsigned ctr,count;
	id transform,theViewList;
	theViewList=[[theContext contentView] subviews];
	count=[theViewList count];
	transform=[Linear3D new];
	for(ctr=0;ctr<count;++ctr) {
		[transform rotation:L3D_X_AXIS:(float)(ctr+1)];
		[[[theViewList objectAt:ctr] transformation] concatAfter:transform];
	}
	for(ctr=0;ctr<count;++ctr) {
		[transform rotation:L3D_Y_AXIS:(float)(ctr+1)*2.0];
		[[[theViewList objectAt:ctr] transformation] concatAfter:transform];
	}
	[transform free];
	[[theContext window] display];
    return self;
}

- closer:sender
{
	id transform;
	transform=[Linear3D new];
	[transform translation:0.0: 0.0 : 1.0];
	[[[theContext contentView] transformation] concatBefore:transform];
	[transform free];
	[[theContext window] display];
	return self;
}

- farther:sender
{
	id transform;
	transform=[Linear3D new];
	[transform translation:0.0: 0.0 : -1.0];
	[[[theContext contentView] transformation] concatBefore:transform];
	[transform free];
	[[theContext window] display];
	return self;
}

@end
