/* Context3D.h */

#import <appkit/View.h>
#import "3D.h"

@interface Context3D:View
{
	id contentView;
	vector3D currentPoint;
	float pictureDistance,clippingDistance;
}

	/* 
		contentView 
			is the top of the View3D drawing hierarchy for this context.
		currentPoint 
			is the current drawing point, used by lineto: messages and altered by
			moveto:, lineto: and polygon:howMany: messages 
		pictureDistance
			is the distance from the viewers eye to the virtual screen which 
			the Context3D represents
		clippingDistance
			is the distance at which all closer drawing will not be drawn (clipped 
			out)
	*/
	
+ newFrame:(NXRect *)frameRect;

	/*
		+newFrame: calls [View +newFrame:frameRect] to create the new View
		object, and	then initiates it's instance variables. The following are 
		initial Values:
			contentView to a new View3D, which should be freed if changed.
			currentPoint to {0.0,0.0,0.0}
			pictureDistance to 1500.0
			clippingDistance to 1.0
	*/
			
- moveto:(vector3D *)where;

	/*	-moveto: set's the currentPoint equal to *where. */

- lineto:(vector3D *)where;

	/*
		-lineto: draws a line on screen from the currentPoint to where after 
		projecting the current point and *where to the Context3D's coordinates
		as a View. It leaves currentPoint == *where
	*/

- polygon:(vector3D *)vertices howMany:(int)count;

	/*
		vertices must point to an array of count elements type vector3D.
		-polygon: howMany: does the equivalent of a moveto: to the first
		vector3D of vertices, and then lineto: to each succesive vertex
		back to the first one.
	*/
	
- contentView;

	/* -contentView returns the id of the current contentView. */

- setContentView:anObject;

	/*
		-setContentView: sets the id of the current contentView, and will
		send [anObject setSuperView:self].
	*/

- setPictureDistance:(float)dist;

	/* 
		sets the pictureDistance instance Variable to dist. dist must be 
		a postitive number. If succesful, setProjection returns self, otherwise 
		it returns nil.
	*/

- setClippingDistance:(float)dist;

	/* 
		sets the clippingDistance instance Variable to dist. dist must be 
		a postitive number. If succesful, setClipping returns self, otherwise 
		it returns nil.
	*/

- drawSelf:(const NXRect *)rects:(int)rectCount;

	/* sends render to its contentView */
@end
