/* File:	MagnifyView.h - View class for 'Magnify'
 *
 * By:		Christopher Lane
 *		Symbolic Systems Resources Group
 *		Knowledge Systems Laboratory
 *		Stanford University
 *
 * Date:	6 March 1990
 *
 * Copyright:	1990 by The Leland Stanford Junior University.  This program
 *		may be distributed without restriction for non-commercial use.
 */
 
#import <cthreads.h>
#import <appkit/appkit.h>

@interface MagnifyView : View
{  
	Bitmap *bitmap;
	Window *invisibleWindow;
	NXPoint mouse;
	NXRect virtualBounds;
	mutex_t lock;
	BOOL frozen;
	char *data;
	int width, height, bps, spp;
}

+ newFrame:(const NXRect *) frameRect;

- (BOOL) acceptsFirstResponder;
- copy:sender;
- drawSelf:(const NXRect *) rects :(int) rectCount;
- free;
- sizeTo:(NXCoord) newWidth :(NXCoord) newHeight;
- mouseMoved:(NXEvent *) theEvent;

- updateBitmap:(NXPoint *) point;

- (BOOL) isFrozen;
- toggleFrozen:sender;

- createWindows:(float) scale;

@end
