#import "BezierApp.h"
#import "Bezier.h"
#import <appkit/Window.h>
#import <appkit/defaults.h>
#import <appkit/Bitmap.h>
#import <appkit/Control.h>
#import <stdlib.h>

@implementation BezierApp

+ new			// create the new application, and make us its delegate.
{
  self = [super new];
  [self setDelegate:self];
  return self;
}
- setBezier:anObject		// let me know where the view is.
{
  bezier=anObject;
  return self;
}
- setLineSlider:anObject	// let me know where the sliders are.
{
  lineSlider=anObject;
  return self;
}
- setControlSlider:anObject
{
  controlSlider=anObject;
  return self;
}
- appDidInit:sender			// set up in the icon, and set the timing.
{
  const char *t;
  if( t=NXGetDefaultValue( [NXApp appName], "LineSize"))
    [bezier setLineWidth:atof( t)];
  if( t=NXGetDefaultValue( [NXApp appName], "BlockSize"))
    [bezier setBlockSize:atof( t)];
  [lineSlider setDoubleValue:[bezier lineWidth]];
  [controlSlider setDoubleValue:[bezier blockSize]];
  [[bezier window] orderFront:self];	// make the window visible.  I didn't
  				// set it to come up right away, so that the
				// user wouldn't see me adjust the defaults.
  return self;
}
- terminate:sender			// store the defaults, and go away.
{
  char s[ 20];
  sprintf( s, "%f", [bezier lineWidth]);
  NXWriteDefault( [self appName], "LineSize", s);
  sprintf( s, "%f", [bezier blockSize]);
  NXWriteDefault( [self appName], "BlockSize", s);
  return [super terminate:sender];
}
- appPowerOffIn:(int)ms andSave:(int)aFlag	// catch Workspace logout.
{
  return [self terminate:self];
}

- windowWillResize:sender toSize:(NXSize *)s	// Just limits a window's size.
{
  NXRect r;
  [sender getFrame:&r];
  s->height=r.size.height;			// kindly change it back.
  return self;
}

@end
