
/* Generated by Interface Builder */

#import "Bezier.h"
#import <appkit/Window.h>
#import <appkit/Control.h>
#import <appkit/Application.h>
#import <dpsclient/psops.h>
#import <dpsclient/wraps.h>
#import <stdlib.h>
#import <math.h>

@implementation Bezier

+ newFrame:(NXRect *)r
{
  int i;
  self = [super newFrame:r];
  p[ 0].x=50.0;			// init all the variables.
  p[ 0].y=200.0;
  p[ 1].x=150.0;
  p[ 1].y=300.0;
  p[ 2].x=250.0;
  p[ 2].y=100.0;
  p[ 3].x=350.0;
  p[ 3].y=200.0;
  lineWidth=2.0;
  blockSize=4.0;
  return self;
}

-(BOOL)acceptsFirstMouse	// accept first mouseDown.
{
  return YES;
}

- setLineWidth:(double)width
{
  lineWidth=width;
  return [self display];
}
- setBlockSize:(double)size
{
  blockSize=size;
  return [self display];
}
- takeLineWidthFrom:sender
{
  return [self setLineWidth:[sender doubleValue]];
}
- takeBlockSizeFrom:sender
{
  return [self setBlockSize:[sender doubleValue]];
}
-(double)blockSize
{
  return blockSize;
}
-(double)lineWidth
{
  return lineWidth;
}

- mouseDown:(NXEvent *)e
{
  NXPoint mLoc;
  int j;
  int saveMask;
  
  mLoc=e->location;				// get location.
  [self convertPoint:&mLoc fromView:nil];	// convert to local View.
  for( j=0; j<4; j++)				// is it a control point?
    if( fabs( mLoc.x-p[ j].x)<=blockSize/2.0
     && fabs( mLoc.y-p[ j].y)<=blockSize/2.0)
      break;					// break out of loop.
  if( j<4)					// found a point,
    {						// change the event mask.
      saveMask=[[self window] addToEventMask:(NX_MOUSEUPMASK |
					      NX_MOUSEDRAGGEDMASK)];
      [self lockFocus];
      do {
        mLoc=e->location;			// each time, get location,
	[self convertPoint:&mLoc fromView:nil];	// and convert.
	p[ j]=mLoc;				// set the right control point.
	[self drawSelf:&bounds :1];		// redisplay.
						// get next event
	e=[NXApp getNextEvent:(NX_MOUSEUPMASK | NX_MOUSEDRAGGEDMASK)];
      } while( e->type!=NX_MOUSEUP);		// until mouse went up.
      [self unlockFocus];
      [[self window] setEventMask:saveMask];	// restore the event mask.
    }
  return self;
}

- drawSelf:(NXRect *)r :(int)count
{
  int i;
  PSsetlinecap( 1);				// rounded line caps.
  PSsetgray( NX_LTGRAY);			// clear the background.
  NXRectFill( &bounds);
  PSsetlinewidth( lineWidth);			// set the line width.
  PSsetgray( NX_BLACK);				// draw the line.
  PSmoveto( p[ 0].x, p[ 0].y);
  PScurveto( p[ 1].x, p[ 1].y, p[ 2].x, p[ 2].y, p[ 3].x, p[ 3].y);
  PSstroke();
  PSsetgray( NX_DKGRAY);
  for( i=0; i<4; i++)
    PSrectfill( p[ i].x-blockSize/2.0, p[ i].y-blockSize/2.0, blockSize, blockSize);
  [[self window] flushWindow];
  NXPing();
  return self;
}

@end
