
//  This program flips through premade tiff files.
//  Blake Hughes   University of Kansas   hughes@next1.cs.ukans.edu

#import "myView.h"
#import <dpsclient/dpsclient.h>

@implementation myView

- load:sender
{
	static int data_loaded=FALSE;
	char path[100];
	int count;

	frame_count=1;  // initialization stuff
	direction=1;    // here because - initialize is not being called
	speed=.25;      // or it is not working right!!!

	if(!data_loaded) {
		[NXwait push];        // Change cursor to wait
		for(count=1;count<61;count++) {
			sprintf(path,"./data/world%d.tiff",count);
			myBitmap[count]=[Bitmap newFromTIFF:path];
		}
		[NXwait pop];         // Change cursor back
		data_loaded=TRUE;
		[sender setTitle:"Loaded!"];
	}
	[sender setState:0];
    return self;
}

- initialize
{
	frame_count=1;
	direction=1;
	speed=.25;
printf("\ndirection=%d   frame_count=%d\n",direction,frame_count);
}

- left:sender
{
    direction=1;
    return self;
}

- right:sender
{
    direction=-1;
    return self;
}

- rotate
{
	static NXPoint here={0.0, 0.0};

	switch(frame_count) {
		case 1 : if(direction==-1) {
					frame_count=60;
					break;
				 }			
				else {
					frame_count++;
					break;
				}
		case 60 :if(direction==1) {
					frame_count=1;
					break;
				}
				else {
					frame_count--;
					break;
				}
		default : frame_count+=direction;
				  break;
	}

	[self lockFocus];
	[myBitmap[frame_count] composite:NX_SOVER toPoint:&here];
	[self display];
	[self unlockFocus];
}

void doIt (DPSTimedEntry te, double timeNow, void *data)
{
	[(id)data rotate];
}

- stop:sender
{
	if (running) {
		DPSRemoveTimedEntry (mouseTE);
		running = NO;
	}
	else {
      	mouseTE = DPSAddTimedEntry(speed, &doIt, self, 1);
      	running = YES;
	}
	return self;
}

- speed:sender
{
	speed=[sender doubleValue];
	[self stop:sender];
	[self stop:sender];

    return self;
}

@end
