#import "Myapp.h"
#import "RLE.h"
#import "RASF.h"
#import <rle.h>
#import <stdio.h>
#import <stdlib.h>
#import <appkit/OpenPanel.h>
#import <strings.h>

// Myapp.m
// 
// Written by Vince DeMarco 
// 	demarco@cpsc.ucalgary.ca
//
// This program is In the Public Domain. If you make any improvements to this
// program please let me know
// 

@implementation Myapp:Application
+ new
{
    self = [super new];
    [self activateSelf:NO];
    return(self);
}

- (int)appOpenFile:(const char *)fullPath type:(const char *)type
{
    id                  ptr;
 
    [self activateSelf:NO];
    if (!strcmp(type,"rle"))
	ptr = [[RLE alloc]init];
    else
	ptr = [[RASF alloc]init];
    [ptr open:(char *)fullPath];
    return YES;
}

- (BOOL)appAcceptsAnotherFile:sender
{
    return YES;
}

- openfile:sender
{
    char                      temp[1024];
    char                      directory[1024];
    char                     *extension;
    id                        ptr;
    int                       loop;
    static const char  *const opentypes[] = {"rle","rasf",NULL};

    openpanel = [OpenPanel new];
    [openpanel allowMultipleFiles:YES];

    if ([openpanel runModalForTypes:opentypes]) {
	loop = 0;
	strncpy(directory,[openpanel directory],1024);
	while ([openpanel filenames][loop]) {
	    sprintf(temp,"%s/%s",directory,[openpanel filenames][loop]);
	    extension = rindex(temp,'.');
	    if (!strcmp(extension,".rle"))
		ptr = [[RLE alloc]init];
	    else
		ptr = [[RASF alloc]init];

	    [ptr open:temp];
	    ++loop;
	}
    }
    return(self);
}
@end
