/*
Copyright Notice:
	Copyright 1990 Robert C. Hood
	This software is distributed "as is" without warranty.  Use this software at your OWN RISK.  Source may be distributed freely, at NO CHARGE, but must be accompanied by this documentation and copyright notice.
*/
#include <stdio.h>
#include "giflib.h"


startbuffer (size)
int size;
	{
	GIF_max = fread (&GIF_buffer, 1, size, GIF_file);
	GIF_bufptr = 0;
	GIF_bitbuffer = ((unsigned int)GIF_buffer [GIF_bufptr]) |
		((unsigned int)GIF_buffer [GIF_bufptr + 1] << 8) |
		((unsigned int)GIF_buffer [GIF_bufptr + 2] << 16) |
		((unsigned int)GIF_buffer [GIF_bufptr + 3] << 24);
	GIF_bufptr += 4;
	GIF_bits = 0;
	}

getbits (num)
register int num;
	{
	register int reply;
	register unsigned int temp;

	reply = (0xFFFFFFFF >> (32 - num)) & GIF_bitbuffer;
	GIF_bitbuffer = GIF_bitbuffer >> num;
	GIF_bits += num;
	while (GIF_bits >= 16)
		{
		temp = (unsigned int)GIF_buffer [GIF_bufptr++];
		temp |= (unsigned int)GIF_buffer [GIF_bufptr++] << 8;
		GIF_bitbuffer |= ((unsigned int)temp << (32 - GIF_bits));
		GIF_bits -= 16;
		}
	return reply;
	}

