/* @(#)src/route.h	1.2 24 Oct 1990 05:24:21 */

/*
 *    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
 * 
 * See the file COPYING, distributed with smail, for restriction
 * and warranty information.
 */

#ifndef	ROUTE_H
#define ROUTE_H

/*
 * route.h:
 *	interface file for route.c.  Also, types and macros for
 *	use by router drivers.
 */

/* structure of a router, as read from the configuration file */
struct router {
    char *name;				/* name of router */
    char *driver;			/* name of driver */
    struct router *succ;		/* next router in the list */
    long flags;				/* boolean flag values */
    struct method *method;		/* table of host/tport associations */
    char *default_transport;		/* name of default transport */
    char *private;			/* private data storage */
};

/* method - table associating hosts and transports */
struct method {
    char *host;				/* host name */
    char *transport;			/* transport name */
};

/* compiled in route drivers */
struct route_driver {
    char *name;				/* name of route driver */
    void (*cache)();			/* function to cache routing info */
    void (*driver)();			/* function to perform routing */
    void (*verify)();			/* function to perform verification */
    void (*finish)();			/* function to free resources */
    char *(*builder)();			/* fun to read from router file */
};

/* values for router.flags field */
#define USE_ALWAYS	0x0001		/* if match, don't use next router */

#endif	/* ROUTE_H */
