#!/bin/sh
# @(#)samples/bsmtp/batchsmtp.sh	1.2 24 Oct 1990 04:51:31

# deliver messages accumlated into subdirectories of the
# outq spool directory.  Subdirectory names are based on
# the actual hostnames involved:

OUTQ=/usr/spool/smail/outq
UUX=/usr/bin/uux
LOCALHOST=busboy.uts.amdahl.com

cd $OUTQ
# loop through all of the subdirectories
for i in *; do (
	cd $i
	list=q*		# get the list of message files
	if [ "$list" = "*" ]; then
		# no messages were found
		exit 0	# leave sub-shell
	fi
	# send all of the files, adding HELO and QUIT commands
	(echo "HELO $LOCALHOST"
	 cat $list
	 echo QUIT) | $UUX - $i!rsmtp
	rm $list
); done

exit 0
