/* @(#)pd/binmail/binmail.c	1.2 24 Oct 1990 05:18:59 */
/* This program will be used in place of /bin/mail on SVR2 sites.
 * It looks at the arguments and decides whether to call
 * SMAIL for sending mail, or LMAIL for reading mail.
 *
 * before installing as /bin/mail, move the stock /bin/mail to /bin/lmail
 *
 */

#include <stdio.h>
#include "defs.h"

#ifndef LMAIL
#define LMAIL "/bin/lmail"
#endif

#ifndef SMAIL
#define SMAIL "/usr/lib/sendmail"
#endif

#define TRUE 1
#define FALSE 0

char *program;

void	perror(), exit(), usage();

main(argc, argv)
int argc;
char *argv[];
{
	int i, j, c;		/* indexes */
	int reading = FALSE;	/* TRUE => user read mail, run LMAIL */
	int sending = FALSE;	/* TRUE => sending mail, call Smail directly */
	extern int optind;
	extern char *optarg;

	/*
	 * parse args
	 */
	program = argv[0];
	if(argc == 1) {
		/* no args means just a user wanting to read their mail */
		reading = TRUE;
	} else {
		while((c = getopt(argc, argv, "epqrtf:")) != EOF) {
			switch(c) {
			case 'e':
			case 'p':
			case 'q':
			case 'r':
			case 'f':
				reading = TRUE;
				break;
			case 't':
				sending = TRUE;
				break;
			default:
				usage();
				exit(1);
			}
		}
	}
	/* any arguments left over -> sending */
	if(argc > optind) {
		sending = TRUE;
	}
	if((reading == TRUE) && (sending == TRUE)) {
		usage();
		exit(1);
	}

	/*
	 * form arguments
	 */
	if(sending == TRUE) {
		argv[0] = SMAIL;
		for(i = 1, j = optind; i < argc; i++, j++) {
			argv[i] = argv[j];
		}
		argv[i] = NULL;
	} else {
		argv[0] = LMAIL;
		argv[1] = NULL;
	}

	/*
	 * exec our real program
	 */
	(void) execv(argv[0], argv);
	(void) fprintf(stderr, "%s: execv(\"%s\", argv) failed: ",
		program, argv[0]);
	perror("");
	exit(1);
}

void
usage()
{
	(void) fprintf(stderr, "usage: %s [ -epqr ] [ -f file ]\n", program);
	(void) fprintf(stderr, "or usage: %s [ -t ] persons\n", program);
}
