:
#!/bin/sh
# @(#)conf/lib/instm.sh	1.2 24 Oct 1990 05:16:06
# Install a set of files into a directory
#
# usage: sh instm.sh [-sr] [-u user] [-g group] [-m mode] dir file...
#
#    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
# 
# See the file COPYING, distributed with smail, for restriction
# and warranty information.

# Don't use getopt(1), as we can't rely on it being built yet, or
# existing on the system.
usage="Usage: instm.sh [-sr] [-u user] [-g group] [-m mode] dir file..."
user=
group=
mode=
err=0
strip=
rm_old=
dbg=

# put /etc in path, for chmod
PATH="$PATH:/etc"

# Note:  this shell script uses case rather than test, where possible
#	 to prevent a fork/exec on systems where test is not a builtin.

# process the list of options.
# Note:  the option letters and option arguments must be separate tokens.
while : ; do
	case $# in
	0)	break;
	esac
	case "$1" in
	--)	shift; break;;
	-[ugm])case $# in
		1)	err=1;;
		esac
		case "$1" in
		-u)	user="$2";;
		-g)	group="$2";;
		-m)	mode="$2";;
		esac
		shift; shift;;
	-s)	strip=true; shift;;
	-r)	rm_old=true; shift;;
	-D)	dbg=echo; shift;;
	-*)	err=1; break;;
	*)	break;
	esac
done

# There must be at least two operands
case $# in
0|1)	err=1;;
esac

# If an error occured, spit out a usage message.
case "$err" in
1)	echo "$usage" 1>&2
	exit 1;;
esac

# the directory name is the first operand
dir="$1"; shift

for file in "$@"; do
	dst="$dir/$file"
	new="$dst.NEW"
	old="$dst.OLD"
	$dbg rm -f "$new" "$old"
	$dbg ln "$dst" "$old" 2> /dev/null
	if $dbg cp "$file" "$new"; then
		:
	else
		$dbg rm -f "$old"
		echo "instm: failed to copy $file to $dst" >&2
		err=1
		continue
	fi
	case "$strip" in
	?*)	strip "$new";;
	esac
	case "$user" in
	?*)	if $dbg chown "$user" "$new"; then
			:
		else
			$dbg rm -f "$new" "$old"
			echo "instm: failed to change owner of $dir" 1>&2
			err=1
			continue
		fi;;
	esac
	case "$group" in
	?*)	if $dbg chgrp "$group" "$new"; then
			:
		else
			$dbg rm -f "$new" "$old"
			echo "instm: failed to change group of $dir" 1>&2
			err=1
			continue
		fi;;
	esac
	case "$mode" in
	?*)	if $dbg chmod "$mode" "$new"; then
			:
		else
			$dbg rm -f "$new" "$old"
			echo "instm: failed to change mode of $dir" 1>&2
			err=1
			continue
		fi;;
	esac
	if $dbg mv "$new" "$dst" < /dev/null; then
		echo "installed $file as $dst"
	else
		$dbg rm -f "$new" "$old"
		echo "instm: failed to install $file as $dst" 1>&2
		err=1
		continue
	fi
	case "$rm_old" in
	?*)	rm -f "$old";;
	esac
done

exit $err
