/*----------------------------------------------------------------------
    See memlog.c for more explaination. This can be used to analyze  
  malloced memory use.
----*/


#define fs_get(n)       (fs_get2((n), __FILE__, __LINE__))
#define malloc(n)       (malloc2((n), __FILE__, __LINE__))
#define cpystr(s)       (cpystr2((s), __FILE__, __LINE__))
#define fs_give(s)      (fs_give2((s), __FILE__, __LINE__))
#define fs_resize(s, n) (fs_resize2((s), (n), __FILE__, __LINE__))
#define realloc(s, n)   (realloc2((s), (n), __FILE__, __LINE__))
#define free(s)         (free2((s), __FILE__, __LINE__))

#ifdef ANSI
void *fs_get2(int, char *, int);
void *malloc2(int, char *, int);
char *cpystr2(char *, char *, int);
void fs_give2(void **, char *, int);
void fs_resize2(void **, int, char *, int);
void *realloc2(char *, int, char *, int);
void free2(char *, char *, int);
#else
void *fs_get2();
void *malloc2();
char *cpystr2();
void fs_give2();
void fs_resize2();
void *realloc2();
void free2();
#endif






