
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <assert.h>
#include <time.h>



main()
{
   int fd;
   int ret;
   int count;
   unsigned char buf[512*512+1];
   float rate;
   
   int num=50;
   long startTime;
   long endTime;
   long diff;
   int i;
   
   fprintf(stderr,"test perfomance start\n");
   

   fd = open( "/dev/cortex" , O_RDWR );
   if ( fd < 0 )
   {
      fprintf(stderr,"ctest open failed with %d \n",fd);
      exit(1);
   }
     
   startTime = time(NULL);
   
   count = 486*512;
   for( i=0 ; i <num ; i++ )
   {
      /* fprintf(stderr,"try %d \n",i); */
      
      lseek(fd,0,SEEK_SET );
      ret=read(fd, buf, count);
      assert( ret == 486*512 );
   }   
   endTime = time(NULL);
   
   diff = endTime-startTime;
   fprintf(stderr,"read in %ld seconds \n",diff);
   
   rate = (float)(num)/(float)(diff);
   fprintf(stderr,"transfer rate %3.1f frames per second\n",rate);

   rate = (float)(num)*486*512/( (float)(diff)*1024*1024 );
   fprintf(stderr,"transfer rate %3.1f meg. bytes per second\n",rate);
   
   close(fd);


     
   startTime = time(NULL);
   
   count = 486*512;
   for( i=0 ; i <num ; i++ )
   {
      /* fprintf(stderr,"try %d \n",i); */
      fd = open( "/dev/cortex" , O_RDWR );
      ret=read(fd, buf, count);
      assert( ret == 486*512 );
      close(fd);
   }   
   endTime = time(NULL);
   
   diff = endTime-startTime;
   fprintf(stderr,"read in %ld seconds \n",diff);
   
   rate = (float)(num)/(float)(diff);
   fprintf(stderr,"grab rate %3.1f frames per second\n",rate);

   rate = (float)(num)*486*512/( (float)(diff)*1024*1024 );
   fprintf(stderr,"grab rate %3.1f meg. bytes per second\n",rate);
   

   fprintf(stderr,"ctest done\n");
   exit(0);
}
