#!/bin/bash
# @(#)backup_daily.sh - backup directories daily v1.1, (C)mpan 1/2006
# This software is originally copyright (C) by Mika Panhelainen 2003, 2006
# Note: create first date.lock to the daily backup directory

# Daily backup directory
daily="/mnt/backup/daily"

# Directories to be backed up
dirs="/home /root"

# Move to the backup directory
cd $daily

# Only root has access to the backup files. Also umask 027 may be used
umask 077

# Incremental backup. Modification time of date.lock defines what 
# files to be backed up. Backup file is  
# <week day: Sun, Mon, etc.>.backup.tar.gz and end of list of files is .txt.
# File errors.txt holds errors that occurred during backup
tar -N ./date.lock -czvf `date +%a`.backup.tar.gz $dirs 1>./`date +%a`.backup.tar.gz.txt 2>./errors.txt
error=$?

# If no errors during backup procedure, create new date.lock 
# for the next incremental
if [ $error = 0 ]
then
    touch ./date.lock
else

# Send error message to the root
    mail -s "Error in backup_daily.sh" root@localhost <./errors.txt
fi
