/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  xmps_config.h
 *
 *  Definitons file for the options.
 *  @Author : Damien Chavarria (1999)
 *
 */

#ifndef _XMPS_CONFIG_H
#define _XMPS_CONFIG_H

#include <glib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

typedef struct
{
        gchar *key;
        gchar *value;
}
ConfigLine;

typedef struct
{
        gchar *name;
        GList *lines;
}
ConfigSection;

typedef struct
{
        GList *sections;
}
ConfigFile;

ConfigFile *xmps_cfg_new(void);
ConfigFile *xmps_cfg_open_file(gchar * filename);
gboolean xmps_cfg_write_file(ConfigFile * cfg, gchar * filename);
void xmps_cfg_free(ConfigFile * cfg);
ConfigFile *xmps_cfg_open_default_file(void);
gboolean xmps_cfg_write_default_file(ConfigFile * cfg);

gboolean xmps_cfg_read_string(ConfigFile * cfg, gchar * section, gchar * key, gchar ** value);
gboolean xmps_cfg_read_int(ConfigFile * cfg, gchar * section, gchar * key, gint * value);
gboolean xmps_cfg_read_boolean(ConfigFile * cfg, gchar * section, gchar * key, gboolean * value);
gboolean xmps_cfg_read_float(ConfigFile * cfg, gchar * section, gchar * key, gfloat * value);
gboolean xmps_cfg_read_double(ConfigFile * cfg, gchar * section, gchar * key, gdouble * value);

void xmps_cfg_write_string(ConfigFile * cfg, gchar * section, gchar * key, gchar * value);
void xmps_cfg_write_int(ConfigFile * cfg, gchar * section, gchar * key, gint value);
void xmps_cfg_write_boolean(ConfigFile * cfg, gchar * section, gchar * key, gboolean value);
void xmps_cfg_write_float(ConfigFile * cfg, gchar * section, gchar * key, gfloat value);
void xmps_cfg_write_double(ConfigFile * cfg, gchar * section, gchar * key, gdouble value);

void xmps_cfg_remove_key(ConfigFile * cfg, gchar * section, gchar * key);

#endif
