/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * types.h
 *
 * General types and constants. (used by all units)
 * @Author Chavarria Damien.
 * 	   Copyrigth 1999-2000
 */

#include <gtk/gtk.h>
#include <pthread.h>

/* CONSTANTS */

#ifndef _TYPES_H
#define _TYPES_H

/* for buttons */
 #define NORMAL 0
 #define PUSHED 1

/* for toggled buttons */
 #define NORMAL_TOGGLED 2
 #define PUSHED_TOGGLED 3  

/*for zones in general */
 #define INACTIVE 0
 #define ACTIVE   1

/* for the image size */

#define IMAGE_DEFAULT_SIZE_X 103
#define IMAGE_DEFAULT_SIZE_Y 77

#define NO_TIME -4271

#define GTK_PLAYER     0
#define SKINNED_PLAYER 1

/* TYPES */

/* enums for actions */
 typedef enum {
 	       NONE,
	       ABOUT_MENU_CLICKED,
 	       INVERT_TIME_DIGIT_CLICKED,
 	       LOOP_DIGIT_CLICKED,
 	       FULL_SCREEN_BUTTON_CLICKED,
	       LOOP_BUTTON_CLICKED,
	       PLAYLIST_BUTTON_CLICKED,
	       REWIND_BUTTON_CLICKED,
	       STOP_BUTTON_CLICKED,
 	       PLAY_BUTTON_CLICKED,
	       PAUSE_BUTTON_CLICKED,
 	       FAST_FORWARD_BUTTON_CLICKED,
	       LOAD_BUTTON_CLICKED,
	       PROGRESS_BAR_MOVING,
	       VOLUME_BAR_MOVING,
	       BALANCE_BAR_MOVING,
	       WINDOW_MOVING,
	       WINDOW_CLOSING,
	       WINDOW_RESIZING,
	       PLAYLIST_MENU_CLICKED,
	       PLAYLIST_TITLE_CLICKED,
	       PLAYLIST_CLOSE_CLICKED,
	       PLAYLIST_ITEMS_CLICKED,
	       PLAYLIST_ADD_BUTTON_CLICKED,
	       PLAYLIST_REMOVE_BUTTON_CLICKED,
	       PLAYLIST_SORT_BUTTON_CLICKED,
	       PLAYLIST_RAND_BUTTON_CLICKED,
	       PLAYLIST_RESIZE_CLICKED,
	       PLAYLIST_CURSOR_CLICKED,
	      } XMPS_Action;

/* video formats */

typedef enum {
  XMPS_VIDEO_YUV,
  XMPS_VIDEO_RGB565,
  XMPS_VIDEO_RGB555,
  XMPS_VIDEO_RGB888,
  XMPS_VIDEO_RGB32
} XMPSVideoFormat;

/* rectangle type */
typedef struct {
 		gint start_x;
 		gint start_y;
 		gint size_x;
 		gint size_y;
               } XMPS_rect;

/* progress bars */
 typedef struct {
 		 XMPS_rect bar_rect;
 		 XMPS_rect cursor_rect;
		 
		 gint pos_x;
		 gint pos_y;
		 gint cursor_pos_x;
		 gint cursor_pos_y;
		 
		 gint value; /* 0 to 100 */ 
 		 
		 } XMPS_progress_bar;

/* infos on mpeg files */
 typedef struct {
		 char * filename;
		 char * directory;
		 int    fps;
		 long   file_size;
		 int    nb_frames;
	       } MPEG_file_info;

/* for a skin */
typedef struct {
  gchar       *directory;
  gchar       *name;
  GdkColor    playlist_bgcolor;
  GdkColor    filename_bgcolor;
  GdkColor    filename_font_color;
  GdkColor    playlist_font_color;
  GdkColor    playlist_selected;
} XMPS_skin;	       

/* La playlist */
		
typedef struct {
		 MPEG_file_info file_info;
		 gint           selected;
		} XMPS_playlist_item;


typedef struct {
  		 gint                playlist_pos_x;
 		 gint                playlist_pos_y;
                 gint                playlist_size_x;
		 gint                nbr_lines;
		 
		 guint               nbr_items;
		 gint                current_display_position;
		 gint 		     current_play_position;
		 GList		     *list;
	        } XMPS_playlist;

								       			       	       
/* main type for describing the application */
typedef struct {

  gint        window_type;
  
  gint        window_pos_x;
  gint        window_pos_y;
  gint        window_size_x;
  gint        window_size_y;

  gint        has_focus;
  gint        playlist_has_focus;
        
  gint       save_window_pos;
  gint       save_skin;
 
  gint       is_playlist_toggled;
  gint	     is_playlist_glued;
  gint       allways_glued;
  gint       allow_multiples_instances;
  gint       reverse_file_order;
  gint       scroll_title;
  gint       confirm_fullscreen;
  gint       save_on_exit;

  gint       save_playlist_content;
  gint       save_playlist_pos;
  gint       save_playlist_size;
  gint       playlist_multiple_selection;

  int	     is_invert_time;
  int	     is_loop;

  gint       fullscreen;
  char *     current_renderer;

  char *     filesel_dir;
  
  guint32     current_time;	
  XMPS_Action current_action;
  
  XMPS_skin *current_skin;
  
  XMPS_progress_bar balance_bar;
  XMPS_progress_bar volume_bar;
  XMPS_progress_bar progress_bar;

  unsigned int  current_file_size;
  
} XMPS_Info;

/* For plugins */

typedef enum { CODEC_PLAYING, CODEC_PAUSED, CODEC_STOPPED } XMPSCodecStatus;

typedef unsigned char byte;

typedef void (*XMPS_DisplayCallback) (byte *image, 
				      unsigned int x,
				      unsigned int y,
				      unsigned int w, 
				      unsigned int h);

typedef struct {

  unsigned int width;
  unsigned int height;

} XMPSVideoInfo;

/* GLOBAL VARIABLES */

/* Drag and Drop */

XMPS_playlist  playlist;
XMPS_Info      xmps_config;
GtkAccelGroup  *global_accel;
GtkWidget      *window;
char           SDL_windowhack[32];
gint           IDLE;
gint           RESIZED;


#endif













