/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *
 * plugin.h
 *
 * Plugins specifications.
 * @Author Chavarria Damien.
 * 	   Copyright 1999-2000
 */

#ifndef _XMPS_PLUGIN_H
#define _XMPS_PLUGIN_H

#include "xmps_config.h"
#include "types.h"

enum { SDL, X11, OpenGL };

typedef struct {
  
  void *handle;
  char *filename;         
  char *description;      
  int  enabled;

  void (*init) (void);    
  void (*about) (void);   
  void (*configure) (void);
  void (*load_options) (ConfigFile *cfg);
  void (*save_options) (ConfigFile *cfg);
  int  (*is_our_file) (char *filename);
  int  (*open) (char *filename);
  void (*play) ();     
  void (*stop) (void);    
  void (*pause) (void);  
  void (*rewind) (void);   
  void (*seek) (int percent);        
  void (*close) (void);
  void (*get_volume) (void);    
  void (*set_volume) (int volume);      
  void (*file_info_box) (char *filename);   
  void (*set_surface) (int type, void *surface);
  
  void (*set_callback) (XMPS_DisplayCallback callback);

  XMPSCodecStatus (*get_status) (void);
  int             (*has_file)   (void);
  void            (*video_info) (XMPSVideoInfo *info);
  void            (*scale) (int x, int y);
  unsigned int    (*get_actual_position) (void);
  unsigned int    (*get_file_size) (char *filename);
  int             (*move_into_display) (int x, int y);
  XMPSVideoFormat (*get_available_formats)(void);

} XMPSCodec;


typedef struct  {
 
  void *handle;
  char *filename;      
  char *description;
  char *text;

  XMPSCodec *current_codec;

  int       (*init)(void);
  int       (*start_new_play)(XMPSCodec *codec);
  int       (*handle_structure_event)(int x, int y);
  int       (*check_for_events)();
  int       (*stop)();
  int       (*go_fullscreen)();
  int       (*move_display)(int x, int y);
  int       (*use_window_id)(int id);

} XMPSRenderer;


#endif
