/********************************************************

	Video decoder implementation
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 27.06.2000

*********************************************************/


#include <videodecoder.h>
#include <string.h>
int VideoDecoder::Init(const char* format)
{
    if(m_iState>0)
	return -1;//already initialized
    if(format==0)
	return -1;
    memset(&m_cv, 0, sizeof(m_cv));
    memcpy(&m_bh, format, sizeof(m_bh));
    memset(&m_obh, 0, sizeof(m_obh));
    m_obh.biSize=sizeof(m_obh);
    m_cv.cbSize=sizeof(m_cv);
    m_cv.hic=ICOpen(
    	0x63646976,//vidc
	m_bh.biCompression,
	ICMODE_FASTDECOMPRESS);
    if(m_cv.hic==0)
    {
	printf("VideoDecoder:: ICOpen failed\n");
	return -1;
    }
   // m_cv.fccType=0x63646976;
   // m_cv.fccHandler=m_bh.biCompression;
    
    HRESULT h=ICDecompressGetFormat(m_cv.hic, &m_bh, &m_obh);
    if(h!=0)
    {
	printf("VideoDecoder:: Can't handle this format\n");
	ICClose(m_cv.hic);
	return -1;
    }
    m_outFrame=new char[m_obh.biSizeImage?m_obh.biSizeImage:m_obh.biWidth*m_obh.biHeight*m_obh.biBitCount/8];
    if(m_outFrame==0)
    {
	printf("VideoDecoder:: Memory failure\n");
	ICClose(m_cv.hic);
	return -1;
    }	
    m_iState=1;		
    return 0;
}
int VideoDecoder::Start()
{
    if(m_iState!=1)
	return -1;//wrong state
    HRESULT h=ICDecompressBegin(m_cv.hic, &m_bh, &m_obh);
    if(h!=0)
    {
	printf("VideoDecoder::Start: ICDecompressBegin() failed ( shouldn't happen )\n");
	return -1;
    }
    m_iState=2;
    return 0;		
}
int VideoDecoder::Stop()
{
    if(m_iState!=2)
	return -1;//wrong state
    HRESULT h=ICDecompressEnd(m_cv.hic);
    if(h!=0)
    {
	printf("VideoDecoder::Stop: ICDecompressEnd() failed ( shouldn't happen )\n");
	return -1;
    }
    m_iState=1;
    return 0;		
}
int VideoDecoder::Close()
{
    if(m_iState==0)
	return -1;
    ICClose(m_cv.hic);
    delete m_outFrame;
    m_outFrame=0;
    m_iState=0;
}
/*
int VideoDecoder::QueryOutputSize() const
{
    if(m_iState==0)
	return -1;
    return m_obh.biSizeImage?m_obh.biSizeImage:m_obh.biWidth*m_obh.biHeight*m_obh.biBitCount/8;    
}
*/
int VideoDecoder::DecodeFrame(char* src, int size, int is_keyframe)
{
//	int smth1, st1, st2;
//	st1=localcount();
//	printf("Key frame %d\n", is_keyframe);
//	printf("Data %08X\n", *(int*)from);
	m_bh.biSizeImage=size;
	return ICDecompress(m_cv.hic, is_keyframe?0:ICDECOMPRESS_NOTKEYFRAME,
		 &m_bh, src, &m_obh, m_outFrame);
//	return ICDecompress(m_cv.hic, 0,
//		 &m_bh, src, &m_obh, m_outFrame);
//	st2=localcount();
//	printf("%f ms\n", (float)(st2-st1)/550000.);
}
int VideoDecoder::SetBitDepth(int bits)
{
    if(m_iState!=1)
	return -1;
    BITMAPINFOHEADER temp=m_obh;
    temp.biBitCount=bits;
    temp.biSizeImage=m_obh.biWidth*m_obh.biHeight*temp.biBitCount/8;    
    HRESULT h=ICDecompressQuery(m_cv.hic, &m_bh, &temp);
    if(h==0)
	m_obh=temp;
    return (h==0)?0:-1;
}
int VideoDecoder::SetExtendedMode(int mode, int bits)
{
    if(m_iState!=1)
	return -1;
    BITMAPINFOHEADER temp=m_obh;
    temp.biBitCount=bits;
    temp.biCompression=mode;
    temp.biSizeImage=m_obh.biWidth*m_obh.biHeight*temp.biBitCount/8;    
    HRESULT h=ICDecompressQuery(m_cv.hic, &m_bh, &temp);
    if(h==0)
	m_obh=temp;
    return (h==0)?0:-1;
}
int VideoDecoder::SetColorSpace(int csp)
{
    if(m_iState!=1)
	return -1;
    BITMAPINFOHEADER temp=m_obh;
    temp.biCompression=csp;
    HRESULT h=ICDecompressQuery(m_cv.hic, &m_bh, &temp);
    if(h==0)
	m_obh=temp;
    return (h==0)?0:-1;
}
