#include <stdio.h>
#include <videoencoder.h>
#include <avifile.h>
int main(int argc, char** argv)
{
    VideoEncoder enc;
    
    if(argc!=2)
    {
	printf("Usage: %s <output file>\n", argv[0]);
	return 0;
    }	
    FILE* f1=fopen("./uncompr.bmp", "rb");
    fseek(f1, 14, SEEK_SET);
    BITMAPINFOHEADER bh;
    BITMAPINFOHEADER obh;
    fread(&bh, 0x28, 1, f1);
    char pic[384*288*3];
    fread(pic, 384*288*3, 1, f1);
    
    bh.biSizeImage=384*288*3;
    bh.biBitCount=24;
    AviWriteFile file;
    file.Create(argv[1]);
    AviWriteStream* stream=file.AddStream(AviWriteStream::Video);
//    int fccHandler=fccDIV3;
    int fccHandler=fccIV50;
    stream->SetHeader(fccHandler, 40000, 0);

    VideoEncoder::SetExtendedAttr(fccDIV3, "BitRate", 4500);
    
    if(enc.Init(fccHandler, (char*)&bh)!=0)
    {
	printf("Init() failed\n");
	return -1;
    }
    int size=enc.QueryOutputSize();
    if(size<=0)
    {
	printf("QueryOutputSize() failed\n");
	return -1;
    }
    else printf("Driver reported %d as a maximum output size\n", size);
    char* compressed;
    compressed=new char[size];
    enc.Start();
    int keyf;

    obh=enc.QueryOutputFormat();
    stream->SetFormat((char*)&obh, sizeof(obh));

    for(int i=0; i<72; i++)
    {
        enc.EncodeFrame(pic, compressed, &keyf, &size);
        stream->AddChunk(compressed, size, keyf);
	memset(pic+384*i*2*3, 0, 384*2*3);
	memset(pic+384*(143-i)*2*3, 0, 384*2*3);
    }
    file.Close();	
	
    
    enc.Stop();
    delete compressed;
    fclose(f1);

    ICDoSomething();    
    return 0;
}    
    