/********************************************************

	Main AVI player widget
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 13.07.2000

*********************************************************/

//#define USE_ESD
//#define Debug  if(debug_status==0)
#define Debug
#define Sync
#define DEBUG_TOCONSOLE


#include <stdio.h>
#include <iostream>

#include <qwidget.h>
//#include <qcolor.h>
//#include <qapp.h>
//#include <qimage.h>
#include <qapp.h>
#include <qpainter.h>
#include <qobject.h>
#include <qtimer.h>
#include <qpushbutton.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <iostream.h>
#include <assert.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
//#include <signal.h>

#ifdef USE_ESD
#include <esd.h>
#endif

#include <sys/soundcard.h>

#include "renderer.cc"
#include "mywidget.h"

VideoRenderer *renderer;

using namespace std;



extern MyWidget* m;
int quit=0;

void killer(int z)
{
    quit=1;
}


extern void v555to565(short* dest, const short* src, int w, int h);
MyPainter* painter;

bool MyWidget::close( bool alsoDelete )
{
    killer(0);
    return QWidget::close(alsoDelete);
}
void MyWidget::paintEvent(QPaintEvent *)
{
    printf("paintEvent\n");
    return;
}


void MyWidget::reseek()
{
    if(player==0)return;
    double pos=scroller->value();
//    scroller->setValue(player->reseek(pos));
    player->reseek_exact(pos);
}

MyWidget::MyWidget(int width, int height)
{
    initialized=0;
    renderer=0;
    resize(width, height);
}

MyWidget::~MyWidget()
{
    if(renderer)
	delete renderer;
    renderer=0;
    if(painter)
	delete painter;
    painter=0;
    if(player)
	delete player;
    player=0;
    ICDoSomething();
}
void drawfunc(char* data)
{
//    MyPainter painter(m);
    renderer->Draw(painter, data);
    qApp->processEvents(10);
}
void posfunc(double pos)
{
    m->updatePos(pos);
}
void MyWidget::updatePos(double pos)
{
    if(painter==0)return;
    if(!scroller->draggingSlider())
	scroller->setValue(pos);
//    MyPainter p(this);
    char dropstring[100];
    sprintf(dropstring, "Drop: %.2f %%", player->GetDrop());
    painter->eraseRect(5, 15+::height, ::width-5, 45);
    painter->drawText(5, 45+::height, dropstring);
/*	if(::width>320)
         {
	    p.drawText(5, 45+::height, QString("Read/dec/draw: ")+stat.string()+"="+total.string()+" ms");
             p.drawText(225, 45+::height, QString("Drop: ")+drop.string()+QString("%"));
         }
         else
         {
	    p.drawText(5, 45+::height, QString("Drop: ")+drop.string()+QString("%"));
         }*/
    char timing[50];
    if(player->width()>80)
    {
	double len=player->GetVideoLength();
        double stream_time=pos;
        if(stream_time>=3600)
    	    sprintf(timing, "%d:%02d:%02d/",
		int(stream_time/3600), int(stream_time/60)%60,
    		int(stream_time)%60);
	else
	    sprintf(timing, "%02d:%02d/",
		int(stream_time/60)%60,
		int(stream_time)%60);
	if(len>=3600)
	    sprintf(timing+strlen(timing), "%d:%02d:%02d",
		int(len/3600), int(len/60)%60,
		int(len)%60);
	else
	    sprintf(timing+strlen(timing), "%02d:%02d",
		int(len/60)%60,
		int(len)%60);
	painter->drawText(::width-90, ::height+45, timing);
    }
}    
int MyWidget::initPlayer(const char* filename)
{
    player=new AviPlayer;
    player->setKillHandler(&killer);
    player->setDrawCallback(&drawfunc);
    player->setPosCallback(&posfunc);
    int success=player->initPlayer(filename, x11Depth());
    if(success!=0)
    {
	delete player;
	player=0;
	return success;
    }
    int w=player->width();
    int h=player->height();
    painter=new MyPainter(this);
    renderer=new ShmRenderer;
#ifdef HAVE_LIBXXF86DGA
//  renderer=new DGARenderer;
#endif
    int result=renderer->Create(this, w, h);
    if(result!=0)
    {
        cerr<<"Your X server does not support MIT Shared Memory Extension!"<<endl;
        exit(-1);
    }
    resize(w, h+50);
    setCaption(filename);
    //
    //
    //	Scroll bar
    //
    //
    scroller=new QScrollBar(this);
    scroller->move(25, h+5);
    scroller->resize(w-30, 20);
#if(QT_VERSION<210)
    scroller->setRange(0, player->GetAudioLength());
#else
    scroller->setMinValue(0);
    scroller->setMaxValue(player->GetVideoLength());
#endif
    scroller->setOrientation(QScrollBar::Horizontal);
    connect(scroller, SIGNAL(sliderReleased()), this, SLOT(reseek()));

#if (QT_VERSION<210)
    b_pause=new QPushButton("||", this);
#else
    QPixmap pm;
    pm.load("/usr/local/share/avifile/pause.png");
    b_pause=new QPushButton(pm, "", this);
#endif
  
    b_pause->move(5, h+5);
    b_pause->resize(20, 20);
    
    b_pause->setToggleButton(true);
//    pause->setIconSet(pm);
    
//    connect(play, SIGNAL(clicked()), this, SLOT(play()));
    connect(b_pause, SIGNAL(toggled(bool)), this, SLOT(pause(bool)));

    player->start();
    return 0;
}

#include "mywidget.moc"
