/********************************************************

	AviWriteStream/AviWriteFile class implementation
	Copyright 2000 Eugene Smith (divx@euro.ru)
	Last modified: 23.06.2000

*********************************************************/


#include <stdio.h>
#include <fcntl.h>
#include <iostream>

#include <avifile.h>

#warning replace realloc()s with STL calls

using namespace std;
HRESULT AviWriteFile::Create(const char* name, int flags)
{
    if(m_status!=0)
	return -1;
    m_fd=open(name, O_WRONLY | O_CREAT | O_TRUNC, 00777);
    if(m_fd==-1)
    {
	cerr<<"Cannot open file "<<name<<" for writing"<<endl;
	return -1;
    }
    char* junk=new char[0x800];
    write(m_fd, junk, 0x800);
    delete junk;
    m_status=1;
    
    memset(&m_header, 0, sizeof(m_header));
    m_header.dwFlags=flags;

    return 0;		
}


AviWriteStream* AviWriteFile::AddStream(AviWriteStream::StreamType type)
{
    int ckid;
#warning maybe 1st video frame should have cktypeDIBbits?
    ckid=MAKEAVICKID((type==AviWriteStream::Video)?cktypeDIBcompressed:cktypeWAVEbytes, m_strcnt);
    
    AviWriteStream* result=new AviWriteStream(this, ckid);
    if(result==0)
    {
	cerr<<"Failed to create new stream"<<endl;
	return 0;
    }
    m_streams=(AviWriteStream**)realloc(m_streams, sizeof(AviWriteStream*)*(m_strcnt+1));
    m_streams[m_strcnt]=result;
    result->SetType(type);
    m_strcnt++;
    return result;
}
#define write_int(X) 		\
    temp=(X);			\
    write(m_fd, &temp, 4);	
HRESULT AviWriteFile::Close()
{
    int i;
    unsigned temp;
    if(m_status==0)
	return -1;
	
    m_header.dwFlags |= AVIF_HASINDEX | AVIF_TRUSTCKTYPE;
    m_header.dwPaddingGranularity=0;
    m_header.dwTotalFrames=0;
#warning FIXME - what about audio-only files?
    for(i=0; i<m_strcnt; i++)
    {
	if(m_streams[i]->GetType()==AviWriteStream::Video)
	{
	    m_header.dwTotalFrames=m_streams[i]->GetLength();
	    m_header.dwMicroSecPerFrame=m_streams[i]->m_header.dwScale;
	    m_header.dwWidth=m_streams[i]->m_header.rcFrame.right;
	    m_header.dwHeight=m_streams[i]->m_header.rcFrame.bottom;
	    break;
	}
    }	    
    m_header.dwStreams=m_strcnt;
    offset_t videoendpos=lseek(m_fd, 0, SEEK_CUR);
    if(videoendpos%4)
    {
        int junk=-1;
	write(m_fd, &junk, 4-videoendpos%4);
	videoendpos+=4-videoendpos%4;
    }	
    write_int(ckidAVINEWINDEX);
    write_int(m_indsize*sizeof(AVIINDEXENTRY));
    write(m_fd, m_index, m_indsize*sizeof(AVIINDEXENTRY));
    offset_t endpos=lseek(m_fd, 0, SEEK_CUR);
    lseek(m_fd, 0, SEEK_SET);
    write_int(mmioFOURCC('R', 'I', 'F', 'F'));
    write_int(endpos-8);
    write_int(formtypeAVI);// Here goes chunk with all headers
    write_int(mmioFOURCC('L', 'I', 'S', 'T'));
    int hdr_pos=0x10;
    write_int(0);//here header chunk size hdr_size will be
    int hdr_size=12+sizeof(MainAVIHeader);
    write_int(listtypeAVIHEADER);
    write_int(ckidAVIMAINHDR);
    write_int(sizeof(MainAVIHeader));
    write(m_fd, &m_header, sizeof(MainAVIHeader));
//    int streams_size=0;
//    int streams_pos=0x5C;
#warning TESTME
    for(int i=0; i<m_strcnt; i++)
    {
        write_int(mmioFOURCC('L', 'I', 'S', 'T'));
	write_int(20+sizeof(AVIStreamHeader)+m_streams[i]->m_forsize);
        write_int(listtypeSTREAMHEADER);
	write_int(ckidSTREAMHEADER);
        write_int(sizeof(AVIStreamHeader));
      	write(m_fd, &m_streams[i]->m_header, sizeof(AVIStreamHeader));
	write_int(ckidSTREAMFORMAT);
	write_int(m_streams[i]->m_forsize);
	write(m_fd, m_streams[i]->m_format, m_streams[i]->m_forsize);
	hdr_size+=28+sizeof(AVIStreamHeader)+m_streams[i]->m_forsize;
    }

    if(hdr_size>0x700)
    {
	cerr<<"Too large header. Aborting"<<endl;
	return -1;
    }
    	
    int curpos=lseek(m_fd, 0, SEEK_CUR);
    write_int(ckidAVIPADDING);
    write_int(0x7F4-(curpos+8));

    lseek(m_fd, 0x7F4, SEEK_SET);
    write_int(mmioFOURCC('L', 'I', 'S', 'T'));
    write_int(videoendpos-0x7FC);
    write_int(listtypeAVIMOVIE);
    
    lseek(m_fd, hdr_pos, SEEK_SET);
    write_int(hdr_size);
    
//    lseek(m_fd, streams_pos, SEEK_SET);
//    write_int(streams_size);

    close(m_fd);
    m_fd=-1;
    
    for(int i=0; i<m_strcnt; i++)
	delete m_streams[i];
    free(m_streams);
    free(m_index);
    m_status=0;
    return 0;
}

HRESULT AviWriteFile::AddChunk(offset_t offset, unsigned size, unsigned id, unsigned flags=0)
{
    m_index=(AVIINDEXENTRY*)realloc(m_index, (m_indsize+1)*sizeof(AVIINDEXENTRY));
    if(m_index==0)
    {
	cerr<<"Chunk table reallocation failure !!!!!!!!!!!!!!!"<<endl;
	return -1;
    }
    m_index[m_indsize].ckid=id;
    m_index[m_indsize].dwFlags=flags;
    m_index[m_indsize].dwChunkOffset=offset;
    m_index[m_indsize].dwChunkLength=size;
    m_indsize++;	
    return 0;
}

AviWriteStream::AviWriteStream(AviWriteFile* file, int ckid):m_file(file), m_ckid(ckid), m_status(0), 
		 m_format(0), m_forsize(0)
{
    m_fd=file->m_fd;
    m_header.dwLength=0;
}

HRESULT AviWriteStream::AddChunk(const char* chunk, unsigned size, unsigned flags=0)
{
    if(m_status!=ValidStream)
    {
	cout<<"Attempt to write data into invalid stream"<<endl;
	return -1;
    }	
    if((chunk==0) && (size!=0))
    {
	cout<<"Invalid argument to AviWriteStream::AddChunk()"<<endl;
	return -1;
    }	
    offset_t offset=lseek(m_fd, 0, SEEK_CUR);
    write(m_fd, &m_ckid, 4);
    write(m_fd, &size, 4);
    if(chunk)
	write(m_fd, chunk, size);
    m_file->AddChunk(offset-0x7FC, size, m_ckid, flags);
    if(m_header.dwSampleSize==0)
    	m_header.dwLength++;
        else
        m_header.dwLength+=size/m_header.dwSampleSize;
    return 0;
}

AviWriteStream::~AviWriteStream()
{
    if(m_format)
	delete m_format;
}