/********************************************************

         WMA audio decoder
	 Copyright 2000 Eugene Smith (divx@euro.ru)
	 Last modified: 13.07.2000

*********************************************************/

#include <stdio.h>
#include "wma.h"
#include <string.h>
/*char cfmt[]={0x61, 0x01, 0x02, 0x00, 0x22, 0x56, 0x00, 0x00, 
0xa5, 0x0f, 0x00, 0x00, 0xba, 0x00, 0x10, 0x00,
0x0a, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x00,
0xba, 0x00, 0x00, 0x00};
*/

int WMA_Decoder::Init(WAVEFORMATEX* pwf, void* extension)
{
    if(pwf==0)
	return -1;
    m_wstr=*pwf;
    if(extension==0)
	return -1;
/*    if(m_wstr.cbSize<10)
	return -1;*/
    memcpy(ext_info, pwf, sizeof(WAVEFORMATEX));
    memcpy((char*)ext_info+18, extension, min(32, (unsigned)m_wstr.cbSize));
    if(m_wstr.nSamplesPerSec==0)
	return -1;
	
//    MSACM_RegisterAllDrivers();
    
//    WAVEFORMATEX wf;
    wf.nChannels=m_wstr.nChannels;
    wf.nSamplesPerSec=m_wstr.nSamplesPerSec;
    wf.nAvgBytesPerSec=2*wf.nSamplesPerSec*wf.nChannels;
    wf.wFormatTag=WAVE_FORMAT_PCM;
    wf.nBlockAlign=2;
    wf.wBitsPerSample=16;
    wf.cbSize=0;
/*    
    if(memcmp(ext_info, cfmt, sizeof(cfmt))!=0)
    {
	printf("WARNING: ext_info incorrect\n");
    }	
*/
    HRESULT hr=acmStreamOpen(
		&srcstream,    
		(HACMDRIVER)NULL,       
		(WAVEFORMATEX*)ext_info,  
		(WAVEFORMATEX*)&wf,  
		NULL,  
		0,     
		0,     
		0);
//		ACM_STREAMOPENF_NONREALTIME );
	
    if(hr!=S_OK)
    {
    	if(hr==ACMERR_NOTPOSSIBLE)
    	{
    		printf("Unappropriate audio format\n\n");
    		goto error;
	}
	printf("WMA_Decoder: acmStreamOpen error %X\n\n", hr);
	goto error;
    }
    m_status=1;
error:
    return 0;
}
int WMA_Decoder::decode_frames(unsigned char* in_data, unsigned char* out_data,
	    unsigned& in_size, unsigned out_size, out_format* format)
{
    HRESULT hr;
//    static int qw=0;

    if(m_status!=1)
	goto fail;
    if(!in_data)
	goto fail;
    if(!out_data)
	goto fail;

//    printf("WMA_Decoder: %d bytes in in_buffer, %d bytes in out_buffer\n",
//	in_size, out_size);
    if(format)
    {
	format->is_stereo=m_wstr.nChannels-1;
	format->freq=m_wstr.nSamplesPerSec;
	format->valid=OUT_FORMAT_VALID;
    }		

    ACMSTREAMHEADER ash;
    memset(&ash, 0, sizeof(ash));
    ash.cbStruct=sizeof(ash);
    ash.fdwStatus=0;
    ash.dwUser=0; 
    ash.pbSrc=in_data; 
    ash.cbSrcLength=in_size; 
    ash.pbDst=out_data; 
    ash.cbDstLength=out_size; 
   
    hr=acmStreamPrepareHeader(
      srcstream,          
      &ash,  
    	0);
    if(hr!=S_OK)
    {
    	printf("WMA_Decoder: acmStreamPrepareHeader error %X\n\n", hr);
    	goto fail;
    }
    
/*    if(qw==0)
    {
	FILE* qz=fopen("./test.qqq", "wb");
	fwrite(in_data, 1, in_size, qz);
	fclose(qz);
	qw=1;
    }		

*/
    hr=acmStreamConvert(
    	  srcstream,          
	  &ash,  
    	  0
    	);
    if(hr!=S_OK)
    {
	printf("WMA_Decoder: acmStreamConvert error %X\n\n", hr);
	goto fail;
    }

//    printf("Uncompressed %d bytes from %d\n", ash.cbDstLengthUsed, ash.cbSrcLengthUsed);

	
    in_size=ash.cbSrcLengthUsed;

    hr=acmStreamUnprepareHeader(
    	srcstream,          
    	&ash,  
    	0);
    return ash.cbDstLengthUsed;

fail:		
    in_size=0;
    return 0;
}

int WMA_Decoder::Close()
{
    if(m_status==0)
	return 0;
    acmStreamClose(srcstream, 0);
    return 0;
}    