
;;; d-flyspell.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-flyspell.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: flyspell functionality
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

;;(setq flyspell-default-dictionary "british")
;;(ispell-change-dictionary "british")

(when (and os-type--mswindows-p emacs-dialect--gnuemacs-p)
  (setq-default ispell-program-name "aspell")
  (setq-default ispell-extra-args '("--reverse"))
  (setenv "PATH" (concat "C:\\Program Files\\Aspell\\bin;" (getenv "PATH")))
  )

(setq ispell-dictionary "british")

(add-hook 'find-file-hook 'maybe-turn-on-flyspell-mode)
;;(remove-hook 'find-file-hook 'turn-on-flyspell)

(global-set-key "\C-v" 'ispell-word)

(defun maybe-turn-on-flyspell-mode ()
  (if (or (eq major-mode 'text-mode)
          ;;(eq major-mode 'fundamental-mode)
          (eq major-mode 'latex-mode)
          (eq major-mode 'html-mode))
      (progn
;;        (if (< (point-max) 10000)
;;            (flyspell-buffer))
        (flyspell-mode)
        (define-key flyspell-mode-map [mouse-3] 'flyspell-correct-word/local-keymap))))

(defun turn-on-flyspell ()
  (interactive)
  (flyspell-buffer)
  (flyspell-mode))

(add-hook 'flyspell-post-command-hook 'd-flyspell-post-command-hook)

(defun d-flyspell-post-command-hook ()
  ;;(d-foo)
  )

(defun fsb ()
  (interactive)
  (flyspell-mode)
  (flyspell-buffer)
  (local-unset-key [mouse-3])
  (define-key flyspell-mode-map [mouse-3] 'flyspell-correct-word/local-keymap)
  )

(global-set-key [mouse-3] 'flyspell-correct-word)

(provide 'd-flyspell)
;;; d-flyspell.el ends here
