// SPDX-License-Identifier: GPL-2.0
// Copyright (C) 2018 Intel Corporation

#include "ipu3-tables.h"

#define X					0	/*  Don't care value */

const struct imgu_css_bds_config
			imgu_css_bds_configs[IMGU_BDS_CONFIG_LEN] = { {
	/* Scale factor 32 / (32 + 0) = 1 */
	.hor_phase_arr = {
		.even = { { 0, 0, 64, 6, 0, 0, 0 } },
		.odd = { { 0, 0, 64, 6, 0, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 0, 64, 6, 0, 0, 0 } },
		.odd = { { 0, 0, 64, 6, 0, 0, 0 } } },
	.ptrn_arr = { { 0x3 } },
	.sample_patrn_length = 2,
	.hor_ds_en = 0,
	.ver_ds_en = 0
}, {
	/* Scale factor 32 / (32 + 1) = 0.969697 */
	.hor_phase_arr = {
		.even = { { 0, 3, 122, 7, 3, 0, 0 },
			 { 0, 0, 122, 7, 7, -1, 0 },
			 { 0, -3, 122, 7, 10, -1, 0 },
			 { 0, -5, 121, 7, 14, -2, 0 },
			 { 0, -7, 120, 7, 18, -3, 0 },
			 { 0, -9, 118, 7, 23, -4, 0 },
			 { 0, -11, 116, 7, 27, -4, 0 },
			 { 0, -12, 113, 7, 32, -5, 0 },
			 { 0, -13, 110, 7, 37, -6, 0 },
			 { 0, -14, 107, 7, 42, -7, 0 },
			 { 0, -14, 103, 7, 47, -8, 0 },
			 { 0, -15, 100, 7, 52, -9, 0 },
			 { 0, -15, 96, 7, 57, -10, 0 },
			 { 0, -15, 92, 7, 62, -11, 0 },
			 { 0, -14, 86, 7, 68, -12, 0 },
			 { 0, -14, 82, 7, 73, -13, 0 },
			 { 0, -14, 78, 7, 78, -14, 0 },
			 { 0, -13, 73, 7, 82, -14, 0 },
			 { 0, -12, 68, 7, 86, -14, 0 },
			 { 0, -11, 62, 7, 92, -15, 0 },
			 { 0, -10, 57, 7, 96, -15, 0 },
			 { 0, -9, 52, 7, 100, -15, 0 },
			 { 0, -8, 47, 7, 103, -14, 0 },
			 { 0, -7, 42, 7, 107, -14, 0 },
			 { 0, -6, 37, 7, 110, -13, 0 },
			 { 0, -5, 32, 7, 113, -12, 0 },
			 { 0, -4, 27, 7, 116, -11, 0 },
			 { 0, -4, 23, 7, 118, -9, 0 },
			 { 0, -3, 18, 7, 120, -7, 0 },
			 { 0, -2, 14, 7, 121, -5, 0 },
			 { 0, -1, 10, 7, 122, -3, 0 },
			 { 0, -1, 7, 7, 122, 0, 0 } },
		.odd = { { 0, 2, 122, 7, 5, -1, 0 },
			 { 0, -1, 122, 7, 8, -1, 0 },
			 { 0, -4, 122, 7, 12, -2, 0 },
			 { 0, -6, 120, 7, 16, -2, 0 },
			 { 0, -8, 118, 7, 21, -3, 0 },
			 { 0, -10, 117, 7, 25, -4, 0 },
			 { 0, -11, 114, 7, 30, -5, 0 },
			 { 0, -13, 112, 7, 35, -6, 0 },
			 { 0, -14, 109, 7, 40, -7, 0 },
			 { 0, -14, 105, 7, 45, -8, 0 },
			 { 0, -15, 102, 7, 50, -9, 0 },
			 { 0, -15, 98, 7, 55, -10, 0 },
			 { 0, -15, 94, 7, 60, -11, 0 },
			 { 0, -15, 90, 7, 65, -12, 0 },
			 { 0, -14, 85, 7, 70, -13, 0 },
			 { 0, -14, 80, 7, 75, -13, 0 },
			 { 0, -13, 75, 7, 80, -14, 0 },
			 { 0, -13, 70, 7, 85, -14, 0 },
			 { 0, -12, 65, 7, 90, -15, 0 },
			 { 0, -11, 60, 7, 94, -15, 0 },
			 { 0, -10, 55, 7, 98, -15, 0 },
			 { 0, -9, 50, 7, 102, -15, 0 },
			 { 0, -8, 45, 7, 105, -14, 0 },
			 { 0, -7, 40, 7, 109, -14, 0 },
			 { 0, -6, 35, 7, 112, -13, 0 },
			 { 0, -5, 30, 7, 114, -11, 0 },
			 { 0, -4, 25, 7, 117, -10, 0 },
			 { 0, -3, 21, 7, 118, -8, 0 },
			 { 0, -2, 16, 7, 120, -6, 0 },
			 { 0, -2, 12, 7, 122, -4, 0 },
			 { 0, -1, 8, 7, 122, -1, 0 },
			 { 0, -1, 5, 7, 122, 2, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 3, 122, 7, 3, 0, 0 },
			 { 0, 0, 122, 7, 7, -1, 0 },
			 { 0, -3, 122, 7, 10, -1, 0 },
			 { 0, -5, 121, 7, 14, -2, 0 },
			 { 0, -7, 120, 7, 18, -3, 0 },
			 { 0, -9, 118, 7, 23, -4, 0 },
			 { 0, -11, 116, 7, 27, -4, 0 },
			 { 0, -12, 113, 7, 32, -5, 0 },
			 { 0, -13, 110, 7, 37, -6, 0 },
			 { 0, -14, 107, 7, 42, -7, 0 },
			 { 0, -14, 103, 7, 47, -8, 0 },
			 { 0, -15, 100, 7, 52, -9, 0 },
			 { 0, -15, 96, 7, 57, -10, 0 },
			 { 0, -15, 92, 7, 62, -11, 0 },
			 { 0, -14, 86, 7, 68, -12, 0 },
			 { 0, -14, 82, 7, 73, -13, 0 },
			 { 0, -14, 78, 7, 78, -14, 0 },
			 { 0, -13, 73, 7, 82, -14, 0 },
			 { 0, -12, 68, 7, 86, -14, 0 },
			 { 0, -11, 62, 7, 92, -15, 0 },
			 { 0, -10, 57, 7, 96, -15, 0 },
			 { 0, -9, 52, 7, 100, -15, 0 },
			 { 0, -8, 47, 7, 103, -14, 0 },
			 { 0, -7, 42, 7, 107, -14, 0 },
			 { 0, -6, 37, 7, 110, -13, 0 },
			 { 0, -5, 32, 7, 113, -12, 0 },
			 { 0, -4, 27, 7, 116, -11, 0 },
			 { 0, -4, 23, 7, 118, -9, 0 },
			 { 0, -3, 18, 7, 120, -7, 0 },
			 { 0, -2, 14, 7, 121, -5, 0 },
			 { 0, -1, 10, 7, 122, -3, 0 },
			 { 0, -1, 7, 7, 122, 0, 0 } },
		.odd = { { 0, 2, 122, 7, 5, -1, 0 },
			 { 0, -1, 122, 7, 8, -1, 0 },
			 { 0, -4, 122, 7, 12, -2, 0 },
			 { 0, -6, 120, 7, 16, -2, 0 },
			 { 0, -8, 118, 7, 21, -3, 0 },
			 { 0, -10, 117, 7, 25, -4, 0 },
			 { 0, -11, 114, 7, 30, -5, 0 },
			 { 0, -13, 112, 7, 35, -6, 0 },
			 { 0, -14, 109, 7, 40, -7, 0 },
			 { 0, -14, 105, 7, 45, -8, 0 },
			 { 0, -15, 102, 7, 50, -9, 0 },
			 { 0, -15, 98, 7, 55, -10, 0 },
			 { 0, -15, 94, 7, 60, -11, 0 },
			 { 0, -15, 90, 7, 65, -12, 0 },
			 { 0, -14, 85, 7, 70, -13, 0 },
			 { 0, -14, 80, 7, 75, -13, 0 },
			 { 0, -13, 75, 7, 80, -14, 0 },
			 { 0, -13, 70, 7, 85, -14, 0 },
			 { 0, -12, 65, 7, 90, -15, 0 },
			 { 0, -11, 60, 7, 94, -15, 0 },
			 { 0, -10, 55, 7, 98, -15, 0 },
			 { 0, -9, 50, 7, 102, -15, 0 },
			 { 0, -8, 45, 7, 105, -14, 0 },
			 { 0, -7, 40, 7, 109, -14, 0 },
			 { 0, -6, 35, 7, 112, -13, 0 },
			 { 0, -5, 30, 7, 114, -11, 0 },
			 { 0, -4, 25, 7, 117, -10, 0 },
			 { 0, -3, 21, 7, 118, -8, 0 },
			 { 0, -2, 16, 7, 120, -6, 0 },
			 { 0, -2, 12, 7, 122, -4, 0 },
			 { 0, -1, 8, 7, 122, -1, 0 },
			 { 0, -1, 5, 7, 122, 2, 0 } } },
	.ptrn_arr = { { 0xffffffff, 0xffffffff } },
	.sample_patrn_length = 66,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 2) = 0.941176 */
	.hor_phase_arr = {
		.even = { { -1, 6, 118, 7, 6, -1, 0 },
			 { 0, 0, 117, 7, 13, -2, 0 },
			 { 0, -5, 116, 7, 21, -4, 0 },
			 { 0, -9, 113, 7, 30, -6, 0 },
			 { 0, -12, 109, 7, 39, -8, 0 },
			 { 0, -13, 102, 7, 49, -10, 0 },
			 { 0, -14, 94, 7, 59, -11, 0 },
			 { 0, -14, 86, 7, 69, -13, 0 },
			 { 0, -14, 78, 7, 78, -14, 0 },
			 { 0, -13, 69, 7, 86, -14, 0 },
			 { 0, -11, 59, 7, 94, -14, 0 },
			 { 0, -10, 49, 7, 102, -13, 0 },
			 { 0, -8, 39, 7, 109, -12, 0 },
			 { 0, -6, 30, 7, 113, -9, 0 },
			 { 0, -4, 21, 7, 116, -5, 0 },
			 { 0, -2, 13, 7, 117, 0, 0 } },
		.odd = { { -1, 3, 118, 7, 10, -2, 0 },
			 { 0, -3, 117, 7, 17, -3, 0 },
			 { 0, -7, 114, 7, 26, -5, 0 },
			 { 0, -10, 110, 7, 35, -7, 0 },
			 { 0, -13, 106, 7, 44, -9, 0 },
			 { 0, -14, 99, 7, 54, -11, 0 },
			 { 0, -14, 90, 7, 64, -12, 0 },
			 { 0, -14, 82, 7, 73, -13, 0 },
			 { 0, -13, 73, 7, 82, -14, 0 },
			 { 0, -12, 64, 7, 90, -14, 0 },
			 { 0, -11, 54, 7, 99, -14, 0 },
			 { 0, -9, 44, 7, 106, -13, 0 },
			 { 0, -7, 35, 7, 110, -10, 0 },
			 { 0, -5, 26, 7, 114, -7, 0 },
			 { 0, -3, 17, 7, 117, -3, 0 },
			 { 0, -2, 10, 7, 118, 3, -1 } } },
	.ver_phase_arr = {
		.even = { { -1, 6, 118, 7, 6, -1, 0 },
			 { 0, 0, 117, 7, 13, -2, 0 },
			 { 0, -5, 116, 7, 21, -4, 0 },
			 { 0, -9, 113, 7, 30, -6, 0 },
			 { 0, -12, 109, 7, 39, -8, 0 },
			 { 0, -13, 102, 7, 49, -10, 0 },
			 { 0, -14, 94, 7, 59, -11, 0 },
			 { 0, -14, 86, 7, 69, -13, 0 },
			 { 0, -14, 78, 7, 78, -14, 0 },
			 { 0, -13, 69, 7, 86, -14, 0 },
			 { 0, -11, 59, 7, 94, -14, 0 },
			 { 0, -10, 49, 7, 102, -13, 0 },
			 { 0, -8, 39, 7, 109, -12, 0 },
			 { 0, -6, 30, 7, 113, -9, 0 },
			 { 0, -4, 21, 7, 116, -5, 0 },
			 { 0, -2, 13, 7, 117, 0, 0 } },
		.odd = { { -1, 3, 118, 7, 10, -2, 0 },
			 { 0, -3, 117, 7, 17, -3, 0 },
			 { 0, -7, 114, 7, 26, -5, 0 },
			 { 0, -10, 110, 7, 35, -7, 0 },
			 { 0, -13, 106, 7, 44, -9, 0 },
			 { 0, -14, 99, 7, 54, -11, 0 },
			 { 0, -14, 90, 7, 64, -12, 0 },
			 { 0, -14, 82, 7, 73, -13, 0 },
			 { 0, -13, 73, 7, 82, -14, 0 },
			 { 0, -12, 64, 7, 90, -14, 0 },
			 { 0, -11, 54, 7, 99, -14, 0 },
			 { 0, -9, 44, 7, 106, -13, 0 },
			 { 0, -7, 35, 7, 110, -10, 0 },
			 { 0, -5, 26, 7, 114, -7, 0 },
			 { 0, -3, 17, 7, 117, -3, 0 },
			 { 0, -2, 10, 7, 118, 3, -1 } } },
	.ptrn_arr = { { 0xffffffff } },
	.sample_patrn_length = 34,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 3) = 0.914286 */
	.hor_phase_arr = {
		.even = { { -2, 9, 114, 7, 9, -2, 0 },
			 { -1, 0, 114, 7, 20, -5, 0 },
			 { 0, -7, 110, 7, 32, -7, 0 },
			 { 0, -11, 103, 7, 46, -10, 0 },
			 { 0, -13, 93, 7, 60, -12, 0 },
			 { 0, -14, 82, 7, 74, -14, 0 },
			 { 0, -13, 69, 7, 86, -14, 0 },
			 { 0, -11, 55, 7, 97, -13, 0 },
			 { 0, -9, 41, 7, 106, -10, 0 },
			 { 0, -6, 28, 7, 111, -5, 0 },
			 { 0, -4, 16, 7, 114, 3, -1 },
			 { -2, 6, 115, 7, 12, -3, 0 },
			 { 0, -2, 111, 7, 24, -5, 0 },
			 { 0, -8, 107, 7, 37, -8, 0 },
			 { 0, -12, 100, 7, 51, -11, 0 },
			 { 0, -14, 90, 7, 65, -13, 0 },
			 { 0, -14, 78, 7, 78, -14, 0 },
			 { 0, -13, 65, 7, 90, -14, 0 },
			 { 0, -11, 51, 7, 100, -12, 0 },
			 { 0, -8, 37, 7, 107, -8, 0 },
			 { 0, -5, 24, 7, 111, -2, 0 },
			 { 0, -3, 12, 7, 115, 6, -2 },
			 { -1, 3, 114, 7, 16, -4, 0 },
			 { 0, -5, 111, 7, 28, -6, 0 },
			 { 0, -10, 106, 7, 41, -9, 0 },
			 { 0, -13, 97, 7, 55, -11, 0 },
			 { 0, -14, 86, 7, 69, -13, 0 },
			 { 0, -14, 74, 7, 82, -14, 0 },
			 { 0, -12, 60, 7, 93, -13, 0 },
			 { 0, -10, 46, 7, 103, -11, 0 },
			 { 0, -7, 32, 7, 110, -7, 0 },
			 { 0, -5, 20, 7, 114, 0, -1 } },
		.odd = { { -1, 4, 114, 7, 14, -3, 0 },
			 { 0, -4, 112, 7, 26, -6, 0 },
			 { 0, -9, 107, 7, 39, -9, 0 },
			 { 0, -13, 99, 7, 53, -11, 0 },
			 { 0, -14, 88, 7, 67, -13, 0 },
			 { 0, -14, 76, 7, 80, -14, 0 },
			 { 0, -13, 62, 7, 93, -14, 0 },
			 { 0, -10, 48, 7, 102, -12, 0 },
			 { 0, -8, 35, 7, 109, -8, 0 },
			 { 0, -5, 22, 7, 112, -1, 0 },
			 { 0, -3, 11, 7, 115, 7, -2 },
			 { -1, 1, 114, 7, 18, -4, 0 },
			 { 0, -6, 111, 7, 30, -7, 0 },
			 { 0, -10, 103, 7, 44, -9, 0 },
			 { 0, -13, 95, 7, 58, -12, 0 },
			 { 0, -14, 85, 7, 71, -14, 0 },
			 { 0, -14, 71, 7, 85, -14, 0 },
			 { 0, -12, 58, 7, 95, -13, 0 },
			 { 0, -9, 44, 7, 103, -10, 0 },
			 { 0, -7, 30, 7, 111, -6, 0 },
			 { 0, -4, 18, 7, 114, 1, -1 },
			 { -2, 7, 115, 7, 11, -3, 0 },
			 { 0, -1, 112, 7, 22, -5, 0 },
			 { 0, -8, 109, 7, 35, -8, 0 },
			 { 0, -12, 102, 7, 48, -10, 0 },
			 { 0, -14, 93, 7, 62, -13, 0 },
			 { 0, -14, 80, 7, 76, -14, 0 },
			 { 0, -13, 67, 7, 88, -14, 0 },
			 { 0, -11, 53, 7, 99, -13, 0 },
			 { 0, -9, 39, 7, 107, -9, 0 },
			 { 0, -6, 26, 7, 112, -4, 0 },
			 { 0, -3, 14, 7, 114, 4, -1 } } },
	.ver_phase_arr = {
		.even = { { -2, 9, 114, 7, 9, -2, 0 },
			 { -1, 0, 114, 7, 20, -5, 0 },
			 { 0, -7, 110, 7, 32, -7, 0 },
			 { 0, -11, 103, 7, 46, -10, 0 },
			 { 0, -13, 93, 7, 60, -12, 0 },
			 { 0, -14, 82, 7, 74, -14, 0 },
			 { 0, -13, 69, 7, 86, -14, 0 },
			 { 0, -11, 55, 7, 97, -13, 0 },
			 { 0, -9, 41, 7, 106, -10, 0 },
			 { 0, -6, 28, 7, 111, -5, 0 },
			 { 0, -4, 16, 7, 114, 3, -1 },
			 { -2, 6, 115, 7, 12, -3, 0 },
			 { 0, -2, 111, 7, 24, -5, 0 },
			 { 0, -8, 107, 7, 37, -8, 0 },
			 { 0, -12, 100, 7, 51, -11, 0 },
			 { 0, -14, 90, 7, 65, -13, 0 },
			 { 0, -14, 78, 7, 78, -14, 0 },
			 { 0, -13, 65, 7, 90, -14, 0 },
			 { 0, -11, 51, 7, 100, -12, 0 },
			 { 0, -8, 37, 7, 107, -8, 0 },
			 { 0, -5, 24, 7, 111, -2, 0 },
			 { 0, -3, 12, 7, 115, 6, -2 },
			 { -1, 3, 114, 7, 16, -4, 0 },
			 { 0, -5, 111, 7, 28, -6, 0 },
			 { 0, -10, 106, 7, 41, -9, 0 },
			 { 0, -13, 97, 7, 55, -11, 0 },
			 { 0, -14, 86, 7, 69, -13, 0 },
			 { 0, -14, 74, 7, 82, -14, 0 },
			 { 0, -12, 60, 7, 93, -13, 0 },
			 { 0, -10, 46, 7, 103, -11, 0 },
			 { 0, -7, 32, 7, 110, -7, 0 },
			 { 0, -5, 20, 7, 114, 0, -1 } },
		.odd = { { -1, 4, 114, 7, 14, -3, 0 },
			 { 0, -4, 112, 7, 26, -6, 0 },
			 { 0, -9, 107, 7, 39, -9, 0 },
			 { 0, -13, 99, 7, 53, -11, 0 },
			 { 0, -14, 88, 7, 67, -13, 0 },
			 { 0, -14, 76, 7, 80, -14, 0 },
			 { 0, -13, 62, 7, 93, -14, 0 },
			 { 0, -10, 48, 7, 102, -12, 0 },
			 { 0, -8, 35, 7, 109, -8, 0 },
			 { 0, -5, 22, 7, 112, -1, 0 },
			 { 0, -3, 11, 7, 115, 7, -2 },
			 { -1, 1, 114, 7, 18, -4, 0 },
			 { 0, -6, 111, 7, 30, -7, 0 },
			 { 0, -10, 103, 7, 44, -9, 0 },
			 { 0, -13, 95, 7, 58, -12, 0 },
			 { 0, -14, 85, 7, 71, -14, 0 },
			 { 0, -14, 71, 7, 85, -14, 0 },
			 { 0, -12, 58, 7, 95, -13, 0 },
			 { 0, -9, 44, 7, 103, -10, 0 },
			 { 0, -7, 30, 7, 111, -6, 0 },
			 { 0, -4, 18, 7, 114, 1, -1 },
			 { -2, 7, 115, 7, 11, -3, 0 },
			 { 0, -1, 112, 7, 22, -5, 0 },
			 { 0, -8, 109, 7, 35, -8, 0 },
			 { 0, -12, 102, 7, 48, -10, 0 },
			 { 0, -14, 93, 7, 62, -13, 0 },
			 { 0, -14, 80, 7, 76, -14, 0 },
			 { 0, -13, 67, 7, 88, -14, 0 },
			 { 0, -11, 53, 7, 99, -13, 0 },
			 { 0, -9, 39, 7, 107, -9, 0 },
			 { 0, -6, 26, 7, 112, -4, 0 },
			 { 0, -3, 14, 7, 114, 4, -1 } } },
	.ptrn_arr = { { 0xff3fffff, 0xffff9fff, 0xf } },
	.sample_patrn_length = 70,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 4) = 0.888889 */
	.hor_phase_arr = {
		.even = { { -3, 12, 110, 7, 12, -3, 0 },
			 { -1, 0, 110, 7, 26, -7, 0 },
			 { 0, -8, 103, 7, 43, -10, 0 },
			 { 0, -12, 92, 7, 61, -13, 0 },
			 { 0, -14, 78, 7, 78, -14, 0 },
			 { 0, -13, 61, 7, 92, -12, 0 },
			 { 0, -10, 43, 7, 103, -8, 0 },
			 { 0, -7, 26, 7, 110, 0, -1 } },
		.odd = { { -2, 5, 111, 7, 19, -5, 0 },
			 { 0, -4, 106, 7, 34, -8, 0 },
			 { 0, -11, 98, 7, 52, -11, 0 },
			 { 0, -13, 85, 7, 69, -13, 0 },
			 { 0, -13, 69, 7, 85, -13, 0 },
			 { 0, -11, 52, 7, 98, -11, 0 },
			 { 0, -8, 34, 7, 106, -4, 0 },
			 { 0, -5, 19, 7, 111, 5, -2 } } },
	.ver_phase_arr = {
		.even = { { -3, 12, 110, 7, 12, -3, 0 },
			 { -1, 0, 110, 7, 26, -7, 0 },
			 { 0, -8, 103, 7, 43, -10, 0 },
			 { 0, -12, 92, 7, 61, -13, 0 },
			 { 0, -14, 78, 7, 78, -14, 0 },
			 { 0, -13, 61, 7, 92, -12, 0 },
			 { 0, -10, 43, 7, 103, -8, 0 },
			 { 0, -7, 26, 7, 110, 0, -1 } },
		.odd = { { -2, 5, 111, 7, 19, -5, 0 },
			 { 0, -4, 106, 7, 34, -8, 0 },
			 { 0, -11, 98, 7, 52, -11, 0 },
			 { 0, -13, 85, 7, 69, -13, 0 },
			 { 0, -13, 69, 7, 85, -13, 0 },
			 { 0, -11, 52, 7, 98, -11, 0 },
			 { 0, -8, 34, 7, 106, -4, 0 },
			 { 0, -5, 19, 7, 111, 5, -2 } } },
	.ptrn_arr = { { 0xffff } },
	.sample_patrn_length = 18,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 5) = 0.864865 */
	.hor_phase_arr = {
		.even = { { -5, 14, 110, 7, 14, -5, 0 },
			 { -1, 0, 106, 7, 32, -9, 0 },
			 { 0, -9, 96, 7, 53, -12, 0 },
			 { 0, -13, 81, 7, 73, -13, 0 },
			 { 0, -13, 61, 7, 91, -11, 0 },
			 { 0, -10, 40, 7, 103, -4, -1 },
			 { 0, -6, 21, 7, 108, 8, -3 },
			 { -3, 5, 108, 7, 25, -7, 0 },
			 { 0, -6, 101, 7, 44, -11, 0 },
			 { 0, -12, 88, 7, 65, -13, 0 },
			 { 0, -13, 69, 7, 85, -13, 0 },
			 { 0, -11, 49, 7, 98, -8, 0 },
			 { 0, -8, 28, 7, 108, 2, -2 },
			 { -4, 11, 108, 7, 18, -5, 0 },
			 { -1, -2, 104, 7, 36, -9, 0 },
			 { 0, -10, 93, 7, 57, -12, 0 },
			 { 0, -13, 77, 7, 77, -13, 0 },
			 { 0, -12, 57, 7, 93, -10, 0 },
			 { 0, -9, 36, 7, 104, -2, -1 },
			 { 0, -5, 18, 7, 108, 11, -4 },
			 { -2, 2, 108, 7, 28, -8, 0 },
			 { 0, -8, 98, 7, 49, -11, 0 },
			 { 0, -13, 85, 7, 69, -13, 0 },
			 { 0, -13, 65, 7, 88, -12, 0 },
			 { 0, -11, 44, 7, 101, -6, 0 },
			 { 0, -7, 25, 7, 108, 5, -3 },
			 { -3, 8, 108, 7, 21, -6, 0 },
			 { -1, -4, 103, 7, 40, -10, 0 },
			 { 0, -11, 91, 7, 61, -13, 0 },
			 { 0, -13, 73, 7, 81, -13, 0 },
			 { 0, -12, 53, 7, 96, -9, 0 },
			 { 0, -9, 32, 7, 106, 0, -1 } },
		.odd = { { -3, 7, 108, 7, 23, -7, 0 },
			 { 0, -5, 101, 7, 42, -10, 0 },
			 { 0, -12, 90, 7, 63, -13, 0 },
			 { 0, -13, 71, 7, 83, -13, 0 },
			 { 0, -12, 51, 7, 97, -8, 0 },
			 { 0, -8, 30, 7, 107, 1, -2 },
			 { -4, 13, 108, 7, 16, -5, 0 },
			 { -1, -1, 105, 7, 34, -9, 0 },
			 { 0, -10, 95, 7, 55, -12, 0 },
			 { 0, -13, 79, 7, 75, -13, 0 },
			 { 0, -13, 59, 7, 93, -11, 0 },
			 { 0, -10, 38, 7, 104, -3, -1 },
			 { 0, -6, 19, 7, 110, 9, -4 },
			 { -2, 4, 106, 7, 27, -7, 0 },
			 { 0, -7, 99, 7, 47, -11, 0 },
			 { 0, -12, 86, 7, 67, -13, 0 },
			 { 0, -13, 67, 7, 86, -12, 0 },
			 { 0, -11, 47, 7, 99, -7, 0 },
			 { 0, -7, 27, 7, 106, 4, -2 },
			 { -4, 9, 110, 7, 19, -6, 0 },
			 { -1, -3, 104, 7, 38, -10, 0 },
			 { 0, -11, 93, 7, 59, -13, 0 },
			 { 0, -13, 75, 7, 79, -13, 0 },
			 { 0, -12, 55, 7, 95, -10, 0 },
			 { 0, -9, 34, 7, 105, -1, -1 },
			 { 0, -5, 16, 7, 108, 13, -4 },
			 { -2, 1, 107, 7, 30, -8, 0 },
			 { 0, -8, 97, 7, 51, -12, 0 },
			 { 0, -13, 83, 7, 71, -13, 0 },
			 { 0, -13, 63, 7, 90, -12, 0 },
			 { 0, -10, 42, 7, 101, -5, 0 },
			 { 0, -7, 23, 7, 108, 7, -3 } } },
	.ver_phase_arr = {
		.even = { { -5, 14, 110, 7, 14, -5, 0 },
			 { -1, 0, 106, 7, 32, -9, 0 },
			 { 0, -9, 96, 7, 53, -12, 0 },
			 { 0, -13, 81, 7, 73, -13, 0 },
			 { 0, -13, 61, 7, 91, -11, 0 },
			 { 0, -10, 40, 7, 103, -4, -1 },
			 { 0, -6, 21, 7, 108, 8, -3 },
			 { -3, 5, 108, 7, 25, -7, 0 },
			 { 0, -6, 101, 7, 44, -11, 0 },
			 { 0, -12, 88, 7, 65, -13, 0 },
			 { 0, -13, 69, 7, 85, -13, 0 },
			 { 0, -11, 49, 7, 98, -8, 0 },
			 { 0, -8, 28, 7, 108, 2, -2 },
			 { -4, 11, 108, 7, 18, -5, 0 },
			 { -1, -2, 104, 7, 36, -9, 0 },
			 { 0, -10, 93, 7, 57, -12, 0 },
			 { 0, -13, 77, 7, 77, -13, 0 },
			 { 0, -12, 57, 7, 93, -10, 0 },
			 { 0, -9, 36, 7, 104, -2, -1 },
			 { 0, -5, 18, 7, 108, 11, -4 },
			 { -2, 2, 108, 7, 28, -8, 0 },
			 { 0, -8, 98, 7, 49, -11, 0 },
			 { 0, -13, 85, 7, 69, -13, 0 },
			 { 0, -13, 65, 7, 88, -12, 0 },
			 { 0, -11, 44, 7, 101, -6, 0 },
			 { 0, -7, 25, 7, 108, 5, -3 },
			 { -3, 8, 108, 7, 21, -6, 0 },
			 { -1, -4, 103, 7, 40, -10, 0 },
			 { 0, -11, 91, 7, 61, -13, 0 },
			 { 0, -13, 73, 7, 81, -13, 0 },
			 { 0, -12, 53, 7, 96, -9, 0 },
			 { 0, -9, 32, 7, 106, 0, -1 } },
		.odd = { { -3, 7, 108, 7, 23, -7, 0 },
			 { 0, -5, 101, 7, 42, -10, 0 },
			 { 0, -12, 90, 7, 63, -13, 0 },
			 { 0, -13, 71, 7, 83, -13, 0 },
			 { 0, -12, 51, 7, 97, -8, 0 },
			 { 0, -8, 30, 7, 107, 1, -2 },
			 { -4, 13, 108, 7, 16, -5, 0 },
			 { -1, -1, 105, 7, 34, -9, 0 },
			 { 0, -10, 95, 7, 55, -12, 0 },
			 { 0, -13, 79, 7, 75, -13, 0 },
			 { 0, -13, 59, 7, 93, -11, 0 },
			 { 0, -10, 38, 7, 104, -3, -1 },
			 { 0, -6, 19, 7, 110, 9, -4 },
			 { -2, 4, 106, 7, 27, -7, 0 },
			 { 0, -7, 99, 7, 47, -11, 0 },
			 { 0, -12, 86, 7, 67, -13, 0 },
			 { 0, -13, 67, 7, 86, -12, 0 },
			 { 0, -11, 47, 7, 99, -7, 0 },
			 { 0, -7, 27, 7, 106, 4, -2 },
			 { -4, 9, 110, 7, 19, -6, 0 },
			 { -1, -3, 104, 7, 38, -10, 0 },
			 { 0, -11, 93, 7, 59, -13, 0 },
			 { 0, -13, 75, 7, 79, -13, 0 },
			 { 0, -12, 55, 7, 95, -10, 0 },
			 { 0, -9, 34, 7, 105, -1, -1 },
			 { 0, -5, 16, 7, 108, 13, -4 },
			 { -2, 1, 107, 7, 30, -8, 0 },
			 { 0, -8, 97, 7, 51, -12, 0 },
			 { 0, -13, 83, 7, 71, -13, 0 },
			 { 0, -13, 63, 7, 90, -12, 0 },
			 { 0, -10, 42, 7, 101, -5, 0 },
			 { 0, -7, 23, 7, 108, 7, -3 } } },
	.ptrn_arr = { { 0xcfff9fff, 0xf3ffe7ff, 0xff } },
	.sample_patrn_length = 74,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 6) = 0.842105 */
	.hor_phase_arr = {
		.even = { { -6, 17, 106, 7, 17, -6, 0 },
			 { -2, 0, 102, 7, 38, -10, 0 },
			 { 0, -10, 89, 7, 62, -13, 0 },
			 { 0, -13, 69, 7, 83, -11, 0 },
			 { 0, -11, 46, 7, 98, -4, -1 },
			 { 0, -7, 23, 7, 106, 10, -4 },
			 { -3, 5, 104, 7, 31, -9, 0 },
			 { 0, -7, 93, 7, 54, -12, 0 },
			 { 0, -12, 76, 7, 76, -12, 0 },
			 { 0, -12, 54, 7, 93, -7, 0 },
			 { 0, -9, 31, 7, 104, 5, -3 },
			 { -4, 10, 106, 7, 23, -7, 0 },
			 { -1, -4, 98, 7, 46, -11, 0 },
			 { 0, -11, 83, 7, 69, -13, 0 },
			 { 0, -13, 62, 7, 89, -10, 0 },
			 { 0, -10, 38, 7, 102, 0, -2 } },
		.odd = { { -4, 8, 105, 7, 27, -8, 0 },
			 { 0, -6, 96, 7, 50, -12, 0 },
			 { 0, -12, 80, 7, 73, -13, 0 },
			 { 0, -13, 58, 7, 92, -9, 0 },
			 { 0, -9, 34, 7, 103, 2, -2 },
			 { -5, 13, 107, 7, 20, -7, 0 },
			 { -1, -2, 100, 7, 42, -11, 0 },
			 { 0, -11, 87, 7, 65, -13, 0 },
			 { 0, -13, 65, 7, 87, -11, 0 },
			 { 0, -11, 42, 7, 100, -2, -1 },
			 { 0, -7, 20, 7, 107, 13, -5 },
			 { -2, 2, 103, 7, 34, -9, 0 },
			 { 0, -9, 92, 7, 58, -13, 0 },
			 { 0, -13, 73, 7, 80, -12, 0 },
			 { 0, -12, 50, 7, 96, -6, 0 },
			 { 0, -8, 27, 7, 105, 8, -4 } } },
	.ver_phase_arr = {
		.even = { { -6, 17, 106, 7, 17, -6, 0 },
			 { -2, 0, 102, 7, 38, -10, 0 },
			 { 0, -10, 89, 7, 62, -13, 0 },
			 { 0, -13, 69, 7, 83, -11, 0 },
			 { 0, -11, 46, 7, 98, -4, -1 },
			 { 0, -7, 23, 7, 106, 10, -4 },
			 { -3, 5, 104, 7, 31, -9, 0 },
			 { 0, -7, 93, 7, 54, -12, 0 },
			 { 0, -12, 76, 7, 76, -12, 0 },
			 { 0, -12, 54, 7, 93, -7, 0 },
			 { 0, -9, 31, 7, 104, 5, -3 },
			 { -4, 10, 106, 7, 23, -7, 0 },
			 { -1, -4, 98, 7, 46, -11, 0 },
			 { 0, -11, 83, 7, 69, -13, 0 },
			 { 0, -13, 62, 7, 89, -10, 0 },
			 { 0, -10, 38, 7, 102, 0, -2 } },
		.odd = { { -4, 8, 105, 7, 27, -8, 0 },
			 { 0, -6, 96, 7, 50, -12, 0 },
			 { 0, -12, 80, 7, 73, -13, 0 },
			 { 0, -13, 58, 7, 92, -9, 0 },
			 { 0, -9, 34, 7, 103, 2, -2 },
			 { -5, 13, 107, 7, 20, -7, 0 },
			 { -1, -2, 100, 7, 42, -11, 0 },
			 { 0, -11, 87, 7, 65, -13, 0 },
			 { 0, -13, 65, 7, 87, -11, 0 },
			 { 0, -11, 42, 7, 100, -2, -1 },
			 { 0, -7, 20, 7, 107, 13, -5 },
			 { -2, 2, 103, 7, 34, -9, 0 },
			 { 0, -9, 92, 7, 58, -13, 0 },
			 { 0, -13, 73, 7, 80, -12, 0 },
			 { 0, -12, 50, 7, 96, -6, 0 },
			 { 0, -8, 27, 7, 105, 8, -4 } } },
	.ptrn_arr = { { 0xfcffe7ff, 0xf } },
	.sample_patrn_length = 38,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 7) = 0.820513 */
	.hor_phase_arr = {
		.even = { { -7, 19, 104, 7, 19, -7, 0 },
			 { -2, 0, 98, 7, 43, -11, 0 },
			 { 0, -10, 81, 7, 69, -12, 0 },
			 { 0, -12, 58, 7, 89, -7, 0 },
			 { 0, -10, 32, 7, 103, 7, -4 },
			 { -5, 10, 103, 7, 29, -9, 0 },
			 { -1, -6, 93, 7, 54, -12, 0 },
			 { 0, -12, 72, 7, 79, -11, 0 },
			 { 0, -12, 47, 7, 97, -2, -2 },
			 { 0, -8, 22, 7, 104, 16, -6 },
			 { -3, 2, 100, 7, 40, -11, 0 },
			 { 0, -9, 84, 7, 65, -12, 0 },
			 { 0, -13, 62, 7, 87, -8, 0 },
			 { 0, -10, 36, 7, 100, 5, -3 },
			 { -5, 13, 103, 7, 25, -8, 0 },
			 { -1, -4, 94, 7, 51, -12, 0 },
			 { 0, -12, 76, 7, 76, -12, 0 },
			 { 0, -12, 51, 7, 94, -4, -1 },
			 { 0, -8, 25, 7, 103, 13, -5 },
			 { -3, 5, 100, 7, 36, -10, 0 },
			 { 0, -8, 87, 7, 62, -13, 0 },
			 { 0, -12, 65, 7, 84, -9, 0 },
			 { 0, -11, 40, 7, 100, 2, -3 },
			 { -6, 16, 104, 7, 22, -8, 0 },
			 { -2, -2, 97, 7, 47, -12, 0 },
			 { 0, -11, 79, 7, 72, -12, 0 },
			 { 0, -12, 54, 7, 93, -6, -1 },
			 { 0, -9, 29, 7, 103, 10, -5 },
			 { -4, 7, 103, 7, 32, -10, 0 },
			 { 0, -7, 89, 7, 58, -12, 0 },
			 { 0, -12, 69, 7, 81, -10, 0 },
			 { 0, -11, 43, 7, 98, 0, -2 } },
		.odd = { { -4, 9, 101, 7, 31, -9, 0 },
			 { -1, -6, 91, 7, 56, -12, 0 },
			 { 0, -12, 71, 7, 80, -11, 0 },
			 { 0, -11, 45, 7, 97, -1, -2 },
			 { 0, -7, 20, 7, 105, 17, -7 },
			 { -3, 1, 100, 7, 41, -11, 0 },
			 { 0, -10, 83, 7, 67, -12, 0 },
			 { 0, -13, 60, 7, 89, -8, 0 },
			 { 0, -10, 34, 7, 102, 6, -4 },
			 { -5, 11, 104, 7, 27, -9, 0 },
			 { -1, -5, 94, 7, 52, -12, 0 },
			 { 0, -12, 74, 7, 77, -11, 0 },
			 { 0, -12, 49, 7, 95, -3, -1 },
			 { 0, -8, 24, 7, 104, 14, -6 },
			 { -3, 3, 100, 7, 38, -10, 0 },
			 { 0, -9, 87, 7, 63, -13, 0 },
			 { 0, -13, 63, 7, 87, -9, 0 },
			 { 0, -10, 38, 7, 100, 3, -3 },
			 { -6, 14, 104, 7, 24, -8, 0 },
			 { -1, -3, 95, 7, 49, -12, 0 },
			 { 0, -11, 77, 7, 74, -12, 0 },
			 { 0, -12, 52, 7, 94, -5, -1 },
			 { 0, -9, 27, 7, 104, 11, -5 },
			 { -4, 6, 102, 7, 34, -10, 0 },
			 { 0, -8, 89, 7, 60, -13, 0 },
			 { 0, -12, 67, 7, 83, -10, 0 },
			 { 0, -11, 41, 7, 100, 1, -3 },
			 { -7, 17, 105, 7, 20, -7, 0 },
			 { -2, -1, 97, 7, 45, -11, 0 },
			 { 0, -11, 80, 7, 71, -12, 0 },
			 { 0, -12, 56, 7, 91, -6, -1 },
			 { 0, -9, 31, 7, 101, 9, -4 } } },
	.ver_phase_arr = {
		.even = { { -7, 19, 104, 7, 19, -7, 0 },
			 { -2, 0, 98, 7, 43, -11, 0 },
			 { 0, -10, 81, 7, 69, -12, 0 },
			 { 0, -12, 58, 7, 89, -7, 0 },
			 { 0, -10, 32, 7, 103, 7, -4 },
			 { -5, 10, 103, 7, 29, -9, 0 },
			 { -1, -6, 93, 7, 54, -12, 0 },
			 { 0, -12, 72, 7, 79, -11, 0 },
			 { 0, -12, 47, 7, 97, -2, -2 },
			 { 0, -8, 22, 7, 104, 16, -6 },
			 { -3, 2, 100, 7, 40, -11, 0 },
			 { 0, -9, 84, 7, 65, -12, 0 },
			 { 0, -13, 62, 7, 87, -8, 0 },
			 { 0, -10, 36, 7, 100, 5, -3 },
			 { -5, 13, 103, 7, 25, -8, 0 },
			 { -1, -4, 94, 7, 51, -12, 0 },
			 { 0, -12, 76, 7, 76, -12, 0 },
			 { 0, -12, 51, 7, 94, -4, -1 },
			 { 0, -8, 25, 7, 103, 13, -5 },
			 { -3, 5, 100, 7, 36, -10, 0 },
			 { 0, -8, 87, 7, 62, -13, 0 },
			 { 0, -12, 65, 7, 84, -9, 0 },
			 { 0, -11, 40, 7, 100, 2, -3 },
			 { -6, 16, 104, 7, 22, -8, 0 },
			 { -2, -2, 97, 7, 47, -12, 0 },
			 { 0, -11, 79, 7, 72, -12, 0 },
			 { 0, -12, 54, 7, 93, -6, -1 },
			 { 0, -9, 29, 7, 103, 10, -5 },
			 { -4, 7, 103, 7, 32, -10, 0 },
			 { 0, -7, 89, 7, 58, -12, 0 },
			 { 0, -12, 69, 7, 81, -10, 0 },
			 { 0, -11, 43, 7, 98, 0, -2 } },
		.odd = { { -4, 9, 101, 7, 31, -9, 0 },
			 { -1, -6, 91, 7, 56, -12, 0 },
			 { 0, -12, 71, 7, 80, -11, 0 },
			 { 0, -11, 45, 7, 97, -1, -2 },
			 { 0, -7, 20, 7, 105, 17, -7 },
			 { -3, 1, 100, 7, 41, -11, 0 },
			 { 0, -10, 83, 7, 67, -12, 0 },
			 { 0, -13, 60, 7, 89, -8, 0 },
			 { 0, -10, 34, 7, 102, 6, -4 },
			 { -5, 11, 104, 7, 27, -9, 0 },
			 { -1, -5, 94, 7, 52, -12, 0 },
			 { 0, -12, 74, 7, 77, -11, 0 },
			 { 0, -12, 49, 7, 95, -3, -1 },
			 { 0, -8, 24, 7, 104, 14, -6 },
			 { -3, 3, 100, 7, 38, -10, 0 },
			 { 0, -9, 87, 7, 63, -13, 0 },
			 { 0, -13, 63, 7, 87, -9, 0 },
			 { 0, -10, 38, 7, 100, 3, -3 },
			 { -6, 14, 104, 7, 24, -8, 0 },
			 { -1, -3, 95, 7, 49, -12, 0 },
			 { 0, -11, 77, 7, 74, -12, 0 },
			 { 0, -12, 52, 7, 94, -5, -1 },
			 { 0, -9, 27, 7, 104, 11, -5 },
			 { -4, 6, 102, 7, 34, -10, 0 },
			 { 0, -8, 89, 7, 60, -13, 0 },
			 { 0, -12, 67, 7, 83, -10, 0 },
			 { 0, -11, 41, 7, 100, 1, -3 },
			 { -7, 17, 105, 7, 20, -7, 0 },
			 { -2, -1, 97, 7, 45, -11, 0 },
			 { 0, -11, 80, 7, 71, -12, 0 },
			 { 0, -12, 56, 7, 91, -6, -1 },
			 { 0, -9, 31, 7, 101, 9, -4 } } },
	.ptrn_arr = { { 0xff9ff3ff, 0xff3fe7fc, 0xff9 } },
	.sample_patrn_length = 78,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 8) = 0.8 */
	.hor_phase_arr = {
		.even = { { -8, 21, 102, 7, 21, -8, 0 },
			 { -3, 0, 95, 7, 48, -12, 0 },
			 { 0, -11, 75, 7, 75, -11, 0 },
			 { 0, -12, 48, 7, 95, 0, -3 } },
		.odd = { { -5, 9, 100, 7, 34, -10, 0 },
			 { -1, -7, 86, 7, 62, -12, 0 },
			 { 0, -12, 62, 7, 86, -7, -1 },
			 { 0, -10, 34, 7, 100, 9, -5 } } },
	.ver_phase_arr = {
		.even = { { -8, 21, 102, 7, 21, -8, 0 },
			 { -3, 0, 95, 7, 48, -12, 0 },
			 { 0, -11, 75, 7, 75, -11, 0 },
			 { 0, -12, 48, 7, 95, 0, -3 } },
		.odd = { { -5, 9, 100, 7, 34, -10, 0 },
			 { -1, -7, 86, 7, 62, -12, 0 },
			 { 0, -12, 62, 7, 86, -7, -1 },
			 { 0, -10, 34, 7, 100, 9, -5 } } },
	.ptrn_arr = { { 0xff } },
	.sample_patrn_length = 10,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 9) = 0.780488 */
	.hor_phase_arr = {
		.even = { { -9, 23, 100, 7, 23, -9, 0 },
			 { -3, 0, 91, 7, 52, -12, 0 },
			 { 0, -11, 68, 7, 80, -8, -1 },
			 { 0, -11, 39, 7, 96, 9, -5 },
			 { -6, 12, 98, 7, 35, -11, 0 },
			 { -1, -6, 81, 7, 65, -11, 0 },
			 { 0, -12, 55, 7, 89, -2, -2 },
			 { 0, -9, 26, 7, 99, 20, -8 },
			 { -4, 2, 93, 7, 49, -12, 0 },
			 { 0, -10, 71, 7, 76, -9, 0 },
			 { 0, -11, 42, 7, 95, 7, -5 },
			 { -7, 14, 99, 7, 32, -10, 0 },
			 { -1, -5, 84, 7, 62, -12, 0 },
			 { 0, -12, 59, 7, 87, -4, -2 },
			 { 0, -10, 29, 7, 99, 17, -7 },
			 { -4, 4, 95, 7, 45, -12, 0 },
			 { 0, -9, 72, 7, 74, -9, 0 },
			 { 0, -12, 45, 7, 95, 4, -4 },
			 { -7, 17, 99, 7, 29, -10, 0 },
			 { -2, -4, 87, 7, 59, -12, 0 },
			 { 0, -12, 62, 7, 84, -5, -1 },
			 { 0, -10, 32, 7, 99, 14, -7 },
			 { -5, 7, 95, 7, 42, -11, 0 },
			 { 0, -9, 76, 7, 71, -10, 0 },
			 { 0, -12, 49, 7, 93, 2, -4 },
			 { -8, 20, 99, 7, 26, -9, 0 },
			 { -2, -2, 89, 7, 55, -12, 0 },
			 { 0, -11, 65, 7, 81, -6, -1 },
			 { 0, -11, 35, 7, 98, 12, -6 },
			 { -5, 9, 96, 7, 39, -11, 0 },
			 { -1, -8, 80, 7, 68, -11, 0 },
			 { 0, -12, 52, 7, 91, 0, -3 } },
		.odd = { { -6, 10, 98, 7, 37, -11, 0 },
			 { -1, -7, 81, 7, 66, -11, 0 },
			 { 0, -12, 54, 7, 90, -1, -3 },
			 { 0, -9, 24, 7, 100, 21, -8 },
			 { -3, 1, 92, 7, 50, -12, 0 },
			 { 0, -10, 69, 7, 78, -8, -1 },
			 { 0, -11, 40, 7, 96, 8, -5 },
			 { -6, 13, 97, 7, 34, -10, 0 },
			 { -1, -6, 83, 7, 63, -11, 0 },
			 { 0, -12, 57, 7, 88, -3, -2 },
			 { 0, -9, 27, 7, 100, 18, -8 },
			 { -4, 3, 94, 7, 47, -12, 0 },
			 { 0, -10, 72, 7, 75, -9, 0 },
			 { 0, -11, 44, 7, 95, 5, -5 },
			 { -7, 16, 98, 7, 31, -10, 0 },
			 { -2, -4, 86, 7, 60, -12, 0 },
			 { 0, -12, 60, 7, 86, -4, -2 },
			 { 0, -10, 31, 7, 98, 16, -7 },
			 { -5, 5, 95, 7, 44, -11, 0 },
			 { 0, -9, 75, 7, 72, -10, 0 },
			 { 0, -12, 47, 7, 94, 3, -4 },
			 { -8, 18, 100, 7, 27, -9, 0 },
			 { -2, -3, 88, 7, 57, -12, 0 },
			 { 0, -11, 63, 7, 83, -6, -1 },
			 { 0, -10, 34, 7, 97, 13, -6 },
			 { -5, 8, 96, 7, 40, -11, 0 },
			 { -1, -8, 78, 7, 69, -10, 0 },
			 { 0, -12, 50, 7, 92, 1, -3 },
			 { -8, 21, 100, 7, 24, -9, 0 },
			 { -3, -1, 90, 7, 54, -12, 0 },
			 { 0, -11, 66, 7, 81, -7, -1 },
			 { 0, -11, 37, 7, 98, 10, -6 } } },
	.ver_phase_arr = {
		.even = { { -9, 23, 100, 7, 23, -9, 0 },
			 { -3, 0, 91, 7, 52, -12, 0 },
			 { 0, -11, 68, 7, 80, -8, -1 },
			 { 0, -11, 39, 7, 96, 9, -5 },
			 { -6, 12, 98, 7, 35, -11, 0 },
			 { -1, -6, 81, 7, 65, -11, 0 },
			 { 0, -12, 55, 7, 89, -2, -2 },
			 { 0, -9, 26, 7, 99, 20, -8 },
			 { -4, 2, 93, 7, 49, -12, 0 },
			 { 0, -10, 71, 7, 76, -9, 0 },
			 { 0, -11, 42, 7, 95, 7, -5 },
			 { -7, 14, 99, 7, 32, -10, 0 },
			 { -1, -5, 84, 7, 62, -12, 0 },
			 { 0, -12, 59, 7, 87, -4, -2 },
			 { 0, -10, 29, 7, 99, 17, -7 },
			 { -4, 4, 95, 7, 45, -12, 0 },
			 { 0, -9, 72, 7, 74, -9, 0 },
			 { 0, -12, 45, 7, 95, 4, -4 },
			 { -7, 17, 99, 7, 29, -10, 0 },
			 { -2, -4, 87, 7, 59, -12, 0 },
			 { 0, -12, 62, 7, 84, -5, -1 },
			 { 0, -10, 32, 7, 99, 14, -7 },
			 { -5, 7, 95, 7, 42, -11, 0 },
			 { 0, -9, 76, 7, 71, -10, 0 },
			 { 0, -12, 49, 7, 93, 2, -4 },
			 { -8, 20, 99, 7, 26, -9, 0 },
			 { -2, -2, 89, 7, 55, -12, 0 },
			 { 0, -11, 65, 7, 81, -6, -1 },
			 { 0, -11, 35, 7, 98, 12, -6 },
			 { -5, 9, 96, 7, 39, -11, 0 },
			 { -1, -8, 80, 7, 68, -11, 0 },
			 { 0, -12, 52, 7, 91, 0, -3 } },
		.odd = { { -6, 10, 98, 7, 37, -11, 0 },
			 { -1, -7, 81, 7, 66, -11, 0 },
			 { 0, -12, 54, 7, 90, -1, -3 },
			 { 0, -9, 24, 7, 100, 21, -8 },
			 { -3, 1, 92, 7, 50, -12, 0 },
			 { 0, -10, 69, 7, 78, -8, -1 },
			 { 0, -11, 40, 7, 96, 8, -5 },
			 { -6, 13, 97, 7, 34, -10, 0 },
			 { -1, -6, 83, 7, 63, -11, 0 },
			 { 0, -12, 57, 7, 88, -3, -2 },
			 { 0, -9, 27, 7, 100, 18, -8 },
			 { -4, 3, 94, 7, 47, -12, 0 },
			 { 0, -10, 72, 7, 75, -9, 0 },
			 { 0, -11, 44, 7, 95, 5, -5 },
			 { -7, 16, 98, 7, 31, -10, 0 },
			 { -2, -4, 86, 7, 60, -12, 0 },
			 { 0, -12, 60, 7, 86, -4, -2 },
			 { 0, -10, 31, 7, 98, 16, -7 },
			 { -5, 5, 95, 7, 44, -11, 0 },
			 { 0, -9, 75, 7, 72, -10, 0 },
			 { 0, -12, 47, 7, 94, 3, -4 },
			 { -8, 18, 100, 7, 27, -9, 0 },
			 { -2, -3, 88, 7, 57, -12, 0 },
			 { 0, -11, 63, 7, 83, -6, -1 },
			 { 0, -10, 34, 7, 97, 13, -6 },
			 { -5, 8, 96, 7, 40, -11, 0 },
			 { -1, -8, 78, 7, 69, -10, 0 },
			 { 0, -12, 50, 7, 92, 1, -3 },
			 { -8, 21, 100, 7, 24, -9, 0 },
			 { -3, -1, 90, 7, 54, -12, 0 },
			 { 0, -11, 66, 7, 81, -7, -1 },
			 { 0, -11, 37, 7, 98, 10, -6 } } },
	.ptrn_arr = { { 0xf3f9fcff, 0x3f9fcfe7, 0xfe7f } },
	.sample_patrn_length = 82,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 10) = 0.761905 */
	.hor_phase_arr = {
		.even = { { -9, 25, 96, 7, 25, -9, 0 },
			 { -3, 0, 86, 7, 56, -11, 0 },
			 { 0, -11, 62, 7, 82, -3, -2 },
			 { 0, -10, 31, 7, 96, 19, -8 },
			 { -5, 4, 92, 7, 49, -12, 0 },
			 { 0, -10, 67, 7, 78, -6, -1 },
			 { 0, -11, 37, 7, 95, 14, -7 },
			 { -6, 9, 93, 7, 43, -11, 0 },
			 { -1, -8, 73, 7, 73, -8, -1 },
			 { 0, -11, 43, 7, 93, 9, -6 },
			 { -7, 14, 95, 7, 37, -11, 0 },
			 { -1, -6, 78, 7, 67, -10, 0 },
			 { 0, -12, 49, 7, 92, 4, -5 },
			 { -8, 19, 96, 7, 31, -10, 0 },
			 { -2, -3, 82, 7, 62, -11, 0 },
			 { 0, -11, 56, 7, 86, 0, -3 } },
		.odd = { { -6, 11, 94, 7, 40, -11, 0 },
			 { -1, -7, 75, 7, 70, -9, 0 },
			 { 0, -12, 46, 7, 93, 6, -5 },
			 { -8, 16, 97, 7, 34, -11, 0 },
			 { -2, -5, 81, 7, 64, -10, 0 },
			 { 0, -12, 53, 7, 89, 2, -4 },
			 { -9, 22, 97, 7, 28, -10, 0 },
			 { -3, -2, 85, 7, 59, -11, 0 },
			 { 0, -11, 59, 7, 85, -2, -3 },
			 { 0, -10, 28, 7, 97, 22, -9 },
			 { -4, 2, 89, 7, 53, -12, 0 },
			 { 0, -10, 64, 7, 81, -5, -2 },
			 { 0, -11, 34, 7, 97, 16, -8 },
			 { -5, 6, 93, 7, 46, -12, 0 },
			 { 0, -9, 70, 7, 75, -7, -1 },
			 { 0, -11, 40, 7, 94, 11, -6 } } },
	.ver_phase_arr = {
		.even = { { -9, 25, 96, 7, 25, -9, 0 },
			 { -3, 0, 86, 7, 56, -11, 0 },
			 { 0, -11, 62, 7, 82, -3, -2 },
			 { 0, -10, 31, 7, 96, 19, -8 },
			 { -5, 4, 92, 7, 49, -12, 0 },
			 { 0, -10, 67, 7, 78, -6, -1 },
			 { 0, -11, 37, 7, 95, 14, -7 },
			 { -6, 9, 93, 7, 43, -11, 0 },
			 { -1, -8, 73, 7, 73, -8, -1 },
			 { 0, -11, 43, 7, 93, 9, -6 },
			 { -7, 14, 95, 7, 37, -11, 0 },
			 { -1, -6, 78, 7, 67, -10, 0 },
			 { 0, -12, 49, 7, 92, 4, -5 },
			 { -8, 19, 96, 7, 31, -10, 0 },
			 { -2, -3, 82, 7, 62, -11, 0 },
			 { 0, -11, 56, 7, 86, 0, -3 } },
		.odd = { { -6, 11, 94, 7, 40, -11, 0 },
			 { -1, -7, 75, 7, 70, -9, 0 },
			 { 0, -12, 46, 7, 93, 6, -5 },
			 { -8, 16, 97, 7, 34, -11, 0 },
			 { -2, -5, 81, 7, 64, -10, 0 },
			 { 0, -12, 53, 7, 89, 2, -4 },
			 { -9, 22, 97, 7, 28, -10, 0 },
			 { -3, -2, 85, 7, 59, -11, 0 },
			 { 0, -11, 59, 7, 85, -2, -3 },
			 { 0, -10, 28, 7, 97, 22, -9 },
			 { -4, 2, 89, 7, 53, -12, 0 },
			 { 0, -10, 64, 7, 81, -5, -2 },
			 { 0, -11, 34, 7, 97, 16, -8 },
			 { -5, 6, 93, 7, 46, -12, 0 },
			 { 0, -9, 70, 7, 75, -7, -1 },
			 { 0, -11, 40, 7, 94, 11, -6 } } },
	.ptrn_arr = { { 0xfcfe7e7f, 0xfc } },
	.sample_patrn_length = 42,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 11) = 0.744186 */
	.hor_phase_arr = {
		.even = { { -10, 26, 96, 7, 26, -10, 0 },
			 { -4, 0, 83, 7, 59, -10, 0 },
			 { 0, -11, 56, 7, 85, 2, -4 },
			 { -9, 23, 95, 7, 29, -10, 0 },
			 { -3, -2, 82, 7, 61, -10, 0 },
			 { 0, -11, 53, 7, 87, 4, -5 },
			 { -9, 21, 94, 7, 32, -10, 0 },
			 { -3, -3, 79, 7, 64, -9, 0 },
			 { 0, -11, 50, 7, 88, 6, -5 },
			 { -8, 18, 94, 7, 35, -11, 0 },
			 { -2, -5, 78, 7, 67, -9, -1 },
			 { 0, -11, 47, 7, 90, 8, -6 },
			 { -8, 15, 94, 7, 38, -11, 0 },
			 { -2, -6, 75, 7, 70, -8, -1 },
			 { 0, -11, 44, 7, 92, 10, -7 },
			 { -7, 13, 92, 7, 41, -11, 0 },
			 { -1, -7, 72, 7, 72, -7, -1 },
			 { 0, -11, 41, 7, 92, 13, -7 },
			 { -7, 10, 92, 7, 44, -11, 0 },
			 { -1, -8, 70, 7, 75, -6, -2 },
			 { 0, -11, 38, 7, 94, 15, -8 },
			 { -6, 8, 90, 7, 47, -11, 0 },
			 { -1, -9, 67, 7, 78, -5, -2 },
			 { 0, -11, 35, 7, 94, 18, -8 },
			 { -5, 6, 88, 7, 50, -11, 0 },
			 { 0, -9, 64, 7, 79, -3, -3 },
			 { 0, -10, 32, 7, 94, 21, -9 },
			 { -5, 4, 87, 7, 53, -11, 0 },
			 { 0, -10, 61, 7, 82, -2, -3 },
			 { 0, -10, 29, 7, 95, 23, -9 },
			 { -4, 2, 85, 7, 56, -11, 0 },
			 { 0, -10, 59, 7, 83, 0, -4 } },
		.odd = { { -7, 12, 92, 7, 42, -11, 0 },
			 { -1, -7, 71, 7, 72, -6, -1 },
			 { 0, -11, 39, 7, 93, 14, -7 },
			 { -6, 9, 91, 7, 45, -11, 0 },
			 { -1, -8, 68, 7, 76, -5, -2 },
			 { 0, -11, 36, 7, 94, 17, -8 },
			 { -6, 7, 90, 7, 48, -11, 0 },
			 { 0, -9, 66, 7, 77, -4, -2 },
			 { 0, -11, 33, 7, 96, 19, -9 },
			 { -5, 5, 88, 7, 51, -11, 0 },
			 { 0, -10, 63, 7, 80, -2, -3 },
			 { 0, -10, 31, 7, 94, 22, -9 },
			 { -5, 3, 87, 7, 54, -11, 0 },
			 { 0, -10, 60, 7, 82, -1, -3 },
			 { 0, -10, 28, 7, 94, 25, -9 },
			 { -4, 1, 85, 7, 57, -11, 0 },
			 { 0, -11, 57, 7, 85, 1, -4 },
			 { -9, 25, 94, 7, 28, -10, 0 },
			 { -3, -1, 82, 7, 60, -10, 0 },
			 { 0, -11, 54, 7, 87, 3, -5 },
			 { -9, 22, 94, 7, 31, -10, 0 },
			 { -3, -2, 80, 7, 63, -10, 0 },
			 { 0, -11, 51, 7, 88, 5, -5 },
			 { -9, 19, 96, 7, 33, -11, 0 },
			 { -2, -4, 77, 7, 66, -9, 0 },
			 { 0, -11, 48, 7, 90, 7, -6 },
			 { -8, 17, 94, 7, 36, -11, 0 },
			 { -2, -5, 76, 7, 68, -8, -1 },
			 { 0, -11, 45, 7, 91, 9, -6 },
			 { -7, 14, 93, 7, 39, -11, 0 },
			 { -1, -6, 72, 7, 71, -7, -1 },
			 { 0, -11, 42, 7, 92, 12, -7 } } },
	.ver_phase_arr = {
		.even = { { -10, 26, 96, 7, 26, -10, 0 },
			 { -4, 0, 83, 7, 59, -10, 0 },
			 { 0, -11, 56, 7, 85, 2, -4 },
			 { -9, 23, 95, 7, 29, -10, 0 },
			 { -3, -2, 82, 7, 61, -10, 0 },
			 { 0, -11, 53, 7, 87, 4, -5 },
			 { -9, 21, 94, 7, 32, -10, 0 },
			 { -3, -3, 79, 7, 64, -9, 0 },
			 { 0, -11, 50, 7, 88, 6, -5 },
			 { -8, 18, 94, 7, 35, -11, 0 },
			 { -2, -5, 78, 7, 67, -9, -1 },
			 { 0, -11, 47, 7, 90, 8, -6 },
			 { -8, 15, 94, 7, 38, -11, 0 },
			 { -2, -6, 75, 7, 70, -8, -1 },
			 { 0, -11, 44, 7, 92, 10, -7 },
			 { -7, 13, 92, 7, 41, -11, 0 },
			 { -1, -7, 72, 7, 72, -7, -1 },
			 { 0, -11, 41, 7, 92, 13, -7 },
			 { -7, 10, 92, 7, 44, -11, 0 },
			 { -1, -8, 70, 7, 75, -6, -2 },
			 { 0, -11, 38, 7, 94, 15, -8 },
			 { -6, 8, 90, 7, 47, -11, 0 },
			 { -1, -9, 67, 7, 78, -5, -2 },
			 { 0, -11, 35, 7, 94, 18, -8 },
			 { -5, 6, 88, 7, 50, -11, 0 },
			 { 0, -9, 64, 7, 79, -3, -3 },
			 { 0, -10, 32, 7, 94, 21, -9 },
			 { -5, 4, 87, 7, 53, -11, 0 },
			 { 0, -10, 61, 7, 82, -2, -3 },
			 { 0, -10, 29, 7, 95, 23, -9 },
			 { -4, 2, 85, 7, 56, -11, 0 },
			 { 0, -10, 59, 7, 83, 0, -4 } },
		.odd = { { -7, 12, 92, 7, 42, -11, 0 },
			 { -1, -7, 71, 7, 72, -6, -1 },
			 { 0, -11, 39, 7, 93, 14, -7 },
			 { -6, 9, 91, 7, 45, -11, 0 },
			 { -1, -8, 68, 7, 76, -5, -2 },
			 { 0, -11, 36, 7, 94, 17, -8 },
			 { -6, 7, 90, 7, 48, -11, 0 },
			 { 0, -9, 66, 7, 77, -4, -2 },
			 { 0, -11, 33, 7, 96, 19, -9 },
			 { -5, 5, 88, 7, 51, -11, 0 },
			 { 0, -10, 63, 7, 80, -2, -3 },
			 { 0, -10, 31, 7, 94, 22, -9 },
			 { -5, 3, 87, 7, 54, -11, 0 },
			 { 0, -10, 60, 7, 82, -1, -3 },
			 { 0, -10, 28, 7, 94, 25, -9 },
			 { -4, 1, 85, 7, 57, -11, 0 },
			 { 0, -11, 57, 7, 85, 1, -4 },
			 { -9, 25, 94, 7, 28, -10, 0 },
			 { -3, -1, 82, 7, 60, -10, 0 },
			 { 0, -11, 54, 7, 87, 3, -5 },
			 { -9, 22, 94, 7, 31, -10, 0 },
			 { -3, -2, 80, 7, 63, -10, 0 },
			 { 0, -11, 51, 7, 88, 5, -5 },
			 { -9, 19, 96, 7, 33, -11, 0 },
			 { -2, -4, 77, 7, 66, -9, 0 },
			 { 0, -11, 48, 7, 90, 7, -6 },
			 { -8, 17, 94, 7, 36, -11, 0 },
			 { -2, -5, 76, 7, 68, -8, -1 },
			 { 0, -11, 45, 7, 91, 9, -6 },
			 { -7, 14, 93, 7, 39, -11, 0 },
			 { -1, -6, 72, 7, 71, -7, -1 },
			 { 0, -11, 42, 7, 92, 12, -7 } } },
	.ptrn_arr = { { 0x3f3f3f3f, 0x9f9f9f3f, 0xf9f9f } },
	.sample_patrn_length = 86,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 12) = 0.727273 */
	.hor_phase_arr = {
		.even = { { -10, 28, 92, 7, 28, -10, 0 },
			 { -4, 0, 81, 7, 61, -9, -1 },
			 { 0, -11, 50, 7, 87, 8, -6 },
			 { -8, 17, 91, 7, 39, -11, 0 },
			 { -2, -6, 72, 7, 72, -6, -2 },
			 { 0, -11, 39, 7, 91, 17, -8 },
			 { -6, 8, 87, 7, 50, -11, 0 },
			 { -1, -9, 61, 7, 81, 0, -4 } },
		.odd = { { -7, 12, 89, 7, 45, -11, 0 },
			 { -1, -8, 67, 7, 76, -3, -3 },
			 { 0, -11, 33, 7, 93, 22, -9 },
			 { -5, 4, 83, 7, 56, -10, 0 },
			 { 0, -10, 56, 7, 83, 4, -5 },
			 { -9, 22, 93, 7, 33, -11, 0 },
			 { -3, -3, 76, 7, 67, -8, -1 },
			 { 0, -11, 45, 7, 89, 12, -7 } } },
	.ver_phase_arr = {
		.even = { { -10, 28, 92, 7, 28, -10, 0 },
			 { -4, 0, 81, 7, 61, -9, -1 },
			 { 0, -11, 50, 7, 87, 8, -6 },
			 { -8, 17, 91, 7, 39, -11, 0 },
			 { -2, -6, 72, 7, 72, -6, -2 },
			 { 0, -11, 39, 7, 91, 17, -8 },
			 { -6, 8, 87, 7, 50, -11, 0 },
			 { -1, -9, 61, 7, 81, 0, -4 } },
		.odd = { { -7, 12, 89, 7, 45, -11, 0 },
			 { -1, -8, 67, 7, 76, -3, -3 },
			 { 0, -11, 33, 7, 93, 22, -9 },
			 { -5, 4, 83, 7, 56, -10, 0 },
			 { 0, -10, 56, 7, 83, 4, -5 },
			 { -9, 22, 93, 7, 33, -11, 0 },
			 { -3, -3, 76, 7, 67, -8, -1 },
			 { 0, -11, 45, 7, 89, 12, -7 } } },
	.ptrn_arr = { { 0xf9f3f } },
	.sample_patrn_length = 22,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 13) = 0.711111 */
	.hor_phase_arr = {
		.even = { { -10, 29, 90, 7, 29, -10, 0 },
			 { -4, 0, 76, 7, 64, -7, -1 },
			 { 0, -11, 45, 7, 88, 14, -8 },
			 { -7, 12, 85, 7, 48, -10, 0 },
			 { -1, -8, 61, 7, 79, 2, -5 },
			 { -10, 26, 90, 7, 32, -10, 0 },
			 { -4, -2, 76, 7, 66, -6, -2 },
			 { 0, -11, 42, 7, 89, 16, -8 },
			 { -7, 10, 84, 7, 51, -10, 0 },
			 { -1, -9, 59, 7, 81, 3, -5 },
			 { -10, 24, 91, 7, 34, -11, 0 },
			 { -3, -3, 72, 7, 69, -5, -2 },
			 { 0, -11, 40, 7, 89, 19, -9 },
			 { -6, 7, 84, 7, 53, -10, 0 },
			 { -1, -9, 56, 7, 83, 5, -6 },
			 { -9, 21, 90, 7, 37, -11, 0 },
			 { -3, -4, 71, 7, 71, -4, -3 },
			 { 0, -11, 37, 7, 90, 21, -9 },
			 { -6, 5, 83, 7, 56, -9, -1 },
			 { 0, -10, 53, 7, 84, 7, -6 },
			 { -9, 19, 89, 7, 40, -11, 0 },
			 { -2, -5, 69, 7, 72, -3, -3 },
			 { 0, -11, 34, 7, 91, 24, -10 },
			 { -5, 3, 81, 7, 59, -9, -1 },
			 { 0, -10, 51, 7, 84, 10, -7 },
			 { -8, 16, 89, 7, 42, -11, 0 },
			 { -2, -6, 66, 7, 76, -2, -4 },
			 { 0, -10, 32, 7, 90, 26, -10 },
			 { -5, 2, 79, 7, 61, -8, -1 },
			 { 0, -10, 48, 7, 85, 12, -7 },
			 { -8, 14, 88, 7, 45, -11, 0 },
			 { -1, -7, 64, 7, 76, 0, -4 } },
		.odd = { { -8, 13, 88, 7, 46, -11, 0 },
			 { -1, -8, 63, 7, 78, 1, -5 },
			 { -10, 28, 90, 7, 30, -10, 0 },
			 { -4, -1, 77, 7, 65, -7, -2 },
			 { 0, -11, 44, 7, 88, 15, -8 },
			 { -7, 11, 85, 7, 49, -10, 0 },
			 { -1, -8, 60, 7, 79, 3, -5 },
			 { -10, 25, 91, 7, 33, -11, 0 },
			 { -4, -2, 74, 7, 68, -6, -2 },
			 { 0, -11, 41, 7, 89, 18, -9 },
			 { -7, 8, 85, 7, 52, -10, 0 },
			 { -1, -9, 57, 7, 83, 4, -6 },
			 { -9, 22, 90, 7, 36, -11, 0 },
			 { -3, -4, 73, 7, 70, -5, -3 },
			 { 0, -11, 38, 7, 90, 20, -9 },
			 { -6, 6, 83, 7, 55, -10, 0 },
			 { 0, -10, 55, 7, 83, 6, -6 },
			 { -9, 20, 90, 7, 38, -11, 0 },
			 { -3, -5, 70, 7, 73, -4, -3 },
			 { 0, -11, 36, 7, 90, 22, -9 },
			 { -6, 4, 83, 7, 57, -9, -1 },
			 { 0, -10, 52, 7, 85, 8, -7 },
			 { -9, 18, 89, 7, 41, -11, 0 },
			 { -2, -6, 68, 7, 74, -2, -4 },
			 { 0, -11, 33, 7, 91, 25, -10 },
			 { -5, 3, 79, 7, 60, -8, -1 },
			 { 0, -10, 49, 7, 85, 11, -7 },
			 { -8, 15, 88, 7, 44, -11, 0 },
			 { -2, -7, 65, 7, 77, -1, -4 },
			 { 0, -10, 30, 7, 90, 28, -10 },
			 { -5, 1, 78, 7, 63, -8, -1 },
			 { 0, -11, 46, 7, 88, 13, -8 } } },
	.ver_phase_arr = {
		.even = { { -10, 29, 90, 7, 29, -10, 0 },
			 { -4, 0, 76, 7, 64, -7, -1 },
			 { 0, -11, 45, 7, 88, 14, -8 },
			 { -7, 12, 85, 7, 48, -10, 0 },
			 { -1, -8, 61, 7, 79, 2, -5 },
			 { -10, 26, 90, 7, 32, -10, 0 },
			 { -4, -2, 76, 7, 66, -6, -2 },
			 { 0, -11, 42, 7, 89, 16, -8 },
			 { -7, 10, 84, 7, 51, -10, 0 },
			 { -1, -9, 59, 7, 81, 3, -5 },
			 { -10, 24, 91, 7, 34, -11, 0 },
			 { -3, -3, 72, 7, 69, -5, -2 },
			 { 0, -11, 40, 7, 89, 19, -9 },
			 { -6, 7, 84, 7, 53, -10, 0 },
			 { -1, -9, 56, 7, 83, 5, -6 },
			 { -9, 21, 90, 7, 37, -11, 0 },
			 { -3, -4, 71, 7, 71, -4, -3 },
			 { 0, -11, 37, 7, 90, 21, -9 },
			 { -6, 5, 83, 7, 56, -9, -1 },
			 { 0, -10, 53, 7, 84, 7, -6 },
			 { -9, 19, 89, 7, 40, -11, 0 },
			 { -2, -5, 69, 7, 72, -3, -3 },
			 { 0, -11, 34, 7, 91, 24, -10 },
			 { -5, 3, 81, 7, 59, -9, -1 },
			 { 0, -10, 51, 7, 84, 10, -7 },
			 { -8, 16, 89, 7, 42, -11, 0 },
			 { -2, -6, 66, 7, 76, -2, -4 },
			 { 0, -10, 32, 7, 90, 26, -10 },
			 { -5, 2, 79, 7, 61, -8, -1 },
			 { 0, -10, 48, 7, 85, 12, -7 },
			 { -8, 14, 88, 7, 45, -11, 0 },
			 { -1, -7, 64, 7, 76, 0, -4 } },
		.odd = { { -8, 13, 88, 7, 46, -11, 0 },
			 { -1, -8, 63, 7, 78, 1, -5 },
			 { -10, 28, 90, 7, 30, -10, 0 },
			 { -4, -1, 77, 7, 65, -7, -2 },
			 { 0, -11, 44, 7, 88, 15, -8 },
			 { -7, 11, 85, 7, 49, -10, 0 },
			 { -1, -8, 60, 7, 79, 3, -5 },
			 { -10, 25, 91, 7, 33, -11, 0 },
			 { -4, -2, 74, 7, 68, -6, -2 },
			 { 0, -11, 41, 7, 89, 18, -9 },
			 { -7, 8, 85, 7, 52, -10, 0 },
			 { -1, -9, 57, 7, 83, 4, -6 },
			 { -9, 22, 90, 7, 36, -11, 0 },
			 { -3, -4, 73, 7, 70, -5, -3 },
			 { 0, -11, 38, 7, 90, 20, -9 },
			 { -6, 6, 83, 7, 55, -10, 0 },
			 { 0, -10, 55, 7, 83, 6, -6 },
			 { -9, 20, 90, 7, 38, -11, 0 },
			 { -3, -5, 70, 7, 73, -4, -3 },
			 { 0, -11, 36, 7, 90, 22, -9 },
			 { -6, 4, 83, 7, 57, -9, -1 },
			 { 0, -10, 52, 7, 85, 8, -7 },
			 { -9, 18, 89, 7, 41, -11, 0 },
			 { -2, -6, 68, 7, 74, -2, -4 },
			 { 0, -11, 33, 7, 91, 25, -10 },
			 { -5, 3, 79, 7, 60, -8, -1 },
			 { 0, -10, 49, 7, 85, 11, -7 },
			 { -8, 15, 88, 7, 44, -11, 0 },
			 { -2, -7, 65, 7, 77, -1, -4 },
			 { 0, -10, 30, 7, 90, 28, -10 },
			 { -5, 1, 78, 7, 63, -8, -1 },
			 { 0, -11, 46, 7, 88, 13, -8 } } },
	.ptrn_arr = { { 0xf3e7cf9f, 0x9f3e7cf9, 0xf3e7cf } },
	.sample_patrn_length = 90,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 14) = 0.695652 */
	.hor_phase_arr = {
		.even = { { -10, 30, 88, 7, 30, -10, 0 },
			 { -5, 0, 75, 7, 66, -5, -3 },
			 { 0, -10, 40, 7, 87, 20, -9 },
			 { -7, 7, 81, 7, 56, -8, -1 },
			 { 0, -9, 51, 7, 83, 11, -8 },
			 { -8, 16, 84, 7, 46, -10, 0 },
			 { -2, -7, 61, 7, 79, 3, -6 },
			 { -10, 25, 88, 7, 35, -10, 0 },
			 { -4, -3, 72, 7, 70, -3, -4 },
			 { 0, -10, 35, 7, 88, 25, -10 },
			 { -6, 3, 79, 7, 61, -7, -2 },
			 { 0, -10, 46, 7, 84, 16, -8 },
			 { -8, 11, 83, 7, 51, -9, 0 },
			 { -1, -8, 56, 7, 81, 7, -7 },
			 { -9, 20, 87, 7, 40, -10, 0 },
			 { -3, -5, 66, 7, 75, 0, -5 } },
		.odd = { { -8, 13, 85, 7, 48, -10, 0 },
			 { -1, -8, 59, 7, 79, 5, -6 },
			 { -10, 23, 87, 7, 38, -10, 0 },
			 { -3, -4, 68, 7, 72, -1, -4 },
			 { 0, -10, 33, 7, 87, 28, -10 },
			 { -5, 2, 75, 7, 64, -6, -2 },
			 { 0, -10, 43, 7, 86, 18, -9 },
			 { -7, 9, 83, 7, 53, -9, -1 },
			 { -1, -9, 53, 7, 83, 9, -7 },
			 { -9, 18, 86, 7, 43, -10, 0 },
			 { -2, -6, 64, 7, 75, 2, -5 },
			 { -10, 28, 87, 7, 33, -10, 0 },
			 { -4, -1, 72, 7, 68, -4, -3 },
			 { 0, -10, 38, 7, 87, 23, -10 },
			 { -6, 5, 79, 7, 59, -8, -1 },
			 { 0, -10, 48, 7, 85, 13, -8 } } },
	.ver_phase_arr = {
		.even = { { -10, 30, 88, 7, 30, -10, 0 },
			 { -5, 0, 75, 7, 66, -5, -3 },
			 { 0, -10, 40, 7, 87, 20, -9 },
			 { -7, 7, 81, 7, 56, -8, -1 },
			 { 0, -9, 51, 7, 83, 11, -8 },
			 { -8, 16, 84, 7, 46, -10, 0 },
			 { -2, -7, 61, 7, 79, 3, -6 },
			 { -10, 25, 88, 7, 35, -10, 0 },
			 { -4, -3, 72, 7, 70, -3, -4 },
			 { 0, -10, 35, 7, 88, 25, -10 },
			 { -6, 3, 79, 7, 61, -7, -2 },
			 { 0, -10, 46, 7, 84, 16, -8 },
			 { -8, 11, 83, 7, 51, -9, 0 },
			 { -1, -8, 56, 7, 81, 7, -7 },
			 { -9, 20, 87, 7, 40, -10, 0 },
			 { -3, -5, 66, 7, 75, 0, -5 } },
		.odd = { { -8, 13, 85, 7, 48, -10, 0 },
			 { -1, -8, 59, 7, 79, 5, -6 },
			 { -10, 23, 87, 7, 38, -10, 0 },
			 { -3, -4, 68, 7, 72, -1, -4 },
			 { 0, -10, 33, 7, 87, 28, -10 },
			 { -5, 2, 75, 7, 64, -6, -2 },
			 { 0, -10, 43, 7, 86, 18, -9 },
			 { -7, 9, 83, 7, 53, -9, -1 },
			 { -1, -9, 53, 7, 83, 9, -7 },
			 { -9, 18, 86, 7, 43, -10, 0 },
			 { -2, -6, 64, 7, 75, 2, -5 },
			 { -10, 28, 87, 7, 33, -10, 0 },
			 { -4, -1, 72, 7, 68, -4, -3 },
			 { 0, -10, 38, 7, 87, 23, -10 },
			 { -6, 5, 79, 7, 59, -8, -1 },
			 { 0, -10, 48, 7, 85, 13, -8 } } },
	.ptrn_arr = { { 0x79f3cf9f, 0xf3e } },
	.sample_patrn_length = 46,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 15) = 0.680851 */
	.hor_phase_arr = {
		.even = { { -10, 31, 86, 7, 31, -10, 0 },
			 { -5, 0, 72, 7, 68, -3, -4 },
			 { 0, -10, 36, 7, 86, 26, -10 },
			 { -6, 3, 76, 7, 63, -5, -3 },
			 { 0, -10, 41, 7, 85, 21, -9 },
			 { -7, 7, 78, 7, 59, -7, -2 },
			 { 0, -10, 46, 7, 84, 17, -9 },
			 { -8, 11, 80, 7, 54, -8, -1 },
			 { -1, -9, 51, 7, 82, 13, -8 },
			 { -9, 15, 83, 7, 49, -9, -1 },
			 { -2, -8, 56, 7, 80, 9, -7 },
			 { -9, 19, 85, 7, 43, -10, 0 },
			 { -3, -6, 61, 7, 77, 5, -6 },
			 { -10, 24, 86, 7, 38, -10, 0 },
			 { -3, -4, 66, 7, 72, 2, -5 },
			 { -10, 29, 86, 7, 33, -10, 0 },
			 { -4, -1, 68, 7, 70, -1, -4 },
			 { 0, -10, 33, 7, 86, 29, -10 },
			 { -5, 2, 72, 7, 66, -4, -3 },
			 { 0, -10, 38, 7, 86, 24, -10 },
			 { -6, 5, 77, 7, 61, -6, -3 },
			 { 0, -10, 43, 7, 85, 19, -9 },
			 { -7, 9, 80, 7, 56, -8, -2 },
			 { -1, -9, 49, 7, 83, 15, -9 },
			 { -8, 13, 82, 7, 51, -9, -1 },
			 { -1, -8, 54, 7, 80, 11, -8 },
			 { -9, 17, 84, 7, 46, -10, 0 },
			 { -2, -7, 59, 7, 78, 7, -7 },
			 { -9, 21, 85, 7, 41, -10, 0 },
			 { -3, -5, 63, 7, 76, 3, -6 },
			 { -10, 26, 86, 7, 36, -10, 0 },
			 { -4, -3, 68, 7, 72, 0, -5 } },
		.odd = { { -8, 14, 82, 7, 50, -9, -1 },
			 { -1, -8, 55, 7, 79, 10, -7 },
			 { -9, 18, 84, 7, 45, -10, 0 },
			 { -2, -6, 60, 7, 77, 6, -7 },
			 { -10, 23, 85, 7, 40, -10, 0 },
			 { -3, -4, 64, 7, 75, 2, -6 },
			 { -10, 27, 86, 7, 35, -10, 0 },
			 { -4, -2, 69, 7, 71, -1, -5 },
			 { 0, -10, 32, 7, 86, 30, -10 },
			 { -5, 1, 72, 7, 67, -3, -4 },
			 { 0, -10, 37, 7, 86, 25, -10 },
			 { -6, 4, 77, 7, 62, -6, -3 },
			 { 0, -10, 42, 7, 85, 20, -9 },
			 { -7, 8, 79, 7, 57, -7, -2 },
			 { -1, -9, 47, 7, 84, 16, -9 },
			 { -8, 12, 81, 7, 52, -8, -1 },
			 { -1, -8, 52, 7, 81, 12, -8 },
			 { -9, 16, 84, 7, 47, -9, -1 },
			 { -2, -7, 57, 7, 79, 8, -7 },
			 { -9, 20, 85, 7, 42, -10, 0 },
			 { -3, -6, 62, 7, 77, 4, -6 },
			 { -10, 25, 86, 7, 37, -10, 0 },
			 { -4, -3, 67, 7, 72, 1, -5 },
			 { -10, 30, 86, 7, 32, -10, 0 },
			 { -5, -1, 71, 7, 69, -2, -4 },
			 { 0, -10, 35, 7, 86, 27, -10 },
			 { -6, 2, 75, 7, 64, -4, -3 },
			 { 0, -10, 40, 7, 85, 23, -10 },
			 { -7, 6, 77, 7, 60, -6, -2 },
			 { 0, -10, 45, 7, 84, 18, -9 },
			 { -7, 10, 79, 7, 55, -8, -1 },
			 { -1, -9, 50, 7, 82, 14, -8 } } },
	.ver_phase_arr = {
		.even = { { -10, 31, 86, 7, 31, -10, 0 },
			 { -5, 0, 72, 7, 68, -3, -4 },
			 { 0, -10, 36, 7, 86, 26, -10 },
			 { -6, 3, 76, 7, 63, -5, -3 },
			 { 0, -10, 41, 7, 85, 21, -9 },
			 { -7, 7, 78, 7, 59, -7, -2 },
			 { 0, -10, 46, 7, 84, 17, -9 },
			 { -8, 11, 80, 7, 54, -8, -1 },
			 { -1, -9, 51, 7, 82, 13, -8 },
			 { -9, 15, 83, 7, 49, -9, -1 },
			 { -2, -8, 56, 7, 80, 9, -7 },
			 { -9, 19, 85, 7, 43, -10, 0 },
			 { -3, -6, 61, 7, 77, 5, -6 },
			 { -10, 24, 86, 7, 38, -10, 0 },
			 { -3, -4, 66, 7, 72, 2, -5 },
			 { -10, 29, 86, 7, 33, -10, 0 },
			 { -4, -1, 68, 7, 70, -1, -4 },
			 { 0, -10, 33, 7, 86, 29, -10 },
			 { -5, 2, 72, 7, 66, -4, -3 },
			 { 0, -10, 38, 7, 86, 24, -10 },
			 { -6, 5, 77, 7, 61, -6, -3 },
			 { 0, -10, 43, 7, 85, 19, -9 },
			 { -7, 9, 80, 7, 56, -8, -2 },
			 { -1, -9, 49, 7, 83, 15, -9 },
			 { -8, 13, 82, 7, 51, -9, -1 },
			 { -1, -8, 54, 7, 80, 11, -8 },
			 { -9, 17, 84, 7, 46, -10, 0 },
			 { -2, -7, 59, 7, 78, 7, -7 },
			 { -9, 21, 85, 7, 41, -10, 0 },
			 { -3, -5, 63, 7, 76, 3, -6 },
			 { -10, 26, 86, 7, 36, -10, 0 },
			 { -4, -3, 68, 7, 72, 0, -5 } },
		.odd = { { -8, 14, 82, 7, 50, -9, -1 },
			 { -1, -8, 55, 7, 79, 10, -7 },
			 { -9, 18, 84, 7, 45, -10, 0 },
			 { -2, -6, 60, 7, 77, 6, -7 },
			 { -10, 23, 85, 7, 40, -10, 0 },
			 { -3, -4, 64, 7, 75, 2, -6 },
			 { -10, 27, 86, 7, 35, -10, 0 },
			 { -4, -2, 69, 7, 71, -1, -5 },
			 { 0, -10, 32, 7, 86, 30, -10 },
			 { -5, 1, 72, 7, 67, -3, -4 },
			 { 0, -10, 37, 7, 86, 25, -10 },
			 { -6, 4, 77, 7, 62, -6, -3 },
			 { 0, -10, 42, 7, 85, 20, -9 },
			 { -7, 8, 79, 7, 57, -7, -2 },
			 { -1, -9, 47, 7, 84, 16, -9 },
			 { -8, 12, 81, 7, 52, -8, -1 },
			 { -1, -8, 52, 7, 81, 12, -8 },
			 { -9, 16, 84, 7, 47, -9, -1 },
			 { -2, -7, 57, 7, 79, 8, -7 },
			 { -9, 20, 85, 7, 42, -10, 0 },
			 { -3, -6, 62, 7, 77, 4, -6 },
			 { -10, 25, 86, 7, 37, -10, 0 },
			 { -4, -3, 67, 7, 72, 1, -5 },
			 { -10, 30, 86, 7, 32, -10, 0 },
			 { -5, -1, 71, 7, 69, -2, -4 },
			 { 0, -10, 35, 7, 86, 27, -10 },
			 { -6, 2, 75, 7, 64, -4, -3 },
			 { 0, -10, 40, 7, 85, 23, -10 },
			 { -7, 6, 77, 7, 60, -6, -2 },
			 { 0, -10, 45, 7, 84, 18, -9 },
			 { -7, 10, 79, 7, 55, -8, -1 },
			 { -1, -9, 50, 7, 82, 14, -8 } } },
	.ptrn_arr = { { 0x3cf9e79f, 0x9e79f3cf, 0xf3cf3e7 } },
	.sample_patrn_length = 94,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 16) = 0.666667 */
	.hor_phase_arr = {
		.even = { { -10, 32, 84, 7, 32, -10, 0 },
			 { -5, 0, 69, 7, 69, 0, -5 } },
		.odd = { { -9, 14, 82, 7, 51, -8, -2 },
			 { -2, -8, 51, 7, 82, 14, -9 } } },
	.ver_phase_arr = {
		.even = { { -10, 32, 84, 7, 32, -10, 0 },
			 { -5, 0, 69, 7, 69, 0, -5 } },
		.odd = { { -9, 14, 82, 7, 51, -8, -2 },
			 { -2, -8, 51, 7, 82, 14, -9 } } },
	.ptrn_arr = { { 0xf } },
	.sample_patrn_length = 6,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 17) = 0.653061 */
	.hor_phase_arr = {
		.even = { { -10, 33, 82, 7, 33, -10, 0 },
			 { -5, 0, 66, 7, 70, 3, -6 },
			 { -10, 28, 82, 7, 37, -9, 0 },
			 { -4, -3, 62, 7, 74, 6, -7 },
			 { -10, 24, 82, 7, 42, -9, -1 },
			 { -3, -5, 58, 7, 76, 10, -8 },
			 { -9, 20, 79, 7, 47, -8, -1 },
			 { -3, -6, 54, 7, 78, 14, -9 },
			 { -9, 16, 79, 7, 51, -7, -2 },
			 { -2, -8, 49, 7, 80, 18, -9 },
			 { -8, 12, 77, 7, 56, -6, -3 },
			 { -1, -9, 44, 7, 81, 22, -9 },
			 { -7, 8, 75, 7, 60, -4, -4 },
			 { -1, -9, 40, 7, 82, 26, -10 },
			 { -7, 5, 71, 7, 65, -1, -5 },
			 { 0, -10, 35, 7, 83, 30, -10 },
			 { -6, 1, 70, 7, 68, 1, -6 },
			 { -10, 30, 83, 7, 35, -10, 0 },
			 { -5, -1, 65, 7, 71, 5, -7 },
			 { -10, 26, 82, 7, 40, -9, -1 },
			 { -4, -4, 60, 7, 75, 8, -7 },
			 { -9, 22, 81, 7, 44, -9, -1 },
			 { -3, -6, 56, 7, 77, 12, -8 },
			 { -9, 18, 80, 7, 49, -8, -2 },
			 { -2, -7, 51, 7, 79, 16, -9 },
			 { -9, 14, 78, 7, 54, -6, -3 },
			 { -1, -8, 47, 7, 79, 20, -9 },
			 { -8, 10, 76, 7, 58, -5, -3 },
			 { -1, -9, 42, 7, 82, 24, -10 },
			 { -7, 6, 74, 7, 62, -3, -4 },
			 { 0, -9, 37, 7, 82, 28, -10 },
			 { -6, 3, 70, 7, 66, 0, -5 } },
		.odd = { { -9, 15, 79, 7, 52, -7, -2 },
			 { -2, -8, 48, 7, 80, 19, -9 },
			 { -8, 11, 76, 7, 57, -5, -3 },
			 { -1, -9, 43, 7, 82, 23, -10 },
			 { -7, 7, 74, 7, 61, -3, -4 },
			 { -1, -9, 38, 7, 83, 27, -10 },
			 { -6, 4, 70, 7, 66, -1, -5 },
			 { 0, -10, 34, 7, 83, 31, -10 },
			 { -6, 1, 67, 7, 70, 2, -6 },
			 { -10, 29, 83, 7, 36, -10, 0 },
			 { -5, -2, 64, 7, 73, 5, -7 },
			 { -10, 25, 82, 7, 41, -9, -1 },
			 { -4, -4, 59, 7, 76, 9, -8 },
			 { -9, 21, 80, 7, 45, -8, -1 },
			 { -3, -6, 55, 7, 77, 13, -8 },
			 { -9, 17, 79, 7, 50, -7, -2 },
			 { -2, -7, 50, 7, 79, 17, -9 },
			 { -8, 13, 77, 7, 55, -6, -3 },
			 { -1, -8, 45, 7, 80, 21, -9 },
			 { -8, 9, 76, 7, 59, -4, -4 },
			 { -1, -9, 41, 7, 82, 25, -10 },
			 { -7, 5, 73, 7, 64, -2, -5 },
			 { 0, -10, 36, 7, 83, 29, -10 },
			 { -6, 2, 70, 7, 67, 1, -6 },
			 { -10, 31, 83, 7, 34, -10, 0 },
			 { -5, -1, 66, 7, 70, 4, -6 },
			 { -10, 27, 83, 7, 38, -9, -1 },
			 { -4, -3, 61, 7, 74, 7, -7 },
			 { -10, 23, 82, 7, 43, -9, -1 },
			 { -3, -5, 57, 7, 76, 11, -8 },
			 { -9, 19, 80, 7, 48, -8, -2 },
			 { -2, -7, 52, 7, 79, 15, -9 } } },
	.ver_phase_arr = {
		.even = { { -10, 33, 82, 7, 33, -10, 0 },
			 { -5, 0, 66, 7, 70, 3, -6 },
			 { -10, 28, 82, 7, 37, -9, 0 },
			 { -4, -3, 62, 7, 74, 6, -7 },
			 { -10, 24, 82, 7, 42, -9, -1 },
			 { -3, -5, 58, 7, 76, 10, -8 },
			 { -9, 20, 79, 7, 47, -8, -1 },
			 { -3, -6, 54, 7, 78, 14, -9 },
			 { -9, 16, 79, 7, 51, -7, -2 },
			 { -2, -8, 49, 7, 80, 18, -9 },
			 { -8, 12, 77, 7, 56, -6, -3 },
			 { -1, -9, 44, 7, 81, 22, -9 },
			 { -7, 8, 75, 7, 60, -4, -4 },
			 { -1, -9, 40, 7, 82, 26, -10 },
			 { -7, 5, 71, 7, 65, -1, -5 },
			 { 0, -10, 35, 7, 83, 30, -10 },
			 { -6, 1, 70, 7, 68, 1, -6 },
			 { -10, 30, 83, 7, 35, -10, 0 },
			 { -5, -1, 65, 7, 71, 5, -7 },
			 { -10, 26, 82, 7, 40, -9, -1 },
			 { -4, -4, 60, 7, 75, 8, -7 },
			 { -9, 22, 81, 7, 44, -9, -1 },
			 { -3, -6, 56, 7, 77, 12, -8 },
			 { -9, 18, 80, 7, 49, -8, -2 },
			 { -2, -7, 51, 7, 79, 16, -9 },
			 { -9, 14, 78, 7, 54, -6, -3 },
			 { -1, -8, 47, 7, 79, 20, -9 },
			 { -8, 10, 76, 7, 58, -5, -3 },
			 { -1, -9, 42, 7, 82, 24, -10 },
			 { -7, 6, 74, 7, 62, -3, -4 },
			 { 0, -9, 37, 7, 82, 28, -10 },
			 { -6, 3, 70, 7, 66, 0, -5 } },
		.odd = { { -9, 15, 79, 7, 52, -7, -2 },
			 { -2, -8, 48, 7, 80, 19, -9 },
			 { -8, 11, 76, 7, 57, -5, -3 },
			 { -1, -9, 43, 7, 82, 23, -10 },
			 { -7, 7, 74, 7, 61, -3, -4 },
			 { -1, -9, 38, 7, 83, 27, -10 },
			 { -6, 4, 70, 7, 66, -1, -5 },
			 { 0, -10, 34, 7, 83, 31, -10 },
			 { -6, 1, 67, 7, 70, 2, -6 },
			 { -10, 29, 83, 7, 36, -10, 0 },
			 { -5, -2, 64, 7, 73, 5, -7 },
			 { -10, 25, 82, 7, 41, -9, -1 },
			 { -4, -4, 59, 7, 76, 9, -8 },
			 { -9, 21, 80, 7, 45, -8, -1 },
			 { -3, -6, 55, 7, 77, 13, -8 },
			 { -9, 17, 79, 7, 50, -7, -2 },
			 { -2, -7, 50, 7, 79, 17, -9 },
			 { -8, 13, 77, 7, 55, -6, -3 },
			 { -1, -8, 45, 7, 80, 21, -9 },
			 { -8, 9, 76, 7, 59, -4, -4 },
			 { -1, -9, 41, 7, 82, 25, -10 },
			 { -7, 5, 73, 7, 64, -2, -5 },
			 { 0, -10, 36, 7, 83, 29, -10 },
			 { -6, 2, 70, 7, 67, 1, -6 },
			 { -10, 31, 83, 7, 34, -10, 0 },
			 { -5, -1, 66, 7, 70, 4, -6 },
			 { -10, 27, 83, 7, 38, -9, -1 },
			 { -4, -3, 61, 7, 74, 7, -7 },
			 { -10, 23, 82, 7, 43, -9, -1 },
			 { -3, -5, 57, 7, 76, 11, -8 },
			 { -9, 19, 80, 7, 48, -8, -2 },
			 { -2, -7, 52, 7, 79, 15, -9 } } },
	.ptrn_arr = { { 0xe73cf3cf, 0x3cf39e79, 0xe79e79cf } },
	.sample_patrn_length = 98,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 18) = 0.64 */
	.hor_phase_arr = {
		.even = { { -9, 33, 80, 7, 33, -9, 0 },
			 { -6, 0, 64, 7, 71, 6, -7 },
			 { -10, 25, 80, 7, 42, -8, -1 },
			 { -4, -4, 56, 7, 76, 13, -9 },
			 { -9, 17, 78, 7, 51, -6, -3 },
			 { -2, -7, 47, 7, 78, 21, -9 },
			 { -8, 9, 74, 7, 60, -2, -5 },
			 { -1, -9, 38, 7, 81, 29, -10 },
			 { -6, 3, 66, 7, 68, 3, -6 },
			 { -10, 29, 81, 7, 38, -9, -1 },
			 { -5, -2, 60, 7, 74, 9, -8 },
			 { -9, 21, 78, 7, 47, -7, -2 },
			 { -3, -6, 51, 7, 78, 17, -9 },
			 { -9, 13, 76, 7, 56, -4, -4 },
			 { -1, -8, 42, 7, 80, 25, -10 },
			 { -7, 6, 71, 7, 64, 0, -6 } },
		.odd = { { -9, 15, 76, 7, 54, -5, -3 },
			 { -2, -8, 45, 7, 80, 23, -10 },
			 { -8, 8, 72, 7, 62, -1, -5 },
			 { -1, -9, 36, 7, 80, 31, -9 },
			 { -6, 1, 66, 7, 70, 4, -7 },
			 { -10, 27, 81, 7, 40, -9, -1 },
			 { -4, -4, 58, 7, 75, 11, -8 },
			 { -9, 19, 78, 7, 49, -7, -2 },
			 { -2, -7, 49, 7, 78, 19, -9 },
			 { -8, 11, 75, 7, 58, -4, -4 },
			 { -1, -9, 40, 7, 81, 27, -10 },
			 { -7, 4, 70, 7, 66, 1, -6 },
			 { -9, 31, 80, 7, 36, -9, -1 },
			 { -5, -1, 62, 7, 72, 8, -8 },
			 { -10, 23, 80, 7, 45, -8, -2 },
			 { -3, -5, 54, 7, 76, 15, -9 } } },
	.ver_phase_arr = {
		.even = { { -9, 33, 80, 7, 33, -9, 0 },
			 { -6, 0, 64, 7, 71, 6, -7 },
			 { -10, 25, 80, 7, 42, -8, -1 },
			 { -4, -4, 56, 7, 76, 13, -9 },
			 { -9, 17, 78, 7, 51, -6, -3 },
			 { -2, -7, 47, 7, 78, 21, -9 },
			 { -8, 9, 74, 7, 60, -2, -5 },
			 { -1, -9, 38, 7, 81, 29, -10 },
			 { -6, 3, 66, 7, 68, 3, -6 },
			 { -10, 29, 81, 7, 38, -9, -1 },
			 { -5, -2, 60, 7, 74, 9, -8 },
			 { -9, 21, 78, 7, 47, -7, -2 },
			 { -3, -6, 51, 7, 78, 17, -9 },
			 { -9, 13, 76, 7, 56, -4, -4 },
			 { -1, -8, 42, 7, 80, 25, -10 },
			 { -7, 6, 71, 7, 64, 0, -6 } },
		.odd = { { -9, 15, 76, 7, 54, -5, -3 },
			 { -2, -8, 45, 7, 80, 23, -10 },
			 { -8, 8, 72, 7, 62, -1, -5 },
			 { -1, -9, 36, 7, 80, 31, -9 },
			 { -6, 1, 66, 7, 70, 4, -7 },
			 { -10, 27, 81, 7, 40, -9, -1 },
			 { -4, -4, 58, 7, 75, 11, -8 },
			 { -9, 19, 78, 7, 49, -7, -2 },
			 { -2, -7, 49, 7, 78, 19, -9 },
			 { -8, 11, 75, 7, 58, -4, -4 },
			 { -1, -9, 40, 7, 81, 27, -10 },
			 { -7, 4, 70, 7, 66, 1, -6 },
			 { -9, 31, 80, 7, 36, -9, -1 },
			 { -5, -1, 62, 7, 72, 8, -8 },
			 { -10, 23, 80, 7, 45, -8, -2 },
			 { -3, -5, 54, 7, 76, 15, -9 } } },
	.ptrn_arr = { { 0xf39e73cf, 0xe79c } },
	.sample_patrn_length = 50,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 19) = 0.627451 */
	.hor_phase_arr = {
		.even = { { -9, 34, 79, 7, 34, -9, -1 },
			 { -6, 0, 61, 7, 72, 9, -8 },
			 { -9, 22, 78, 7, 47, -7, -3 },
			 { -3, -6, 49, 7, 77, 20, -9 },
			 { -8, 11, 72, 7, 59, -1, -5 },
			 { -1, -9, 36, 7, 79, 32, -9 },
			 { -6, 1, 63, 7, 71, 7, -8 },
			 { -9, 24, 77, 7, 45, -7, -2 },
			 { -4, -5, 51, 7, 77, 18, -9 },
			 { -9, 13, 73, 7, 58, -2, -5 },
			 { -1, -8, 38, 7, 78, 30, -9 },
			 { -6, 3, 65, 7, 67, 6, -7 },
			 { -9, 26, 78, 7, 43, -8, -2 },
			 { -4, -4, 53, 7, 76, 16, -9 },
			 { -9, 14, 75, 7, 55, -3, -4 },
			 { -2, -8, 40, 7, 79, 28, -9 },
			 { -7, 4, 67, 7, 67, 4, -7 },
			 { -9, 28, 79, 7, 40, -8, -2 },
			 { -4, -3, 55, 7, 75, 14, -9 },
			 { -9, 16, 76, 7, 53, -4, -4 },
			 { -2, -8, 43, 7, 78, 26, -9 },
			 { -7, 6, 67, 7, 65, 3, -6 },
			 { -9, 30, 78, 7, 38, -8, -1 },
			 { -5, -2, 58, 7, 73, 13, -9 },
			 { -9, 18, 77, 7, 51, -5, -4 },
			 { -2, -7, 45, 7, 77, 24, -9 },
			 { -8, 7, 71, 7, 63, 1, -6 },
			 { -9, 32, 79, 7, 36, -9, -1 },
			 { -5, -1, 59, 7, 72, 11, -8 },
			 { -9, 20, 77, 7, 49, -6, -3 },
			 { -3, -7, 47, 7, 78, 22, -9 },
			 { -8, 9, 72, 7, 61, 0, -6 } },
		.odd = { { -9, 15, 76, 7, 54, -4, -4 },
			 { -2, -8, 41, 7, 79, 27, -9 },
			 { -7, 5, 68, 7, 66, 3, -7 },
			 { -9, 29, 78, 7, 39, -8, -1 },
			 { -5, -3, 56, 7, 76, 13, -9 },
			 { -9, 17, 77, 7, 52, -5, -4 },
			 { -2, -7, 44, 7, 77, 25, -9 },
			 { -7, 7, 68, 7, 64, 2, -6 },
			 { -9, 31, 79, 7, 37, -9, -1 },
			 { -5, -2, 59, 7, 72, 12, -8 },
			 { -9, 19, 77, 7, 50, -6, -3 },
			 { -3, -7, 46, 7, 78, 23, -9 },
			 { -8, 8, 71, 7, 62, 1, -6 },
			 { -9, 33, 79, 7, 35, -9, -1 },
			 { -5, -1, 60, 7, 72, 10, -8 },
			 { -9, 21, 77, 7, 48, -6, -3 },
			 { -3, -6, 48, 7, 77, 21, -9 },
			 { -8, 10, 72, 7, 60, -1, -5 },
			 { -1, -9, 35, 7, 79, 33, -9 },
			 { -6, 1, 62, 7, 71, 8, -8 },
			 { -9, 23, 78, 7, 46, -7, -3 },
			 { -3, -6, 50, 7, 77, 19, -9 },
			 { -8, 12, 72, 7, 59, -2, -5 },
			 { -1, -9, 37, 7, 79, 31, -9 },
			 { -6, 2, 64, 7, 68, 7, -7 },
			 { -9, 25, 77, 7, 44, -7, -2 },
			 { -4, -5, 52, 7, 77, 17, -9 },
			 { -9, 13, 76, 7, 56, -3, -5 },
			 { -1, -8, 39, 7, 78, 29, -9 },
			 { -7, 3, 66, 7, 68, 5, -7 },
			 { -9, 27, 79, 7, 41, -8, -2 },
			 { -4, -4, 54, 7, 76, 15, -9 } } },
	.ver_phase_arr = {
		.even = { { -9, 34, 79, 7, 34, -9, -1 },
			 { -6, 0, 61, 7, 72, 9, -8 },
			 { -9, 22, 78, 7, 47, -7, -3 },
			 { -3, -6, 49, 7, 77, 20, -9 },
			 { -8, 11, 72, 7, 59, -1, -5 },
			 { -1, -9, 36, 7, 79, 32, -9 },
			 { -6, 1, 63, 7, 71, 7, -8 },
			 { -9, 24, 77, 7, 45, -7, -2 },
			 { -4, -5, 51, 7, 77, 18, -9 },
			 { -9, 13, 73, 7, 58, -2, -5 },
			 { -1, -8, 38, 7, 78, 30, -9 },
			 { -6, 3, 65, 7, 67, 6, -7 },
			 { -9, 26, 78, 7, 43, -8, -2 },
			 { -4, -4, 53, 7, 76, 16, -9 },
			 { -9, 14, 75, 7, 55, -3, -4 },
			 { -2, -8, 40, 7, 79, 28, -9 },
			 { -7, 4, 67, 7, 67, 4, -7 },
			 { -9, 28, 79, 7, 40, -8, -2 },
			 { -4, -3, 55, 7, 75, 14, -9 },
			 { -9, 16, 76, 7, 53, -4, -4 },
			 { -2, -8, 43, 7, 78, 26, -9 },
			 { -7, 6, 67, 7, 65, 3, -6 },
			 { -9, 30, 78, 7, 38, -8, -1 },
			 { -5, -2, 58, 7, 73, 13, -9 },
			 { -9, 18, 77, 7, 51, -5, -4 },
			 { -2, -7, 45, 7, 77, 24, -9 },
			 { -8, 7, 71, 7, 63, 1, -6 },
			 { -9, 32, 79, 7, 36, -9, -1 },
			 { -5, -1, 59, 7, 72, 11, -8 },
			 { -9, 20, 77, 7, 49, -6, -3 },
			 { -3, -7, 47, 7, 78, 22, -9 },
			 { -8, 9, 72, 7, 61, 0, -6 } },
		.odd = { { -9, 15, 76, 7, 54, -4, -4 },
			 { -2, -8, 41, 7, 79, 27, -9 },
			 { -7, 5, 68, 7, 66, 3, -7 },
			 { -9, 29, 78, 7, 39, -8, -1 },
			 { -5, -3, 56, 7, 76, 13, -9 },
			 { -9, 17, 77, 7, 52, -5, -4 },
			 { -2, -7, 44, 7, 77, 25, -9 },
			 { -7, 7, 68, 7, 64, 2, -6 },
			 { -9, 31, 79, 7, 37, -9, -1 },
			 { -5, -2, 59, 7, 72, 12, -8 },
			 { -9, 19, 77, 7, 50, -6, -3 },
			 { -3, -7, 46, 7, 78, 23, -9 },
			 { -8, 8, 71, 7, 62, 1, -6 },
			 { -9, 33, 79, 7, 35, -9, -1 },
			 { -5, -1, 60, 7, 72, 10, -8 },
			 { -9, 21, 77, 7, 48, -6, -3 },
			 { -3, -6, 48, 7, 77, 21, -9 },
			 { -8, 10, 72, 7, 60, -1, -5 },
			 { -1, -9, 35, 7, 79, 33, -9 },
			 { -6, 1, 62, 7, 71, 8, -8 },
			 { -9, 23, 78, 7, 46, -7, -3 },
			 { -3, -6, 50, 7, 77, 19, -9 },
			 { -8, 12, 72, 7, 59, -2, -5 },
			 { -1, -9, 37, 7, 79, 31, -9 },
			 { -6, 2, 64, 7, 68, 7, -7 },
			 { -9, 25, 77, 7, 44, -7, -2 },
			 { -4, -5, 52, 7, 77, 17, -9 },
			 { -9, 13, 76, 7, 56, -3, -5 },
			 { -1, -8, 39, 7, 78, 29, -9 },
			 { -7, 3, 66, 7, 68, 5, -7 },
			 { -9, 27, 79, 7, 41, -8, -2 },
			 { -4, -4, 54, 7, 76, 15, -9 } } },
	.ptrn_arr = { { 0x79ce79cf, 0x73ce79ce, 0x73ce73ce, 0xe } },
	.sample_patrn_length = 102,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 20) = 0.615385 */
	.hor_phase_arr = {
		.even = { { -8, 34, 77, 7, 34, -8, -1 },
			 { -6, 0, 59, 7, 71, 12, -8 },
			 { -9, 19, 75, 7, 51, -4, -4 },
			 { -3, -7, 43, 7, 77, 27, -9 },
			 { -7, 6, 64, 7, 66, 6, -7 },
			 { -9, 27, 77, 7, 43, -7, -3 },
			 { -4, -4, 51, 7, 75, 19, -9 },
			 { -8, 12, 71, 7, 59, 0, -6 } },
		.odd = { { -9, 16, 73, 7, 55, -2, -5 },
			 { -2, -8, 39, 7, 77, 31, -9 },
			 { -7, 3, 63, 7, 68, 9, -8 },
			 { -9, 23, 76, 7, 47, -6, -3 },
			 { -3, -6, 47, 7, 76, 23, -9 },
			 { -8, 9, 68, 7, 63, 3, -7 },
			 { -9, 31, 77, 7, 39, -8, -2 },
			 { -5, -2, 55, 7, 73, 16, -9 } } },
	.ver_phase_arr = {
		.even = { { -8, 34, 77, 7, 34, -8, -1 },
			 { -6, 0, 59, 7, 71, 12, -8 },
			 { -9, 19, 75, 7, 51, -4, -4 },
			 { -3, -7, 43, 7, 77, 27, -9 },
			 { -7, 6, 64, 7, 66, 6, -7 },
			 { -9, 27, 77, 7, 43, -7, -3 },
			 { -4, -4, 51, 7, 75, 19, -9 },
			 { -8, 12, 71, 7, 59, 0, -6 } },
		.odd = { { -9, 16, 73, 7, 55, -2, -5 },
			 { -2, -8, 39, 7, 77, 31, -9 },
			 { -7, 3, 63, 7, 68, 9, -8 },
			 { -9, 23, 76, 7, 47, -6, -3 },
			 { -3, -6, 47, 7, 76, 23, -9 },
			 { -8, 9, 68, 7, 63, 3, -7 },
			 { -9, 31, 77, 7, 39, -8, -2 },
			 { -5, -2, 55, 7, 73, 16, -9 } } },
	.ptrn_arr = { { 0xe739cf } },
	.sample_patrn_length = 26,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 21) = 0.603774 */
	.hor_phase_arr = {
		.even = { { -8, 35, 76, 7, 35, -8, -2 },
			 { -6, 0, 57, 7, 71, 15, -9 },
			 { -9, 17, 71, 7, 55, -1, -5 },
			 { -2, -8, 37, 7, 76, 33, -8 },
			 { -6, 1, 58, 7, 71, 13, -9 },
			 { -9, 18, 73, 7, 53, -2, -5 },
			 { -2, -7, 39, 7, 75, 31, -8 },
			 { -7, 2, 60, 7, 69, 12, -8 },
			 { -9, 20, 74, 7, 51, -3, -5 },
			 { -3, -7, 41, 7, 77, 29, -9 },
			 { -7, 4, 62, 7, 67, 10, -8 },
			 { -9, 22, 74, 7, 49, -4, -4 },
			 { -3, -6, 43, 7, 75, 28, -9 },
			 { -7, 5, 63, 7, 67, 8, -8 },
			 { -9, 24, 75, 7, 47, -5, -4 },
			 { -4, -5, 45, 7, 75, 26, -9 },
			 { -8, 7, 65, 7, 65, 7, -8 },
			 { -9, 26, 75, 7, 45, -5, -4 },
			 { -4, -5, 47, 7, 75, 24, -9 },
			 { -8, 8, 67, 7, 63, 5, -7 },
			 { -9, 28, 75, 7, 43, -6, -3 },
			 { -4, -4, 49, 7, 74, 22, -9 },
			 { -8, 10, 67, 7, 62, 4, -7 },
			 { -9, 29, 77, 7, 41, -7, -3 },
			 { -5, -3, 51, 7, 74, 20, -9 },
			 { -8, 12, 69, 7, 60, 2, -7 },
			 { -8, 31, 75, 7, 39, -7, -2 },
			 { -5, -2, 53, 7, 73, 18, -9 },
			 { -9, 13, 71, 7, 58, 1, -6 },
			 { -8, 33, 76, 7, 37, -8, -2 },
			 { -5, -1, 55, 7, 71, 17, -9 },
			 { -9, 15, 71, 7, 57, 0, -6 } },
		.odd = { { -9, 16, 72, 7, 56, -1, -6 },
			 { -2, -8, 36, 7, 76, 34, -8 },
			 { -6, 1, 58, 7, 70, 14, -9 },
			 { -9, 18, 72, 7, 54, -2, -5 },
			 { -2, -7, 38, 7, 75, 32, -8 },
			 { -6, 2, 59, 7, 70, 12, -9 },
			 { -9, 19, 74, 7, 52, -3, -5 },
			 { -3, -7, 40, 7, 77, 30, -9 },
			 { -7, 3, 61, 7, 68, 11, -8 },
			 { -9, 21, 75, 7, 50, -4, -5 },
			 { -3, -6, 42, 7, 75, 29, -9 },
			 { -7, 5, 63, 7, 66, 9, -8 },
			 { -9, 23, 74, 7, 48, -4, -4 },
			 { -3, -6, 44, 7, 75, 27, -9 },
			 { -7, 6, 64, 7, 65, 8, -8 },
			 { -9, 25, 75, 7, 46, -5, -4 },
			 { -4, -5, 46, 7, 75, 25, -9 },
			 { -8, 8, 65, 7, 64, 6, -7 },
			 { -9, 27, 75, 7, 44, -6, -3 },
			 { -4, -4, 48, 7, 74, 23, -9 },
			 { -8, 9, 66, 7, 63, 5, -7 },
			 { -9, 29, 75, 7, 42, -6, -3 },
			 { -5, -4, 50, 7, 75, 21, -9 },
			 { -8, 11, 68, 7, 61, 3, -7 },
			 { -9, 30, 77, 7, 40, -7, -3 },
			 { -5, -3, 52, 7, 74, 19, -9 },
			 { -9, 12, 70, 7, 59, 2, -6 },
			 { -8, 32, 75, 7, 38, -7, -2 },
			 { -5, -2, 54, 7, 72, 18, -9 },
			 { -9, 14, 70, 7, 58, 1, -6 },
			 { -8, 34, 76, 7, 36, -8, -2 },
			 { -6, -1, 56, 7, 72, 16, -9 } } },
	.ver_phase_arr = {
		.even = { { -8, 35, 76, 7, 35, -8, -2 },
			 { -6, 0, 57, 7, 71, 15, -9 },
			 { -9, 17, 71, 7, 55, -1, -5 },
			 { -2, -8, 37, 7, 76, 33, -8 },
			 { -6, 1, 58, 7, 71, 13, -9 },
			 { -9, 18, 73, 7, 53, -2, -5 },
			 { -2, -7, 39, 7, 75, 31, -8 },
			 { -7, 2, 60, 7, 69, 12, -8 },
			 { -9, 20, 74, 7, 51, -3, -5 },
			 { -3, -7, 41, 7, 77, 29, -9 },
			 { -7, 4, 62, 7, 67, 10, -8 },
			 { -9, 22, 74, 7, 49, -4, -4 },
			 { -3, -6, 43, 7, 75, 28, -9 },
			 { -7, 5, 63, 7, 67, 8, -8 },
			 { -9, 24, 75, 7, 47, -5, -4 },
			 { -4, -5, 45, 7, 75, 26, -9 },
			 { -8, 7, 65, 7, 65, 7, -8 },
			 { -9, 26, 75, 7, 45, -5, -4 },
			 { -4, -5, 47, 7, 75, 24, -9 },
			 { -8, 8, 67, 7, 63, 5, -7 },
			 { -9, 28, 75, 7, 43, -6, -3 },
			 { -4, -4, 49, 7, 74, 22, -9 },
			 { -8, 10, 67, 7, 62, 4, -7 },
			 { -9, 29, 77, 7, 41, -7, -3 },
			 { -5, -3, 51, 7, 74, 20, -9 },
			 { -8, 12, 69, 7, 60, 2, -7 },
			 { -8, 31, 75, 7, 39, -7, -2 },
			 { -5, -2, 53, 7, 73, 18, -9 },
			 { -9, 13, 71, 7, 58, 1, -6 },
			 { -8, 33, 76, 7, 37, -8, -2 },
			 { -5, -1, 55, 7, 71, 17, -9 },
			 { -9, 15, 71, 7, 57, 0, -6 } },
		.odd = { { -9, 16, 72, 7, 56, -1, -6 },
			 { -2, -8, 36, 7, 76, 34, -8 },
			 { -6, 1, 58, 7, 70, 14, -9 },
			 { -9, 18, 72, 7, 54, -2, -5 },
			 { -2, -7, 38, 7, 75, 32, -8 },
			 { -6, 2, 59, 7, 70, 12, -9 },
			 { -9, 19, 74, 7, 52, -3, -5 },
			 { -3, -7, 40, 7, 77, 30, -9 },
			 { -7, 3, 61, 7, 68, 11, -8 },
			 { -9, 21, 75, 7, 50, -4, -5 },
			 { -3, -6, 42, 7, 75, 29, -9 },
			 { -7, 5, 63, 7, 66, 9, -8 },
			 { -9, 23, 74, 7, 48, -4, -4 },
			 { -3, -6, 44, 7, 75, 27, -9 },
			 { -7, 6, 64, 7, 65, 8, -8 },
			 { -9, 25, 75, 7, 46, -5, -4 },
			 { -4, -5, 46, 7, 75, 25, -9 },
			 { -8, 8, 65, 7, 64, 6, -7 },
			 { -9, 27, 75, 7, 44, -6, -3 },
			 { -4, -4, 48, 7, 74, 23, -9 },
			 { -8, 9, 66, 7, 63, 5, -7 },
			 { -9, 29, 75, 7, 42, -6, -3 },
			 { -5, -4, 50, 7, 75, 21, -9 },
			 { -8, 11, 68, 7, 61, 3, -7 },
			 { -9, 30, 77, 7, 40, -7, -3 },
			 { -5, -3, 52, 7, 74, 19, -9 },
			 { -9, 12, 70, 7, 59, 2, -6 },
			 { -8, 32, 75, 7, 38, -7, -2 },
			 { -5, -2, 54, 7, 72, 18, -9 },
			 { -9, 14, 70, 7, 58, 1, -6 },
			 { -8, 34, 76, 7, 36, -8, -2 },
			 { -6, -1, 56, 7, 72, 16, -9 } } },
	.ptrn_arr = { { 0x9ce739cf, 0xe739ce73, 0x39ce739c, 0xe7 } },
	.sample_patrn_length = 106,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 22) = 0.592593 */
	.hor_phase_arr = {
		.even = { { -7, 35, 74, 7, 35, -7, -2 },
			 { -6, 0, 54, 7, 71, 18, -9 },
			 { -9, 14, 70, 7, 58, 2, -7 },
			 { -8, 32, 74, 7, 39, -6, -3 },
			 { -5, -2, 51, 7, 72, 21, -9 },
			 { -8, 11, 66, 7, 61, 5, -7 },
			 { -9, 28, 75, 7, 43, -5, -4 },
			 { -4, -4, 47, 7, 73, 25, -9 },
			 { -8, 8, 64, 7, 64, 8, -8 },
			 { -9, 25, 73, 7, 47, -4, -4 },
			 { -4, -5, 43, 7, 75, 28, -9 },
			 { -7, 5, 61, 7, 66, 11, -8 },
			 { -9, 21, 72, 7, 51, -2, -5 },
			 { -3, -6, 39, 7, 74, 32, -8 },
			 { -7, 2, 58, 7, 70, 14, -9 },
			 { -9, 18, 71, 7, 54, 0, -6 } },
		.odd = { { -9, 16, 70, 7, 56, 1, -6 },
			 { -8, 34, 75, 7, 37, -7, -3 },
			 { -6, -1, 53, 7, 72, 19, -9 },
			 { -9, 13, 68, 7, 59, 4, -7 },
			 { -8, 30, 74, 7, 41, -6, -3 },
			 { -5, -3, 49, 7, 73, 23, -9 },
			 { -8, 10, 66, 7, 62, 6, -8 },
			 { -9, 27, 74, 7, 45, -5, -4 },
			 { -4, -5, 45, 7, 74, 27, -9 },
			 { -8, 6, 62, 7, 66, 10, -8 },
			 { -9, 23, 73, 7, 49, -3, -5 },
			 { -3, -6, 41, 7, 74, 30, -8 },
			 { -7, 4, 59, 7, 68, 13, -9 },
			 { -9, 19, 72, 7, 53, -1, -6 },
			 { -3, -7, 37, 7, 75, 34, -8 },
			 { -6, 1, 56, 7, 70, 16, -9 } } },
	.ver_phase_arr = {
		.even = { { -7, 35, 74, 7, 35, -7, -2 },
			 { -6, 0, 54, 7, 71, 18, -9 },
			 { -9, 14, 70, 7, 58, 2, -7 },
			 { -8, 32, 74, 7, 39, -6, -3 },
			 { -5, -2, 51, 7, 72, 21, -9 },
			 { -8, 11, 66, 7, 61, 5, -7 },
			 { -9, 28, 75, 7, 43, -5, -4 },
			 { -4, -4, 47, 7, 73, 25, -9 },
			 { -8, 8, 64, 7, 64, 8, -8 },
			 { -9, 25, 73, 7, 47, -4, -4 },
			 { -4, -5, 43, 7, 75, 28, -9 },
			 { -7, 5, 61, 7, 66, 11, -8 },
			 { -9, 21, 72, 7, 51, -2, -5 },
			 { -3, -6, 39, 7, 74, 32, -8 },
			 { -7, 2, 58, 7, 70, 14, -9 },
			 { -9, 18, 71, 7, 54, 0, -6 } },
		.odd = { { -9, 16, 70, 7, 56, 1, -6 },
			 { -8, 34, 75, 7, 37, -7, -3 },
			 { -6, -1, 53, 7, 72, 19, -9 },
			 { -9, 13, 68, 7, 59, 4, -7 },
			 { -8, 30, 74, 7, 41, -6, -3 },
			 { -5, -3, 49, 7, 73, 23, -9 },
			 { -8, 10, 66, 7, 62, 6, -8 },
			 { -9, 27, 74, 7, 45, -5, -4 },
			 { -4, -5, 45, 7, 74, 27, -9 },
			 { -8, 6, 62, 7, 66, 10, -8 },
			 { -9, 23, 73, 7, 49, -3, -5 },
			 { -3, -6, 41, 7, 74, 30, -8 },
			 { -7, 4, 59, 7, 68, 13, -9 },
			 { -9, 19, 72, 7, 53, -1, -6 },
			 { -3, -7, 37, 7, 75, 34, -8 },
			 { -6, 1, 56, 7, 70, 16, -9 } } },
	.ptrn_arr = { { 0xce739ce7, 0xce739 } },
	.sample_patrn_length = 54,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 23) = 0.581818 */
	.hor_phase_arr = {
		.even = { { -7, 36, 73, 7, 36, -7, -3 },
			 { -6, 0, 52, 7, 71, 20, -9 },
			 { -8, 12, 66, 7, 60, 6, -8 },
			 { -8, 27, 73, 7, 45, -4, -5 },
			 { -4, -4, 43, 7, 72, 29, -8 },
			 { -7, 5, 59, 7, 66, 14, -9 },
			 { -9, 19, 69, 7, 54, 1, -6 },
			 { -7, 34, 72, 7, 38, -6, -3 },
			 { -6, -1, 50, 7, 72, 22, -9 },
			 { -8, 11, 63, 7, 62, 8, -8 },
			 { -9, 26, 72, 7, 47, -3, -5 },
			 { -4, -5, 41, 7, 73, 31, -8 },
			 { -7, 4, 57, 7, 68, 15, -9 },
			 { -9, 17, 69, 7, 56, 2, -7 },
			 { -7, 32, 74, 7, 39, -6, -4 },
			 { -5, -2, 49, 7, 71, 24, -9 },
			 { -8, 9, 63, 7, 63, 9, -8 },
			 { -9, 24, 71, 7, 49, -2, -5 },
			 { -4, -6, 39, 7, 74, 32, -7 },
			 { -7, 2, 56, 7, 69, 17, -9 },
			 { -9, 15, 68, 7, 57, 4, -7 },
			 { -8, 31, 73, 7, 41, -5, -4 },
			 { -5, -3, 47, 7, 72, 26, -9 },
			 { -8, 8, 62, 7, 63, 11, -8 },
			 { -9, 22, 72, 7, 50, -1, -6 },
			 { -3, -6, 38, 7, 72, 34, -7 },
			 { -6, 1, 54, 7, 69, 19, -9 },
			 { -9, 14, 66, 7, 59, 5, -7 },
			 { -8, 29, 72, 7, 43, -4, -4 },
			 { -5, -4, 45, 7, 73, 27, -8 },
			 { -8, 6, 60, 7, 66, 12, -8 },
			 { -9, 20, 71, 7, 52, 0, -6 } },
		.odd = { { -9, 16, 69, 7, 56, 3, -7 },
			 { -8, 31, 74, 7, 40, -5, -4 },
			 { -5, -2, 48, 7, 71, 25, -9 },
			 { -8, 8, 62, 7, 64, 10, -8 },
			 { -9, 23, 72, 7, 50, -2, -6 },
			 { -3, -6, 39, 7, 72, 33, -7 },
			 { -7, 2, 55, 7, 69, 18, -9 },
			 { -9, 15, 67, 7, 58, 4, -7 },
			 { -8, 30, 73, 7, 42, -5, -4 },
			 { -5, -3, 46, 7, 72, 26, -8 },
			 { -8, 7, 61, 7, 65, 11, -8 },
			 { -9, 21, 72, 7, 51, -1, -6 },
			 { -3, -6, 37, 7, 72, 35, -7 },
			 { -6, 1, 53, 7, 69, 20, -9 },
			 { -9, 13, 66, 7, 59, 6, -7 },
			 { -8, 28, 72, 7, 44, -4, -4 },
			 { -4, -4, 44, 7, 72, 28, -8 },
			 { -7, 6, 59, 7, 66, 13, -9 },
			 { -9, 20, 69, 7, 53, 1, -6 },
			 { -7, 35, 72, 7, 37, -6, -3 },
			 { -6, -1, 51, 7, 72, 21, -9 },
			 { -8, 11, 65, 7, 61, 7, -8 },
			 { -8, 26, 72, 7, 46, -3, -5 },
			 { -4, -5, 42, 7, 73, 30, -8 },
			 { -7, 4, 58, 7, 67, 15, -9 },
			 { -9, 18, 69, 7, 55, 2, -7 },
			 { -7, 33, 72, 7, 39, -6, -3 },
			 { -6, -2, 50, 7, 72, 23, -9 },
			 { -8, 10, 64, 7, 62, 8, -8 },
			 { -9, 25, 71, 7, 48, -2, -5 },
			 { -4, -5, 40, 7, 74, 31, -8 },
			 { -7, 3, 56, 7, 69, 16, -9 } } },
	.ver_phase_arr = {
		.even = { { -7, 36, 73, 7, 36, -7, -3 },
			 { -6, 0, 52, 7, 71, 20, -9 },
			 { -8, 12, 66, 7, 60, 6, -8 },
			 { -8, 27, 73, 7, 45, -4, -5 },
			 { -4, -4, 43, 7, 72, 29, -8 },
			 { -7, 5, 59, 7, 66, 14, -9 },
			 { -9, 19, 69, 7, 54, 1, -6 },
			 { -7, 34, 72, 7, 38, -6, -3 },
			 { -6, -1, 50, 7, 72, 22, -9 },
			 { -8, 11, 63, 7, 62, 8, -8 },
			 { -9, 26, 72, 7, 47, -3, -5 },
			 { -4, -5, 41, 7, 73, 31, -8 },
			 { -7, 4, 57, 7, 68, 15, -9 },
			 { -9, 17, 69, 7, 56, 2, -7 },
			 { -7, 32, 74, 7, 39, -6, -4 },
			 { -5, -2, 49, 7, 71, 24, -9 },
			 { -8, 9, 63, 7, 63, 9, -8 },
			 { -9, 24, 71, 7, 49, -2, -5 },
			 { -4, -6, 39, 7, 74, 32, -7 },
			 { -7, 2, 56, 7, 69, 17, -9 },
			 { -9, 15, 68, 7, 57, 4, -7 },
			 { -8, 31, 73, 7, 41, -5, -4 },
			 { -5, -3, 47, 7, 72, 26, -9 },
			 { -8, 8, 62, 7, 63, 11, -8 },
			 { -9, 22, 72, 7, 50, -1, -6 },
			 { -3, -6, 38, 7, 72, 34, -7 },
			 { -6, 1, 54, 7, 69, 19, -9 },
			 { -9, 14, 66, 7, 59, 5, -7 },
			 { -8, 29, 72, 7, 43, -4, -4 },
			 { -5, -4, 45, 7, 73, 27, -8 },
			 { -8, 6, 60, 7, 66, 12, -8 },
			 { -9, 20, 71, 7, 52, 0, -6 } },
		.odd = { { -9, 16, 69, 7, 56, 3, -7 },
			 { -8, 31, 74, 7, 40, -5, -4 },
			 { -5, -2, 48, 7, 71, 25, -9 },
			 { -8, 8, 62, 7, 64, 10, -8 },
			 { -9, 23, 72, 7, 50, -2, -6 },
			 { -3, -6, 39, 7, 72, 33, -7 },
			 { -7, 2, 55, 7, 69, 18, -9 },
			 { -9, 15, 67, 7, 58, 4, -7 },
			 { -8, 30, 73, 7, 42, -5, -4 },
			 { -5, -3, 46, 7, 72, 26, -8 },
			 { -8, 7, 61, 7, 65, 11, -8 },
			 { -9, 21, 72, 7, 51, -1, -6 },
			 { -3, -6, 37, 7, 72, 35, -7 },
			 { -6, 1, 53, 7, 69, 20, -9 },
			 { -9, 13, 66, 7, 59, 6, -7 },
			 { -8, 28, 72, 7, 44, -4, -4 },
			 { -4, -4, 44, 7, 72, 28, -8 },
			 { -7, 6, 59, 7, 66, 13, -9 },
			 { -9, 20, 69, 7, 53, 1, -6 },
			 { -7, 35, 72, 7, 37, -6, -3 },
			 { -6, -1, 51, 7, 72, 21, -9 },
			 { -8, 11, 65, 7, 61, 7, -8 },
			 { -8, 26, 72, 7, 46, -3, -5 },
			 { -4, -5, 42, 7, 73, 30, -8 },
			 { -7, 4, 58, 7, 67, 15, -9 },
			 { -9, 18, 69, 7, 55, 2, -7 },
			 { -7, 33, 72, 7, 39, -6, -3 },
			 { -6, -2, 50, 7, 72, 23, -9 },
			 { -8, 10, 64, 7, 62, 8, -8 },
			 { -9, 25, 71, 7, 48, -2, -5 },
			 { -4, -5, 40, 7, 74, 31, -8 },
			 { -7, 3, 56, 7, 69, 16, -9 } } },
	.ptrn_arr = { { 0xe7339ce7, 0x9ce7339c, 0x399ce739, 0xce7 } },
	.sample_patrn_length = 110,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 24) = 0.571429 */
	.hor_phase_arr = {
		.even = { { -6, 36, 71, 7, 36, -6, -3 },
			 { -6, 0, 50, 7, 69, 23, -8 },
			 { -8, 10, 62, 7, 62, 10, -8 },
			 { -8, 23, 69, 7, 50, 0, -6 } },
		.odd = { { -9, 16, 67, 7, 56, 5, -7 },
			 { -8, 29, 73, 7, 43, -4, -5 },
			 { -5, -4, 43, 7, 73, 29, -8 },
			 { -7, 5, 56, 7, 67, 16, -9 } } },
	.ver_phase_arr = {
		.even = { { -6, 36, 71, 7, 36, -6, -3 },
			 { -6, 0, 50, 7, 69, 23, -8 },
			 { -8, 10, 62, 7, 62, 10, -8 },
			 { -8, 23, 69, 7, 50, 0, -6 } },
		.odd = { { -9, 16, 67, 7, 56, 5, -7 },
			 { -8, 29, 73, 7, 43, -4, -5 },
			 { -5, -4, 43, 7, 73, 29, -8 },
			 { -7, 5, 56, 7, 67, 16, -9 } } },
	.ptrn_arr = { { 0xce7 } },
	.sample_patrn_length = 14,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 25) = 0.561404 */
	.hor_phase_arr = {
		.even = { { -5, 36, 70, 7, 36, -5, -4 },
			 { -6, 0, 48, 7, 69, 25, -8 },
			 { -8, 8, 59, 7, 63, 14, -8 },
			 { -8, 19, 66, 7, 54, 4, -7 },
			 { -7, 30, 70, 7, 43, -3, -5 },
			 { -5, -3, 41, 7, 70, 32, -7 },
			 { -7, 3, 53, 7, 67, 20, -8 },
			 { -8, 13, 61, 7, 60, 10, -8 },
			 { -8, 24, 67, 7, 50, 1, -6 },
			 { -6, 35, 70, 7, 38, -5, -4 },
			 { -6, -1, 46, 7, 70, 27, -8 },
			 { -8, 7, 57, 7, 64, 16, -8 },
			 { -8, 17, 64, 7, 56, 6, -7 },
			 { -7, 28, 69, 7, 45, -2, -5 },
			 { -4, -4, 40, 7, 69, 33, -6 },
			 { -7, 2, 51, 7, 68, 22, -8 },
			 { -8, 11, 61, 7, 61, 11, -8 },
			 { -8, 22, 68, 7, 51, 2, -7 },
			 { -6, 33, 69, 7, 40, -4, -4 },
			 { -5, -2, 45, 7, 69, 28, -7 },
			 { -7, 6, 56, 7, 64, 17, -8 },
			 { -8, 16, 64, 7, 57, 7, -8 },
			 { -8, 27, 70, 7, 46, -1, -6 },
			 { -4, -5, 38, 7, 70, 35, -6 },
			 { -6, 1, 50, 7, 67, 24, -8 },
			 { -8, 10, 60, 7, 61, 13, -8 },
			 { -8, 20, 67, 7, 53, 3, -7 },
			 { -7, 32, 70, 7, 41, -3, -5 },
			 { -5, -3, 43, 7, 70, 30, -7 },
			 { -7, 4, 54, 7, 66, 19, -8 },
			 { -8, 14, 63, 7, 59, 8, -8 },
			 { -8, 25, 69, 7, 48, 0, -6 } },
		.odd = { { -8, 16, 66, 7, 56, 6, -8 },
			 { -8, 28, 69, 7, 46, -1, -6 },
			 { -4, -4, 39, 7, 69, 34, -6 },
			 { -7, 2, 51, 7, 67, 23, -8 },
			 { -8, 10, 60, 7, 62, 12, -8 },
			 { -8, 21, 67, 7, 52, 3, -7 },
			 { -7, 32, 71, 7, 41, -4, -5 },
			 { -5, -2, 44, 7, 69, 29, -7 },
			 { -7, 5, 55, 7, 65, 18, -8 },
			 { -8, 15, 63, 7, 58, 8, -8 },
			 { -8, 26, 69, 7, 47, 0, -6 },
			 { -4, -5, 37, 7, 71, 35, -6 },
			 { -6, 1, 49, 7, 68, 24, -8 },
			 { -8, 9, 59, 7, 63, 13, -8 },
			 { -8, 20, 65, 7, 54, 4, -7 },
			 { -7, 31, 70, 7, 42, -3, -5 },
			 { -5, -3, 42, 7, 70, 31, -7 },
			 { -7, 4, 54, 7, 65, 20, -8 },
			 { -8, 13, 63, 7, 59, 9, -8 },
			 { -8, 24, 68, 7, 49, 1, -6 },
			 { -6, 35, 71, 7, 37, -5, -4 },
			 { -6, 0, 47, 7, 69, 26, -8 },
			 { -8, 8, 58, 7, 63, 15, -8 },
			 { -8, 18, 65, 7, 55, 5, -7 },
			 { -7, 29, 69, 7, 44, -2, -5 },
			 { -5, -4, 41, 7, 71, 32, -7 },
			 { -7, 3, 52, 7, 67, 21, -8 },
			 { -8, 12, 62, 7, 60, 10, -8 },
			 { -8, 23, 67, 7, 51, 2, -7 },
			 { -6, 34, 69, 7, 39, -4, -4 },
			 { -6, -1, 46, 7, 69, 28, -8 },
			 { -8, 6, 56, 7, 66, 16, -8 } } },
	.ver_phase_arr = {
		.even = { { -5, 36, 70, 7, 36, -5, -4 },
			 { -6, 0, 48, 7, 69, 25, -8 },
			 { -8, 8, 59, 7, 63, 14, -8 },
			 { -8, 19, 66, 7, 54, 4, -7 },
			 { -7, 30, 70, 7, 43, -3, -5 },
			 { -5, -3, 41, 7, 70, 32, -7 },
			 { -7, 3, 53, 7, 67, 20, -8 },
			 { -8, 13, 61, 7, 60, 10, -8 },
			 { -8, 24, 67, 7, 50, 1, -6 },
			 { -6, 35, 70, 7, 38, -5, -4 },
			 { -6, -1, 46, 7, 70, 27, -8 },
			 { -8, 7, 57, 7, 64, 16, -8 },
			 { -8, 17, 64, 7, 56, 6, -7 },
			 { -7, 28, 69, 7, 45, -2, -5 },
			 { -4, -4, 40, 7, 69, 33, -6 },
			 { -7, 2, 51, 7, 68, 22, -8 },
			 { -8, 11, 61, 7, 61, 11, -8 },
			 { -8, 22, 68, 7, 51, 2, -7 },
			 { -6, 33, 69, 7, 40, -4, -4 },
			 { -5, -2, 45, 7, 69, 28, -7 },
			 { -7, 6, 56, 7, 64, 17, -8 },
			 { -8, 16, 64, 7, 57, 7, -8 },
			 { -8, 27, 70, 7, 46, -1, -6 },
			 { -4, -5, 38, 7, 70, 35, -6 },
			 { -6, 1, 50, 7, 67, 24, -8 },
			 { -8, 10, 60, 7, 61, 13, -8 },
			 { -8, 20, 67, 7, 53, 3, -7 },
			 { -7, 32, 70, 7, 41, -3, -5 },
			 { -5, -3, 43, 7, 70, 30, -7 },
			 { -7, 4, 54, 7, 66, 19, -8 },
			 { -8, 14, 63, 7, 59, 8, -8 },
			 { -8, 25, 69, 7, 48, 0, -6 } },
		.odd = { { -8, 16, 66, 7, 56, 6, -8 },
			 { -8, 28, 69, 7, 46, -1, -6 },
			 { -4, -4, 39, 7, 69, 34, -6 },
			 { -7, 2, 51, 7, 67, 23, -8 },
			 { -8, 10, 60, 7, 62, 12, -8 },
			 { -8, 21, 67, 7, 52, 3, -7 },
			 { -7, 32, 71, 7, 41, -4, -5 },
			 { -5, -2, 44, 7, 69, 29, -7 },
			 { -7, 5, 55, 7, 65, 18, -8 },
			 { -8, 15, 63, 7, 58, 8, -8 },
			 { -8, 26, 69, 7, 47, 0, -6 },
			 { -4, -5, 37, 7, 71, 35, -6 },
			 { -6, 1, 49, 7, 68, 24, -8 },
			 { -8, 9, 59, 7, 63, 13, -8 },
			 { -8, 20, 65, 7, 54, 4, -7 },
			 { -7, 31, 70, 7, 42, -3, -5 },
			 { -5, -3, 42, 7, 70, 31, -7 },
			 { -7, 4, 54, 7, 65, 20, -8 },
			 { -8, 13, 63, 7, 59, 9, -8 },
			 { -8, 24, 68, 7, 49, 1, -6 },
			 { -6, 35, 71, 7, 37, -5, -4 },
			 { -6, 0, 47, 7, 69, 26, -8 },
			 { -8, 8, 58, 7, 63, 15, -8 },
			 { -8, 18, 65, 7, 55, 5, -7 },
			 { -7, 29, 69, 7, 44, -2, -5 },
			 { -5, -4, 41, 7, 71, 32, -7 },
			 { -7, 3, 52, 7, 67, 21, -8 },
			 { -8, 12, 62, 7, 60, 10, -8 },
			 { -8, 23, 67, 7, 51, 2, -7 },
			 { -6, 34, 69, 7, 39, -4, -4 },
			 { -6, -1, 46, 7, 69, 28, -8 },
			 { -8, 6, 56, 7, 66, 16, -8 } } },
	.ptrn_arr = { { 0x3399cce7, 0x3399cce7, 0x3399ce67, 0xce67 } },
	.sample_patrn_length = 114,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 26) = 0.551724 */
	.hor_phase_arr = {
		.even = { { -5, 36, 70, 7, 36, -5, -4 },
			 { -6, 0, 46, 7, 68, 27, -7 },
			 { -8, 7, 55, 7, 64, 18, -8 },
			 { -8, 15, 62, 7, 58, 9, -8 },
			 { -8, 24, 68, 7, 49, 2, -7 },
			 { -6, 33, 69, 7, 40, -3, -5 },
			 { -6, -2, 43, 7, 70, 30, -7 },
			 { -7, 4, 52, 7, 66, 21, -8 },
			 { -8, 12, 60, 7, 60, 12, -8 },
			 { -8, 21, 66, 7, 52, 4, -7 },
			 { -7, 30, 70, 7, 43, -2, -6 },
			 { -5, -3, 40, 7, 69, 33, -6 },
			 { -7, 2, 49, 7, 68, 24, -8 },
			 { -8, 9, 58, 7, 62, 15, -8 },
			 { -8, 18, 64, 7, 55, 7, -8 },
			 { -7, 27, 68, 7, 46, 0, -6 } },
		.odd = { { -8, 17, 63, 7, 56, 8, -8 },
			 { -8, 26, 67, 7, 48, 1, -6 },
			 { -5, 35, 69, 7, 38, -4, -5 },
			 { -6, -1, 45, 7, 68, 29, -7 },
			 { -7, 5, 54, 7, 64, 20, -8 },
			 { -8, 14, 60, 7, 59, 11, -8 },
			 { -8, 23, 66, 7, 51, 3, -7 },
			 { -6, 32, 69, 7, 41, -3, -5 },
			 { -5, -3, 41, 7, 69, 32, -6 },
			 { -7, 3, 51, 7, 66, 23, -8 },
			 { -8, 11, 59, 7, 60, 14, -8 },
			 { -8, 20, 64, 7, 54, 5, -7 },
			 { -7, 29, 68, 7, 45, -1, -6 },
			 { -5, -4, 38, 7, 69, 35, -5 },
			 { -6, 1, 48, 7, 67, 26, -8 },
			 { -8, 8, 56, 7, 63, 17, -8 } } },
	.ver_phase_arr = {
		.even = { { -5, 36, 70, 7, 36, -5, -4 },
			 { -6, 0, 46, 7, 68, 27, -7 },
			 { -8, 7, 55, 7, 64, 18, -8 },
			 { -8, 15, 62, 7, 58, 9, -8 },
			 { -8, 24, 68, 7, 49, 2, -7 },
			 { -6, 33, 69, 7, 40, -3, -5 },
			 { -6, -2, 43, 7, 70, 30, -7 },
			 { -7, 4, 52, 7, 66, 21, -8 },
			 { -8, 12, 60, 7, 60, 12, -8 },
			 { -8, 21, 66, 7, 52, 4, -7 },
			 { -7, 30, 70, 7, 43, -2, -6 },
			 { -5, -3, 40, 7, 69, 33, -6 },
			 { -7, 2, 49, 7, 68, 24, -8 },
			 { -8, 9, 58, 7, 62, 15, -8 },
			 { -8, 18, 64, 7, 55, 7, -8 },
			 { -7, 27, 68, 7, 46, 0, -6 } },
		.odd = { { -8, 17, 63, 7, 56, 8, -8 },
			 { -8, 26, 67, 7, 48, 1, -6 },
			 { -5, 35, 69, 7, 38, -4, -5 },
			 { -6, -1, 45, 7, 68, 29, -7 },
			 { -7, 5, 54, 7, 64, 20, -8 },
			 { -8, 14, 60, 7, 59, 11, -8 },
			 { -8, 23, 66, 7, 51, 3, -7 },
			 { -6, 32, 69, 7, 41, -3, -5 },
			 { -5, -3, 41, 7, 69, 32, -6 },
			 { -7, 3, 51, 7, 66, 23, -8 },
			 { -8, 11, 59, 7, 60, 14, -8 },
			 { -8, 20, 64, 7, 54, 5, -7 },
			 { -7, 29, 68, 7, 45, -1, -6 },
			 { -5, -4, 38, 7, 69, 35, -5 },
			 { -6, 1, 48, 7, 67, 26, -8 },
			 { -8, 8, 56, 7, 63, 17, -8 } } },
	.ptrn_arr = { { 0x399cce67, 0xcce673 } },
	.sample_patrn_length = 58,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 27) = 0.542373 */
	.hor_phase_arr = {
		.even = { { -4, 37, 67, 7, 37, -4, -5 },
			 { -6, 0, 44, 7, 67, 29, -6 },
			 { -7, 5, 52, 7, 64, 22, -8 },
			 { -8, 12, 58, 7, 60, 14, -8 },
			 { -8, 19, 63, 7, 54, 8, -8 },
			 { -7, 26, 67, 7, 47, 2, -7 },
			 { -5, 34, 66, 7, 40, -2, -5 },
			 { -6, -2, 41, 7, 68, 32, -5 },
			 { -7, 3, 49, 7, 65, 25, -7 },
			 { -8, 9, 56, 7, 62, 17, -8 },
			 { -8, 16, 61, 7, 57, 10, -8 },
			 { -8, 23, 66, 7, 50, 4, -7 },
			 { -6, 31, 67, 7, 43, -1, -6 },
			 { -5, -3, 38, 7, 67, 35, -4 },
			 { -6, 1, 46, 7, 66, 28, -7 },
			 { -8, 6, 53, 7, 65, 20, -8 },
			 { -8, 13, 59, 7, 59, 13, -8 },
			 { -8, 20, 65, 7, 53, 6, -8 },
			 { -7, 28, 66, 7, 46, 1, -6 },
			 { -4, 35, 67, 7, 38, -3, -5 },
			 { -6, -1, 43, 7, 67, 31, -6 },
			 { -7, 4, 50, 7, 66, 23, -8 },
			 { -8, 10, 57, 7, 61, 16, -8 },
			 { -8, 17, 62, 7, 56, 9, -8 },
			 { -7, 25, 65, 7, 49, 3, -7 },
			 { -5, 32, 68, 7, 41, -2, -6 },
			 { -5, -2, 40, 7, 66, 34, -5 },
			 { -7, 2, 47, 7, 67, 26, -7 },
			 { -8, 8, 54, 7, 63, 19, -8 },
			 { -8, 14, 60, 7, 58, 12, -8 },
			 { -8, 22, 64, 7, 52, 5, -7 },
			 { -6, 29, 67, 7, 44, 0, -6 } },
		.odd = { { -8, 17, 61, 7, 56, 10, -8 },
			 { -7, 24, 64, 7, 50, 4, -7 },
			 { -6, 31, 68, 7, 42, -1, -6 },
			 { -5, -3, 39, 7, 68, 34, -5 },
			 { -7, 1, 47, 7, 67, 27, -7 },
			 { -8, 7, 54, 7, 64, 19, -8 },
			 { -8, 14, 59, 7, 59, 12, -8 },
			 { -8, 21, 64, 7, 52, 6, -7 },
			 { -7, 28, 68, 7, 45, 0, -6 },
			 { -4, 36, 68, 7, 37, -4, -5 },
			 { -6, 0, 44, 7, 66, 30, -6 },
			 { -7, 5, 51, 7, 65, 22, -8 },
			 { -8, 11, 57, 7, 61, 15, -8 },
			 { -8, 18, 63, 7, 55, 8, -8 },
			 { -7, 25, 67, 7, 48, 2, -7 },
			 { -5, 33, 66, 7, 41, -2, -5 },
			 { -5, -2, 41, 7, 66, 33, -5 },
			 { -7, 2, 48, 7, 67, 25, -7 },
			 { -8, 8, 55, 7, 63, 18, -8 },
			 { -8, 15, 61, 7, 57, 11, -8 },
			 { -8, 22, 65, 7, 51, 5, -7 },
			 { -6, 30, 66, 7, 44, 0, -6 },
			 { -5, -4, 37, 7, 68, 36, -4 },
			 { -6, 0, 45, 7, 68, 28, -7 },
			 { -7, 6, 52, 7, 64, 21, -8 },
			 { -8, 12, 59, 7, 59, 14, -8 },
			 { -8, 19, 64, 7, 54, 7, -8 },
			 { -7, 27, 67, 7, 47, 1, -7 },
			 { -5, 34, 68, 7, 39, -3, -5 },
			 { -6, -1, 42, 7, 68, 31, -6 },
			 { -7, 4, 50, 7, 64, 24, -7 },
			 { -8, 10, 56, 7, 61, 17, -8 } } },
	.ver_phase_arr = {
		.even = { { -4, 37, 67, 7, 37, -4, -5 },
			 { -6, 0, 44, 7, 67, 29, -6 },
			 { -7, 5, 52, 7, 64, 22, -8 },
			 { -8, 12, 58, 7, 60, 14, -8 },
			 { -8, 19, 63, 7, 54, 8, -8 },
			 { -7, 26, 67, 7, 47, 2, -7 },
			 { -5, 34, 66, 7, 40, -2, -5 },
			 { -6, -2, 41, 7, 68, 32, -5 },
			 { -7, 3, 49, 7, 65, 25, -7 },
			 { -8, 9, 56, 7, 62, 17, -8 },
			 { -8, 16, 61, 7, 57, 10, -8 },
			 { -8, 23, 66, 7, 50, 4, -7 },
			 { -6, 31, 67, 7, 43, -1, -6 },
			 { -5, -3, 38, 7, 67, 35, -4 },
			 { -6, 1, 46, 7, 66, 28, -7 },
			 { -8, 6, 53, 7, 65, 20, -8 },
			 { -8, 13, 59, 7, 59, 13, -8 },
			 { -8, 20, 65, 7, 53, 6, -8 },
			 { -7, 28, 66, 7, 46, 1, -6 },
			 { -4, 35, 67, 7, 38, -3, -5 },
			 { -6, -1, 43, 7, 67, 31, -6 },
			 { -7, 4, 50, 7, 66, 23, -8 },
			 { -8, 10, 57, 7, 61, 16, -8 },
			 { -8, 17, 62, 7, 56, 9, -8 },
			 { -7, 25, 65, 7, 49, 3, -7 },
			 { -5, 32, 68, 7, 41, -2, -6 },
			 { -5, -2, 40, 7, 66, 34, -5 },
			 { -7, 2, 47, 7, 67, 26, -7 },
			 { -8, 8, 54, 7, 63, 19, -8 },
			 { -8, 14, 60, 7, 58, 12, -8 },
			 { -8, 22, 64, 7, 52, 5, -7 },
			 { -6, 29, 67, 7, 44, 0, -6 } },
		.odd = { { -8, 17, 61, 7, 56, 10, -8 },
			 { -7, 24, 64, 7, 50, 4, -7 },
			 { -6, 31, 68, 7, 42, -1, -6 },
			 { -5, -3, 39, 7, 68, 34, -5 },
			 { -7, 1, 47, 7, 67, 27, -7 },
			 { -8, 7, 54, 7, 64, 19, -8 },
			 { -8, 14, 59, 7, 59, 12, -8 },
			 { -8, 21, 64, 7, 52, 6, -7 },
			 { -7, 28, 68, 7, 45, 0, -6 },
			 { -4, 36, 68, 7, 37, -4, -5 },
			 { -6, 0, 44, 7, 66, 30, -6 },
			 { -7, 5, 51, 7, 65, 22, -8 },
			 { -8, 11, 57, 7, 61, 15, -8 },
			 { -8, 18, 63, 7, 55, 8, -8 },
			 { -7, 25, 67, 7, 48, 2, -7 },
			 { -5, 33, 66, 7, 41, -2, -5 },
			 { -5, -2, 41, 7, 66, 33, -5 },
			 { -7, 2, 48, 7, 67, 25, -7 },
			 { -8, 8, 55, 7, 63, 18, -8 },
			 { -8, 15, 61, 7, 57, 11, -8 },
			 { -8, 22, 65, 7, 51, 5, -7 },
			 { -6, 30, 66, 7, 44, 0, -6 },
			 { -5, -4, 37, 7, 68, 36, -4 },
			 { -6, 0, 45, 7, 68, 28, -7 },
			 { -7, 6, 52, 7, 64, 21, -8 },
			 { -8, 12, 59, 7, 59, 14, -8 },
			 { -8, 19, 64, 7, 54, 7, -8 },
			 { -7, 27, 67, 7, 47, 1, -7 },
			 { -5, 34, 68, 7, 39, -3, -5 },
			 { -6, -1, 42, 7, 68, 31, -6 },
			 { -7, 4, 50, 7, 64, 24, -7 },
			 { -8, 10, 56, 7, 61, 17, -8 } } },
	.ptrn_arr = { { 0x99ccce67, 0xce667339, 0x733399cc, 0xcce66 } },
	.sample_patrn_length = 118,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 28) = 0.533333 */
	.hor_phase_arr = {
		.even = { { -3, 37, 65, 7, 37, -3, -5 },
			 { -6, 0, 43, 7, 65, 31, -5 },
			 { -7, 4, 48, 7, 65, 25, -7 },
			 { -8, 9, 54, 7, 62, 19, -8 },
			 { -8, 14, 58, 7, 58, 14, -8 },
			 { -8, 19, 62, 7, 54, 9, -8 },
			 { -7, 25, 65, 7, 48, 4, -7 },
			 { -5, 31, 65, 7, 43, 0, -6 } },
		.odd = { { -8, 17, 60, 7, 56, 11, -8 },
			 { -7, 22, 63, 7, 51, 6, -7 },
			 { -6, 28, 65, 7, 46, 2, -7 },
			 { -4, 34, 66, 7, 40, -2, -6 },
			 { -6, -2, 40, 7, 66, 34, -4 },
			 { -7, 2, 46, 7, 65, 28, -6 },
			 { -7, 6, 51, 7, 63, 22, -7 },
			 { -8, 11, 56, 7, 60, 17, -8 } } },
	.ver_phase_arr = {
		.even = { { -3, 37, 65, 7, 37, -3, -5 },
			 { -6, 0, 43, 7, 65, 31, -5 },
			 { -7, 4, 48, 7, 65, 25, -7 },
			 { -8, 9, 54, 7, 62, 19, -8 },
			 { -8, 14, 58, 7, 58, 14, -8 },
			 { -8, 19, 62, 7, 54, 9, -8 },
			 { -7, 25, 65, 7, 48, 4, -7 },
			 { -5, 31, 65, 7, 43, 0, -6 } },
		.odd = { { -8, 17, 60, 7, 56, 11, -8 },
			 { -7, 22, 63, 7, 51, 6, -7 },
			 { -6, 28, 65, 7, 46, 2, -7 },
			 { -4, 34, 66, 7, 40, -2, -6 },
			 { -6, -2, 40, 7, 66, 34, -4 },
			 { -7, 2, 46, 7, 65, 28, -6 },
			 { -7, 6, 51, 7, 63, 22, -7 },
			 { -8, 11, 56, 7, 60, 17, -8 } } },
	.ptrn_arr = { { 0xccce667 } },
	.sample_patrn_length = 30,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 29) = 0.52459 */
	.hor_phase_arr = {
		.even = { { -2, 37, 63, 7, 37, -2, -5 },
			 { -6, 0, 41, 7, 64, 33, -4 },
			 { -7, 3, 45, 7, 65, 28, -6 },
			 { -7, 6, 49, 7, 63, 24, -7 },
			 { -8, 9, 53, 7, 61, 20, -7 },
			 { -8, 13, 56, 7, 59, 16, -8 },
			 { -8, 17, 60, 7, 55, 12, -8 },
			 { -7, 21, 62, 7, 52, 8, -8 },
			 { -6, 26, 62, 7, 48, 5, -7 },
			 { -5, 30, 64, 7, 44, 2, -7 },
			 { -4, 34, 65, 7, 40, -1, -6 },
			 { -6, -2, 38, 7, 66, 35, -3 },
			 { -6, 1, 42, 7, 65, 31, -5 },
			 { -7, 4, 47, 7, 63, 27, -6 },
			 { -7, 7, 50, 7, 62, 23, -7 },
			 { -8, 11, 54, 7, 59, 19, -7 },
			 { -8, 15, 57, 7, 57, 15, -8 },
			 { -7, 19, 59, 7, 54, 11, -8 },
			 { -7, 23, 62, 7, 50, 7, -7 },
			 { -6, 27, 63, 7, 47, 4, -7 },
			 { -5, 31, 65, 7, 42, 1, -6 },
			 { -3, 35, 66, 7, 38, -2, -6 },
			 { -6, -1, 40, 7, 65, 34, -4 },
			 { -7, 2, 44, 7, 64, 30, -5 },
			 { -7, 5, 48, 7, 62, 26, -6 },
			 { -8, 8, 52, 7, 62, 21, -7 },
			 { -8, 12, 55, 7, 60, 17, -8 },
			 { -8, 16, 59, 7, 56, 13, -8 },
			 { -7, 20, 61, 7, 53, 9, -8 },
			 { -7, 24, 63, 7, 49, 6, -7 },
			 { -6, 28, 65, 7, 45, 3, -7 },
			 { -4, 33, 64, 7, 41, 0, -6 } },
		.odd = { { -8, 17, 58, 7, 56, 13, -8 },
			 { -7, 21, 61, 7, 52, 9, -8 },
			 { -6, 25, 62, 7, 49, 5, -7 },
			 { -5, 29, 64, 7, 45, 2, -7 },
			 { -4, 33, 65, 7, 40, 0, -6 },
			 { -6, -2, 37, 7, 66, 36, -3 },
			 { -6, 0, 42, 7, 64, 32, -4 },
			 { -7, 3, 46, 7, 64, 28, -6 },
			 { -7, 7, 50, 7, 61, 24, -7 },
			 { -8, 10, 53, 7, 61, 19, -7 },
			 { -8, 14, 57, 7, 58, 15, -8 },
			 { -8, 18, 60, 7, 55, 11, -8 },
			 { -7, 22, 62, 7, 51, 8, -8 },
			 { -6, 26, 64, 7, 47, 4, -7 },
			 { -5, 31, 65, 7, 43, 1, -7 },
			 { -3, 35, 64, 7, 39, -1, -6 },
			 { -6, -1, 39, 7, 64, 35, -3 },
			 { -7, 1, 43, 7, 65, 31, -5 },
			 { -7, 4, 47, 7, 64, 26, -6 },
			 { -8, 8, 51, 7, 62, 22, -7 },
			 { -8, 11, 55, 7, 60, 18, -8 },
			 { -8, 15, 58, 7, 57, 14, -8 },
			 { -7, 19, 61, 7, 53, 10, -8 },
			 { -7, 24, 61, 7, 50, 7, -7 },
			 { -6, 28, 64, 7, 46, 3, -7 },
			 { -4, 32, 64, 7, 42, 0, -6 },
			 { -3, 36, 66, 7, 37, -2, -6 },
			 { -6, 0, 40, 7, 65, 33, -4 },
			 { -7, 2, 45, 7, 64, 29, -5 },
			 { -7, 5, 49, 7, 62, 25, -6 },
			 { -8, 9, 52, 7, 61, 21, -7 },
			 { -8, 13, 56, 7, 58, 17, -8 } } },
	.ver_phase_arr = {
		.even = { { -2, 37, 63, 7, 37, -2, -5 },
			 { -6, 0, 41, 7, 64, 33, -4 },
			 { -7, 3, 45, 7, 65, 28, -6 },
			 { -7, 6, 49, 7, 63, 24, -7 },
			 { -8, 9, 53, 7, 61, 20, -7 },
			 { -8, 13, 56, 7, 59, 16, -8 },
			 { -8, 17, 60, 7, 55, 12, -8 },
			 { -7, 21, 62, 7, 52, 8, -8 },
			 { -6, 26, 62, 7, 48, 5, -7 },
			 { -5, 30, 64, 7, 44, 2, -7 },
			 { -4, 34, 65, 7, 40, -1, -6 },
			 { -6, -2, 38, 7, 66, 35, -3 },
			 { -6, 1, 42, 7, 65, 31, -5 },
			 { -7, 4, 47, 7, 63, 27, -6 },
			 { -7, 7, 50, 7, 62, 23, -7 },
			 { -8, 11, 54, 7, 59, 19, -7 },
			 { -8, 15, 57, 7, 57, 15, -8 },
			 { -7, 19, 59, 7, 54, 11, -8 },
			 { -7, 23, 62, 7, 50, 7, -7 },
			 { -6, 27, 63, 7, 47, 4, -7 },
			 { -5, 31, 65, 7, 42, 1, -6 },
			 { -3, 35, 66, 7, 38, -2, -6 },
			 { -6, -1, 40, 7, 65, 34, -4 },
			 { -7, 2, 44, 7, 64, 30, -5 },
			 { -7, 5, 48, 7, 62, 26, -6 },
			 { -8, 8, 52, 7, 62, 21, -7 },
			 { -8, 12, 55, 7, 60, 17, -8 },
			 { -8, 16, 59, 7, 56, 13, -8 },
			 { -7, 20, 61, 7, 53, 9, -8 },
			 { -7, 24, 63, 7, 49, 6, -7 },
			 { -6, 28, 65, 7, 45, 3, -7 },
			 { -4, 33, 64, 7, 41, 0, -6 } },
		.odd = { { -8, 17, 58, 7, 56, 13, -8 },
			 { -7, 21, 61, 7, 52, 9, -8 },
			 { -6, 25, 62, 7, 49, 5, -7 },
			 { -5, 29, 64, 7, 45, 2, -7 },
			 { -4, 33, 65, 7, 40, 0, -6 },
			 { -6, -2, 37, 7, 66, 36, -3 },
			 { -6, 0, 42, 7, 64, 32, -4 },
			 { -7, 3, 46, 7, 64, 28, -6 },
			 { -7, 7, 50, 7, 61, 24, -7 },
			 { -8, 10, 53, 7, 61, 19, -7 },
			 { -8, 14, 57, 7, 58, 15, -8 },
			 { -8, 18, 60, 7, 55, 11, -8 },
			 { -7, 22, 62, 7, 51, 8, -8 },
			 { -6, 26, 64, 7, 47, 4, -7 },
			 { -5, 31, 65, 7, 43, 1, -7 },
			 { -3, 35, 64, 7, 39, -1, -6 },
			 { -6, -1, 39, 7, 64, 35, -3 },
			 { -7, 1, 43, 7, 65, 31, -5 },
			 { -7, 4, 47, 7, 64, 26, -6 },
			 { -8, 8, 51, 7, 62, 22, -7 },
			 { -8, 11, 55, 7, 60, 18, -8 },
			 { -8, 15, 58, 7, 57, 14, -8 },
			 { -7, 19, 61, 7, 53, 10, -8 },
			 { -7, 24, 61, 7, 50, 7, -7 },
			 { -6, 28, 64, 7, 46, 3, -7 },
			 { -4, 32, 64, 7, 42, 0, -6 },
			 { -3, 36, 66, 7, 37, -2, -6 },
			 { -6, 0, 40, 7, 65, 33, -4 },
			 { -7, 2, 45, 7, 64, 29, -5 },
			 { -7, 5, 49, 7, 62, 25, -6 },
			 { -8, 9, 52, 7, 61, 21, -7 },
			 { -8, 13, 56, 7, 58, 17, -8 } } },
	.ptrn_arr = { { 0xccce6667, 0x399999cc, 0x66673333, 0xcccce6 } },
	.sample_patrn_length = 122,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 30) = 0.516129 */
	.hor_phase_arr = {
		.even = { { -2, 37, 64, 7, 37, -2, -6 },
			 { -6, 0, 39, 7, 64, 34, -3 },
			 { -7, 2, 42, 7, 64, 31, -4 },
			 { -7, 4, 45, 7, 62, 29, -5 },
			 { -7, 6, 47, 7, 62, 26, -6 },
			 { -7, 8, 50, 7, 60, 23, -6 },
			 { -8, 10, 52, 7, 60, 21, -7 },
			 { -8, 13, 54, 7, 58, 18, -7 },
			 { -8, 15, 58, 7, 56, 15, -8 },
			 { -7, 18, 58, 7, 54, 13, -8 },
			 { -7, 21, 60, 7, 52, 10, -8 },
			 { -6, 23, 60, 7, 50, 8, -7 },
			 { -6, 26, 62, 7, 47, 6, -7 },
			 { -5, 29, 62, 7, 45, 4, -7 },
			 { -4, 31, 64, 7, 42, 2, -7 },
			 { -3, 34, 64, 7, 39, 0, -6 } },
		.odd = { { -7, 17, 57, 7, 55, 14, -8 },
			 { -7, 19, 59, 7, 53, 12, -8 },
			 { -7, 22, 61, 7, 51, 9, -8 },
			 { -6, 25, 60, 7, 49, 7, -7 },
			 { -5, 27, 62, 7, 46, 5, -7 },
			 { -5, 30, 63, 7, 44, 3, -7 },
			 { -3, 33, 62, 7, 41, 1, -6 },
			 { -2, 35, 64, 7, 38, -1, -6 },
			 { -6, -1, 38, 7, 64, 35, -2 },
			 { -6, 1, 41, 7, 62, 33, -3 },
			 { -7, 3, 44, 7, 63, 30, -5 },
			 { -7, 5, 46, 7, 62, 27, -5 },
			 { -7, 7, 49, 7, 60, 25, -6 },
			 { -8, 9, 51, 7, 61, 22, -7 },
			 { -8, 12, 53, 7, 59, 19, -7 },
			 { -8, 14, 55, 7, 57, 17, -7 } } },
	.ver_phase_arr = {
		.even = { { -2, 37, 64, 7, 37, -2, -6 },
			 { -6, 0, 39, 7, 64, 34, -3 },
			 { -7, 2, 42, 7, 64, 31, -4 },
			 { -7, 4, 45, 7, 62, 29, -5 },
			 { -7, 6, 47, 7, 62, 26, -6 },
			 { -7, 8, 50, 7, 60, 23, -6 },
			 { -8, 10, 52, 7, 60, 21, -7 },
			 { -8, 13, 54, 7, 58, 18, -7 },
			 { -8, 15, 58, 7, 56, 15, -8 },
			 { -7, 18, 58, 7, 54, 13, -8 },
			 { -7, 21, 60, 7, 52, 10, -8 },
			 { -6, 23, 60, 7, 50, 8, -7 },
			 { -6, 26, 62, 7, 47, 6, -7 },
			 { -5, 29, 62, 7, 45, 4, -7 },
			 { -4, 31, 64, 7, 42, 2, -7 },
			 { -3, 34, 64, 7, 39, 0, -6 } },
		.odd = { { -7, 17, 57, 7, 55, 14, -8 },
			 { -7, 19, 59, 7, 53, 12, -8 },
			 { -7, 22, 61, 7, 51, 9, -8 },
			 { -6, 25, 60, 7, 49, 7, -7 },
			 { -5, 27, 62, 7, 46, 5, -7 },
			 { -5, 30, 63, 7, 44, 3, -7 },
			 { -3, 33, 62, 7, 41, 1, -6 },
			 { -2, 35, 64, 7, 38, -1, -6 },
			 { -6, -1, 38, 7, 64, 35, -2 },
			 { -6, 1, 41, 7, 62, 33, -3 },
			 { -7, 3, 44, 7, 63, 30, -5 },
			 { -7, 5, 46, 7, 62, 27, -5 },
			 { -7, 7, 49, 7, 60, 25, -6 },
			 { -8, 9, 51, 7, 61, 22, -7 },
			 { -8, 12, 53, 7, 59, 19, -7 },
			 { -8, 14, 55, 7, 57, 17, -7 } } },
	.ptrn_arr = { { 0xe6666667, 0xccccccc } },
	.sample_patrn_length = 62,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 31) = 0.507937 */
	.hor_phase_arr = {
		.even = { { -1, 37, 62, 7, 37, -1, -6 },
			 { -6, 0, 38, 7, 62, 35, -1 },
			 { -6, 1, 39, 7, 62, 34, -2 },
			 { -7, 2, 41, 7, 62, 33, -3 },
			 { -7, 3, 42, 7, 61, 32, -3 },
			 { -7, 4, 43, 7, 62, 30, -4 },
			 { -7, 4, 44, 7, 62, 29, -4 },
			 { -7, 6, 46, 7, 60, 28, -5 },
			 { -7, 7, 47, 7, 60, 26, -5 },
			 { -7, 8, 48, 7, 60, 25, -6 },
			 { -7, 9, 49, 7, 59, 24, -6 },
			 { -7, 10, 50, 7, 59, 22, -6 },
			 { -7, 11, 51, 7, 59, 21, -7 },
			 { -7, 12, 52, 7, 58, 20, -7 },
			 { -7, 13, 53, 7, 57, 19, -7 },
			 { -7, 15, 54, 7, 56, 17, -7 },
			 { -7, 16, 55, 7, 55, 16, -7 },
			 { -7, 17, 56, 7, 54, 15, -7 },
			 { -7, 19, 57, 7, 53, 13, -7 },
			 { -7, 20, 58, 7, 52, 12, -7 },
			 { -7, 21, 59, 7, 51, 11, -7 },
			 { -6, 22, 59, 7, 50, 10, -7 },
			 { -6, 24, 59, 7, 49, 9, -7 },
			 { -6, 25, 60, 7, 48, 8, -7 },
			 { -5, 26, 60, 7, 47, 7, -7 },
			 { -5, 28, 60, 7, 46, 6, -7 },
			 { -4, 29, 62, 7, 44, 4, -7 },
			 { -4, 30, 62, 7, 43, 4, -7 },
			 { -3, 32, 61, 7, 42, 3, -7 },
			 { -3, 33, 62, 7, 41, 2, -7 },
			 { -2, 34, 62, 7, 39, 1, -6 },
			 { -1, 35, 62, 7, 38, 0, -6 } },
		.odd = { { -7, 17, 55, 7, 55, 15, -7 },
			 { -7, 18, 56, 7, 54, 14, -7 },
			 { -7, 19, 57, 7, 53, 13, -7 },
			 { -7, 20, 58, 7, 52, 12, -7 },
			 { -6, 22, 58, 7, 51, 10, -7 },
			 { -6, 23, 59, 7, 50, 9, -7 },
			 { -6, 24, 60, 7, 49, 8, -7 },
			 { -5, 26, 60, 7, 47, 7, -7 },
			 { -5, 27, 61, 7, 46, 6, -7 },
			 { -5, 28, 62, 7, 45, 5, -7 },
			 { -4, 30, 61, 7, 44, 4, -7 },
			 { -4, 31, 62, 7, 43, 3, -7 },
			 { -3, 32, 63, 7, 41, 2, -7 },
			 { -2, 34, 61, 7, 40, 1, -6 },
			 { -2, 35, 62, 7, 39, 0, -6 },
			 { -1, 36, 62, 7, 37, 0, -6 },
			 { -6, 0, 37, 7, 62, 36, -1 },
			 { -6, 0, 39, 7, 62, 35, -2 },
			 { -6, 1, 40, 7, 61, 34, -2 },
			 { -7, 2, 41, 7, 63, 32, -3 },
			 { -7, 3, 43, 7, 62, 31, -4 },
			 { -7, 4, 44, 7, 61, 30, -4 },
			 { -7, 5, 45, 7, 62, 28, -5 },
			 { -7, 6, 46, 7, 61, 27, -5 },
			 { -7, 7, 47, 7, 60, 26, -5 },
			 { -7, 8, 49, 7, 60, 24, -6 },
			 { -7, 9, 50, 7, 59, 23, -6 },
			 { -7, 10, 51, 7, 58, 22, -6 },
			 { -7, 12, 52, 7, 58, 20, -7 },
			 { -7, 13, 53, 7, 57, 19, -7 },
			 { -7, 14, 54, 7, 56, 18, -7 },
			 { -7, 15, 55, 7, 55, 17, -7 } } },
	.ver_phase_arr = {
		.even = { { -1, 37, 62, 7, 37, -1, -6 },
			 { -6, 0, 38, 7, 62, 35, -1 },
			 { -6, 1, 39, 7, 62, 34, -2 },
			 { -7, 2, 41, 7, 62, 33, -3 },
			 { -7, 3, 42, 7, 61, 32, -3 },
			 { -7, 4, 43, 7, 62, 30, -4 },
			 { -7, 4, 44, 7, 62, 29, -4 },
			 { -7, 6, 46, 7, 60, 28, -5 },
			 { -7, 7, 47, 7, 60, 26, -5 },
			 { -7, 8, 48, 7, 60, 25, -6 },
			 { -7, 9, 49, 7, 59, 24, -6 },
			 { -7, 10, 50, 7, 59, 22, -6 },
			 { -7, 11, 51, 7, 59, 21, -7 },
			 { -7, 12, 52, 7, 58, 20, -7 },
			 { -7, 13, 53, 7, 57, 19, -7 },
			 { -7, 15, 54, 7, 56, 17, -7 },
			 { -7, 16, 55, 7, 55, 16, -7 },
			 { -7, 17, 56, 7, 54, 15, -7 },
			 { -7, 19, 57, 7, 53, 13, -7 },
			 { -7, 20, 58, 7, 52, 12, -7 },
			 { -7, 21, 59, 7, 51, 11, -7 },
			 { -6, 22, 59, 7, 50, 10, -7 },
			 { -6, 24, 59, 7, 49, 9, -7 },
			 { -6, 25, 60, 7, 48, 8, -7 },
			 { -5, 26, 60, 7, 47, 7, -7 },
			 { -5, 28, 60, 7, 46, 6, -7 },
			 { -4, 29, 62, 7, 44, 4, -7 },
			 { -4, 30, 62, 7, 43, 4, -7 },
			 { -3, 32, 61, 7, 42, 3, -7 },
			 { -3, 33, 62, 7, 41, 2, -7 },
			 { -2, 34, 62, 7, 39, 1, -6 },
			 { -1, 35, 62, 7, 38, 0, -6 } },
		.odd = { { -7, 17, 55, 7, 55, 15, -7 },
			 { -7, 18, 56, 7, 54, 14, -7 },
			 { -7, 19, 57, 7, 53, 13, -7 },
			 { -7, 20, 58, 7, 52, 12, -7 },
			 { -6, 22, 58, 7, 51, 10, -7 },
			 { -6, 23, 59, 7, 50, 9, -7 },
			 { -6, 24, 60, 7, 49, 8, -7 },
			 { -5, 26, 60, 7, 47, 7, -7 },
			 { -5, 27, 61, 7, 46, 6, -7 },
			 { -5, 28, 62, 7, 45, 5, -7 },
			 { -4, 30, 61, 7, 44, 4, -7 },
			 { -4, 31, 62, 7, 43, 3, -7 },
			 { -3, 32, 63, 7, 41, 2, -7 },
			 { -2, 34, 61, 7, 40, 1, -6 },
			 { -2, 35, 62, 7, 39, 0, -6 },
			 { -1, 36, 62, 7, 37, 0, -6 },
			 { -6, 0, 37, 7, 62, 36, -1 },
			 { -6, 0, 39, 7, 62, 35, -2 },
			 { -6, 1, 40, 7, 61, 34, -2 },
			 { -7, 2, 41, 7, 63, 32, -3 },
			 { -7, 3, 43, 7, 62, 31, -4 },
			 { -7, 4, 44, 7, 61, 30, -4 },
			 { -7, 5, 45, 7, 62, 28, -5 },
			 { -7, 6, 46, 7, 61, 27, -5 },
			 { -7, 7, 47, 7, 60, 26, -5 },
			 { -7, 8, 49, 7, 60, 24, -6 },
			 { -7, 9, 50, 7, 59, 23, -6 },
			 { -7, 10, 51, 7, 58, 22, -6 },
			 { -7, 12, 52, 7, 58, 20, -7 },
			 { -7, 13, 53, 7, 57, 19, -7 },
			 { -7, 14, 54, 7, 56, 18, -7 },
			 { -7, 15, 55, 7, 55, 17, -7 } } },
	.ptrn_arr = { { 0x66666667, 0xe6666666, 0xcccccccc, 0xccccccc } },
	.sample_patrn_length = 126,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 32) = 0.5 */
	.hor_phase_arr = {
		.even = { { 0, 8, 112, 7, 8, 0, 0 } },
		.odd = { { 0, 0, 64, 7, 64, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 8, 112, 7, 8, 0, 0 } },
		.odd = { { 0, 0, 64, 7, 64, 0, 0 } } },
	.ptrn_arr = { { 0x3 } },
	.sample_patrn_length = 4,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 33) = 0.492308 */
	.hor_phase_arr = {
		.even = { { 0, 9, 110, 7, 9, 0, 0 },
			 { 0, 8, 109, 7, 11, 0, 0 },
			 { 0, 7, 109, 7, 12, 0, 0 },
			 { 0, 6, 108, 7, 14, 0, 0 },
			 { 0, 5, 107, 7, 16, 0, 0 },
			 { 0, 4, 105, 7, 19, 0, 0 },
			 { 0, 3, 103, 7, 22, 0, 0 },
			 { 0, 3, 100, 7, 25, 0, 0 },
			 { 0, 2, 98, 7, 28, 0, 0 },
			 { 0, 2, 94, 7, 32, 0, 0 },
			 { 0, 2, 90, 7, 36, 0, 0 },
			 { 0, 1, 87, 7, 40, 0, 0 },
			 { 0, 1, 83, 7, 44, 0, 0 },
			 { 0, 1, 78, 7, 49, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 },
			 { 0, 1, 68, 7, 59, 0, 0 },
			 { 0, 0, 64, 7, 64, 0, 0 },
			 { 0, 0, 59, 7, 68, 1, 0 },
			 { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 49, 7, 78, 1, 0 },
			 { 0, 0, 44, 7, 83, 1, 0 },
			 { 0, 0, 40, 7, 87, 1, 0 },
			 { 0, 0, 36, 7, 90, 2, 0 },
			 { 0, 0, 32, 7, 94, 2, 0 },
			 { 0, 0, 28, 7, 98, 2, 0 },
			 { 0, 0, 25, 7, 100, 3, 0 },
			 { 0, 0, 22, 7, 103, 3, 0 },
			 { 0, 0, 19, 7, 105, 4, 0 },
			 { 0, 0, 16, 7, 107, 5, 0 },
			 { 0, 0, 14, 7, 108, 6, 0 },
			 { 0, 0, 12, 7, 109, 7, 0 },
			 { 0, 0, 11, 7, 109, 8, 0 } },
		.odd = { { 0, 0, 61, 7, 67, 0, 0 },
			 { 0, 0, 56, 7, 71, 1, 0 },
			 { 0, 0, 51, 7, 76, 1, 0 },
			 { 0, 0, 46, 7, 81, 1, 0 },
			 { 0, 0, 42, 7, 85, 1, 0 },
			 { 0, 0, 38, 7, 89, 1, 0 },
			 { 0, 0, 34, 7, 92, 2, 0 },
			 { 0, 0, 30, 7, 96, 2, 0 },
			 { 0, 0, 26, 7, 99, 3, 0 },
			 { 0, 0, 23, 7, 102, 3, 0 },
			 { 0, 0, 20, 7, 104, 4, 0 },
			 { 0, 0, 18, 7, 106, 4, 0 },
			 { 0, 0, 15, 7, 108, 5, 0 },
			 { 0, 0, 13, 7, 109, 6, 0 },
			 { 0, 0, 11, 7, 110, 7, 0 },
			 { 0, 0, 10, 7, 110, 8, 0 },
			 { 0, 8, 110, 7, 10, 0, 0 },
			 { 0, 7, 110, 7, 11, 0, 0 },
			 { 0, 6, 109, 7, 13, 0, 0 },
			 { 0, 5, 108, 7, 15, 0, 0 },
			 { 0, 4, 106, 7, 18, 0, 0 },
			 { 0, 4, 104, 7, 20, 0, 0 },
			 { 0, 3, 102, 7, 23, 0, 0 },
			 { 0, 3, 99, 7, 26, 0, 0 },
			 { 0, 2, 96, 7, 30, 0, 0 },
			 { 0, 2, 92, 7, 34, 0, 0 },
			 { 0, 1, 89, 7, 38, 0, 0 },
			 { 0, 1, 85, 7, 42, 0, 0 },
			 { 0, 1, 81, 7, 46, 0, 0 },
			 { 0, 1, 76, 7, 51, 0, 0 },
			 { 0, 1, 71, 7, 56, 0, 0 },
			 { 0, 0, 67, 7, 61, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 9, 110, 7, 9, 0, 0 },
			 { 0, 8, 109, 7, 11, 0, 0 },
			 { 0, 7, 109, 7, 12, 0, 0 },
			 { 0, 6, 108, 7, 14, 0, 0 },
			 { 0, 5, 107, 7, 16, 0, 0 },
			 { 0, 4, 105, 7, 19, 0, 0 },
			 { 0, 3, 103, 7, 22, 0, 0 },
			 { 0, 3, 100, 7, 25, 0, 0 },
			 { 0, 2, 98, 7, 28, 0, 0 },
			 { 0, 2, 94, 7, 32, 0, 0 },
			 { 0, 2, 90, 7, 36, 0, 0 },
			 { 0, 1, 87, 7, 40, 0, 0 },
			 { 0, 1, 83, 7, 44, 0, 0 },
			 { 0, 1, 78, 7, 49, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 },
			 { 0, 1, 68, 7, 59, 0, 0 },
			 { 0, 0, 64, 7, 64, 0, 0 },
			 { 0, 0, 59, 7, 68, 1, 0 },
			 { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 49, 7, 78, 1, 0 },
			 { 0, 0, 44, 7, 83, 1, 0 },
			 { 0, 0, 40, 7, 87, 1, 0 },
			 { 0, 0, 36, 7, 90, 2, 0 },
			 { 0, 0, 32, 7, 94, 2, 0 },
			 { 0, 0, 28, 7, 98, 2, 0 },
			 { 0, 0, 25, 7, 100, 3, 0 },
			 { 0, 0, 22, 7, 103, 3, 0 },
			 { 0, 0, 19, 7, 105, 4, 0 },
			 { 0, 0, 16, 7, 107, 5, 0 },
			 { 0, 0, 14, 7, 108, 6, 0 },
			 { 0, 0, 12, 7, 109, 7, 0 },
			 { 0, 0, 11, 7, 109, 8, 0 } },
		.odd = { { 0, 0, 61, 7, 67, 0, 0 },
			 { 0, 0, 56, 7, 71, 1, 0 },
			 { 0, 0, 51, 7, 76, 1, 0 },
			 { 0, 0, 46, 7, 81, 1, 0 },
			 { 0, 0, 42, 7, 85, 1, 0 },
			 { 0, 0, 38, 7, 89, 1, 0 },
			 { 0, 0, 34, 7, 92, 2, 0 },
			 { 0, 0, 30, 7, 96, 2, 0 },
			 { 0, 0, 26, 7, 99, 3, 0 },
			 { 0, 0, 23, 7, 102, 3, 0 },
			 { 0, 0, 20, 7, 104, 4, 0 },
			 { 0, 0, 18, 7, 106, 4, 0 },
			 { 0, 0, 15, 7, 108, 5, 0 },
			 { 0, 0, 13, 7, 109, 6, 0 },
			 { 0, 0, 11, 7, 110, 7, 0 },
			 { 0, 0, 10, 7, 110, 8, 0 },
			 { 0, 8, 110, 7, 10, 0, 0 },
			 { 0, 7, 110, 7, 11, 0, 0 },
			 { 0, 6, 109, 7, 13, 0, 0 },
			 { 0, 5, 108, 7, 15, 0, 0 },
			 { 0, 4, 106, 7, 18, 0, 0 },
			 { 0, 4, 104, 7, 20, 0, 0 },
			 { 0, 3, 102, 7, 23, 0, 0 },
			 { 0, 3, 99, 7, 26, 0, 0 },
			 { 0, 2, 96, 7, 30, 0, 0 },
			 { 0, 2, 92, 7, 34, 0, 0 },
			 { 0, 1, 89, 7, 38, 0, 0 },
			 { 0, 1, 85, 7, 42, 0, 0 },
			 { 0, 1, 81, 7, 46, 0, 0 },
			 { 0, 1, 76, 7, 51, 0, 0 },
			 { 0, 1, 71, 7, 56, 0, 0 },
			 { 0, 0, 67, 7, 61, 0, 0 } } },
	.ptrn_arr = { { 0x33333333, 0x33333333, 0x99999999, 0x99999999 } },
	.sample_patrn_length = 130,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 34) = 0.484848 */
	.hor_phase_arr = {
		.even = { { 0, 10, 108, 7, 10, 0, 0 },
			 { 0, 7, 108, 7, 13, 0, 0 },
			 { 0, 5, 106, 7, 17, 0, 0 },
			 { 0, 4, 102, 7, 22, 0, 0 },
			 { 0, 3, 96, 7, 29, 0, 0 },
			 { 0, 2, 90, 7, 36, 0, 0 },
			 { 0, 1, 82, 7, 45, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 },
			 { 0, 0, 64, 7, 64, 0, 0 },
			 { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 45, 7, 82, 1, 0 },
			 { 0, 0, 36, 7, 90, 2, 0 },
			 { 0, 0, 29, 7, 96, 3, 0 },
			 { 0, 0, 22, 7, 102, 4, 0 },
			 { 0, 0, 17, 7, 106, 5, 0 },
			 { 0, 0, 13, 7, 108, 7, 0 } },
		.odd = { { 0, 0, 59, 7, 68, 1, 0 },
			 { 0, 0, 49, 7, 78, 1, 0 },
			 { 0, 0, 40, 7, 87, 1, 0 },
			 { 0, 0, 32, 7, 94, 2, 0 },
			 { 0, 0, 25, 7, 100, 3, 0 },
			 { 0, 0, 20, 7, 104, 4, 0 },
			 { 0, 0, 15, 7, 107, 6, 0 },
			 { 0, 0, 11, 7, 109, 8, 0 },
			 { 0, 8, 109, 7, 11, 0, 0 },
			 { 0, 6, 107, 7, 15, 0, 0 },
			 { 0, 4, 104, 7, 20, 0, 0 },
			 { 0, 3, 100, 7, 25, 0, 0 },
			 { 0, 2, 94, 7, 32, 0, 0 },
			 { 0, 1, 87, 7, 40, 0, 0 },
			 { 0, 1, 78, 7, 49, 0, 0 },
			 { 0, 1, 68, 7, 59, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 10, 108, 7, 10, 0, 0 },
			 { 0, 7, 108, 7, 13, 0, 0 },
			 { 0, 5, 106, 7, 17, 0, 0 },
			 { 0, 4, 102, 7, 22, 0, 0 },
			 { 0, 3, 96, 7, 29, 0, 0 },
			 { 0, 2, 90, 7, 36, 0, 0 },
			 { 0, 1, 82, 7, 45, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 },
			 { 0, 0, 64, 7, 64, 0, 0 },
			 { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 45, 7, 82, 1, 0 },
			 { 0, 0, 36, 7, 90, 2, 0 },
			 { 0, 0, 29, 7, 96, 3, 0 },
			 { 0, 0, 22, 7, 102, 4, 0 },
			 { 0, 0, 17, 7, 106, 5, 0 },
			 { 0, 0, 13, 7, 108, 7, 0 } },
		.odd = { { 0, 0, 59, 7, 68, 1, 0 },
			 { 0, 0, 49, 7, 78, 1, 0 },
			 { 0, 0, 40, 7, 87, 1, 0 },
			 { 0, 0, 32, 7, 94, 2, 0 },
			 { 0, 0, 25, 7, 100, 3, 0 },
			 { 0, 0, 20, 7, 104, 4, 0 },
			 { 0, 0, 15, 7, 107, 6, 0 },
			 { 0, 0, 11, 7, 109, 8, 0 },
			 { 0, 8, 109, 7, 11, 0, 0 },
			 { 0, 6, 107, 7, 15, 0, 0 },
			 { 0, 4, 104, 7, 20, 0, 0 },
			 { 0, 3, 100, 7, 25, 0, 0 },
			 { 0, 2, 94, 7, 32, 0, 0 },
			 { 0, 1, 87, 7, 40, 0, 0 },
			 { 0, 1, 78, 7, 49, 0, 0 },
			 { 0, 1, 68, 7, 59, 0, 0 } } },
	.ptrn_arr = { { 0x33333333, 0x99999999 } },
	.sample_patrn_length = 66,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 35) = 0.477612 */
	.hor_phase_arr = {
		.even = { { 0, 10, 108, 7, 10, 0, 0 },
			 { 0, 6, 106, 7, 16, 0, 0 },
			 { 0, 4, 101, 7, 23, 0, 0 },
			 { 0, 2, 93, 7, 33, 0, 0 },
			 { 0, 1, 82, 7, 45, 0, 0 },
			 { 0, 1, 68, 7, 59, 0, 0 },
			 { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 41, 7, 85, 2, 0 },
			 { 0, 0, 29, 7, 96, 3, 0 },
			 { 0, 0, 20, 7, 103, 5, 0 },
			 { 0, 0, 14, 7, 106, 8, 0 },
			 { 0, 9, 107, 7, 12, 0, 0 },
			 { 0, 5, 105, 7, 18, 0, 0 },
			 { 0, 3, 99, 7, 26, 0, 0 },
			 { 0, 2, 89, 7, 37, 0, 0 },
			 { 0, 1, 77, 7, 50, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 50, 7, 77, 1, 0 },
			 { 0, 0, 37, 7, 89, 2, 0 },
			 { 0, 0, 26, 7, 99, 3, 0 },
			 { 0, 0, 18, 7, 105, 5, 0 },
			 { 0, 0, 12, 7, 107, 9, 0 },
			 { 0, 8, 106, 7, 14, 0, 0 },
			 { 0, 5, 103, 7, 20, 0, 0 },
			 { 0, 3, 96, 7, 29, 0, 0 },
			 { 0, 2, 85, 7, 41, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 },
			 { 0, 0, 59, 7, 68, 1, 0 },
			 { 0, 0, 45, 7, 82, 1, 0 },
			 { 0, 0, 33, 7, 93, 2, 0 },
			 { 0, 0, 23, 7, 101, 4, 0 },
			 { 0, 0, 16, 7, 106, 6, 0 } },
		.odd = { { 0, 0, 56, 7, 71, 1, 0 },
			 { 0, 0, 43, 7, 84, 1, 0 },
			 { 0, 0, 31, 7, 94, 3, 0 },
			 { 0, 0, 22, 7, 102, 4, 0 },
			 { 0, 0, 15, 7, 106, 7, 0 },
			 { 0, 9, 108, 7, 11, 0, 0 },
			 { 0, 6, 105, 7, 17, 0, 0 },
			 { 0, 4, 99, 7, 25, 0, 0 },
			 { 0, 2, 91, 7, 35, 0, 0 },
			 { 0, 1, 80, 7, 47, 0, 0 },
			 { 0, 1, 65, 7, 61, 1, 0 },
			 { 0, 0, 52, 7, 75, 1, 0 },
			 { 0, 0, 39, 7, 87, 2, 0 },
			 { 0, 0, 28, 7, 97, 3, 0 },
			 { 0, 0, 19, 7, 104, 5, 0 },
			 { 0, 0, 13, 7, 107, 8, 0 },
			 { 0, 8, 107, 7, 13, 0, 0 },
			 { 0, 5, 104, 7, 19, 0, 0 },
			 { 0, 3, 97, 7, 28, 0, 0 },
			 { 0, 2, 87, 7, 39, 0, 0 },
			 { 0, 1, 75, 7, 52, 0, 0 },
			 { 0, 1, 61, 7, 65, 1, 0 },
			 { 0, 0, 47, 7, 80, 1, 0 },
			 { 0, 0, 35, 7, 91, 2, 0 },
			 { 0, 0, 25, 7, 99, 4, 0 },
			 { 0, 0, 17, 7, 105, 6, 0 },
			 { 0, 0, 11, 7, 108, 9, 0 },
			 { 0, 7, 106, 7, 15, 0, 0 },
			 { 0, 4, 102, 7, 22, 0, 0 },
			 { 0, 3, 94, 7, 31, 0, 0 },
			 { 0, 1, 84, 7, 43, 0, 0 },
			 { 0, 1, 71, 7, 56, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 10, 108, 7, 10, 0, 0 },
			 { 0, 6, 106, 7, 16, 0, 0 },
			 { 0, 4, 101, 7, 23, 0, 0 },
			 { 0, 2, 93, 7, 33, 0, 0 },
			 { 0, 1, 82, 7, 45, 0, 0 },
			 { 0, 1, 68, 7, 59, 0, 0 },
			 { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 41, 7, 85, 2, 0 },
			 { 0, 0, 29, 7, 96, 3, 0 },
			 { 0, 0, 20, 7, 103, 5, 0 },
			 { 0, 0, 14, 7, 106, 8, 0 },
			 { 0, 9, 107, 7, 12, 0, 0 },
			 { 0, 5, 105, 7, 18, 0, 0 },
			 { 0, 3, 99, 7, 26, 0, 0 },
			 { 0, 2, 89, 7, 37, 0, 0 },
			 { 0, 1, 77, 7, 50, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 50, 7, 77, 1, 0 },
			 { 0, 0, 37, 7, 89, 2, 0 },
			 { 0, 0, 26, 7, 99, 3, 0 },
			 { 0, 0, 18, 7, 105, 5, 0 },
			 { 0, 0, 12, 7, 107, 9, 0 },
			 { 0, 8, 106, 7, 14, 0, 0 },
			 { 0, 5, 103, 7, 20, 0, 0 },
			 { 0, 3, 96, 7, 29, 0, 0 },
			 { 0, 2, 85, 7, 41, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 },
			 { 0, 0, 59, 7, 68, 1, 0 },
			 { 0, 0, 45, 7, 82, 1, 0 },
			 { 0, 0, 33, 7, 93, 2, 0 },
			 { 0, 0, 23, 7, 101, 4, 0 },
			 { 0, 0, 16, 7, 106, 6, 0 } },
		.odd = { { 0, 0, 56, 7, 71, 1, 0 },
			 { 0, 0, 43, 7, 84, 1, 0 },
			 { 0, 0, 31, 7, 94, 3, 0 },
			 { 0, 0, 22, 7, 102, 4, 0 },
			 { 0, 0, 15, 7, 106, 7, 0 },
			 { 0, 9, 108, 7, 11, 0, 0 },
			 { 0, 6, 105, 7, 17, 0, 0 },
			 { 0, 4, 99, 7, 25, 0, 0 },
			 { 0, 2, 91, 7, 35, 0, 0 },
			 { 0, 1, 80, 7, 47, 0, 0 },
			 { 0, 1, 65, 7, 61, 1, 0 },
			 { 0, 0, 52, 7, 75, 1, 0 },
			 { 0, 0, 39, 7, 87, 2, 0 },
			 { 0, 0, 28, 7, 97, 3, 0 },
			 { 0, 0, 19, 7, 104, 5, 0 },
			 { 0, 0, 13, 7, 107, 8, 0 },
			 { 0, 8, 107, 7, 13, 0, 0 },
			 { 0, 5, 104, 7, 19, 0, 0 },
			 { 0, 3, 97, 7, 28, 0, 0 },
			 { 0, 2, 87, 7, 39, 0, 0 },
			 { 0, 1, 75, 7, 52, 0, 0 },
			 { 0, 1, 61, 7, 65, 1, 0 },
			 { 0, 0, 47, 7, 80, 1, 0 },
			 { 0, 0, 35, 7, 91, 2, 0 },
			 { 0, 0, 25, 7, 99, 4, 0 },
			 { 0, 0, 17, 7, 105, 6, 0 },
			 { 0, 0, 11, 7, 108, 9, 0 },
			 { 0, 7, 106, 7, 15, 0, 0 },
			 { 0, 4, 102, 7, 22, 0, 0 },
			 { 0, 3, 94, 7, 31, 0, 0 },
			 { 0, 1, 84, 7, 43, 0, 0 },
			 { 0, 1, 71, 7, 56, 0, 0 } } },
	.ptrn_arr = { { 0x99933333, 0xccccc999, 0x32666664, 0x99993333,
			 0x9 } },
	.sample_patrn_length = 134,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 36) = 0.470588 */
	.hor_phase_arr = {
		.even = { { 0, 11, 106, 7, 11, 0, 0 },
			 { 0, 6, 103, 7, 19, 0, 0 },
			 { 0, 3, 95, 7, 30, 0, 0 },
			 { 0, 1, 81, 7, 46, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 46, 7, 81, 1, 0 },
			 { 0, 0, 30, 7, 95, 3, 0 },
			 { 0, 0, 19, 7, 103, 6, 0 } },
		.odd = { { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 37, 7, 89, 2, 0 },
			 { 0, 0, 24, 7, 100, 4, 0 },
			 { 0, 0, 14, 7, 106, 8, 0 },
			 { 0, 8, 106, 7, 14, 0, 0 },
			 { 0, 4, 100, 7, 24, 0, 0 },
			 { 0, 2, 89, 7, 37, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 11, 106, 7, 11, 0, 0 },
			 { 0, 6, 103, 7, 19, 0, 0 },
			 { 0, 3, 95, 7, 30, 0, 0 },
			 { 0, 1, 81, 7, 46, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 46, 7, 81, 1, 0 },
			 { 0, 0, 30, 7, 95, 3, 0 },
			 { 0, 0, 19, 7, 103, 6, 0 } },
		.odd = { { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 37, 7, 89, 2, 0 },
			 { 0, 0, 24, 7, 100, 4, 0 },
			 { 0, 0, 14, 7, 106, 8, 0 },
			 { 0, 8, 106, 7, 14, 0, 0 },
			 { 0, 4, 100, 7, 24, 0, 0 },
			 { 0, 2, 89, 7, 37, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 } } },
	.ptrn_arr = { { 0x99993333 } },
	.sample_patrn_length = 34,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 37) = 0.463768 */
	.hor_phase_arr = {
		.even = { { 0, 11, 106, 7, 11, 0, 0 },
			 { 0, 5, 101, 7, 22, 0, 0 },
			 { 0, 2, 88, 7, 38, 0, 0 },
			 { 0, 1, 67, 7, 59, 1, 0 },
			 { 0, 0, 46, 7, 80, 2, 0 },
			 { 0, 0, 28, 7, 96, 4, 0 },
			 { 0, 0, 15, 7, 104, 9, 0 },
			 { 0, 7, 104, 7, 17, 0, 0 },
			 { 0, 3, 94, 7, 31, 0, 0 },
			 { 0, 1, 77, 7, 50, 0, 0 },
			 { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 34, 7, 91, 3, 0 },
			 { 0, 0, 19, 7, 103, 6, 0 },
			 { 0, 10, 105, 7, 13, 0, 0 },
			 { 0, 5, 98, 7, 25, 0, 0 },
			 { 0, 2, 84, 7, 42, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 42, 7, 84, 2, 0 },
			 { 0, 0, 25, 7, 98, 5, 0 },
			 { 0, 0, 13, 7, 105, 10, 0 },
			 { 0, 6, 103, 7, 19, 0, 0 },
			 { 0, 3, 91, 7, 34, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 },
			 { 0, 0, 50, 7, 77, 1, 0 },
			 { 0, 0, 31, 7, 94, 3, 0 },
			 { 0, 0, 17, 7, 104, 7, 0 },
			 { 0, 9, 104, 7, 15, 0, 0 },
			 { 0, 4, 96, 7, 28, 0, 0 },
			 { 0, 2, 80, 7, 46, 0, 0 },
			 { 0, 1, 59, 7, 67, 1, 0 },
			 { 0, 0, 38, 7, 88, 2, 0 },
			 { 0, 0, 22, 7, 101, 5, 0 } },
		.odd = { { 0, 0, 52, 7, 75, 1, 0 },
			 { 0, 0, 33, 7, 92, 3, 0 },
			 { 0, 0, 18, 7, 103, 7, 0 },
			 { 0, 9, 105, 7, 14, 0, 0 },
			 { 0, 4, 98, 7, 26, 0, 0 },
			 { 0, 2, 82, 7, 44, 0, 0 },
			 { 0, 1, 61, 7, 65, 1, 0 },
			 { 0, 0, 40, 7, 86, 2, 0 },
			 { 0, 0, 23, 7, 100, 5, 0 },
			 { 0, 0, 12, 7, 105, 11, 0 },
			 { 0, 6, 101, 7, 21, 0, 0 },
			 { 0, 3, 89, 7, 36, 0, 0 },
			 { 0, 1, 69, 7, 57, 1, 0 },
			 { 0, 0, 48, 7, 79, 1, 0 },
			 { 0, 0, 29, 7, 95, 4, 0 },
			 { 0, 0, 16, 7, 104, 8, 0 },
			 { 0, 8, 104, 7, 16, 0, 0 },
			 { 0, 4, 95, 7, 29, 0, 0 },
			 { 0, 1, 79, 7, 48, 0, 0 },
			 { 0, 1, 57, 7, 69, 1, 0 },
			 { 0, 0, 36, 7, 89, 3, 0 },
			 { 0, 0, 21, 7, 101, 6, 0 },
			 { 0, 11, 105, 7, 12, 0, 0 },
			 { 0, 5, 100, 7, 23, 0, 0 },
			 { 0, 2, 86, 7, 40, 0, 0 },
			 { 0, 1, 65, 7, 61, 1, 0 },
			 { 0, 0, 44, 7, 82, 2, 0 },
			 { 0, 0, 26, 7, 98, 4, 0 },
			 { 0, 0, 14, 7, 105, 9, 0 },
			 { 0, 7, 103, 7, 18, 0, 0 },
			 { 0, 3, 92, 7, 33, 0, 0 },
			 { 0, 1, 75, 7, 52, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 11, 106, 7, 11, 0, 0 },
			 { 0, 5, 101, 7, 22, 0, 0 },
			 { 0, 2, 88, 7, 38, 0, 0 },
			 { 0, 1, 67, 7, 59, 1, 0 },
			 { 0, 0, 46, 7, 80, 2, 0 },
			 { 0, 0, 28, 7, 96, 4, 0 },
			 { 0, 0, 15, 7, 104, 9, 0 },
			 { 0, 7, 104, 7, 17, 0, 0 },
			 { 0, 3, 94, 7, 31, 0, 0 },
			 { 0, 1, 77, 7, 50, 0, 0 },
			 { 0, 0, 54, 7, 73, 1, 0 },
			 { 0, 0, 34, 7, 91, 3, 0 },
			 { 0, 0, 19, 7, 103, 6, 0 },
			 { 0, 10, 105, 7, 13, 0, 0 },
			 { 0, 5, 98, 7, 25, 0, 0 },
			 { 0, 2, 84, 7, 42, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 42, 7, 84, 2, 0 },
			 { 0, 0, 25, 7, 98, 5, 0 },
			 { 0, 0, 13, 7, 105, 10, 0 },
			 { 0, 6, 103, 7, 19, 0, 0 },
			 { 0, 3, 91, 7, 34, 0, 0 },
			 { 0, 1, 73, 7, 54, 0, 0 },
			 { 0, 0, 50, 7, 77, 1, 0 },
			 { 0, 0, 31, 7, 94, 3, 0 },
			 { 0, 0, 17, 7, 104, 7, 0 },
			 { 0, 9, 104, 7, 15, 0, 0 },
			 { 0, 4, 96, 7, 28, 0, 0 },
			 { 0, 2, 80, 7, 46, 0, 0 },
			 { 0, 1, 59, 7, 67, 1, 0 },
			 { 0, 0, 38, 7, 88, 2, 0 },
			 { 0, 0, 22, 7, 101, 5, 0 } },
		.odd = { { 0, 0, 52, 7, 75, 1, 0 },
			 { 0, 0, 33, 7, 92, 3, 0 },
			 { 0, 0, 18, 7, 103, 7, 0 },
			 { 0, 9, 105, 7, 14, 0, 0 },
			 { 0, 4, 98, 7, 26, 0, 0 },
			 { 0, 2, 82, 7, 44, 0, 0 },
			 { 0, 1, 61, 7, 65, 1, 0 },
			 { 0, 0, 40, 7, 86, 2, 0 },
			 { 0, 0, 23, 7, 100, 5, 0 },
			 { 0, 0, 12, 7, 105, 11, 0 },
			 { 0, 6, 101, 7, 21, 0, 0 },
			 { 0, 3, 89, 7, 36, 0, 0 },
			 { 0, 1, 69, 7, 57, 1, 0 },
			 { 0, 0, 48, 7, 79, 1, 0 },
			 { 0, 0, 29, 7, 95, 4, 0 },
			 { 0, 0, 16, 7, 104, 8, 0 },
			 { 0, 8, 104, 7, 16, 0, 0 },
			 { 0, 4, 95, 7, 29, 0, 0 },
			 { 0, 1, 79, 7, 48, 0, 0 },
			 { 0, 1, 57, 7, 69, 1, 0 },
			 { 0, 0, 36, 7, 89, 3, 0 },
			 { 0, 0, 21, 7, 101, 6, 0 },
			 { 0, 11, 105, 7, 12, 0, 0 },
			 { 0, 5, 100, 7, 23, 0, 0 },
			 { 0, 2, 86, 7, 40, 0, 0 },
			 { 0, 1, 65, 7, 61, 1, 0 },
			 { 0, 0, 44, 7, 82, 2, 0 },
			 { 0, 0, 26, 7, 98, 4, 0 },
			 { 0, 0, 14, 7, 105, 9, 0 },
			 { 0, 7, 103, 7, 18, 0, 0 },
			 { 0, 3, 92, 7, 33, 0, 0 },
			 { 0, 1, 75, 7, 52, 0, 0 } } },
	.ptrn_arr = { { 0xc9999333, 0x332664cc, 0x4cc99993, 0x93332666,
			 0x99 } },
	.sample_patrn_length = 138,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 38) = 0.457143 */
	.hor_phase_arr = {
		.even = { { 0, 12, 104, 7, 12, 0, 0 },
			 { 0, 5, 98, 7, 25, 0, 0 },
			 { 0, 2, 80, 7, 46, 0, 0 },
			 { 0, 1, 55, 7, 71, 1, 0 },
			 { 0, 0, 32, 7, 92, 4, 0 },
			 { 0, 0, 16, 7, 103, 9, 0 },
			 { 0, 7, 101, 7, 20, 0, 0 },
			 { 0, 3, 86, 7, 39, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 39, 7, 86, 3, 0 },
			 { 0, 0, 20, 7, 101, 7, 0 },
			 { 0, 9, 103, 7, 16, 0, 0 },
			 { 0, 4, 92, 7, 32, 0, 0 },
			 { 0, 1, 71, 7, 55, 1, 0 },
			 { 0, 0, 46, 7, 80, 2, 0 },
			 { 0, 0, 25, 7, 98, 5, 0 } },
		.odd = { { 0, 0, 50, 7, 76, 2, 0 },
			 { 0, 0, 28, 7, 96, 4, 0 },
			 { 0, 0, 14, 7, 104, 10, 0 },
			 { 0, 6, 99, 7, 23, 0, 0 },
			 { 0, 2, 84, 7, 42, 0, 0 },
			 { 0, 1, 59, 7, 67, 1, 0 },
			 { 0, 0, 35, 7, 90, 3, 0 },
			 { 0, 0, 18, 7, 102, 8, 0 },
			 { 0, 8, 102, 7, 18, 0, 0 },
			 { 0, 3, 90, 7, 35, 0, 0 },
			 { 0, 1, 67, 7, 59, 1, 0 },
			 { 0, 0, 42, 7, 84, 2, 0 },
			 { 0, 0, 23, 7, 99, 6, 0 },
			 { 0, 10, 104, 7, 14, 0, 0 },
			 { 0, 4, 96, 7, 28, 0, 0 },
			 { 0, 2, 76, 7, 50, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 12, 104, 7, 12, 0, 0 },
			 { 0, 5, 98, 7, 25, 0, 0 },
			 { 0, 2, 80, 7, 46, 0, 0 },
			 { 0, 1, 55, 7, 71, 1, 0 },
			 { 0, 0, 32, 7, 92, 4, 0 },
			 { 0, 0, 16, 7, 103, 9, 0 },
			 { 0, 7, 101, 7, 20, 0, 0 },
			 { 0, 3, 86, 7, 39, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 39, 7, 86, 3, 0 },
			 { 0, 0, 20, 7, 101, 7, 0 },
			 { 0, 9, 103, 7, 16, 0, 0 },
			 { 0, 4, 92, 7, 32, 0, 0 },
			 { 0, 1, 71, 7, 55, 1, 0 },
			 { 0, 0, 46, 7, 80, 2, 0 },
			 { 0, 0, 25, 7, 98, 5, 0 } },
		.odd = { { 0, 0, 50, 7, 76, 2, 0 },
			 { 0, 0, 28, 7, 96, 4, 0 },
			 { 0, 0, 14, 7, 104, 10, 0 },
			 { 0, 6, 99, 7, 23, 0, 0 },
			 { 0, 2, 84, 7, 42, 0, 0 },
			 { 0, 1, 59, 7, 67, 1, 0 },
			 { 0, 0, 35, 7, 90, 3, 0 },
			 { 0, 0, 18, 7, 102, 8, 0 },
			 { 0, 8, 102, 7, 18, 0, 0 },
			 { 0, 3, 90, 7, 35, 0, 0 },
			 { 0, 1, 67, 7, 59, 1, 0 },
			 { 0, 0, 42, 7, 84, 2, 0 },
			 { 0, 0, 23, 7, 99, 6, 0 },
			 { 0, 10, 104, 7, 14, 0, 0 },
			 { 0, 4, 96, 7, 28, 0, 0 },
			 { 0, 2, 76, 7, 50, 0, 0 } } },
	.ptrn_arr = { { 0xcc999333, 0x99332664, 0x9 } },
	.sample_patrn_length = 70,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 39) = 0.450704 */
	.hor_phase_arr = {
		.even = { { 0, 13, 102, 7, 13, 0, 0 },
			 { 0, 5, 94, 7, 29, 0, 0 },
			 { 0, 1, 71, 7, 55, 1, 0 },
			 { 0, 0, 43, 7, 83, 2, 0 },
			 { 0, 0, 21, 7, 100, 7, 0 },
			 { 0, 8, 102, 7, 18, 0, 0 },
			 { 0, 3, 86, 7, 39, 0, 0 },
			 { 0, 1, 59, 7, 67, 1, 0 },
			 { 0, 0, 32, 7, 92, 4, 0 },
			 { 0, 0, 14, 7, 103, 11, 0 },
			 { 0, 5, 97, 7, 26, 0, 0 },
			 { 0, 2, 74, 7, 51, 1, 0 },
			 { 0, 0, 47, 7, 79, 2, 0 },
			 { 0, 0, 23, 7, 99, 6, 0 },
			 { 0, 10, 102, 7, 16, 0, 0 },
			 { 0, 3, 89, 7, 36, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 36, 7, 89, 3, 0 },
			 { 0, 0, 16, 7, 102, 10, 0 },
			 { 0, 6, 99, 7, 23, 0, 0 },
			 { 0, 2, 79, 7, 47, 0, 0 },
			 { 0, 1, 51, 7, 74, 2, 0 },
			 { 0, 0, 26, 7, 97, 5, 0 },
			 { 0, 11, 103, 7, 14, 0, 0 },
			 { 0, 4, 92, 7, 32, 0, 0 },
			 { 0, 1, 67, 7, 59, 1, 0 },
			 { 0, 0, 39, 7, 86, 3, 0 },
			 { 0, 0, 18, 7, 102, 8, 0 },
			 { 0, 7, 100, 7, 21, 0, 0 },
			 { 0, 2, 83, 7, 43, 0, 0 },
			 { 0, 1, 55, 7, 71, 1, 0 },
			 { 0, 0, 29, 7, 94, 5, 0 } },
		.odd = { { 0, 0, 49, 7, 77, 2, 0 },
			 { 0, 0, 25, 7, 97, 6, 0 },
			 { 0, 10, 103, 7, 15, 0, 0 },
			 { 0, 4, 90, 7, 34, 0, 0 },
			 { 0, 1, 65, 7, 61, 1, 0 },
			 { 0, 0, 37, 7, 88, 3, 0 },
			 { 0, 0, 17, 7, 102, 9, 0 },
			 { 0, 7, 99, 7, 22, 0, 0 },
			 { 0, 2, 81, 7, 45, 0, 0 },
			 { 0, 1, 53, 7, 72, 2, 0 },
			 { 0, 0, 27, 7, 96, 5, 0 },
			 { 0, 12, 103, 7, 13, 0, 0 },
			 { 0, 4, 93, 7, 31, 0, 0 },
			 { 0, 1, 69, 7, 57, 1, 0 },
			 { 0, 0, 41, 7, 84, 3, 0 },
			 { 0, 0, 20, 7, 100, 8, 0 },
			 { 0, 8, 100, 7, 20, 0, 0 },
			 { 0, 3, 84, 7, 41, 0, 0 },
			 { 0, 1, 57, 7, 69, 1, 0 },
			 { 0, 0, 31, 7, 93, 4, 0 },
			 { 0, 0, 13, 7, 103, 12, 0 },
			 { 0, 5, 96, 7, 27, 0, 0 },
			 { 0, 2, 72, 7, 53, 1, 0 },
			 { 0, 0, 45, 7, 81, 2, 0 },
			 { 0, 0, 22, 7, 99, 7, 0 },
			 { 0, 9, 102, 7, 17, 0, 0 },
			 { 0, 3, 88, 7, 37, 0, 0 },
			 { 0, 1, 61, 7, 65, 1, 0 },
			 { 0, 0, 34, 7, 90, 4, 0 },
			 { 0, 0, 15, 7, 103, 10, 0 },
			 { 0, 6, 97, 7, 25, 0, 0 },
			 { 0, 2, 77, 7, 49, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 13, 102, 7, 13, 0, 0 },
			 { 0, 5, 94, 7, 29, 0, 0 },
			 { 0, 1, 71, 7, 55, 1, 0 },
			 { 0, 0, 43, 7, 83, 2, 0 },
			 { 0, 0, 21, 7, 100, 7, 0 },
			 { 0, 8, 102, 7, 18, 0, 0 },
			 { 0, 3, 86, 7, 39, 0, 0 },
			 { 0, 1, 59, 7, 67, 1, 0 },
			 { 0, 0, 32, 7, 92, 4, 0 },
			 { 0, 0, 14, 7, 103, 11, 0 },
			 { 0, 5, 97, 7, 26, 0, 0 },
			 { 0, 2, 74, 7, 51, 1, 0 },
			 { 0, 0, 47, 7, 79, 2, 0 },
			 { 0, 0, 23, 7, 99, 6, 0 },
			 { 0, 10, 102, 7, 16, 0, 0 },
			 { 0, 3, 89, 7, 36, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 36, 7, 89, 3, 0 },
			 { 0, 0, 16, 7, 102, 10, 0 },
			 { 0, 6, 99, 7, 23, 0, 0 },
			 { 0, 2, 79, 7, 47, 0, 0 },
			 { 0, 1, 51, 7, 74, 2, 0 },
			 { 0, 0, 26, 7, 97, 5, 0 },
			 { 0, 11, 103, 7, 14, 0, 0 },
			 { 0, 4, 92, 7, 32, 0, 0 },
			 { 0, 1, 67, 7, 59, 1, 0 },
			 { 0, 0, 39, 7, 86, 3, 0 },
			 { 0, 0, 18, 7, 102, 8, 0 },
			 { 0, 7, 100, 7, 21, 0, 0 },
			 { 0, 2, 83, 7, 43, 0, 0 },
			 { 0, 1, 55, 7, 71, 1, 0 },
			 { 0, 0, 29, 7, 94, 5, 0 } },
		.odd = { { 0, 0, 49, 7, 77, 2, 0 },
			 { 0, 0, 25, 7, 97, 6, 0 },
			 { 0, 10, 103, 7, 15, 0, 0 },
			 { 0, 4, 90, 7, 34, 0, 0 },
			 { 0, 1, 65, 7, 61, 1, 0 },
			 { 0, 0, 37, 7, 88, 3, 0 },
			 { 0, 0, 17, 7, 102, 9, 0 },
			 { 0, 7, 99, 7, 22, 0, 0 },
			 { 0, 2, 81, 7, 45, 0, 0 },
			 { 0, 1, 53, 7, 72, 2, 0 },
			 { 0, 0, 27, 7, 96, 5, 0 },
			 { 0, 12, 103, 7, 13, 0, 0 },
			 { 0, 4, 93, 7, 31, 0, 0 },
			 { 0, 1, 69, 7, 57, 1, 0 },
			 { 0, 0, 41, 7, 84, 3, 0 },
			 { 0, 0, 20, 7, 100, 8, 0 },
			 { 0, 8, 100, 7, 20, 0, 0 },
			 { 0, 3, 84, 7, 41, 0, 0 },
			 { 0, 1, 57, 7, 69, 1, 0 },
			 { 0, 0, 31, 7, 93, 4, 0 },
			 { 0, 0, 13, 7, 103, 12, 0 },
			 { 0, 5, 96, 7, 27, 0, 0 },
			 { 0, 2, 72, 7, 53, 1, 0 },
			 { 0, 0, 45, 7, 81, 2, 0 },
			 { 0, 0, 22, 7, 99, 7, 0 },
			 { 0, 9, 102, 7, 17, 0, 0 },
			 { 0, 3, 88, 7, 37, 0, 0 },
			 { 0, 1, 61, 7, 65, 1, 0 },
			 { 0, 0, 34, 7, 90, 4, 0 },
			 { 0, 0, 15, 7, 103, 10, 0 },
			 { 0, 6, 97, 7, 25, 0, 0 },
			 { 0, 2, 77, 7, 49, 0, 0 } } },
	.ptrn_arr = { { 0x4cc99933, 0xc9993266, 0x9332664c, 0x32664cc9,
			 0x993 } },
	.sample_patrn_length = 142,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 40) = 0.444444 */
	.hor_phase_arr = {
		.even = { { 0, 13, 102, 7, 13, 0, 0 },
			 { 0, 4, 91, 7, 33, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 33, 7, 91, 4, 0 } },
		.odd = { { 0, 0, 47, 7, 79, 2, 0 },
			 { 0, 0, 21, 7, 99, 8, 0 },
			 { 0, 8, 99, 7, 21, 0, 0 },
			 { 0, 2, 79, 7, 47, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 13, 102, 7, 13, 0, 0 },
			 { 0, 4, 91, 7, 33, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 33, 7, 91, 4, 0 } },
		.odd = { { 0, 0, 47, 7, 79, 2, 0 },
			 { 0, 0, 21, 7, 99, 8, 0 },
			 { 0, 8, 99, 7, 21, 0, 0 },
			 { 0, 2, 79, 7, 47, 0, 0 } } },
	.ptrn_arr = { { 0x9933 } },
	.sample_patrn_length = 18,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 41) = 0.438356 */
	.hor_phase_arr = {
		.even = { { 0, 14, 100, 7, 14, 0, 0 },
			 { 0, 4, 87, 7, 37, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 25, 7, 96, 7, 0 },
			 { 0, 8, 98, 7, 22, 0, 0 },
			 { 0, 2, 74, 7, 51, 1, 0 },
			 { 0, 0, 40, 7, 85, 3, 0 },
			 { 0, 0, 16, 7, 100, 12, 0 },
			 { 0, 5, 90, 7, 33, 0, 0 },
			 { 0, 1, 59, 7, 67, 1, 0 },
			 { 0, 0, 27, 7, 95, 6, 0 },
			 { 0, 9, 99, 7, 20, 0, 0 },
			 { 0, 2, 78, 7, 47, 1, 0 },
			 { 0, 0, 44, 7, 81, 3, 0 },
			 { 0, 0, 18, 7, 99, 11, 0 },
			 { 0, 5, 93, 7, 30, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 30, 7, 93, 5, 0 },
			 { 0, 11, 99, 7, 18, 0, 0 },
			 { 0, 3, 81, 7, 44, 0, 0 },
			 { 0, 1, 47, 7, 78, 2, 0 },
			 { 0, 0, 20, 7, 99, 9, 0 },
			 { 0, 6, 95, 7, 27, 0, 0 },
			 { 0, 1, 67, 7, 59, 1, 0 },
			 { 0, 0, 33, 7, 90, 5, 0 },
			 { 0, 12, 100, 7, 16, 0, 0 },
			 { 0, 3, 85, 7, 40, 0, 0 },
			 { 0, 1, 51, 7, 74, 2, 0 },
			 { 0, 0, 22, 7, 98, 8, 0 },
			 { 0, 7, 96, 7, 25, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 37, 7, 87, 4, 0 } },
		.odd = { { 0, 0, 45, 7, 80, 3, 0 },
			 { 0, 0, 19, 7, 99, 10, 0 },
			 { 0, 6, 93, 7, 29, 0, 0 },
			 { 0, 1, 65, 7, 61, 1, 0 },
			 { 0, 0, 32, 7, 91, 5, 0 },
			 { 0, 11, 100, 7, 17, 0, 0 },
			 { 0, 3, 83, 7, 42, 0, 0 },
			 { 0, 1, 49, 7, 76, 2, 0 },
			 { 0, 0, 21, 7, 98, 9, 0 },
			 { 0, 7, 95, 7, 26, 0, 0 },
			 { 0, 2, 68, 7, 57, 1, 0 },
			 { 0, 0, 35, 7, 89, 4, 0 },
			 { 0, 13, 100, 7, 15, 0, 0 },
			 { 0, 4, 86, 7, 38, 0, 0 },
			 { 0, 1, 53, 7, 72, 2, 0 },
			 { 0, 0, 23, 7, 97, 8, 0 },
			 { 0, 8, 97, 7, 23, 0, 0 },
			 { 0, 2, 72, 7, 53, 1, 0 },
			 { 0, 0, 38, 7, 86, 4, 0 },
			 { 0, 0, 15, 7, 100, 13, 0 },
			 { 0, 4, 89, 7, 35, 0, 0 },
			 { 0, 1, 57, 7, 68, 2, 0 },
			 { 0, 0, 26, 7, 95, 7, 0 },
			 { 0, 9, 98, 7, 21, 0, 0 },
			 { 0, 2, 76, 7, 49, 1, 0 },
			 { 0, 0, 42, 7, 83, 3, 0 },
			 { 0, 0, 17, 7, 100, 11, 0 },
			 { 0, 5, 91, 7, 32, 0, 0 },
			 { 0, 1, 61, 7, 65, 1, 0 },
			 { 0, 0, 29, 7, 93, 6, 0 },
			 { 0, 10, 99, 7, 19, 0, 0 },
			 { 0, 3, 80, 7, 45, 0, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 14, 100, 7, 14, 0, 0 },
			 { 0, 4, 87, 7, 37, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 25, 7, 96, 7, 0 },
			 { 0, 8, 98, 7, 22, 0, 0 },
			 { 0, 2, 74, 7, 51, 1, 0 },
			 { 0, 0, 40, 7, 85, 3, 0 },
			 { 0, 0, 16, 7, 100, 12, 0 },
			 { 0, 5, 90, 7, 33, 0, 0 },
			 { 0, 1, 59, 7, 67, 1, 0 },
			 { 0, 0, 27, 7, 95, 6, 0 },
			 { 0, 9, 99, 7, 20, 0, 0 },
			 { 0, 2, 78, 7, 47, 1, 0 },
			 { 0, 0, 44, 7, 81, 3, 0 },
			 { 0, 0, 18, 7, 99, 11, 0 },
			 { 0, 5, 93, 7, 30, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 30, 7, 93, 5, 0 },
			 { 0, 11, 99, 7, 18, 0, 0 },
			 { 0, 3, 81, 7, 44, 0, 0 },
			 { 0, 1, 47, 7, 78, 2, 0 },
			 { 0, 0, 20, 7, 99, 9, 0 },
			 { 0, 6, 95, 7, 27, 0, 0 },
			 { 0, 1, 67, 7, 59, 1, 0 },
			 { 0, 0, 33, 7, 90, 5, 0 },
			 { 0, 12, 100, 7, 16, 0, 0 },
			 { 0, 3, 85, 7, 40, 0, 0 },
			 { 0, 1, 51, 7, 74, 2, 0 },
			 { 0, 0, 22, 7, 98, 8, 0 },
			 { 0, 7, 96, 7, 25, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 37, 7, 87, 4, 0 } },
		.odd = { { 0, 0, 45, 7, 80, 3, 0 },
			 { 0, 0, 19, 7, 99, 10, 0 },
			 { 0, 6, 93, 7, 29, 0, 0 },
			 { 0, 1, 65, 7, 61, 1, 0 },
			 { 0, 0, 32, 7, 91, 5, 0 },
			 { 0, 11, 100, 7, 17, 0, 0 },
			 { 0, 3, 83, 7, 42, 0, 0 },
			 { 0, 1, 49, 7, 76, 2, 0 },
			 { 0, 0, 21, 7, 98, 9, 0 },
			 { 0, 7, 95, 7, 26, 0, 0 },
			 { 0, 2, 68, 7, 57, 1, 0 },
			 { 0, 0, 35, 7, 89, 4, 0 },
			 { 0, 13, 100, 7, 15, 0, 0 },
			 { 0, 4, 86, 7, 38, 0, 0 },
			 { 0, 1, 53, 7, 72, 2, 0 },
			 { 0, 0, 23, 7, 97, 8, 0 },
			 { 0, 8, 97, 7, 23, 0, 0 },
			 { 0, 2, 72, 7, 53, 1, 0 },
			 { 0, 0, 38, 7, 86, 4, 0 },
			 { 0, 0, 15, 7, 100, 13, 0 },
			 { 0, 4, 89, 7, 35, 0, 0 },
			 { 0, 1, 57, 7, 68, 2, 0 },
			 { 0, 0, 26, 7, 95, 7, 0 },
			 { 0, 9, 98, 7, 21, 0, 0 },
			 { 0, 2, 76, 7, 49, 1, 0 },
			 { 0, 0, 42, 7, 83, 3, 0 },
			 { 0, 0, 17, 7, 100, 11, 0 },
			 { 0, 5, 91, 7, 32, 0, 0 },
			 { 0, 1, 61, 7, 65, 1, 0 },
			 { 0, 0, 29, 7, 93, 6, 0 },
			 { 0, 10, 99, 7, 19, 0, 0 },
			 { 0, 3, 80, 7, 45, 0, 0 } } },
	.ptrn_arr = { { 0x664c9933, 0x664c9932, 0x64cc9932, 0x64cc9932,
			 0x9932 } },
	.sample_patrn_length = 146,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 42) = 0.432432 */
	.hor_phase_arr = {
		.even = { { 0, 14, 100, 7, 14, 0, 0 },
			 { 0, 4, 84, 7, 40, 0, 0 },
			 { 0, 1, 48, 7, 76, 3, 0 },
			 { 0, 0, 18, 7, 99, 11, 0 },
			 { 0, 5, 89, 7, 34, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 23, 7, 96, 9, 0 },
			 { 0, 7, 93, 7, 28, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 28, 7, 93, 7, 0 },
			 { 0, 9, 96, 7, 23, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 34, 7, 89, 5, 0 },
			 { 0, 11, 99, 7, 18, 0, 0 },
			 { 0, 3, 76, 7, 48, 1, 0 },
			 { 0, 0, 40, 7, 84, 4, 0 } },
		.odd = { { 0, 1, 44, 7, 80, 3, 0 },
			 { 0, 0, 16, 7, 99, 13, 0 },
			 { 0, 4, 87, 7, 37, 0, 0 },
			 { 0, 1, 51, 7, 74, 2, 0 },
			 { 0, 0, 20, 7, 98, 10, 0 },
			 { 0, 6, 91, 7, 31, 0, 0 },
			 { 0, 1, 59, 7, 66, 2, 0 },
			 { 0, 0, 25, 7, 95, 8, 0 },
			 { 0, 8, 95, 7, 25, 0, 0 },
			 { 0, 2, 66, 7, 59, 1, 0 },
			 { 0, 0, 31, 7, 91, 6, 0 },
			 { 0, 10, 98, 7, 20, 0, 0 },
			 { 0, 2, 74, 7, 51, 1, 0 },
			 { 0, 0, 37, 7, 87, 4, 0 },
			 { 0, 13, 99, 7, 16, 0, 0 },
			 { 0, 3, 80, 7, 44, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 14, 100, 7, 14, 0, 0 },
			 { 0, 4, 84, 7, 40, 0, 0 },
			 { 0, 1, 48, 7, 76, 3, 0 },
			 { 0, 0, 18, 7, 99, 11, 0 },
			 { 0, 5, 89, 7, 34, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 23, 7, 96, 9, 0 },
			 { 0, 7, 93, 7, 28, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 28, 7, 93, 7, 0 },
			 { 0, 9, 96, 7, 23, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 34, 7, 89, 5, 0 },
			 { 0, 11, 99, 7, 18, 0, 0 },
			 { 0, 3, 76, 7, 48, 1, 0 },
			 { 0, 0, 40, 7, 84, 4, 0 } },
		.odd = { { 0, 1, 44, 7, 80, 3, 0 },
			 { 0, 0, 16, 7, 99, 13, 0 },
			 { 0, 4, 87, 7, 37, 0, 0 },
			 { 0, 1, 51, 7, 74, 2, 0 },
			 { 0, 0, 20, 7, 98, 10, 0 },
			 { 0, 6, 91, 7, 31, 0, 0 },
			 { 0, 1, 59, 7, 66, 2, 0 },
			 { 0, 0, 25, 7, 95, 8, 0 },
			 { 0, 8, 95, 7, 25, 0, 0 },
			 { 0, 2, 66, 7, 59, 1, 0 },
			 { 0, 0, 31, 7, 91, 6, 0 },
			 { 0, 10, 98, 7, 20, 0, 0 },
			 { 0, 2, 74, 7, 51, 1, 0 },
			 { 0, 0, 37, 7, 87, 4, 0 },
			 { 0, 13, 99, 7, 16, 0, 0 },
			 { 0, 3, 80, 7, 44, 1, 0 } } },
	.ptrn_arr = { { 0x264c9933, 0x3264c993, 0x99 } },
	.sample_patrn_length = 74,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 43) = 0.426667 */
	.hor_phase_arr = {
		.even = { { 0, 15, 98, 7, 15, 0, 0 },
			 { 0, 3, 80, 7, 44, 1, 0 },
			 { 0, 0, 41, 7, 83, 4, 0 },
			 { 0, 13, 98, 7, 17, 0, 0 },
			 { 0, 3, 76, 7, 48, 1, 0 },
			 { 0, 0, 38, 7, 85, 5, 0 },
			 { 0, 12, 97, 7, 19, 0, 0 },
			 { 0, 2, 74, 7, 51, 1, 0 },
			 { 0, 0, 34, 7, 89, 5, 0 },
			 { 0, 10, 97, 7, 21, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 31, 7, 91, 6, 0 },
			 { 0, 9, 96, 7, 23, 0, 0 },
			 { 0, 2, 66, 7, 59, 1, 0 },
			 { 0, 0, 29, 7, 92, 7, 0 },
			 { 0, 8, 94, 7, 26, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 26, 7, 94, 8, 0 },
			 { 0, 7, 92, 7, 29, 0, 0 },
			 { 0, 1, 59, 7, 66, 2, 0 },
			 { 0, 0, 23, 7, 96, 9, 0 },
			 { 0, 6, 91, 7, 31, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 21, 7, 97, 10, 0 },
			 { 0, 5, 89, 7, 34, 0, 0 },
			 { 0, 1, 51, 7, 74, 2, 0 },
			 { 0, 0, 19, 7, 97, 12, 0 },
			 { 0, 5, 85, 7, 38, 0, 0 },
			 { 0, 1, 48, 7, 76, 3, 0 },
			 { 0, 0, 17, 7, 98, 13, 0 },
			 { 0, 4, 83, 7, 41, 0, 0 },
			 { 0, 1, 44, 7, 80, 3, 0 } },
		.odd = { { 0, 1, 43, 7, 80, 4, 0 },
			 { 0, 14, 98, 7, 16, 0, 0 },
			 { 0, 3, 78, 7, 46, 1, 0 },
			 { 0, 0, 39, 7, 85, 4, 0 },
			 { 0, 12, 98, 7, 18, 0, 0 },
			 { 0, 3, 74, 7, 50, 1, 0 },
			 { 0, 0, 36, 7, 87, 5, 0 },
			 { 0, 11, 97, 7, 20, 0, 0 },
			 { 0, 2, 72, 7, 53, 1, 0 },
			 { 0, 0, 33, 7, 89, 6, 0 },
			 { 0, 10, 96, 7, 22, 0, 0 },
			 { 0, 2, 68, 7, 57, 1, 0 },
			 { 0, 0, 30, 7, 92, 6, 0 },
			 { 0, 9, 94, 7, 25, 0, 0 },
			 { 0, 2, 64, 7, 61, 1, 0 },
			 { 0, 0, 27, 7, 94, 7, 0 },
			 { 0, 7, 94, 7, 27, 0, 0 },
			 { 0, 1, 61, 7, 64, 2, 0 },
			 { 0, 0, 25, 7, 94, 9, 0 },
			 { 0, 6, 92, 7, 30, 0, 0 },
			 { 0, 1, 57, 7, 68, 2, 0 },
			 { 0, 0, 22, 7, 96, 10, 0 },
			 { 0, 6, 89, 7, 33, 0, 0 },
			 { 0, 1, 53, 7, 72, 2, 0 },
			 { 0, 0, 20, 7, 97, 11, 0 },
			 { 0, 5, 87, 7, 36, 0, 0 },
			 { 0, 1, 50, 7, 74, 3, 0 },
			 { 0, 0, 18, 7, 98, 12, 0 },
			 { 0, 4, 85, 7, 39, 0, 0 },
			 { 0, 1, 46, 7, 78, 3, 0 },
			 { 0, 0, 16, 7, 98, 14, 0 },
			 { 0, 4, 80, 7, 43, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 15, 98, 7, 15, 0, 0 },
			 { 0, 3, 80, 7, 44, 1, 0 },
			 { 0, 0, 41, 7, 83, 4, 0 },
			 { 0, 13, 98, 7, 17, 0, 0 },
			 { 0, 3, 76, 7, 48, 1, 0 },
			 { 0, 0, 38, 7, 85, 5, 0 },
			 { 0, 12, 97, 7, 19, 0, 0 },
			 { 0, 2, 74, 7, 51, 1, 0 },
			 { 0, 0, 34, 7, 89, 5, 0 },
			 { 0, 10, 97, 7, 21, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 31, 7, 91, 6, 0 },
			 { 0, 9, 96, 7, 23, 0, 0 },
			 { 0, 2, 66, 7, 59, 1, 0 },
			 { 0, 0, 29, 7, 92, 7, 0 },
			 { 0, 8, 94, 7, 26, 0, 0 },
			 { 0, 1, 63, 7, 63, 1, 0 },
			 { 0, 0, 26, 7, 94, 8, 0 },
			 { 0, 7, 92, 7, 29, 0, 0 },
			 { 0, 1, 59, 7, 66, 2, 0 },
			 { 0, 0, 23, 7, 96, 9, 0 },
			 { 0, 6, 91, 7, 31, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 21, 7, 97, 10, 0 },
			 { 0, 5, 89, 7, 34, 0, 0 },
			 { 0, 1, 51, 7, 74, 2, 0 },
			 { 0, 0, 19, 7, 97, 12, 0 },
			 { 0, 5, 85, 7, 38, 0, 0 },
			 { 0, 1, 48, 7, 76, 3, 0 },
			 { 0, 0, 17, 7, 98, 13, 0 },
			 { 0, 4, 83, 7, 41, 0, 0 },
			 { 0, 1, 44, 7, 80, 3, 0 } },
		.odd = { { 0, 1, 43, 7, 80, 4, 0 },
			 { 0, 14, 98, 7, 16, 0, 0 },
			 { 0, 3, 78, 7, 46, 1, 0 },
			 { 0, 0, 39, 7, 85, 4, 0 },
			 { 0, 12, 98, 7, 18, 0, 0 },
			 { 0, 3, 74, 7, 50, 1, 0 },
			 { 0, 0, 36, 7, 87, 5, 0 },
			 { 0, 11, 97, 7, 20, 0, 0 },
			 { 0, 2, 72, 7, 53, 1, 0 },
			 { 0, 0, 33, 7, 89, 6, 0 },
			 { 0, 10, 96, 7, 22, 0, 0 },
			 { 0, 2, 68, 7, 57, 1, 0 },
			 { 0, 0, 30, 7, 92, 6, 0 },
			 { 0, 9, 94, 7, 25, 0, 0 },
			 { 0, 2, 64, 7, 61, 1, 0 },
			 { 0, 0, 27, 7, 94, 7, 0 },
			 { 0, 7, 94, 7, 27, 0, 0 },
			 { 0, 1, 61, 7, 64, 2, 0 },
			 { 0, 0, 25, 7, 94, 9, 0 },
			 { 0, 6, 92, 7, 30, 0, 0 },
			 { 0, 1, 57, 7, 68, 2, 0 },
			 { 0, 0, 22, 7, 96, 10, 0 },
			 { 0, 6, 89, 7, 33, 0, 0 },
			 { 0, 1, 53, 7, 72, 2, 0 },
			 { 0, 0, 20, 7, 97, 11, 0 },
			 { 0, 5, 87, 7, 36, 0, 0 },
			 { 0, 1, 50, 7, 74, 3, 0 },
			 { 0, 0, 18, 7, 98, 12, 0 },
			 { 0, 4, 85, 7, 39, 0, 0 },
			 { 0, 1, 46, 7, 78, 3, 0 },
			 { 0, 0, 16, 7, 98, 14, 0 },
			 { 0, 4, 80, 7, 43, 1, 0 } } },
	.ptrn_arr = { { 0x3264c993, 0x93264c99, 0x993264c9, 0xc993264c,
			 0x93264 } },
	.sample_patrn_length = 150,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 44) = 0.421053 */
	.hor_phase_arr = {
		.even = { { 0, 16, 96, 7, 16, 0, 0 },
			 { 0, 3, 76, 7, 48, 1, 0 },
			 { 0, 0, 35, 7, 87, 6, 0 },
			 { 0, 10, 94, 7, 24, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 0, 24, 7, 94, 10, 0 },
			 { 0, 6, 87, 7, 35, 0, 0 },
			 { 0, 1, 48, 7, 76, 3, 0 } },
		.odd = { { 0, 1, 41, 7, 82, 4, 0 },
			 { 0, 12, 97, 7, 19, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 29, 7, 92, 7, 0 },
			 { 0, 7, 92, 7, 29, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 19, 7, 97, 12, 0 },
			 { 0, 4, 82, 7, 41, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 16, 96, 7, 16, 0, 0 },
			 { 0, 3, 76, 7, 48, 1, 0 },
			 { 0, 0, 35, 7, 87, 6, 0 },
			 { 0, 10, 94, 7, 24, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 0, 24, 7, 94, 10, 0 },
			 { 0, 6, 87, 7, 35, 0, 0 },
			 { 0, 1, 48, 7, 76, 3, 0 } },
		.odd = { { 0, 1, 41, 7, 82, 4, 0 },
			 { 0, 12, 97, 7, 19, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 29, 7, 92, 7, 0 },
			 { 0, 7, 92, 7, 29, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 19, 7, 97, 12, 0 },
			 { 0, 4, 82, 7, 41, 1, 0 } } },
	.ptrn_arr = { { 0x3264c993, 0x9 } },
	.sample_patrn_length = 38,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 45) = 0.415584 */
	.hor_phase_arr = {
		.even = { { 0, 16, 96, 7, 16, 0, 0 },
			 { 0, 3, 72, 7, 52, 1, 0 },
			 { 0, 0, 30, 7, 90, 8, 0 },
			 { 0, 7, 89, 7, 32, 0, 0 },
			 { 0, 1, 48, 7, 76, 3, 0 },
			 { 0, 14, 96, 7, 18, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 27, 7, 92, 9, 0 },
			 { 0, 6, 87, 7, 35, 0, 0 },
			 { 0, 1, 45, 7, 78, 4, 0 },
			 { 0, 13, 95, 7, 20, 0, 0 },
			 { 0, 2, 66, 7, 59, 1, 0 },
			 { 0, 0, 24, 7, 94, 10, 0 },
			 { 0, 5, 85, 7, 38, 0, 0 },
			 { 0, 1, 42, 7, 81, 4, 0 },
			 { 0, 11, 95, 7, 22, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 0, 22, 7, 95, 11, 0 },
			 { 0, 4, 81, 7, 42, 1, 0 },
			 { 0, 0, 38, 7, 85, 5, 0 },
			 { 0, 10, 94, 7, 24, 0, 0 },
			 { 0, 1, 59, 7, 66, 2, 0 },
			 { 0, 0, 20, 7, 95, 13, 0 },
			 { 0, 4, 78, 7, 45, 1, 0 },
			 { 0, 0, 35, 7, 87, 6, 0 },
			 { 0, 9, 92, 7, 27, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 18, 7, 96, 14, 0 },
			 { 0, 3, 76, 7, 48, 1, 0 },
			 { 0, 0, 32, 7, 89, 7, 0 },
			 { 0, 8, 90, 7, 30, 0, 0 },
			 { 0, 1, 52, 7, 72, 3, 0 } },
		.odd = { { 0, 1, 40, 7, 82, 5, 0 },
			 { 0, 11, 94, 7, 23, 0, 0 },
			 { 0, 2, 61, 7, 63, 2, 0 },
			 { 0, 0, 21, 7, 95, 12, 0 },
			 { 0, 4, 80, 7, 43, 1, 0 },
			 { 0, 0, 37, 7, 85, 6, 0 },
			 { 0, 9, 93, 7, 26, 0, 0 },
			 { 0, 1, 57, 7, 68, 2, 0 },
			 { 0, 0, 19, 7, 95, 14, 0 },
			 { 0, 4, 76, 7, 47, 1, 0 },
			 { 0, 0, 34, 7, 88, 6, 0 },
			 { 0, 8, 92, 7, 28, 0, 0 },
			 { 0, 1, 54, 7, 70, 3, 0 },
			 { 0, 0, 17, 7, 96, 15, 0 },
			 { 0, 3, 74, 7, 50, 1, 0 },
			 { 0, 0, 31, 7, 90, 7, 0 },
			 { 0, 7, 90, 7, 31, 0, 0 },
			 { 0, 1, 50, 7, 74, 3, 0 },
			 { 0, 15, 96, 7, 17, 0, 0 },
			 { 0, 3, 70, 7, 54, 1, 0 },
			 { 0, 0, 28, 7, 92, 8, 0 },
			 { 0, 6, 88, 7, 34, 0, 0 },
			 { 0, 1, 47, 7, 76, 4, 0 },
			 { 0, 14, 95, 7, 19, 0, 0 },
			 { 0, 2, 68, 7, 57, 1, 0 },
			 { 0, 0, 26, 7, 93, 9, 0 },
			 { 0, 6, 85, 7, 37, 0, 0 },
			 { 0, 1, 43, 7, 80, 4, 0 },
			 { 0, 12, 95, 7, 21, 0, 0 },
			 { 0, 2, 63, 7, 61, 2, 0 },
			 { 0, 0, 23, 7, 94, 11, 0 },
			 { 0, 5, 82, 7, 40, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 16, 96, 7, 16, 0, 0 },
			 { 0, 3, 72, 7, 52, 1, 0 },
			 { 0, 0, 30, 7, 90, 8, 0 },
			 { 0, 7, 89, 7, 32, 0, 0 },
			 { 0, 1, 48, 7, 76, 3, 0 },
			 { 0, 14, 96, 7, 18, 0, 0 },
			 { 0, 2, 70, 7, 55, 1, 0 },
			 { 0, 0, 27, 7, 92, 9, 0 },
			 { 0, 6, 87, 7, 35, 0, 0 },
			 { 0, 1, 45, 7, 78, 4, 0 },
			 { 0, 13, 95, 7, 20, 0, 0 },
			 { 0, 2, 66, 7, 59, 1, 0 },
			 { 0, 0, 24, 7, 94, 10, 0 },
			 { 0, 5, 85, 7, 38, 0, 0 },
			 { 0, 1, 42, 7, 81, 4, 0 },
			 { 0, 11, 95, 7, 22, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 0, 22, 7, 95, 11, 0 },
			 { 0, 4, 81, 7, 42, 1, 0 },
			 { 0, 0, 38, 7, 85, 5, 0 },
			 { 0, 10, 94, 7, 24, 0, 0 },
			 { 0, 1, 59, 7, 66, 2, 0 },
			 { 0, 0, 20, 7, 95, 13, 0 },
			 { 0, 4, 78, 7, 45, 1, 0 },
			 { 0, 0, 35, 7, 87, 6, 0 },
			 { 0, 9, 92, 7, 27, 0, 0 },
			 { 0, 1, 55, 7, 70, 2, 0 },
			 { 0, 0, 18, 7, 96, 14, 0 },
			 { 0, 3, 76, 7, 48, 1, 0 },
			 { 0, 0, 32, 7, 89, 7, 0 },
			 { 0, 8, 90, 7, 30, 0, 0 },
			 { 0, 1, 52, 7, 72, 3, 0 } },
		.odd = { { 0, 1, 40, 7, 82, 5, 0 },
			 { 0, 11, 94, 7, 23, 0, 0 },
			 { 0, 2, 61, 7, 63, 2, 0 },
			 { 0, 0, 21, 7, 95, 12, 0 },
			 { 0, 4, 80, 7, 43, 1, 0 },
			 { 0, 0, 37, 7, 85, 6, 0 },
			 { 0, 9, 93, 7, 26, 0, 0 },
			 { 0, 1, 57, 7, 68, 2, 0 },
			 { 0, 0, 19, 7, 95, 14, 0 },
			 { 0, 4, 76, 7, 47, 1, 0 },
			 { 0, 0, 34, 7, 88, 6, 0 },
			 { 0, 8, 92, 7, 28, 0, 0 },
			 { 0, 1, 54, 7, 70, 3, 0 },
			 { 0, 0, 17, 7, 96, 15, 0 },
			 { 0, 3, 74, 7, 50, 1, 0 },
			 { 0, 0, 31, 7, 90, 7, 0 },
			 { 0, 7, 90, 7, 31, 0, 0 },
			 { 0, 1, 50, 7, 74, 3, 0 },
			 { 0, 15, 96, 7, 17, 0, 0 },
			 { 0, 3, 70, 7, 54, 1, 0 },
			 { 0, 0, 28, 7, 92, 8, 0 },
			 { 0, 6, 88, 7, 34, 0, 0 },
			 { 0, 1, 47, 7, 76, 4, 0 },
			 { 0, 14, 95, 7, 19, 0, 0 },
			 { 0, 2, 68, 7, 57, 1, 0 },
			 { 0, 0, 26, 7, 93, 9, 0 },
			 { 0, 6, 85, 7, 37, 0, 0 },
			 { 0, 1, 43, 7, 80, 4, 0 },
			 { 0, 12, 95, 7, 21, 0, 0 },
			 { 0, 2, 63, 7, 61, 2, 0 },
			 { 0, 0, 23, 7, 94, 11, 0 },
			 { 0, 5, 82, 7, 40, 1, 0 } } },
	.ptrn_arr = { { 0x9324c993, 0xc99324c9, 0x26499324, 0x93264993,
			 0x932649 } },
	.sample_patrn_length = 154,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 46) = 0.410256 */
	.hor_phase_arr = {
		.even = { { 0, 17, 94, 7, 17, 0, 0 },
			 { 0, 3, 69, 7, 55, 1, 0 },
			 { 0, 0, 25, 7, 93, 10, 0 },
			 { 0, 5, 80, 7, 42, 1, 0 },
			 { 0, 0, 36, 7, 86, 6, 0 },
			 { 0, 8, 90, 7, 30, 0, 0 },
			 { 0, 1, 49, 7, 74, 4, 0 },
			 { 0, 13, 94, 7, 21, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 0, 21, 7, 94, 13, 0 },
			 { 0, 4, 74, 7, 49, 1, 0 },
			 { 0, 0, 30, 7, 90, 8, 0 },
			 { 0, 6, 86, 7, 36, 0, 0 },
			 { 0, 1, 42, 7, 80, 5, 0 },
			 { 0, 10, 93, 7, 25, 0, 0 },
			 { 0, 1, 55, 7, 69, 3, 0 } },
		.odd = { { 0, 1, 39, 7, 83, 5, 0 },
			 { 0, 9, 91, 7, 28, 0, 0 },
			 { 0, 1, 52, 7, 72, 3, 0 },
			 { 0, 15, 94, 7, 19, 0, 0 },
			 { 0, 2, 65, 7, 59, 2, 0 },
			 { 0, 0, 23, 7, 93, 12, 0 },
			 { 0, 4, 78, 7, 45, 1, 0 },
			 { 0, 0, 33, 7, 88, 7, 0 },
			 { 0, 7, 88, 7, 33, 0, 0 },
			 { 0, 1, 45, 7, 78, 4, 0 },
			 { 0, 12, 93, 7, 23, 0, 0 },
			 { 0, 2, 59, 7, 65, 2, 0 },
			 { 0, 0, 19, 7, 94, 15, 0 },
			 { 0, 3, 72, 7, 52, 1, 0 },
			 { 0, 0, 28, 7, 91, 9, 0 },
			 { 0, 5, 83, 7, 39, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 17, 94, 7, 17, 0, 0 },
			 { 0, 3, 69, 7, 55, 1, 0 },
			 { 0, 0, 25, 7, 93, 10, 0 },
			 { 0, 5, 80, 7, 42, 1, 0 },
			 { 0, 0, 36, 7, 86, 6, 0 },
			 { 0, 8, 90, 7, 30, 0, 0 },
			 { 0, 1, 49, 7, 74, 4, 0 },
			 { 0, 13, 94, 7, 21, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 0, 21, 7, 94, 13, 0 },
			 { 0, 4, 74, 7, 49, 1, 0 },
			 { 0, 0, 30, 7, 90, 8, 0 },
			 { 0, 6, 86, 7, 36, 0, 0 },
			 { 0, 1, 42, 7, 80, 5, 0 },
			 { 0, 10, 93, 7, 25, 0, 0 },
			 { 0, 1, 55, 7, 69, 3, 0 } },
		.odd = { { 0, 1, 39, 7, 83, 5, 0 },
			 { 0, 9, 91, 7, 28, 0, 0 },
			 { 0, 1, 52, 7, 72, 3, 0 },
			 { 0, 15, 94, 7, 19, 0, 0 },
			 { 0, 2, 65, 7, 59, 2, 0 },
			 { 0, 0, 23, 7, 93, 12, 0 },
			 { 0, 4, 78, 7, 45, 1, 0 },
			 { 0, 0, 33, 7, 88, 7, 0 },
			 { 0, 7, 88, 7, 33, 0, 0 },
			 { 0, 1, 45, 7, 78, 4, 0 },
			 { 0, 12, 93, 7, 23, 0, 0 },
			 { 0, 2, 59, 7, 65, 2, 0 },
			 { 0, 0, 19, 7, 94, 15, 0 },
			 { 0, 3, 72, 7, 52, 1, 0 },
			 { 0, 0, 28, 7, 91, 9, 0 },
			 { 0, 5, 83, 7, 39, 1, 0 } } },
	.ptrn_arr = { { 0x93264993, 0x4c99264c, 0x932 } },
	.sample_patrn_length = 78,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 47) = 0.405063 */
	.hor_phase_arr = {
		.even = { { 0, 17, 94, 7, 17, 0, 0 },
			 { 0, 2, 65, 7, 59, 2, 0 },
			 { 0, 0, 21, 7, 93, 14, 0 },
			 { 0, 3, 72, 7, 52, 1, 0 },
			 { 0, 0, 26, 7, 91, 11, 0 },
			 { 0, 4, 78, 7, 45, 1, 0 },
			 { 0, 0, 31, 7, 88, 9, 0 },
			 { 0, 6, 82, 7, 39, 1, 0 },
			 { 0, 1, 36, 7, 84, 7, 0 },
			 { 0, 8, 87, 7, 33, 0, 0 },
			 { 0, 1, 42, 7, 80, 5, 0 },
			 { 0, 10, 90, 7, 28, 0, 0 },
			 { 0, 1, 49, 7, 74, 4, 0 },
			 { 0, 12, 93, 7, 23, 0, 0 },
			 { 0, 2, 55, 7, 68, 3, 0 },
			 { 0, 15, 94, 7, 19, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 0, 19, 7, 94, 15, 0 },
			 { 0, 3, 68, 7, 55, 2, 0 },
			 { 0, 0, 23, 7, 93, 12, 0 },
			 { 0, 4, 74, 7, 49, 1, 0 },
			 { 0, 0, 28, 7, 90, 10, 0 },
			 { 0, 5, 80, 7, 42, 1, 0 },
			 { 0, 0, 33, 7, 87, 8, 0 },
			 { 0, 7, 84, 7, 36, 1, 0 },
			 { 0, 1, 39, 7, 82, 6, 0 },
			 { 0, 9, 88, 7, 31, 0, 0 },
			 { 0, 1, 45, 7, 78, 4, 0 },
			 { 0, 11, 91, 7, 26, 0, 0 },
			 { 0, 1, 52, 7, 72, 3, 0 },
			 { 0, 14, 93, 7, 21, 0, 0 },
			 { 0, 2, 59, 7, 65, 2, 0 } },
		.odd = { { 0, 1, 38, 7, 83, 6, 0 },
			 { 0, 8, 88, 7, 32, 0, 0 },
			 { 0, 1, 44, 7, 78, 5, 0 },
			 { 0, 10, 91, 7, 27, 0, 0 },
			 { 0, 1, 50, 7, 73, 4, 0 },
			 { 0, 13, 93, 7, 22, 0, 0 },
			 { 0, 2, 57, 7, 66, 3, 0 },
			 { 0, 16, 94, 7, 18, 0, 0 },
			 { 0, 2, 64, 7, 60, 2, 0 },
			 { 0, 0, 20, 7, 93, 15, 0 },
			 { 0, 3, 70, 7, 54, 1, 0 },
			 { 0, 0, 24, 7, 92, 12, 0 },
			 { 0, 4, 76, 7, 47, 1, 0 },
			 { 0, 0, 29, 7, 90, 9, 0 },
			 { 0, 5, 81, 7, 41, 1, 0 },
			 { 0, 0, 35, 7, 86, 7, 0 },
			 { 0, 7, 86, 7, 35, 0, 0 },
			 { 0, 1, 41, 7, 81, 5, 0 },
			 { 0, 9, 90, 7, 29, 0, 0 },
			 { 0, 1, 47, 7, 76, 4, 0 },
			 { 0, 12, 92, 7, 24, 0, 0 },
			 { 0, 1, 54, 7, 70, 3, 0 },
			 { 0, 15, 93, 7, 20, 0, 0 },
			 { 0, 2, 60, 7, 64, 2, 0 },
			 { 0, 0, 18, 7, 94, 16, 0 },
			 { 0, 3, 66, 7, 57, 2, 0 },
			 { 0, 0, 22, 7, 93, 13, 0 },
			 { 0, 4, 73, 7, 50, 1, 0 },
			 { 0, 0, 27, 7, 91, 10, 0 },
			 { 0, 5, 78, 7, 44, 1, 0 },
			 { 0, 0, 32, 7, 88, 8, 0 },
			 { 0, 6, 83, 7, 38, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 17, 94, 7, 17, 0, 0 },
			 { 0, 2, 65, 7, 59, 2, 0 },
			 { 0, 0, 21, 7, 93, 14, 0 },
			 { 0, 3, 72, 7, 52, 1, 0 },
			 { 0, 0, 26, 7, 91, 11, 0 },
			 { 0, 4, 78, 7, 45, 1, 0 },
			 { 0, 0, 31, 7, 88, 9, 0 },
			 { 0, 6, 82, 7, 39, 1, 0 },
			 { 0, 1, 36, 7, 84, 7, 0 },
			 { 0, 8, 87, 7, 33, 0, 0 },
			 { 0, 1, 42, 7, 80, 5, 0 },
			 { 0, 10, 90, 7, 28, 0, 0 },
			 { 0, 1, 49, 7, 74, 4, 0 },
			 { 0, 12, 93, 7, 23, 0, 0 },
			 { 0, 2, 55, 7, 68, 3, 0 },
			 { 0, 15, 94, 7, 19, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 0, 19, 7, 94, 15, 0 },
			 { 0, 3, 68, 7, 55, 2, 0 },
			 { 0, 0, 23, 7, 93, 12, 0 },
			 { 0, 4, 74, 7, 49, 1, 0 },
			 { 0, 0, 28, 7, 90, 10, 0 },
			 { 0, 5, 80, 7, 42, 1, 0 },
			 { 0, 0, 33, 7, 87, 8, 0 },
			 { 0, 7, 84, 7, 36, 1, 0 },
			 { 0, 1, 39, 7, 82, 6, 0 },
			 { 0, 9, 88, 7, 31, 0, 0 },
			 { 0, 1, 45, 7, 78, 4, 0 },
			 { 0, 11, 91, 7, 26, 0, 0 },
			 { 0, 1, 52, 7, 72, 3, 0 },
			 { 0, 14, 93, 7, 21, 0, 0 },
			 { 0, 2, 59, 7, 65, 2, 0 } },
		.odd = { { 0, 1, 38, 7, 83, 6, 0 },
			 { 0, 8, 88, 7, 32, 0, 0 },
			 { 0, 1, 44, 7, 78, 5, 0 },
			 { 0, 10, 91, 7, 27, 0, 0 },
			 { 0, 1, 50, 7, 73, 4, 0 },
			 { 0, 13, 93, 7, 22, 0, 0 },
			 { 0, 2, 57, 7, 66, 3, 0 },
			 { 0, 16, 94, 7, 18, 0, 0 },
			 { 0, 2, 64, 7, 60, 2, 0 },
			 { 0, 0, 20, 7, 93, 15, 0 },
			 { 0, 3, 70, 7, 54, 1, 0 },
			 { 0, 0, 24, 7, 92, 12, 0 },
			 { 0, 4, 76, 7, 47, 1, 0 },
			 { 0, 0, 29, 7, 90, 9, 0 },
			 { 0, 5, 81, 7, 41, 1, 0 },
			 { 0, 0, 35, 7, 86, 7, 0 },
			 { 0, 7, 86, 7, 35, 0, 0 },
			 { 0, 1, 41, 7, 81, 5, 0 },
			 { 0, 9, 90, 7, 29, 0, 0 },
			 { 0, 1, 47, 7, 76, 4, 0 },
			 { 0, 12, 92, 7, 24, 0, 0 },
			 { 0, 1, 54, 7, 70, 3, 0 },
			 { 0, 15, 93, 7, 20, 0, 0 },
			 { 0, 2, 60, 7, 64, 2, 0 },
			 { 0, 0, 18, 7, 94, 16, 0 },
			 { 0, 3, 66, 7, 57, 2, 0 },
			 { 0, 0, 22, 7, 93, 13, 0 },
			 { 0, 4, 73, 7, 50, 1, 0 },
			 { 0, 0, 27, 7, 91, 10, 0 },
			 { 0, 5, 78, 7, 44, 1, 0 },
			 { 0, 0, 32, 7, 88, 8, 0 },
			 { 0, 6, 83, 7, 38, 1, 0 } } },
	.ptrn_arr = { { 0x99264993, 0x24c93264, 0x99264c93, 0x24c99264,
			 0x9324c93 } },
	.sample_patrn_length = 158,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 48) = 0.4 */
	.hor_phase_arr = {
		.even = { { 0, 18, 92, 7, 18, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 } },
		.odd = { { 0, 1, 37, 7, 83, 7, 0 },
			 { 0, 7, 83, 7, 37, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 18, 92, 7, 18, 0, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 } },
		.odd = { { 0, 1, 37, 7, 83, 7, 0 },
			 { 0, 7, 83, 7, 37, 1, 0 } } },
	.ptrn_arr = { { 0x93 } },
	.sample_patrn_length = 10,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 49) = 0.395062 */
	.hor_phase_arr = {
		.even = { { 0, 18, 92, 7, 18, 0, 0 },
			 { 0, 2, 58, 7, 65, 3, 0 },
			 { 0, 15, 91, 7, 22, 0, 0 },
			 { 0, 2, 52, 7, 70, 4, 0 },
			 { 0, 12, 89, 7, 27, 0, 0 },
			 { 0, 1, 46, 7, 76, 5, 0 },
			 { 0, 9, 87, 7, 32, 0, 0 },
			 { 0, 1, 40, 7, 80, 7, 0 },
			 { 0, 7, 83, 7, 37, 1, 0 },
			 { 0, 1, 34, 7, 85, 8, 0 },
			 { 0, 6, 78, 7, 43, 1, 0 },
			 { 0, 0, 29, 7, 88, 11, 0 },
			 { 0, 4, 74, 7, 49, 1, 0 },
			 { 0, 0, 24, 7, 91, 13, 0 },
			 { 0, 3, 68, 7, 55, 2, 0 },
			 { 0, 0, 20, 7, 92, 16, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 16, 92, 7, 20, 0, 0 },
			 { 0, 2, 55, 7, 68, 3, 0 },
			 { 0, 13, 91, 7, 24, 0, 0 },
			 { 0, 1, 49, 7, 74, 4, 0 },
			 { 0, 11, 88, 7, 29, 0, 0 },
			 { 0, 1, 43, 7, 78, 6, 0 },
			 { 0, 8, 85, 7, 34, 1, 0 },
			 { 0, 1, 37, 7, 83, 7, 0 },
			 { 0, 7, 80, 7, 40, 1, 0 },
			 { 0, 0, 32, 7, 87, 9, 0 },
			 { 0, 5, 76, 7, 46, 1, 0 },
			 { 0, 0, 27, 7, 89, 12, 0 },
			 { 0, 4, 70, 7, 52, 2, 0 },
			 { 0, 0, 22, 7, 91, 15, 0 },
			 { 0, 3, 65, 7, 58, 2, 0 } },
		.odd = { { 0, 1, 36, 7, 83, 8, 0 },
			 { 0, 6, 80, 7, 41, 1, 0 },
			 { 0, 0, 30, 7, 88, 10, 0 },
			 { 0, 5, 75, 7, 47, 1, 0 },
			 { 0, 0, 25, 7, 90, 13, 0 },
			 { 0, 4, 68, 7, 54, 2, 0 },
			 { 0, 0, 21, 7, 91, 16, 0 },
			 { 0, 3, 63, 7, 60, 2, 0 },
			 { 0, 17, 92, 7, 19, 0, 0 },
			 { 0, 2, 57, 7, 66, 3, 0 },
			 { 0, 14, 91, 7, 23, 0, 0 },
			 { 0, 1, 51, 7, 72, 4, 0 },
			 { 0, 11, 89, 7, 28, 0, 0 },
			 { 0, 1, 44, 7, 78, 5, 0 },
			 { 0, 9, 85, 7, 33, 1, 0 },
			 { 0, 1, 38, 7, 82, 7, 0 },
			 { 0, 7, 82, 7, 38, 1, 0 },
			 { 0, 1, 33, 7, 85, 9, 0 },
			 { 0, 5, 78, 7, 44, 1, 0 },
			 { 0, 0, 28, 7, 89, 11, 0 },
			 { 0, 4, 72, 7, 51, 1, 0 },
			 { 0, 0, 23, 7, 91, 14, 0 },
			 { 0, 3, 66, 7, 57, 2, 0 },
			 { 0, 0, 19, 7, 92, 17, 0 },
			 { 0, 2, 60, 7, 63, 3, 0 },
			 { 0, 16, 91, 7, 21, 0, 0 },
			 { 0, 2, 54, 7, 68, 4, 0 },
			 { 0, 13, 90, 7, 25, 0, 0 },
			 { 0, 1, 47, 7, 75, 5, 0 },
			 { 0, 10, 88, 7, 30, 0, 0 },
			 { 0, 1, 41, 7, 80, 6, 0 },
			 { 0, 8, 83, 7, 36, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 18, 92, 7, 18, 0, 0 },
			 { 0, 2, 58, 7, 65, 3, 0 },
			 { 0, 15, 91, 7, 22, 0, 0 },
			 { 0, 2, 52, 7, 70, 4, 0 },
			 { 0, 12, 89, 7, 27, 0, 0 },
			 { 0, 1, 46, 7, 76, 5, 0 },
			 { 0, 9, 87, 7, 32, 0, 0 },
			 { 0, 1, 40, 7, 80, 7, 0 },
			 { 0, 7, 83, 7, 37, 1, 0 },
			 { 0, 1, 34, 7, 85, 8, 0 },
			 { 0, 6, 78, 7, 43, 1, 0 },
			 { 0, 0, 29, 7, 88, 11, 0 },
			 { 0, 4, 74, 7, 49, 1, 0 },
			 { 0, 0, 24, 7, 91, 13, 0 },
			 { 0, 3, 68, 7, 55, 2, 0 },
			 { 0, 0, 20, 7, 92, 16, 0 },
			 { 0, 2, 62, 7, 62, 2, 0 },
			 { 0, 16, 92, 7, 20, 0, 0 },
			 { 0, 2, 55, 7, 68, 3, 0 },
			 { 0, 13, 91, 7, 24, 0, 0 },
			 { 0, 1, 49, 7, 74, 4, 0 },
			 { 0, 11, 88, 7, 29, 0, 0 },
			 { 0, 1, 43, 7, 78, 6, 0 },
			 { 0, 8, 85, 7, 34, 1, 0 },
			 { 0, 1, 37, 7, 83, 7, 0 },
			 { 0, 7, 80, 7, 40, 1, 0 },
			 { 0, 0, 32, 7, 87, 9, 0 },
			 { 0, 5, 76, 7, 46, 1, 0 },
			 { 0, 0, 27, 7, 89, 12, 0 },
			 { 0, 4, 70, 7, 52, 2, 0 },
			 { 0, 0, 22, 7, 91, 15, 0 },
			 { 0, 3, 65, 7, 58, 2, 0 } },
		.odd = { { 0, 1, 36, 7, 83, 8, 0 },
			 { 0, 6, 80, 7, 41, 1, 0 },
			 { 0, 0, 30, 7, 88, 10, 0 },
			 { 0, 5, 75, 7, 47, 1, 0 },
			 { 0, 0, 25, 7, 90, 13, 0 },
			 { 0, 4, 68, 7, 54, 2, 0 },
			 { 0, 0, 21, 7, 91, 16, 0 },
			 { 0, 3, 63, 7, 60, 2, 0 },
			 { 0, 17, 92, 7, 19, 0, 0 },
			 { 0, 2, 57, 7, 66, 3, 0 },
			 { 0, 14, 91, 7, 23, 0, 0 },
			 { 0, 1, 51, 7, 72, 4, 0 },
			 { 0, 11, 89, 7, 28, 0, 0 },
			 { 0, 1, 44, 7, 78, 5, 0 },
			 { 0, 9, 85, 7, 33, 1, 0 },
			 { 0, 1, 38, 7, 82, 7, 0 },
			 { 0, 7, 82, 7, 38, 1, 0 },
			 { 0, 1, 33, 7, 85, 9, 0 },
			 { 0, 5, 78, 7, 44, 1, 0 },
			 { 0, 0, 28, 7, 89, 11, 0 },
			 { 0, 4, 72, 7, 51, 1, 0 },
			 { 0, 0, 23, 7, 91, 14, 0 },
			 { 0, 3, 66, 7, 57, 2, 0 },
			 { 0, 0, 19, 7, 92, 17, 0 },
			 { 0, 2, 60, 7, 63, 3, 0 },
			 { 0, 16, 91, 7, 21, 0, 0 },
			 { 0, 2, 54, 7, 68, 4, 0 },
			 { 0, 13, 90, 7, 25, 0, 0 },
			 { 0, 1, 47, 7, 75, 5, 0 },
			 { 0, 10, 88, 7, 30, 0, 0 },
			 { 0, 1, 41, 7, 80, 6, 0 },
			 { 0, 8, 83, 7, 36, 1, 0 } } },
	.ptrn_arr = { { 0xc9324c93, 0x92649924, 0x24c92649, 0x49324c93,
			 0x92649926 } },
	.sample_patrn_length = 162,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 50) = 0.390244 */
	.hor_phase_arr = {
		.even = { { 0, 19, 90, 7, 19, 0, 0 },
			 { 0, 2, 55, 7, 67, 4, 0 },
			 { 0, 12, 89, 7, 27, 0, 0 },
			 { 0, 1, 43, 7, 78, 6, 0 },
			 { 0, 8, 82, 7, 37, 1, 0 },
			 { 0, 1, 32, 7, 85, 10, 0 },
			 { 0, 5, 73, 7, 49, 1, 0 },
			 { 0, 0, 23, 7, 90, 15, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 15, 90, 7, 23, 0, 0 },
			 { 0, 1, 49, 7, 73, 5, 0 },
			 { 0, 10, 85, 7, 32, 1, 0 },
			 { 0, 1, 37, 7, 82, 8, 0 },
			 { 0, 6, 78, 7, 43, 1, 0 },
			 { 0, 0, 27, 7, 89, 12, 0 },
			 { 0, 4, 67, 7, 55, 2, 0 } },
		.odd = { { 0, 1, 35, 7, 83, 9, 0 },
			 { 0, 5, 76, 7, 46, 1, 0 },
			 { 0, 0, 25, 7, 89, 14, 0 },
			 { 0, 3, 65, 7, 58, 2, 0 },
			 { 0, 17, 90, 7, 21, 0, 0 },
			 { 0, 2, 52, 7, 70, 4, 0 },
			 { 0, 11, 88, 7, 29, 0, 0 },
			 { 0, 1, 40, 7, 80, 7, 0 },
			 { 0, 7, 80, 7, 40, 1, 0 },
			 { 0, 0, 29, 7, 88, 11, 0 },
			 { 0, 4, 70, 7, 52, 2, 0 },
			 { 0, 0, 21, 7, 90, 17, 0 },
			 { 0, 2, 58, 7, 65, 3, 0 },
			 { 0, 14, 89, 7, 25, 0, 0 },
			 { 0, 1, 46, 7, 76, 5, 0 },
			 { 0, 9, 83, 7, 35, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 19, 90, 7, 19, 0, 0 },
			 { 0, 2, 55, 7, 67, 4, 0 },
			 { 0, 12, 89, 7, 27, 0, 0 },
			 { 0, 1, 43, 7, 78, 6, 0 },
			 { 0, 8, 82, 7, 37, 1, 0 },
			 { 0, 1, 32, 7, 85, 10, 0 },
			 { 0, 5, 73, 7, 49, 1, 0 },
			 { 0, 0, 23, 7, 90, 15, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 15, 90, 7, 23, 0, 0 },
			 { 0, 1, 49, 7, 73, 5, 0 },
			 { 0, 10, 85, 7, 32, 1, 0 },
			 { 0, 1, 37, 7, 82, 8, 0 },
			 { 0, 6, 78, 7, 43, 1, 0 },
			 { 0, 0, 27, 7, 89, 12, 0 },
			 { 0, 4, 67, 7, 55, 2, 0 } },
		.odd = { { 0, 1, 35, 7, 83, 9, 0 },
			 { 0, 5, 76, 7, 46, 1, 0 },
			 { 0, 0, 25, 7, 89, 14, 0 },
			 { 0, 3, 65, 7, 58, 2, 0 },
			 { 0, 17, 90, 7, 21, 0, 0 },
			 { 0, 2, 52, 7, 70, 4, 0 },
			 { 0, 11, 88, 7, 29, 0, 0 },
			 { 0, 1, 40, 7, 80, 7, 0 },
			 { 0, 7, 80, 7, 40, 1, 0 },
			 { 0, 0, 29, 7, 88, 11, 0 },
			 { 0, 4, 70, 7, 52, 2, 0 },
			 { 0, 0, 21, 7, 90, 17, 0 },
			 { 0, 2, 58, 7, 65, 3, 0 },
			 { 0, 14, 89, 7, 25, 0, 0 },
			 { 0, 1, 46, 7, 76, 5, 0 },
			 { 0, 9, 83, 7, 35, 1, 0 } } },
	.ptrn_arr = { { 0x49924c93, 0x9324c926, 0x9264 } },
	.sample_patrn_length = 82,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 51) = 0.385542 */
	.hor_phase_arr = {
		.even = { { 0, 19, 90, 7, 19, 0, 0 },
			 { 0, 2, 52, 7, 70, 4, 0 },
			 { 0, 10, 85, 7, 32, 1, 0 },
			 { 0, 1, 35, 7, 83, 9, 0 },
			 { 0, 5, 72, 7, 49, 2, 0 },
			 { 0, 0, 21, 7, 90, 17, 0 },
			 { 0, 2, 55, 7, 67, 4, 0 },
			 { 0, 11, 87, 7, 30, 0, 0 },
			 { 0, 1, 38, 7, 81, 8, 0 },
			 { 0, 6, 75, 7, 46, 1, 0 },
			 { 0, 0, 23, 7, 89, 16, 0 },
			 { 0, 2, 58, 7, 65, 3, 0 },
			 { 0, 13, 87, 7, 28, 0, 0 },
			 { 0, 1, 41, 7, 79, 7, 0 },
			 { 0, 6, 78, 7, 43, 1, 0 },
			 { 0, 0, 25, 7, 89, 14, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 14, 89, 7, 25, 0, 0 },
			 { 0, 1, 43, 7, 78, 6, 0 },
			 { 0, 7, 79, 7, 41, 1, 0 },
			 { 0, 0, 28, 7, 87, 13, 0 },
			 { 0, 3, 65, 7, 58, 2, 0 },
			 { 0, 16, 89, 7, 23, 0, 0 },
			 { 0, 1, 46, 7, 75, 6, 0 },
			 { 0, 8, 81, 7, 38, 1, 0 },
			 { 0, 0, 30, 7, 87, 11, 0 },
			 { 0, 4, 67, 7, 55, 2, 0 },
			 { 0, 17, 90, 7, 21, 0, 0 },
			 { 0, 2, 49, 7, 72, 5, 0 },
			 { 0, 9, 83, 7, 35, 1, 0 },
			 { 0, 1, 32, 7, 85, 10, 0 },
			 { 0, 4, 70, 7, 52, 2, 0 } },
		.odd = { { 0, 1, 34, 7, 83, 10, 0 },
			 { 0, 5, 70, 7, 51, 2, 0 },
			 { 0, 0, 20, 7, 90, 18, 0 },
			 { 0, 2, 54, 7, 68, 4, 0 },
			 { 0, 11, 85, 7, 31, 1, 0 },
			 { 0, 1, 36, 7, 82, 9, 0 },
			 { 0, 5, 74, 7, 48, 1, 0 },
			 { 0, 0, 22, 7, 89, 17, 0 },
			 { 0, 2, 57, 7, 65, 4, 0 },
			 { 0, 12, 87, 7, 29, 0, 0 },
			 { 0, 1, 39, 7, 80, 8, 0 },
			 { 0, 6, 76, 7, 45, 1, 0 },
			 { 0, 0, 24, 7, 89, 15, 0 },
			 { 0, 3, 60, 7, 62, 3, 0 },
			 { 0, 13, 89, 7, 26, 0, 0 },
			 { 0, 1, 42, 7, 78, 7, 0 },
			 { 0, 7, 78, 7, 42, 1, 0 },
			 { 0, 0, 26, 7, 89, 13, 0 },
			 { 0, 3, 62, 7, 60, 3, 0 },
			 { 0, 15, 89, 7, 24, 0, 0 },
			 { 0, 1, 45, 7, 76, 6, 0 },
			 { 0, 8, 80, 7, 39, 1, 0 },
			 { 0, 0, 29, 7, 87, 12, 0 },
			 { 0, 4, 65, 7, 57, 2, 0 },
			 { 0, 17, 89, 7, 22, 0, 0 },
			 { 0, 1, 48, 7, 74, 5, 0 },
			 { 0, 9, 82, 7, 36, 1, 0 },
			 { 0, 1, 31, 7, 85, 11, 0 },
			 { 0, 4, 68, 7, 54, 2, 0 },
			 { 0, 18, 90, 7, 20, 0, 0 },
			 { 0, 2, 51, 7, 70, 5, 0 },
			 { 0, 10, 83, 7, 34, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 19, 90, 7, 19, 0, 0 },
			 { 0, 2, 52, 7, 70, 4, 0 },
			 { 0, 10, 85, 7, 32, 1, 0 },
			 { 0, 1, 35, 7, 83, 9, 0 },
			 { 0, 5, 72, 7, 49, 2, 0 },
			 { 0, 0, 21, 7, 90, 17, 0 },
			 { 0, 2, 55, 7, 67, 4, 0 },
			 { 0, 11, 87, 7, 30, 0, 0 },
			 { 0, 1, 38, 7, 81, 8, 0 },
			 { 0, 6, 75, 7, 46, 1, 0 },
			 { 0, 0, 23, 7, 89, 16, 0 },
			 { 0, 2, 58, 7, 65, 3, 0 },
			 { 0, 13, 87, 7, 28, 0, 0 },
			 { 0, 1, 41, 7, 79, 7, 0 },
			 { 0, 6, 78, 7, 43, 1, 0 },
			 { 0, 0, 25, 7, 89, 14, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 14, 89, 7, 25, 0, 0 },
			 { 0, 1, 43, 7, 78, 6, 0 },
			 { 0, 7, 79, 7, 41, 1, 0 },
			 { 0, 0, 28, 7, 87, 13, 0 },
			 { 0, 3, 65, 7, 58, 2, 0 },
			 { 0, 16, 89, 7, 23, 0, 0 },
			 { 0, 1, 46, 7, 75, 6, 0 },
			 { 0, 8, 81, 7, 38, 1, 0 },
			 { 0, 0, 30, 7, 87, 11, 0 },
			 { 0, 4, 67, 7, 55, 2, 0 },
			 { 0, 17, 90, 7, 21, 0, 0 },
			 { 0, 2, 49, 7, 72, 5, 0 },
			 { 0, 9, 83, 7, 35, 1, 0 },
			 { 0, 1, 32, 7, 85, 10, 0 },
			 { 0, 4, 70, 7, 52, 2, 0 } },
		.odd = { { 0, 1, 34, 7, 83, 10, 0 },
			 { 0, 5, 70, 7, 51, 2, 0 },
			 { 0, 0, 20, 7, 90, 18, 0 },
			 { 0, 2, 54, 7, 68, 4, 0 },
			 { 0, 11, 85, 7, 31, 1, 0 },
			 { 0, 1, 36, 7, 82, 9, 0 },
			 { 0, 5, 74, 7, 48, 1, 0 },
			 { 0, 0, 22, 7, 89, 17, 0 },
			 { 0, 2, 57, 7, 65, 4, 0 },
			 { 0, 12, 87, 7, 29, 0, 0 },
			 { 0, 1, 39, 7, 80, 8, 0 },
			 { 0, 6, 76, 7, 45, 1, 0 },
			 { 0, 0, 24, 7, 89, 15, 0 },
			 { 0, 3, 60, 7, 62, 3, 0 },
			 { 0, 13, 89, 7, 26, 0, 0 },
			 { 0, 1, 42, 7, 78, 7, 0 },
			 { 0, 7, 78, 7, 42, 1, 0 },
			 { 0, 0, 26, 7, 89, 13, 0 },
			 { 0, 3, 62, 7, 60, 3, 0 },
			 { 0, 15, 89, 7, 24, 0, 0 },
			 { 0, 1, 45, 7, 76, 6, 0 },
			 { 0, 8, 80, 7, 39, 1, 0 },
			 { 0, 0, 29, 7, 87, 12, 0 },
			 { 0, 4, 65, 7, 57, 2, 0 },
			 { 0, 17, 89, 7, 22, 0, 0 },
			 { 0, 1, 48, 7, 74, 5, 0 },
			 { 0, 9, 82, 7, 36, 1, 0 },
			 { 0, 1, 31, 7, 85, 11, 0 },
			 { 0, 4, 68, 7, 54, 2, 0 },
			 { 0, 18, 90, 7, 20, 0, 0 },
			 { 0, 2, 51, 7, 70, 5, 0 },
			 { 0, 10, 83, 7, 34, 1, 0 } } },
	.ptrn_arr = { { 0x49924c93, 0xc9264932, 0x93249924, 0x924c9264,
			 0x26493249, 0x9 } },
	.sample_patrn_length = 166,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 52) = 0.380952 */
	.hor_phase_arr = {
		.even = { { 0, 20, 88, 7, 20, 0, 0 },
			 { 0, 2, 49, 7, 72, 5, 0 },
			 { 0, 8, 81, 7, 38, 1, 0 },
			 { 0, 0, 28, 7, 87, 13, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 13, 87, 7, 28, 0, 0 },
			 { 0, 1, 38, 7, 81, 8, 0 },
			 { 0, 5, 72, 7, 49, 2, 0 } },
		.odd = { { 0, 1, 33, 7, 83, 11, 0 },
			 { 0, 4, 67, 7, 55, 2, 0 },
			 { 0, 16, 88, 7, 24, 0, 0 },
			 { 0, 1, 44, 7, 76, 7, 0 },
			 { 0, 7, 76, 7, 44, 1, 0 },
			 { 0, 0, 24, 7, 88, 16, 0 },
			 { 0, 2, 55, 7, 67, 4, 0 },
			 { 0, 11, 83, 7, 33, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 20, 88, 7, 20, 0, 0 },
			 { 0, 2, 49, 7, 72, 5, 0 },
			 { 0, 8, 81, 7, 38, 1, 0 },
			 { 0, 0, 28, 7, 87, 13, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 13, 87, 7, 28, 0, 0 },
			 { 0, 1, 38, 7, 81, 8, 0 },
			 { 0, 5, 72, 7, 49, 2, 0 } },
		.odd = { { 0, 1, 33, 7, 83, 11, 0 },
			 { 0, 4, 67, 7, 55, 2, 0 },
			 { 0, 16, 88, 7, 24, 0, 0 },
			 { 0, 1, 44, 7, 76, 7, 0 },
			 { 0, 7, 76, 7, 44, 1, 0 },
			 { 0, 0, 24, 7, 88, 16, 0 },
			 { 0, 2, 55, 7, 67, 4, 0 },
			 { 0, 11, 83, 7, 33, 1, 0 } } },
	.ptrn_arr = { { 0x4c926493, 0x92 } },
	.sample_patrn_length = 42,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 53) = 0.376471 */
	.hor_phase_arr = {
		.even = { { 0, 20, 88, 7, 20, 0, 0 },
			 { 0, 2, 47, 7, 73, 6, 0 },
			 { 0, 7, 76, 7, 44, 1, 0 },
			 { 0, 0, 22, 7, 88, 18, 0 },
			 { 0, 2, 49, 7, 72, 5, 0 },
			 { 0, 8, 78, 7, 41, 1, 0 },
			 { 0, 0, 24, 7, 87, 17, 0 },
			 { 0, 2, 52, 7, 69, 5, 0 },
			 { 0, 9, 80, 7, 38, 1, 0 },
			 { 0, 0, 26, 7, 87, 15, 0 },
			 { 0, 2, 55, 7, 67, 4, 0 },
			 { 0, 10, 81, 7, 36, 1, 0 },
			 { 0, 1, 28, 7, 85, 14, 0 },
			 { 0, 3, 58, 7, 63, 4, 0 },
			 { 0, 11, 83, 7, 33, 1, 0 },
			 { 0, 1, 31, 7, 84, 12, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 12, 84, 7, 31, 1, 0 },
			 { 0, 1, 33, 7, 83, 11, 0 },
			 { 0, 4, 63, 7, 58, 3, 0 },
			 { 0, 14, 85, 7, 28, 1, 0 },
			 { 0, 1, 36, 7, 81, 10, 0 },
			 { 0, 4, 67, 7, 55, 2, 0 },
			 { 0, 15, 87, 7, 26, 0, 0 },
			 { 0, 1, 38, 7, 80, 9, 0 },
			 { 0, 5, 69, 7, 52, 2, 0 },
			 { 0, 17, 87, 7, 24, 0, 0 },
			 { 0, 1, 41, 7, 78, 8, 0 },
			 { 0, 5, 72, 7, 49, 2, 0 },
			 { 0, 18, 88, 7, 22, 0, 0 },
			 { 0, 1, 44, 7, 76, 7, 0 },
			 { 0, 6, 73, 7, 47, 2, 0 } },
		.odd = { { 0, 1, 32, 7, 83, 12, 0 },
			 { 0, 3, 63, 7, 59, 3, 0 },
			 { 0, 13, 84, 7, 30, 1, 0 },
			 { 0, 1, 34, 7, 83, 10, 0 },
			 { 0, 4, 64, 7, 57, 3, 0 },
			 { 0, 14, 87, 7, 27, 0, 0 },
			 { 0, 1, 37, 7, 81, 9, 0 },
			 { 0, 5, 67, 7, 54, 2, 0 },
			 { 0, 16, 87, 7, 25, 0, 0 },
			 { 0, 1, 40, 7, 79, 8, 0 },
			 { 0, 5, 70, 7, 51, 2, 0 },
			 { 0, 18, 87, 7, 23, 0, 0 },
			 { 0, 1, 42, 7, 78, 7, 0 },
			 { 0, 6, 72, 7, 48, 2, 0 },
			 { 0, 19, 88, 7, 21, 0, 0 },
			 { 0, 1, 45, 7, 75, 7, 0 },
			 { 0, 7, 75, 7, 45, 1, 0 },
			 { 0, 0, 21, 7, 88, 19, 0 },
			 { 0, 2, 48, 7, 72, 6, 0 },
			 { 0, 7, 78, 7, 42, 1, 0 },
			 { 0, 0, 23, 7, 87, 18, 0 },
			 { 0, 2, 51, 7, 70, 5, 0 },
			 { 0, 8, 79, 7, 40, 1, 0 },
			 { 0, 0, 25, 7, 87, 16, 0 },
			 { 0, 2, 54, 7, 67, 5, 0 },
			 { 0, 9, 81, 7, 37, 1, 0 },
			 { 0, 0, 27, 7, 87, 14, 0 },
			 { 0, 3, 57, 7, 64, 4, 0 },
			 { 0, 10, 83, 7, 34, 1, 0 },
			 { 0, 1, 30, 7, 84, 13, 0 },
			 { 0, 3, 59, 7, 63, 3, 0 },
			 { 0, 12, 83, 7, 32, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 20, 88, 7, 20, 0, 0 },
			 { 0, 2, 47, 7, 73, 6, 0 },
			 { 0, 7, 76, 7, 44, 1, 0 },
			 { 0, 0, 22, 7, 88, 18, 0 },
			 { 0, 2, 49, 7, 72, 5, 0 },
			 { 0, 8, 78, 7, 41, 1, 0 },
			 { 0, 0, 24, 7, 87, 17, 0 },
			 { 0, 2, 52, 7, 69, 5, 0 },
			 { 0, 9, 80, 7, 38, 1, 0 },
			 { 0, 0, 26, 7, 87, 15, 0 },
			 { 0, 2, 55, 7, 67, 4, 0 },
			 { 0, 10, 81, 7, 36, 1, 0 },
			 { 0, 1, 28, 7, 85, 14, 0 },
			 { 0, 3, 58, 7, 63, 4, 0 },
			 { 0, 11, 83, 7, 33, 1, 0 },
			 { 0, 1, 31, 7, 84, 12, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 12, 84, 7, 31, 1, 0 },
			 { 0, 1, 33, 7, 83, 11, 0 },
			 { 0, 4, 63, 7, 58, 3, 0 },
			 { 0, 14, 85, 7, 28, 1, 0 },
			 { 0, 1, 36, 7, 81, 10, 0 },
			 { 0, 4, 67, 7, 55, 2, 0 },
			 { 0, 15, 87, 7, 26, 0, 0 },
			 { 0, 1, 38, 7, 80, 9, 0 },
			 { 0, 5, 69, 7, 52, 2, 0 },
			 { 0, 17, 87, 7, 24, 0, 0 },
			 { 0, 1, 41, 7, 78, 8, 0 },
			 { 0, 5, 72, 7, 49, 2, 0 },
			 { 0, 18, 88, 7, 22, 0, 0 },
			 { 0, 1, 44, 7, 76, 7, 0 },
			 { 0, 6, 73, 7, 47, 2, 0 } },
		.odd = { { 0, 1, 32, 7, 83, 12, 0 },
			 { 0, 3, 63, 7, 59, 3, 0 },
			 { 0, 13, 84, 7, 30, 1, 0 },
			 { 0, 1, 34, 7, 83, 10, 0 },
			 { 0, 4, 64, 7, 57, 3, 0 },
			 { 0, 14, 87, 7, 27, 0, 0 },
			 { 0, 1, 37, 7, 81, 9, 0 },
			 { 0, 5, 67, 7, 54, 2, 0 },
			 { 0, 16, 87, 7, 25, 0, 0 },
			 { 0, 1, 40, 7, 79, 8, 0 },
			 { 0, 5, 70, 7, 51, 2, 0 },
			 { 0, 18, 87, 7, 23, 0, 0 },
			 { 0, 1, 42, 7, 78, 7, 0 },
			 { 0, 6, 72, 7, 48, 2, 0 },
			 { 0, 19, 88, 7, 21, 0, 0 },
			 { 0, 1, 45, 7, 75, 7, 0 },
			 { 0, 7, 75, 7, 45, 1, 0 },
			 { 0, 0, 21, 7, 88, 19, 0 },
			 { 0, 2, 48, 7, 72, 6, 0 },
			 { 0, 7, 78, 7, 42, 1, 0 },
			 { 0, 0, 23, 7, 87, 18, 0 },
			 { 0, 2, 51, 7, 70, 5, 0 },
			 { 0, 8, 79, 7, 40, 1, 0 },
			 { 0, 0, 25, 7, 87, 16, 0 },
			 { 0, 2, 54, 7, 67, 5, 0 },
			 { 0, 9, 81, 7, 37, 1, 0 },
			 { 0, 0, 27, 7, 87, 14, 0 },
			 { 0, 3, 57, 7, 64, 4, 0 },
			 { 0, 10, 83, 7, 34, 1, 0 },
			 { 0, 1, 30, 7, 84, 13, 0 },
			 { 0, 3, 59, 7, 63, 3, 0 },
			 { 0, 12, 83, 7, 32, 1, 0 } } },
	.ptrn_arr = { { 0x64926493, 0x64926492, 0x4c926492, 0x4c924c92,
			 0x4c924c92, 0x92 } },
	.sample_patrn_length = 170,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 54) = 0.372093 */
	.hor_phase_arr = {
		.even = { { 0, 21, 86, 7, 21, 0, 0 },
			 { 0, 1, 44, 7, 76, 7, 0 },
			 { 0, 6, 71, 7, 49, 2, 0 },
			 { 0, 17, 86, 7, 25, 0, 0 },
			 { 0, 1, 39, 7, 79, 9, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 14, 84, 7, 29, 1, 0 },
			 { 0, 1, 34, 7, 82, 11, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 11, 82, 7, 34, 1, 0 },
			 { 0, 1, 29, 7, 84, 14, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 9, 79, 7, 39, 1, 0 },
			 { 0, 0, 25, 7, 86, 17, 0 },
			 { 0, 2, 49, 7, 71, 6, 0 },
			 { 0, 7, 76, 7, 44, 1, 0 } },
		.odd = { { 0, 1, 31, 7, 83, 13, 0 },
			 { 0, 3, 58, 7, 63, 4, 0 },
			 { 0, 10, 81, 7, 36, 1, 0 },
			 { 0, 0, 27, 7, 85, 16, 0 },
			 { 0, 2, 52, 7, 69, 5, 0 },
			 { 0, 8, 78, 7, 41, 1, 0 },
			 { 0, 0, 23, 7, 86, 19, 0 },
			 { 0, 2, 47, 7, 72, 7, 0 },
			 { 0, 7, 72, 7, 47, 2, 0 },
			 { 0, 19, 86, 7, 23, 0, 0 },
			 { 0, 1, 41, 7, 78, 8, 0 },
			 { 0, 5, 69, 7, 52, 2, 0 },
			 { 0, 16, 85, 7, 27, 0, 0 },
			 { 0, 1, 36, 7, 81, 10, 0 },
			 { 0, 4, 63, 7, 58, 3, 0 },
			 { 0, 13, 83, 7, 31, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 21, 86, 7, 21, 0, 0 },
			 { 0, 1, 44, 7, 76, 7, 0 },
			 { 0, 6, 71, 7, 49, 2, 0 },
			 { 0, 17, 86, 7, 25, 0, 0 },
			 { 0, 1, 39, 7, 79, 9, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 14, 84, 7, 29, 1, 0 },
			 { 0, 1, 34, 7, 82, 11, 0 },
			 { 0, 3, 61, 7, 61, 3, 0 },
			 { 0, 11, 82, 7, 34, 1, 0 },
			 { 0, 1, 29, 7, 84, 14, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 9, 79, 7, 39, 1, 0 },
			 { 0, 0, 25, 7, 86, 17, 0 },
			 { 0, 2, 49, 7, 71, 6, 0 },
			 { 0, 7, 76, 7, 44, 1, 0 } },
		.odd = { { 0, 1, 31, 7, 83, 13, 0 },
			 { 0, 3, 58, 7, 63, 4, 0 },
			 { 0, 10, 81, 7, 36, 1, 0 },
			 { 0, 0, 27, 7, 85, 16, 0 },
			 { 0, 2, 52, 7, 69, 5, 0 },
			 { 0, 8, 78, 7, 41, 1, 0 },
			 { 0, 0, 23, 7, 86, 19, 0 },
			 { 0, 2, 47, 7, 72, 7, 0 },
			 { 0, 7, 72, 7, 47, 2, 0 },
			 { 0, 19, 86, 7, 23, 0, 0 },
			 { 0, 1, 41, 7, 78, 8, 0 },
			 { 0, 5, 69, 7, 52, 2, 0 },
			 { 0, 16, 85, 7, 27, 0, 0 },
			 { 0, 1, 36, 7, 81, 10, 0 },
			 { 0, 4, 63, 7, 58, 3, 0 },
			 { 0, 13, 83, 7, 31, 1, 0 } } },
	.ptrn_arr = { { 0x24932493, 0x24992493, 0x92499 } },
	.sample_patrn_length = 86,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 55) = 0.367816 */
	.hor_phase_arr = {
		.even = { { 0, 21, 86, 7, 21, 0, 0 },
			 { 0, 1, 41, 7, 77, 9, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 13, 82, 7, 32, 1, 0 },
			 { 0, 1, 29, 7, 83, 15, 0 },
			 { 0, 2, 52, 7, 69, 5, 0 },
			 { 0, 8, 74, 7, 44, 2, 0 },
			 { 0, 19, 86, 7, 23, 0, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 4, 63, 7, 58, 3, 0 },
			 { 0, 12, 81, 7, 34, 1, 0 },
			 { 0, 1, 27, 7, 84, 16, 0 },
			 { 0, 2, 50, 7, 70, 6, 0 },
			 { 0, 7, 72, 7, 47, 2, 0 },
			 { 0, 18, 85, 7, 25, 0, 0 },
			 { 0, 1, 36, 7, 80, 11, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 11, 80, 7, 36, 1, 0 },
			 { 0, 0, 25, 7, 85, 18, 0 },
			 { 0, 2, 47, 7, 72, 7, 0 },
			 { 0, 6, 70, 7, 50, 2, 0 },
			 { 0, 16, 84, 7, 27, 1, 0 },
			 { 0, 1, 34, 7, 81, 12, 0 },
			 { 0, 3, 58, 7, 63, 4, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 },
			 { 0, 0, 23, 7, 86, 19, 0 },
			 { 0, 2, 44, 7, 74, 8, 0 },
			 { 0, 5, 69, 7, 52, 2, 0 },
			 { 0, 15, 83, 7, 29, 1, 0 },
			 { 0, 1, 32, 7, 82, 13, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 9, 77, 7, 41, 1, 0 } },
		.odd = { { 0, 1, 30, 7, 83, 14, 0 },
			 { 0, 3, 54, 7, 66, 5, 0 },
			 { 0, 8, 76, 7, 43, 1, 0 },
			 { 0, 20, 86, 7, 22, 0, 0 },
			 { 0, 1, 40, 7, 78, 9, 0 },
			 { 0, 4, 65, 7, 56, 3, 0 },
			 { 0, 13, 81, 7, 33, 1, 0 },
			 { 0, 1, 28, 7, 84, 15, 0 },
			 { 0, 2, 51, 7, 69, 6, 0 },
			 { 0, 7, 74, 7, 45, 2, 0 },
			 { 0, 18, 86, 7, 24, 0, 0 },
			 { 0, 1, 38, 7, 79, 10, 0 },
			 { 0, 4, 62, 7, 59, 3, 0 },
			 { 0, 11, 81, 7, 35, 1, 0 },
			 { 0, 0, 26, 7, 85, 17, 0 },
			 { 0, 2, 48, 7, 72, 6, 0 },
			 { 0, 6, 72, 7, 48, 2, 0 },
			 { 0, 17, 85, 7, 26, 0, 0 },
			 { 0, 1, 35, 7, 81, 11, 0 },
			 { 0, 3, 59, 7, 62, 4, 0 },
			 { 0, 10, 79, 7, 38, 1, 0 },
			 { 0, 0, 24, 7, 86, 18, 0 },
			 { 0, 2, 45, 7, 74, 7, 0 },
			 { 0, 6, 69, 7, 51, 2, 0 },
			 { 0, 15, 84, 7, 28, 1, 0 },
			 { 0, 1, 33, 7, 81, 13, 0 },
			 { 0, 3, 56, 7, 65, 4, 0 },
			 { 0, 9, 78, 7, 40, 1, 0 },
			 { 0, 0, 22, 7, 86, 20, 0 },
			 { 0, 1, 43, 7, 76, 8, 0 },
			 { 0, 5, 66, 7, 54, 3, 0 },
			 { 0, 14, 83, 7, 30, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 21, 86, 7, 21, 0, 0 },
			 { 0, 1, 41, 7, 77, 9, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 13, 82, 7, 32, 1, 0 },
			 { 0, 1, 29, 7, 83, 15, 0 },
			 { 0, 2, 52, 7, 69, 5, 0 },
			 { 0, 8, 74, 7, 44, 2, 0 },
			 { 0, 19, 86, 7, 23, 0, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 4, 63, 7, 58, 3, 0 },
			 { 0, 12, 81, 7, 34, 1, 0 },
			 { 0, 1, 27, 7, 84, 16, 0 },
			 { 0, 2, 50, 7, 70, 6, 0 },
			 { 0, 7, 72, 7, 47, 2, 0 },
			 { 0, 18, 85, 7, 25, 0, 0 },
			 { 0, 1, 36, 7, 80, 11, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 11, 80, 7, 36, 1, 0 },
			 { 0, 0, 25, 7, 85, 18, 0 },
			 { 0, 2, 47, 7, 72, 7, 0 },
			 { 0, 6, 70, 7, 50, 2, 0 },
			 { 0, 16, 84, 7, 27, 1, 0 },
			 { 0, 1, 34, 7, 81, 12, 0 },
			 { 0, 3, 58, 7, 63, 4, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 },
			 { 0, 0, 23, 7, 86, 19, 0 },
			 { 0, 2, 44, 7, 74, 8, 0 },
			 { 0, 5, 69, 7, 52, 2, 0 },
			 { 0, 15, 83, 7, 29, 1, 0 },
			 { 0, 1, 32, 7, 82, 13, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 9, 77, 7, 41, 1, 0 } },
		.odd = { { 0, 1, 30, 7, 83, 14, 0 },
			 { 0, 3, 54, 7, 66, 5, 0 },
			 { 0, 8, 76, 7, 43, 1, 0 },
			 { 0, 20, 86, 7, 22, 0, 0 },
			 { 0, 1, 40, 7, 78, 9, 0 },
			 { 0, 4, 65, 7, 56, 3, 0 },
			 { 0, 13, 81, 7, 33, 1, 0 },
			 { 0, 1, 28, 7, 84, 15, 0 },
			 { 0, 2, 51, 7, 69, 6, 0 },
			 { 0, 7, 74, 7, 45, 2, 0 },
			 { 0, 18, 86, 7, 24, 0, 0 },
			 { 0, 1, 38, 7, 79, 10, 0 },
			 { 0, 4, 62, 7, 59, 3, 0 },
			 { 0, 11, 81, 7, 35, 1, 0 },
			 { 0, 0, 26, 7, 85, 17, 0 },
			 { 0, 2, 48, 7, 72, 6, 0 },
			 { 0, 6, 72, 7, 48, 2, 0 },
			 { 0, 17, 85, 7, 26, 0, 0 },
			 { 0, 1, 35, 7, 81, 11, 0 },
			 { 0, 3, 59, 7, 62, 4, 0 },
			 { 0, 10, 79, 7, 38, 1, 0 },
			 { 0, 0, 24, 7, 86, 18, 0 },
			 { 0, 2, 45, 7, 74, 7, 0 },
			 { 0, 6, 69, 7, 51, 2, 0 },
			 { 0, 15, 84, 7, 28, 1, 0 },
			 { 0, 1, 33, 7, 81, 13, 0 },
			 { 0, 3, 56, 7, 65, 4, 0 },
			 { 0, 9, 78, 7, 40, 1, 0 },
			 { 0, 0, 22, 7, 86, 20, 0 },
			 { 0, 1, 43, 7, 76, 8, 0 },
			 { 0, 5, 66, 7, 54, 3, 0 },
			 { 0, 14, 83, 7, 30, 1, 0 } } },
	.ptrn_arr = { { 0x24992493, 0x264924c9, 0x92493249, 0x924c9249,
			 0x93249264, 0x924 } },
	.sample_patrn_length = 174,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 56) = 0.363636 */
	.hor_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 } },
		.odd = { { 0, 1, 30, 7, 82, 15, 0 },
			 { 0, 2, 50, 7, 70, 6, 0 },
			 { 0, 6, 70, 7, 50, 2, 0 },
			 { 0, 15, 82, 7, 30, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 } },
		.odd = { { 0, 1, 30, 7, 82, 15, 0 },
			 { 0, 2, 50, 7, 70, 6, 0 },
			 { 0, 6, 70, 7, 50, 2, 0 },
			 { 0, 15, 82, 7, 30, 1, 0 } } },
	.ptrn_arr = { { 0x92493 } },
	.sample_patrn_length = 22,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 57) = 0.359551 */
	.hor_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 1, 37, 7, 79, 11, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 7, 72, 7, 47, 2, 0 },
			 { 0, 15, 82, 7, 30, 1, 0 },
			 { 0, 1, 28, 7, 82, 17, 0 },
			 { 0, 2, 44, 7, 74, 8, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 },
			 { 0, 20, 84, 7, 24, 0, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 7, 69, 7, 50, 2, 0 },
			 { 0, 14, 81, 7, 32, 1, 0 },
			 { 0, 1, 26, 7, 83, 18, 0 },
			 { 0, 2, 42, 7, 75, 9, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 9, 75, 7, 42, 2, 0 },
			 { 0, 18, 83, 7, 26, 1, 0 },
			 { 0, 1, 32, 7, 81, 14, 0 },
			 { 0, 2, 50, 7, 69, 7, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 0, 24, 7, 84, 20, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 8, 74, 7, 44, 2, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 },
			 { 0, 1, 30, 7, 82, 15, 0 },
			 { 0, 2, 47, 7, 72, 7, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 11, 79, 7, 37, 1, 0 } },
		.odd = { { 0, 1, 29, 7, 82, 16, 0 },
			 { 0, 2, 46, 7, 72, 8, 0 },
			 { 0, 5, 64, 7, 56, 3, 0 },
			 { 0, 11, 78, 7, 38, 1, 0 },
			 { 0, 21, 84, 7, 23, 0, 0 },
			 { 0, 1, 36, 7, 79, 12, 0 },
			 { 0, 3, 53, 7, 66, 6, 0 },
			 { 0, 7, 71, 7, 48, 2, 0 },
			 { 0, 15, 81, 7, 31, 1, 0 },
			 { 0, 1, 27, 7, 82, 18, 0 },
			 { 0, 2, 43, 7, 74, 9, 0 },
			 { 0, 4, 61, 7, 59, 4, 0 },
			 { 0, 10, 75, 7, 41, 2, 0 },
			 { 0, 19, 83, 7, 25, 1, 0 },
			 { 0, 1, 33, 7, 81, 13, 0 },
			 { 0, 3, 51, 7, 68, 6, 0 },
			 { 0, 6, 68, 7, 51, 3, 0 },
			 { 0, 13, 81, 7, 33, 1, 0 },
			 { 0, 1, 25, 7, 83, 19, 0 },
			 { 0, 2, 41, 7, 75, 10, 0 },
			 { 0, 4, 59, 7, 61, 4, 0 },
			 { 0, 9, 74, 7, 43, 2, 0 },
			 { 0, 18, 82, 7, 27, 1, 0 },
			 { 0, 1, 31, 7, 81, 15, 0 },
			 { 0, 2, 48, 7, 71, 7, 0 },
			 { 0, 6, 66, 7, 53, 3, 0 },
			 { 0, 12, 79, 7, 36, 1, 0 },
			 { 0, 0, 23, 7, 84, 21, 0 },
			 { 0, 1, 38, 7, 78, 11, 0 },
			 { 0, 3, 56, 7, 64, 5, 0 },
			 { 0, 8, 72, 7, 46, 2, 0 },
			 { 0, 16, 82, 7, 29, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 1, 37, 7, 79, 11, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 7, 72, 7, 47, 2, 0 },
			 { 0, 15, 82, 7, 30, 1, 0 },
			 { 0, 1, 28, 7, 82, 17, 0 },
			 { 0, 2, 44, 7, 74, 8, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 },
			 { 0, 20, 84, 7, 24, 0, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 7, 69, 7, 50, 2, 0 },
			 { 0, 14, 81, 7, 32, 1, 0 },
			 { 0, 1, 26, 7, 83, 18, 0 },
			 { 0, 2, 42, 7, 75, 9, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 9, 75, 7, 42, 2, 0 },
			 { 0, 18, 83, 7, 26, 1, 0 },
			 { 0, 1, 32, 7, 81, 14, 0 },
			 { 0, 2, 50, 7, 69, 7, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 0, 24, 7, 84, 20, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 8, 74, 7, 44, 2, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 },
			 { 0, 1, 30, 7, 82, 15, 0 },
			 { 0, 2, 47, 7, 72, 7, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 11, 79, 7, 37, 1, 0 } },
		.odd = { { 0, 1, 29, 7, 82, 16, 0 },
			 { 0, 2, 46, 7, 72, 8, 0 },
			 { 0, 5, 64, 7, 56, 3, 0 },
			 { 0, 11, 78, 7, 38, 1, 0 },
			 { 0, 21, 84, 7, 23, 0, 0 },
			 { 0, 1, 36, 7, 79, 12, 0 },
			 { 0, 3, 53, 7, 66, 6, 0 },
			 { 0, 7, 71, 7, 48, 2, 0 },
			 { 0, 15, 81, 7, 31, 1, 0 },
			 { 0, 1, 27, 7, 82, 18, 0 },
			 { 0, 2, 43, 7, 74, 9, 0 },
			 { 0, 4, 61, 7, 59, 4, 0 },
			 { 0, 10, 75, 7, 41, 2, 0 },
			 { 0, 19, 83, 7, 25, 1, 0 },
			 { 0, 1, 33, 7, 81, 13, 0 },
			 { 0, 3, 51, 7, 68, 6, 0 },
			 { 0, 6, 68, 7, 51, 3, 0 },
			 { 0, 13, 81, 7, 33, 1, 0 },
			 { 0, 1, 25, 7, 83, 19, 0 },
			 { 0, 2, 41, 7, 75, 10, 0 },
			 { 0, 4, 59, 7, 61, 4, 0 },
			 { 0, 9, 74, 7, 43, 2, 0 },
			 { 0, 18, 82, 7, 27, 1, 0 },
			 { 0, 1, 31, 7, 81, 15, 0 },
			 { 0, 2, 48, 7, 71, 7, 0 },
			 { 0, 6, 66, 7, 53, 3, 0 },
			 { 0, 12, 79, 7, 36, 1, 0 },
			 { 0, 0, 23, 7, 84, 21, 0 },
			 { 0, 1, 38, 7, 78, 11, 0 },
			 { 0, 3, 56, 7, 64, 5, 0 },
			 { 0, 8, 72, 7, 46, 2, 0 },
			 { 0, 16, 82, 7, 29, 1, 0 } } },
	.ptrn_arr = { { 0x26492493, 0x924c9249, 0x49249924, 0x64924932,
			 0x24c92492, 0x9249 } },
	.sample_patrn_length = 178,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 58) = 0.355556 */
	.hor_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 3, 50, 7, 68, 7, 0 },
			 { 0, 6, 64, 7, 55, 3, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 19, 82, 7, 26, 1, 0 },
			 { 0, 1, 30, 7, 81, 16, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 16, 81, 7, 30, 1, 0 },
			 { 0, 1, 26, 7, 82, 19, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 3, 55, 7, 64, 6, 0 },
			 { 0, 7, 68, 7, 50, 3, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 } },
		.odd = { { 0, 1, 28, 7, 82, 17, 0 },
			 { 0, 2, 42, 7, 74, 10, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 8, 71, 7, 47, 2, 0 },
			 { 0, 14, 80, 7, 33, 1, 0 },
			 { 0, 1, 24, 7, 82, 21, 0 },
			 { 0, 1, 37, 7, 78, 12, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 12, 78, 7, 37, 1, 0 },
			 { 0, 21, 82, 7, 24, 1, 0 },
			 { 0, 1, 33, 7, 80, 14, 0 },
			 { 0, 2, 47, 7, 71, 8, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 10, 74, 7, 42, 2, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 3, 50, 7, 68, 7, 0 },
			 { 0, 6, 64, 7, 55, 3, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 19, 82, 7, 26, 1, 0 },
			 { 0, 1, 30, 7, 81, 16, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 16, 81, 7, 30, 1, 0 },
			 { 0, 1, 26, 7, 82, 19, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 3, 55, 7, 64, 6, 0 },
			 { 0, 7, 68, 7, 50, 3, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 } },
		.odd = { { 0, 1, 28, 7, 82, 17, 0 },
			 { 0, 2, 42, 7, 74, 10, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 8, 71, 7, 47, 2, 0 },
			 { 0, 14, 80, 7, 33, 1, 0 },
			 { 0, 1, 24, 7, 82, 21, 0 },
			 { 0, 1, 37, 7, 78, 12, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 12, 78, 7, 37, 1, 0 },
			 { 0, 21, 82, 7, 24, 1, 0 },
			 { 0, 1, 33, 7, 80, 14, 0 },
			 { 0, 2, 47, 7, 71, 8, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 10, 74, 7, 42, 2, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 } } },
	.ptrn_arr = { { 0x32492493, 0x99249249, 0x924924 } },
	.sample_patrn_length = 90,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 59) = 0.351648 */
	.hor_phase_arr = {
		.even = { { 0, 23, 82, 7, 23, 0, 0 },
			 { 0, 1, 33, 7, 79, 15, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 7, 68, 7, 50, 3, 0 },
			 { 0, 12, 78, 7, 37, 1, 0 },
			 { 0, 19, 81, 7, 27, 1, 0 },
			 { 0, 1, 29, 7, 80, 18, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 3, 52, 7, 66, 7, 0 },
			 { 0, 6, 63, 7, 55, 4, 0 },
			 { 0, 10, 74, 7, 42, 2, 0 },
			 { 0, 16, 80, 7, 31, 1, 0 },
			 { 0, 1, 25, 7, 81, 21, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 2, 47, 7, 71, 8, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 8, 71, 7, 47, 2, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 21, 81, 7, 25, 1, 0 },
			 { 0, 1, 31, 7, 80, 16, 0 },
			 { 0, 2, 42, 7, 74, 10, 0 },
			 { 0, 4, 55, 7, 63, 6, 0 },
			 { 0, 7, 66, 7, 52, 3, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 18, 80, 7, 29, 1, 0 },
			 { 0, 1, 27, 7, 81, 19, 0 },
			 { 0, 1, 37, 7, 78, 12, 0 },
			 { 0, 3, 50, 7, 68, 7, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 15, 79, 7, 33, 1, 0 } },
		.odd = { { 0, 1, 28, 7, 81, 18, 0 },
			 { 0, 2, 39, 7, 75, 12, 0 },
			 { 0, 3, 51, 7, 67, 7, 0 },
			 { 0, 6, 62, 7, 56, 4, 0 },
			 { 0, 10, 73, 7, 43, 2, 0 },
			 { 0, 15, 80, 7, 32, 1, 0 },
			 { 0, 1, 24, 7, 81, 22, 0 },
			 { 0, 1, 34, 7, 79, 14, 0 },
			 { 0, 2, 46, 7, 71, 9, 0 },
			 { 0, 4, 58, 7, 61, 5, 0 },
			 { 0, 8, 69, 7, 48, 3, 0 },
			 { 0, 13, 78, 7, 36, 1, 0 },
			 { 0, 20, 81, 7, 26, 1, 0 },
			 { 0, 1, 30, 7, 80, 17, 0 },
			 { 0, 2, 41, 7, 74, 11, 0 },
			 { 0, 3, 53, 7, 66, 6, 0 },
			 { 0, 6, 66, 7, 53, 3, 0 },
			 { 0, 11, 74, 7, 41, 2, 0 },
			 { 0, 17, 80, 7, 30, 1, 0 },
			 { 0, 1, 26, 7, 81, 20, 0 },
			 { 0, 1, 36, 7, 78, 13, 0 },
			 { 0, 3, 48, 7, 69, 8, 0 },
			 { 0, 5, 61, 7, 58, 4, 0 },
			 { 0, 9, 71, 7, 46, 2, 0 },
			 { 0, 14, 79, 7, 34, 1, 0 },
			 { 0, 22, 81, 7, 24, 1, 0 },
			 { 0, 1, 32, 7, 80, 15, 0 },
			 { 0, 2, 43, 7, 73, 10, 0 },
			 { 0, 4, 56, 7, 62, 6, 0 },
			 { 0, 7, 67, 7, 51, 3, 0 },
			 { 0, 12, 75, 7, 39, 2, 0 },
			 { 0, 18, 81, 7, 28, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 23, 82, 7, 23, 0, 0 },
			 { 0, 1, 33, 7, 79, 15, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 7, 68, 7, 50, 3, 0 },
			 { 0, 12, 78, 7, 37, 1, 0 },
			 { 0, 19, 81, 7, 27, 1, 0 },
			 { 0, 1, 29, 7, 80, 18, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 3, 52, 7, 66, 7, 0 },
			 { 0, 6, 63, 7, 55, 4, 0 },
			 { 0, 10, 74, 7, 42, 2, 0 },
			 { 0, 16, 80, 7, 31, 1, 0 },
			 { 0, 1, 25, 7, 81, 21, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 2, 47, 7, 71, 8, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 8, 71, 7, 47, 2, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 21, 81, 7, 25, 1, 0 },
			 { 0, 1, 31, 7, 80, 16, 0 },
			 { 0, 2, 42, 7, 74, 10, 0 },
			 { 0, 4, 55, 7, 63, 6, 0 },
			 { 0, 7, 66, 7, 52, 3, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 18, 80, 7, 29, 1, 0 },
			 { 0, 1, 27, 7, 81, 19, 0 },
			 { 0, 1, 37, 7, 78, 12, 0 },
			 { 0, 3, 50, 7, 68, 7, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 15, 79, 7, 33, 1, 0 } },
		.odd = { { 0, 1, 28, 7, 81, 18, 0 },
			 { 0, 2, 39, 7, 75, 12, 0 },
			 { 0, 3, 51, 7, 67, 7, 0 },
			 { 0, 6, 62, 7, 56, 4, 0 },
			 { 0, 10, 73, 7, 43, 2, 0 },
			 { 0, 15, 80, 7, 32, 1, 0 },
			 { 0, 1, 24, 7, 81, 22, 0 },
			 { 0, 1, 34, 7, 79, 14, 0 },
			 { 0, 2, 46, 7, 71, 9, 0 },
			 { 0, 4, 58, 7, 61, 5, 0 },
			 { 0, 8, 69, 7, 48, 3, 0 },
			 { 0, 13, 78, 7, 36, 1, 0 },
			 { 0, 20, 81, 7, 26, 1, 0 },
			 { 0, 1, 30, 7, 80, 17, 0 },
			 { 0, 2, 41, 7, 74, 11, 0 },
			 { 0, 3, 53, 7, 66, 6, 0 },
			 { 0, 6, 66, 7, 53, 3, 0 },
			 { 0, 11, 74, 7, 41, 2, 0 },
			 { 0, 17, 80, 7, 30, 1, 0 },
			 { 0, 1, 26, 7, 81, 20, 0 },
			 { 0, 1, 36, 7, 78, 13, 0 },
			 { 0, 3, 48, 7, 69, 8, 0 },
			 { 0, 5, 61, 7, 58, 4, 0 },
			 { 0, 9, 71, 7, 46, 2, 0 },
			 { 0, 14, 79, 7, 34, 1, 0 },
			 { 0, 22, 81, 7, 24, 1, 0 },
			 { 0, 1, 32, 7, 80, 15, 0 },
			 { 0, 2, 43, 7, 73, 10, 0 },
			 { 0, 4, 56, 7, 62, 6, 0 },
			 { 0, 7, 67, 7, 51, 3, 0 },
			 { 0, 12, 75, 7, 39, 2, 0 },
			 { 0, 18, 81, 7, 28, 1, 0 } } },
	.ptrn_arr = { { 0x92492493, 0x4924924c, 0x24924992, 0x92493249,
			 0x49264924, 0x92492 } },
	.sample_patrn_length = 182,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 60) = 0.347826 */
	.hor_phase_arr = {
		.even = { { 1, 23, 80, 7, 23, 1, 0 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 } },
		.odd = { { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 1, 35, 7, 78, 14, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 4, 54, 7, 64, 6, 0 },
			 { 0, 6, 64, 7, 54, 4, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 14, 78, 7, 35, 1, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 23, 80, 7, 23, 1, 0 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 } },
		.odd = { { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 1, 35, 7, 78, 14, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 4, 54, 7, 64, 6, 0 },
			 { 0, 6, 64, 7, 54, 4, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 14, 78, 7, 35, 1, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 } } },
	.ptrn_arr = { { 0x92492493, 0x924 } },
	.sample_patrn_length = 46,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 61) = 0.344086 */
	.hor_phase_arr = {
		.even = { { 1, 23, 80, 7, 23, 1, 0 },
			 { 0, 1, 29, 7, 80, 18, 0 },
			 { 0, 1, 36, 7, 77, 14, 0 },
			 { 0, 2, 42, 7, 73, 11, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 5, 57, 7, 60, 6, 0 },
			 { 0, 6, 64, 7, 54, 4, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 16, 78, 7, 33, 1, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 },
			 { 0, 1, 25, 7, 79, 22, 1 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 },
			 { 0, 2, 45, 7, 71, 10, 0 },
			 { 0, 4, 52, 7, 65, 7, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 7, 65, 7, 52, 4, 0 },
			 { 0, 10, 71, 7, 45, 2, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 },
			 { 1, 22, 79, 7, 25, 1, 0 },
			 { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 1, 33, 7, 78, 16, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 4, 54, 7, 64, 6, 0 },
			 { 0, 6, 60, 7, 57, 5, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 11, 73, 7, 42, 2, 0 },
			 { 0, 14, 77, 7, 36, 1, 0 },
			 { 0, 18, 80, 7, 29, 1, 0 } },
		.odd = { { 0, 1, 26, 7, 80, 21, 0 },
			 { 0, 1, 32, 7, 79, 16, 0 },
			 { 0, 2, 39, 7, 75, 12, 0 },
			 { 0, 3, 46, 7, 70, 9, 0 },
			 { 0, 4, 53, 7, 64, 7, 0 },
			 { 0, 5, 60, 7, 58, 5, 0 },
			 { 0, 8, 66, 7, 51, 3, 0 },
			 { 0, 10, 72, 7, 44, 2, 0 },
			 { 0, 14, 75, 7, 37, 2, 0 },
			 { 0, 18, 79, 7, 30, 1, 0 },
			 { 1, 23, 79, 7, 24, 1, 0 },
			 { 0, 1, 28, 7, 80, 19, 0 },
			 { 0, 1, 35, 7, 77, 15, 0 },
			 { 0, 2, 41, 7, 74, 11, 0 },
			 { 0, 3, 48, 7, 69, 8, 0 },
			 { 0, 4, 55, 7, 63, 6, 0 },
			 { 0, 6, 63, 7, 55, 4, 0 },
			 { 0, 8, 69, 7, 48, 3, 0 },
			 { 0, 11, 74, 7, 41, 2, 0 },
			 { 0, 15, 77, 7, 35, 1, 0 },
			 { 0, 19, 80, 7, 28, 1, 0 },
			 { 0, 1, 24, 7, 79, 23, 1 },
			 { 0, 1, 30, 7, 79, 18, 0 },
			 { 0, 2, 37, 7, 75, 14, 0 },
			 { 0, 2, 44, 7, 72, 10, 0 },
			 { 0, 3, 51, 7, 66, 8, 0 },
			 { 0, 5, 58, 7, 60, 5, 0 },
			 { 0, 7, 64, 7, 53, 4, 0 },
			 { 0, 9, 70, 7, 46, 3, 0 },
			 { 0, 12, 75, 7, 39, 2, 0 },
			 { 0, 16, 79, 7, 32, 1, 0 },
			 { 0, 21, 80, 7, 26, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 23, 80, 7, 23, 1, 0 },
			 { 0, 1, 29, 7, 80, 18, 0 },
			 { 0, 1, 36, 7, 77, 14, 0 },
			 { 0, 2, 42, 7, 73, 11, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 5, 57, 7, 60, 6, 0 },
			 { 0, 6, 64, 7, 54, 4, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 16, 78, 7, 33, 1, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 },
			 { 0, 1, 25, 7, 79, 22, 1 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 },
			 { 0, 2, 45, 7, 71, 10, 0 },
			 { 0, 4, 52, 7, 65, 7, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 7, 65, 7, 52, 4, 0 },
			 { 0, 10, 71, 7, 45, 2, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 },
			 { 1, 22, 79, 7, 25, 1, 0 },
			 { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 1, 33, 7, 78, 16, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 4, 54, 7, 64, 6, 0 },
			 { 0, 6, 60, 7, 57, 5, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 11, 73, 7, 42, 2, 0 },
			 { 0, 14, 77, 7, 36, 1, 0 },
			 { 0, 18, 80, 7, 29, 1, 0 } },
		.odd = { { 0, 1, 26, 7, 80, 21, 0 },
			 { 0, 1, 32, 7, 79, 16, 0 },
			 { 0, 2, 39, 7, 75, 12, 0 },
			 { 0, 3, 46, 7, 70, 9, 0 },
			 { 0, 4, 53, 7, 64, 7, 0 },
			 { 0, 5, 60, 7, 58, 5, 0 },
			 { 0, 8, 66, 7, 51, 3, 0 },
			 { 0, 10, 72, 7, 44, 2, 0 },
			 { 0, 14, 75, 7, 37, 2, 0 },
			 { 0, 18, 79, 7, 30, 1, 0 },
			 { 1, 23, 79, 7, 24, 1, 0 },
			 { 0, 1, 28, 7, 80, 19, 0 },
			 { 0, 1, 35, 7, 77, 15, 0 },
			 { 0, 2, 41, 7, 74, 11, 0 },
			 { 0, 3, 48, 7, 69, 8, 0 },
			 { 0, 4, 55, 7, 63, 6, 0 },
			 { 0, 6, 63, 7, 55, 4, 0 },
			 { 0, 8, 69, 7, 48, 3, 0 },
			 { 0, 11, 74, 7, 41, 2, 0 },
			 { 0, 15, 77, 7, 35, 1, 0 },
			 { 0, 19, 80, 7, 28, 1, 0 },
			 { 0, 1, 24, 7, 79, 23, 1 },
			 { 0, 1, 30, 7, 79, 18, 0 },
			 { 0, 2, 37, 7, 75, 14, 0 },
			 { 0, 2, 44, 7, 72, 10, 0 },
			 { 0, 3, 51, 7, 66, 8, 0 },
			 { 0, 5, 58, 7, 60, 5, 0 },
			 { 0, 7, 64, 7, 53, 4, 0 },
			 { 0, 9, 70, 7, 46, 3, 0 },
			 { 0, 12, 75, 7, 39, 2, 0 },
			 { 0, 16, 79, 7, 32, 1, 0 },
			 { 0, 21, 80, 7, 26, 1, 0 } } },
	.ptrn_arr = { { 0x92492493, 0x64924924, 0x92492492, 0x4c924924,
			 0x92492492, 0x924924 } },
	.sample_patrn_length = 186,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 62) = 0.340426 */
	.hor_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 1, 28, 7, 79, 20, 0 },
			 { 0, 1, 32, 7, 78, 17, 0 },
			 { 0, 2, 36, 7, 75, 15, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 },
			 { 0, 3, 45, 7, 70, 10, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 4, 54, 7, 63, 7, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 7, 63, 7, 54, 4, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 10, 70, 7, 45, 3, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 15, 75, 7, 36, 2, 0 },
			 { 0, 17, 78, 7, 32, 1, 0 },
			 { 0, 20, 79, 7, 28, 1, 0 } },
		.odd = { { 0, 1, 26, 7, 78, 22, 1 },
			 { 0, 1, 30, 7, 78, 19, 0 },
			 { 0, 1, 34, 7, 77, 16, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 },
			 { 0, 2, 43, 7, 72, 11, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 4, 52, 7, 65, 7, 0 },
			 { 0, 5, 56, 7, 61, 6, 0 },
			 { 0, 6, 61, 7, 56, 5, 0 },
			 { 0, 7, 65, 7, 52, 4, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 11, 72, 7, 43, 2, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 16, 77, 7, 34, 1, 0 },
			 { 0, 19, 78, 7, 30, 1, 0 },
			 { 1, 22, 78, 7, 26, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 1, 28, 7, 79, 20, 0 },
			 { 0, 1, 32, 7, 78, 17, 0 },
			 { 0, 2, 36, 7, 75, 15, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 },
			 { 0, 3, 45, 7, 70, 10, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 4, 54, 7, 63, 7, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 7, 63, 7, 54, 4, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 10, 70, 7, 45, 3, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 15, 75, 7, 36, 2, 0 },
			 { 0, 17, 78, 7, 32, 1, 0 },
			 { 0, 20, 79, 7, 28, 1, 0 } },
		.odd = { { 0, 1, 26, 7, 78, 22, 1 },
			 { 0, 1, 30, 7, 78, 19, 0 },
			 { 0, 1, 34, 7, 77, 16, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 },
			 { 0, 2, 43, 7, 72, 11, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 4, 52, 7, 65, 7, 0 },
			 { 0, 5, 56, 7, 61, 6, 0 },
			 { 0, 6, 61, 7, 56, 5, 0 },
			 { 0, 7, 65, 7, 52, 4, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 11, 72, 7, 43, 2, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 16, 77, 7, 34, 1, 0 },
			 { 0, 19, 78, 7, 30, 1, 0 },
			 { 1, 22, 78, 7, 26, 1, 0 } } },
	.ptrn_arr = { { 0x92492493, 0x24924924, 0x9249249 } },
	.sample_patrn_length = 94,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 63) = 0.336842 */
	.hor_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 1, 26, 7, 78, 22, 1 },
			 { 0, 1, 28, 7, 77, 21, 1 },
			 { 0, 1, 30, 7, 78, 19, 0 },
			 { 0, 1, 32, 7, 77, 18, 0 },
			 { 0, 1, 34, 7, 77, 16, 0 },
			 { 0, 2, 36, 7, 75, 15, 0 },
			 { 0, 2, 38, 7, 74, 14, 0 },
			 { 0, 2, 40, 7, 73, 13, 0 },
			 { 0, 2, 43, 7, 72, 11, 0 },
			 { 0, 3, 45, 7, 70, 10, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 4, 49, 7, 66, 9, 0 },
			 { 0, 4, 52, 7, 64, 8, 0 },
			 { 0, 4, 54, 7, 63, 7, 0 },
			 { 0, 5, 56, 7, 61, 6, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 6, 61, 7, 56, 5, 0 },
			 { 0, 7, 63, 7, 54, 4, 0 },
			 { 0, 8, 64, 7, 52, 4, 0 },
			 { 0, 9, 66, 7, 49, 4, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 10, 70, 7, 45, 3, 0 },
			 { 0, 11, 72, 7, 43, 2, 0 },
			 { 0, 13, 73, 7, 40, 2, 0 },
			 { 0, 14, 74, 7, 38, 2, 0 },
			 { 0, 15, 75, 7, 36, 2, 0 },
			 { 0, 16, 77, 7, 34, 1, 0 },
			 { 0, 18, 77, 7, 32, 1, 0 },
			 { 0, 19, 78, 7, 30, 1, 0 },
			 { 1, 21, 77, 7, 28, 1, 0 },
			 { 1, 22, 78, 7, 26, 1, 0 } },
		.odd = { { 0, 1, 25, 7, 78, 23, 1 },
			 { 0, 1, 27, 7, 77, 22, 1 },
			 { 0, 1, 29, 7, 78, 20, 0 },
			 { 0, 1, 31, 7, 78, 18, 0 },
			 { 0, 1, 33, 7, 77, 17, 0 },
			 { 0, 2, 35, 7, 75, 16, 0 },
			 { 0, 2, 37, 7, 75, 14, 0 },
			 { 0, 2, 39, 7, 74, 13, 0 },
			 { 0, 2, 42, 7, 72, 12, 0 },
			 { 0, 3, 44, 7, 70, 11, 0 },
			 { 0, 3, 46, 7, 69, 10, 0 },
			 { 0, 3, 48, 7, 68, 9, 0 },
			 { 0, 4, 51, 7, 65, 8, 0 },
			 { 0, 4, 53, 7, 64, 7, 0 },
			 { 0, 5, 55, 7, 61, 7, 0 },
			 { 0, 5, 57, 7, 60, 6, 0 },
			 { 0, 6, 60, 7, 57, 5, 0 },
			 { 0, 7, 61, 7, 55, 5, 0 },
			 { 0, 7, 64, 7, 53, 4, 0 },
			 { 0, 8, 65, 7, 51, 4, 0 },
			 { 0, 9, 68, 7, 48, 3, 0 },
			 { 0, 10, 69, 7, 46, 3, 0 },
			 { 0, 11, 70, 7, 44, 3, 0 },
			 { 0, 12, 72, 7, 42, 2, 0 },
			 { 0, 13, 74, 7, 39, 2, 0 },
			 { 0, 14, 75, 7, 37, 2, 0 },
			 { 0, 16, 75, 7, 35, 2, 0 },
			 { 0, 17, 77, 7, 33, 1, 0 },
			 { 0, 18, 78, 7, 31, 1, 0 },
			 { 0, 20, 78, 7, 29, 1, 0 },
			 { 1, 22, 77, 7, 27, 1, 0 },
			 { 1, 23, 78, 7, 25, 1, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 1, 26, 7, 78, 22, 1 },
			 { 0, 1, 28, 7, 77, 21, 1 },
			 { 0, 1, 30, 7, 78, 19, 0 },
			 { 0, 1, 32, 7, 77, 18, 0 },
			 { 0, 1, 34, 7, 77, 16, 0 },
			 { 0, 2, 36, 7, 75, 15, 0 },
			 { 0, 2, 38, 7, 74, 14, 0 },
			 { 0, 2, 40, 7, 73, 13, 0 },
			 { 0, 2, 43, 7, 72, 11, 0 },
			 { 0, 3, 45, 7, 70, 10, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 4, 49, 7, 66, 9, 0 },
			 { 0, 4, 52, 7, 64, 8, 0 },
			 { 0, 4, 54, 7, 63, 7, 0 },
			 { 0, 5, 56, 7, 61, 6, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 6, 61, 7, 56, 5, 0 },
			 { 0, 7, 63, 7, 54, 4, 0 },
			 { 0, 8, 64, 7, 52, 4, 0 },
			 { 0, 9, 66, 7, 49, 4, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 10, 70, 7, 45, 3, 0 },
			 { 0, 11, 72, 7, 43, 2, 0 },
			 { 0, 13, 73, 7, 40, 2, 0 },
			 { 0, 14, 74, 7, 38, 2, 0 },
			 { 0, 15, 75, 7, 36, 2, 0 },
			 { 0, 16, 77, 7, 34, 1, 0 },
			 { 0, 18, 77, 7, 32, 1, 0 },
			 { 0, 19, 78, 7, 30, 1, 0 },
			 { 1, 21, 77, 7, 28, 1, 0 },
			 { 1, 22, 78, 7, 26, 1, 0 } },
		.odd = { { 0, 1, 25, 7, 78, 23, 1 },
			 { 0, 1, 27, 7, 77, 22, 1 },
			 { 0, 1, 29, 7, 78, 20, 0 },
			 { 0, 1, 31, 7, 78, 18, 0 },
			 { 0, 1, 33, 7, 77, 17, 0 },
			 { 0, 2, 35, 7, 75, 16, 0 },
			 { 0, 2, 37, 7, 75, 14, 0 },
			 { 0, 2, 39, 7, 74, 13, 0 },
			 { 0, 2, 42, 7, 72, 12, 0 },
			 { 0, 3, 44, 7, 70, 11, 0 },
			 { 0, 3, 46, 7, 69, 10, 0 },
			 { 0, 3, 48, 7, 68, 9, 0 },
			 { 0, 4, 51, 7, 65, 8, 0 },
			 { 0, 4, 53, 7, 64, 7, 0 },
			 { 0, 5, 55, 7, 61, 7, 0 },
			 { 0, 5, 57, 7, 60, 6, 0 },
			 { 0, 6, 60, 7, 57, 5, 0 },
			 { 0, 7, 61, 7, 55, 5, 0 },
			 { 0, 7, 64, 7, 53, 4, 0 },
			 { 0, 8, 65, 7, 51, 4, 0 },
			 { 0, 9, 68, 7, 48, 3, 0 },
			 { 0, 10, 69, 7, 46, 3, 0 },
			 { 0, 11, 70, 7, 44, 3, 0 },
			 { 0, 12, 72, 7, 42, 2, 0 },
			 { 0, 13, 74, 7, 39, 2, 0 },
			 { 0, 14, 75, 7, 37, 2, 0 },
			 { 0, 16, 75, 7, 35, 2, 0 },
			 { 0, 17, 77, 7, 33, 1, 0 },
			 { 0, 18, 78, 7, 31, 1, 0 },
			 { 0, 20, 78, 7, 29, 1, 0 },
			 { 1, 22, 77, 7, 27, 1, 0 },
			 { 1, 23, 78, 7, 25, 1, 0 } } },
	.ptrn_arr = { { 0x92492493, 0x24924924, 0x49249249, 0x92492492,
			 0x24924924, 0x9249249 } },
	.sample_patrn_length = 190,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 64) = 0.333333 */
	.hor_phase_arr = {
		.even = { { 0, 21, 86, 7, 21, 0, 0 } },
		.odd = { { 0, 4, 60, 7, 60, 4, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 21, 86, 7, 21, 0, 0 } },
		.odd = { { 0, 4, 60, 7, 60, 4, 0 } } },
	.ptrn_arr = { { 0x9 } },
	.sample_patrn_length = 6,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 65) = 0.329897 */
	.hor_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 20, 85, 7, 23, 0, 0 },
			 { 0, 18, 84, 7, 25, 1, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 },
			 { 0, 15, 82, 7, 30, 1, 0 },
			 { 0, 14, 81, 7, 32, 1, 0 },
			 { 0, 12, 81, 7, 34, 1, 0 },
			 { 0, 11, 79, 7, 37, 1, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 },
			 { 0, 9, 75, 7, 42, 2, 0 },
			 { 0, 8, 74, 7, 44, 2, 0 },
			 { 0, 7, 72, 7, 47, 2, 0 },
			 { 0, 6, 70, 7, 50, 2, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 4, 64, 7, 57, 3, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 3, 57, 7, 64, 4, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 2, 50, 7, 70, 6, 0 },
			 { 0, 2, 47, 7, 72, 7, 0 },
			 { 0, 2, 44, 7, 74, 8, 0 },
			 { 0, 2, 42, 7, 75, 9, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 1, 37, 7, 79, 11, 0 },
			 { 0, 1, 34, 7, 81, 12, 0 },
			 { 0, 1, 32, 7, 81, 14, 0 },
			 { 0, 1, 30, 7, 82, 15, 0 },
			 { 0, 1, 28, 7, 82, 17, 0 },
			 { 0, 1, 25, 7, 84, 18, 0 },
			 { 0, 0, 23, 7, 85, 20, 0 } },
		.odd = { { 0, 21, 84, 7, 23, 0, 0 },
			 { 0, 19, 85, 7, 24, 0, 0 },
			 { 0, 17, 84, 7, 26, 1, 0 },
			 { 0, 16, 82, 7, 29, 1, 0 },
			 { 0, 14, 82, 7, 31, 1, 0 },
			 { 0, 13, 81, 7, 33, 1, 0 },
			 { 0, 12, 80, 7, 35, 1, 0 },
			 { 0, 11, 78, 7, 38, 1, 0 },
			 { 0, 10, 77, 7, 40, 1, 0 },
			 { 0, 9, 74, 7, 43, 2, 0 },
			 { 0, 8, 72, 7, 46, 2, 0 },
			 { 0, 7, 71, 7, 48, 2, 0 },
			 { 0, 6, 69, 7, 51, 2, 0 },
			 { 0, 5, 66, 7, 54, 3, 0 },
			 { 0, 5, 64, 7, 56, 3, 0 },
			 { 0, 4, 61, 7, 59, 4, 0 },
			 { 0, 4, 59, 7, 61, 4, 0 },
			 { 0, 3, 56, 7, 64, 5, 0 },
			 { 0, 3, 54, 7, 66, 5, 0 },
			 { 0, 2, 51, 7, 69, 6, 0 },
			 { 0, 2, 48, 7, 71, 7, 0 },
			 { 0, 2, 46, 7, 72, 8, 0 },
			 { 0, 2, 43, 7, 74, 9, 0 },
			 { 0, 1, 40, 7, 77, 10, 0 },
			 { 0, 1, 38, 7, 78, 11, 0 },
			 { 0, 1, 35, 7, 80, 12, 0 },
			 { 0, 1, 33, 7, 81, 13, 0 },
			 { 0, 1, 31, 7, 82, 14, 0 },
			 { 0, 1, 29, 7, 82, 16, 0 },
			 { 0, 1, 26, 7, 84, 17, 0 },
			 { 0, 0, 24, 7, 85, 19, 0 },
			 { 0, 0, 23, 7, 84, 21, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 20, 85, 7, 23, 0, 0 },
			 { 0, 18, 84, 7, 25, 1, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 },
			 { 0, 15, 82, 7, 30, 1, 0 },
			 { 0, 14, 81, 7, 32, 1, 0 },
			 { 0, 12, 81, 7, 34, 1, 0 },
			 { 0, 11, 79, 7, 37, 1, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 },
			 { 0, 9, 75, 7, 42, 2, 0 },
			 { 0, 8, 74, 7, 44, 2, 0 },
			 { 0, 7, 72, 7, 47, 2, 0 },
			 { 0, 6, 70, 7, 50, 2, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 4, 64, 7, 57, 3, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 3, 57, 7, 64, 4, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 2, 50, 7, 70, 6, 0 },
			 { 0, 2, 47, 7, 72, 7, 0 },
			 { 0, 2, 44, 7, 74, 8, 0 },
			 { 0, 2, 42, 7, 75, 9, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 1, 37, 7, 79, 11, 0 },
			 { 0, 1, 34, 7, 81, 12, 0 },
			 { 0, 1, 32, 7, 81, 14, 0 },
			 { 0, 1, 30, 7, 82, 15, 0 },
			 { 0, 1, 28, 7, 82, 17, 0 },
			 { 0, 1, 25, 7, 84, 18, 0 },
			 { 0, 0, 23, 7, 85, 20, 0 } },
		.odd = { { 0, 21, 84, 7, 23, 0, 0 },
			 { 0, 19, 85, 7, 24, 0, 0 },
			 { 0, 17, 84, 7, 26, 1, 0 },
			 { 0, 16, 82, 7, 29, 1, 0 },
			 { 0, 14, 82, 7, 31, 1, 0 },
			 { 0, 13, 81, 7, 33, 1, 0 },
			 { 0, 12, 80, 7, 35, 1, 0 },
			 { 0, 11, 78, 7, 38, 1, 0 },
			 { 0, 10, 77, 7, 40, 1, 0 },
			 { 0, 9, 74, 7, 43, 2, 0 },
			 { 0, 8, 72, 7, 46, 2, 0 },
			 { 0, 7, 71, 7, 48, 2, 0 },
			 { 0, 6, 69, 7, 51, 2, 0 },
			 { 0, 5, 66, 7, 54, 3, 0 },
			 { 0, 5, 64, 7, 56, 3, 0 },
			 { 0, 4, 61, 7, 59, 4, 0 },
			 { 0, 4, 59, 7, 61, 4, 0 },
			 { 0, 3, 56, 7, 64, 5, 0 },
			 { 0, 3, 54, 7, 66, 5, 0 },
			 { 0, 2, 51, 7, 69, 6, 0 },
			 { 0, 2, 48, 7, 71, 7, 0 },
			 { 0, 2, 46, 7, 72, 8, 0 },
			 { 0, 2, 43, 7, 74, 9, 0 },
			 { 0, 1, 40, 7, 77, 10, 0 },
			 { 0, 1, 38, 7, 78, 11, 0 },
			 { 0, 1, 35, 7, 80, 12, 0 },
			 { 0, 1, 33, 7, 81, 13, 0 },
			 { 0, 1, 31, 7, 82, 14, 0 },
			 { 0, 1, 29, 7, 82, 16, 0 },
			 { 0, 1, 26, 7, 84, 17, 0 },
			 { 0, 0, 24, 7, 85, 19, 0 },
			 { 0, 0, 23, 7, 84, 21, 0 } } },
	.ptrn_arr = { { 0x49249249, 0x92492492, 0x24924924, 0x49249249,
			 0x92492492, 0x24924924 } },
	.sample_patrn_length = 194,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 66) = 0.326531 */
	.hor_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 18, 83, 7, 26, 1, 0 },
			 { 0, 15, 82, 7, 30, 1, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 },
			 { 0, 8, 74, 7, 44, 2, 0 },
			 { 0, 7, 69, 7, 50, 2, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 2, 50, 7, 69, 7, 0 },
			 { 0, 2, 44, 7, 74, 8, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 1, 30, 7, 82, 15, 0 },
			 { 0, 1, 26, 7, 83, 18, 0 } },
		.odd = { { 0, 20, 84, 7, 24, 0, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 },
			 { 0, 14, 81, 7, 32, 1, 0 },
			 { 0, 12, 78, 7, 37, 1, 0 },
			 { 0, 9, 75, 7, 42, 2, 0 },
			 { 0, 8, 71, 7, 47, 2, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 2, 47, 7, 71, 8, 0 },
			 { 0, 2, 42, 7, 75, 9, 0 },
			 { 0, 1, 37, 7, 78, 12, 0 },
			 { 0, 1, 32, 7, 81, 14, 0 },
			 { 0, 1, 28, 7, 82, 17, 0 },
			 { 0, 0, 24, 7, 84, 20, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 18, 83, 7, 26, 1, 0 },
			 { 0, 15, 82, 7, 30, 1, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 10, 78, 7, 39, 1, 0 },
			 { 0, 8, 74, 7, 44, 2, 0 },
			 { 0, 7, 69, 7, 50, 2, 0 },
			 { 0, 5, 65, 7, 55, 3, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 3, 55, 7, 65, 5, 0 },
			 { 0, 2, 50, 7, 69, 7, 0 },
			 { 0, 2, 44, 7, 74, 8, 0 },
			 { 0, 1, 39, 7, 78, 10, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 1, 30, 7, 82, 15, 0 },
			 { 0, 1, 26, 7, 83, 18, 0 } },
		.odd = { { 0, 20, 84, 7, 24, 0, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 },
			 { 0, 14, 81, 7, 32, 1, 0 },
			 { 0, 12, 78, 7, 37, 1, 0 },
			 { 0, 9, 75, 7, 42, 2, 0 },
			 { 0, 8, 71, 7, 47, 2, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 2, 47, 7, 71, 8, 0 },
			 { 0, 2, 42, 7, 75, 9, 0 },
			 { 0, 1, 37, 7, 78, 12, 0 },
			 { 0, 1, 32, 7, 81, 14, 0 },
			 { 0, 1, 28, 7, 82, 17, 0 },
			 { 0, 0, 24, 7, 84, 20, 0 } } },
	.ptrn_arr = { { 0x49249249, 0x92492492, 0x24924924 } },
	.sample_patrn_length = 98,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 67) = 0.323232 */
	.hor_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 10, 74, 7, 42, 2, 0 },
			 { 0, 7, 68, 7, 50, 3, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 3, 55, 7, 64, 6, 0 },
			 { 0, 2, 47, 7, 71, 8, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 1, 33, 7, 80, 14, 0 },
			 { 0, 1, 26, 7, 82, 19, 0 },
			 { 0, 21, 82, 7, 24, 1, 0 },
			 { 0, 16, 81, 7, 30, 1, 0 },
			 { 0, 12, 78, 7, 37, 1, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 1, 37, 7, 78, 12, 0 },
			 { 0, 1, 30, 7, 81, 16, 0 },
			 { 0, 1, 24, 7, 82, 21, 0 },
			 { 0, 19, 82, 7, 26, 1, 0 },
			 { 0, 14, 80, 7, 33, 1, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 8, 71, 7, 47, 2, 0 },
			 { 0, 6, 64, 7, 55, 3, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 3, 50, 7, 68, 7, 0 },
			 { 0, 2, 42, 7, 74, 10, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 1, 28, 7, 82, 17, 0 } },
		.odd = { { 0, 20, 82, 7, 25, 1, 0 },
			 { 0, 15, 81, 7, 31, 1, 0 },
			 { 0, 11, 78, 7, 38, 1, 0 },
			 { 0, 8, 72, 7, 46, 2, 0 },
			 { 0, 6, 66, 7, 53, 3, 0 },
			 { 0, 4, 58, 7, 61, 5, 0 },
			 { 0, 3, 51, 7, 67, 7, 0 },
			 { 0, 2, 43, 7, 74, 9, 0 },
			 { 0, 1, 36, 7, 79, 12, 0 },
			 { 0, 1, 29, 7, 81, 17, 0 },
			 { 0, 0, 23, 7, 84, 21, 0 },
			 { 0, 18, 82, 7, 27, 1, 0 },
			 { 0, 14, 79, 7, 34, 1, 0 },
			 { 0, 10, 75, 7, 41, 2, 0 },
			 { 0, 7, 71, 7, 48, 2, 0 },
			 { 0, 5, 63, 7, 56, 4, 0 },
			 { 0, 4, 56, 7, 63, 5, 0 },
			 { 0, 2, 48, 7, 71, 7, 0 },
			 { 0, 2, 41, 7, 75, 10, 0 },
			 { 0, 1, 34, 7, 79, 14, 0 },
			 { 0, 1, 27, 7, 82, 18, 0 },
			 { 0, 21, 84, 7, 23, 0, 0 },
			 { 0, 17, 81, 7, 29, 1, 0 },
			 { 0, 12, 79, 7, 36, 1, 0 },
			 { 0, 9, 74, 7, 43, 2, 0 },
			 { 0, 7, 67, 7, 51, 3, 0 },
			 { 0, 5, 61, 7, 58, 4, 0 },
			 { 0, 3, 53, 7, 66, 6, 0 },
			 { 0, 2, 46, 7, 72, 8, 0 },
			 { 0, 1, 38, 7, 78, 11, 0 },
			 { 0, 1, 31, 7, 81, 15, 0 },
			 { 0, 1, 25, 7, 82, 20, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 22, 84, 7, 22, 0, 0 },
			 { 0, 17, 82, 7, 28, 1, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 10, 74, 7, 42, 2, 0 },
			 { 0, 7, 68, 7, 50, 3, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 3, 55, 7, 64, 6, 0 },
			 { 0, 2, 47, 7, 71, 8, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 1, 33, 7, 80, 14, 0 },
			 { 0, 1, 26, 7, 82, 19, 0 },
			 { 0, 21, 82, 7, 24, 1, 0 },
			 { 0, 16, 81, 7, 30, 1, 0 },
			 { 0, 12, 78, 7, 37, 1, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 6, 67, 7, 52, 3, 0 },
			 { 0, 4, 60, 7, 60, 4, 0 },
			 { 0, 3, 52, 7, 67, 6, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 1, 37, 7, 78, 12, 0 },
			 { 0, 1, 30, 7, 81, 16, 0 },
			 { 0, 1, 24, 7, 82, 21, 0 },
			 { 0, 19, 82, 7, 26, 1, 0 },
			 { 0, 14, 80, 7, 33, 1, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 8, 71, 7, 47, 2, 0 },
			 { 0, 6, 64, 7, 55, 3, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 3, 50, 7, 68, 7, 0 },
			 { 0, 2, 42, 7, 74, 10, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 1, 28, 7, 82, 17, 0 } },
		.odd = { { 0, 20, 82, 7, 25, 1, 0 },
			 { 0, 15, 81, 7, 31, 1, 0 },
			 { 0, 11, 78, 7, 38, 1, 0 },
			 { 0, 8, 72, 7, 46, 2, 0 },
			 { 0, 6, 66, 7, 53, 3, 0 },
			 { 0, 4, 58, 7, 61, 5, 0 },
			 { 0, 3, 51, 7, 67, 7, 0 },
			 { 0, 2, 43, 7, 74, 9, 0 },
			 { 0, 1, 36, 7, 79, 12, 0 },
			 { 0, 1, 29, 7, 81, 17, 0 },
			 { 0, 0, 23, 7, 84, 21, 0 },
			 { 0, 18, 82, 7, 27, 1, 0 },
			 { 0, 14, 79, 7, 34, 1, 0 },
			 { 0, 10, 75, 7, 41, 2, 0 },
			 { 0, 7, 71, 7, 48, 2, 0 },
			 { 0, 5, 63, 7, 56, 4, 0 },
			 { 0, 4, 56, 7, 63, 5, 0 },
			 { 0, 2, 48, 7, 71, 7, 0 },
			 { 0, 2, 41, 7, 75, 10, 0 },
			 { 0, 1, 34, 7, 79, 14, 0 },
			 { 0, 1, 27, 7, 82, 18, 0 },
			 { 0, 21, 84, 7, 23, 0, 0 },
			 { 0, 17, 81, 7, 29, 1, 0 },
			 { 0, 12, 79, 7, 36, 1, 0 },
			 { 0, 9, 74, 7, 43, 2, 0 },
			 { 0, 7, 67, 7, 51, 3, 0 },
			 { 0, 5, 61, 7, 58, 4, 0 },
			 { 0, 3, 53, 7, 66, 6, 0 },
			 { 0, 2, 46, 7, 72, 8, 0 },
			 { 0, 1, 38, 7, 78, 11, 0 },
			 { 0, 1, 31, 7, 81, 15, 0 },
			 { 0, 1, 25, 7, 82, 20, 0 } } },
	.ptrn_arr = { { 0x49249249, 0x92492492, 0x92492490, 0x24924924,
			 0x24924921, 0x49249249, 0x2 } },
	.sample_patrn_length = 198,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 68) = 0.32 */
	.hor_phase_arr = {
		.even = { { 0, 23, 82, 7, 23, 0, 0 },
			 { 0, 16, 80, 7, 31, 1, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 7, 68, 7, 50, 3, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 3, 50, 7, 68, 7, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 1, 31, 7, 80, 16, 0 } },
		.odd = { { 0, 19, 81, 7, 27, 1, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 6, 63, 7, 55, 4, 0 },
			 { 0, 4, 55, 7, 63, 6, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 1, 27, 7, 81, 19, 0 } } },
	.ver_phase_arr = {
		.even = { { 0, 23, 82, 7, 23, 0, 0 },
			 { 0, 16, 80, 7, 31, 1, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 7, 68, 7, 50, 3, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 3, 50, 7, 68, 7, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 1, 31, 7, 80, 16, 0 } },
		.odd = { { 0, 19, 81, 7, 27, 1, 0 },
			 { 0, 13, 79, 7, 35, 1, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 6, 63, 7, 55, 4, 0 },
			 { 0, 4, 55, 7, 63, 6, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 1, 35, 7, 79, 13, 0 },
			 { 0, 1, 27, 7, 81, 19, 0 } } },
	.ptrn_arr = { { 0x49249249, 0x2492 } },
	.sample_patrn_length = 50,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 69) = 0.316832 */
	.hor_phase_arr = {
		.even = { { 1, 23, 80, 7, 23, 1, 0 },
			 { 0, 15, 79, 7, 33, 1, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 },
			 { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 18, 80, 7, 29, 1, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 7, 66, 7, 52, 3, 0 },
			 { 0, 4, 54, 7, 64, 6, 0 },
			 { 0, 2, 42, 7, 74, 10, 0 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 21, 81, 7, 25, 1, 0 },
			 { 0, 14, 78, 7, 35, 1, 0 },
			 { 0, 8, 70, 7, 47, 3, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 3, 47, 7, 70, 8, 0 },
			 { 0, 1, 35, 7, 78, 14, 0 },
			 { 0, 1, 25, 7, 81, 21, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 },
			 { 0, 10, 74, 7, 42, 2, 0 },
			 { 0, 6, 64, 7, 54, 4, 0 },
			 { 0, 3, 52, 7, 66, 7, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 1, 29, 7, 80, 18, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 1, 33, 7, 79, 15, 0 } },
		.odd = { { 0, 19, 80, 7, 28, 1, 0 },
			 { 0, 12, 75, 7, 39, 2, 0 },
			 { 0, 7, 67, 7, 51, 3, 0 },
			 { 0, 4, 56, 7, 62, 6, 0 },
			 { 0, 2, 44, 7, 72, 10, 0 },
			 { 0, 1, 32, 7, 79, 16, 0 },
			 { 0, 22, 81, 7, 24, 1, 0 },
			 { 0, 14, 79, 7, 34, 1, 0 },
			 { 0, 9, 71, 7, 46, 2, 0 },
			 { 0, 5, 60, 7, 58, 5, 0 },
			 { 0, 3, 48, 7, 69, 8, 0 },
			 { 0, 1, 36, 7, 78, 13, 0 },
			 { 0, 1, 26, 7, 81, 20, 0 },
			 { 0, 17, 80, 7, 30, 1, 0 },
			 { 0, 11, 74, 7, 41, 2, 0 },
			 { 0, 6, 65, 7, 53, 4, 0 },
			 { 0, 4, 53, 7, 65, 6, 0 },
			 { 0, 2, 41, 7, 74, 11, 0 },
			 { 0, 1, 30, 7, 80, 17, 0 },
			 { 0, 20, 81, 7, 26, 1, 0 },
			 { 0, 13, 78, 7, 36, 1, 0 },
			 { 0, 8, 69, 7, 48, 3, 0 },
			 { 0, 5, 58, 7, 60, 5, 0 },
			 { 0, 2, 46, 7, 71, 9, 0 },
			 { 0, 1, 34, 7, 79, 14, 0 },
			 { 0, 1, 24, 7, 81, 22, 0 },
			 { 0, 16, 79, 7, 32, 1, 0 },
			 { 0, 10, 72, 7, 44, 2, 0 },
			 { 0, 6, 62, 7, 56, 4, 0 },
			 { 0, 3, 51, 7, 67, 7, 0 },
			 { 0, 2, 39, 7, 75, 12, 0 },
			 { 0, 1, 28, 7, 80, 19, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 23, 80, 7, 23, 1, 0 },
			 { 0, 15, 79, 7, 33, 1, 0 },
			 { 0, 9, 72, 7, 45, 2, 0 },
			 { 0, 5, 62, 7, 57, 4, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 },
			 { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 18, 80, 7, 29, 1, 0 },
			 { 0, 11, 75, 7, 40, 2, 0 },
			 { 0, 7, 66, 7, 52, 3, 0 },
			 { 0, 4, 54, 7, 64, 6, 0 },
			 { 0, 2, 42, 7, 74, 10, 0 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 21, 81, 7, 25, 1, 0 },
			 { 0, 14, 78, 7, 35, 1, 0 },
			 { 0, 8, 70, 7, 47, 3, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 3, 47, 7, 70, 8, 0 },
			 { 0, 1, 35, 7, 78, 14, 0 },
			 { 0, 1, 25, 7, 81, 21, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 },
			 { 0, 10, 74, 7, 42, 2, 0 },
			 { 0, 6, 64, 7, 54, 4, 0 },
			 { 0, 3, 52, 7, 66, 7, 0 },
			 { 0, 2, 40, 7, 75, 11, 0 },
			 { 0, 1, 29, 7, 80, 18, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 4, 57, 7, 62, 5, 0 },
			 { 0, 2, 45, 7, 72, 9, 0 },
			 { 0, 1, 33, 7, 79, 15, 0 } },
		.odd = { { 0, 19, 80, 7, 28, 1, 0 },
			 { 0, 12, 75, 7, 39, 2, 0 },
			 { 0, 7, 67, 7, 51, 3, 0 },
			 { 0, 4, 56, 7, 62, 6, 0 },
			 { 0, 2, 44, 7, 72, 10, 0 },
			 { 0, 1, 32, 7, 79, 16, 0 },
			 { 0, 22, 81, 7, 24, 1, 0 },
			 { 0, 14, 79, 7, 34, 1, 0 },
			 { 0, 9, 71, 7, 46, 2, 0 },
			 { 0, 5, 60, 7, 58, 5, 0 },
			 { 0, 3, 48, 7, 69, 8, 0 },
			 { 0, 1, 36, 7, 78, 13, 0 },
			 { 0, 1, 26, 7, 81, 20, 0 },
			 { 0, 17, 80, 7, 30, 1, 0 },
			 { 0, 11, 74, 7, 41, 2, 0 },
			 { 0, 6, 65, 7, 53, 4, 0 },
			 { 0, 4, 53, 7, 65, 6, 0 },
			 { 0, 2, 41, 7, 74, 11, 0 },
			 { 0, 1, 30, 7, 80, 17, 0 },
			 { 0, 20, 81, 7, 26, 1, 0 },
			 { 0, 13, 78, 7, 36, 1, 0 },
			 { 0, 8, 69, 7, 48, 3, 0 },
			 { 0, 5, 58, 7, 60, 5, 0 },
			 { 0, 2, 46, 7, 71, 9, 0 },
			 { 0, 1, 34, 7, 79, 14, 0 },
			 { 0, 1, 24, 7, 81, 22, 0 },
			 { 0, 16, 79, 7, 32, 1, 0 },
			 { 0, 10, 72, 7, 44, 2, 0 },
			 { 0, 6, 62, 7, 56, 4, 0 },
			 { 0, 3, 51, 7, 67, 7, 0 },
			 { 0, 2, 39, 7, 75, 12, 0 },
			 { 0, 1, 28, 7, 80, 19, 0 } } },
	.ptrn_arr = { { 0x49249249, 0x49249212, 0x49242492, 0x48492492,
			 0x92492492, 0x92492490, 0x24 } },
	.sample_patrn_length = 202,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 70) = 0.313725 */
	.hor_phase_arr = {
		.even = { { 1, 23, 80, 7, 23, 1, 0 },
			 { 0, 14, 77, 7, 36, 1, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 4, 54, 7, 64, 6, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 },
			 { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 },
			 { 0, 10, 71, 7, 45, 2, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 2, 45, 7, 71, 10, 0 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 6, 64, 7, 54, 4, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 1, 36, 7, 77, 14, 0 } },
		.odd = { { 0, 18, 80, 7, 29, 1, 0 },
			 { 0, 11, 73, 7, 42, 2, 0 },
			 { 0, 6, 61, 7, 57, 4, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 1, 33, 7, 79, 15, 0 },
			 { 0, 22, 80, 7, 25, 1, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 7, 65, 7, 52, 4, 0 },
			 { 0, 4, 52, 7, 65, 7, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 },
			 { 0, 1, 25, 7, 80, 22, 0 },
			 { 0, 15, 79, 7, 33, 1, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 4, 57, 7, 61, 6, 0 },
			 { 0, 2, 42, 7, 73, 11, 0 },
			 { 0, 1, 29, 7, 80, 18, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 23, 80, 7, 23, 1, 0 },
			 { 0, 14, 77, 7, 36, 1, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 4, 54, 7, 64, 6, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 },
			 { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 },
			 { 0, 10, 71, 7, 45, 2, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 2, 45, 7, 71, 10, 0 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 6, 64, 7, 54, 4, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 1, 36, 7, 77, 14, 0 } },
		.odd = { { 0, 18, 80, 7, 29, 1, 0 },
			 { 0, 11, 73, 7, 42, 2, 0 },
			 { 0, 6, 61, 7, 57, 4, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 1, 33, 7, 79, 15, 0 },
			 { 0, 22, 80, 7, 25, 1, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 7, 65, 7, 52, 4, 0 },
			 { 0, 4, 52, 7, 65, 7, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 },
			 { 0, 1, 25, 7, 80, 22, 0 },
			 { 0, 15, 79, 7, 33, 1, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 4, 57, 7, 61, 6, 0 },
			 { 0, 2, 42, 7, 73, 11, 0 },
			 { 0, 1, 29, 7, 80, 18, 0 } } },
	.ptrn_arr = { { 0x49249249, 0x49249248, 0x49249242, 0x2 } },
	.sample_patrn_length = 102,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 71) = 0.31068 */
	.hor_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 7, 63, 7, 54, 4, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 19, 79, 7, 29, 1, 0 },
			 { 0, 10, 70, 7, 45, 3, 0 },
			 { 0, 5, 56, 7, 61, 6, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 },
			 { 0, 1, 26, 7, 78, 22, 1 },
			 { 0, 14, 76, 7, 36, 2, 0 },
			 { 0, 7, 65, 7, 52, 4, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 1, 34, 7, 77, 16, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 },
			 { 0, 11, 72, 7, 43, 2, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 2, 43, 7, 72, 11, 0 },
			 { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 16, 77, 7, 34, 1, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 4, 52, 7, 65, 7, 0 },
			 { 0, 2, 36, 7, 76, 14, 0 },
			 { 1, 22, 78, 7, 26, 1, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 6, 61, 7, 56, 5, 0 },
			 { 0, 3, 45, 7, 70, 10, 0 },
			 { 0, 1, 29, 7, 79, 19, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 4, 54, 7, 63, 7, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 } },
		.odd = { { 0, 18, 79, 7, 30, 1, 0 },
			 { 0, 9, 70, 7, 46, 3, 0 },
			 { 0, 4, 55, 7, 63, 6, 0 },
			 { 0, 2, 39, 7, 74, 13, 0 },
			 { 0, 1, 25, 7, 78, 23, 1 },
			 { 0, 14, 75, 7, 37, 2, 0 },
			 { 0, 7, 64, 7, 53, 4, 0 },
			 { 0, 3, 48, 7, 68, 9, 0 },
			 { 0, 1, 33, 7, 77, 17, 0 },
			 { 0, 20, 79, 7, 28, 1, 0 },
			 { 0, 10, 72, 7, 44, 2, 0 },
			 { 0, 5, 58, 7, 59, 6, 0 },
			 { 0, 2, 41, 7, 74, 11, 0 },
			 { 0, 1, 26, 7, 79, 21, 1 },
			 { 0, 15, 77, 7, 35, 1, 0 },
			 { 0, 8, 66, 7, 51, 3, 0 },
			 { 0, 3, 51, 7, 66, 8, 0 },
			 { 0, 1, 35, 7, 77, 15, 0 },
			 { 1, 21, 79, 7, 26, 1, 0 },
			 { 0, 11, 74, 7, 41, 2, 0 },
			 { 0, 6, 59, 7, 58, 5, 0 },
			 { 0, 2, 44, 7, 72, 10, 0 },
			 { 0, 1, 28, 7, 79, 20, 0 },
			 { 0, 17, 77, 7, 33, 1, 0 },
			 { 0, 9, 68, 7, 48, 3, 0 },
			 { 0, 4, 53, 7, 64, 7, 0 },
			 { 0, 2, 37, 7, 75, 14, 0 },
			 { 1, 23, 78, 7, 25, 1, 0 },
			 { 0, 13, 74, 7, 39, 2, 0 },
			 { 0, 6, 63, 7, 55, 4, 0 },
			 { 0, 3, 46, 7, 70, 9, 0 },
			 { 0, 1, 30, 7, 79, 18, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 13, 75, 7, 38, 2, 0 },
			 { 0, 7, 63, 7, 54, 4, 0 },
			 { 0, 3, 47, 7, 69, 9, 0 },
			 { 0, 1, 31, 7, 79, 17, 0 },
			 { 0, 19, 79, 7, 29, 1, 0 },
			 { 0, 10, 70, 7, 45, 3, 0 },
			 { 0, 5, 56, 7, 61, 6, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 },
			 { 0, 1, 26, 7, 78, 22, 1 },
			 { 0, 14, 76, 7, 36, 2, 0 },
			 { 0, 7, 65, 7, 52, 4, 0 },
			 { 0, 3, 50, 7, 67, 8, 0 },
			 { 0, 1, 34, 7, 77, 16, 0 },
			 { 0, 20, 80, 7, 27, 1, 0 },
			 { 0, 11, 72, 7, 43, 2, 0 },
			 { 0, 5, 59, 7, 59, 5, 0 },
			 { 0, 2, 43, 7, 72, 11, 0 },
			 { 0, 1, 27, 7, 80, 20, 0 },
			 { 0, 16, 77, 7, 34, 1, 0 },
			 { 0, 8, 67, 7, 50, 3, 0 },
			 { 0, 4, 52, 7, 65, 7, 0 },
			 { 0, 2, 36, 7, 76, 14, 0 },
			 { 1, 22, 78, 7, 26, 1, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 6, 61, 7, 56, 5, 0 },
			 { 0, 3, 45, 7, 70, 10, 0 },
			 { 0, 1, 29, 7, 79, 19, 0 },
			 { 0, 17, 79, 7, 31, 1, 0 },
			 { 0, 9, 69, 7, 47, 3, 0 },
			 { 0, 4, 54, 7, 63, 7, 0 },
			 { 0, 2, 38, 7, 75, 13, 0 } },
		.odd = { { 0, 18, 79, 7, 30, 1, 0 },
			 { 0, 9, 70, 7, 46, 3, 0 },
			 { 0, 4, 55, 7, 63, 6, 0 },
			 { 0, 2, 39, 7, 74, 13, 0 },
			 { 0, 1, 25, 7, 78, 23, 1 },
			 { 0, 14, 75, 7, 37, 2, 0 },
			 { 0, 7, 64, 7, 53, 4, 0 },
			 { 0, 3, 48, 7, 68, 9, 0 },
			 { 0, 1, 33, 7, 77, 17, 0 },
			 { 0, 20, 79, 7, 28, 1, 0 },
			 { 0, 10, 72, 7, 44, 2, 0 },
			 { 0, 5, 58, 7, 59, 6, 0 },
			 { 0, 2, 41, 7, 74, 11, 0 },
			 { 0, 1, 26, 7, 79, 21, 1 },
			 { 0, 15, 77, 7, 35, 1, 0 },
			 { 0, 8, 66, 7, 51, 3, 0 },
			 { 0, 3, 51, 7, 66, 8, 0 },
			 { 0, 1, 35, 7, 77, 15, 0 },
			 { 1, 21, 79, 7, 26, 1, 0 },
			 { 0, 11, 74, 7, 41, 2, 0 },
			 { 0, 6, 59, 7, 58, 5, 0 },
			 { 0, 2, 44, 7, 72, 10, 0 },
			 { 0, 1, 28, 7, 79, 20, 0 },
			 { 0, 17, 77, 7, 33, 1, 0 },
			 { 0, 9, 68, 7, 48, 3, 0 },
			 { 0, 4, 53, 7, 64, 7, 0 },
			 { 0, 2, 37, 7, 75, 14, 0 },
			 { 1, 23, 78, 7, 25, 1, 0 },
			 { 0, 13, 74, 7, 39, 2, 0 },
			 { 0, 6, 63, 7, 55, 4, 0 },
			 { 0, 3, 46, 7, 70, 9, 0 },
			 { 0, 1, 30, 7, 79, 18, 0 } } },
	.ptrn_arr = { { 0x9249249, 0x21249249, 0x24249249, 0x24849249,
			 0x24909249, 0x24921249, 0x249 } },
	.sample_patrn_length = 206,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 72) = 0.307692 */
	.hor_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 5, 60, 7, 58, 5, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 } },
		.odd = { { 0, 18, 77, 7, 32, 1, 0 },
			 { 0, 8, 68, 7, 49, 3, 0 },
			 { 0, 3, 49, 7, 68, 8, 0 },
			 { 0, 1, 32, 7, 77, 18, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 12, 74, 7, 40, 2, 0 },
			 { 0, 5, 60, 7, 58, 5, 0 },
			 { 0, 2, 40, 7, 74, 12, 0 } },
		.odd = { { 0, 18, 77, 7, 32, 1, 0 },
			 { 0, 8, 68, 7, 49, 3, 0 },
			 { 0, 3, 49, 7, 68, 8, 0 },
			 { 0, 1, 32, 7, 77, 18, 0 } } },
	.ptrn_arr = { { 0x249249 } },
	.sample_patrn_length = 26,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 73) = 0.304762 */
	.hor_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 12, 70, 7, 43, 3, 0 },
			 { 0, 5, 54, 7, 62, 7, 0 },
			 { 0, 2, 34, 7, 76, 16, 0 },
			 { 0, 18, 77, 7, 32, 1, 0 },
			 { 0, 8, 64, 7, 52, 4, 0 },
			 { 0, 3, 45, 7, 69, 11, 0 },
			 { 0, 1, 26, 7, 77, 23, 1 },
			 { 0, 13, 73, 7, 40, 2, 0 },
			 { 0, 5, 56, 7, 61, 6, 0 },
			 { 0, 2, 36, 7, 75, 15, 0 },
			 { 0, 19, 78, 7, 30, 1, 0 },
			 { 0, 9, 66, 7, 49, 4, 0 },
			 { 0, 3, 47, 7, 68, 10, 0 },
			 { 0, 1, 28, 7, 77, 21, 1 },
			 { 0, 14, 74, 7, 38, 2, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 2, 38, 7, 74, 14, 0 },
			 { 1, 21, 77, 7, 28, 1, 0 },
			 { 0, 10, 68, 7, 47, 3, 0 },
			 { 0, 4, 49, 7, 66, 9, 0 },
			 { 0, 1, 30, 7, 78, 19, 0 },
			 { 0, 15, 75, 7, 36, 2, 0 },
			 { 0, 6, 61, 7, 56, 5, 0 },
			 { 0, 2, 40, 7, 73, 13, 0 },
			 { 1, 23, 77, 7, 26, 1, 0 },
			 { 0, 11, 69, 7, 45, 3, 0 },
			 { 0, 4, 52, 7, 64, 8, 0 },
			 { 0, 1, 32, 7, 77, 18, 0 },
			 { 0, 16, 76, 7, 34, 2, 0 },
			 { 0, 7, 62, 7, 54, 5, 0 },
			 { 0, 3, 43, 7, 70, 12, 0 } },
		.odd = { { 0, 17, 77, 7, 33, 1, 0 },
			 { 0, 7, 64, 7, 53, 4, 0 },
			 { 0, 3, 44, 7, 70, 11, 0 },
			 { 0, 1, 25, 7, 78, 23, 1 },
			 { 0, 12, 72, 7, 42, 2, 0 },
			 { 0, 5, 55, 7, 61, 7, 0 },
			 { 0, 2, 35, 7, 75, 16, 0 },
			 { 0, 19, 77, 7, 31, 1, 0 },
			 { 0, 8, 65, 7, 51, 4, 0 },
			 { 0, 3, 46, 7, 69, 10, 0 },
			 { 0, 1, 27, 7, 77, 22, 1 },
			 { 0, 13, 74, 7, 39, 2, 0 },
			 { 0, 5, 57, 7, 60, 6, 0 },
			 { 0, 2, 37, 7, 75, 14, 0 },
			 { 1, 20, 77, 7, 29, 1, 0 },
			 { 0, 9, 68, 7, 48, 3, 0 },
			 { 0, 3, 48, 7, 68, 9, 0 },
			 { 0, 1, 29, 7, 77, 20, 1 },
			 { 0, 14, 75, 7, 37, 2, 0 },
			 { 0, 6, 60, 7, 57, 5, 0 },
			 { 0, 2, 39, 7, 74, 13, 0 },
			 { 1, 22, 77, 7, 27, 1, 0 },
			 { 0, 10, 69, 7, 46, 3, 0 },
			 { 0, 4, 51, 7, 65, 8, 0 },
			 { 0, 1, 31, 7, 77, 19, 0 },
			 { 0, 16, 75, 7, 35, 2, 0 },
			 { 0, 7, 61, 7, 55, 5, 0 },
			 { 0, 2, 42, 7, 72, 12, 0 },
			 { 1, 23, 78, 7, 25, 1, 0 },
			 { 0, 11, 70, 7, 44, 3, 0 },
			 { 0, 4, 53, 7, 64, 7, 0 },
			 { 0, 1, 33, 7, 77, 17, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 24, 78, 7, 24, 1, 0 },
			 { 0, 12, 70, 7, 43, 3, 0 },
			 { 0, 5, 54, 7, 62, 7, 0 },
			 { 0, 2, 34, 7, 76, 16, 0 },
			 { 0, 18, 77, 7, 32, 1, 0 },
			 { 0, 8, 64, 7, 52, 4, 0 },
			 { 0, 3, 45, 7, 69, 11, 0 },
			 { 0, 1, 26, 7, 77, 23, 1 },
			 { 0, 13, 73, 7, 40, 2, 0 },
			 { 0, 5, 56, 7, 61, 6, 0 },
			 { 0, 2, 36, 7, 75, 15, 0 },
			 { 0, 19, 78, 7, 30, 1, 0 },
			 { 0, 9, 66, 7, 49, 4, 0 },
			 { 0, 3, 47, 7, 68, 10, 0 },
			 { 0, 1, 28, 7, 77, 21, 1 },
			 { 0, 14, 74, 7, 38, 2, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 2, 38, 7, 74, 14, 0 },
			 { 1, 21, 77, 7, 28, 1, 0 },
			 { 0, 10, 68, 7, 47, 3, 0 },
			 { 0, 4, 49, 7, 66, 9, 0 },
			 { 0, 1, 30, 7, 78, 19, 0 },
			 { 0, 15, 75, 7, 36, 2, 0 },
			 { 0, 6, 61, 7, 56, 5, 0 },
			 { 0, 2, 40, 7, 73, 13, 0 },
			 { 1, 23, 77, 7, 26, 1, 0 },
			 { 0, 11, 69, 7, 45, 3, 0 },
			 { 0, 4, 52, 7, 64, 8, 0 },
			 { 0, 1, 32, 7, 77, 18, 0 },
			 { 0, 16, 76, 7, 34, 2, 0 },
			 { 0, 7, 62, 7, 54, 5, 0 },
			 { 0, 3, 43, 7, 70, 12, 0 } },
		.odd = { { 0, 17, 77, 7, 33, 1, 0 },
			 { 0, 7, 64, 7, 53, 4, 0 },
			 { 0, 3, 44, 7, 70, 11, 0 },
			 { 0, 1, 25, 7, 78, 23, 1 },
			 { 0, 12, 72, 7, 42, 2, 0 },
			 { 0, 5, 55, 7, 61, 7, 0 },
			 { 0, 2, 35, 7, 75, 16, 0 },
			 { 0, 19, 77, 7, 31, 1, 0 },
			 { 0, 8, 65, 7, 51, 4, 0 },
			 { 0, 3, 46, 7, 69, 10, 0 },
			 { 0, 1, 27, 7, 77, 22, 1 },
			 { 0, 13, 74, 7, 39, 2, 0 },
			 { 0, 5, 57, 7, 60, 6, 0 },
			 { 0, 2, 37, 7, 75, 14, 0 },
			 { 1, 20, 77, 7, 29, 1, 0 },
			 { 0, 9, 68, 7, 48, 3, 0 },
			 { 0, 3, 48, 7, 68, 9, 0 },
			 { 0, 1, 29, 7, 77, 20, 1 },
			 { 0, 14, 75, 7, 37, 2, 0 },
			 { 0, 6, 60, 7, 57, 5, 0 },
			 { 0, 2, 39, 7, 74, 13, 0 },
			 { 1, 22, 77, 7, 27, 1, 0 },
			 { 0, 10, 69, 7, 46, 3, 0 },
			 { 0, 4, 51, 7, 65, 8, 0 },
			 { 0, 1, 31, 7, 77, 19, 0 },
			 { 0, 16, 75, 7, 35, 2, 0 },
			 { 0, 7, 61, 7, 55, 5, 0 },
			 { 0, 2, 42, 7, 72, 12, 0 },
			 { 1, 23, 78, 7, 25, 1, 0 },
			 { 0, 11, 70, 7, 44, 3, 0 },
			 { 0, 4, 53, 7, 64, 7, 0 },
			 { 0, 1, 33, 7, 77, 17, 0 } } },
	.ptrn_arr = { { 0x24249249, 0x24921249, 0x84924909, 0x92424924,
			 0x92492124, 0x48492490, 0x2492 } },
	.sample_patrn_length = 210,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 74) = 0.301887 */
	.hor_phase_arr = {
		.even = { { 1, 25, 76, 7, 25, 1, 0 },
			 { 0, 11, 69, 7, 45, 3, 0 },
			 { 0, 4, 49, 7, 66, 9, 0 },
			 { 0, 1, 28, 7, 77, 21, 1 },
			 { 0, 13, 72, 7, 41, 2, 0 },
			 { 0, 5, 54, 7, 62, 7, 0 },
			 { 0, 1, 32, 7, 77, 18, 0 },
			 { 0, 15, 75, 7, 36, 2, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 2, 36, 7, 75, 15, 0 },
			 { 0, 18, 77, 7, 32, 1, 0 },
			 { 0, 7, 62, 7, 54, 5, 0 },
			 { 0, 2, 41, 7, 72, 13, 0 },
			 { 1, 21, 77, 7, 28, 1, 0 },
			 { 0, 9, 66, 7, 49, 4, 0 },
			 { 0, 3, 45, 7, 69, 11, 0 } },
		.odd = { { 0, 17, 75, 7, 34, 2, 0 },
			 { 0, 7, 60, 7, 56, 5, 0 },
			 { 0, 2, 38, 7, 74, 14, 0 },
			 { 1, 20, 76, 7, 30, 1, 0 },
			 { 0, 8, 64, 7, 52, 4, 0 },
			 { 0, 3, 43, 7, 70, 12, 0 },
			 { 1, 23, 77, 7, 26, 1, 0 },
			 { 0, 10, 68, 7, 47, 3, 0 },
			 { 0, 3, 47, 7, 68, 10, 0 },
			 { 0, 1, 26, 7, 77, 23, 1 },
			 { 0, 12, 70, 7, 43, 3, 0 },
			 { 0, 4, 52, 7, 64, 8, 0 },
			 { 0, 1, 30, 7, 76, 20, 1 },
			 { 0, 14, 74, 7, 38, 2, 0 },
			 { 0, 5, 56, 7, 60, 7, 0 },
			 { 0, 2, 34, 7, 75, 17, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 25, 76, 7, 25, 1, 0 },
			 { 0, 11, 69, 7, 45, 3, 0 },
			 { 0, 4, 49, 7, 66, 9, 0 },
			 { 0, 1, 28, 7, 77, 21, 1 },
			 { 0, 13, 72, 7, 41, 2, 0 },
			 { 0, 5, 54, 7, 62, 7, 0 },
			 { 0, 1, 32, 7, 77, 18, 0 },
			 { 0, 15, 75, 7, 36, 2, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 2, 36, 7, 75, 15, 0 },
			 { 0, 18, 77, 7, 32, 1, 0 },
			 { 0, 7, 62, 7, 54, 5, 0 },
			 { 0, 2, 41, 7, 72, 13, 0 },
			 { 1, 21, 77, 7, 28, 1, 0 },
			 { 0, 9, 66, 7, 49, 4, 0 },
			 { 0, 3, 45, 7, 69, 11, 0 } },
		.odd = { { 0, 17, 75, 7, 34, 2, 0 },
			 { 0, 7, 60, 7, 56, 5, 0 },
			 { 0, 2, 38, 7, 74, 14, 0 },
			 { 1, 20, 76, 7, 30, 1, 0 },
			 { 0, 8, 64, 7, 52, 4, 0 },
			 { 0, 3, 43, 7, 70, 12, 0 },
			 { 1, 23, 77, 7, 26, 1, 0 },
			 { 0, 10, 68, 7, 47, 3, 0 },
			 { 0, 3, 47, 7, 68, 10, 0 },
			 { 0, 1, 26, 7, 77, 23, 1 },
			 { 0, 12, 70, 7, 43, 3, 0 },
			 { 0, 4, 52, 7, 64, 8, 0 },
			 { 0, 1, 30, 7, 76, 20, 1 },
			 { 0, 14, 74, 7, 38, 2, 0 },
			 { 0, 5, 56, 7, 60, 7, 0 },
			 { 0, 2, 34, 7, 75, 17, 0 } } },
	.ptrn_arr = { { 0x24849249, 0x24924849, 0x92424924, 0x24 } },
	.sample_patrn_length = 106,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 75) = 0.299065 */
	.hor_phase_arr = {
		.even = { { 1, 25, 76, 7, 25, 1, 0 },
			 { 0, 10, 67, 7, 47, 4, 0 },
			 { 0, 3, 45, 7, 69, 11, 0 },
			 { 1, 23, 76, 7, 27, 1, 0 },
			 { 0, 9, 66, 7, 49, 4, 0 },
			 { 0, 3, 43, 7, 70, 12, 0 },
			 { 1, 22, 75, 7, 29, 1, 0 },
			 { 0, 8, 65, 7, 51, 4, 0 },
			 { 0, 2, 41, 7, 72, 13, 0 },
			 { 1, 20, 76, 7, 30, 1, 0 },
			 { 0, 8, 61, 7, 54, 5, 0 },
			 { 0, 2, 39, 7, 72, 15, 0 },
			 { 0, 19, 76, 7, 32, 1, 0 },
			 { 0, 7, 59, 7, 56, 6, 0 },
			 { 0, 2, 36, 7, 74, 16, 0 },
			 { 0, 17, 75, 7, 34, 2, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 2, 34, 7, 75, 17, 0 },
			 { 0, 16, 74, 7, 36, 2, 0 },
			 { 0, 6, 56, 7, 59, 7, 0 },
			 { 0, 1, 32, 7, 76, 19, 0 },
			 { 0, 15, 72, 7, 39, 2, 0 },
			 { 0, 5, 54, 7, 61, 8, 0 },
			 { 0, 1, 30, 7, 76, 20, 1 },
			 { 0, 13, 72, 7, 41, 2, 0 },
			 { 0, 4, 51, 7, 65, 8, 0 },
			 { 0, 1, 29, 7, 75, 22, 1 },
			 { 0, 12, 70, 7, 43, 3, 0 },
			 { 0, 4, 49, 7, 66, 9, 0 },
			 { 0, 1, 27, 7, 76, 23, 1 },
			 { 0, 11, 69, 7, 45, 3, 0 },
			 { 0, 4, 47, 7, 67, 10, 0 } },
		.odd = { { 0, 16, 75, 7, 35, 2, 0 },
			 { 0, 6, 57, 7, 58, 7, 0 },
			 { 0, 2, 33, 7, 75, 18, 0 },
			 { 0, 15, 73, 7, 38, 2, 0 },
			 { 0, 5, 55, 7, 61, 7, 0 },
			 { 0, 1, 31, 7, 76, 19, 1 },
			 { 0, 14, 72, 7, 40, 2, 0 },
			 { 0, 5, 53, 7, 62, 8, 0 },
			 { 0, 1, 30, 7, 75, 21, 1 },
			 { 0, 13, 70, 7, 42, 3, 0 },
			 { 0, 4, 50, 7, 65, 9, 0 },
			 { 0, 1, 28, 7, 76, 22, 1 },
			 { 0, 12, 69, 7, 44, 3, 0 },
			 { 0, 4, 48, 7, 66, 10, 0 },
			 { 0, 1, 26, 7, 76, 24, 1 },
			 { 0, 11, 68, 7, 46, 3, 0 },
			 { 0, 3, 46, 7, 68, 11, 0 },
			 { 1, 24, 76, 7, 26, 1, 0 },
			 { 0, 10, 66, 7, 48, 4, 0 },
			 { 0, 3, 44, 7, 69, 12, 0 },
			 { 1, 22, 76, 7, 28, 1, 0 },
			 { 0, 9, 65, 7, 50, 4, 0 },
			 { 0, 3, 42, 7, 70, 13, 0 },
			 { 1, 21, 75, 7, 30, 1, 0 },
			 { 0, 8, 62, 7, 53, 5, 0 },
			 { 0, 2, 40, 7, 72, 14, 0 },
			 { 1, 19, 76, 7, 31, 1, 0 },
			 { 0, 7, 61, 7, 55, 5, 0 },
			 { 0, 2, 38, 7, 73, 15, 0 },
			 { 0, 18, 75, 7, 33, 2, 0 },
			 { 0, 7, 58, 7, 57, 6, 0 },
			 { 0, 2, 35, 7, 75, 16, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 25, 76, 7, 25, 1, 0 },
			 { 0, 10, 67, 7, 47, 4, 0 },
			 { 0, 3, 45, 7, 69, 11, 0 },
			 { 1, 23, 76, 7, 27, 1, 0 },
			 { 0, 9, 66, 7, 49, 4, 0 },
			 { 0, 3, 43, 7, 70, 12, 0 },
			 { 1, 22, 75, 7, 29, 1, 0 },
			 { 0, 8, 65, 7, 51, 4, 0 },
			 { 0, 2, 41, 7, 72, 13, 0 },
			 { 1, 20, 76, 7, 30, 1, 0 },
			 { 0, 8, 61, 7, 54, 5, 0 },
			 { 0, 2, 39, 7, 72, 15, 0 },
			 { 0, 19, 76, 7, 32, 1, 0 },
			 { 0, 7, 59, 7, 56, 6, 0 },
			 { 0, 2, 36, 7, 74, 16, 0 },
			 { 0, 17, 75, 7, 34, 2, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 2, 34, 7, 75, 17, 0 },
			 { 0, 16, 74, 7, 36, 2, 0 },
			 { 0, 6, 56, 7, 59, 7, 0 },
			 { 0, 1, 32, 7, 76, 19, 0 },
			 { 0, 15, 72, 7, 39, 2, 0 },
			 { 0, 5, 54, 7, 61, 8, 0 },
			 { 0, 1, 30, 7, 76, 20, 1 },
			 { 0, 13, 72, 7, 41, 2, 0 },
			 { 0, 4, 51, 7, 65, 8, 0 },
			 { 0, 1, 29, 7, 75, 22, 1 },
			 { 0, 12, 70, 7, 43, 3, 0 },
			 { 0, 4, 49, 7, 66, 9, 0 },
			 { 0, 1, 27, 7, 76, 23, 1 },
			 { 0, 11, 69, 7, 45, 3, 0 },
			 { 0, 4, 47, 7, 67, 10, 0 } },
		.odd = { { 0, 16, 75, 7, 35, 2, 0 },
			 { 0, 6, 57, 7, 58, 7, 0 },
			 { 0, 2, 33, 7, 75, 18, 0 },
			 { 0, 15, 73, 7, 38, 2, 0 },
			 { 0, 5, 55, 7, 61, 7, 0 },
			 { 0, 1, 31, 7, 76, 19, 1 },
			 { 0, 14, 72, 7, 40, 2, 0 },
			 { 0, 5, 53, 7, 62, 8, 0 },
			 { 0, 1, 30, 7, 75, 21, 1 },
			 { 0, 13, 70, 7, 42, 3, 0 },
			 { 0, 4, 50, 7, 65, 9, 0 },
			 { 0, 1, 28, 7, 76, 22, 1 },
			 { 0, 12, 69, 7, 44, 3, 0 },
			 { 0, 4, 48, 7, 66, 10, 0 },
			 { 0, 1, 26, 7, 76, 24, 1 },
			 { 0, 11, 68, 7, 46, 3, 0 },
			 { 0, 3, 46, 7, 68, 11, 0 },
			 { 1, 24, 76, 7, 26, 1, 0 },
			 { 0, 10, 66, 7, 48, 4, 0 },
			 { 0, 3, 44, 7, 69, 12, 0 },
			 { 1, 22, 76, 7, 28, 1, 0 },
			 { 0, 9, 65, 7, 50, 4, 0 },
			 { 0, 3, 42, 7, 70, 13, 0 },
			 { 1, 21, 75, 7, 30, 1, 0 },
			 { 0, 8, 62, 7, 53, 5, 0 },
			 { 0, 2, 40, 7, 72, 14, 0 },
			 { 1, 19, 76, 7, 31, 1, 0 },
			 { 0, 7, 61, 7, 55, 5, 0 },
			 { 0, 2, 38, 7, 73, 15, 0 },
			 { 0, 18, 75, 7, 33, 2, 0 },
			 { 0, 7, 58, 7, 57, 6, 0 },
			 { 0, 2, 35, 7, 75, 16, 0 } } },
	.ptrn_arr = { { 0x24909249, 0x90924909, 0x92490924, 0x49212490,
			 0x21249212, 0x24921249, 0x24921 } },
	.sample_patrn_length = 214,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 76) = 0.296296 */
	.hor_phase_arr = {
		.even = { { 1, 25, 76, 7, 25, 1, 0 },
			 { 0, 10, 65, 7, 49, 4, 0 },
			 { 0, 3, 41, 7, 70, 14, 0 },
			 { 1, 19, 73, 7, 33, 2, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 2, 33, 7, 73, 19, 1 },
			 { 0, 14, 70, 7, 41, 3, 0 },
			 { 0, 4, 49, 7, 65, 10, 0 } },
		.odd = { { 0, 16, 73, 7, 37, 2, 0 },
			 { 0, 5, 53, 7, 62, 8, 0 },
			 { 0, 1, 29, 7, 75, 22, 1 },
			 { 0, 11, 69, 7, 45, 3, 0 },
			 { 0, 3, 45, 7, 69, 11, 0 },
			 { 1, 22, 75, 7, 29, 1, 0 },
			 { 0, 8, 62, 7, 53, 5, 0 },
			 { 0, 2, 37, 7, 73, 16, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 25, 76, 7, 25, 1, 0 },
			 { 0, 10, 65, 7, 49, 4, 0 },
			 { 0, 3, 41, 7, 70, 14, 0 },
			 { 1, 19, 73, 7, 33, 2, 0 },
			 { 0, 6, 58, 7, 58, 6, 0 },
			 { 0, 2, 33, 7, 73, 19, 1 },
			 { 0, 14, 70, 7, 41, 3, 0 },
			 { 0, 4, 49, 7, 65, 10, 0 } },
		.odd = { { 0, 16, 73, 7, 37, 2, 0 },
			 { 0, 5, 53, 7, 62, 8, 0 },
			 { 0, 1, 29, 7, 75, 22, 1 },
			 { 0, 11, 69, 7, 45, 3, 0 },
			 { 0, 3, 45, 7, 69, 11, 0 },
			 { 1, 22, 75, 7, 29, 1, 0 },
			 { 0, 8, 62, 7, 53, 5, 0 },
			 { 0, 2, 37, 7, 73, 16, 0 } } },
	.ptrn_arr = { { 0x24909249, 0x24921 } },
	.sample_patrn_length = 54,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 77) = 0.293578 */
	.hor_phase_arr = {
		.even = { { 1, 26, 74, 7, 26, 1, 0 },
			 { 0, 9, 63, 7, 51, 5, 0 },
			 { 0, 2, 37, 7, 73, 16, 0 },
			 { 0, 15, 72, 7, 39, 2, 0 },
			 { 0, 4, 49, 7, 65, 10, 0 },
			 { 1, 24, 75, 7, 27, 1, 0 },
			 { 0, 8, 62, 7, 53, 5, 0 },
			 { 0, 2, 35, 7, 72, 18, 1 },
			 { 0, 14, 70, 7, 41, 3, 0 },
			 { 0, 4, 47, 7, 66, 11, 0 },
			 { 1, 22, 75, 7, 29, 1, 0 },
			 { 0, 7, 60, 7, 55, 6, 0 },
			 { 0, 2, 33, 7, 73, 19, 1 },
			 { 0, 13, 69, 7, 43, 3, 0 },
			 { 0, 3, 45, 7, 68, 12, 0 },
			 { 1, 21, 74, 7, 31, 1, 0 },
			 { 0, 7, 57, 7, 57, 7, 0 },
			 { 0, 1, 31, 7, 74, 21, 1 },
			 { 0, 12, 68, 7, 45, 3, 0 },
			 { 0, 3, 43, 7, 69, 13, 0 },
			 { 1, 19, 73, 7, 33, 2, 0 },
			 { 0, 6, 55, 7, 60, 7, 0 },
			 { 0, 1, 29, 7, 75, 22, 1 },
			 { 0, 11, 66, 7, 47, 4, 0 },
			 { 0, 3, 41, 7, 70, 14, 0 },
			 { 1, 18, 72, 7, 35, 2, 0 },
			 { 0, 5, 53, 7, 62, 8, 0 },
			 { 0, 1, 27, 7, 75, 24, 1 },
			 { 0, 10, 65, 7, 49, 4, 0 },
			 { 0, 2, 39, 7, 72, 15, 0 },
			 { 0, 16, 73, 7, 37, 2, 0 },
			 { 0, 5, 51, 7, 63, 9, 0 } },
		.odd = { { 0, 16, 72, 7, 38, 2, 0 },
			 { 0, 5, 50, 7, 64, 9, 0 },
			 { 1, 25, 75, 7, 26, 1, 0 },
			 { 0, 8, 63, 7, 52, 5, 0 },
			 { 0, 2, 36, 7, 73, 17, 0 },
			 { 0, 15, 70, 7, 40, 3, 0 },
			 { 0, 4, 48, 7, 66, 10, 0 },
			 { 1, 23, 75, 7, 28, 1, 0 },
			 { 0, 8, 60, 7, 54, 6, 0 },
			 { 0, 2, 34, 7, 73, 18, 1 },
			 { 0, 13, 70, 7, 42, 3, 0 },
			 { 0, 4, 46, 7, 67, 11, 0 },
			 { 1, 21, 75, 7, 30, 1, 0 },
			 { 0, 7, 59, 7, 56, 6, 0 },
			 { 0, 2, 32, 7, 73, 20, 1 },
			 { 0, 12, 69, 7, 44, 3, 0 },
			 { 0, 3, 44, 7, 69, 12, 0 },
			 { 1, 20, 73, 7, 32, 2, 0 },
			 { 0, 6, 56, 7, 59, 7, 0 },
			 { 0, 1, 30, 7, 75, 21, 1 },
			 { 0, 11, 67, 7, 46, 4, 0 },
			 { 0, 3, 42, 7, 70, 13, 0 },
			 { 1, 18, 73, 7, 34, 2, 0 },
			 { 0, 6, 54, 7, 60, 8, 0 },
			 { 0, 1, 28, 7, 75, 23, 1 },
			 { 0, 10, 66, 7, 48, 4, 0 },
			 { 0, 3, 40, 7, 70, 15, 0 },
			 { 0, 17, 73, 7, 36, 2, 0 },
			 { 0, 5, 52, 7, 63, 8, 0 },
			 { 0, 1, 26, 7, 75, 25, 1 },
			 { 0, 9, 64, 7, 50, 5, 0 },
			 { 0, 2, 38, 7, 72, 16, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 26, 74, 7, 26, 1, 0 },
			 { 0, 9, 63, 7, 51, 5, 0 },
			 { 0, 2, 37, 7, 73, 16, 0 },
			 { 0, 15, 72, 7, 39, 2, 0 },
			 { 0, 4, 49, 7, 65, 10, 0 },
			 { 1, 24, 75, 7, 27, 1, 0 },
			 { 0, 8, 62, 7, 53, 5, 0 },
			 { 0, 2, 35, 7, 72, 18, 1 },
			 { 0, 14, 70, 7, 41, 3, 0 },
			 { 0, 4, 47, 7, 66, 11, 0 },
			 { 1, 22, 75, 7, 29, 1, 0 },
			 { 0, 7, 60, 7, 55, 6, 0 },
			 { 0, 2, 33, 7, 73, 19, 1 },
			 { 0, 13, 69, 7, 43, 3, 0 },
			 { 0, 3, 45, 7, 68, 12, 0 },
			 { 1, 21, 74, 7, 31, 1, 0 },
			 { 0, 7, 57, 7, 57, 7, 0 },
			 { 0, 1, 31, 7, 74, 21, 1 },
			 { 0, 12, 68, 7, 45, 3, 0 },
			 { 0, 3, 43, 7, 69, 13, 0 },
			 { 1, 19, 73, 7, 33, 2, 0 },
			 { 0, 6, 55, 7, 60, 7, 0 },
			 { 0, 1, 29, 7, 75, 22, 1 },
			 { 0, 11, 66, 7, 47, 4, 0 },
			 { 0, 3, 41, 7, 70, 14, 0 },
			 { 1, 18, 72, 7, 35, 2, 0 },
			 { 0, 5, 53, 7, 62, 8, 0 },
			 { 0, 1, 27, 7, 75, 24, 1 },
			 { 0, 10, 65, 7, 49, 4, 0 },
			 { 0, 2, 39, 7, 72, 15, 0 },
			 { 0, 16, 73, 7, 37, 2, 0 },
			 { 0, 5, 51, 7, 63, 9, 0 } },
		.odd = { { 0, 16, 72, 7, 38, 2, 0 },
			 { 0, 5, 50, 7, 64, 9, 0 },
			 { 1, 25, 75, 7, 26, 1, 0 },
			 { 0, 8, 63, 7, 52, 5, 0 },
			 { 0, 2, 36, 7, 73, 17, 0 },
			 { 0, 15, 70, 7, 40, 3, 0 },
			 { 0, 4, 48, 7, 66, 10, 0 },
			 { 1, 23, 75, 7, 28, 1, 0 },
			 { 0, 8, 60, 7, 54, 6, 0 },
			 { 0, 2, 34, 7, 73, 18, 1 },
			 { 0, 13, 70, 7, 42, 3, 0 },
			 { 0, 4, 46, 7, 67, 11, 0 },
			 { 1, 21, 75, 7, 30, 1, 0 },
			 { 0, 7, 59, 7, 56, 6, 0 },
			 { 0, 2, 32, 7, 73, 20, 1 },
			 { 0, 12, 69, 7, 44, 3, 0 },
			 { 0, 3, 44, 7, 69, 12, 0 },
			 { 1, 20, 73, 7, 32, 2, 0 },
			 { 0, 6, 56, 7, 59, 7, 0 },
			 { 0, 1, 30, 7, 75, 21, 1 },
			 { 0, 11, 67, 7, 46, 4, 0 },
			 { 0, 3, 42, 7, 70, 13, 0 },
			 { 1, 18, 73, 7, 34, 2, 0 },
			 { 0, 6, 54, 7, 60, 8, 0 },
			 { 0, 1, 28, 7, 75, 23, 1 },
			 { 0, 10, 66, 7, 48, 4, 0 },
			 { 0, 3, 40, 7, 70, 15, 0 },
			 { 0, 17, 73, 7, 36, 2, 0 },
			 { 0, 5, 52, 7, 63, 8, 0 },
			 { 0, 1, 26, 7, 75, 25, 1 },
			 { 0, 9, 64, 7, 50, 5, 0 },
			 { 0, 2, 38, 7, 72, 16, 0 } } },
	.ptrn_arr = { { 0x24921249, 0x92484924, 0x49212490, 0x24849242,
			 0x92124909, 0x48492424, 0x249092 } },
	.sample_patrn_length = 218,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 78) = 0.290909 */
	.hor_phase_arr = {
		.even = { { 1, 26, 74, 7, 26, 1, 0 },
			 { 0, 8, 61, 7, 53, 6, 0 },
			 { 0, 2, 33, 7, 73, 19, 1 },
			 { 0, 12, 67, 7, 45, 4, 0 },
			 { 0, 3, 41, 7, 70, 14, 0 },
			 { 0, 17, 72, 7, 37, 2, 0 },
			 { 0, 5, 49, 7, 64, 10, 0 },
			 { 1, 22, 75, 7, 29, 1, 0 },
			 { 0, 7, 57, 7, 57, 7, 0 },
			 { 0, 1, 29, 7, 75, 22, 1 },
			 { 0, 10, 64, 7, 49, 5, 0 },
			 { 0, 2, 37, 7, 72, 17, 0 },
			 { 0, 14, 70, 7, 41, 3, 0 },
			 { 0, 4, 45, 7, 67, 12, 0 },
			 { 1, 19, 73, 7, 33, 2, 0 },
			 { 0, 6, 53, 7, 61, 8, 0 } },
		.odd = { { 0, 15, 71, 7, 39, 3, 0 },
			 { 0, 4, 47, 7, 66, 11, 0 },
			 { 1, 21, 73, 7, 31, 2, 0 },
			 { 0, 6, 55, 7, 59, 8, 0 },
			 { 0, 1, 28, 7, 74, 24, 1 },
			 { 0, 9, 63, 7, 51, 5, 0 },
			 { 0, 2, 35, 7, 72, 18, 1 },
			 { 0, 13, 69, 7, 43, 3, 0 },
			 { 0, 3, 43, 7, 69, 13, 0 },
			 { 1, 18, 72, 7, 35, 2, 0 },
			 { 0, 5, 51, 7, 63, 9, 0 },
			 { 1, 24, 74, 7, 28, 1, 0 },
			 { 0, 8, 59, 7, 55, 6, 0 },
			 { 0, 2, 31, 7, 73, 21, 1 },
			 { 0, 11, 66, 7, 47, 4, 0 },
			 { 0, 3, 39, 7, 71, 15, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 26, 74, 7, 26, 1, 0 },
			 { 0, 8, 61, 7, 53, 6, 0 },
			 { 0, 2, 33, 7, 73, 19, 1 },
			 { 0, 12, 67, 7, 45, 4, 0 },
			 { 0, 3, 41, 7, 70, 14, 0 },
			 { 0, 17, 72, 7, 37, 2, 0 },
			 { 0, 5, 49, 7, 64, 10, 0 },
			 { 1, 22, 75, 7, 29, 1, 0 },
			 { 0, 7, 57, 7, 57, 7, 0 },
			 { 0, 1, 29, 7, 75, 22, 1 },
			 { 0, 10, 64, 7, 49, 5, 0 },
			 { 0, 2, 37, 7, 72, 17, 0 },
			 { 0, 14, 70, 7, 41, 3, 0 },
			 { 0, 4, 45, 7, 67, 12, 0 },
			 { 1, 19, 73, 7, 33, 2, 0 },
			 { 0, 6, 53, 7, 61, 8, 0 } },
		.odd = { { 0, 15, 71, 7, 39, 3, 0 },
			 { 0, 4, 47, 7, 66, 11, 0 },
			 { 1, 21, 73, 7, 31, 2, 0 },
			 { 0, 6, 55, 7, 59, 8, 0 },
			 { 0, 1, 28, 7, 74, 24, 1 },
			 { 0, 9, 63, 7, 51, 5, 0 },
			 { 0, 2, 35, 7, 72, 18, 1 },
			 { 0, 13, 69, 7, 43, 3, 0 },
			 { 0, 3, 43, 7, 69, 13, 0 },
			 { 1, 18, 72, 7, 35, 2, 0 },
			 { 0, 5, 51, 7, 63, 9, 0 },
			 { 1, 24, 74, 7, 28, 1, 0 },
			 { 0, 8, 59, 7, 55, 6, 0 },
			 { 0, 2, 31, 7, 73, 21, 1 },
			 { 0, 11, 66, 7, 47, 4, 0 },
			 { 0, 3, 39, 7, 71, 15, 0 } } },
	.ptrn_arr = { { 0x24921249, 0x12490924, 0x9248492, 0x249 } },
	.sample_patrn_length = 110,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 79) = 0.288288 */
	.hor_phase_arr = {
		.even = { { 1, 26, 74, 7, 26, 1, 0 },
			 { 0, 8, 59, 7, 55, 6, 0 },
			 { 0, 1, 30, 7, 73, 23, 1 },
			 { 0, 9, 63, 7, 51, 5, 0 },
			 { 0, 2, 33, 7, 72, 20, 1 },
			 { 0, 11, 66, 7, 47, 4, 0 },
			 { 0, 2, 37, 7, 71, 17, 1 },
			 { 0, 13, 69, 7, 43, 3, 0 },
			 { 0, 3, 41, 7, 69, 15, 0 },
			 { 0, 16, 70, 7, 39, 3, 0 },
			 { 0, 4, 45, 7, 67, 12, 0 },
			 { 1, 18, 72, 7, 35, 2, 0 },
			 { 0, 5, 49, 7, 64, 10, 0 },
			 { 1, 21, 73, 7, 31, 2, 0 },
			 { 0, 6, 53, 7, 60, 9, 0 },
			 { 1, 24, 74, 7, 28, 1, 0 },
			 { 0, 7, 57, 7, 57, 7, 0 },
			 { 0, 1, 28, 7, 74, 24, 1 },
			 { 0, 9, 60, 7, 53, 6, 0 },
			 { 0, 2, 31, 7, 73, 21, 1 },
			 { 0, 10, 64, 7, 49, 5, 0 },
			 { 0, 2, 35, 7, 72, 18, 1 },
			 { 0, 12, 67, 7, 45, 4, 0 },
			 { 0, 3, 39, 7, 70, 16, 0 },
			 { 0, 15, 69, 7, 41, 3, 0 },
			 { 0, 3, 43, 7, 69, 13, 0 },
			 { 1, 17, 71, 7, 37, 2, 0 },
			 { 0, 4, 47, 7, 66, 11, 0 },
			 { 1, 20, 72, 7, 33, 2, 0 },
			 { 0, 5, 51, 7, 63, 9, 0 },
			 { 1, 23, 73, 7, 30, 1, 0 },
			 { 0, 6, 55, 7, 59, 8, 0 } },
		.odd = { { 0, 15, 70, 7, 40, 3, 0 },
			 { 0, 4, 44, 7, 67, 13, 0 },
			 { 1, 18, 71, 7, 36, 2, 0 },
			 { 0, 4, 48, 7, 65, 11, 0 },
			 { 1, 20, 73, 7, 32, 2, 0 },
			 { 0, 6, 52, 7, 61, 9, 0 },
			 { 1, 24, 73, 7, 29, 1, 0 },
			 { 0, 7, 56, 7, 58, 7, 0 },
			 { 0, 1, 27, 7, 74, 25, 1 },
			 { 0, 8, 60, 7, 54, 6, 0 },
			 { 0, 2, 30, 7, 73, 22, 1 },
			 { 0, 10, 63, 7, 50, 5, 0 },
			 { 0, 2, 34, 7, 72, 19, 1 },
			 { 0, 12, 66, 7, 46, 4, 0 },
			 { 0, 3, 38, 7, 71, 16, 0 },
			 { 0, 14, 69, 7, 42, 3, 0 },
			 { 0, 3, 42, 7, 69, 14, 0 },
			 { 0, 16, 71, 7, 38, 3, 0 },
			 { 0, 4, 46, 7, 66, 12, 0 },
			 { 1, 19, 72, 7, 34, 2, 0 },
			 { 0, 5, 50, 7, 63, 10, 0 },
			 { 1, 22, 73, 7, 30, 2, 0 },
			 { 0, 6, 54, 7, 60, 8, 0 },
			 { 1, 25, 74, 7, 27, 1, 0 },
			 { 0, 7, 58, 7, 56, 7, 0 },
			 { 0, 1, 29, 7, 73, 24, 1 },
			 { 0, 9, 61, 7, 52, 6, 0 },
			 { 0, 2, 32, 7, 73, 20, 1 },
			 { 0, 11, 65, 7, 48, 4, 0 },
			 { 0, 2, 36, 7, 71, 18, 1 },
			 { 0, 13, 67, 7, 44, 4, 0 },
			 { 0, 3, 40, 7, 70, 15, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 26, 74, 7, 26, 1, 0 },
			 { 0, 8, 59, 7, 55, 6, 0 },
			 { 0, 1, 30, 7, 73, 23, 1 },
			 { 0, 9, 63, 7, 51, 5, 0 },
			 { 0, 2, 33, 7, 72, 20, 1 },
			 { 0, 11, 66, 7, 47, 4, 0 },
			 { 0, 2, 37, 7, 71, 17, 1 },
			 { 0, 13, 69, 7, 43, 3, 0 },
			 { 0, 3, 41, 7, 69, 15, 0 },
			 { 0, 16, 70, 7, 39, 3, 0 },
			 { 0, 4, 45, 7, 67, 12, 0 },
			 { 1, 18, 72, 7, 35, 2, 0 },
			 { 0, 5, 49, 7, 64, 10, 0 },
			 { 1, 21, 73, 7, 31, 2, 0 },
			 { 0, 6, 53, 7, 60, 9, 0 },
			 { 1, 24, 74, 7, 28, 1, 0 },
			 { 0, 7, 57, 7, 57, 7, 0 },
			 { 0, 1, 28, 7, 74, 24, 1 },
			 { 0, 9, 60, 7, 53, 6, 0 },
			 { 0, 2, 31, 7, 73, 21, 1 },
			 { 0, 10, 64, 7, 49, 5, 0 },
			 { 0, 2, 35, 7, 72, 18, 1 },
			 { 0, 12, 67, 7, 45, 4, 0 },
			 { 0, 3, 39, 7, 70, 16, 0 },
			 { 0, 15, 69, 7, 41, 3, 0 },
			 { 0, 3, 43, 7, 69, 13, 0 },
			 { 1, 17, 71, 7, 37, 2, 0 },
			 { 0, 4, 47, 7, 66, 11, 0 },
			 { 1, 20, 72, 7, 33, 2, 0 },
			 { 0, 5, 51, 7, 63, 9, 0 },
			 { 1, 23, 73, 7, 30, 1, 0 },
			 { 0, 6, 55, 7, 59, 8, 0 } },
		.odd = { { 0, 15, 70, 7, 40, 3, 0 },
			 { 0, 4, 44, 7, 67, 13, 0 },
			 { 1, 18, 71, 7, 36, 2, 0 },
			 { 0, 4, 48, 7, 65, 11, 0 },
			 { 1, 20, 73, 7, 32, 2, 0 },
			 { 0, 6, 52, 7, 61, 9, 0 },
			 { 1, 24, 73, 7, 29, 1, 0 },
			 { 0, 7, 56, 7, 58, 7, 0 },
			 { 0, 1, 27, 7, 74, 25, 1 },
			 { 0, 8, 60, 7, 54, 6, 0 },
			 { 0, 2, 30, 7, 73, 22, 1 },
			 { 0, 10, 63, 7, 50, 5, 0 },
			 { 0, 2, 34, 7, 72, 19, 1 },
			 { 0, 12, 66, 7, 46, 4, 0 },
			 { 0, 3, 38, 7, 71, 16, 0 },
			 { 0, 14, 69, 7, 42, 3, 0 },
			 { 0, 3, 42, 7, 69, 14, 0 },
			 { 0, 16, 71, 7, 38, 3, 0 },
			 { 0, 4, 46, 7, 66, 12, 0 },
			 { 1, 19, 72, 7, 34, 2, 0 },
			 { 0, 5, 50, 7, 63, 10, 0 },
			 { 1, 22, 73, 7, 30, 2, 0 },
			 { 0, 6, 54, 7, 60, 8, 0 },
			 { 1, 25, 74, 7, 27, 1, 0 },
			 { 0, 7, 58, 7, 56, 7, 0 },
			 { 0, 1, 29, 7, 73, 24, 1 },
			 { 0, 9, 61, 7, 52, 6, 0 },
			 { 0, 2, 32, 7, 73, 20, 1 },
			 { 0, 11, 65, 7, 48, 4, 0 },
			 { 0, 2, 36, 7, 71, 18, 1 },
			 { 0, 13, 67, 7, 44, 4, 0 },
			 { 0, 3, 40, 7, 70, 15, 0 } } },
	.ptrn_arr = { { 0x84921249, 0x42492124, 0x24249092, 0x92124909,
			 0x49212484, 0x24909248, 0x2490924 } },
	.sample_patrn_length = 222,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 80) = 0.285714 */
	.hor_phase_arr = {
		.even = { { 1, 26, 74, 7, 26, 1, 0 },
			 { 0, 7, 57, 7, 57, 7, 0 } },
		.odd = { { 0, 15, 69, 7, 41, 3, 0 },
			 { 0, 3, 41, 7, 69, 15, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 26, 74, 7, 26, 1, 0 },
			 { 0, 7, 57, 7, 57, 7, 0 } },
		.odd = { { 0, 15, 69, 7, 41, 3, 0 },
			 { 0, 3, 41, 7, 69, 15, 0 } } },
	.ptrn_arr = { { 0x249 } },
	.sample_patrn_length = 14,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 81) = 0.283186 */
	.hor_phase_arr = {
		.even = { { 1, 27, 72, 7, 27, 1, 0 },
			 { 0, 7, 54, 7, 59, 8, 0 },
			 { 1, 23, 72, 7, 30, 2, 0 },
			 { 0, 6, 51, 7, 61, 10, 0 },
			 { 1, 20, 71, 7, 34, 2, 0 },
			 { 0, 5, 47, 7, 64, 12, 0 },
			 { 1, 18, 69, 7, 37, 3, 0 },
			 { 0, 4, 43, 7, 67, 14, 0 },
			 { 0, 15, 69, 7, 41, 3, 0 },
			 { 0, 3, 39, 7, 69, 16, 1 },
			 { 0, 13, 66, 7, 45, 4, 0 },
			 { 0, 2, 35, 7, 71, 19, 1 },
			 { 0, 11, 63, 7, 49, 5, 0 },
			 { 0, 2, 32, 7, 71, 22, 1 },
			 { 0, 9, 60, 7, 53, 6, 0 },
			 { 0, 1, 28, 7, 73, 25, 1 },
			 { 0, 8, 56, 7, 56, 8, 0 },
			 { 1, 25, 73, 7, 28, 1, 0 },
			 { 0, 6, 53, 7, 60, 9, 0 },
			 { 1, 22, 71, 7, 32, 2, 0 },
			 { 0, 5, 49, 7, 63, 11, 0 },
			 { 1, 19, 71, 7, 35, 2, 0 },
			 { 0, 4, 45, 7, 66, 13, 0 },
			 { 1, 16, 69, 7, 39, 3, 0 },
			 { 0, 3, 41, 7, 69, 15, 0 },
			 { 0, 14, 67, 7, 43, 4, 0 },
			 { 0, 3, 37, 7, 69, 18, 1 },
			 { 0, 12, 64, 7, 47, 5, 0 },
			 { 0, 2, 34, 7, 71, 20, 1 },
			 { 0, 10, 61, 7, 51, 6, 0 },
			 { 0, 2, 30, 7, 72, 23, 1 },
			 { 0, 8, 59, 7, 54, 7, 0 } },
		.odd = { { 0, 15, 67, 7, 42, 4, 0 },
			 { 0, 3, 38, 7, 69, 17, 1 },
			 { 0, 12, 66, 7, 46, 4, 0 },
			 { 0, 2, 34, 7, 71, 20, 1 },
			 { 0, 10, 63, 7, 50, 5, 0 },
			 { 0, 2, 31, 7, 71, 23, 1 },
			 { 0, 9, 58, 7, 54, 7, 0 },
			 { 0, 1, 27, 7, 73, 26, 1 },
			 { 0, 7, 55, 7, 58, 8, 0 },
			 { 1, 24, 72, 7, 29, 2, 0 },
			 { 0, 6, 52, 7, 60, 10, 0 },
			 { 1, 21, 71, 7, 33, 2, 0 },
			 { 0, 5, 48, 7, 64, 11, 0 },
			 { 1, 18, 70, 7, 36, 3, 0 },
			 { 0, 4, 44, 7, 67, 13, 0 },
			 { 0, 16, 69, 7, 40, 3, 0 },
			 { 0, 3, 40, 7, 69, 16, 0 },
			 { 0, 13, 67, 7, 44, 4, 0 },
			 { 0, 3, 36, 7, 70, 18, 1 },
			 { 0, 11, 64, 7, 48, 5, 0 },
			 { 0, 2, 33, 7, 71, 21, 1 },
			 { 0, 10, 60, 7, 52, 6, 0 },
			 { 0, 2, 29, 7, 72, 24, 1 },
			 { 0, 8, 58, 7, 55, 7, 0 },
			 { 1, 26, 73, 7, 27, 1, 0 },
			 { 0, 7, 54, 7, 58, 9, 0 },
			 { 1, 23, 71, 7, 31, 2, 0 },
			 { 0, 5, 50, 7, 63, 10, 0 },
			 { 1, 20, 71, 7, 34, 2, 0 },
			 { 0, 4, 46, 7, 66, 12, 0 },
			 { 1, 17, 69, 7, 38, 3, 0 },
			 { 0, 4, 42, 7, 67, 15, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 27, 72, 7, 27, 1, 0 },
			 { 0, 7, 54, 7, 59, 8, 0 },
			 { 1, 23, 72, 7, 30, 2, 0 },
			 { 0, 6, 51, 7, 61, 10, 0 },
			 { 1, 20, 71, 7, 34, 2, 0 },
			 { 0, 5, 47, 7, 64, 12, 0 },
			 { 1, 18, 69, 7, 37, 3, 0 },
			 { 0, 4, 43, 7, 67, 14, 0 },
			 { 0, 15, 69, 7, 41, 3, 0 },
			 { 0, 3, 39, 7, 69, 16, 1 },
			 { 0, 13, 66, 7, 45, 4, 0 },
			 { 0, 2, 35, 7, 71, 19, 1 },
			 { 0, 11, 63, 7, 49, 5, 0 },
			 { 0, 2, 32, 7, 71, 22, 1 },
			 { 0, 9, 60, 7, 53, 6, 0 },
			 { 0, 1, 28, 7, 73, 25, 1 },
			 { 0, 8, 56, 7, 56, 8, 0 },
			 { 1, 25, 73, 7, 28, 1, 0 },
			 { 0, 6, 53, 7, 60, 9, 0 },
			 { 1, 22, 71, 7, 32, 2, 0 },
			 { 0, 5, 49, 7, 63, 11, 0 },
			 { 1, 19, 71, 7, 35, 2, 0 },
			 { 0, 4, 45, 7, 66, 13, 0 },
			 { 1, 16, 69, 7, 39, 3, 0 },
			 { 0, 3, 41, 7, 69, 15, 0 },
			 { 0, 14, 67, 7, 43, 4, 0 },
			 { 0, 3, 37, 7, 69, 18, 1 },
			 { 0, 12, 64, 7, 47, 5, 0 },
			 { 0, 2, 34, 7, 71, 20, 1 },
			 { 0, 10, 61, 7, 51, 6, 0 },
			 { 0, 2, 30, 7, 72, 23, 1 },
			 { 0, 8, 59, 7, 54, 7, 0 } },
		.odd = { { 0, 15, 67, 7, 42, 4, 0 },
			 { 0, 3, 38, 7, 69, 17, 1 },
			 { 0, 12, 66, 7, 46, 4, 0 },
			 { 0, 2, 34, 7, 71, 20, 1 },
			 { 0, 10, 63, 7, 50, 5, 0 },
			 { 0, 2, 31, 7, 71, 23, 1 },
			 { 0, 9, 58, 7, 54, 7, 0 },
			 { 0, 1, 27, 7, 73, 26, 1 },
			 { 0, 7, 55, 7, 58, 8, 0 },
			 { 1, 24, 72, 7, 29, 2, 0 },
			 { 0, 6, 52, 7, 60, 10, 0 },
			 { 1, 21, 71, 7, 33, 2, 0 },
			 { 0, 5, 48, 7, 64, 11, 0 },
			 { 1, 18, 70, 7, 36, 3, 0 },
			 { 0, 4, 44, 7, 67, 13, 0 },
			 { 0, 16, 69, 7, 40, 3, 0 },
			 { 0, 3, 40, 7, 69, 16, 0 },
			 { 0, 13, 67, 7, 44, 4, 0 },
			 { 0, 3, 36, 7, 70, 18, 1 },
			 { 0, 11, 64, 7, 48, 5, 0 },
			 { 0, 2, 33, 7, 71, 21, 1 },
			 { 0, 10, 60, 7, 52, 6, 0 },
			 { 0, 2, 29, 7, 72, 24, 1 },
			 { 0, 8, 58, 7, 55, 7, 0 },
			 { 1, 26, 73, 7, 27, 1, 0 },
			 { 0, 7, 54, 7, 58, 9, 0 },
			 { 1, 23, 71, 7, 31, 2, 0 },
			 { 0, 5, 50, 7, 63, 10, 0 },
			 { 1, 20, 71, 7, 34, 2, 0 },
			 { 0, 4, 46, 7, 66, 12, 0 },
			 { 1, 17, 69, 7, 38, 3, 0 },
			 { 0, 4, 42, 7, 67, 15, 0 } } },
	.ptrn_arr = { { 0x90924249, 0x49092424, 0x84921248, 0x49092124,
			 0x24909242, 0x48492124, 0x24849212 } },
	.sample_patrn_length = 226,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 82) = 0.280702 */
	.hor_phase_arr = {
		.even = { { 1, 27, 72, 7, 27, 1, 0 },
			 { 0, 6, 52, 7, 61, 9, 0 },
			 { 1, 21, 70, 7, 34, 2, 0 },
			 { 0, 4, 45, 7, 66, 13, 0 },
			 { 0, 15, 68, 7, 41, 4, 0 },
			 { 0, 3, 37, 7, 69, 18, 1 },
			 { 0, 11, 63, 7, 49, 5, 0 },
			 { 0, 2, 30, 7, 71, 24, 1 },
			 { 0, 8, 56, 7, 56, 8, 0 },
			 { 1, 24, 71, 7, 30, 2, 0 },
			 { 0, 5, 49, 7, 63, 11, 0 },
			 { 1, 18, 69, 7, 37, 3, 0 },
			 { 0, 4, 41, 7, 68, 15, 0 },
			 { 0, 13, 66, 7, 45, 4, 0 },
			 { 0, 2, 34, 7, 70, 21, 1 },
			 { 0, 9, 61, 7, 52, 6, 0 } },
		.odd = { { 0, 14, 67, 7, 43, 4, 0 },
			 { 0, 3, 36, 7, 69, 19, 1 },
			 { 0, 10, 61, 7, 51, 6, 0 },
			 { 0, 2, 28, 7, 72, 25, 1 },
			 { 0, 7, 54, 7, 58, 9, 0 },
			 { 1, 22, 71, 7, 32, 2, 0 },
			 { 0, 5, 47, 7, 64, 12, 0 },
			 { 1, 17, 68, 7, 39, 3, 0 },
			 { 0, 3, 39, 7, 68, 17, 1 },
			 { 0, 12, 64, 7, 47, 5, 0 },
			 { 0, 2, 32, 7, 71, 22, 1 },
			 { 0, 9, 58, 7, 54, 7, 0 },
			 { 1, 25, 72, 7, 28, 2, 0 },
			 { 0, 6, 51, 7, 61, 10, 0 },
			 { 1, 19, 69, 7, 36, 3, 0 },
			 { 0, 4, 43, 7, 67, 14, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 27, 72, 7, 27, 1, 0 },
			 { 0, 6, 52, 7, 61, 9, 0 },
			 { 1, 21, 70, 7, 34, 2, 0 },
			 { 0, 4, 45, 7, 66, 13, 0 },
			 { 0, 15, 68, 7, 41, 4, 0 },
			 { 0, 3, 37, 7, 69, 18, 1 },
			 { 0, 11, 63, 7, 49, 5, 0 },
			 { 0, 2, 30, 7, 71, 24, 1 },
			 { 0, 8, 56, 7, 56, 8, 0 },
			 { 1, 24, 71, 7, 30, 2, 0 },
			 { 0, 5, 49, 7, 63, 11, 0 },
			 { 1, 18, 69, 7, 37, 3, 0 },
			 { 0, 4, 41, 7, 68, 15, 0 },
			 { 0, 13, 66, 7, 45, 4, 0 },
			 { 0, 2, 34, 7, 70, 21, 1 },
			 { 0, 9, 61, 7, 52, 6, 0 } },
		.odd = { { 0, 14, 67, 7, 43, 4, 0 },
			 { 0, 3, 36, 7, 69, 19, 1 },
			 { 0, 10, 61, 7, 51, 6, 0 },
			 { 0, 2, 28, 7, 72, 25, 1 },
			 { 0, 7, 54, 7, 58, 9, 0 },
			 { 1, 22, 71, 7, 32, 2, 0 },
			 { 0, 5, 47, 7, 64, 12, 0 },
			 { 1, 17, 68, 7, 39, 3, 0 },
			 { 0, 3, 39, 7, 68, 17, 1 },
			 { 0, 12, 64, 7, 47, 5, 0 },
			 { 0, 2, 32, 7, 71, 22, 1 },
			 { 0, 9, 58, 7, 54, 7, 0 },
			 { 1, 25, 72, 7, 28, 2, 0 },
			 { 0, 6, 51, 7, 61, 10, 0 },
			 { 1, 19, 69, 7, 36, 3, 0 },
			 { 0, 4, 43, 7, 67, 14, 0 } } },
	.ptrn_arr = { { 0x90924249, 0x9212484, 0x92124249, 0x2484 } },
	.sample_patrn_length = 114,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 83) = 0.278261 */
	.hor_phase_arr = {
		.even = { { 1, 27, 72, 7, 27, 1, 0 },
			 { 0, 6, 51, 7, 61, 10, 0 },
			 { 1, 18, 68, 7, 38, 3, 0 },
			 { 0, 3, 39, 7, 68, 17, 1 },
			 { 0, 11, 62, 7, 49, 6, 0 },
			 { 0, 2, 29, 7, 71, 25, 1 },
			 { 0, 7, 52, 7, 59, 10, 0 },
			 { 1, 19, 69, 7, 36, 3, 0 },
			 { 0, 4, 41, 7, 66, 16, 1 },
			 { 0, 12, 64, 7, 47, 5, 0 },
			 { 0, 2, 30, 7, 71, 24, 1 },
			 { 0, 7, 54, 7, 58, 9, 0 },
			 { 1, 21, 70, 7, 34, 2, 0 },
			 { 0, 4, 43, 7, 66, 15, 0 },
			 { 0, 13, 65, 7, 45, 5, 0 },
			 { 0, 2, 32, 7, 71, 22, 1 },
			 { 0, 8, 56, 7, 56, 8, 0 },
			 { 1, 22, 71, 7, 32, 2, 0 },
			 { 0, 5, 45, 7, 65, 13, 0 },
			 { 0, 15, 66, 7, 43, 4, 0 },
			 { 0, 2, 34, 7, 70, 21, 1 },
			 { 0, 9, 58, 7, 54, 7, 0 },
			 { 1, 24, 71, 7, 30, 2, 0 },
			 { 0, 5, 47, 7, 64, 12, 0 },
			 { 1, 16, 66, 7, 41, 4, 0 },
			 { 0, 3, 36, 7, 69, 19, 1 },
			 { 0, 10, 59, 7, 52, 7, 0 },
			 { 1, 25, 71, 7, 29, 2, 0 },
			 { 0, 6, 49, 7, 62, 11, 0 },
			 { 1, 17, 68, 7, 39, 3, 0 },
			 { 0, 3, 38, 7, 68, 18, 1 },
			 { 0, 10, 61, 7, 51, 6, 0 } },
		.odd = { { 0, 14, 66, 7, 44, 4, 0 },
			 { 0, 2, 33, 7, 70, 22, 1 },
			 { 0, 8, 57, 7, 55, 8, 0 },
			 { 1, 23, 71, 7, 31, 2, 0 },
			 { 0, 5, 46, 7, 64, 13, 0 },
			 { 0, 15, 67, 7, 42, 4, 0 },
			 { 0, 3, 35, 7, 69, 20, 1 },
			 { 0, 9, 59, 7, 53, 7, 0 },
			 { 1, 25, 71, 7, 29, 2, 0 },
			 { 0, 5, 48, 7, 63, 12, 0 },
			 { 1, 16, 68, 7, 40, 3, 0 },
			 { 0, 3, 37, 7, 68, 19, 1 },
			 { 0, 10, 61, 7, 51, 6, 0 },
			 { 1, 26, 71, 7, 28, 2, 0 },
			 { 0, 6, 50, 7, 61, 11, 0 },
			 { 1, 18, 68, 7, 38, 3, 0 },
			 { 0, 3, 38, 7, 68, 18, 1 },
			 { 0, 11, 61, 7, 50, 6, 0 },
			 { 0, 2, 28, 7, 71, 26, 1 },
			 { 0, 6, 51, 7, 61, 10, 0 },
			 { 1, 19, 68, 7, 37, 3, 0 },
			 { 0, 3, 40, 7, 68, 16, 1 },
			 { 0, 12, 63, 7, 48, 5, 0 },
			 { 0, 2, 29, 7, 71, 25, 1 },
			 { 0, 7, 53, 7, 59, 9, 0 },
			 { 1, 20, 69, 7, 35, 3, 0 },
			 { 0, 4, 42, 7, 67, 15, 0 },
			 { 0, 13, 64, 7, 46, 5, 0 },
			 { 0, 2, 31, 7, 71, 23, 1 },
			 { 0, 8, 55, 7, 57, 8, 0 },
			 { 1, 22, 70, 7, 33, 2, 0 },
			 { 0, 4, 44, 7, 66, 14, 0 } } },
	.ver_phase_arr = {
		.even = { { 1, 27, 72, 7, 27, 1, 0 },
			 { 0, 6, 51, 7, 61, 10, 0 },
			 { 1, 18, 68, 7, 38, 3, 0 },
			 { 0, 3, 39, 7, 68, 17, 1 },
			 { 0, 11, 62, 7, 49, 6, 0 },
			 { 0, 2, 29, 7, 71, 25, 1 },
			 { 0, 7, 52, 7, 59, 10, 0 },
			 { 1, 19, 69, 7, 36, 3, 0 },
			 { 0, 4, 41, 7, 66, 16, 1 },
			 { 0, 12, 64, 7, 47, 5, 0 },
			 { 0, 2, 30, 7, 71, 24, 1 },
			 { 0, 7, 54, 7, 58, 9, 0 },
			 { 1, 21, 70, 7, 34, 2, 0 },
			 { 0, 4, 43, 7, 66, 15, 0 },
			 { 0, 13, 65, 7, 45, 5, 0 },
			 { 0, 2, 32, 7, 71, 22, 1 },
			 { 0, 8, 56, 7, 56, 8, 0 },
			 { 1, 22, 71, 7, 32, 2, 0 },
			 { 0, 5, 45, 7, 65, 13, 0 },
			 { 0, 15, 66, 7, 43, 4, 0 },
			 { 0, 2, 34, 7, 70, 21, 1 },
			 { 0, 9, 58, 7, 54, 7, 0 },
			 { 1, 24, 71, 7, 30, 2, 0 },
			 { 0, 5, 47, 7, 64, 12, 0 },
			 { 1, 16, 66, 7, 41, 4, 0 },
			 { 0, 3, 36, 7, 69, 19, 1 },
			 { 0, 10, 59, 7, 52, 7, 0 },
			 { 1, 25, 71, 7, 29, 2, 0 },
			 { 0, 6, 49, 7, 62, 11, 0 },
			 { 1, 17, 68, 7, 39, 3, 0 },
			 { 0, 3, 38, 7, 68, 18, 1 },
			 { 0, 10, 61, 7, 51, 6, 0 } },
		.odd = { { 0, 14, 66, 7, 44, 4, 0 },
			 { 0, 2, 33, 7, 70, 22, 1 },
			 { 0, 8, 57, 7, 55, 8, 0 },
			 { 1, 23, 71, 7, 31, 2, 0 },
			 { 0, 5, 46, 7, 64, 13, 0 },
			 { 0, 15, 67, 7, 42, 4, 0 },
			 { 0, 3, 35, 7, 69, 20, 1 },
			 { 0, 9, 59, 7, 53, 7, 0 },
			 { 1, 25, 71, 7, 29, 2, 0 },
			 { 0, 5, 48, 7, 63, 12, 0 },
			 { 1, 16, 68, 7, 40, 3, 0 },
			 { 0, 3, 37, 7, 68, 19, 1 },
			 { 0, 10, 61, 7, 51, 6, 0 },
			 { 1, 26, 71, 7, 28, 2, 0 },
			 { 0, 6, 50, 7, 61, 11, 0 },
			 { 1, 18, 68, 7, 38, 3, 0 },
			 { 0, 3, 38, 7, 68, 18, 1 },
			 { 0, 11, 61, 7, 50, 6, 0 },
			 { 0, 2, 28, 7, 71, 26, 1 },
			 { 0, 6, 51, 7, 61, 10, 0 },
			 { 1, 19, 68, 7, 37, 3, 0 },
			 { 0, 3, 40, 7, 68, 16, 1 },
			 { 0, 12, 63, 7, 48, 5, 0 },
			 { 0, 2, 29, 7, 71, 25, 1 },
			 { 0, 7, 53, 7, 59, 9, 0 },
			 { 1, 20, 69, 7, 35, 3, 0 },
			 { 0, 4, 42, 7, 67, 15, 0 },
			 { 0, 13, 64, 7, 46, 5, 0 },
			 { 0, 2, 31, 7, 71, 23, 1 },
			 { 0, 8, 55, 7, 57, 8, 0 },
			 { 1, 22, 70, 7, 33, 2, 0 },
			 { 0, 4, 44, 7, 66, 14, 0 } } },
	.ptrn_arr = { { 0x92124249, 0x21242484, 0x12424849, 0x24248492,
			 0x42484909, 0x24849092, 0x48490924, 0x2 } },
	.sample_patrn_length = 230,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 84) = 0.275862 */
	.hor_phase_arr = {
		.even = { { 2, 27, 70, 7, 27, 2, 0 },
			 { 0, 6, 49, 7, 61, 12, 0 },
			 { 1, 16, 66, 7, 41, 4, 0 },
			 { 0, 2, 34, 7, 70, 21, 1 },
			 { 0, 8, 56, 7, 56, 8, 0 },
			 { 1, 21, 70, 7, 34, 2, 0 },
			 { 0, 4, 41, 7, 66, 16, 1 },
			 { 0, 12, 61, 7, 49, 6, 0 } },
		.odd = { { 0, 14, 64, 7, 45, 5, 0 },
			 { 0, 2, 31, 7, 70, 24, 1 },
			 { 0, 7, 52, 7, 59, 10, 0 },
			 { 1, 18, 68, 7, 38, 3, 0 },
			 { 0, 3, 38, 7, 68, 18, 1 },
			 { 0, 10, 59, 7, 52, 7, 0 },
			 { 1, 24, 70, 7, 31, 2, 0 },
			 { 0, 5, 45, 7, 64, 14, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 27, 70, 7, 27, 2, 0 },
			 { 0, 6, 49, 7, 61, 12, 0 },
			 { 1, 16, 66, 7, 41, 4, 0 },
			 { 0, 2, 34, 7, 70, 21, 1 },
			 { 0, 8, 56, 7, 56, 8, 0 },
			 { 1, 21, 70, 7, 34, 2, 0 },
			 { 0, 4, 41, 7, 66, 16, 1 },
			 { 0, 12, 61, 7, 49, 6, 0 } },
		.odd = { { 0, 14, 64, 7, 45, 5, 0 },
			 { 0, 2, 31, 7, 70, 24, 1 },
			 { 0, 7, 52, 7, 59, 10, 0 },
			 { 1, 18, 68, 7, 38, 3, 0 },
			 { 0, 3, 38, 7, 68, 18, 1 },
			 { 0, 10, 59, 7, 52, 7, 0 },
			 { 1, 24, 70, 7, 31, 2, 0 },
			 { 0, 5, 45, 7, 64, 14, 0 } } },
	.ptrn_arr = { { 0x92124249, 0x248490 } },
	.sample_patrn_length = 58,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 85) = 0.273504 */
	.hor_phase_arr = {
		.even = { { 2, 27, 70, 7, 27, 2, 0 },
			 { 0, 5, 47, 7, 63, 13, 0 },
			 { 0, 14, 64, 7, 45, 5, 0 },
			 { 0, 2, 29, 7, 70, 26, 1 },
			 { 0, 6, 48, 7, 62, 12, 0 },
			 { 1, 15, 65, 7, 43, 4, 0 },
			 { 0, 2, 31, 7, 70, 24, 1 },
			 { 0, 6, 50, 7, 61, 11, 0 },
			 { 1, 16, 66, 7, 41, 4, 0 },
			 { 0, 2, 32, 7, 70, 23, 1 },
			 { 0, 7, 52, 7, 59, 10, 0 },
			 { 1, 17, 67, 7, 39, 4, 0 },
			 { 0, 3, 34, 7, 69, 21, 1 },
			 { 0, 8, 54, 7, 57, 9, 0 },
			 { 1, 19, 67, 7, 38, 3, 0 },
			 { 0, 3, 36, 7, 68, 20, 1 },
			 { 0, 9, 55, 7, 55, 9, 0 },
			 { 1, 20, 68, 7, 36, 3, 0 },
			 { 0, 3, 38, 7, 67, 19, 1 },
			 { 0, 9, 57, 7, 54, 8, 0 },
			 { 1, 21, 69, 7, 34, 3, 0 },
			 { 0, 4, 39, 7, 67, 17, 1 },
			 { 0, 10, 59, 7, 52, 7, 0 },
			 { 1, 23, 70, 7, 32, 2, 0 },
			 { 0, 4, 41, 7, 66, 16, 1 },
			 { 0, 11, 61, 7, 50, 6, 0 },
			 { 1, 24, 70, 7, 31, 2, 0 },
			 { 0, 4, 43, 7, 65, 15, 1 },
			 { 0, 12, 62, 7, 48, 6, 0 },
			 { 1, 26, 70, 7, 29, 2, 0 },
			 { 0, 5, 45, 7, 64, 14, 0 },
			 { 0, 13, 63, 7, 47, 5, 0 } },
		.odd = { { 0, 13, 64, 7, 46, 5, 0 },
			 { 0, 2, 28, 7, 69, 27, 2 },
			 { 0, 6, 48, 7, 62, 12, 0 },
			 { 1, 14, 64, 7, 44, 5, 0 },
			 { 0, 2, 30, 7, 70, 25, 1 },
			 { 0, 6, 49, 7, 62, 11, 0 },
			 { 1, 16, 65, 7, 42, 4, 0 },
			 { 0, 2, 32, 7, 69, 24, 1 },
			 { 0, 7, 51, 7, 59, 11, 0 },
			 { 1, 17, 66, 7, 40, 4, 0 },
			 { 0, 2, 33, 7, 70, 22, 1 },
			 { 0, 7, 53, 7, 58, 10, 0 },
			 { 1, 18, 67, 7, 39, 3, 0 },
			 { 0, 3, 35, 7, 68, 21, 1 },
			 { 0, 8, 54, 7, 57, 9, 0 },
			 { 1, 19, 68, 7, 37, 3, 0 },
			 { 0, 3, 37, 7, 68, 19, 1 },
			 { 0, 9, 57, 7, 54, 8, 0 },
			 { 1, 21, 68, 7, 35, 3, 0 },
			 { 0, 3, 39, 7, 67, 18, 1 },
			 { 0, 10, 58, 7, 53, 7, 0 },
			 { 1, 22, 70, 7, 33, 2, 0 },
			 { 0, 4, 40, 7, 66, 17, 1 },
			 { 0, 11, 59, 7, 51, 7, 0 },
			 { 1, 24, 69, 7, 32, 2, 0 },
			 { 0, 4, 42, 7, 65, 16, 1 },
			 { 0, 11, 62, 7, 49, 6, 0 },
			 { 1, 25, 70, 7, 30, 2, 0 },
			 { 0, 5, 44, 7, 64, 14, 1 },
			 { 0, 12, 62, 7, 48, 6, 0 },
			 { 2, 27, 69, 7, 28, 2, 0 },
			 { 0, 5, 46, 7, 64, 13, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 27, 70, 7, 27, 2, 0 },
			 { 0, 5, 47, 7, 63, 13, 0 },
			 { 0, 14, 64, 7, 45, 5, 0 },
			 { 0, 2, 29, 7, 70, 26, 1 },
			 { 0, 6, 48, 7, 62, 12, 0 },
			 { 1, 15, 65, 7, 43, 4, 0 },
			 { 0, 2, 31, 7, 70, 24, 1 },
			 { 0, 6, 50, 7, 61, 11, 0 },
			 { 1, 16, 66, 7, 41, 4, 0 },
			 { 0, 2, 32, 7, 70, 23, 1 },
			 { 0, 7, 52, 7, 59, 10, 0 },
			 { 1, 17, 67, 7, 39, 4, 0 },
			 { 0, 3, 34, 7, 69, 21, 1 },
			 { 0, 8, 54, 7, 57, 9, 0 },
			 { 1, 19, 67, 7, 38, 3, 0 },
			 { 0, 3, 36, 7, 68, 20, 1 },
			 { 0, 9, 55, 7, 55, 9, 0 },
			 { 1, 20, 68, 7, 36, 3, 0 },
			 { 0, 3, 38, 7, 67, 19, 1 },
			 { 0, 9, 57, 7, 54, 8, 0 },
			 { 1, 21, 69, 7, 34, 3, 0 },
			 { 0, 4, 39, 7, 67, 17, 1 },
			 { 0, 10, 59, 7, 52, 7, 0 },
			 { 1, 23, 70, 7, 32, 2, 0 },
			 { 0, 4, 41, 7, 66, 16, 1 },
			 { 0, 11, 61, 7, 50, 6, 0 },
			 { 1, 24, 70, 7, 31, 2, 0 },
			 { 0, 4, 43, 7, 65, 15, 1 },
			 { 0, 12, 62, 7, 48, 6, 0 },
			 { 1, 26, 70, 7, 29, 2, 0 },
			 { 0, 5, 45, 7, 64, 14, 0 },
			 { 0, 13, 63, 7, 47, 5, 0 } },
		.odd = { { 0, 13, 64, 7, 46, 5, 0 },
			 { 0, 2, 28, 7, 69, 27, 2 },
			 { 0, 6, 48, 7, 62, 12, 0 },
			 { 1, 14, 64, 7, 44, 5, 0 },
			 { 0, 2, 30, 7, 70, 25, 1 },
			 { 0, 6, 49, 7, 62, 11, 0 },
			 { 1, 16, 65, 7, 42, 4, 0 },
			 { 0, 2, 32, 7, 69, 24, 1 },
			 { 0, 7, 51, 7, 59, 11, 0 },
			 { 1, 17, 66, 7, 40, 4, 0 },
			 { 0, 2, 33, 7, 70, 22, 1 },
			 { 0, 7, 53, 7, 58, 10, 0 },
			 { 1, 18, 67, 7, 39, 3, 0 },
			 { 0, 3, 35, 7, 68, 21, 1 },
			 { 0, 8, 54, 7, 57, 9, 0 },
			 { 1, 19, 68, 7, 37, 3, 0 },
			 { 0, 3, 37, 7, 68, 19, 1 },
			 { 0, 9, 57, 7, 54, 8, 0 },
			 { 1, 21, 68, 7, 35, 3, 0 },
			 { 0, 3, 39, 7, 67, 18, 1 },
			 { 0, 10, 58, 7, 53, 7, 0 },
			 { 1, 22, 70, 7, 33, 2, 0 },
			 { 0, 4, 40, 7, 66, 17, 1 },
			 { 0, 11, 59, 7, 51, 7, 0 },
			 { 1, 24, 69, 7, 32, 2, 0 },
			 { 0, 4, 42, 7, 65, 16, 1 },
			 { 0, 11, 62, 7, 49, 6, 0 },
			 { 1, 25, 70, 7, 30, 2, 0 },
			 { 0, 5, 44, 7, 64, 14, 1 },
			 { 0, 12, 62, 7, 48, 6, 0 },
			 { 2, 27, 69, 7, 28, 2, 0 },
			 { 0, 5, 46, 7, 64, 13, 0 } } },
	.ptrn_arr = { { 0x92124249, 0x24248490, 0x48490921, 0x90921242,
			 0x21242484, 0x42484909, 0x84909212, 0x24 } },
	.sample_patrn_length = 234,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 86) = 0.271186 */
	.hor_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 5, 45, 7, 63, 14, 1 },
			 { 0, 12, 62, 7, 48, 6, 0 },
			 { 1, 25, 69, 7, 31, 2, 0 },
			 { 0, 4, 41, 7, 66, 16, 1 },
			 { 0, 10, 59, 7, 52, 7, 0 },
			 { 1, 22, 68, 7, 34, 3, 0 },
			 { 0, 3, 38, 7, 67, 19, 1 },
			 { 0, 9, 55, 7, 55, 9, 0 },
			 { 1, 19, 67, 7, 38, 3, 0 },
			 { 0, 3, 34, 7, 68, 22, 1 },
			 { 0, 7, 52, 7, 59, 10, 0 },
			 { 1, 16, 66, 7, 41, 4, 0 },
			 { 0, 2, 31, 7, 69, 25, 1 },
			 { 0, 6, 48, 7, 62, 12, 0 },
			 { 1, 14, 63, 7, 45, 5, 0 } },
		.odd = { { 0, 13, 62, 7, 47, 6, 0 },
			 { 2, 26, 69, 7, 29, 2, 0 },
			 { 0, 5, 43, 7, 64, 15, 1 },
			 { 0, 11, 60, 7, 50, 7, 0 },
			 { 1, 23, 69, 7, 33, 2, 0 },
			 { 0, 4, 40, 7, 65, 18, 1 },
			 { 0, 10, 57, 7, 53, 8, 0 },
			 { 1, 20, 68, 7, 36, 3, 0 },
			 { 0, 3, 36, 7, 68, 20, 1 },
			 { 0, 8, 53, 7, 57, 10, 0 },
			 { 1, 18, 65, 7, 40, 4, 0 },
			 { 0, 2, 33, 7, 69, 23, 1 },
			 { 0, 7, 50, 7, 60, 11, 0 },
			 { 1, 15, 64, 7, 43, 5, 0 },
			 { 0, 2, 29, 7, 69, 26, 2 },
			 { 0, 6, 47, 7, 62, 13, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 5, 45, 7, 63, 14, 1 },
			 { 0, 12, 62, 7, 48, 6, 0 },
			 { 1, 25, 69, 7, 31, 2, 0 },
			 { 0, 4, 41, 7, 66, 16, 1 },
			 { 0, 10, 59, 7, 52, 7, 0 },
			 { 1, 22, 68, 7, 34, 3, 0 },
			 { 0, 3, 38, 7, 67, 19, 1 },
			 { 0, 9, 55, 7, 55, 9, 0 },
			 { 1, 19, 67, 7, 38, 3, 0 },
			 { 0, 3, 34, 7, 68, 22, 1 },
			 { 0, 7, 52, 7, 59, 10, 0 },
			 { 1, 16, 66, 7, 41, 4, 0 },
			 { 0, 2, 31, 7, 69, 25, 1 },
			 { 0, 6, 48, 7, 62, 12, 0 },
			 { 1, 14, 63, 7, 45, 5, 0 } },
		.odd = { { 0, 13, 62, 7, 47, 6, 0 },
			 { 2, 26, 69, 7, 29, 2, 0 },
			 { 0, 5, 43, 7, 64, 15, 1 },
			 { 0, 11, 60, 7, 50, 7, 0 },
			 { 1, 23, 69, 7, 33, 2, 0 },
			 { 0, 4, 40, 7, 65, 18, 1 },
			 { 0, 10, 57, 7, 53, 8, 0 },
			 { 1, 20, 68, 7, 36, 3, 0 },
			 { 0, 3, 36, 7, 68, 20, 1 },
			 { 0, 8, 53, 7, 57, 10, 0 },
			 { 1, 18, 65, 7, 40, 4, 0 },
			 { 0, 2, 33, 7, 69, 23, 1 },
			 { 0, 7, 50, 7, 60, 11, 0 },
			 { 1, 15, 64, 7, 43, 5, 0 },
			 { 0, 2, 29, 7, 69, 26, 2 },
			 { 0, 6, 47, 7, 62, 13, 0 } } },
	.ptrn_arr = { { 0x12424849, 0x24849092, 0x49092124, 0x24248 } },
	.sample_patrn_length = 118,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 87) = 0.268908 */
	.hor_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 5, 43, 7, 63, 16, 1 },
			 { 0, 11, 57, 7, 52, 8, 0 },
			 { 1, 21, 67, 7, 36, 3, 0 },
			 { 0, 3, 34, 7, 68, 22, 1 },
			 { 0, 7, 50, 7, 60, 11, 0 },
			 { 1, 14, 63, 7, 45, 5, 0 },
			 { 2, 26, 69, 7, 29, 2, 0 },
			 { 0, 4, 41, 7, 65, 17, 1 },
			 { 0, 10, 57, 7, 53, 8, 0 },
			 { 1, 19, 66, 7, 38, 4, 0 },
			 { 0, 3, 33, 7, 68, 23, 1 },
			 { 0, 6, 48, 7, 62, 12, 0 },
			 { 0, 13, 62, 7, 47, 6, 0 },
			 { 1, 25, 69, 7, 31, 2, 0 },
			 { 0, 4, 40, 7, 65, 18, 1 },
			 { 0, 9, 55, 7, 55, 9, 0 },
			 { 1, 18, 65, 7, 40, 4, 0 },
			 { 0, 2, 31, 7, 69, 25, 1 },
			 { 0, 6, 47, 7, 62, 13, 0 },
			 { 0, 12, 62, 7, 48, 6, 0 },
			 { 1, 23, 68, 7, 33, 3, 0 },
			 { 0, 4, 38, 7, 66, 19, 1 },
			 { 0, 8, 53, 7, 57, 10, 0 },
			 { 1, 17, 65, 7, 41, 4, 0 },
			 { 0, 2, 29, 7, 69, 26, 2 },
			 { 0, 5, 45, 7, 63, 14, 1 },
			 { 0, 11, 60, 7, 50, 7, 0 },
			 { 1, 22, 68, 7, 34, 3, 0 },
			 { 0, 3, 36, 7, 67, 21, 1 },
			 { 0, 8, 52, 7, 57, 11, 0 },
			 { 1, 16, 63, 7, 43, 5, 0 } },
		.odd = { { 0, 13, 62, 7, 47, 6, 0 },
			 { 1, 24, 69, 7, 32, 2, 0 },
			 { 0, 4, 39, 7, 65, 19, 1 },
			 { 0, 9, 54, 7, 56, 9, 0 },
			 { 1, 17, 66, 7, 40, 4, 0 },
			 { 0, 2, 30, 7, 69, 25, 2 },
			 { 0, 5, 46, 7, 62, 14, 1 },
			 { 0, 12, 60, 7, 49, 7, 0 },
			 { 1, 23, 67, 7, 34, 3, 0 },
			 { 0, 3, 37, 7, 67, 20, 1 },
			 { 0, 8, 52, 7, 58, 10, 0 },
			 { 1, 16, 64, 7, 42, 5, 0 },
			 { 0, 2, 29, 7, 68, 27, 2 },
			 { 0, 5, 44, 7, 63, 15, 1 },
			 { 0, 11, 59, 7, 51, 7, 0 },
			 { 1, 21, 68, 7, 35, 3, 0 },
			 { 0, 3, 35, 7, 68, 21, 1 },
			 { 0, 7, 51, 7, 59, 11, 0 },
			 { 1, 15, 63, 7, 44, 5, 0 },
			 { 2, 27, 68, 7, 29, 2, 0 },
			 { 0, 5, 42, 7, 64, 16, 1 },
			 { 0, 10, 58, 7, 52, 8, 0 },
			 { 1, 20, 67, 7, 37, 3, 0 },
			 { 0, 3, 34, 7, 67, 23, 1 },
			 { 0, 7, 49, 7, 60, 12, 0 },
			 { 1, 14, 62, 7, 46, 5, 0 },
			 { 2, 25, 69, 7, 30, 2, 0 },
			 { 0, 4, 40, 7, 66, 17, 1 },
			 { 0, 9, 56, 7, 54, 9, 0 },
			 { 1, 19, 65, 7, 39, 4, 0 },
			 { 0, 2, 32, 7, 69, 24, 1 },
			 { 0, 6, 47, 7, 62, 13, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 5, 43, 7, 63, 16, 1 },
			 { 0, 11, 57, 7, 52, 8, 0 },
			 { 1, 21, 67, 7, 36, 3, 0 },
			 { 0, 3, 34, 7, 68, 22, 1 },
			 { 0, 7, 50, 7, 60, 11, 0 },
			 { 1, 14, 63, 7, 45, 5, 0 },
			 { 2, 26, 69, 7, 29, 2, 0 },
			 { 0, 4, 41, 7, 65, 17, 1 },
			 { 0, 10, 57, 7, 53, 8, 0 },
			 { 1, 19, 66, 7, 38, 4, 0 },
			 { 0, 3, 33, 7, 68, 23, 1 },
			 { 0, 6, 48, 7, 62, 12, 0 },
			 { 0, 13, 62, 7, 47, 6, 0 },
			 { 1, 25, 69, 7, 31, 2, 0 },
			 { 0, 4, 40, 7, 65, 18, 1 },
			 { 0, 9, 55, 7, 55, 9, 0 },
			 { 1, 18, 65, 7, 40, 4, 0 },
			 { 0, 2, 31, 7, 69, 25, 1 },
			 { 0, 6, 47, 7, 62, 13, 0 },
			 { 0, 12, 62, 7, 48, 6, 0 },
			 { 1, 23, 68, 7, 33, 3, 0 },
			 { 0, 4, 38, 7, 66, 19, 1 },
			 { 0, 8, 53, 7, 57, 10, 0 },
			 { 1, 17, 65, 7, 41, 4, 0 },
			 { 0, 2, 29, 7, 69, 26, 2 },
			 { 0, 5, 45, 7, 63, 14, 1 },
			 { 0, 11, 60, 7, 50, 7, 0 },
			 { 1, 22, 68, 7, 34, 3, 0 },
			 { 0, 3, 36, 7, 67, 21, 1 },
			 { 0, 8, 52, 7, 57, 11, 0 },
			 { 1, 16, 63, 7, 43, 5, 0 } },
		.odd = { { 0, 13, 62, 7, 47, 6, 0 },
			 { 1, 24, 69, 7, 32, 2, 0 },
			 { 0, 4, 39, 7, 65, 19, 1 },
			 { 0, 9, 54, 7, 56, 9, 0 },
			 { 1, 17, 66, 7, 40, 4, 0 },
			 { 0, 2, 30, 7, 69, 25, 2 },
			 { 0, 5, 46, 7, 62, 14, 1 },
			 { 0, 12, 60, 7, 49, 7, 0 },
			 { 1, 23, 67, 7, 34, 3, 0 },
			 { 0, 3, 37, 7, 67, 20, 1 },
			 { 0, 8, 52, 7, 58, 10, 0 },
			 { 1, 16, 64, 7, 42, 5, 0 },
			 { 0, 2, 29, 7, 68, 27, 2 },
			 { 0, 5, 44, 7, 63, 15, 1 },
			 { 0, 11, 59, 7, 51, 7, 0 },
			 { 1, 21, 68, 7, 35, 3, 0 },
			 { 0, 3, 35, 7, 68, 21, 1 },
			 { 0, 7, 51, 7, 59, 11, 0 },
			 { 1, 15, 63, 7, 44, 5, 0 },
			 { 2, 27, 68, 7, 29, 2, 0 },
			 { 0, 5, 42, 7, 64, 16, 1 },
			 { 0, 10, 58, 7, 52, 8, 0 },
			 { 1, 20, 67, 7, 37, 3, 0 },
			 { 0, 3, 34, 7, 67, 23, 1 },
			 { 0, 7, 49, 7, 60, 12, 0 },
			 { 1, 14, 62, 7, 46, 5, 0 },
			 { 2, 25, 69, 7, 30, 2, 0 },
			 { 0, 4, 40, 7, 66, 17, 1 },
			 { 0, 9, 56, 7, 54, 9, 0 },
			 { 1, 19, 65, 7, 39, 4, 0 },
			 { 0, 2, 32, 7, 69, 24, 1 },
			 { 0, 6, 47, 7, 62, 13, 0 } } },
	.ptrn_arr = { { 0x12424849, 0x84909092, 0x9212424, 0x42484909,
			 0x90921212, 0x21242484, 0x48490921, 0x242 } },
	.sample_patrn_length = 238,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 88) = 0.266667 */
	.hor_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 4, 41, 7, 65, 17, 1 },
			 { 0, 9, 55, 7, 55, 9, 0 },
			 { 1, 17, 65, 7, 41, 4, 0 } },
		.odd = { { 0, 13, 60, 7, 48, 7, 0 },
			 { 1, 22, 68, 7, 34, 3, 0 },
			 { 0, 3, 34, 7, 68, 22, 1 },
			 { 0, 7, 48, 7, 60, 13, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 4, 41, 7, 65, 17, 1 },
			 { 0, 9, 55, 7, 55, 9, 0 },
			 { 1, 17, 65, 7, 41, 4, 0 } },
		.odd = { { 0, 13, 60, 7, 48, 7, 0 },
			 { 1, 22, 68, 7, 34, 3, 0 },
			 { 0, 3, 34, 7, 68, 22, 1 },
			 { 0, 7, 48, 7, 60, 13, 0 } } },
	.ptrn_arr = { { 0x2424849 } },
	.sample_patrn_length = 30,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 89) = 0.264463 */
	.hor_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 4, 40, 7, 65, 18, 1 },
			 { 0, 8, 51, 7, 58, 11, 0 },
			 { 1, 14, 61, 7, 46, 6, 0 },
			 { 1, 22, 67, 7, 35, 3, 0 },
			 { 0, 3, 33, 7, 67, 24, 1 },
			 { 0, 6, 45, 7, 61, 15, 1 },
			 { 0, 10, 56, 7, 53, 9, 0 },
			 { 1, 17, 64, 7, 41, 5, 0 },
			 { 2, 27, 67, 7, 30, 2, 0 },
			 { 0, 4, 38, 7, 65, 20, 1 },
			 { 0, 7, 50, 7, 59, 12, 0 },
			 { 0, 13, 60, 7, 48, 7, 0 },
			 { 1, 21, 67, 7, 36, 3, 0 },
			 { 0, 3, 31, 7, 67, 25, 2 },
			 { 0, 5, 43, 7, 63, 16, 1 },
			 { 0, 9, 56, 7, 54, 9, 0 },
			 { 1, 16, 63, 7, 43, 5, 0 },
			 { 2, 25, 67, 7, 31, 3, 0 },
			 { 0, 3, 36, 7, 67, 21, 1 },
			 { 0, 7, 48, 7, 60, 13, 0 },
			 { 0, 12, 59, 7, 50, 7, 0 },
			 { 1, 20, 65, 7, 38, 4, 0 },
			 { 0, 2, 30, 7, 67, 27, 2 },
			 { 0, 5, 41, 7, 64, 17, 1 },
			 { 0, 9, 53, 7, 56, 10, 0 },
			 { 1, 15, 61, 7, 45, 6, 0 },
			 { 1, 24, 67, 7, 33, 3, 0 },
			 { 0, 3, 35, 7, 67, 22, 1 },
			 { 0, 6, 46, 7, 61, 14, 1 },
			 { 0, 11, 58, 7, 51, 8, 0 },
			 { 1, 18, 65, 7, 40, 4, 0 } },
		.odd = { { 0, 12, 60, 7, 49, 7, 0 },
			 { 1, 20, 66, 7, 37, 4, 0 },
			 { 0, 2, 31, 7, 67, 26, 2 },
			 { 0, 5, 42, 7, 63, 17, 1 },
			 { 0, 9, 54, 7, 55, 10, 0 },
			 { 1, 16, 62, 7, 44, 5, 0 },
			 { 2, 24, 67, 7, 32, 3, 0 },
			 { 0, 3, 35, 7, 67, 22, 1 },
			 { 0, 6, 47, 7, 61, 13, 1 },
			 { 0, 12, 58, 7, 50, 8, 0 },
			 { 1, 19, 65, 7, 39, 4, 0 },
			 { 0, 2, 29, 7, 68, 27, 2 },
			 { 0, 4, 40, 7, 65, 18, 1 },
			 { 0, 8, 52, 7, 57, 11, 0 },
			 { 1, 14, 61, 7, 46, 6, 0 },
			 { 1, 23, 67, 7, 34, 3, 0 },
			 { 0, 3, 34, 7, 67, 23, 1 },
			 { 0, 6, 46, 7, 61, 14, 1 },
			 { 0, 11, 57, 7, 52, 8, 0 },
			 { 1, 18, 65, 7, 40, 4, 0 },
			 { 2, 27, 68, 7, 29, 2, 0 },
			 { 0, 4, 39, 7, 65, 19, 1 },
			 { 0, 8, 50, 7, 58, 12, 0 },
			 { 1, 13, 61, 7, 47, 6, 0 },
			 { 1, 22, 67, 7, 35, 3, 0 },
			 { 0, 3, 32, 7, 67, 24, 2 },
			 { 0, 5, 44, 7, 62, 16, 1 },
			 { 0, 10, 55, 7, 54, 9, 0 },
			 { 1, 17, 63, 7, 42, 5, 0 },
			 { 2, 26, 67, 7, 31, 2, 0 },
			 { 0, 4, 37, 7, 66, 20, 1 },
			 { 0, 7, 49, 7, 60, 12, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 4, 40, 7, 65, 18, 1 },
			 { 0, 8, 51, 7, 58, 11, 0 },
			 { 1, 14, 61, 7, 46, 6, 0 },
			 { 1, 22, 67, 7, 35, 3, 0 },
			 { 0, 3, 33, 7, 67, 24, 1 },
			 { 0, 6, 45, 7, 61, 15, 1 },
			 { 0, 10, 56, 7, 53, 9, 0 },
			 { 1, 17, 64, 7, 41, 5, 0 },
			 { 2, 27, 67, 7, 30, 2, 0 },
			 { 0, 4, 38, 7, 65, 20, 1 },
			 { 0, 7, 50, 7, 59, 12, 0 },
			 { 0, 13, 60, 7, 48, 7, 0 },
			 { 1, 21, 67, 7, 36, 3, 0 },
			 { 0, 3, 31, 7, 67, 25, 2 },
			 { 0, 5, 43, 7, 63, 16, 1 },
			 { 0, 9, 56, 7, 54, 9, 0 },
			 { 1, 16, 63, 7, 43, 5, 0 },
			 { 2, 25, 67, 7, 31, 3, 0 },
			 { 0, 3, 36, 7, 67, 21, 1 },
			 { 0, 7, 48, 7, 60, 13, 0 },
			 { 0, 12, 59, 7, 50, 7, 0 },
			 { 1, 20, 65, 7, 38, 4, 0 },
			 { 0, 2, 30, 7, 67, 27, 2 },
			 { 0, 5, 41, 7, 64, 17, 1 },
			 { 0, 9, 53, 7, 56, 10, 0 },
			 { 1, 15, 61, 7, 45, 6, 0 },
			 { 1, 24, 67, 7, 33, 3, 0 },
			 { 0, 3, 35, 7, 67, 22, 1 },
			 { 0, 6, 46, 7, 61, 14, 1 },
			 { 0, 11, 58, 7, 51, 8, 0 },
			 { 1, 18, 65, 7, 40, 4, 0 } },
		.odd = { { 0, 12, 60, 7, 49, 7, 0 },
			 { 1, 20, 66, 7, 37, 4, 0 },
			 { 0, 2, 31, 7, 67, 26, 2 },
			 { 0, 5, 42, 7, 63, 17, 1 },
			 { 0, 9, 54, 7, 55, 10, 0 },
			 { 1, 16, 62, 7, 44, 5, 0 },
			 { 2, 24, 67, 7, 32, 3, 0 },
			 { 0, 3, 35, 7, 67, 22, 1 },
			 { 0, 6, 47, 7, 61, 13, 1 },
			 { 0, 12, 58, 7, 50, 8, 0 },
			 { 1, 19, 65, 7, 39, 4, 0 },
			 { 0, 2, 29, 7, 68, 27, 2 },
			 { 0, 4, 40, 7, 65, 18, 1 },
			 { 0, 8, 52, 7, 57, 11, 0 },
			 { 1, 14, 61, 7, 46, 6, 0 },
			 { 1, 23, 67, 7, 34, 3, 0 },
			 { 0, 3, 34, 7, 67, 23, 1 },
			 { 0, 6, 46, 7, 61, 14, 1 },
			 { 0, 11, 57, 7, 52, 8, 0 },
			 { 1, 18, 65, 7, 40, 4, 0 },
			 { 2, 27, 68, 7, 29, 2, 0 },
			 { 0, 4, 39, 7, 65, 19, 1 },
			 { 0, 8, 50, 7, 58, 12, 0 },
			 { 1, 13, 61, 7, 47, 6, 0 },
			 { 1, 22, 67, 7, 35, 3, 0 },
			 { 0, 3, 32, 7, 67, 24, 2 },
			 { 0, 5, 44, 7, 62, 16, 1 },
			 { 0, 10, 55, 7, 54, 9, 0 },
			 { 1, 17, 63, 7, 42, 5, 0 },
			 { 2, 26, 67, 7, 31, 2, 0 },
			 { 0, 4, 37, 7, 66, 20, 1 },
			 { 0, 7, 49, 7, 60, 12, 0 } } },
	.ptrn_arr = { { 0x42424849, 0x90921212, 0x24248490, 0x9212124,
			 0x48484909, 0x92121242, 0x84849090, 0x2424 } },
	.sample_patrn_length = 242,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 90) = 0.262295 */
	.hor_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 4, 38, 7, 65, 20, 1 },
			 { 0, 7, 48, 7, 59, 13, 1 },
			 { 0, 11, 58, 7, 51, 8, 0 },
			 { 1, 17, 64, 7, 41, 5, 0 },
			 { 2, 25, 67, 7, 31, 3, 0 },
			 { 0, 3, 35, 7, 66, 23, 1 },
			 { 0, 6, 45, 7, 61, 15, 1 },
			 { 0, 10, 54, 7, 54, 10, 0 },
			 { 1, 15, 61, 7, 45, 6, 0 },
			 { 1, 23, 66, 7, 35, 3, 0 },
			 { 0, 3, 31, 7, 67, 25, 2 },
			 { 0, 5, 41, 7, 64, 17, 1 },
			 { 0, 8, 51, 7, 58, 11, 0 },
			 { 1, 13, 59, 7, 48, 7, 0 },
			 { 1, 20, 65, 7, 38, 4, 0 } },
		.odd = { { 0, 12, 59, 7, 49, 8, 0 },
			 { 1, 19, 64, 7, 40, 4, 0 },
			 { 2, 27, 67, 7, 30, 2, 0 },
			 { 0, 4, 36, 7, 66, 21, 1 },
			 { 0, 6, 46, 7, 61, 14, 1 },
			 { 0, 10, 56, 7, 53, 9, 0 },
			 { 1, 16, 63, 7, 43, 5, 0 },
			 { 2, 24, 66, 7, 33, 3, 0 },
			 { 0, 3, 33, 7, 66, 24, 2 },
			 { 0, 5, 43, 7, 63, 16, 1 },
			 { 0, 9, 53, 7, 56, 10, 0 },
			 { 1, 14, 61, 7, 46, 6, 0 },
			 { 1, 21, 66, 7, 36, 4, 0 },
			 { 0, 2, 30, 7, 67, 27, 2 },
			 { 0, 4, 40, 7, 64, 19, 1 },
			 { 0, 8, 49, 7, 59, 12, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 28, 68, 7, 28, 2, 0 },
			 { 0, 4, 38, 7, 65, 20, 1 },
			 { 0, 7, 48, 7, 59, 13, 1 },
			 { 0, 11, 58, 7, 51, 8, 0 },
			 { 1, 17, 64, 7, 41, 5, 0 },
			 { 2, 25, 67, 7, 31, 3, 0 },
			 { 0, 3, 35, 7, 66, 23, 1 },
			 { 0, 6, 45, 7, 61, 15, 1 },
			 { 0, 10, 54, 7, 54, 10, 0 },
			 { 1, 15, 61, 7, 45, 6, 0 },
			 { 1, 23, 66, 7, 35, 3, 0 },
			 { 0, 3, 31, 7, 67, 25, 2 },
			 { 0, 5, 41, 7, 64, 17, 1 },
			 { 0, 8, 51, 7, 58, 11, 0 },
			 { 1, 13, 59, 7, 48, 7, 0 },
			 { 1, 20, 65, 7, 38, 4, 0 } },
		.odd = { { 0, 12, 59, 7, 49, 8, 0 },
			 { 1, 19, 64, 7, 40, 4, 0 },
			 { 2, 27, 67, 7, 30, 2, 0 },
			 { 0, 4, 36, 7, 66, 21, 1 },
			 { 0, 6, 46, 7, 61, 14, 1 },
			 { 0, 10, 56, 7, 53, 9, 0 },
			 { 1, 16, 63, 7, 43, 5, 0 },
			 { 2, 24, 66, 7, 33, 3, 0 },
			 { 0, 3, 33, 7, 66, 24, 2 },
			 { 0, 5, 43, 7, 63, 16, 1 },
			 { 0, 9, 53, 7, 56, 10, 0 },
			 { 1, 14, 61, 7, 46, 6, 0 },
			 { 1, 21, 66, 7, 36, 4, 0 },
			 { 0, 2, 30, 7, 67, 27, 2 },
			 { 0, 4, 40, 7, 64, 19, 1 },
			 { 0, 8, 49, 7, 59, 12, 0 } } },
	.ptrn_arr = { { 0x42484849, 0x92121242, 0x84849090, 0x242424 } },
	.sample_patrn_length = 122,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 91) = 0.260163 */
	.hor_phase_arr = {
		.even = { { 2, 29, 66, 7, 29, 2, 0 },
			 { 0, 4, 36, 7, 66, 21, 1 },
			 { 0, 6, 45, 7, 61, 15, 1 },
			 { 0, 9, 52, 7, 56, 11, 0 },
			 { 1, 13, 59, 7, 48, 7, 0 },
			 { 1, 19, 63, 7, 40, 5, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 },
			 { 0, 3, 33, 7, 66, 24, 2 },
			 { 0, 5, 41, 7, 63, 18, 1 },
			 { 0, 8, 49, 7, 59, 12, 0 },
			 { 0, 12, 57, 7, 51, 8, 0 },
			 { 1, 17, 62, 7, 43, 5, 0 },
			 { 1, 23, 66, 7, 35, 3, 0 },
			 { 0, 3, 30, 7, 66, 27, 2 },
			 { 0, 4, 38, 7, 65, 20, 1 },
			 { 0, 7, 46, 7, 60, 14, 1 },
			 { 0, 10, 54, 7, 54, 10, 0 },
			 { 1, 14, 60, 7, 46, 7, 0 },
			 { 1, 20, 65, 7, 38, 4, 0 },
			 { 2, 27, 66, 7, 30, 3, 0 },
			 { 0, 3, 35, 7, 66, 23, 1 },
			 { 0, 5, 43, 7, 62, 17, 1 },
			 { 0, 8, 51, 7, 57, 12, 0 },
			 { 0, 12, 59, 7, 49, 8, 0 },
			 { 1, 18, 63, 7, 41, 5, 0 },
			 { 2, 24, 66, 7, 33, 3, 0 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 5, 40, 7, 63, 19, 1 },
			 { 0, 7, 48, 7, 59, 13, 1 },
			 { 0, 11, 56, 7, 52, 9, 0 },
			 { 1, 15, 61, 7, 45, 6, 0 },
			 { 1, 21, 66, 7, 36, 4, 0 } },
		.odd = { { 0, 12, 58, 7, 50, 8, 0 },
			 { 1, 17, 63, 7, 42, 5, 0 },
			 { 2, 23, 66, 7, 34, 3, 0 },
			 { 0, 3, 31, 7, 66, 26, 2 },
			 { 0, 4, 39, 7, 64, 20, 1 },
			 { 0, 7, 47, 7, 59, 14, 1 },
			 { 0, 10, 55, 7, 53, 10, 0 },
			 { 1, 15, 61, 7, 45, 6, 0 },
			 { 1, 21, 65, 7, 37, 4, 0 },
			 { 2, 28, 67, 7, 29, 2, 0 },
			 { 0, 4, 36, 7, 65, 22, 1 },
			 { 0, 6, 44, 7, 61, 16, 1 },
			 { 0, 9, 52, 7, 56, 11, 0 },
			 { 1, 13, 58, 7, 49, 7, 0 },
			 { 1, 18, 64, 7, 40, 5, 0 },
			 { 2, 25, 66, 7, 32, 3, 0 },
			 { 0, 3, 32, 7, 66, 25, 2 },
			 { 0, 5, 40, 7, 64, 18, 1 },
			 { 0, 7, 49, 7, 58, 13, 1 },
			 { 0, 11, 56, 7, 52, 9, 0 },
			 { 1, 16, 61, 7, 44, 6, 0 },
			 { 1, 22, 65, 7, 36, 4, 0 },
			 { 0, 2, 29, 7, 67, 28, 2 },
			 { 0, 4, 37, 7, 65, 21, 1 },
			 { 0, 6, 45, 7, 61, 15, 1 },
			 { 0, 10, 53, 7, 55, 10, 0 },
			 { 1, 14, 59, 7, 47, 7, 0 },
			 { 1, 20, 64, 7, 39, 4, 0 },
			 { 2, 26, 66, 7, 31, 3, 0 },
			 { 0, 3, 34, 7, 66, 23, 2 },
			 { 0, 5, 42, 7, 63, 17, 1 },
			 { 0, 8, 50, 7, 58, 12, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 29, 66, 7, 29, 2, 0 },
			 { 0, 4, 36, 7, 66, 21, 1 },
			 { 0, 6, 45, 7, 61, 15, 1 },
			 { 0, 9, 52, 7, 56, 11, 0 },
			 { 1, 13, 59, 7, 48, 7, 0 },
			 { 1, 19, 63, 7, 40, 5, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 },
			 { 0, 3, 33, 7, 66, 24, 2 },
			 { 0, 5, 41, 7, 63, 18, 1 },
			 { 0, 8, 49, 7, 59, 12, 0 },
			 { 0, 12, 57, 7, 51, 8, 0 },
			 { 1, 17, 62, 7, 43, 5, 0 },
			 { 1, 23, 66, 7, 35, 3, 0 },
			 { 0, 3, 30, 7, 66, 27, 2 },
			 { 0, 4, 38, 7, 65, 20, 1 },
			 { 0, 7, 46, 7, 60, 14, 1 },
			 { 0, 10, 54, 7, 54, 10, 0 },
			 { 1, 14, 60, 7, 46, 7, 0 },
			 { 1, 20, 65, 7, 38, 4, 0 },
			 { 2, 27, 66, 7, 30, 3, 0 },
			 { 0, 3, 35, 7, 66, 23, 1 },
			 { 0, 5, 43, 7, 62, 17, 1 },
			 { 0, 8, 51, 7, 57, 12, 0 },
			 { 0, 12, 59, 7, 49, 8, 0 },
			 { 1, 18, 63, 7, 41, 5, 0 },
			 { 2, 24, 66, 7, 33, 3, 0 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 5, 40, 7, 63, 19, 1 },
			 { 0, 7, 48, 7, 59, 13, 1 },
			 { 0, 11, 56, 7, 52, 9, 0 },
			 { 1, 15, 61, 7, 45, 6, 0 },
			 { 1, 21, 66, 7, 36, 4, 0 } },
		.odd = { { 0, 12, 58, 7, 50, 8, 0 },
			 { 1, 17, 63, 7, 42, 5, 0 },
			 { 2, 23, 66, 7, 34, 3, 0 },
			 { 0, 3, 31, 7, 66, 26, 2 },
			 { 0, 4, 39, 7, 64, 20, 1 },
			 { 0, 7, 47, 7, 59, 14, 1 },
			 { 0, 10, 55, 7, 53, 10, 0 },
			 { 1, 15, 61, 7, 45, 6, 0 },
			 { 1, 21, 65, 7, 37, 4, 0 },
			 { 2, 28, 67, 7, 29, 2, 0 },
			 { 0, 4, 36, 7, 65, 22, 1 },
			 { 0, 6, 44, 7, 61, 16, 1 },
			 { 0, 9, 52, 7, 56, 11, 0 },
			 { 1, 13, 58, 7, 49, 7, 0 },
			 { 1, 18, 64, 7, 40, 5, 0 },
			 { 2, 25, 66, 7, 32, 3, 0 },
			 { 0, 3, 32, 7, 66, 25, 2 },
			 { 0, 5, 40, 7, 64, 18, 1 },
			 { 0, 7, 49, 7, 58, 13, 1 },
			 { 0, 11, 56, 7, 52, 9, 0 },
			 { 1, 16, 61, 7, 44, 6, 0 },
			 { 1, 22, 65, 7, 36, 4, 0 },
			 { 0, 2, 29, 7, 67, 28, 2 },
			 { 0, 4, 37, 7, 65, 21, 1 },
			 { 0, 6, 45, 7, 61, 15, 1 },
			 { 0, 10, 53, 7, 55, 10, 0 },
			 { 1, 14, 59, 7, 47, 7, 0 },
			 { 1, 20, 64, 7, 39, 4, 0 },
			 { 2, 26, 66, 7, 31, 3, 0 },
			 { 0, 3, 34, 7, 66, 23, 2 },
			 { 0, 5, 42, 7, 63, 17, 1 },
			 { 0, 8, 50, 7, 58, 12, 0 } } },
	.ptrn_arr = { { 0x42484849, 0x12124242, 0x90909212, 0x24848484,
			 0x21242424, 0x9090921, 0x48484849, 0x24242 } },
	.sample_patrn_length = 246,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 92) = 0.258065 */
	.hor_phase_arr = {
		.even = { { 2, 29, 66, 7, 29, 2, 0 },
			 { 0, 4, 35, 7, 64, 23, 2 },
			 { 0, 5, 41, 7, 63, 18, 1 },
			 { 0, 7, 48, 7, 58, 14, 1 },
			 { 0, 10, 54, 7, 54, 10, 0 },
			 { 1, 14, 58, 7, 48, 7, 0 },
			 { 1, 18, 63, 7, 41, 5, 0 },
			 { 2, 23, 64, 7, 35, 4, 0 } },
		.odd = { { 0, 12, 56, 7, 51, 9, 0 },
			 { 1, 16, 61, 7, 44, 6, 0 },
			 { 1, 20, 65, 7, 38, 4, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 4, 38, 7, 65, 20, 1 },
			 { 0, 6, 44, 7, 61, 16, 1 },
			 { 0, 9, 51, 7, 56, 12, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 29, 66, 7, 29, 2, 0 },
			 { 0, 4, 35, 7, 64, 23, 2 },
			 { 0, 5, 41, 7, 63, 18, 1 },
			 { 0, 7, 48, 7, 58, 14, 1 },
			 { 0, 10, 54, 7, 54, 10, 0 },
			 { 1, 14, 58, 7, 48, 7, 0 },
			 { 1, 18, 63, 7, 41, 5, 0 },
			 { 2, 23, 64, 7, 35, 4, 0 } },
		.odd = { { 0, 12, 56, 7, 51, 9, 0 },
			 { 1, 16, 61, 7, 44, 6, 0 },
			 { 1, 20, 65, 7, 38, 4, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 4, 38, 7, 65, 20, 1 },
			 { 0, 6, 44, 7, 61, 16, 1 },
			 { 0, 9, 51, 7, 56, 12, 0 } } },
	.ptrn_arr = { { 0x48484849, 0x2424242 } },
	.sample_patrn_length = 62,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 93) = 0.256 */
	.hor_phase_arr = {
		.even = { { 2, 29, 66, 7, 29, 2, 0 },
			 { 0, 3, 33, 7, 65, 25, 2 },
			 { 0, 4, 38, 7, 64, 21, 1 },
			 { 0, 6, 43, 7, 61, 17, 1 },
			 { 0, 8, 47, 7, 58, 14, 1 },
			 { 0, 10, 52, 7, 55, 11, 0 },
			 { 1, 12, 56, 7, 50, 9, 0 },
			 { 1, 15, 59, 7, 46, 7, 0 },
			 { 1, 18, 63, 7, 41, 5, 0 },
			 { 1, 22, 65, 7, 36, 4, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 },
			 { 0, 3, 30, 7, 66, 27, 2 },
			 { 0, 4, 35, 7, 64, 23, 2 },
			 { 0, 5, 40, 7, 63, 19, 1 },
			 { 0, 6, 44, 7, 61, 16, 1 },
			 { 0, 8, 49, 7, 57, 13, 1 },
			 { 0, 10, 55, 7, 53, 10, 0 },
			 { 1, 13, 57, 7, 49, 8, 0 },
			 { 1, 16, 61, 7, 44, 6, 0 },
			 { 1, 19, 63, 7, 40, 5, 0 },
			 { 2, 23, 64, 7, 35, 4, 0 },
			 { 2, 27, 66, 7, 30, 3, 0 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 4, 36, 7, 65, 22, 1 },
			 { 0, 5, 41, 7, 63, 18, 1 },
			 { 0, 7, 46, 7, 59, 15, 1 },
			 { 0, 9, 50, 7, 56, 12, 1 },
			 { 0, 11, 55, 7, 52, 10, 0 },
			 { 1, 14, 58, 7, 47, 8, 0 },
			 { 1, 17, 61, 7, 43, 6, 0 },
			 { 1, 21, 64, 7, 38, 4, 0 },
			 { 2, 25, 65, 7, 33, 3, 0 } },
		.odd = { { 0, 12, 56, 7, 51, 9, 0 },
			 { 1, 14, 59, 7, 47, 7, 0 },
			 { 1, 18, 61, 7, 42, 6, 0 },
			 { 1, 21, 65, 7, 37, 4, 0 },
			 { 2, 25, 65, 7, 33, 3, 0 },
			 { 0, 3, 30, 7, 65, 28, 2 },
			 { 0, 3, 34, 7, 65, 24, 2 },
			 { 0, 5, 39, 7, 63, 20, 1 },
			 { 0, 6, 44, 7, 61, 16, 1 },
			 { 0, 8, 48, 7, 58, 13, 1 },
			 { 0, 10, 53, 7, 54, 11, 0 },
			 { 1, 12, 57, 7, 50, 8, 0 },
			 { 1, 15, 60, 7, 45, 7, 0 },
			 { 1, 19, 63, 7, 40, 5, 0 },
			 { 2, 23, 63, 7, 36, 4, 0 },
			 { 2, 27, 65, 7, 31, 3, 0 },
			 { 0, 3, 31, 7, 65, 27, 2 },
			 { 0, 4, 36, 7, 63, 23, 2 },
			 { 0, 5, 40, 7, 63, 19, 1 },
			 { 0, 7, 45, 7, 60, 15, 1 },
			 { 0, 8, 50, 7, 57, 12, 1 },
			 { 0, 11, 54, 7, 53, 10, 0 },
			 { 1, 13, 58, 7, 48, 8, 0 },
			 { 1, 16, 61, 7, 44, 6, 0 },
			 { 1, 20, 63, 7, 39, 5, 0 },
			 { 2, 24, 65, 7, 34, 3, 0 },
			 { 2, 28, 65, 7, 30, 3, 0 },
			 { 0, 3, 33, 7, 65, 25, 2 },
			 { 0, 4, 37, 7, 65, 21, 1 },
			 { 0, 6, 42, 7, 61, 18, 1 },
			 { 0, 7, 47, 7, 59, 14, 1 },
			 { 0, 9, 51, 7, 56, 12, 0 } } },
	.ver_phase_arr = {
		.even = { { 2, 29, 66, 7, 29, 2, 0 },
			 { 0, 3, 33, 7, 65, 25, 2 },
			 { 0, 4, 38, 7, 64, 21, 1 },
			 { 0, 6, 43, 7, 61, 17, 1 },
			 { 0, 8, 47, 7, 58, 14, 1 },
			 { 0, 10, 52, 7, 55, 11, 0 },
			 { 1, 12, 56, 7, 50, 9, 0 },
			 { 1, 15, 59, 7, 46, 7, 0 },
			 { 1, 18, 63, 7, 41, 5, 0 },
			 { 1, 22, 65, 7, 36, 4, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 },
			 { 0, 3, 30, 7, 66, 27, 2 },
			 { 0, 4, 35, 7, 64, 23, 2 },
			 { 0, 5, 40, 7, 63, 19, 1 },
			 { 0, 6, 44, 7, 61, 16, 1 },
			 { 0, 8, 49, 7, 57, 13, 1 },
			 { 0, 10, 55, 7, 53, 10, 0 },
			 { 1, 13, 57, 7, 49, 8, 0 },
			 { 1, 16, 61, 7, 44, 6, 0 },
			 { 1, 19, 63, 7, 40, 5, 0 },
			 { 2, 23, 64, 7, 35, 4, 0 },
			 { 2, 27, 66, 7, 30, 3, 0 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 4, 36, 7, 65, 22, 1 },
			 { 0, 5, 41, 7, 63, 18, 1 },
			 { 0, 7, 46, 7, 59, 15, 1 },
			 { 0, 9, 50, 7, 56, 12, 1 },
			 { 0, 11, 55, 7, 52, 10, 0 },
			 { 1, 14, 58, 7, 47, 8, 0 },
			 { 1, 17, 61, 7, 43, 6, 0 },
			 { 1, 21, 64, 7, 38, 4, 0 },
			 { 2, 25, 65, 7, 33, 3, 0 } },
		.odd = { { 0, 12, 56, 7, 51, 9, 0 },
			 { 1, 14, 59, 7, 47, 7, 0 },
			 { 1, 18, 61, 7, 42, 6, 0 },
			 { 1, 21, 65, 7, 37, 4, 0 },
			 { 2, 25, 65, 7, 33, 3, 0 },
			 { 0, 3, 30, 7, 65, 28, 2 },
			 { 0, 3, 34, 7, 65, 24, 2 },
			 { 0, 5, 39, 7, 63, 20, 1 },
			 { 0, 6, 44, 7, 61, 16, 1 },
			 { 0, 8, 48, 7, 58, 13, 1 },
			 { 0, 10, 53, 7, 54, 11, 0 },
			 { 1, 12, 57, 7, 50, 8, 0 },
			 { 1, 15, 60, 7, 45, 7, 0 },
			 { 1, 19, 63, 7, 40, 5, 0 },
			 { 2, 23, 63, 7, 36, 4, 0 },
			 { 2, 27, 65, 7, 31, 3, 0 },
			 { 0, 3, 31, 7, 65, 27, 2 },
			 { 0, 4, 36, 7, 63, 23, 2 },
			 { 0, 5, 40, 7, 63, 19, 1 },
			 { 0, 7, 45, 7, 60, 15, 1 },
			 { 0, 8, 50, 7, 57, 12, 1 },
			 { 0, 11, 54, 7, 53, 10, 0 },
			 { 1, 13, 58, 7, 48, 8, 0 },
			 { 1, 16, 61, 7, 44, 6, 0 },
			 { 1, 20, 63, 7, 39, 5, 0 },
			 { 2, 24, 65, 7, 34, 3, 0 },
			 { 2, 28, 65, 7, 30, 3, 0 },
			 { 0, 3, 33, 7, 65, 25, 2 },
			 { 0, 4, 37, 7, 65, 21, 1 },
			 { 0, 6, 42, 7, 61, 18, 1 },
			 { 0, 7, 47, 7, 59, 14, 1 },
			 { 0, 9, 51, 7, 56, 12, 0 } } },
	.ptrn_arr = { { 0x48484849, 0x42424248, 0x12124242, 0x92121212,
			 0x90909090, 0x84848490, 0x24248484, 0x242424 } },
	.sample_patrn_length = 250,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 94) = 0.253968 */
	.hor_phase_arr = {
		.even = { { 3, 29, 64, 7, 29, 3, 0 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 4, 35, 7, 64, 23, 2 },
			 { 0, 5, 38, 7, 63, 21, 1 },
			 { 0, 5, 41, 7, 63, 18, 1 },
			 { 0, 7, 44, 7, 60, 16, 1 },
			 { 0, 8, 47, 7, 58, 14, 1 },
			 { 0, 9, 50, 7, 56, 12, 1 },
			 { 0, 11, 53, 7, 53, 11, 0 },
			 { 1, 12, 56, 7, 50, 9, 0 },
			 { 1, 14, 58, 7, 47, 8, 0 },
			 { 1, 16, 60, 7, 44, 7, 0 },
			 { 1, 18, 63, 7, 41, 5, 0 },
			 { 1, 21, 63, 7, 38, 5, 0 },
			 { 2, 23, 64, 7, 35, 4, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 } },
		.odd = { { 0, 11, 55, 7, 52, 10, 0 },
			 { 1, 13, 57, 7, 49, 8, 0 },
			 { 1, 15, 59, 7, 46, 7, 0 },
			 { 1, 17, 61, 7, 43, 6, 0 },
			 { 1, 20, 62, 7, 40, 5, 0 },
			 { 2, 22, 63, 7, 37, 4, 0 },
			 { 2, 25, 65, 7, 33, 3, 0 },
			 { 2, 28, 65, 7, 30, 3, 0 },
			 { 0, 3, 30, 7, 65, 28, 2 },
			 { 0, 3, 33, 7, 65, 25, 2 },
			 { 0, 4, 37, 7, 63, 22, 2 },
			 { 0, 5, 40, 7, 62, 20, 1 },
			 { 0, 6, 43, 7, 61, 17, 1 },
			 { 0, 7, 46, 7, 59, 15, 1 },
			 { 0, 8, 49, 7, 57, 13, 1 },
			 { 0, 10, 52, 7, 55, 11, 0 } } },
	.ver_phase_arr = {
		.even = { { 3, 29, 64, 7, 29, 3, 0 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 4, 35, 7, 64, 23, 2 },
			 { 0, 5, 38, 7, 63, 21, 1 },
			 { 0, 5, 41, 7, 63, 18, 1 },
			 { 0, 7, 44, 7, 60, 16, 1 },
			 { 0, 8, 47, 7, 58, 14, 1 },
			 { 0, 9, 50, 7, 56, 12, 1 },
			 { 0, 11, 53, 7, 53, 11, 0 },
			 { 1, 12, 56, 7, 50, 9, 0 },
			 { 1, 14, 58, 7, 47, 8, 0 },
			 { 1, 16, 60, 7, 44, 7, 0 },
			 { 1, 18, 63, 7, 41, 5, 0 },
			 { 1, 21, 63, 7, 38, 5, 0 },
			 { 2, 23, 64, 7, 35, 4, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 } },
		.odd = { { 0, 11, 55, 7, 52, 10, 0 },
			 { 1, 13, 57, 7, 49, 8, 0 },
			 { 1, 15, 59, 7, 46, 7, 0 },
			 { 1, 17, 61, 7, 43, 6, 0 },
			 { 1, 20, 62, 7, 40, 5, 0 },
			 { 2, 22, 63, 7, 37, 4, 0 },
			 { 2, 25, 65, 7, 33, 3, 0 },
			 { 2, 28, 65, 7, 30, 3, 0 },
			 { 0, 3, 30, 7, 65, 28, 2 },
			 { 0, 3, 33, 7, 65, 25, 2 },
			 { 0, 4, 37, 7, 63, 22, 2 },
			 { 0, 5, 40, 7, 62, 20, 1 },
			 { 0, 6, 43, 7, 61, 17, 1 },
			 { 0, 7, 46, 7, 59, 15, 1 },
			 { 0, 8, 49, 7, 57, 13, 1 },
			 { 0, 10, 52, 7, 55, 11, 0 } } },
	.ptrn_arr = { { 0x48484849, 0x48484848, 0x42424242, 0x2424242 } },
	.sample_patrn_length = 126,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 95) = 0.251969 */
	.hor_phase_arr = {
		.even = { { 3, 29, 64, 7, 29, 3, 0 },
			 { 0, 3, 31, 7, 64, 28, 2 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 4, 34, 7, 63, 25, 2 },
			 { 0, 4, 35, 7, 63, 24, 2 },
			 { 0, 4, 37, 7, 63, 22, 2 },
			 { 0, 5, 38, 7, 63, 21, 1 },
			 { 0, 5, 40, 7, 62, 20, 1 },
			 { 0, 6, 41, 7, 61, 19, 1 },
			 { 0, 6, 43, 7, 61, 17, 1 },
			 { 0, 7, 44, 7, 60, 16, 1 },
			 { 0, 7, 46, 7, 59, 15, 1 },
			 { 0, 8, 47, 7, 58, 14, 1 },
			 { 0, 9, 49, 7, 56, 13, 1 },
			 { 0, 9, 50, 7, 56, 12, 1 },
			 { 0, 10, 51, 7, 54, 12, 1 },
			 { 0, 11, 53, 7, 53, 11, 0 },
			 { 1, 12, 54, 7, 51, 10, 0 },
			 { 1, 12, 56, 7, 50, 9, 0 },
			 { 1, 13, 56, 7, 49, 9, 0 },
			 { 1, 14, 58, 7, 47, 8, 0 },
			 { 1, 15, 59, 7, 46, 7, 0 },
			 { 1, 16, 60, 7, 44, 7, 0 },
			 { 1, 17, 61, 7, 43, 6, 0 },
			 { 1, 19, 61, 7, 41, 6, 0 },
			 { 1, 20, 62, 7, 40, 5, 0 },
			 { 1, 21, 63, 7, 38, 5, 0 },
			 { 2, 22, 63, 7, 37, 4, 0 },
			 { 2, 24, 63, 7, 35, 4, 0 },
			 { 2, 25, 63, 7, 34, 4, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 },
			 { 2, 28, 64, 7, 31, 3, 0 } },
		.odd = { { 0, 11, 55, 7, 52, 10, 0 },
			 { 1, 12, 54, 7, 51, 10, 0 },
			 { 1, 13, 56, 7, 49, 9, 0 },
			 { 1, 14, 57, 7, 48, 8, 0 },
			 { 1, 15, 58, 7, 46, 8, 0 },
			 { 1, 16, 59, 7, 45, 7, 0 },
			 { 1, 17, 61, 7, 43, 6, 0 },
			 { 1, 18, 61, 7, 42, 6, 0 },
			 { 1, 19, 63, 7, 40, 5, 0 },
			 { 1, 20, 63, 7, 39, 5, 0 },
			 { 2, 22, 62, 7, 37, 5, 0 },
			 { 2, 23, 63, 7, 36, 4, 0 },
			 { 2, 24, 64, 7, 34, 4, 0 },
			 { 2, 26, 64, 7, 33, 3, 0 },
			 { 2, 27, 65, 7, 31, 3, 0 },
			 { 3, 28, 64, 7, 30, 3, 0 },
			 { 0, 3, 30, 7, 64, 28, 3 },
			 { 0, 3, 31, 7, 65, 27, 2 },
			 { 0, 3, 33, 7, 64, 26, 2 },
			 { 0, 4, 34, 7, 64, 24, 2 },
			 { 0, 4, 36, 7, 63, 23, 2 },
			 { 0, 5, 37, 7, 62, 22, 2 },
			 { 0, 5, 39, 7, 63, 20, 1 },
			 { 0, 5, 40, 7, 63, 19, 1 },
			 { 0, 6, 42, 7, 61, 18, 1 },
			 { 0, 6, 43, 7, 61, 17, 1 },
			 { 0, 7, 45, 7, 59, 16, 1 },
			 { 0, 8, 46, 7, 58, 15, 1 },
			 { 0, 8, 48, 7, 57, 14, 1 },
			 { 0, 9, 49, 7, 56, 13, 1 },
			 { 0, 10, 51, 7, 54, 12, 1 },
			 { 0, 10, 52, 7, 55, 11, 0 } } },
	.ver_phase_arr = {
		.even = { { 3, 29, 64, 7, 29, 3, 0 },
			 { 0, 3, 31, 7, 64, 28, 2 },
			 { 0, 3, 32, 7, 65, 26, 2 },
			 { 0, 4, 34, 7, 63, 25, 2 },
			 { 0, 4, 35, 7, 63, 24, 2 },
			 { 0, 4, 37, 7, 63, 22, 2 },
			 { 0, 5, 38, 7, 63, 21, 1 },
			 { 0, 5, 40, 7, 62, 20, 1 },
			 { 0, 6, 41, 7, 61, 19, 1 },
			 { 0, 6, 43, 7, 61, 17, 1 },
			 { 0, 7, 44, 7, 60, 16, 1 },
			 { 0, 7, 46, 7, 59, 15, 1 },
			 { 0, 8, 47, 7, 58, 14, 1 },
			 { 0, 9, 49, 7, 56, 13, 1 },
			 { 0, 9, 50, 7, 56, 12, 1 },
			 { 0, 10, 51, 7, 54, 12, 1 },
			 { 0, 11, 53, 7, 53, 11, 0 },
			 { 1, 12, 54, 7, 51, 10, 0 },
			 { 1, 12, 56, 7, 50, 9, 0 },
			 { 1, 13, 56, 7, 49, 9, 0 },
			 { 1, 14, 58, 7, 47, 8, 0 },
			 { 1, 15, 59, 7, 46, 7, 0 },
			 { 1, 16, 60, 7, 44, 7, 0 },
			 { 1, 17, 61, 7, 43, 6, 0 },
			 { 1, 19, 61, 7, 41, 6, 0 },
			 { 1, 20, 62, 7, 40, 5, 0 },
			 { 1, 21, 63, 7, 38, 5, 0 },
			 { 2, 22, 63, 7, 37, 4, 0 },
			 { 2, 24, 63, 7, 35, 4, 0 },
			 { 2, 25, 63, 7, 34, 4, 0 },
			 { 2, 26, 65, 7, 32, 3, 0 },
			 { 2, 28, 64, 7, 31, 3, 0 } },
		.odd = { { 0, 11, 55, 7, 52, 10, 0 },
			 { 1, 12, 54, 7, 51, 10, 0 },
			 { 1, 13, 56, 7, 49, 9, 0 },
			 { 1, 14, 57, 7, 48, 8, 0 },
			 { 1, 15, 58, 7, 46, 8, 0 },
			 { 1, 16, 59, 7, 45, 7, 0 },
			 { 1, 17, 61, 7, 43, 6, 0 },
			 { 1, 18, 61, 7, 42, 6, 0 },
			 { 1, 19, 63, 7, 40, 5, 0 },
			 { 1, 20, 63, 7, 39, 5, 0 },
			 { 2, 22, 62, 7, 37, 5, 0 },
			 { 2, 23, 63, 7, 36, 4, 0 },
			 { 2, 24, 64, 7, 34, 4, 0 },
			 { 2, 26, 64, 7, 33, 3, 0 },
			 { 2, 27, 65, 7, 31, 3, 0 },
			 { 3, 28, 64, 7, 30, 3, 0 },
			 { 0, 3, 30, 7, 64, 28, 3 },
			 { 0, 3, 31, 7, 65, 27, 2 },
			 { 0, 3, 33, 7, 64, 26, 2 },
			 { 0, 4, 34, 7, 64, 24, 2 },
			 { 0, 4, 36, 7, 63, 23, 2 },
			 { 0, 5, 37, 7, 62, 22, 2 },
			 { 0, 5, 39, 7, 63, 20, 1 },
			 { 0, 5, 40, 7, 63, 19, 1 },
			 { 0, 6, 42, 7, 61, 18, 1 },
			 { 0, 6, 43, 7, 61, 17, 1 },
			 { 0, 7, 45, 7, 59, 16, 1 },
			 { 0, 8, 46, 7, 58, 15, 1 },
			 { 0, 8, 48, 7, 57, 14, 1 },
			 { 0, 9, 49, 7, 56, 13, 1 },
			 { 0, 10, 51, 7, 54, 12, 1 },
			 { 0, 10, 52, 7, 55, 11, 0 } } },
	.ptrn_arr = { { 0x48484849, 0x48484848, 0x48484848, 0x48484848,
			 0x42424242, 0x42424242, 0x42424242, 0x2424242 } },
	.sample_patrn_length = 254,
	.hor_ds_en = 1,
	.ver_ds_en = 1
}, {
	/* Scale factor 32 / (32 + 96) = 0.25 */
	.hor_phase_arr = {
		.even = { { 3, 29, 64, 7, 29, 3, 0 } },
		.odd = { { 0, 11, 53, 7, 53, 11, 0 } } },
	.ver_phase_arr = {
		.even = { { 3, 29, 64, 7, 29, 3, 0 } },
		.odd = { { 0, 11, 53, 7, 53, 11, 0 } } },
	.ptrn_arr = { { 0x9 } },
	.sample_patrn_length = 8,
	.hor_ds_en = 1,
	.ver_ds_en = 1
} };

const s32 imgu_css_downscale_4taps[IMGU_SCALER_DOWNSCALE_4TAPS_LEN] = {
	IMGU_SCALER_FP * -0.000000000000000,
	IMGU_SCALER_FP * -0.000249009327023,
	IMGU_SCALER_FP * -0.001022241683322,
	IMGU_SCALER_FP * -0.002352252699175,
	IMGU_SCALER_FP * -0.004261594242362,
	IMGU_SCALER_FP * -0.006761648795689,
	IMGU_SCALER_FP * -0.009851589454154,
	IMGU_SCALER_FP * -0.013517488475013,
	IMGU_SCALER_FP * -0.017731595701026,
	IMGU_SCALER_FP * -0.022451806160682,
	IMGU_SCALER_FP * -0.027621333752351,
	IMGU_SCALER_FP * -0.033168605172067,
	IMGU_SCALER_FP * -0.039007385183627,
	IMGU_SCALER_FP * -0.045037140997445,
	IMGU_SCALER_FP * -0.051143649969349,
	IMGU_SCALER_FP * -0.057199851105019,
	IMGU_SCALER_FP * -0.063066937016941,
	IMGU_SCALER_FP * -0.068595679088417,
	IMGU_SCALER_FP * -0.073627974715370,
	IMGU_SCALER_FP * -0.077998601684588,
	IMGU_SCALER_FP * -0.081537161069780,
	IMGU_SCALER_FP * -0.084070186546763,
	IMGU_SCALER_FP * -0.085423394806327,
	IMGU_SCALER_FP * -0.085424048835192,
	IMGU_SCALER_FP * -0.083903403294908,
	IMGU_SCALER_FP * -0.080699199103829,
	IMGU_SCALER_FP * -0.075658172660608,
	IMGU_SCALER_FP * -0.068638543974523,
	IMGU_SCALER_FP * -0.059512447316781,
	IMGU_SCALER_FP * -0.048168267897836,
	IMGU_SCALER_FP * -0.034512848520921,
	IMGU_SCALER_FP * -0.018473531164409,
	IMGU_SCALER_FP * 0.000000000000000,
	IMGU_SCALER_FP * 0.020934105554674,
	IMGU_SCALER_FP * 0.044329836544650,
	IMGU_SCALER_FP * 0.070161864654994,
	IMGU_SCALER_FP * 0.098377719033862,
	IMGU_SCALER_FP * 0.128897348012514,
	IMGU_SCALER_FP * 0.161613019706978,
	IMGU_SCALER_FP * 0.196389570939079,
	IMGU_SCALER_FP * 0.233065009152522,
	IMGU_SCALER_FP * 0.271451467092549,
	IMGU_SCALER_FP * 0.311336505037934,
	IMGU_SCALER_FP * 0.352484750396743,
	IMGU_SCALER_FP * 0.394639859577736,
	IMGU_SCALER_FP * 0.437526782302744,
	IMGU_SCALER_FP * 0.480854304005320,
	IMGU_SCALER_FP * 0.524317837738108,
	IMGU_SCALER_FP * 0.567602433152471,
	IMGU_SCALER_FP * 0.610385966680669,
	IMGU_SCALER_FP * 0.652342474098843,
	IMGU_SCALER_FP * 0.693145584226952,
	IMGU_SCALER_FP * 0.732472010670320,
	IMGU_SCALER_FP * 0.770005057258970,
	IMGU_SCALER_FP * 0.805438092218553,
	IMGU_SCALER_FP * 0.838477946124244,
	IMGU_SCALER_FP * 0.868848189350256,
	IMGU_SCALER_FP * 0.896292246026874,
	IMGU_SCALER_FP * 0.920576303438191,
	IMGU_SCALER_FP * 0.941491978311745,
	IMGU_SCALER_FP * 0.958858704531378,
	IMGU_SCALER_FP * 0.972525810403401,
	IMGU_SCALER_FP * 0.982374257672165,
	IMGU_SCALER_FP * 0.988318018955586,
	IMGU_SCALER_FP * 0.990305075088925,
	IMGU_SCALER_FP * 0.988318018955586,
	IMGU_SCALER_FP * 0.982374257672165,
	IMGU_SCALER_FP * 0.972525810403401,
	IMGU_SCALER_FP * 0.958858704531378,
	IMGU_SCALER_FP * 0.941491978311745,
	IMGU_SCALER_FP * 0.920576303438191,
	IMGU_SCALER_FP * 0.896292246026874,
	IMGU_SCALER_FP * 0.868848189350256,
	IMGU_SCALER_FP * 0.838477946124244,
	IMGU_SCALER_FP * 0.805438092218553,
	IMGU_SCALER_FP * 0.770005057258970,
	IMGU_SCALER_FP * 0.732472010670320,
	IMGU_SCALER_FP * 0.693145584226952,
	IMGU_SCALER_FP * 0.652342474098843,
	IMGU_SCALER_FP * 0.610385966680669,
	IMGU_SCALER_FP * 0.567602433152471,
	IMGU_SCALER_FP * 0.524317837738108,
	IMGU_SCALER_FP * 0.480854304005320,
	IMGU_SCALER_FP * 0.437526782302744,
	IMGU_SCALER_FP * 0.394639859577736,
	IMGU_SCALER_FP * 0.352484750396743,
	IMGU_SCALER_FP * 0.311336505037934,
	IMGU_SCALER_FP * 0.271451467092549,
	IMGU_SCALER_FP * 0.233065009152522,
	IMGU_SCALER_FP * 0.196389570939079,
	IMGU_SCALER_FP * 0.161613019706978,
	IMGU_SCALER_FP * 0.128897348012514,
	IMGU_SCALER_FP * 0.098377719033862,
	IMGU_SCALER_FP * 0.070161864654994,
	IMGU_SCALER_FP * 0.044329836544650,
	IMGU_SCALER_FP * 0.020934105554674,
	IMGU_SCALER_FP * 0.000000000000000,
	IMGU_SCALER_FP * -0.018473531164409,
	IMGU_SCALER_FP * -0.034512848520921,
	IMGU_SCALER_FP * -0.048168267897836,
	IMGU_SCALER_FP * -0.059512447316781,
	IMGU_SCALER_FP * -0.068638543974523,
	IMGU_SCALER_FP * -0.075658172660608,
	IMGU_SCALER_FP * -0.080699199103829,
	IMGU_SCALER_FP * -0.083903403294908,
	IMGU_SCALER_FP * -0.085424048835192,
	IMGU_SCALER_FP * -0.085423394806327,
	IMGU_SCALER_FP * -0.084070186546763,
	IMGU_SCALER_FP * -0.081537161069780,
	IMGU_SCALER_FP * -0.077998601684588,
	IMGU_SCALER_FP * -0.073627974715370,
	IMGU_SCALER_FP * -0.068595679088417,
	IMGU_SCALER_FP * -0.063066937016941,
	IMGU_SCALER_FP * -0.057199851105019,
	IMGU_SCALER_FP * -0.051143649969349,
	IMGU_SCALER_FP * -0.045037140997445,
	IMGU_SCALER_FP * -0.039007385183627,
	IMGU_SCALER_FP * -0.033168605172067,
	IMGU_SCALER_FP * -0.027621333752351,
	IMGU_SCALER_FP * -0.022451806160682,
	IMGU_SCALER_FP * -0.017731595701026,
	IMGU_SCALER_FP * -0.013517488475013,
	IMGU_SCALER_FP * -0.009851589454154,
	IMGU_SCALER_FP * -0.006761648795689,
	IMGU_SCALER_FP * -0.004261594242362,
	IMGU_SCALER_FP * -0.002352252699175,
	IMGU_SCALER_FP * -0.001022241683322,
	IMGU_SCALER_FP * -0.000249009327023
};

const s32 imgu_css_downscale_2taps[IMGU_SCALER_DOWNSCALE_2TAPS_LEN] = {
	IMGU_SCALER_FP * 0.074300676367033,
	IMGU_SCALER_FP * 0.094030234498392,
	IMGU_SCALER_FP * 0.115522859526596,
	IMGU_SCALER_FP * 0.138778551451644,
	IMGU_SCALER_FP * 0.163629399140505,
	IMGU_SCALER_FP * 0.190075402593178,
	IMGU_SCALER_FP * 0.217864695110113,
	IMGU_SCALER_FP * 0.247081232257828,
	IMGU_SCALER_FP * 0.277389191770256,
	IMGU_SCALER_FP * 0.308704618080881,
	IMGU_SCALER_FP * 0.340859600056670,
	IMGU_SCALER_FP * 0.373602270998074,
	IMGU_SCALER_FP * 0.406848675338577,
	IMGU_SCALER_FP * 0.440346946378629,
	IMGU_SCALER_FP * 0.473845217418681,
	IMGU_SCALER_FP * 0.507091621759184,
	IMGU_SCALER_FP * 0.540002203833621,
	IMGU_SCALER_FP * 0.572157185809410,
	IMGU_SCALER_FP * 0.603472612120036,
	IMGU_SCALER_FP * 0.633612660499431,
	IMGU_SCALER_FP * 0.662493375381080,
	IMGU_SCALER_FP * 0.689778934498917,
	IMGU_SCALER_FP * 0.715301426719909,
	IMGU_SCALER_FP * 0.738892940911023,
	IMGU_SCALER_FP * 0.760385565939227,
	IMGU_SCALER_FP * 0.779527435104971,
	IMGU_SCALER_FP * 0.796234592841739,
	IMGU_SCALER_FP * 0.810339128016497,
	IMGU_SCALER_FP * 0.821841040629247,
	IMGU_SCALER_FP * 0.830488463980438,
	IMGU_SCALER_FP * 0.836281398070072,
	IMGU_SCALER_FP * 0.839219842898146,
	IMGU_SCALER_FP * 0.839219842898146,
	IMGU_SCALER_FP * 0.836281398070072,
	IMGU_SCALER_FP * 0.830488463980438,
	IMGU_SCALER_FP * 0.821841040629247,
	IMGU_SCALER_FP * 0.810339128016497,
	IMGU_SCALER_FP * 0.796234592841739,
	IMGU_SCALER_FP * 0.779527435104971,
	IMGU_SCALER_FP * 0.760385565939227,
	IMGU_SCALER_FP * 0.738892940911023,
	IMGU_SCALER_FP * 0.715301426719909,
	IMGU_SCALER_FP * 0.689778934498917,
	IMGU_SCALER_FP * 0.662493375381080,
	IMGU_SCALER_FP * 0.633612660499431,
	IMGU_SCALER_FP * 0.603472612120036,
	IMGU_SCALER_FP * 0.572157185809410,
	IMGU_SCALER_FP * 0.540002203833621,
	IMGU_SCALER_FP * 0.507091621759184,
	IMGU_SCALER_FP * 0.473845217418681,
	IMGU_SCALER_FP * 0.440346946378629,
	IMGU_SCALER_FP * 0.406848675338577,
	IMGU_SCALER_FP * 0.373602270998074,
	IMGU_SCALER_FP * 0.340859600056670,
	IMGU_SCALER_FP * 0.308704618080881,
	IMGU_SCALER_FP * 0.277389191770256,
	IMGU_SCALER_FP * 0.247081232257828,
	IMGU_SCALER_FP * 0.217864695110113,
	IMGU_SCALER_FP * 0.190075402593178,
	IMGU_SCALER_FP * 0.163629399140505,
	IMGU_SCALER_FP * 0.138778551451644,
	IMGU_SCALER_FP * 0.115522859526596,
	IMGU_SCALER_FP * 0.094030234498392,
	IMGU_SCALER_FP * 0.074300676367033
};

/* settings for Geometric Distortion Correction */
const s16 imgu_css_gdc_lut[4][256] = { {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -2, -2, -2,
	-2, -3, -3, -3, -4, -4, -4, -5, -5, -5, -6, -6, -7, -7, -7, -8, -8,
	-9, -9, -10, -10, -11, -11, -12, -12, -13, -13, -14, -14, -15, -15,
	-16, -16, -17, -17, -18, -19, -19, -20, -20, -21, -22, -22, -23, -24,
	-24, -25, -25, -26, -27, -27, -28, -29, -29, -30, -31, -31, -32, -33,
	-33, -34, -35, -35, -36, -37, -37, -38, -39, -39, -40,	-41, -41, -42,
	-43, -43, -44, -45, -45, -46, -46, -47, -48, -48, -49, -50, -50, -51,
	-52, -52, -53, -53, -54, -55, -55, -56, -56, -57, -58, -58, -59, -59,
	-60, -60, -61, -61, -62, -62, -63, -64, -64, -64, -65,	-65, -66, -66,
	-67, -67, -68, -68, -68, -69, -69, -70, -70, -70, -71, -71, -71, -72,
	-72, -72, -73, -73, -73, -73, -74, -74, -74, -74, -74, -75, -75, -75,
	-75, -75, -75, -75, -75, -75, -75, -75, -75, -75, -75,	-75, -75, -75,
	-75, -75, -75, -75, -74, -74, -74, -74, -74, -73, -73, -73, -73, -72,
	-72, -72, -71, -71, -70, -70, -69, -69, -68, -68, -67, -67, -66, -66,
	-65, -64, -64, -63, -62, -61, -61, -60, -59, -58, -57,	-56, -56, -55,
	-54, -53, -52, -51, -50, -49, -47, -46, -45, -44, -43, -41, -40, -39,
	-38, -36, -35, -33, -32, -31, -29, -28, -26, -25, -23, -21, -20, -18,
	-16, -15, -13, -11, -9, -7, -5, -3, -1
}, {
	0, 2, 4, 6, 8, 10, 13, 15, 17, 20, 23, 25, 28, 31, 33, 36, 39, 42, 45,
	48, 51, 54, 58, 61, 64, 68, 71, 74, 78, 82, 85, 89, 93, 96, 100, 104,
	108, 112, 116, 120, 124, 128, 132, 136, 140, 144, 149, 153, 157, 162,
	166, 171, 175, 180, 184, 189, 193, 198, 203, 207, 212, 217, 222, 227,
	232, 236, 241, 246, 251, 256, 261, 266, 271, 276, 282, 287, 292, 297,
	302, 307, 313, 318, 323, 328, 334, 339, 344, 350, 355, 360, 366, 371,
	377, 382, 388, 393, 399, 404, 409, 415, 420, 426, 431, 437, 443, 448,
	454, 459, 465, 470, 476, 481, 487, 492, 498, 504, 509, 515, 520, 526,
	531, 537, 542, 548, 553, 559, 564, 570, 576, 581, 586, 592, 597, 603,
	608, 614, 619, 625, 630, 635, 641, 646, 651, 657, 662, 667, 673, 678,
	683, 688, 694, 699, 704, 709, 714, 719, 724, 729, 735, 740, 745, 749,
	754, 759, 764, 769, 774, 779, 783, 788, 793, 797, 802, 807, 811, 816,
	820, 825, 829, 834, 838, 842, 847, 851, 855, 859, 863, 868, 872, 876,
	880, 884, 888, 891, 895, 899, 903, 906, 910, 914, 917, 921, 924, 927,
	931, 934, 937, 940, 944, 947, 950, 953, 956, 959, 961, 964, 967, 970,
	972, 975, 977, 980, 982, 984, 987, 989, 991, 993, 995, 997, 999, 1001,
	1002, 1004, 1006, 1007, 1009, 1010, 1011, 1013, 1014, 1015, 1016, 1017,
	1018, 1019, 1020, 1020, 1021, 1022, 1022, 1023, 1023, 1023, 1023, 1023
}, {
	1024, 1023, 1023, 1023, 1023, 1023, 1022, 1022, 1021, 1020, 1020, 1019,
	1018, 1017, 1016, 1015, 1014, 1013, 1011, 1010, 1009, 1007, 1006, 1004,
	1002, 1001, 999, 997, 995, 993, 991, 989, 987, 984, 982, 980, 977, 975,
	972, 970, 967, 964, 961, 959, 956, 953, 950, 947, 944, 940, 937, 934,
	931, 927, 924, 921, 917, 914, 910, 906, 903, 899, 895, 891, 888, 884,
	880, 876, 872, 868, 863, 859, 855, 851, 847, 842, 838, 834, 829, 825,
	820, 816, 811, 807, 802, 797, 793, 788, 783, 779, 774, 769, 764, 759,
	754, 749, 745, 740, 735, 729, 724, 719, 714, 709, 704, 699, 694, 688,
	683, 678, 673, 667, 662, 657, 651, 646, 641, 635, 630, 625, 619, 614,
	608, 603, 597, 592, 586, 581, 576, 570, 564, 559, 553, 548, 542, 537,
	531, 526, 520, 515, 509, 504, 498, 492, 487, 481, 476, 470, 465, 459,
	454, 448, 443, 437, 431, 426, 420, 415, 409, 404, 399, 393, 388, 382,
	377, 371, 366, 360, 355, 350, 344, 339, 334, 328, 323, 318, 313, 307,
	302, 297, 292, 287, 282, 276, 271, 266, 261, 256, 251, 246, 241, 236,
	232, 227, 222, 217, 212, 207, 203, 198, 193, 189, 184, 180, 175, 171,
	166, 162, 157, 153, 149, 144, 140, 136, 132, 128, 124, 120, 116, 112,
	108, 104, 100, 96, 93, 89, 85, 82, 78, 74, 71, 68, 64, 61, 58, 54, 51,
	48, 45, 42, 39, 36, 33, 31, 28, 25, 23, 20, 17, 15, 13, 10, 8, 6, 4, 2
}, {
	0, -1, -3, -5, -7, -9, -11, -13, -14, -16, -19, -20, -21, -23, -24, -26,
	-28, -29, -30, -32, -34, -34, -37, -38, -38, -41, -42, -42, -44, -46,
	-46, -48, -49, -49, -51, -52, -53, -54, -55, -56, -57, -57, -58, -59,
	-60, -60, -62, -62, -63, -63, -64, -65, -66, -66, -67, -68, -67, -69,
	-69, -69, -70, -70, -71, -71, -72, -72, -72, -73, -73, -73, -73, -73,
	-73, -74, -75, -74, -75, -75, -74, -75, -75, -75, -75, -75, -75, -75,
	-75, -75, -75, -75, -75, -75, -75, -74, -75, -74, -75, -75, -74, -74,
	-73, -73, -73, -73, -73, -73, -73, -71, -72, -71, -72, -70, -70, -70,
	-69, -70, -69, -68, -68, -68, -67, -67, -66, -66, -65, -65, -64, -64,
	-64, -63, -62, -62, -61, -61, -60, -60, -59, -59, -58, -58, -57, -57,
	-55, -55, -55, -53, -54, -53, -52, -51, -52, -50, -50, -49, -48, -47,
	-46, -46, -46, -46, -45, -43, -43, -42, -42, -41, -41, -40, -39, -39,
	-38, -37, -37, -36, -35, -35, -34, -33, -32, -32, -31, -31, -31, -29,
	-28, -27, -27, -27, -26, -25, -25, -24, -24, -23, -22, -22, -21, -20,
	-20, -20, -18, -19, -17, -17, -16, -16, -15, -14, -14, -14, -14, -12,
	-12, -12, -11, -11, -11, -10, -9, -9, -8, -8, -7, -6, -7, -7, -6, -6,
	-5, -4, -5, -5, -3, -3, -4, -2, -3, -2, -1, -2, -1, -1, 0, -1, -1, 0,
	-1, 0, 1, 0, 0, 0, 0, 0, 0, 0
} };

const struct imgu_css_xnr3_vmem_defaults imgu_css_xnr3_vmem_defaults = {
	.x = {
		1024, 1164, 1320, 1492, 1680, 1884, 2108, 2352,
		2616, 2900, 3208, 3540, 3896, 4276, 4684, 5120
	},
	.a = {
		-7213, -5580, -4371, -3421, -2722, -2159, -6950, -5585,
		-4529, -3697, -3010, -2485, -2070, -1727, -1428, 0
	},
	.b = {
		4096, 3603, 3178, 2811, 2497, 2226, 1990, 1783,
		1603, 1446, 1307, 1185, 1077, 981, 895, 819
	},
	.c = {
		1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	},
};

/* settings for Bayer Noise Reduction */
const struct ipu3_uapi_bnr_static_config imgu_css_bnr_defaults = {
	{ 16, 16, 16, 16 },			/* wb_gains */
	{ 16, 16, 16, 16 },			/* wb_gains_thr */
	{ 0, X, 8, 6, X, 14 },			/* thr_coeffs */
	{ 0, 0, 0, 0 },				/* thr_ctrl_shd */
	{ -128, X, -128, X },			/* opt_center */
	{					/* lut */
		{ 17, 23, 28, 32, 36, 39, 42, 45,
		  48, 51, 53, 55, 58, 60, 62, 64,
		  66, 68, 70, 72, 73, 75, 77, 78,
		  80, 82, 83, 85, 86, 88, 89, 90 }
	},
	{ 4, X, 1, 8, X, 8, X, 8, X },		/* bp_ctrl */
	{ 8, 4, 4, X, 8, X, 1, 1, 1, 1 },	/* dn_detect_ctrl */
};

const struct ipu3_uapi_dm_config imgu_css_dm_defaults = {
	1, 1, 1, X, X, 8, X, 7, X, 8, X, 8, X, 4, X
};

const struct ipu3_uapi_ccm_mat_config imgu_css_ccm_defaults = {
	 9775, -2671,  1087, 0,
	-1071,  8303,   815, 0,
	  -23, -7887, 16103, 0
};

/* settings for Gamma correction */
const struct ipu3_uapi_gamma_corr_lut imgu_css_gamma_lut = { {
	63, 79, 95, 111, 127, 143, 159, 175, 191, 207, 223, 239, 255, 271, 287,
	303, 319, 335, 351, 367, 383, 399, 415, 431, 447, 463, 479, 495, 511,
	527, 543, 559, 575, 591, 607, 623, 639, 655, 671, 687, 703, 719, 735,
	751, 767, 783, 799, 815, 831, 847, 863, 879, 895, 911, 927, 943, 959,
	975, 991, 1007, 1023, 1039, 1055, 1071, 1087, 1103, 1119, 1135, 1151,
	1167, 1183, 1199, 1215, 1231, 1247, 1263, 1279, 1295, 1311, 1327, 1343,
	1359, 1375, 1391, 1407, 1423, 1439, 1455, 1471, 1487, 1503, 1519, 1535,
	1551, 1567, 1583, 1599, 1615, 1631, 1647, 1663, 1679, 1695, 1711, 1727,
	1743, 1759, 1775, 1791, 1807, 1823, 1839, 1855, 1871, 1887, 1903, 1919,
	1935, 1951, 1967, 1983, 1999, 2015, 2031, 2047, 2063, 2079, 2095, 2111,
	2143, 2175, 2207, 2239, 2271, 2303, 2335, 2367, 2399, 2431, 2463, 2495,
	2527, 2559, 2591, 2623, 2655, 2687, 2719, 2751, 2783, 2815, 2847, 2879,
	2911, 2943, 2975, 3007, 3039, 3071, 3103, 3135, 3167, 3199, 3231, 3263,
	3295, 3327, 3359, 3391, 3423, 3455, 3487, 3519, 3551, 3583, 3615, 3647,
	3679, 3711, 3743, 3775, 3807, 3839, 3871, 3903, 3935, 3967, 3999, 4031,
	4063, 4095, 4127, 4159, 4223, 4287, 4351, 4415, 4479, 4543, 4607, 4671,
	4735, 4799, 4863, 4927, 4991, 5055, 5119, 5183, 5247, 5311, 5375, 5439,
	5503, 5567, 5631, 5695, 5759, 5823, 5887, 5951, 6015, 6079, 6143, 6207,
	6271, 6335, 6399, 6463, 6527, 6591, 6655, 6719, 6783, 6847, 6911, 6975,
	7039, 7103, 7167, 7231, 7295, 7359, 7423, 7487, 7551, 7615, 7679, 7743,
	7807, 7871, 7935, 7999, 8063, 8127, 8191
} };

const struct ipu3_uapi_csc_mat_config imgu_css_csc_defaults = {
	 4898,  9617,  1867, 0,
	-2410, -4732,  7143, 0,
	10076, -8437, -1638, 0
};

const struct ipu3_uapi_cds_params imgu_css_cds_defaults = {
	1, 3, 3, 1,
	1, 3, 3, 1,
	4, X,					/* ds_nf */
	1,					/* csc_en */
	0, X					/* uv_bin_output */
};

const struct ipu3_uapi_shd_config_static imgu_css_shd_defaults = {
	.grid = {
		.width = 73,
		.height = 55,
		.block_width_log2 = 7,
		.block_height_log2 = 7,
		.x_start = 0,
		.y_start = 0,
	},
	.general = {
		.shd_enable = 1,
		.gain_factor = 0,
	},
	.black_level = {
		.bl_r = 0,
		.bl_gr = 0 | (0 << IPU3_UAPI_SHD_BLGR_NF_SHIFT),
		.bl_gb = 0,
		.bl_b = 0,
	},
};

const struct ipu3_uapi_yuvp1_iefd_config imgu_css_iefd_defaults = {
	.units = {
		.cu_1 = { 0, 150, 7, 0 },
		.cu_ed = { 7, 110, 244, X, 307, 409, 511, X,
			   184, 255, 255, X, 0, 0, X,
			   7, 81, 255, X, 255, 255, X },
		.cu_3 = { 148, 251, 10, 0 },
		.cu_5 = { 25, 70, 501, X, 32, X },
		.cu_6 = { 32, 63, 183, X, 397,
			  33, 0, X, 0,
			  0, 64, X, 64, X },
		.cu_7 = { 200, 303,
			  10, 0 },
		.cu_unsharp = { 10, 64, 110, X, 511,
				66, 12, X, 0,
				0, 56, X, 64, X },
		.cu_radial = { 6, 203, 255, 255, 255, 255, X,
			      84, 444, 397, 288, 300, X,
			       4, 69, 207, X, 369, 448, X },
		.cu_vssnlm = { 61, 100, 25, 0}
	},
	.config = { 45, X, 0, X, 16, X, 45, X },
	.control = { 1, 1, 1, 1, 1, X },
	.sharp = { { 50, X, 511, X, 50, X, 50, X },
		   { 64, X, 0, X, 0, X},
		   { 56, X, 56, X } },
	.unsharp = { { 36, 17, 8, X },
		     { 13, 7, 3, X } },
	.rad = { { -2104, X, -1559, X },
		 { 4426816, X },
		 { 2430481, X },
		 { 6, X, 79, X },
		 { 64, 0, 0, X },
		 { 1, X, 2, X, 0, X, 0, X },
		 { 40, X, 62, X } },
	.vsslnm = { { 16, 32, 64, X },
		    { 1, X, 2, X,  8, X } },
};

const struct ipu3_uapi_yuvp1_yds_config imgu_css_yds_defaults = {
	0, 1, 1, 0, 0, 1, 1, 0, 2, X, 0, X
};

const struct ipu3_uapi_yuvp1_chnr_config imgu_css_chnr_defaults = {
	.coring = { 0, X, 0, X },
	.sense_gain = { 6, 6, 6, X, 4, 4, 4, X },
	.iir_fir = { 8, X, 12, X, 0, 256 - 127, X },
};

const struct ipu3_uapi_yuvp1_y_ee_nr_config imgu_css_y_ee_nr_defaults = {
	.lpf = { 4, X, 8, X, 16, X,  0 },
	.sense = { 8191, X, 0, X, 8191, X, 0, X },
	.gain = { 8, X, 0, X, 8, X, 0, X },
	.clip = { 8, X, 0, X, 8, X, 0, X },
	.frng = { 2, X, 200, X, 2, X, 1, 1, X },
	.diag = { 1, X, 4, 1, 1, 4, X },
	.fc_coring = { 0, X, 0, X, 0, X, 0, X }
};

const struct ipu3_uapi_yuvp2_tcc_gain_pcwl_lut_static_config
					imgu_css_tcc_gain_pcwl_lut = { {
	1024, 1032, 1040, 1048, 1057, 1065, 1073, 1081, 1089, 1097, 1105, 1113,
	1122, 1130, 1138, 1146, 1154, 1162, 1170, 1178, 1187, 1195, 1203, 1211,
	1219, 1227, 1235, 1243, 1252, 1260, 1268, 1276, 1284, 1292, 1300, 1308,
	1317, 1325, 1333, 1341, 1349, 1357, 1365, 1373, 1382, 1390, 1398, 1406,
	1414, 1422, 1430, 1438, 1447, 1455, 1463, 1471, 1479, 1487, 1495, 1503,
	1512, 1520, 1528, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
	1536, 1536, 1528, 1520, 1512, 1503, 1495, 1487, 1479, 1471, 1463, 1455,
	1447, 1438, 1430, 1422, 1414, 1406, 1398, 1390, 1382, 1373, 1365, 1357,
	1349, 1341, 1333, 1325, 1317, 1308, 1300, 1292, 1284, 1276, 1268, 1260,
	1252, 1243, 1235, 1227, 1219, 1211, 1203, 1195, 1187, 1178, 1170, 1162,
	1154, 1146, 1138, 1130, 1122, 1113, 1105, 1097, 1089, 1081, 1073, 1065,
	1057, 1048, 1040, 1032, 1024
} };

const struct ipu3_uapi_yuvp2_tcc_r_sqr_lut_static_config
					imgu_css_tcc_r_sqr_lut = { {
	32, 44, 64, 92, 128, 180, 256, 364, 512, 628, 724, 808, 888,
	956, 1024, 1088, 1144, 1200, 1256, 1304, 1356, 1404, 1448
} };

const struct imgu_abi_anr_config imgu_css_anr_defaults = {
	.transform = {
		.adaptive_treshhold_en = 1,
		.alpha = { { 13, 13, 13, 13, 0, 0, 0, 0},
			   { 11, 11, 11, 11, 0, 0, 0, 0},
			   { 14,  14, 14, 14, 0, 0, 0, 0} },
		.beta = { { 24, 24, 24, 24},
			  { 21, 20, 20, 21},
			  { 25, 25, 25, 25} },
		.color = { { { 166, 173, 149, 166, 161, 146, 145, 173,
			       145, 150, 141, 149, 145, 141, 142 },
			     { 166, 173, 149, 165, 161, 145, 145, 173,
			       145, 150, 141, 149, 145, 141, 142 },
			     { 166, 174, 149, 166, 162, 146, 146, 173,
			       145, 150, 141, 149, 145, 141, 142 },
			     { 166, 173, 149, 165, 161, 145, 145, 173,
			       146, 150, 141, 149, 145, 141, 142 } },
			   { { 141, 131, 140, 141, 144, 143, 144, 131,
			       143, 137, 140, 140, 144, 140, 141 },
			     { 141, 131, 140, 141, 143, 143, 144, 131,
			       143, 137, 140, 140, 144, 140, 141 },
			     { 141, 131, 141, 141, 144, 144, 144, 131,
			       143, 137, 140, 140, 144, 140, 141 },
			     { 140, 131, 140, 141, 143, 143, 144, 131,
			       143, 137, 140, 140, 144, 140, 141 } },
			   { { 184, 173, 188, 184, 182, 182, 181, 173,
			       182, 179, 182, 188, 181, 182, 180 },
			     { 184, 173, 188, 184, 183, 182, 181, 173,
			       182, 178, 182, 188, 181, 182, 180 },
			     { 184, 173, 188, 184, 182, 182, 181, 173,
			       182, 178, 182, 188, 181, 182, 181 },
			     { 184, 172, 188, 184, 182, 182, 181, 173,
			       182, 178, 182, 188, 182, 182, 180 } } },
		.sqrt_lut = { 724, 768, 810, 849, 887, 923, 958, 991, 1024,
			      1056, 1086, 1116, 1145, 1173, 1201, 1228, 1254,
			      1280, 1305, 1330, 1355, 1379, 1402, 1425, 1448 },
		.xreset = -1632,
		.yreset = -1224,
		.x_sqr_reset = 2663424,
		.r_normfactor = 14,
		.y_sqr_reset = 1498176,
		.gain_scale = 115
	},
	.stitch = {
		.anr_stitch_en = 1,
		.pyramid = { { 1, 3, 5 }, { 7, 7, 5 }, { 3, 1, 3 },
			     { 9, 15, 21 }, { 21, 15, 9 }, { 3, 5, 15 },
			     { 25, 35, 35 }, { 25, 15, 5 }, { 7, 21, 35 },
			     { 49, 49, 35 }, { 21, 7, 7 }, { 21, 35, 49 },
			     { 49, 35, 21 }, { 7, 5, 15 }, { 25, 35, 35 },
			     { 25, 15, 5 }, { 3, 9, 15 }, { 21, 21, 15 },
			     { 9, 3, 1 }, { 3, 5, 7 }, { 7, 5, 3}, { 1 }
		}
	}
};

/* frame settings for Auto White Balance */
const struct ipu3_uapi_awb_fr_config_s imgu_css_awb_fr_defaults = {
	.grid_cfg = {
		.width = 16,
		.height = 16,
		.block_width_log2 = 3,
		.block_height_log2 = 3,
		.x_start = 10,
		.y_start = 2 | IPU3_UAPI_GRID_Y_START_EN,
	},
	.bayer_coeff = { 0, 0, 0, 0, 0, 128 },
	.bayer_sign = 0,
	.bayer_nf = 7
};

/* settings for Auto Exposure */
const struct ipu3_uapi_ae_grid_config imgu_css_ae_grid_defaults = {
	.width = 16,
	.height = 16,
	.block_width_log2 = 3,
	.block_height_log2 = 3,
	.ae_en = 1,
	.x_start = 0,
	.y_start = 0,
};

/* settings for Auto Exposure color correction matrix */
const struct ipu3_uapi_ae_ccm imgu_css_ae_ccm_defaults = {
	256, 256, 256, 256,		/* gain_gr/r/b/gb */
	.mat = { 128, 0, 0, 0, 0, 128, 0, 0, 0, 0, 128, 0, 0, 0, 0, 128 },
};

/* settings for Auto Focus */
const struct ipu3_uapi_af_config_s imgu_css_af_defaults = {
	.filter_config = {
		{ 0, 0, 0, 0 }, { 0, 0, 0, 0 }, { 0, 0, 0, 128 }, 0,
		{ 0, 0, 0, 0 }, { 0, 0, 0, 0 }, { 0, 0, 0, 128 }, 0,
		.y_calc = { 8, 8, 8, 8 },
		.nf = { X, 7, X, 7 },
	},
	.grid_cfg = {
		.width = 16,
		.height = 16,
		.block_width_log2 = 3,
		.block_height_log2 = 3,
		.x_start = 10,
		.y_start = 2 | IPU3_UAPI_GRID_Y_START_EN,
	},
};

/* settings for Auto White Balance */
const struct ipu3_uapi_awb_config_s imgu_css_awb_defaults = {
	8191, 8191, 8191, 8191 |	/* rgbs_thr_gr/r/gb/b */
	IPU3_UAPI_AWB_RGBS_THR_B_EN | IPU3_UAPI_AWB_RGBS_THR_B_INCL_SAT,
	.grid = {
		.width = 16,
		.height = 16,
		.block_width_log2 = 3,
		.block_height_log2 = 3,
		.x_start = 0,
		.y_start = 0,
	},
};
