/*
 * Simple program to generate defines out of facility lists that use the bit
 * numbering scheme from the Princples of Operations: most significant bit
 * has bit number 0.
 *
 *    Copyright IBM Corp. 2015
 *
 */

#define S390_GEN_FACILITIES_C

#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <asm/facilities_src.h>

static void print_facility_list(struct facility_def *def)
{
	unsigned int high, bit, dword, i;
	unsigned long long *array;

	array = calloc(1, 8);
	if (!array)
		exit(EXIT_FAILURE);
	high = 0;
	for (i = 0; def->bits[i] != -1; i++) {
		bit = 63 - (def->bits[i] & 63);
		dword = def->bits[i] / 64;
		if (dword > high) {
			array = realloc(array, (dword + 1) * 8);
			if (!array)
				exit(EXIT_FAILURE);
			memset(array + high + 1, 0, (dword - high) * 8);
			high = dword;
		}
		array[dword] |= 1ULL << bit;
	}
	printf("#define %s ", def->name);
	for (i = 0; i <= high; i++)
		printf("_AC(0x%016llx,UL)%c", array[i], i < high ? ',' : '\n');
	printf("#define %s_DWORDS %d\n", def->name, high + 1);
	free(array);
}

static void print_facility_lists(void)
{
	unsigned int i;

	for (i = 0; i < sizeof(facility_defs) / sizeof(facility_defs[0]); i++)
		print_facility_list(&facility_defs[i]);
}

int main(int argc, char **argv)
{
	printf("#ifndef __ASM_S390_FACILITIES__\n");
	printf("#define __ASM_S390_FACILITIES__\n");
	printf("/*\n");
	printf(" * DO NOT MODIFY.\n");
	printf(" *\n");
	printf(" * This file was generated by %s\n", __FILE__);
	printf(" */\n\n");
	printf("#include <linux/const.h>\n\n");
	print_facility_lists();
	printf("\n#endif\n");
	return 0;
}
