/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2022 Intel Corporation
 */

#ifndef __INTEL_DVO_REGS_H__
#define __INTEL_DVO_REGS_H__

#include "intel_display_reg_defs.h"

#define _DVOA			0x61120
#define _DVOB			0x61140
#define _DVOC			0x61160
#define DVO(port)		_MMIO_PORT((port), _DVOA, _DVOB)
#define   DVO_ENABLE				REG_BIT(31)
#define   DVO_PIPE_SEL_MASK			REG_BIT(30)
#define   DVO_PIPE_SEL(pipe)			REG_FIELD_PREP(DVO_PIPE_SEL_MASK, (pipe))
#define   DVO_PIPE_STALL_MASK			REG_GENMASK(29, 28)
#define   DVO_PIPE_STALL_UNUSED			REG_FIELD_PREP(DVO_PIPE_STALL_MASK, 0)
#define   DVO_PIPE_STALL			REG_FIELD_PREP(DVO_PIPE_STALL_MASK, 1)
#define   DVO_PIPE_STALL_TV			REG_FIELD_PREP(DVO_PIPE_STALL_MASK, 2)
#define   DVO_INTERRUPT_SELECT			REG_BIT(27)
#define   DVO_DEDICATED_INT_ENABLE		REG_BIT(26)
#define   DVO_PRESERVE_MASK			REG_GENMASK(25, 24)
#define   DVO_USE_VGA_SYNC			REG_BIT(15)
#define   DVO_DATA_ORDER_MASK			REG_BIT(14)
#define   DVO_DATA_ORDER_I740			REG_FIELD_PREP(DVO_DATA_ORDER_MASK, 0)
#define   DVO_DATA_ORDER_FP			REG_FIELD_PREP(DVO_DATA_ORDER_MASK, 1)
#define   DVO_VSYNC_DISABLE			REG_BIT(11)
#define   DVO_HSYNC_DISABLE			REG_BIT(10)
#define   DVO_VSYNC_TRISTATE			REG_BIT(9)
#define   DVO_HSYNC_TRISTATE			REG_BIT(8)
#define   DVO_BORDER_ENABLE			REG_BIT(7)
#define   DVO_ACT_DATA_ORDER_MASK		REG_BIT(6)
#define   DVO_ACT_DATA_ORDER_RGGB		REG_FIELD_PREP(DVO_ACT_DATA_ORDER_MASK, 0)
#define   DVO_ACT_DATA_ORDER_GBRG		REG_FIELD_PREP(DVO_ACT_DATA_ORDER_MASK, 1)
#define   DVO_ACT_DATA_ORDER_GBRG_ERRATA	REG_FIELD_PREP(DVO_ACT_DATA_ORDER_MASK, 0)
#define   DVO_ACT_DATA_ORDER_RGGB_ERRATA	REG_FIELD_PREP(DVO_ACT_DATA_ORDER_MASK, 1)
#define   DVO_VSYNC_ACTIVE_HIGH			REG_BIT(4)
#define   DVO_HSYNC_ACTIVE_HIGH			REG_BIT(3)
#define   DVO_BLANK_ACTIVE_HIGH			REG_BIT(2)
#define   DVO_OUTPUT_CSTATE_PIXELS		REG_BIT(1) /* SDG only */
#define   DVO_OUTPUT_SOURCE_SIZE_PIXELS		REG_BIT(0) /* SDG only */

#define _DVOA_SRCDIM		0x61124
#define _DVOB_SRCDIM		0x61144
#define _DVOC_SRCDIM		0x61164
#define DVO_SRCDIM(port)	_MMIO_PORT((port), _DVOA_SRCDIM, _DVOB_SRCDIM)
#define   DVO_SRCDIM_HORIZONTAL_MASK		REG_GENMASK(22, 12)
#define   DVO_SRCDIM_HORIZONTAL(x)		REG_FIELD_PREP(DVO_SRCDIM_HORIZONTAL_MASK, (x))
#define   DVO_SRCDIM_VERTICAL_MASK		REG_GENMASK(10, 0)
#define   DVO_SRCDIM_VERTICAL(x)		REG_FIELD_PREP(DVO_SRCDIM_VERTICAL_MASK, (x))

#endif /* __INTEL_DVO_REGS_H__ */
