/*
 * Copyright 2010 Red Hat Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors: Ben Skeggs
 */

#include "drmP.h"
#include "nouveau_drv.h"
#include "nouveau_mm.h"
#include "nvc0_graph.h"

static void
nv_icmd(struct drm_device *dev, u32 icmd, u32 data)
{
	nv_wr32(dev, 0x400204, data);
	nv_wr32(dev, 0x400200, icmd);
	while (nv_rd32(dev, 0x400700) & 2) {}
}

static void
nv_mthd(struct drm_device *dev, u32 class, u32 mthd, u32 data)
{
	nv_wr32(dev, 0x40448c, data);
	nv_wr32(dev, 0x404488, 0x80000000 | (mthd << 14) | class);
}

static void
nvc0_grctx_generate_9097(struct drm_device *dev)
{
	u32 fermi = nvc0_graph_class(dev);
	u32 mthd;

	nv_mthd(dev, 0x9097, 0x0800, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0840, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0880, 0x00000000);
	nv_mthd(dev, 0x9097, 0x08c0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0900, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0940, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0980, 0x00000000);
	nv_mthd(dev, 0x9097, 0x09c0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0804, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0844, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0884, 0x00000000);
	nv_mthd(dev, 0x9097, 0x08c4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0904, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0944, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0984, 0x00000000);
	nv_mthd(dev, 0x9097, 0x09c4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0808, 0x00000400);
	nv_mthd(dev, 0x9097, 0x0848, 0x00000400);
	nv_mthd(dev, 0x9097, 0x0888, 0x00000400);
	nv_mthd(dev, 0x9097, 0x08c8, 0x00000400);
	nv_mthd(dev, 0x9097, 0x0908, 0x00000400);
	nv_mthd(dev, 0x9097, 0x0948, 0x00000400);
	nv_mthd(dev, 0x9097, 0x0988, 0x00000400);
	nv_mthd(dev, 0x9097, 0x09c8, 0x00000400);
	nv_mthd(dev, 0x9097, 0x080c, 0x00000300);
	nv_mthd(dev, 0x9097, 0x084c, 0x00000300);
	nv_mthd(dev, 0x9097, 0x088c, 0x00000300);
	nv_mthd(dev, 0x9097, 0x08cc, 0x00000300);
	nv_mthd(dev, 0x9097, 0x090c, 0x00000300);
	nv_mthd(dev, 0x9097, 0x094c, 0x00000300);
	nv_mthd(dev, 0x9097, 0x098c, 0x00000300);
	nv_mthd(dev, 0x9097, 0x09cc, 0x00000300);
	nv_mthd(dev, 0x9097, 0x0810, 0x000000cf);
	nv_mthd(dev, 0x9097, 0x0850, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0890, 0x00000000);
	nv_mthd(dev, 0x9097, 0x08d0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0910, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0950, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0990, 0x00000000);
	nv_mthd(dev, 0x9097, 0x09d0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0814, 0x00000040);
	nv_mthd(dev, 0x9097, 0x0854, 0x00000040);
	nv_mthd(dev, 0x9097, 0x0894, 0x00000040);
	nv_mthd(dev, 0x9097, 0x08d4, 0x00000040);
	nv_mthd(dev, 0x9097, 0x0914, 0x00000040);
	nv_mthd(dev, 0x9097, 0x0954, 0x00000040);
	nv_mthd(dev, 0x9097, 0x0994, 0x00000040);
	nv_mthd(dev, 0x9097, 0x09d4, 0x00000040);
	nv_mthd(dev, 0x9097, 0x0818, 0x00000001);
	nv_mthd(dev, 0x9097, 0x0858, 0x00000001);
	nv_mthd(dev, 0x9097, 0x0898, 0x00000001);
	nv_mthd(dev, 0x9097, 0x08d8, 0x00000001);
	nv_mthd(dev, 0x9097, 0x0918, 0x00000001);
	nv_mthd(dev, 0x9097, 0x0958, 0x00000001);
	nv_mthd(dev, 0x9097, 0x0998, 0x00000001);
	nv_mthd(dev, 0x9097, 0x09d8, 0x00000001);
	nv_mthd(dev, 0x9097, 0x081c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x085c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x089c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x08dc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x091c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x095c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x099c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x09dc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0820, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0860, 0x00000000);
	nv_mthd(dev, 0x9097, 0x08a0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x08e0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0920, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0960, 0x00000000);
	nv_mthd(dev, 0x9097, 0x09a0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x09e0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2700, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2720, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2740, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2760, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2780, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27a0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27c0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27e0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2704, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2724, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2744, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2764, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2784, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27a4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27c4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27e4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2708, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2728, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2748, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2768, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2788, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27a8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27c8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27e8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x270c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x272c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x274c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x276c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x278c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27ac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27cc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x27ec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2710, 0x00014000);
	nv_mthd(dev, 0x9097, 0x2730, 0x00014000);
	nv_mthd(dev, 0x9097, 0x2750, 0x00014000);
	nv_mthd(dev, 0x9097, 0x2770, 0x00014000);
	nv_mthd(dev, 0x9097, 0x2790, 0x00014000);
	nv_mthd(dev, 0x9097, 0x27b0, 0x00014000);
	nv_mthd(dev, 0x9097, 0x27d0, 0x00014000);
	nv_mthd(dev, 0x9097, 0x27f0, 0x00014000);
	nv_mthd(dev, 0x9097, 0x2714, 0x00000040);
	nv_mthd(dev, 0x9097, 0x2734, 0x00000040);
	nv_mthd(dev, 0x9097, 0x2754, 0x00000040);
	nv_mthd(dev, 0x9097, 0x2774, 0x00000040);
	nv_mthd(dev, 0x9097, 0x2794, 0x00000040);
	nv_mthd(dev, 0x9097, 0x27b4, 0x00000040);
	nv_mthd(dev, 0x9097, 0x27d4, 0x00000040);
	nv_mthd(dev, 0x9097, 0x27f4, 0x00000040);
	nv_mthd(dev, 0x9097, 0x1c00, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c10, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c20, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c30, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c40, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c50, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c60, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c70, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c80, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c90, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ca0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cb0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cc0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cd0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ce0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cf0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c04, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c14, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c24, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c34, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c44, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c54, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c64, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c74, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c84, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c94, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ca4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cb4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cc4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cd4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ce4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cf4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c08, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c18, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c28, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c38, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c48, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c58, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c68, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c78, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c88, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c98, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ca8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cb8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cc8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cd8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ce8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cf8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c0c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c1c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c2c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c3c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c4c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c5c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c6c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c7c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c8c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1c9c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cbc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ccc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cdc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1cfc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d00, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d10, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d20, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d30, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d40, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d50, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d60, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d70, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d80, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d90, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1da0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1db0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dc0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dd0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1de0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1df0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d04, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d14, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d24, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d34, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d44, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d54, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d64, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d74, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d84, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d94, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1da4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1db4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dc4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dd4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1de4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1df4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d08, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d18, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d28, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d38, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d48, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d58, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d68, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d78, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d88, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d98, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1da8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1db8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dc8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dd8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1de8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1df8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d0c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d1c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d2c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d3c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d4c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d5c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d6c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d7c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d8c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1d9c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dbc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dcc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ddc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1dfc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f00, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f08, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f10, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f18, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f20, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f28, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f30, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f38, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f40, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f48, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f50, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f58, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f60, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f68, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f70, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f78, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f04, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f0c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f14, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f1c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f24, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f2c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f34, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f3c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f44, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f4c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f54, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f5c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f64, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f6c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f74, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f7c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f80, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f88, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f90, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f98, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fa0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fa8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fb0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fb8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fc0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fc8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fd0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fd8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fe0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fe8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ff0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ff8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f84, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f8c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f94, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1f9c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fa4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fb4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fbc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fc4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fcc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fd4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fdc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fe4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1fec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ff4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1ffc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2200, 0x00000022);
	nv_mthd(dev, 0x9097, 0x2210, 0x00000022);
	nv_mthd(dev, 0x9097, 0x2220, 0x00000022);
	nv_mthd(dev, 0x9097, 0x2230, 0x00000022);
	nv_mthd(dev, 0x9097, 0x2240, 0x00000022);
	nv_mthd(dev, 0x9097, 0x2000, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2040, 0x00000011);
	nv_mthd(dev, 0x9097, 0x2080, 0x00000020);
	nv_mthd(dev, 0x9097, 0x20c0, 0x00000030);
	nv_mthd(dev, 0x9097, 0x2100, 0x00000040);
	nv_mthd(dev, 0x9097, 0x2140, 0x00000051);
	nv_mthd(dev, 0x9097, 0x200c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x204c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x208c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x20cc, 0x00000001);
	nv_mthd(dev, 0x9097, 0x210c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x214c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x2010, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2050, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2090, 0x00000001);
	nv_mthd(dev, 0x9097, 0x20d0, 0x00000002);
	nv_mthd(dev, 0x9097, 0x2110, 0x00000003);
	nv_mthd(dev, 0x9097, 0x2150, 0x00000004);
	nv_mthd(dev, 0x9097, 0x0380, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03a0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03c0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03e0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0384, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03a4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03c4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03e4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0388, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03a8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03c8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03e8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x038c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03ac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03cc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x03ec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0700, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0710, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0720, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0730, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0704, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0714, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0724, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0734, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0708, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0718, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0728, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0738, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2800, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2804, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2808, 0x00000000);
	nv_mthd(dev, 0x9097, 0x280c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2810, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2814, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2818, 0x00000000);
	nv_mthd(dev, 0x9097, 0x281c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2820, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2824, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2828, 0x00000000);
	nv_mthd(dev, 0x9097, 0x282c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2830, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2834, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2838, 0x00000000);
	nv_mthd(dev, 0x9097, 0x283c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2840, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2844, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2848, 0x00000000);
	nv_mthd(dev, 0x9097, 0x284c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2850, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2854, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2858, 0x00000000);
	nv_mthd(dev, 0x9097, 0x285c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2860, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2864, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2868, 0x00000000);
	nv_mthd(dev, 0x9097, 0x286c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2870, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2874, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2878, 0x00000000);
	nv_mthd(dev, 0x9097, 0x287c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2880, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2884, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2888, 0x00000000);
	nv_mthd(dev, 0x9097, 0x288c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2890, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2894, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2898, 0x00000000);
	nv_mthd(dev, 0x9097, 0x289c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28a0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28a4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28a8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28ac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28b0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28b4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28b8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28bc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28c0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28c4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28c8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28cc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28d0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28d4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28d8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28dc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28e0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28e4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28e8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28ec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28f0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28f4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28f8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x28fc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2900, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2904, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2908, 0x00000000);
	nv_mthd(dev, 0x9097, 0x290c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2910, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2914, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2918, 0x00000000);
	nv_mthd(dev, 0x9097, 0x291c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2920, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2924, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2928, 0x00000000);
	nv_mthd(dev, 0x9097, 0x292c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2930, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2934, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2938, 0x00000000);
	nv_mthd(dev, 0x9097, 0x293c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2940, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2944, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2948, 0x00000000);
	nv_mthd(dev, 0x9097, 0x294c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2950, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2954, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2958, 0x00000000);
	nv_mthd(dev, 0x9097, 0x295c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2960, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2964, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2968, 0x00000000);
	nv_mthd(dev, 0x9097, 0x296c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2970, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2974, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2978, 0x00000000);
	nv_mthd(dev, 0x9097, 0x297c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2980, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2984, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2988, 0x00000000);
	nv_mthd(dev, 0x9097, 0x298c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2990, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2994, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2998, 0x00000000);
	nv_mthd(dev, 0x9097, 0x299c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29a0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29a4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29a8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29ac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29b0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29b4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29b8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29bc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29c0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29c4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29c8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29cc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29d0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29d4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29d8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29dc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29e0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29e4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29e8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29ec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29f0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29f4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29f8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x29fc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a00, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a20, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a40, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a60, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a80, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0aa0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ac0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ae0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b00, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b20, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b40, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b60, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b80, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ba0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bc0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0be0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a04, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a24, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a44, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a64, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a84, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0aa4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ac4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ae4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b04, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b24, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b44, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b64, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b84, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ba4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bc4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0be4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a08, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a28, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a48, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a68, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a88, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0aa8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ac8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ae8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b08, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b28, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b48, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b68, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b88, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ba8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bc8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0be8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a0c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a2c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a4c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a6c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a8c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0aac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0acc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0aec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b0c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b2c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b4c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b6c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b8c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bcc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a10, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a30, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a50, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a70, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a90, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ab0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ad0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0af0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b10, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b30, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b50, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b70, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b90, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bb0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bd0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bf0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a14, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a34, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a54, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a74, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0a94, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ab4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ad4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0af4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b14, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b34, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b54, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b74, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0b94, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bb4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bd4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0bf4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c00, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c10, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c20, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c30, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c40, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c50, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c60, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c70, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c80, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c90, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ca0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cb0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cc0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cd0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ce0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cf0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c04, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c14, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c24, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c34, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c44, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c54, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c64, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c74, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c84, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c94, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ca4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cb4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cc4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cd4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ce4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cf4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c08, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c18, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c28, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c38, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c48, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c58, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c68, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c78, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c88, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c98, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ca8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cb8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cc8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cd8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ce8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0cf8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0c0c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0c1c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0c2c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0c3c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0c4c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0c5c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0c6c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0c7c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0c8c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0c9c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0cac, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0cbc, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0ccc, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0cdc, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0cec, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0cfc, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0d00, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d08, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d10, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d18, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d20, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d28, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d30, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d38, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d04, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d0c, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d14, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d1c, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d24, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d2c, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d34, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d3c, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e00, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e10, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e20, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e30, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e40, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e50, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e60, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e70, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e80, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e90, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ea0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0eb0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ec0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ed0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ee0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ef0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0e04, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e14, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e24, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e34, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e44, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e54, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e64, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e74, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e84, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e94, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ea4, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0eb4, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ec4, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ed4, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ee4, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ef4, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e08, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e18, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e28, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e38, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e48, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e58, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e68, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e78, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e88, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0e98, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ea8, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0eb8, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ec8, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ed8, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ee8, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0ef8, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d40, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d48, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d50, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d58, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d44, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d4c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d54, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d5c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1e00, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e20, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e40, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e60, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e80, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ea0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ec0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ee0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e04, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e24, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e44, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e64, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e84, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ea4, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ec4, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ee4, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e08, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e28, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e48, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e68, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e88, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1ea8, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1ec8, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1ee8, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e0c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e2c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e4c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e6c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e8c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1eac, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ecc, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1eec, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e10, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e30, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e50, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e70, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e90, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1eb0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ed0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ef0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e14, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e34, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e54, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e74, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e94, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1eb4, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1ed4, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1ef4, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1e18, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e38, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e58, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e78, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1e98, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1eb8, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ed8, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1ef8, 0x00000001);
	if (fermi == 0x9097) {
		for (mthd = 0x3400; mthd <= 0x35fc; mthd += 4)
			nv_mthd(dev, 0x9097, mthd, 0x00000000);
	}
	nv_mthd(dev, 0x9097, 0x030c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1944, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1514, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d68, 0x0000ffff);
	nv_mthd(dev, 0x9097, 0x121c, 0x0fac6881);
	nv_mthd(dev, 0x9097, 0x0fac, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1538, 0x00000001);
	nv_mthd(dev, 0x9097, 0x0fe0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0fe4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0fe8, 0x00000014);
	nv_mthd(dev, 0x9097, 0x0fec, 0x00000040);
	nv_mthd(dev, 0x9097, 0x0ff0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x179c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1228, 0x00000400);
	nv_mthd(dev, 0x9097, 0x122c, 0x00000300);
	nv_mthd(dev, 0x9097, 0x1230, 0x00010001);
	nv_mthd(dev, 0x9097, 0x07f8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x15b4, 0x00000001);
	nv_mthd(dev, 0x9097, 0x15cc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1534, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0fb0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x15d0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x153c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x16b4, 0x00000003);
	nv_mthd(dev, 0x9097, 0x0fbc, 0x0000ffff);
	nv_mthd(dev, 0x9097, 0x0fc0, 0x0000ffff);
	nv_mthd(dev, 0x9097, 0x0fc4, 0x0000ffff);
	nv_mthd(dev, 0x9097, 0x0fc8, 0x0000ffff);
	nv_mthd(dev, 0x9097, 0x0df8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0dfc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1948, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1970, 0x00000001);
	nv_mthd(dev, 0x9097, 0x161c, 0x000009f0);
	nv_mthd(dev, 0x9097, 0x0dcc, 0x00000010);
	nv_mthd(dev, 0x9097, 0x163c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x15e4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1160, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1164, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1168, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x116c, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1170, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1174, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1178, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x117c, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1180, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1184, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1188, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x118c, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1190, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1194, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1198, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x119c, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11a0, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11a4, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11a8, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11ac, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11b0, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11b4, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11b8, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11bc, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11c0, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11c4, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11c8, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11cc, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11d0, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11d4, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11d8, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x11dc, 0x25e00040);
	nv_mthd(dev, 0x9097, 0x1880, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1884, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1888, 0x00000000);
	nv_mthd(dev, 0x9097, 0x188c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1890, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1894, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1898, 0x00000000);
	nv_mthd(dev, 0x9097, 0x189c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18a0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18a4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18a8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18ac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18b0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18b4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18b8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18bc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18c0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18c4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18c8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18cc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18d0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18d4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18d8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18dc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18e0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18e4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18e8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18ec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18f0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18f4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18f8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x18fc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0f84, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0f88, 0x00000000);
	nv_mthd(dev, 0x9097, 0x17c8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x17cc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x17d0, 0x000000ff);
	nv_mthd(dev, 0x9097, 0x17d4, 0xffffffff);
	nv_mthd(dev, 0x9097, 0x17d8, 0x00000002);
	nv_mthd(dev, 0x9097, 0x17dc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x15f4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x15f8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1434, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1438, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d74, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0dec, 0x00000001);
	nv_mthd(dev, 0x9097, 0x13a4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1318, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1644, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0748, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0de8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1648, 0x00000000);
	nv_mthd(dev, 0x9097, 0x12a4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1120, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1124, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1128, 0x00000000);
	nv_mthd(dev, 0x9097, 0x112c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1118, 0x00000000);
	nv_mthd(dev, 0x9097, 0x164c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1658, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1910, 0x00000290);
	nv_mthd(dev, 0x9097, 0x1518, 0x00000000);
	nv_mthd(dev, 0x9097, 0x165c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1520, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1604, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1570, 0x00000000);
	nv_mthd(dev, 0x9097, 0x13b0, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x13b4, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x020c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1670, 0x30201000);
	nv_mthd(dev, 0x9097, 0x1674, 0x70605040);
	nv_mthd(dev, 0x9097, 0x1678, 0xb8a89888);
	nv_mthd(dev, 0x9097, 0x167c, 0xf8e8d8c8);
	nv_mthd(dev, 0x9097, 0x166c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1680, 0x00ffff00);
	nv_mthd(dev, 0x9097, 0x12d0, 0x00000003);
	nv_mthd(dev, 0x9097, 0x12d4, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1684, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1688, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0dac, 0x00001b02);
	nv_mthd(dev, 0x9097, 0x0db0, 0x00001b02);
	nv_mthd(dev, 0x9097, 0x0db4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x168c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x15bc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x156c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x187c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1110, 0x00000001);
	nv_mthd(dev, 0x9097, 0x0dc0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0dc4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0dc8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1234, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1690, 0x00000000);
	nv_mthd(dev, 0x9097, 0x12ac, 0x00000001);
	nv_mthd(dev, 0x9097, 0x02c4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0790, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0794, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0798, 0x00000000);
	nv_mthd(dev, 0x9097, 0x079c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x07a0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x077c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1000, 0x00000010);
	nv_mthd(dev, 0x9097, 0x10fc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1290, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0218, 0x00000010);
	nv_mthd(dev, 0x9097, 0x12d8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x12dc, 0x00000010);
	nv_mthd(dev, 0x9097, 0x0d94, 0x00000001);
	nv_mthd(dev, 0x9097, 0x155c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1560, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1564, 0x00001fff);
	nv_mthd(dev, 0x9097, 0x1574, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1578, 0x00000000);
	nv_mthd(dev, 0x9097, 0x157c, 0x003fffff);
	nv_mthd(dev, 0x9097, 0x1354, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1664, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1610, 0x00000012);
	nv_mthd(dev, 0x9097, 0x1608, 0x00000000);
	nv_mthd(dev, 0x9097, 0x160c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x162c, 0x00000003);
	nv_mthd(dev, 0x9097, 0x0210, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0320, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0324, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0328, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x032c, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0330, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0334, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0338, 0x3f800000);
	nv_mthd(dev, 0x9097, 0x0750, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0760, 0x39291909);
	nv_mthd(dev, 0x9097, 0x0764, 0x79695949);
	nv_mthd(dev, 0x9097, 0x0768, 0xb9a99989);
	nv_mthd(dev, 0x9097, 0x076c, 0xf9e9d9c9);
	nv_mthd(dev, 0x9097, 0x0770, 0x30201000);
	nv_mthd(dev, 0x9097, 0x0774, 0x70605040);
	nv_mthd(dev, 0x9097, 0x0778, 0x00009080);
	nv_mthd(dev, 0x9097, 0x0780, 0x39291909);
	nv_mthd(dev, 0x9097, 0x0784, 0x79695949);
	nv_mthd(dev, 0x9097, 0x0788, 0xb9a99989);
	nv_mthd(dev, 0x9097, 0x078c, 0xf9e9d9c9);
	nv_mthd(dev, 0x9097, 0x07d0, 0x30201000);
	nv_mthd(dev, 0x9097, 0x07d4, 0x70605040);
	nv_mthd(dev, 0x9097, 0x07d8, 0x00009080);
	nv_mthd(dev, 0x9097, 0x037c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x0740, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0744, 0x00000000);
	nv_mthd(dev, 0x9097, 0x2600, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1918, 0x00000000);
	nv_mthd(dev, 0x9097, 0x191c, 0x00000900);
	nv_mthd(dev, 0x9097, 0x1920, 0x00000405);
	nv_mthd(dev, 0x9097, 0x1308, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1924, 0x00000000);
	nv_mthd(dev, 0x9097, 0x13ac, 0x00000000);
	nv_mthd(dev, 0x9097, 0x192c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x193c, 0x00002c1c);
	nv_mthd(dev, 0x9097, 0x0d7c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0f8c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x02c0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1510, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1940, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ff4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0ff8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x194c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1950, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1968, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1590, 0x0000003f);
	nv_mthd(dev, 0x9097, 0x07e8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x07ec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x07f0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x07f4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x196c, 0x00000011);
	nv_mthd(dev, 0x9097, 0x197c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0fcc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0fd0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x02d8, 0x00000040);
	nv_mthd(dev, 0x9097, 0x1980, 0x00000080);
	nv_mthd(dev, 0x9097, 0x1504, 0x00000080);
	nv_mthd(dev, 0x9097, 0x1984, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0300, 0x00000001);
	nv_mthd(dev, 0x9097, 0x13a8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x12ec, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1310, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1314, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1380, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1384, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1388, 0x00000001);
	nv_mthd(dev, 0x9097, 0x138c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1390, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1394, 0x00000000);
	nv_mthd(dev, 0x9097, 0x139c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1398, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1594, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1598, 0x00000001);
	nv_mthd(dev, 0x9097, 0x159c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x15a0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x15a4, 0x00000001);
	nv_mthd(dev, 0x9097, 0x0f54, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0f58, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0f5c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x19bc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0f9c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0fa0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x12cc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x12e8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x130c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1360, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1364, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1368, 0x00000000);
	nv_mthd(dev, 0x9097, 0x136c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1370, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1374, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1378, 0x00000000);
	nv_mthd(dev, 0x9097, 0x137c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x133c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1340, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1344, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1348, 0x00000001);
	nv_mthd(dev, 0x9097, 0x134c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1350, 0x00000002);
	nv_mthd(dev, 0x9097, 0x1358, 0x00000001);
	nv_mthd(dev, 0x9097, 0x12e4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x131c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1320, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1324, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1328, 0x00000000);
	nv_mthd(dev, 0x9097, 0x19c0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1140, 0x00000000);
	nv_mthd(dev, 0x9097, 0x19c4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x19c8, 0x00001500);
	nv_mthd(dev, 0x9097, 0x135c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0f90, 0x00000000);
	nv_mthd(dev, 0x9097, 0x19e0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x19e4, 0x00000001);
	nv_mthd(dev, 0x9097, 0x19e8, 0x00000001);
	nv_mthd(dev, 0x9097, 0x19ec, 0x00000001);
	nv_mthd(dev, 0x9097, 0x19f0, 0x00000001);
	nv_mthd(dev, 0x9097, 0x19f4, 0x00000001);
	nv_mthd(dev, 0x9097, 0x19f8, 0x00000001);
	nv_mthd(dev, 0x9097, 0x19fc, 0x00000001);
	nv_mthd(dev, 0x9097, 0x19cc, 0x00000001);
	nv_mthd(dev, 0x9097, 0x15b8, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1a00, 0x00001111);
	nv_mthd(dev, 0x9097, 0x1a04, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1a08, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1a0c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1a10, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1a14, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1a18, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1a1c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d6c, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x0d70, 0xffff0000);
	nv_mthd(dev, 0x9097, 0x10f8, 0x00001010);
	nv_mthd(dev, 0x9097, 0x0d80, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d84, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d88, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d8c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0d90, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0da0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1508, 0x80000000);
	nv_mthd(dev, 0x9097, 0x150c, 0x40000000);
	nv_mthd(dev, 0x9097, 0x1668, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0318, 0x00000008);
	nv_mthd(dev, 0x9097, 0x031c, 0x00000008);
	nv_mthd(dev, 0x9097, 0x0d9c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x07dc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x074c, 0x00000055);
	nv_mthd(dev, 0x9097, 0x1420, 0x00000003);
	nv_mthd(dev, 0x9097, 0x17bc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x17c0, 0x00000000);
	nv_mthd(dev, 0x9097, 0x17c4, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1008, 0x00000008);
	nv_mthd(dev, 0x9097, 0x100c, 0x00000040);
	nv_mthd(dev, 0x9097, 0x1010, 0x0000012c);
	nv_mthd(dev, 0x9097, 0x0d60, 0x00000040);
	nv_mthd(dev, 0x9097, 0x075c, 0x00000003);
	nv_mthd(dev, 0x9097, 0x1018, 0x00000020);
	nv_mthd(dev, 0x9097, 0x101c, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1020, 0x00000020);
	nv_mthd(dev, 0x9097, 0x1024, 0x00000001);
	nv_mthd(dev, 0x9097, 0x1444, 0x00000000);
	nv_mthd(dev, 0x9097, 0x1448, 0x00000000);
	nv_mthd(dev, 0x9097, 0x144c, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0360, 0x20164010);
	nv_mthd(dev, 0x9097, 0x0364, 0x00000020);
	nv_mthd(dev, 0x9097, 0x0368, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0de4, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0204, 0x00000006);
	nv_mthd(dev, 0x9097, 0x0208, 0x00000000);
	nv_mthd(dev, 0x9097, 0x02cc, 0x003fffff);
	nv_mthd(dev, 0x9097, 0x02d0, 0x00000c48);
	nv_mthd(dev, 0x9097, 0x1220, 0x00000005);
	nv_mthd(dev, 0x9097, 0x0fdc, 0x00000000);
	nv_mthd(dev, 0x9097, 0x0f98, 0x00300008);
	nv_mthd(dev, 0x9097, 0x1284, 0x04000080);
	nv_mthd(dev, 0x9097, 0x1450, 0x00300008);
	nv_mthd(dev, 0x9097, 0x1454, 0x04000080);
	nv_mthd(dev, 0x9097, 0x0214, 0x00000000);
	/* in trace, right after 0x90c0, not here */
	nv_mthd(dev, 0x9097, 0x3410, 0x80002006);
}

static void
nvc0_grctx_generate_9197(struct drm_device *dev)
{
	u32 fermi = nvc0_graph_class(dev);
	u32 mthd;

	if (fermi == 0x9197) {
		for (mthd = 0x3400; mthd <= 0x35fc; mthd += 4)
			nv_mthd(dev, 0x9197, mthd, 0x00000000);
	}
	nv_mthd(dev, 0x9197, 0x02e4, 0x0000b001);
}

static void
nvc0_grctx_generate_9297(struct drm_device *dev)
{
	u32 fermi = nvc0_graph_class(dev);
	u32 mthd;

	if (fermi == 0x9297) {
		for (mthd = 0x3400; mthd <= 0x35fc; mthd += 4)
			nv_mthd(dev, 0x9297, mthd, 0x00000000);
	}
	nv_mthd(dev, 0x9297, 0x036c, 0x00000000);
	nv_mthd(dev, 0x9297, 0x0370, 0x00000000);
	nv_mthd(dev, 0x9297, 0x07a4, 0x00000000);
	nv_mthd(dev, 0x9297, 0x07a8, 0x00000000);
	nv_mthd(dev, 0x9297, 0x0374, 0x00000000);
	nv_mthd(dev, 0x9297, 0x0378, 0x00000020);
}

static void
nvc0_grctx_generate_902d(struct drm_device *dev)
{
	nv_mthd(dev, 0x902d, 0x0200, 0x000000cf);
	nv_mthd(dev, 0x902d, 0x0204, 0x00000001);
	nv_mthd(dev, 0x902d, 0x0208, 0x00000020);
	nv_mthd(dev, 0x902d, 0x020c, 0x00000001);
	nv_mthd(dev, 0x902d, 0x0210, 0x00000000);
	nv_mthd(dev, 0x902d, 0x0214, 0x00000080);
	nv_mthd(dev, 0x902d, 0x0218, 0x00000100);
	nv_mthd(dev, 0x902d, 0x021c, 0x00000100);
	nv_mthd(dev, 0x902d, 0x0220, 0x00000000);
	nv_mthd(dev, 0x902d, 0x0224, 0x00000000);
	nv_mthd(dev, 0x902d, 0x0230, 0x000000cf);
	nv_mthd(dev, 0x902d, 0x0234, 0x00000001);
	nv_mthd(dev, 0x902d, 0x0238, 0x00000020);
	nv_mthd(dev, 0x902d, 0x023c, 0x00000001);
	nv_mthd(dev, 0x902d, 0x0244, 0x00000080);
	nv_mthd(dev, 0x902d, 0x0248, 0x00000100);
	nv_mthd(dev, 0x902d, 0x024c, 0x00000100);
}

static void
nvc0_grctx_generate_9039(struct drm_device *dev)
{
	nv_mthd(dev, 0x9039, 0x030c, 0x00000000);
	nv_mthd(dev, 0x9039, 0x0310, 0x00000000);
	nv_mthd(dev, 0x9039, 0x0314, 0x00000000);
	nv_mthd(dev, 0x9039, 0x0320, 0x00000000);
	nv_mthd(dev, 0x9039, 0x0238, 0x00000000);
	nv_mthd(dev, 0x9039, 0x023c, 0x00000000);
	nv_mthd(dev, 0x9039, 0x0318, 0x00000000);
	nv_mthd(dev, 0x9039, 0x031c, 0x00000000);
}

static void
nvc0_grctx_generate_90c0(struct drm_device *dev)
{
	nv_mthd(dev, 0x90c0, 0x270c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x272c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x274c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x276c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x278c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x27ac, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x27cc, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x27ec, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x030c, 0x00000001);
	nv_mthd(dev, 0x90c0, 0x1944, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x0758, 0x00000100);
	nv_mthd(dev, 0x90c0, 0x02c4, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x0790, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x0794, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x0798, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x079c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x07a0, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x077c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x0204, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x0208, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x020c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x0214, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x024c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x0d94, 0x00000001);
	nv_mthd(dev, 0x90c0, 0x1608, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x160c, 0x00000000);
	nv_mthd(dev, 0x90c0, 0x1664, 0x00000000);
}

static void
nvc0_grctx_generate_dispatch(struct drm_device *dev)
{
	int i;

	nv_wr32(dev, 0x404004, 0x00000000);
	nv_wr32(dev, 0x404008, 0x00000000);
	nv_wr32(dev, 0x40400c, 0x00000000);
	nv_wr32(dev, 0x404010, 0x00000000);
	nv_wr32(dev, 0x404014, 0x00000000);
	nv_wr32(dev, 0x404018, 0x00000000);
	nv_wr32(dev, 0x40401c, 0x00000000);
	nv_wr32(dev, 0x404020, 0x00000000);
	nv_wr32(dev, 0x404024, 0x00000000);
	nv_wr32(dev, 0x404028, 0x00000000);
	nv_wr32(dev, 0x40402c, 0x00000000);
	nv_wr32(dev, 0x404044, 0x00000000);
	nv_wr32(dev, 0x404094, 0x00000000);
	nv_wr32(dev, 0x404098, 0x00000000);
	nv_wr32(dev, 0x40409c, 0x00000000);
	nv_wr32(dev, 0x4040a0, 0x00000000);
	nv_wr32(dev, 0x4040a4, 0x00000000);
	nv_wr32(dev, 0x4040a8, 0x00000000);
	nv_wr32(dev, 0x4040ac, 0x00000000);
	nv_wr32(dev, 0x4040b0, 0x00000000);
	nv_wr32(dev, 0x4040b4, 0x00000000);
	nv_wr32(dev, 0x4040b8, 0x00000000);
	nv_wr32(dev, 0x4040bc, 0x00000000);
	nv_wr32(dev, 0x4040c0, 0x00000000);
	nv_wr32(dev, 0x4040c4, 0x00000000);
	nv_wr32(dev, 0x4040c8, 0xf0000087);
	nv_wr32(dev, 0x4040d4, 0x00000000);
	nv_wr32(dev, 0x4040d8, 0x00000000);
	nv_wr32(dev, 0x4040dc, 0x00000000);
	nv_wr32(dev, 0x4040e0, 0x00000000);
	nv_wr32(dev, 0x4040e4, 0x00000000);
	nv_wr32(dev, 0x4040e8, 0x00001000);
	nv_wr32(dev, 0x4040f8, 0x00000000);
	nv_wr32(dev, 0x404130, 0x00000000);
	nv_wr32(dev, 0x404134, 0x00000000);
	nv_wr32(dev, 0x404138, 0x20000040);
	nv_wr32(dev, 0x404150, 0x0000002e);
	nv_wr32(dev, 0x404154, 0x00000400);
	nv_wr32(dev, 0x404158, 0x00000200);
	nv_wr32(dev, 0x404164, 0x00000055);
	nv_wr32(dev, 0x404168, 0x00000000);
	nv_wr32(dev, 0x404174, 0x00000000);
	nv_wr32(dev, 0x404178, 0x00000000);
	nv_wr32(dev, 0x40417c, 0x00000000);
	for (i = 0; i < 8; i++)
		nv_wr32(dev, 0x404200 + (i * 4), 0x00000000); /* subc */
}

static void
nvc0_grctx_generate_macro(struct drm_device *dev)
{
	nv_wr32(dev, 0x404404, 0x00000000);
	nv_wr32(dev, 0x404408, 0x00000000);
	nv_wr32(dev, 0x40440c, 0x00000000);
	nv_wr32(dev, 0x404410, 0x00000000);
	nv_wr32(dev, 0x404414, 0x00000000);
	nv_wr32(dev, 0x404418, 0x00000000);
	nv_wr32(dev, 0x40441c, 0x00000000);
	nv_wr32(dev, 0x404420, 0x00000000);
	nv_wr32(dev, 0x404424, 0x00000000);
	nv_wr32(dev, 0x404428, 0x00000000);
	nv_wr32(dev, 0x40442c, 0x00000000);
	nv_wr32(dev, 0x404430, 0x00000000);
	nv_wr32(dev, 0x404434, 0x00000000);
	nv_wr32(dev, 0x404438, 0x00000000);
	nv_wr32(dev, 0x404460, 0x00000000);
	nv_wr32(dev, 0x404464, 0x00000000);
	nv_wr32(dev, 0x404468, 0x00ffffff);
	nv_wr32(dev, 0x40446c, 0x00000000);
	nv_wr32(dev, 0x404480, 0x00000001);
	nv_wr32(dev, 0x404498, 0x00000001);
}

static void
nvc0_grctx_generate_m2mf(struct drm_device *dev)
{
	nv_wr32(dev, 0x404604, 0x00000015);
	nv_wr32(dev, 0x404608, 0x00000000);
	nv_wr32(dev, 0x40460c, 0x00002e00);
	nv_wr32(dev, 0x404610, 0x00000100);
	nv_wr32(dev, 0x404618, 0x00000000);
	nv_wr32(dev, 0x40461c, 0x00000000);
	nv_wr32(dev, 0x404620, 0x00000000);
	nv_wr32(dev, 0x404624, 0x00000000);
	nv_wr32(dev, 0x404628, 0x00000000);
	nv_wr32(dev, 0x40462c, 0x00000000);
	nv_wr32(dev, 0x404630, 0x00000000);
	nv_wr32(dev, 0x404634, 0x00000000);
	nv_wr32(dev, 0x404638, 0x00000004);
	nv_wr32(dev, 0x40463c, 0x00000000);
	nv_wr32(dev, 0x404640, 0x00000000);
	nv_wr32(dev, 0x404644, 0x00000000);
	nv_wr32(dev, 0x404648, 0x00000000);
	nv_wr32(dev, 0x40464c, 0x00000000);
	nv_wr32(dev, 0x404650, 0x00000000);
	nv_wr32(dev, 0x404654, 0x00000000);
	nv_wr32(dev, 0x404658, 0x00000000);
	nv_wr32(dev, 0x40465c, 0x007f0100);
	nv_wr32(dev, 0x404660, 0x00000000);
	nv_wr32(dev, 0x404664, 0x00000000);
	nv_wr32(dev, 0x404668, 0x00000000);
	nv_wr32(dev, 0x40466c, 0x00000000);
	nv_wr32(dev, 0x404670, 0x00000000);
	nv_wr32(dev, 0x404674, 0x00000000);
	nv_wr32(dev, 0x404678, 0x00000000);
	nv_wr32(dev, 0x40467c, 0x00000002);
	nv_wr32(dev, 0x404680, 0x00000000);
	nv_wr32(dev, 0x404684, 0x00000000);
	nv_wr32(dev, 0x404688, 0x00000000);
	nv_wr32(dev, 0x40468c, 0x00000000);
	nv_wr32(dev, 0x404690, 0x00000000);
	nv_wr32(dev, 0x404694, 0x00000000);
	nv_wr32(dev, 0x404698, 0x00000000);
	nv_wr32(dev, 0x40469c, 0x00000000);
	nv_wr32(dev, 0x4046a0, 0x007f0080);
	nv_wr32(dev, 0x4046a4, 0x00000000);
	nv_wr32(dev, 0x4046a8, 0x00000000);
	nv_wr32(dev, 0x4046ac, 0x00000000);
	nv_wr32(dev, 0x4046b0, 0x00000000);
	nv_wr32(dev, 0x4046b4, 0x00000000);
	nv_wr32(dev, 0x4046b8, 0x00000000);
	nv_wr32(dev, 0x4046bc, 0x00000000);
	nv_wr32(dev, 0x4046c0, 0x00000000);
	nv_wr32(dev, 0x4046c4, 0x00000000);
	nv_wr32(dev, 0x4046c8, 0x00000000);
	nv_wr32(dev, 0x4046cc, 0x00000000);
	nv_wr32(dev, 0x4046d0, 0x00000000);
	nv_wr32(dev, 0x4046d4, 0x00000000);
	nv_wr32(dev, 0x4046d8, 0x00000000);
	nv_wr32(dev, 0x4046dc, 0x00000000);
	nv_wr32(dev, 0x4046e0, 0x00000000);
	nv_wr32(dev, 0x4046e4, 0x00000000);
	nv_wr32(dev, 0x4046e8, 0x00000000);
	nv_wr32(dev, 0x4046f0, 0x00000000);
	nv_wr32(dev, 0x4046f4, 0x00000000);
}

static void
nvc0_grctx_generate_unk47xx(struct drm_device *dev)
{
	nv_wr32(dev, 0x404700, 0x00000000);
	nv_wr32(dev, 0x404704, 0x00000000);
	nv_wr32(dev, 0x404708, 0x00000000);
	nv_wr32(dev, 0x40470c, 0x00000000);
	nv_wr32(dev, 0x404710, 0x00000000);
	nv_wr32(dev, 0x404714, 0x00000000);
	nv_wr32(dev, 0x404718, 0x00000000);
	nv_wr32(dev, 0x40471c, 0x00000000);
	nv_wr32(dev, 0x404720, 0x00000000);
	nv_wr32(dev, 0x404724, 0x00000000);
	nv_wr32(dev, 0x404728, 0x00000000);
	nv_wr32(dev, 0x40472c, 0x00000000);
	nv_wr32(dev, 0x404730, 0x00000000);
	nv_wr32(dev, 0x404734, 0x00000100);
	nv_wr32(dev, 0x404738, 0x00000000);
	nv_wr32(dev, 0x40473c, 0x00000000);
	nv_wr32(dev, 0x404740, 0x00000000);
	nv_wr32(dev, 0x404744, 0x00000000);
	nv_wr32(dev, 0x404748, 0x00000000);
	nv_wr32(dev, 0x40474c, 0x00000000);
	nv_wr32(dev, 0x404750, 0x00000000);
	nv_wr32(dev, 0x404754, 0x00000000);
}

static void
nvc0_grctx_generate_shaders(struct drm_device *dev)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;

	if (dev_priv->chipset != 0xc1) {
		nv_wr32(dev, 0x405800, 0x078000bf);
		nv_wr32(dev, 0x405830, 0x02180000);
	} else {
		nv_wr32(dev, 0x405800, 0x0f8000bf);
		nv_wr32(dev, 0x405830, 0x02180218);
	}
	nv_wr32(dev, 0x405834, 0x00000000);
	nv_wr32(dev, 0x405838, 0x00000000);
	nv_wr32(dev, 0x405854, 0x00000000);
	nv_wr32(dev, 0x405870, 0x00000001);
	nv_wr32(dev, 0x405874, 0x00000001);
	nv_wr32(dev, 0x405878, 0x00000001);
	nv_wr32(dev, 0x40587c, 0x00000001);
	nv_wr32(dev, 0x405a00, 0x00000000);
	nv_wr32(dev, 0x405a04, 0x00000000);
	nv_wr32(dev, 0x405a18, 0x00000000);
}

static void
nvc0_grctx_generate_unk60xx(struct drm_device *dev)
{
	nv_wr32(dev, 0x406020, 0x000103c1);
	nv_wr32(dev, 0x406028, 0x00000001);
	nv_wr32(dev, 0x40602c, 0x00000001);
	nv_wr32(dev, 0x406030, 0x00000001);
	nv_wr32(dev, 0x406034, 0x00000001);
}

static void
nvc0_grctx_generate_unk64xx(struct drm_device *dev)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;

	nv_wr32(dev, 0x4064a8, 0x00000000);
	nv_wr32(dev, 0x4064ac, 0x00003fff);
	nv_wr32(dev, 0x4064b4, 0x00000000);
	nv_wr32(dev, 0x4064b8, 0x00000000);
	if (dev_priv->chipset == 0xc1) {
		nv_wr32(dev, 0x4064c0, 0x80140078);
		nv_wr32(dev, 0x4064c4, 0x0086ffff);
	}
}

static void
nvc0_grctx_generate_tpbus(struct drm_device *dev)
{
	nv_wr32(dev, 0x407804, 0x00000023);
	nv_wr32(dev, 0x40780c, 0x0a418820);
	nv_wr32(dev, 0x407810, 0x062080e6);
	nv_wr32(dev, 0x407814, 0x020398a4);
	nv_wr32(dev, 0x407818, 0x0e629062);
	nv_wr32(dev, 0x40781c, 0x0a418820);
	nv_wr32(dev, 0x407820, 0x000000e6);
	nv_wr32(dev, 0x4078bc, 0x00000103);
}

static void
nvc0_grctx_generate_ccache(struct drm_device *dev)
{
	nv_wr32(dev, 0x408000, 0x00000000);
	nv_wr32(dev, 0x408004, 0x00000000);
	nv_wr32(dev, 0x408008, 0x00000018);
	nv_wr32(dev, 0x40800c, 0x00000000);
	nv_wr32(dev, 0x408010, 0x00000000);
	nv_wr32(dev, 0x408014, 0x00000069);
	nv_wr32(dev, 0x408018, 0xe100e100);
	nv_wr32(dev, 0x408064, 0x00000000);
}

static void
nvc0_grctx_generate_rop(struct drm_device *dev)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	int chipset = dev_priv->chipset;

	/* ROPC_BROADCAST */
	nv_wr32(dev, 0x408800, 0x02802a3c);
	nv_wr32(dev, 0x408804, 0x00000040);
	nv_wr32(dev, 0x408808, chipset != 0xc1 ? 0x0003e00d : 0x1003e005);
	nv_wr32(dev, 0x408900, 0x3080b801);
	nv_wr32(dev, 0x408904, chipset != 0xc1 ? 0x02000001 : 0x62000001);
	nv_wr32(dev, 0x408908, 0x00c80929);
	nv_wr32(dev, 0x40890c, 0x00000000);
	nv_wr32(dev, 0x408980, 0x0000011d);
}

static void
nvc0_grctx_generate_gpc(struct drm_device *dev)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	int chipset = dev_priv->chipset;
	int i;

	/* GPC_BROADCAST */
	nv_wr32(dev, 0x418380, 0x00000016);
	nv_wr32(dev, 0x418400, 0x38004e00);
	nv_wr32(dev, 0x418404, 0x71e0ffff);
	nv_wr32(dev, 0x418408, 0x00000000);
	nv_wr32(dev, 0x41840c, 0x00001008);
	nv_wr32(dev, 0x418410, 0x0fff0fff);
	nv_wr32(dev, 0x418414, 0x00200fff);
	nv_wr32(dev, 0x418450, 0x00000000);
	nv_wr32(dev, 0x418454, 0x00000000);
	nv_wr32(dev, 0x418458, 0x00000000);
	nv_wr32(dev, 0x41845c, 0x00000000);
	nv_wr32(dev, 0x418460, 0x00000000);
	nv_wr32(dev, 0x418464, 0x00000000);
	nv_wr32(dev, 0x418468, 0x00000001);
	nv_wr32(dev, 0x41846c, 0x00000000);
	nv_wr32(dev, 0x418470, 0x00000000);
	nv_wr32(dev, 0x418600, 0x0000001f);
	nv_wr32(dev, 0x418684, 0x0000000f);
	nv_wr32(dev, 0x418700, 0x00000002);
	nv_wr32(dev, 0x418704, 0x00000080);
	nv_wr32(dev, 0x418708, 0x00000000);
	nv_wr32(dev, 0x41870c, 0x07c80000);
	nv_wr32(dev, 0x418710, 0x00000000);
	nv_wr32(dev, 0x418800, 0x0006860a);
	nv_wr32(dev, 0x418808, 0x00000000);
	nv_wr32(dev, 0x41880c, 0x00000000);
	nv_wr32(dev, 0x418810, 0x00000000);
	nv_wr32(dev, 0x418828, 0x00008442);
	nv_wr32(dev, 0x418830, chipset != 0xc1 ? 0x00000001 : 0x10000001);
	nv_wr32(dev, 0x4188d8, 0x00000008);
	nv_wr32(dev, 0x4188e0, 0x01000000);
	nv_wr32(dev, 0x4188e8, 0x00000000);
	nv_wr32(dev, 0x4188ec, 0x00000000);
	nv_wr32(dev, 0x4188f0, 0x00000000);
	nv_wr32(dev, 0x4188f4, 0x00000000);
	nv_wr32(dev, 0x4188f8, 0x00000000);
	nv_wr32(dev, 0x4188fc, chipset != 0xc1 ? 0x00100000 : 0x00100018);
	nv_wr32(dev, 0x41891c, 0x00ff00ff);
	nv_wr32(dev, 0x418924, 0x00000000);
	nv_wr32(dev, 0x418928, 0x00ffff00);
	nv_wr32(dev, 0x41892c, 0x0000ff00);
	for (i = 0; i < 8; i++) {
		nv_wr32(dev, 0x418a00 + (i * 0x20), 0x00000000);
		nv_wr32(dev, 0x418a04 + (i * 0x20), 0x00000000);
		nv_wr32(dev, 0x418a08 + (i * 0x20), 0x00000000);
		nv_wr32(dev, 0x418a0c + (i * 0x20), 0x00010000);
		nv_wr32(dev, 0x418a10 + (i * 0x20), 0x00000000);
		nv_wr32(dev, 0x418a14 + (i * 0x20), 0x00000000);
		nv_wr32(dev, 0x418a18 + (i * 0x20), 0x00000000);
	}
	nv_wr32(dev, 0x418b00, 0x00000000);
	nv_wr32(dev, 0x418b08, 0x0a418820);
	nv_wr32(dev, 0x418b0c, 0x062080e6);
	nv_wr32(dev, 0x418b10, 0x020398a4);
	nv_wr32(dev, 0x418b14, 0x0e629062);
	nv_wr32(dev, 0x418b18, 0x0a418820);
	nv_wr32(dev, 0x418b1c, 0x000000e6);
	nv_wr32(dev, 0x418bb8, 0x00000103);
	nv_wr32(dev, 0x418c08, 0x00000001);
	nv_wr32(dev, 0x418c10, 0x00000000);
	nv_wr32(dev, 0x418c14, 0x00000000);
	nv_wr32(dev, 0x418c18, 0x00000000);
	nv_wr32(dev, 0x418c1c, 0x00000000);
	nv_wr32(dev, 0x418c20, 0x00000000);
	nv_wr32(dev, 0x418c24, 0x00000000);
	nv_wr32(dev, 0x418c28, 0x00000000);
	nv_wr32(dev, 0x418c2c, 0x00000000);
	if (chipset == 0xc1)
		nv_wr32(dev, 0x418c6c, 0x00000001);
	nv_wr32(dev, 0x418c80, 0x20200004);
	nv_wr32(dev, 0x418c8c, 0x00000001);
	nv_wr32(dev, 0x419000, 0x00000780);
	nv_wr32(dev, 0x419004, 0x00000000);
	nv_wr32(dev, 0x419008, 0x00000000);
	nv_wr32(dev, 0x419014, 0x00000004);
}

static void
nvc0_grctx_generate_tp(struct drm_device *dev)
{
	struct drm_nouveau_private *dev_priv = dev->dev_private;
	int chipset = dev_priv->chipset;

	/* GPC_BROADCAST.TP_BROADCAST */
	nv_wr32(dev, 0x419818, 0x00000000);
	nv_wr32(dev, 0x41983c, 0x00038bc7);
	nv_wr32(dev, 0x419848, 0x00000000);
	nv_wr32(dev, 0x419864, chipset != 0xc1 ? 0x0000012a : 0x00000129);
	nv_wr32(dev, 0x419888, 0x00000000);
	nv_wr32(dev, 0x419a00, 0x000001f0);
	nv_wr32(dev, 0x419a04, 0x00000001);
	nv_wr32(dev, 0x419a08, 0x00000023);
	nv_wr32(dev, 0x419a0c, 0x00020000);
	nv_wr32(dev, 0x419a10, 0x00000000);
	nv_wr32(dev, 0x419a14, 0x00000200);
	nv_wr32(dev, 0x419a1c, 0x00000000);
	nv_wr32(dev, 0x419a20, 0x00000800);
	if (chipset != 0xc0 && chipset != 0xc8)
		nv_wr32(dev, 0x00419ac4, 0x0007f440);
	nv_wr32(dev, 0x419b00, 0x0a418820);
	nv_wr32(dev, 0x419b04, 0x062080e6);
	nv_wr32(dev, 0x419b08, 0x020398a4);
	nv_wr32(dev, 0x419b0c, 0x0e629062);
	nv_wr32(dev, 0x419b10, 0x0a418820);
	nv_wr32(dev, 0x419b14, 0x000000e6);
	nv_wr32(dev, 0x419bd0, 0x00900103);
	nv_wr32(dev, 0x419be0, chipset != 0xc1 ? 0x00000001 : 0x00400001);
	nv_wr32(dev, 0x419be4, 0x00000000);
	nv_wr32(dev, 0x419c00, 0x00000002);
	nv_wr32(dev, 0x419c04, 0x00000006);
	nv_wr32(dev, 0x419c08, 0x00000002);
	nv_wr32(dev, 0x419c20, 0x00000000);
	if (chipset == 0xce || chipset == 0xcf)
		nv_wr32(dev, 0x419cb0, 0x00020048);
	else
		nv_wr32(dev, 0x419cb0, 0x00060048);
	nv_wr32(dev, 0x419ce8, 0x00000000);
	nv_wr32(dev, 0x419cf4, 0x00000183);
	nv_wr32(dev, 0x419d20, chipset != 0xc1 ? 0x02180000 : 0x12180000);
	nv_wr32(dev, 0x419d24, 0x00001fff);
	if (chipset == 0xc1)
		nv_wr32(dev, 0x419d44, 0x02180218);
	nv_wr32(dev, 0x419e04, 0x00000000);
	nv_wr32(dev, 0x419e08, 0x00000000);
	nv_wr32(dev, 0x419e0c, 0x00000000);
	nv_wr32(dev, 0x419e10, 0x00000002);
	nv_wr32(dev, 0x419e44, 0x001beff2);
	nv_wr32(dev, 0x419e48, 0x00000000);
	nv_wr32(dev, 0x419e4c, 0x0000000f);
	nv_wr32(dev, 0x419e50, 0x00000000);
	nv_wr32(dev, 0x419e54, 0x00000000);
	nv_wr32(dev, 0x419e58, 0x00000000);
	nv_wr32(dev, 0x419e5c, 0x00000000);
	nv_wr32(dev, 0x419e60, 0x00000000);
	nv_wr32(dev, 0x419e64, 0x00000000);
	nv_wr32(dev, 0x419e68, 0x00000000);
	nv_wr32(dev, 0x419e6c, 0x00000000);
	nv_wr32(dev, 0x419e70, 0x00000000);
	nv_wr32(dev, 0x419e74, 0x00000000);
	nv_wr32(dev, 0x419e78, 0x00000000);
	nv_wr32(dev, 0x419e7c, 0x00000000);
	nv_wr32(dev, 0x419e80, 0x00000000);
	nv_wr32(dev, 0x419e84, 0x00000000);
	nv_wr32(dev, 0x419e88, 0x00000000);
	nv_wr32(dev, 0x419e8c, 0x00000000);
	nv_wr32(dev, 0x419e90, 0x00000000);
	nv_wr32(dev, 0x419e98, 0x00000000);
	if (chipset != 0xc0 && chipset != 0xc8)
		nv_wr32(dev, 0x419ee0, 0x00011110);
	nv_wr32(dev, 0x419f50, 0x00000000);
	nv_wr32(dev, 0x419f54, 0x00000000);
	if (chipset != 0xc0 && chipset != 0xc8)
		nv_wr32(dev, 0x419f58, 0x00000000);
}

int
nvc0_grctx_generate(struct nouveau_channel *chan)
{
	struct drm_nouveau_private *dev_priv = chan->dev->dev_private;
	struct nvc0_graph_priv *priv = nv_engine(chan->dev, NVOBJ_ENGINE_GR);
	struct nvc0_graph_chan *grch = chan->engctx[NVOBJ_ENGINE_GR];
	struct drm_device *dev = chan->dev;
	int i, gpc, tp, id;
	u32 fermi = nvc0_graph_class(dev);
	u32 r000260, tmp;

	r000260 = nv_rd32(dev, 0x000260);
	nv_wr32(dev, 0x000260, r000260 & ~1);
	nv_wr32(dev, 0x400208, 0x00000000);

	nvc0_grctx_generate_dispatch(dev);
	nvc0_grctx_generate_macro(dev);
	nvc0_grctx_generate_m2mf(dev);
	nvc0_grctx_generate_unk47xx(dev);
	nvc0_grctx_generate_shaders(dev);
	nvc0_grctx_generate_unk60xx(dev);
	nvc0_grctx_generate_unk64xx(dev);
	nvc0_grctx_generate_tpbus(dev);
	nvc0_grctx_generate_ccache(dev);
	nvc0_grctx_generate_rop(dev);
	nvc0_grctx_generate_gpc(dev);
	nvc0_grctx_generate_tp(dev);

	nv_wr32(dev, 0x404154, 0x00000000);

	/* fuc "mmio list" writes */
	for (i = 0; i < grch->mmio_nr * 8; i += 8) {
		u32 reg = nv_ro32(grch->mmio, i + 0);
		nv_wr32(dev, reg, nv_ro32(grch->mmio, i + 4));
	}

	for (tp = 0, id = 0; tp < 4; tp++) {
		for (gpc = 0; gpc < priv->gpc_nr; gpc++) {
			if (tp < priv->tp_nr[gpc]) {
				nv_wr32(dev, TP_UNIT(gpc, tp, 0x698), id);
				nv_wr32(dev, TP_UNIT(gpc, tp, 0x4e8), id);
				nv_wr32(dev, GPC_UNIT(gpc, 0x0c10 + tp * 4), id);
				nv_wr32(dev, TP_UNIT(gpc, tp, 0x088), id);
				id++;
			}

			nv_wr32(dev, GPC_UNIT(gpc, 0x0c08), priv->tp_nr[gpc]);
			nv_wr32(dev, GPC_UNIT(gpc, 0x0c8c), priv->tp_nr[gpc]);
		}
	}

	tmp = 0;
	for (i = 0; i < priv->gpc_nr; i++)
		tmp |= priv->tp_nr[i] << (i * 4);
	nv_wr32(dev, 0x406028, tmp);
	nv_wr32(dev, 0x405870, tmp);

	nv_wr32(dev, 0x40602c, 0x00000000);
	nv_wr32(dev, 0x405874, 0x00000000);
	nv_wr32(dev, 0x406030, 0x00000000);
	nv_wr32(dev, 0x405878, 0x00000000);
	nv_wr32(dev, 0x406034, 0x00000000);
	nv_wr32(dev, 0x40587c, 0x00000000);

	if (1) {
		u8 tpnr[GPC_MAX], data[TP_MAX];

		memcpy(tpnr, priv->tp_nr, sizeof(priv->tp_nr));
		memset(data, 0x1f, sizeof(data));

		gpc = -1;
		for (tp = 0; tp < priv->tp_total; tp++) {
			do {
				gpc = (gpc + 1) % priv->gpc_nr;
			} while (!tpnr[gpc]);
			tpnr[gpc]--;
			data[tp] = gpc;
		}

		for (i = 0; i < 4; i++)
			nv_wr32(dev, 0x4060a8 + (i * 4), ((u32 *)data)[i]);
	}

	if (1) {
		u32 data[6] = {}, data2[2] = {};
		u8 tpnr[GPC_MAX];
		u8 shift, ntpcv;

		/* calculate first set of magics */
		memcpy(tpnr, priv->tp_nr, sizeof(priv->tp_nr));

		gpc = -1;
		for (tp = 0; tp < priv->tp_total; tp++) {
			do {
				gpc = (gpc + 1) % priv->gpc_nr;
			} while (!tpnr[gpc]);
			tpnr[gpc]--;

			data[tp / 6] |= gpc << ((tp % 6) * 5);
		}

		for (; tp < 32; tp++)
			data[tp / 6] |= 7 << ((tp % 6) * 5);

		/* and the second... */
		shift = 0;
		ntpcv = priv->tp_total;
		while (!(ntpcv & (1 << 4))) {
			ntpcv <<= 1;
			shift++;
		}

		data2[0]  = (ntpcv << 16);
		data2[0] |= (shift << 21);
		data2[0] |= (((1 << (0 + 5)) % ntpcv) << 24);
		for (i = 1; i < 7; i++)
			data2[1] |= ((1 << (i + 5)) % ntpcv) << ((i - 1) * 5);

		/* GPC_BROADCAST */
		nv_wr32(dev, 0x418bb8, (priv->tp_total << 8) |
					priv->magic_not_rop_nr);
		for (i = 0; i < 6; i++)
			nv_wr32(dev, 0x418b08 + (i * 4), data[i]);

		/* GPC_BROADCAST.TP_BROADCAST */
		nv_wr32(dev, 0x419bd0, (priv->tp_total << 8) |
				       priv->magic_not_rop_nr |
				       data2[0]);
		nv_wr32(dev, 0x419be4, data2[1]);
		for (i = 0; i < 6; i++)
			nv_wr32(dev, 0x419b00 + (i * 4), data[i]);

		/* UNK78xx */
		nv_wr32(dev, 0x4078bc, (priv->tp_total << 8) |
					priv->magic_not_rop_nr);
		for (i = 0; i < 6; i++)
			nv_wr32(dev, 0x40780c + (i * 4), data[i]);
	}

	if (1) {
		u32 tp_mask = 0, tp_set = 0;
		u8  tpnr[GPC_MAX], a, b;

		memcpy(tpnr, priv->tp_nr, sizeof(priv->tp_nr));
		for (gpc = 0; gpc < priv->gpc_nr; gpc++)
			tp_mask |= ((1 << priv->tp_nr[gpc]) - 1) << (gpc * 8);

		for (i = 0, gpc = -1, b = -1; i < 32; i++) {
			a = (i * (priv->tp_total - 1)) / 32;
			if (a != b) {
				b = a;
				do {
					gpc = (gpc + 1) % priv->gpc_nr;
				} while (!tpnr[gpc]);
				tp = priv->tp_nr[gpc] - tpnr[gpc]--;

				tp_set |= 1 << ((gpc * 8) + tp);
			}

			nv_wr32(dev, 0x406800 + (i * 0x20), tp_set);
			nv_wr32(dev, 0x406c00 + (i * 0x20), tp_set ^ tp_mask);
		}
	}

	nv_wr32(dev, 0x400208, 0x80000000);

	nv_icmd(dev, 0x00001000, 0x00000004);
	nv_icmd(dev, 0x000000a9, 0x0000ffff);
	nv_icmd(dev, 0x00000038, 0x0fac6881);
	nv_icmd(dev, 0x0000003d, 0x00000001);
	nv_icmd(dev, 0x000000e8, 0x00000400);
	nv_icmd(dev, 0x000000e9, 0x00000400);
	nv_icmd(dev, 0x000000ea, 0x00000400);
	nv_icmd(dev, 0x000000eb, 0x00000400);
	nv_icmd(dev, 0x000000ec, 0x00000400);
	nv_icmd(dev, 0x000000ed, 0x00000400);
	nv_icmd(dev, 0x000000ee, 0x00000400);
	nv_icmd(dev, 0x000000ef, 0x00000400);
	nv_icmd(dev, 0x00000078, 0x00000300);
	nv_icmd(dev, 0x00000079, 0x00000300);
	nv_icmd(dev, 0x0000007a, 0x00000300);
	nv_icmd(dev, 0x0000007b, 0x00000300);
	nv_icmd(dev, 0x0000007c, 0x00000300);
	nv_icmd(dev, 0x0000007d, 0x00000300);
	nv_icmd(dev, 0x0000007e, 0x00000300);
	nv_icmd(dev, 0x0000007f, 0x00000300);
	nv_icmd(dev, 0x00000050, 0x00000011);
	nv_icmd(dev, 0x00000058, 0x00000008);
	nv_icmd(dev, 0x00000059, 0x00000008);
	nv_icmd(dev, 0x0000005a, 0x00000008);
	nv_icmd(dev, 0x0000005b, 0x00000008);
	nv_icmd(dev, 0x0000005c, 0x00000008);
	nv_icmd(dev, 0x0000005d, 0x00000008);
	nv_icmd(dev, 0x0000005e, 0x00000008);
	nv_icmd(dev, 0x0000005f, 0x00000008);
	nv_icmd(dev, 0x00000208, 0x00000001);
	nv_icmd(dev, 0x00000209, 0x00000001);
	nv_icmd(dev, 0x0000020a, 0x00000001);
	nv_icmd(dev, 0x0000020b, 0x00000001);
	nv_icmd(dev, 0x0000020c, 0x00000001);
	nv_icmd(dev, 0x0000020d, 0x00000001);
	nv_icmd(dev, 0x0000020e, 0x00000001);
	nv_icmd(dev, 0x0000020f, 0x00000001);
	nv_icmd(dev, 0x00000081, 0x00000001);
	nv_icmd(dev, 0x00000085, 0x00000004);
	nv_icmd(dev, 0x00000088, 0x00000400);
	nv_icmd(dev, 0x00000090, 0x00000300);
	nv_icmd(dev, 0x00000098, 0x00001001);
	nv_icmd(dev, 0x000000e3, 0x00000001);
	nv_icmd(dev, 0x000000da, 0x00000001);
	nv_icmd(dev, 0x000000f8, 0x00000003);
	nv_icmd(dev, 0x000000fa, 0x00000001);
	nv_icmd(dev, 0x0000009f, 0x0000ffff);
	nv_icmd(dev, 0x000000a0, 0x0000ffff);
	nv_icmd(dev, 0x000000a1, 0x0000ffff);
	nv_icmd(dev, 0x000000a2, 0x0000ffff);
	nv_icmd(dev, 0x000000b1, 0x00000001);
	nv_icmd(dev, 0x000000b2, 0x00000000);
	nv_icmd(dev, 0x000000b3, 0x00000000);
	nv_icmd(dev, 0x000000b4, 0x00000000);
	nv_icmd(dev, 0x000000b5, 0x00000000);
	nv_icmd(dev, 0x000000b6, 0x00000000);
	nv_icmd(dev, 0x000000b7, 0x00000000);
	nv_icmd(dev, 0x000000b8, 0x00000000);
	nv_icmd(dev, 0x000000b9, 0x00000000);
	nv_icmd(dev, 0x000000ba, 0x00000000);
	nv_icmd(dev, 0x000000bb, 0x00000000);
	nv_icmd(dev, 0x000000bc, 0x00000000);
	nv_icmd(dev, 0x000000bd, 0x00000000);
	nv_icmd(dev, 0x000000be, 0x00000000);
	nv_icmd(dev, 0x000000bf, 0x00000000);
	nv_icmd(dev, 0x000000c0, 0x00000000);
	nv_icmd(dev, 0x000000c1, 0x00000000);
	nv_icmd(dev, 0x000000c2, 0x00000000);
	nv_icmd(dev, 0x000000c3, 0x00000000);
	nv_icmd(dev, 0x000000c4, 0x00000000);
	nv_icmd(dev, 0x000000c5, 0x00000000);
	nv_icmd(dev, 0x000000c6, 0x00000000);
	nv_icmd(dev, 0x000000c7, 0x00000000);
	nv_icmd(dev, 0x000000c8, 0x00000000);
	nv_icmd(dev, 0x000000c9, 0x00000000);
	nv_icmd(dev, 0x000000ca, 0x00000000);
	nv_icmd(dev, 0x000000cb, 0x00000000);
	nv_icmd(dev, 0x000000cc, 0x00000000);
	nv_icmd(dev, 0x000000cd, 0x00000000);
	nv_icmd(dev, 0x000000ce, 0x00000000);
	nv_icmd(dev, 0x000000cf, 0x00000000);
	nv_icmd(dev, 0x000000d0, 0x00000000);
	nv_icmd(dev, 0x000000d1, 0x00000000);
	nv_icmd(dev, 0x000000d2, 0x00000000);
	nv_icmd(dev, 0x000000d3, 0x00000000);
	nv_icmd(dev, 0x000000d4, 0x00000000);
	nv_icmd(dev, 0x000000d5, 0x00000000);
	nv_icmd(dev, 0x000000d6, 0x00000000);
	nv_icmd(dev, 0x000000d7, 0x00000000);
	nv_icmd(dev, 0x000000d8, 0x00000000);
	nv_icmd(dev, 0x000000d9, 0x00000000);
	nv_icmd(dev, 0x00000210, 0x00000040);
	nv_icmd(dev, 0x00000211, 0x00000040);
	nv_icmd(dev, 0x00000212, 0x00000040);
	nv_icmd(dev, 0x00000213, 0x00000040);
	nv_icmd(dev, 0x00000214, 0x00000040);
	nv_icmd(dev, 0x00000215, 0x00000040);
	nv_icmd(dev, 0x00000216, 0x00000040);
	nv_icmd(dev, 0x00000217, 0x00000040);
	nv_icmd(dev, 0x00000218, 0x0000c080);
	nv_icmd(dev, 0x00000219, 0x0000c080);
	nv_icmd(dev, 0x0000021a, 0x0000c080);
	nv_icmd(dev, 0x0000021b, 0x0000c080);
	nv_icmd(dev, 0x0000021c, 0x0000c080);
	nv_icmd(dev, 0x0000021d, 0x0000c080);
	nv_icmd(dev, 0x0000021e, 0x0000c080);
	nv_icmd(dev, 0x0000021f, 0x0000c080);
	nv_icmd(dev, 0x000000ad, 0x0000013e);
	nv_icmd(dev, 0x000000e1, 0x00000010);
	nv_icmd(dev, 0x00000290, 0x00000000);
	nv_icmd(dev, 0x00000291, 0x00000000);
	nv_icmd(dev, 0x00000292, 0x00000000);
	nv_icmd(dev, 0x00000293, 0x00000000);
	nv_icmd(dev, 0x00000294, 0x00000000);
	nv_icmd(dev, 0x00000295, 0x00000000);
	nv_icmd(dev, 0x00000296, 0x00000000);
	nv_icmd(dev, 0x00000297, 0x00000000);
	nv_icmd(dev, 0x00000298, 0x00000000);
	nv_icmd(dev, 0x00000299, 0x00000000);
	nv_icmd(dev, 0x0000029a, 0x00000000);
	nv_icmd(dev, 0x0000029b, 0x00000000);
	nv_icmd(dev, 0x0000029c, 0x00000000);
	nv_icmd(dev, 0x0000029d, 0x00000000);
	nv_icmd(dev, 0x0000029e, 0x00000000);
	nv_icmd(dev, 0x0000029f, 0x00000000);
	nv_icmd(dev, 0x000003b0, 0x00000000);
	nv_icmd(dev, 0x000003b1, 0x00000000);
	nv_icmd(dev, 0x000003b2, 0x00000000);
	nv_icmd(dev, 0x000003b3, 0x00000000);
	nv_icmd(dev, 0x000003b4, 0x00000000);
	nv_icmd(dev, 0x000003b5, 0x00000000);
	nv_icmd(dev, 0x000003b6, 0x00000000);
	nv_icmd(dev, 0x000003b7, 0x00000000);
	nv_icmd(dev, 0x000003b8, 0x00000000);
	nv_icmd(dev, 0x000003b9, 0x00000000);
	nv_icmd(dev, 0x000003ba, 0x00000000);
	nv_icmd(dev, 0x000003bb, 0x00000000);
	nv_icmd(dev, 0x000003bc, 0x00000000);
	nv_icmd(dev, 0x000003bd, 0x00000000);
	nv_icmd(dev, 0x000003be, 0x00000000);
	nv_icmd(dev, 0x000003bf, 0x00000000);
	nv_icmd(dev, 0x000002a0, 0x00000000);
	nv_icmd(dev, 0x000002a1, 0x00000000);
	nv_icmd(dev, 0x000002a2, 0x00000000);
	nv_icmd(dev, 0x000002a3, 0x00000000);
	nv_icmd(dev, 0x000002a4, 0x00000000);
	nv_icmd(dev, 0x000002a5, 0x00000000);
	nv_icmd(dev, 0x000002a6, 0x00000000);
	nv_icmd(dev, 0x000002a7, 0x00000000);
	nv_icmd(dev, 0x000002a8, 0x00000000);
	nv_icmd(dev, 0x000002a9, 0x00000000);
	nv_icmd(dev, 0x000002aa, 0x00000000);
	nv_icmd(dev, 0x000002ab, 0x00000000);
	nv_icmd(dev, 0x000002ac, 0x00000000);
	nv_icmd(dev, 0x000002ad, 0x00000000);
	nv_icmd(dev, 0x000002ae, 0x00000000);
	nv_icmd(dev, 0x000002af, 0x00000000);
	nv_icmd(dev, 0x00000420, 0x00000000);
	nv_icmd(dev, 0x00000421, 0x00000000);
	nv_icmd(dev, 0x00000422, 0x00000000);
	nv_icmd(dev, 0x00000423, 0x00000000);
	nv_icmd(dev, 0x00000424, 0x00000000);
	nv_icmd(dev, 0x00000425, 0x00000000);
	nv_icmd(dev, 0x00000426, 0x00000000);
	nv_icmd(dev, 0x00000427, 0x00000000);
	nv_icmd(dev, 0x00000428, 0x00000000);
	nv_icmd(dev, 0x00000429, 0x00000000);
	nv_icmd(dev, 0x0000042a, 0x00000000);
	nv_icmd(dev, 0x0000042b, 0x00000000);
	nv_icmd(dev, 0x0000042c, 0x00000000);
	nv_icmd(dev, 0x0000042d, 0x00000000);
	nv_icmd(dev, 0x0000042e, 0x00000000);
	nv_icmd(dev, 0x0000042f, 0x00000000);
	nv_icmd(dev, 0x000002b0, 0x00000000);
	nv_icmd(dev, 0x000002b1, 0x00000000);
	nv_icmd(dev, 0x000002b2, 0x00000000);
	nv_icmd(dev, 0x000002b3, 0x00000000);
	nv_icmd(dev, 0x000002b4, 0x00000000);
	nv_icmd(dev, 0x000002b5, 0x00000000);
	nv_icmd(dev, 0x000002b6, 0x00000000);
	nv_icmd(dev, 0x000002b7, 0x00000000);
	nv_icmd(dev, 0x000002b8, 0x00000000);
	nv_icmd(dev, 0x000002b9, 0x00000000);
	nv_icmd(dev, 0x000002ba, 0x00000000);
	nv_icmd(dev, 0x000002bb, 0x00000000);
	nv_icmd(dev, 0x000002bc, 0x00000000);
	nv_icmd(dev, 0x000002bd, 0x00000000);
	nv_icmd(dev, 0x000002be, 0x00000000);
	nv_icmd(dev, 0x000002bf, 0x00000000);
	nv_icmd(dev, 0x00000430, 0x00000000);
	nv_icmd(dev, 0x00000431, 0x00000000);
	nv_icmd(dev, 0x00000432, 0x00000000);
	nv_icmd(dev, 0x00000433, 0x00000000);
	nv_icmd(dev, 0x00000434, 0x00000000);
	nv_icmd(dev, 0x00000435, 0x00000000);
	nv_icmd(dev, 0x00000436, 0x00000000);
	nv_icmd(dev, 0x00000437, 0x00000000);
	nv_icmd(dev, 0x00000438, 0x00000000);
	nv_icmd(dev, 0x00000439, 0x00000000);
	nv_icmd(dev, 0x0000043a, 0x00000000);
	nv_icmd(dev, 0x0000043b, 0x00000000);
	nv_icmd(dev, 0x0000043c, 0x00000000);
	nv_icmd(dev, 0x0000043d, 0x00000000);
	nv_icmd(dev, 0x0000043e, 0x00000000);
	nv_icmd(dev, 0x0000043f, 0x00000000);
	nv_icmd(dev, 0x000002c0, 0x00000000);
	nv_icmd(dev, 0x000002c1, 0x00000000);
	nv_icmd(dev, 0x000002c2, 0x00000000);
	nv_icmd(dev, 0x000002c3, 0x00000000);
	nv_icmd(dev, 0x000002c4, 0x00000000);
	nv_icmd(dev, 0x000002c5, 0x00000000);
	nv_icmd(dev, 0x000002c6, 0x00000000);
	nv_icmd(dev, 0x000002c7, 0x00000000);
	nv_icmd(dev, 0x000002c8, 0x00000000);
	nv_icmd(dev, 0x000002c9, 0x00000000);
	nv_icmd(dev, 0x000002ca, 0x00000000);
	nv_icmd(dev, 0x000002cb, 0x00000000);
	nv_icmd(dev, 0x000002cc, 0x00000000);
	nv_icmd(dev, 0x000002cd, 0x00000000);
	nv_icmd(dev, 0x000002ce, 0x00000000);
	nv_icmd(dev, 0x000002cf, 0x00000000);
	nv_icmd(dev, 0x000004d0, 0x00000000);
	nv_icmd(dev, 0x000004d1, 0x00000000);
	nv_icmd(dev, 0x000004d2, 0x00000000);
	nv_icmd(dev, 0x000004d3, 0x00000000);
	nv_icmd(dev, 0x000004d4, 0x00000000);
	nv_icmd(dev, 0x000004d5, 0x00000000);
	nv_icmd(dev, 0x000004d6, 0x00000000);
	nv_icmd(dev, 0x000004d7, 0x00000000);
	nv_icmd(dev, 0x000004d8, 0x00000000);
	nv_icmd(dev, 0x000004d9, 0x00000000);
	nv_icmd(dev, 0x000004da, 0x00000000);
	nv_icmd(dev, 0x000004db, 0x00000000);
	nv_icmd(dev, 0x000004dc, 0x00000000);
	nv_icmd(dev, 0x000004dd, 0x00000000);
	nv_icmd(dev, 0x000004de, 0x00000000);
	nv_icmd(dev, 0x000004df, 0x00000000);
	nv_icmd(dev, 0x00000720, 0x00000000);
	nv_icmd(dev, 0x00000721, 0x00000000);
	nv_icmd(dev, 0x00000722, 0x00000000);
	nv_icmd(dev, 0x00000723, 0x00000000);
	nv_icmd(dev, 0x00000724, 0x00000000);
	nv_icmd(dev, 0x00000725, 0x00000000);
	nv_icmd(dev, 0x00000726, 0x00000000);
	nv_icmd(dev, 0x00000727, 0x00000000);
	nv_icmd(dev, 0x00000728, 0x00000000);
	nv_icmd(dev, 0x00000729, 0x00000000);
	nv_icmd(dev, 0x0000072a, 0x00000000);
	nv_icmd(dev, 0x0000072b, 0x00000000);
	nv_icmd(dev, 0x0000072c, 0x00000000);
	nv_icmd(dev, 0x0000072d, 0x00000000);
	nv_icmd(dev, 0x0000072e, 0x00000000);
	nv_icmd(dev, 0x0000072f, 0x00000000);
	nv_icmd(dev, 0x000008c0, 0x00000000);
	nv_icmd(dev, 0x000008c1, 0x00000000);
	nv_icmd(dev, 0x000008c2, 0x00000000);
	nv_icmd(dev, 0x000008c3, 0x00000000);
	nv_icmd(dev, 0x000008c4, 0x00000000);
	nv_icmd(dev, 0x000008c5, 0x00000000);
	nv_icmd(dev, 0x000008c6, 0x00000000);
	nv_icmd(dev, 0x000008c7, 0x00000000);
	nv_icmd(dev, 0x000008c8, 0x00000000);
	nv_icmd(dev, 0x000008c9, 0x00000000);
	nv_icmd(dev, 0x000008ca, 0x00000000);
	nv_icmd(dev, 0x000008cb, 0x00000000);
	nv_icmd(dev, 0x000008cc, 0x00000000);
	nv_icmd(dev, 0x000008cd, 0x00000000);
	nv_icmd(dev, 0x000008ce, 0x00000000);
	nv_icmd(dev, 0x000008cf, 0x00000000);
	nv_icmd(dev, 0x00000890, 0x00000000);
	nv_icmd(dev, 0x00000891, 0x00000000);
	nv_icmd(dev, 0x00000892, 0x00000000);
	nv_icmd(dev, 0x00000893, 0x00000000);
	nv_icmd(dev, 0x00000894, 0x00000000);
	nv_icmd(dev, 0x00000895, 0x00000000);
	nv_icmd(dev, 0x00000896, 0x00000000);
	nv_icmd(dev, 0x00000897, 0x00000000);
	nv_icmd(dev, 0x00000898, 0x00000000);
	nv_icmd(dev, 0x00000899, 0x00000000);
	nv_icmd(dev, 0x0000089a, 0x00000000);
	nv_icmd(dev, 0x0000089b, 0x00000000);
	nv_icmd(dev, 0x0000089c, 0x00000000);
	nv_icmd(dev, 0x0000089d, 0x00000000);
	nv_icmd(dev, 0x0000089e, 0x00000000);
	nv_icmd(dev, 0x0000089f, 0x00000000);
	nv_icmd(dev, 0x000008e0, 0x00000000);
	nv_icmd(dev, 0x000008e1, 0x00000000);
	nv_icmd(dev, 0x000008e2, 0x00000000);
	nv_icmd(dev, 0x000008e3, 0x00000000);
	nv_icmd(dev, 0x000008e4, 0x00000000);
	nv_icmd(dev, 0x000008e5, 0x00000000);
	nv_icmd(dev, 0x000008e6, 0x00000000);
	nv_icmd(dev, 0x000008e7, 0x00000000);
	nv_icmd(dev, 0x000008e8, 0x00000000);
	nv_icmd(dev, 0x000008e9, 0x00000000);
	nv_icmd(dev, 0x000008ea, 0x00000000);
	nv_icmd(dev, 0x000008eb, 0x00000000);
	nv_icmd(dev, 0x000008ec, 0x00000000);
	nv_icmd(dev, 0x000008ed, 0x00000000);
	nv_icmd(dev, 0x000008ee, 0x00000000);
	nv_icmd(dev, 0x000008ef, 0x00000000);
	nv_icmd(dev, 0x000008a0, 0x00000000);
	nv_icmd(dev, 0x000008a1, 0x00000000);
	nv_icmd(dev, 0x000008a2, 0x00000000);
	nv_icmd(dev, 0x000008a3, 0x00000000);
	nv_icmd(dev, 0x000008a4, 0x00000000);
	nv_icmd(dev, 0x000008a5, 0x00000000);
	nv_icmd(dev, 0x000008a6, 0x00000000);
	nv_icmd(dev, 0x000008a7, 0x00000000);
	nv_icmd(dev, 0x000008a8, 0x00000000);
	nv_icmd(dev, 0x000008a9, 0x00000000);
	nv_icmd(dev, 0x000008aa, 0x00000000);
	nv_icmd(dev, 0x000008ab, 0x00000000);
	nv_icmd(dev, 0x000008ac, 0x00000000);
	nv_icmd(dev, 0x000008ad, 0x00000000);
	nv_icmd(dev, 0x000008ae, 0x00000000);
	nv_icmd(dev, 0x000008af, 0x00000000);
	nv_icmd(dev, 0x000008f0, 0x00000000);
	nv_icmd(dev, 0x000008f1, 0x00000000);
	nv_icmd(dev, 0x000008f2, 0x00000000);
	nv_icmd(dev, 0x000008f3, 0x00000000);
	nv_icmd(dev, 0x000008f4, 0x00000000);
	nv_icmd(dev, 0x000008f5, 0x00000000);
	nv_icmd(dev, 0x000008f6, 0x00000000);
	nv_icmd(dev, 0x000008f7, 0x00000000);
	nv_icmd(dev, 0x000008f8, 0x00000000);
	nv_icmd(dev, 0x000008f9, 0x00000000);
	nv_icmd(dev, 0x000008fa, 0x00000000);
	nv_icmd(dev, 0x000008fb, 0x00000000);
	nv_icmd(dev, 0x000008fc, 0x00000000);
	nv_icmd(dev, 0x000008fd, 0x00000000);
	nv_icmd(dev, 0x000008fe, 0x00000000);
	nv_icmd(dev, 0x000008ff, 0x00000000);
	nv_icmd(dev, 0x0000094c, 0x000000ff);
	nv_icmd(dev, 0x0000094d, 0xffffffff);
	nv_icmd(dev, 0x0000094e, 0x00000002);
	nv_icmd(dev, 0x000002ec, 0x00000001);
	nv_icmd(dev, 0x00000303, 0x00000001);
	nv_icmd(dev, 0x000002e6, 0x00000001);
	nv_icmd(dev, 0x00000466, 0x00000052);
	nv_icmd(dev, 0x00000301, 0x3f800000);
	nv_icmd(dev, 0x00000304, 0x30201000);
	nv_icmd(dev, 0x00000305, 0x70605040);
	nv_icmd(dev, 0x00000306, 0xb8a89888);
	nv_icmd(dev, 0x00000307, 0xf8e8d8c8);
	nv_icmd(dev, 0x0000030a, 0x00ffff00);
	nv_icmd(dev, 0x0000030b, 0x0000001a);
	nv_icmd(dev, 0x0000030c, 0x00000001);
	nv_icmd(dev, 0x00000318, 0x00000001);
	nv_icmd(dev, 0x00000340, 0x00000000);
	nv_icmd(dev, 0x00000375, 0x00000001);
	nv_icmd(dev, 0x00000351, 0x00000100);
	nv_icmd(dev, 0x0000037d, 0x00000006);
	nv_icmd(dev, 0x000003a0, 0x00000002);
	nv_icmd(dev, 0x000003aa, 0x00000001);
	nv_icmd(dev, 0x000003a9, 0x00000001);
	nv_icmd(dev, 0x00000380, 0x00000001);
	nv_icmd(dev, 0x00000360, 0x00000040);
	nv_icmd(dev, 0x00000366, 0x00000000);
	nv_icmd(dev, 0x00000367, 0x00000000);
	nv_icmd(dev, 0x00000368, 0x00001fff);
	nv_icmd(dev, 0x00000370, 0x00000000);
	nv_icmd(dev, 0x00000371, 0x00000000);
	nv_icmd(dev, 0x00000372, 0x003fffff);
	nv_icmd(dev, 0x0000037a, 0x00000012);
	nv_icmd(dev, 0x000005e0, 0x00000022);
	nv_icmd(dev, 0x000005e1, 0x00000022);
	nv_icmd(dev, 0x000005e2, 0x00000022);
	nv_icmd(dev, 0x000005e3, 0x00000022);
	nv_icmd(dev, 0x000005e4, 0x00000022);
	nv_icmd(dev, 0x00000619, 0x00000003);
	nv_icmd(dev, 0x00000811, 0x00000003);
	nv_icmd(dev, 0x00000812, 0x00000004);
	nv_icmd(dev, 0x00000813, 0x00000006);
	nv_icmd(dev, 0x00000814, 0x00000008);
	nv_icmd(dev, 0x00000815, 0x0000000b);
	nv_icmd(dev, 0x00000800, 0x00000001);
	nv_icmd(dev, 0x00000801, 0x00000001);
	nv_icmd(dev, 0x00000802, 0x00000001);
	nv_icmd(dev, 0x00000803, 0x00000001);
	nv_icmd(dev, 0x00000804, 0x00000001);
	nv_icmd(dev, 0x00000805, 0x00000001);
	nv_icmd(dev, 0x00000632, 0x00000001);
	nv_icmd(dev, 0x00000633, 0x00000002);
	nv_icmd(dev, 0x00000634, 0x00000003);
	nv_icmd(dev, 0x00000635, 0x00000004);
	nv_icmd(dev, 0x00000654, 0x3f800000);
	nv_icmd(dev, 0x00000657, 0x3f800000);
	nv_icmd(dev, 0x00000655, 0x3f800000);
	nv_icmd(dev, 0x00000656, 0x3f800000);
	nv_icmd(dev, 0x000006cd, 0x3f800000);
	nv_icmd(dev, 0x000007f5, 0x3f800000);
	nv_icmd(dev, 0x000007dc, 0x39291909);
	nv_icmd(dev, 0x000007dd, 0x79695949);
	nv_icmd(dev, 0x000007de, 0xb9a99989);
	nv_icmd(dev, 0x000007df, 0xf9e9d9c9);
	nv_icmd(dev, 0x000007e8, 0x00003210);
	nv_icmd(dev, 0x000007e9, 0x00007654);
	nv_icmd(dev, 0x000007ea, 0x00000098);
	nv_icmd(dev, 0x000007ec, 0x39291909);
	nv_icmd(dev, 0x000007ed, 0x79695949);
	nv_icmd(dev, 0x000007ee, 0xb9a99989);
	nv_icmd(dev, 0x000007ef, 0xf9e9d9c9);
	nv_icmd(dev, 0x000007f0, 0x00003210);
	nv_icmd(dev, 0x000007f1, 0x00007654);
	nv_icmd(dev, 0x000007f2, 0x00000098);
	nv_icmd(dev, 0x000005a5, 0x00000001);
	nv_icmd(dev, 0x00000980, 0x00000000);
	nv_icmd(dev, 0x00000981, 0x00000000);
	nv_icmd(dev, 0x00000982, 0x00000000);
	nv_icmd(dev, 0x00000983, 0x00000000);
	nv_icmd(dev, 0x00000984, 0x00000000);
	nv_icmd(dev, 0x00000985, 0x00000000);
	nv_icmd(dev, 0x00000986, 0x00000000);
	nv_icmd(dev, 0x00000987, 0x00000000);
	nv_icmd(dev, 0x00000988, 0x00000000);
	nv_icmd(dev, 0x00000989, 0x00000000);
	nv_icmd(dev, 0x0000098a, 0x00000000);
	nv_icmd(dev, 0x0000098b, 0x00000000);
	nv_icmd(dev, 0x0000098c, 0x00000000);
	nv_icmd(dev, 0x0000098d, 0x00000000);
	nv_icmd(dev, 0x0000098e, 0x00000000);
	nv_icmd(dev, 0x0000098f, 0x00000000);
	nv_icmd(dev, 0x00000990, 0x00000000);
	nv_icmd(dev, 0x00000991, 0x00000000);
	nv_icmd(dev, 0x00000992, 0x00000000);
	nv_icmd(dev, 0x00000993, 0x00000000);
	nv_icmd(dev, 0x00000994, 0x00000000);
	nv_icmd(dev, 0x00000995, 0x00000000);
	nv_icmd(dev, 0x00000996, 0x00000000);
	nv_icmd(dev, 0x00000997, 0x00000000);
	nv_icmd(dev, 0x00000998, 0x00000000);
	nv_icmd(dev, 0x00000999, 0x00000000);
	nv_icmd(dev, 0x0000099a, 0x00000000);
	nv_icmd(dev, 0x0000099b, 0x00000000);
	nv_icmd(dev, 0x0000099c, 0x00000000);
	nv_icmd(dev, 0x0000099d, 0x00000000);
	nv_icmd(dev, 0x0000099e, 0x00000000);
	nv_icmd(dev, 0x0000099f, 0x00000000);
	nv_icmd(dev, 0x000009a0, 0x00000000);
	nv_icmd(dev, 0x000009a1, 0x00000000);
	nv_icmd(dev, 0x000009a2, 0x00000000);
	nv_icmd(dev, 0x000009a3, 0x00000000);
	nv_icmd(dev, 0x000009a4, 0x00000000);
	nv_icmd(dev, 0x000009a5, 0x00000000);
	nv_icmd(dev, 0x000009a6, 0x00000000);
	nv_icmd(dev, 0x000009a7, 0x00000000);
	nv_icmd(dev, 0x000009a8, 0x00000000);
	nv_icmd(dev, 0x000009a9, 0x00000000);
	nv_icmd(dev, 0x000009aa, 0x00000000);
	nv_icmd(dev, 0x000009ab, 0x00000000);
	nv_icmd(dev, 0x000009ac, 0x00000000);
	nv_icmd(dev, 0x000009ad, 0x00000000);
	nv_icmd(dev, 0x000009ae, 0x00000000);
	nv_icmd(dev, 0x000009af, 0x00000000);
	nv_icmd(dev, 0x000009b0, 0x00000000);
	nv_icmd(dev, 0x000009b1, 0x00000000);
	nv_icmd(dev, 0x000009b2, 0x00000000);
	nv_icmd(dev, 0x000009b3, 0x00000000);
	nv_icmd(dev, 0x000009b4, 0x00000000);
	nv_icmd(dev, 0x000009b5, 0x00000000);
	nv_icmd(dev, 0x000009b6, 0x00000000);
	nv_icmd(dev, 0x000009b7, 0x00000000);
	nv_icmd(dev, 0x000009b8, 0x00000000);
	nv_icmd(dev, 0x000009b9, 0x00000000);
	nv_icmd(dev, 0x000009ba, 0x00000000);
	nv_icmd(dev, 0x000009bb, 0x00000000);
	nv_icmd(dev, 0x000009bc, 0x00000000);
	nv_icmd(dev, 0x000009bd, 0x00000000);
	nv_icmd(dev, 0x000009be, 0x00000000);
	nv_icmd(dev, 0x000009bf, 0x00000000);
	nv_icmd(dev, 0x000009c0, 0x00000000);
	nv_icmd(dev, 0x000009c1, 0x00000000);
	nv_icmd(dev, 0x000009c2, 0x00000000);
	nv_icmd(dev, 0x000009c3, 0x00000000);
	nv_icmd(dev, 0x000009c4, 0x00000000);
	nv_icmd(dev, 0x000009c5, 0x00000000);
	nv_icmd(dev, 0x000009c6, 0x00000000);
	nv_icmd(dev, 0x000009c7, 0x00000000);
	nv_icmd(dev, 0x000009c8, 0x00000000);
	nv_icmd(dev, 0x000009c9, 0x00000000);
	nv_icmd(dev, 0x000009ca, 0x00000000);
	nv_icmd(dev, 0x000009cb, 0x00000000);
	nv_icmd(dev, 0x000009cc, 0x00000000);
	nv_icmd(dev, 0x000009cd, 0x00000000);
	nv_icmd(dev, 0x000009ce, 0x00000000);
	nv_icmd(dev, 0x000009cf, 0x00000000);
	nv_icmd(dev, 0x000009d0, 0x00000000);
	nv_icmd(dev, 0x000009d1, 0x00000000);
	nv_icmd(dev, 0x000009d2, 0x00000000);
	nv_icmd(dev, 0x000009d3, 0x00000000);
	nv_icmd(dev, 0x000009d4, 0x00000000);
	nv_icmd(dev, 0x000009d5, 0x00000000);
	nv_icmd(dev, 0x000009d6, 0x00000000);
	nv_icmd(dev, 0x000009d7, 0x00000000);
	nv_icmd(dev, 0x000009d8, 0x00000000);
	nv_icmd(dev, 0x000009d9, 0x00000000);
	nv_icmd(dev, 0x000009da, 0x00000000);
	nv_icmd(dev, 0x000009db, 0x00000000);
	nv_icmd(dev, 0x000009dc, 0x00000000);
	nv_icmd(dev, 0x000009dd, 0x00000000);
	nv_icmd(dev, 0x000009de, 0x00000000);
	nv_icmd(dev, 0x000009df, 0x00000000);
	nv_icmd(dev, 0x000009e0, 0x00000000);
	nv_icmd(dev, 0x000009e1, 0x00000000);
	nv_icmd(dev, 0x000009e2, 0x00000000);
	nv_icmd(dev, 0x000009e3, 0x00000000);
	nv_icmd(dev, 0x000009e4, 0x00000000);
	nv_icmd(dev, 0x000009e5, 0x00000000);
	nv_icmd(dev, 0x000009e6, 0x00000000);
	nv_icmd(dev, 0x000009e7, 0x00000000);
	nv_icmd(dev, 0x000009e8, 0x00000000);
	nv_icmd(dev, 0x000009e9, 0x00000000);
	nv_icmd(dev, 0x000009ea, 0x00000000);
	nv_icmd(dev, 0x000009eb, 0x00000000);
	nv_icmd(dev, 0x000009ec, 0x00000000);
	nv_icmd(dev, 0x000009ed, 0x00000000);
	nv_icmd(dev, 0x000009ee, 0x00000000);
	nv_icmd(dev, 0x000009ef, 0x00000000);
	nv_icmd(dev, 0x000009f0, 0x00000000);
	nv_icmd(dev, 0x000009f1, 0x00000000);
	nv_icmd(dev, 0x000009f2, 0x00000000);
	nv_icmd(dev, 0x000009f3, 0x00000000);
	nv_icmd(dev, 0x000009f4, 0x00000000);
	nv_icmd(dev, 0x000009f5, 0x00000000);
	nv_icmd(dev, 0x000009f6, 0x00000000);
	nv_icmd(dev, 0x000009f7, 0x00000000);
	nv_icmd(dev, 0x000009f8, 0x00000000);
	nv_icmd(dev, 0x000009f9, 0x00000000);
	nv_icmd(dev, 0x000009fa, 0x00000000);
	nv_icmd(dev, 0x000009fb, 0x00000000);
	nv_icmd(dev, 0x000009fc, 0x00000000);
	nv_icmd(dev, 0x000009fd, 0x00000000);
	nv_icmd(dev, 0x000009fe, 0x00000000);
	nv_icmd(dev, 0x000009ff, 0x00000000);
	nv_icmd(dev, 0x00000468, 0x00000004);
	nv_icmd(dev, 0x0000046c, 0x00000001);
	nv_icmd(dev, 0x00000470, 0x00000000);
	nv_icmd(dev, 0x00000471, 0x00000000);
	nv_icmd(dev, 0x00000472, 0x00000000);
	nv_icmd(dev, 0x00000473, 0x00000000);
	nv_icmd(dev, 0x00000474, 0x00000000);
	nv_icmd(dev, 0x00000475, 0x00000000);
	nv_icmd(dev, 0x00000476, 0x00000000);
	nv_icmd(dev, 0x00000477, 0x00000000);
	nv_icmd(dev, 0x00000478, 0x00000000);
	nv_icmd(dev, 0x00000479, 0x00000000);
	nv_icmd(dev, 0x0000047a, 0x00000000);
	nv_icmd(dev, 0x0000047b, 0x00000000);
	nv_icmd(dev, 0x0000047c, 0x00000000);
	nv_icmd(dev, 0x0000047d, 0x00000000);
	nv_icmd(dev, 0x0000047e, 0x00000000);
	nv_icmd(dev, 0x0000047f, 0x00000000);
	nv_icmd(dev, 0x00000480, 0x00000000);
	nv_icmd(dev, 0x00000481, 0x00000000);
	nv_icmd(dev, 0x00000482, 0x00000000);
	nv_icmd(dev, 0x00000483, 0x00000000);
	nv_icmd(dev, 0x00000484, 0x00000000);
	nv_icmd(dev, 0x00000485, 0x00000000);
	nv_icmd(dev, 0x00000486, 0x00000000);
	nv_icmd(dev, 0x00000487, 0x00000000);
	nv_icmd(dev, 0x00000488, 0x00000000);
	nv_icmd(dev, 0x00000489, 0x00000000);
	nv_icmd(dev, 0x0000048a, 0x00000000);
	nv_icmd(dev, 0x0000048b, 0x00000000);
	nv_icmd(dev, 0x0000048c, 0x00000000);
	nv_icmd(dev, 0x0000048d, 0x00000000);
	nv_icmd(dev, 0x0000048e, 0x00000000);
	nv_icmd(dev, 0x0000048f, 0x00000000);
	nv_icmd(dev, 0x00000490, 0x00000000);
	nv_icmd(dev, 0x00000491, 0x00000000);
	nv_icmd(dev, 0x00000492, 0x00000000);
	nv_icmd(dev, 0x00000493, 0x00000000);
	nv_icmd(dev, 0x00000494, 0x00000000);
	nv_icmd(dev, 0x00000495, 0x00000000);
	nv_icmd(dev, 0x00000496, 0x00000000);
	nv_icmd(dev, 0x00000497, 0x00000000);
	nv_icmd(dev, 0x00000498, 0x00000000);
	nv_icmd(dev, 0x00000499, 0x00000000);
	nv_icmd(dev, 0x0000049a, 0x00000000);
	nv_icmd(dev, 0x0000049b, 0x00000000);
	nv_icmd(dev, 0x0000049c, 0x00000000);
	nv_icmd(dev, 0x0000049d, 0x00000000);
	nv_icmd(dev, 0x0000049e, 0x00000000);
	nv_icmd(dev, 0x0000049f, 0x00000000);
	nv_icmd(dev, 0x000004a0, 0x00000000);
	nv_icmd(dev, 0x000004a1, 0x00000000);
	nv_icmd(dev, 0x000004a2, 0x00000000);
	nv_icmd(dev, 0x000004a3, 0x00000000);
	nv_icmd(dev, 0x000004a4, 0x00000000);
	nv_icmd(dev, 0x000004a5, 0x00000000);
	nv_icmd(dev, 0x000004a6, 0x00000000);
	nv_icmd(dev, 0x000004a7, 0x00000000);
	nv_icmd(dev, 0x000004a8, 0x00000000);
	nv_icmd(dev, 0x000004a9, 0x00000000);
	nv_icmd(dev, 0x000004aa, 0x00000000);
	nv_icmd(dev, 0x000004ab, 0x00000000);
	nv_icmd(dev, 0x000004ac, 0x00000000);
	nv_icmd(dev, 0x000004ad, 0x00000000);
	nv_icmd(dev, 0x000004ae, 0x00000000);
	nv_icmd(dev, 0x000004af, 0x00000000);
	nv_icmd(dev, 0x000004b0, 0x00000000);
	nv_icmd(dev, 0x000004b1, 0x00000000);
	nv_icmd(dev, 0x000004b2, 0x00000000);
	nv_icmd(dev, 0x000004b3, 0x00000000);
	nv_icmd(dev, 0x000004b4, 0x00000000);
	nv_icmd(dev, 0x000004b5, 0x00000000);
	nv_icmd(dev, 0x000004b6, 0x00000000);
	nv_icmd(dev, 0x000004b7, 0x00000000);
	nv_icmd(dev, 0x000004b8, 0x00000000);
	nv_icmd(dev, 0x000004b9, 0x00000000);
	nv_icmd(dev, 0x000004ba, 0x00000000);
	nv_icmd(dev, 0x000004bb, 0x00000000);
	nv_icmd(dev, 0x000004bc, 0x00000000);
	nv_icmd(dev, 0x000004bd, 0x00000000);
	nv_icmd(dev, 0x000004be, 0x00000000);
	nv_icmd(dev, 0x000004bf, 0x00000000);
	nv_icmd(dev, 0x000004c0, 0x00000000);
	nv_icmd(dev, 0x000004c1, 0x00000000);
	nv_icmd(dev, 0x000004c2, 0x00000000);
	nv_icmd(dev, 0x000004c3, 0x00000000);
	nv_icmd(dev, 0x000004c4, 0x00000000);
	nv_icmd(dev, 0x000004c5, 0x00000000);
	nv_icmd(dev, 0x000004c6, 0x00000000);
	nv_icmd(dev, 0x000004c7, 0x00000000);
	nv_icmd(dev, 0x000004c8, 0x00000000);
	nv_icmd(dev, 0x000004c9, 0x00000000);
	nv_icmd(dev, 0x000004ca, 0x00000000);
	nv_icmd(dev, 0x000004cb, 0x00000000);
	nv_icmd(dev, 0x000004cc, 0x00000000);
	nv_icmd(dev, 0x000004cd, 0x00000000);
	nv_icmd(dev, 0x000004ce, 0x00000000);
	nv_icmd(dev, 0x000004cf, 0x00000000);
	nv_icmd(dev, 0x00000510, 0x3f800000);
	nv_icmd(dev, 0x00000511, 0x3f800000);
	nv_icmd(dev, 0x00000512, 0x3f800000);
	nv_icmd(dev, 0x00000513, 0x3f800000);
	nv_icmd(dev, 0x00000514, 0x3f800000);
	nv_icmd(dev, 0x00000515, 0x3f800000);
	nv_icmd(dev, 0x00000516, 0x3f800000);
	nv_icmd(dev, 0x00000517, 0x3f800000);
	nv_icmd(dev, 0x00000518, 0x3f800000);
	nv_icmd(dev, 0x00000519, 0x3f800000);
	nv_icmd(dev, 0x0000051a, 0x3f800000);
	nv_icmd(dev, 0x0000051b, 0x3f800000);
	nv_icmd(dev, 0x0000051c, 0x3f800000);
	nv_icmd(dev, 0x0000051d, 0x3f800000);
	nv_icmd(dev, 0x0000051e, 0x3f800000);
	nv_icmd(dev, 0x0000051f, 0x3f800000);
	nv_icmd(dev, 0x00000520, 0x000002b6);
	nv_icmd(dev, 0x00000529, 0x00000001);
	nv_icmd(dev, 0x00000530, 0xffff0000);
	nv_icmd(dev, 0x00000531, 0xffff0000);
	nv_icmd(dev, 0x00000532, 0xffff0000);
	nv_icmd(dev, 0x00000533, 0xffff0000);
	nv_icmd(dev, 0x00000534, 0xffff0000);
	nv_icmd(dev, 0x00000535, 0xffff0000);
	nv_icmd(dev, 0x00000536, 0xffff0000);
	nv_icmd(dev, 0x00000537, 0xffff0000);
	nv_icmd(dev, 0x00000538, 0xffff0000);
	nv_icmd(dev, 0x00000539, 0xffff0000);
	nv_icmd(dev, 0x0000053a, 0xffff0000);
	nv_icmd(dev, 0x0000053b, 0xffff0000);
	nv_icmd(dev, 0x0000053c, 0xffff0000);
	nv_icmd(dev, 0x0000053d, 0xffff0000);
	nv_icmd(dev, 0x0000053e, 0xffff0000);
	nv_icmd(dev, 0x0000053f, 0xffff0000);
	nv_icmd(dev, 0x00000585, 0x0000003f);
	nv_icmd(dev, 0x00000576, 0x00000003);
	if (dev_priv->chipset == 0xc1)
		nv_icmd(dev, 0x0000057b, 0x00000059);
	nv_icmd(dev, 0x00000586, 0x00000040);
	nv_icmd(dev, 0x00000582, 0x00000080);
	nv_icmd(dev, 0x00000583, 0x00000080);
	nv_icmd(dev, 0x000005c2, 0x00000001);
	nv_icmd(dev, 0x00000638, 0x00000001);
	nv_icmd(dev, 0x00000639, 0x00000001);
	nv_icmd(dev, 0x0000063a, 0x00000002);
	nv_icmd(dev, 0x0000063b, 0x00000001);
	nv_icmd(dev, 0x0000063c, 0x00000001);
	nv_icmd(dev, 0x0000063d, 0x00000002);
	nv_icmd(dev, 0x0000063e, 0x00000001);
	nv_icmd(dev, 0x000008b8, 0x00000001);
	nv_icmd(dev, 0x000008b9, 0x00000001);
	nv_icmd(dev, 0x000008ba, 0x00000001);
	nv_icmd(dev, 0x000008bb, 0x00000001);
	nv_icmd(dev, 0x000008bc, 0x00000001);
	nv_icmd(dev, 0x000008bd, 0x00000001);
	nv_icmd(dev, 0x000008be, 0x00000001);
	nv_icmd(dev, 0x000008bf, 0x00000001);
	nv_icmd(dev, 0x00000900, 0x00000001);
	nv_icmd(dev, 0x00000901, 0x00000001);
	nv_icmd(dev, 0x00000902, 0x00000001);
	nv_icmd(dev, 0x00000903, 0x00000001);
	nv_icmd(dev, 0x00000904, 0x00000001);
	nv_icmd(dev, 0x00000905, 0x00000001);
	nv_icmd(dev, 0x00000906, 0x00000001);
	nv_icmd(dev, 0x00000907, 0x00000001);
	nv_icmd(dev, 0x00000908, 0x00000002);
	nv_icmd(dev, 0x00000909, 0x00000002);
	nv_icmd(dev, 0x0000090a, 0x00000002);
	nv_icmd(dev, 0x0000090b, 0x00000002);
	nv_icmd(dev, 0x0000090c, 0x00000002);
	nv_icmd(dev, 0x0000090d, 0x00000002);
	nv_icmd(dev, 0x0000090e, 0x00000002);
	nv_icmd(dev, 0x0000090f, 0x00000002);
	nv_icmd(dev, 0x00000910, 0x00000001);
	nv_icmd(dev, 0x00000911, 0x00000001);
	nv_icmd(dev, 0x00000912, 0x00000001);
	nv_icmd(dev, 0x00000913, 0x00000001);
	nv_icmd(dev, 0x00000914, 0x00000001);
	nv_icmd(dev, 0x00000915, 0x00000001);
	nv_icmd(dev, 0x00000916, 0x00000001);
	nv_icmd(dev, 0x00000917, 0x00000001);
	nv_icmd(dev, 0x00000918, 0x00000001);
	nv_icmd(dev, 0x00000919, 0x00000001);
	nv_icmd(dev, 0x0000091a, 0x00000001);
	nv_icmd(dev, 0x0000091b, 0x00000001);
	nv_icmd(dev, 0x0000091c, 0x00000001);
	nv_icmd(dev, 0x0000091d, 0x00000001);
	nv_icmd(dev, 0x0000091e, 0x00000001);
	nv_icmd(dev, 0x0000091f, 0x00000001);
	nv_icmd(dev, 0x00000920, 0x00000002);
	nv_icmd(dev, 0x00000921, 0x00000002);
	nv_icmd(dev, 0x00000922, 0x00000002);
	nv_icmd(dev, 0x00000923, 0x00000002);
	nv_icmd(dev, 0x00000924, 0x00000002);
	nv_icmd(dev, 0x00000925, 0x00000002);
	nv_icmd(dev, 0x00000926, 0x00000002);
	nv_icmd(dev, 0x00000927, 0x00000002);
	nv_icmd(dev, 0x00000928, 0x00000001);
	nv_icmd(dev, 0x00000929, 0x00000001);
	nv_icmd(dev, 0x0000092a, 0x00000001);
	nv_icmd(dev, 0x0000092b, 0x00000001);
	nv_icmd(dev, 0x0000092c, 0x00000001);
	nv_icmd(dev, 0x0000092d, 0x00000001);
	nv_icmd(dev, 0x0000092e, 0x00000001);
	nv_icmd(dev, 0x0000092f, 0x00000001);
	nv_icmd(dev, 0x00000648, 0x00000001);
	nv_icmd(dev, 0x00000649, 0x00000001);
	nv_icmd(dev, 0x0000064a, 0x00000001);
	nv_icmd(dev, 0x0000064b, 0x00000001);
	nv_icmd(dev, 0x0000064c, 0x00000001);
	nv_icmd(dev, 0x0000064d, 0x00000001);
	nv_icmd(dev, 0x0000064e, 0x00000001);
	nv_icmd(dev, 0x0000064f, 0x00000001);
	nv_icmd(dev, 0x00000650, 0x00000001);
	nv_icmd(dev, 0x00000658, 0x0000000f);
	nv_icmd(dev, 0x000007ff, 0x0000000a);
	nv_icmd(dev, 0x0000066a, 0x40000000);
	nv_icmd(dev, 0x0000066b, 0x10000000);
	nv_icmd(dev, 0x0000066c, 0xffff0000);
	nv_icmd(dev, 0x0000066d, 0xffff0000);
	nv_icmd(dev, 0x000007af, 0x00000008);
	nv_icmd(dev, 0x000007b0, 0x00000008);
	nv_icmd(dev, 0x000007f6, 0x00000001);
	nv_icmd(dev, 0x000006b2, 0x00000055);
	nv_icmd(dev, 0x000007ad, 0x00000003);
	nv_icmd(dev, 0x00000937, 0x00000001);
	nv_icmd(dev, 0x00000971, 0x00000008);
	nv_icmd(dev, 0x00000972, 0x00000040);
	nv_icmd(dev, 0x00000973, 0x0000012c);
	nv_icmd(dev, 0x0000097c, 0x00000040);
	nv_icmd(dev, 0x00000979, 0x00000003);
	nv_icmd(dev, 0x00000975, 0x00000020);
	nv_icmd(dev, 0x00000976, 0x00000001);
	nv_icmd(dev, 0x00000977, 0x00000020);
	nv_icmd(dev, 0x00000978, 0x00000001);
	nv_icmd(dev, 0x00000957, 0x00000003);
	nv_icmd(dev, 0x0000095e, 0x20164010);
	nv_icmd(dev, 0x0000095f, 0x00000020);
	nv_icmd(dev, 0x00000683, 0x00000006);
	nv_icmd(dev, 0x00000685, 0x003fffff);
	nv_icmd(dev, 0x00000687, 0x00000c48);
	nv_icmd(dev, 0x000006a0, 0x00000005);
	nv_icmd(dev, 0x00000840, 0x00300008);
	nv_icmd(dev, 0x00000841, 0x04000080);
	nv_icmd(dev, 0x00000842, 0x00300008);
	nv_icmd(dev, 0x00000843, 0x04000080);
	nv_icmd(dev, 0x00000818, 0x00000000);
	nv_icmd(dev, 0x00000819, 0x00000000);
	nv_icmd(dev, 0x0000081a, 0x00000000);
	nv_icmd(dev, 0x0000081b, 0x00000000);
	nv_icmd(dev, 0x0000081c, 0x00000000);
	nv_icmd(dev, 0x0000081d, 0x00000000);
	nv_icmd(dev, 0x0000081e, 0x00000000);
	nv_icmd(dev, 0x0000081f, 0x00000000);
	nv_icmd(dev, 0x00000848, 0x00000000);
	nv_icmd(dev, 0x00000849, 0x00000000);
	nv_icmd(dev, 0x0000084a, 0x00000000);
	nv_icmd(dev, 0x0000084b, 0x00000000);
	nv_icmd(dev, 0x0000084c, 0x00000000);
	nv_icmd(dev, 0x0000084d, 0x00000000);
	nv_icmd(dev, 0x0000084e, 0x00000000);
	nv_icmd(dev, 0x0000084f, 0x00000000);
	nv_icmd(dev, 0x00000850, 0x00000000);
	nv_icmd(dev, 0x00000851, 0x00000000);
	nv_icmd(dev, 0x00000852, 0x00000000);
	nv_icmd(dev, 0x00000853, 0x00000000);
	nv_icmd(dev, 0x00000854, 0x00000000);
	nv_icmd(dev, 0x00000855, 0x00000000);
	nv_icmd(dev, 0x00000856, 0x00000000);
	nv_icmd(dev, 0x00000857, 0x00000000);
	nv_icmd(dev, 0x00000738, 0x00000000);
	nv_icmd(dev, 0x000006aa, 0x00000001);
	nv_icmd(dev, 0x000006ab, 0x00000002);
	nv_icmd(dev, 0x000006ac, 0x00000080);
	nv_icmd(dev, 0x000006ad, 0x00000100);
	nv_icmd(dev, 0x000006ae, 0x00000100);
	nv_icmd(dev, 0x000006b1, 0x00000011);
	nv_icmd(dev, 0x000006bb, 0x000000cf);
	nv_icmd(dev, 0x000006ce, 0x2a712488);
	nv_icmd(dev, 0x00000739, 0x4085c000);
	nv_icmd(dev, 0x0000073a, 0x00000080);
	nv_icmd(dev, 0x00000786, 0x80000100);
	nv_icmd(dev, 0x0000073c, 0x00010100);
	nv_icmd(dev, 0x0000073d, 0x02800000);
	nv_icmd(dev, 0x00000787, 0x000000cf);
	nv_icmd(dev, 0x0000078c, 0x00000008);
	nv_icmd(dev, 0x00000792, 0x00000001);
	nv_icmd(dev, 0x00000794, 0x00000001);
	nv_icmd(dev, 0x00000795, 0x00000001);
	nv_icmd(dev, 0x00000796, 0x00000001);
	nv_icmd(dev, 0x00000797, 0x000000cf);
	nv_icmd(dev, 0x00000836, 0x00000001);
	nv_icmd(dev, 0x0000079a, 0x00000002);
	nv_icmd(dev, 0x00000833, 0x04444480);
	nv_icmd(dev, 0x000007a1, 0x00000001);
	nv_icmd(dev, 0x000007a3, 0x00000001);
	nv_icmd(dev, 0x000007a4, 0x00000001);
	nv_icmd(dev, 0x000007a5, 0x00000001);
	nv_icmd(dev, 0x00000831, 0x00000004);
	nv_icmd(dev, 0x0000080c, 0x00000002);
	nv_icmd(dev, 0x0000080d, 0x00000100);
	nv_icmd(dev, 0x0000080e, 0x00000100);
	nv_icmd(dev, 0x0000080f, 0x00000001);
	nv_icmd(dev, 0x00000823, 0x00000002);
	nv_icmd(dev, 0x00000824, 0x00000100);
	nv_icmd(dev, 0x00000825, 0x00000100);
	nv_icmd(dev, 0x00000826, 0x00000001);
	nv_icmd(dev, 0x0000095d, 0x00000001);
	nv_icmd(dev, 0x0000082b, 0x00000004);
	nv_icmd(dev, 0x00000942, 0x00010001);
	nv_icmd(dev, 0x00000943, 0x00000001);
	nv_icmd(dev, 0x00000944, 0x00000022);
	nv_icmd(dev, 0x000007c5, 0x00010001);
	nv_icmd(dev, 0x00000834, 0x00000001);
	nv_icmd(dev, 0x000007c7, 0x00000001);
	nv_icmd(dev, 0x0000c1b0, 0x0000000f);
	nv_icmd(dev, 0x0000c1b1, 0x0000000f);
	nv_icmd(dev, 0x0000c1b2, 0x0000000f);
	nv_icmd(dev, 0x0000c1b3, 0x0000000f);
	nv_icmd(dev, 0x0000c1b4, 0x0000000f);
	nv_icmd(dev, 0x0000c1b5, 0x0000000f);
	nv_icmd(dev, 0x0000c1b6, 0x0000000f);
	nv_icmd(dev, 0x0000c1b7, 0x0000000f);
	nv_icmd(dev, 0x0000c1b8, 0x0fac6881);
	nv_icmd(dev, 0x0000c1b9, 0x00fac688);
	nv_icmd(dev, 0x0001e100, 0x00000001);
	nv_icmd(dev, 0x00001000, 0x00000002);
	nv_icmd(dev, 0x000006aa, 0x00000001);
	nv_icmd(dev, 0x000006ad, 0x00000100);
	nv_icmd(dev, 0x000006ae, 0x00000100);
	nv_icmd(dev, 0x000006b1, 0x00000011);
	nv_icmd(dev, 0x0000078c, 0x00000008);
	nv_icmd(dev, 0x00000792, 0x00000001);
	nv_icmd(dev, 0x00000794, 0x00000001);
	nv_icmd(dev, 0x00000795, 0x00000001);
	nv_icmd(dev, 0x00000796, 0x00000001);
	nv_icmd(dev, 0x00000797, 0x000000cf);
	nv_icmd(dev, 0x0000079a, 0x00000002);
	nv_icmd(dev, 0x00000833, 0x04444480);
	nv_icmd(dev, 0x000007a1, 0x00000001);
	nv_icmd(dev, 0x000007a3, 0x00000001);
	nv_icmd(dev, 0x000007a4, 0x00000001);
	nv_icmd(dev, 0x000007a5, 0x00000001);
	nv_icmd(dev, 0x00000831, 0x00000004);
	nv_icmd(dev, 0x0001e100, 0x00000001);
	nv_icmd(dev, 0x00001000, 0x00000014);
	nv_icmd(dev, 0x00000351, 0x00000100);
	nv_icmd(dev, 0x00000957, 0x00000003);
	nv_icmd(dev, 0x0000095d, 0x00000001);
	nv_icmd(dev, 0x0000082b, 0x00000004);
	nv_icmd(dev, 0x00000942, 0x00010001);
	nv_icmd(dev, 0x00000943, 0x00000001);
	nv_icmd(dev, 0x000007c5, 0x00010001);
	nv_icmd(dev, 0x00000834, 0x00000001);
	nv_icmd(dev, 0x000007c7, 0x00000001);
	nv_icmd(dev, 0x0001e100, 0x00000001);
	nv_icmd(dev, 0x00001000, 0x00000001);
	nv_icmd(dev, 0x0000080c, 0x00000002);
	nv_icmd(dev, 0x0000080d, 0x00000100);
	nv_icmd(dev, 0x0000080e, 0x00000100);
	nv_icmd(dev, 0x0000080f, 0x00000001);
	nv_icmd(dev, 0x00000823, 0x00000002);
	nv_icmd(dev, 0x00000824, 0x00000100);
	nv_icmd(dev, 0x00000825, 0x00000100);
	nv_icmd(dev, 0x00000826, 0x00000001);
	nv_icmd(dev, 0x0001e100, 0x00000001);
	nv_wr32(dev, 0x400208, 0x00000000);
	nv_wr32(dev, 0x404154, 0x00000400);

	nvc0_grctx_generate_9097(dev);
	if (fermi >= 0x9197)
		nvc0_grctx_generate_9197(dev);
	if (fermi >= 0x9297)
		nvc0_grctx_generate_9297(dev);
	nvc0_grctx_generate_902d(dev);
	nvc0_grctx_generate_9039(dev);
	nvc0_grctx_generate_90c0(dev);

	nv_wr32(dev, 0x000260, r000260);
	return 0;
}
