/*
 * Platform dependent support for HP simulator.
 *
 * Copyright (C) 1998, 1999 Hewlett-Packard Co
 * Copyright (C) 1998, 1999 David Mosberger-Tang <davidm@hpl.hp.com>
 * Copyright (C) 1999 Vijay Chander <vijay@engr.sgi.com>
 */
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/param.h>
#include <linux/string.h>
#include <linux/types.h>
#include <linux/kdev_t.h>
#include <linux/console.h>

#include <asm/delay.h>
#include <asm/irq.h>
#include <asm/pal.h>
#include <asm/machvec.h>
#include <asm/pgtable.h>
#include <asm/sal.h>

#include "hpsim_ssc.h"

static int simcons_init (struct console *, char *);
static void simcons_write (struct console *, const char *, unsigned);
static int simcons_wait_key (struct console *);
static kdev_t simcons_console_device (struct console *);

struct console hpsim_cons = {
	"simcons",
	simcons_write,		/* write */
	NULL,			/* read */
	simcons_console_device,	/* device */
	simcons_wait_key,	/* wait_key */
	NULL,			/* unblank */
	simcons_init,		/* setup */
	CON_PRINTBUFFER,	/* flags */
	-1,			/* index */
	0,			/* cflag */
	NULL			/* next */
};

static int
simcons_init (struct console *cons, char *options)
{
	return 0;
}

static void
simcons_write (struct console *cons, const char *buf, unsigned count)
{
	unsigned long ch;

	while (count-- > 0) {
		ch = *buf++;
		ia64_ssc(ch, 0, 0, 0, SSC_PUTCHAR);
		if (ch == '\n')
		  ia64_ssc('\r', 0, 0, 0, SSC_PUTCHAR);
	}
}

static int
simcons_wait_key (struct console *cons)
{
	char ch;

	do {
		ch = ia64_ssc(0, 0, 0, 0, SSC_GETCHAR);
	} while (ch == '\0');
	return ch;
}

static kdev_t
simcons_console_device (struct console *c)
{
	return MKDEV(TTY_MAJOR, 64 + c->index);
}
